/*  -*- Mode: Asm -*-  */
/*
    frexp.S is part of     FPlib V 0.3.0       ported to avr-as
    for copyright and details see readme.fplib

 *----------------------------------------------------------------------------------------
 *
 *	A = mantissa(A)  *integ = exponent(A)
 * e.g.
 * int integ
 * double fract = frexp( 3.45, &integ ) = frexp ( 2^2 * 0.8625 )
 * -> fract = 0.8625; *integ = 2
 *
 * fract(0) -> 0/0
 */

#include "gasava.inc"
#include "fplib.inc"

          TEXT_SEG(fplib, frexp)
          FUNCTION(frexp)

GLOBAL(frexp)
        MOV     ZH,rPH
        MOV     ZL,rPL
        BST     rA3,7

        RCALL   _U(__fp_split1)	;
        TST     rA3
        BREQ    _frexp_200
        SUBI    rA3,0x7E	; 0.5 -> 0.5 * 2^0
				; 1.0 -> 0.5 * 2^1
        SBC     rB0,rB0		; sign expand rA3
        ST      Z,rA3
        STD     Z+1,rB0

        ANDI    rA2,0x7F	; mantissa is normalized
        LDI     rA3,0x3F	; exponent for 0.5
        BLD     rA3,7
        RET

 _frexp_200:
        ST      Z,rA3
        STD     Z+1,rT1c
        RJMP    _U(__fp_zero)	; frexp(0) returns 0 not A = 0x00800000 of fp_split1

          ENDFUNC


