#ifndef __HEXIUM_ORION__
#define __HEXIUM_ORION__

#include "hexium.h"

static struct saa7146_extension_ioctls ioctls[] = {
	{ VIDIOC_G_INPUT,	SAA7146_EXCLUSIVE },
	{ VIDIOC_S_INPUT,	SAA7146_EXCLUSIVE },
	{ VIDIOC_ENUMINPUT, 	SAA7146_EXCLUSIVE },
	{ VIDIOC_S_STD,		SAA7146_AFTER },
	{ 0,			0 }
};

struct hexium
{
	int type;
	struct video_device	video_dev;
	struct i2c_adapter	i2c_adapter;	
	int cur_input;	/* current input */
};

/* Philips SAA7110 decoder default registers */
static u8 hexium_saa7110[53]={
/*00*/ 0x4C,0x3C,0x0D,0xEF,0xBD,0xF0,0x00,0x00,
/*08*/ 0xF8,0xF8,0x60,0x60,0x40,0x86,0x18,0x90,
/*10*/ 0x00,0x2C,0x40,0x46,0x42,0x1A,0xFF,0xDA,
/*18*/ 0xF0,0x8B,0x00,0x00,0x00,0x00,0x00,0x00,
/*20*/ 0xD9,0x17,0x40,0x41,0x80,0x41,0x80,0x4F,
/*28*/ 0xFE,0x01,0x0F,0x0F,0x03,0x01,0x81,0x03,
/*30*/ 0x44,0x75,0x01,0x8C,0x03
};

static struct {
	struct hexium_data data[8];	
} hexium_input_select[] = {
{
	{ /* input 0 */
		{ 0x06, 0x00 },
		{ 0x20, 0xD9 },
		{ 0x21, 0x17 }, // 0x16,
		{ 0x22, 0x40 },
		{ 0x2C, 0x03 },
		{ 0x30, 0x44 },
		{ 0x31, 0x75 }, // ??
		{ 0x21, 0x16 }, // 0x03,
	}
}, {
	{ /* input 1 */
		{ 0x06, 0x00 },
		{ 0x20, 0xD8 },
		{ 0x21, 0x17 }, // 0x16,
		{ 0x22, 0x40 },
		{ 0x2C, 0x03 },
		{ 0x30, 0x44 },
		{ 0x31, 0x75 }, // ??
		{ 0x21, 0x16 }, // 0x03,
	}
}, {
	{ /* input 2 */
		{ 0x06, 0x00 },
		{ 0x20, 0xBA },
		{ 0x21, 0x07 }, // 0x05,
		{ 0x22, 0x91 },
		{ 0x2C, 0x03 },
		{ 0x30, 0x60 },
		{ 0x31, 0xB5 }, // ??
		{ 0x21, 0x05 }, // 0x03,
	}
}, {
	{ /* input 3 */
		{ 0x06, 0x00 },
		{ 0x20, 0xB8 },
		{ 0x21, 0x07 }, // 0x05,
		{ 0x22, 0x91 },
		{ 0x2C, 0x03 },
		{ 0x30, 0x60 },
		{ 0x31, 0xB5 }, // ??
		{ 0x21, 0x05 }, // 0x03,
	}
}, {
	{ /* input 4 */
		{ 0x06, 0x00 },
		{ 0x20, 0x7C },
		{ 0x21, 0x07 }, // 0x03
		{ 0x22, 0xD2 },
		{ 0x2C, 0x83 },
		{ 0x30, 0x60 },
		{ 0x31, 0xB5 }, // ??
		{ 0x21, 0x03 },
	} 
}, {
	{ /* input 5 */
		{ 0x06, 0x00 },
		{ 0x20, 0x78 },
		{ 0x21, 0x07 }, // 0x03,
		{ 0x22, 0xD2 },
		{ 0x2C, 0x83 },
		{ 0x30, 0x60 },
		{ 0x31, 0xB5 }, // ?
		{ 0x21, 0x03 },
	}
}, {
	{ /* input 6 */
		{ 0x06, 0x80 },
		{ 0x20, 0x59 },
		{ 0x21, 0x17 },
		{ 0x22, 0x42 },
		{ 0x2C, 0xA3 },
		{ 0x30, 0x44 },
		{ 0x31, 0x75 },
		{ 0x21, 0x12 },
	}
}, {
	{ /* input 7 */
		{ 0x06, 0x80 },
		{ 0x20, 0x9A },
		{ 0x21, 0x17 },
		{ 0x22, 0xB1 },
		{ 0x2C, 0x13 },
		{ 0x30, 0x60 },
		{ 0x31, 0xB5 },
		{ 0x21, 0x14 },
	}
}, {
	{ /* input 8 */
		{ 0x06, 0x80 },
		{ 0x20, 0x3C },
		{ 0x21, 0x27 },
		{ 0x22, 0xC1 },
		{ 0x2C, 0x23 },
		{ 0x30, 0x44 },
		{ 0x31, 0x75 },
		{ 0x21, 0x21 },
	}
}	
};

#endif
