/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.builders;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.ovirt.engine.sdk4.builders.PropertyBuilder;
import org.ovirt.engine.sdk4.internal.containers.ExternalProviderContainer;
import org.ovirt.engine.sdk4.types.ExternalProvider;
import org.ovirt.engine.sdk4.types.Property;

public class ExternalProviderBuilder {
    private String authenticationUrl;
    private String comment;
    private String description;
    private String href;
    private String id;
    private String name;
    private String password;
    private List<Property> properties;
    private Boolean requiresAuthentication;
    private String url;
    private String username;

    public ExternalProviderBuilder authenticationUrl(String newAuthenticationUrl) {
        this.authenticationUrl = newAuthenticationUrl;
        return this;
    }

    public ExternalProviderBuilder comment(String newComment) {
        this.comment = newComment;
        return this;
    }

    public ExternalProviderBuilder description(String newDescription) {
        this.description = newDescription;
        return this;
    }

    public ExternalProviderBuilder href(String newHref) {
        this.href = newHref;
        return this;
    }

    public ExternalProviderBuilder id(String newId) {
        this.id = newId;
        return this;
    }

    public ExternalProviderBuilder name(String newName) {
        this.name = newName;
        return this;
    }

    public ExternalProviderBuilder password(String newPassword) {
        this.password = newPassword;
        return this;
    }

    public ExternalProviderBuilder properties(List<Property> newProperties) {
        if (newProperties != null) {
            if (this.properties == null) {
                this.properties = new ArrayList<Property>(newProperties);
            } else {
                this.properties.addAll(newProperties);
            }
        }
        return this;
    }

    public ExternalProviderBuilder properties(Property ... newProperties) {
        if (newProperties != null) {
            if (this.properties == null) {
                this.properties = new ArrayList<Property>(newProperties.length);
            }
            Collections.addAll(this.properties, newProperties);
        }
        return this;
    }

    public ExternalProviderBuilder properties(PropertyBuilder ... newProperties) {
        if (newProperties != null) {
            if (this.properties == null) {
                this.properties = new ArrayList<Property>(newProperties.length);
            }
            for (PropertyBuilder builder : newProperties) {
                this.properties.add(builder.build());
            }
        }
        return this;
    }

    public ExternalProviderBuilder requiresAuthentication(boolean newRequiresAuthentication) {
        this.requiresAuthentication = newRequiresAuthentication;
        return this;
    }

    public ExternalProviderBuilder requiresAuthentication(Boolean newRequiresAuthentication) {
        this.requiresAuthentication = newRequiresAuthentication;
        return this;
    }

    public ExternalProviderBuilder url(String newUrl) {
        this.url = newUrl;
        return this;
    }

    public ExternalProviderBuilder username(String newUsername) {
        this.username = newUsername;
        return this;
    }

    public ExternalProvider build() {
        ExternalProviderContainer container = new ExternalProviderContainer();
        container.authenticationUrl(this.authenticationUrl);
        container.comment(this.comment);
        container.description(this.description);
        container.href(this.href);
        container.id(this.id);
        container.name(this.name);
        container.password(this.password);
        container.properties(this.properties);
        container.requiresAuthentication(this.requiresAuthentication);
        container.url(this.url);
        container.username(this.username);
        return container;
    }
}

