/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.builders;

import java.math.BigInteger;
import org.ovirt.engine.sdk4.internal.containers.HighAvailabilityContainer;
import org.ovirt.engine.sdk4.types.HighAvailability;

public class HighAvailabilityBuilder {
    private Boolean enabled;
    private BigInteger priority;

    public HighAvailabilityBuilder enabled(boolean newEnabled) {
        this.enabled = newEnabled;
        return this;
    }

    public HighAvailabilityBuilder enabled(Boolean newEnabled) {
        this.enabled = newEnabled;
        return this;
    }

    public HighAvailabilityBuilder priority(int newPriority) {
        this.priority = BigInteger.valueOf(newPriority);
        return this;
    }

    public HighAvailabilityBuilder priority(Integer newPriority) {
        this.priority = newPriority == null ? null : BigInteger.valueOf(newPriority.longValue());
        return this;
    }

    public HighAvailabilityBuilder priority(long newPriority) {
        this.priority = BigInteger.valueOf(newPriority);
        return this;
    }

    public HighAvailabilityBuilder priority(Long newPriority) {
        this.priority = newPriority == null ? null : BigInteger.valueOf(newPriority);
        return this;
    }

    public HighAvailabilityBuilder priority(BigInteger newPriority) {
        this.priority = newPriority;
        return this;
    }

    public HighAvailability build() {
        HighAvailabilityContainer container = new HighAvailabilityContainer();
        container.enabled(this.enabled);
        container.priority(this.priority);
        return container;
    }
}

