/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.builders;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.ovirt.engine.sdk4.builders.QuotaBuilder;
import org.ovirt.engine.sdk4.builders.StorageDomainBuilder;
import org.ovirt.engine.sdk4.internal.containers.QuotaStorageLimitContainer;
import org.ovirt.engine.sdk4.types.Quota;
import org.ovirt.engine.sdk4.types.QuotaStorageLimit;
import org.ovirt.engine.sdk4.types.StorageDomain;

public class QuotaStorageLimitBuilder {
    private String comment;
    private String description;
    private String href;
    private String id;
    private BigInteger limit;
    private String name;
    private Quota quota;
    private StorageDomain storageDomain;
    private BigDecimal usage;

    public QuotaStorageLimitBuilder comment(String newComment) {
        this.comment = newComment;
        return this;
    }

    public QuotaStorageLimitBuilder description(String newDescription) {
        this.description = newDescription;
        return this;
    }

    public QuotaStorageLimitBuilder href(String newHref) {
        this.href = newHref;
        return this;
    }

    public QuotaStorageLimitBuilder id(String newId) {
        this.id = newId;
        return this;
    }

    public QuotaStorageLimitBuilder limit(int newLimit) {
        this.limit = BigInteger.valueOf(newLimit);
        return this;
    }

    public QuotaStorageLimitBuilder limit(Integer newLimit) {
        this.limit = newLimit == null ? null : BigInteger.valueOf(newLimit.longValue());
        return this;
    }

    public QuotaStorageLimitBuilder limit(long newLimit) {
        this.limit = BigInteger.valueOf(newLimit);
        return this;
    }

    public QuotaStorageLimitBuilder limit(Long newLimit) {
        this.limit = newLimit == null ? null : BigInteger.valueOf(newLimit);
        return this;
    }

    public QuotaStorageLimitBuilder limit(BigInteger newLimit) {
        this.limit = newLimit;
        return this;
    }

    public QuotaStorageLimitBuilder name(String newName) {
        this.name = newName;
        return this;
    }

    public QuotaStorageLimitBuilder quota(Quota newQuota) {
        this.quota = newQuota;
        return this;
    }

    public QuotaStorageLimitBuilder quota(QuotaBuilder newQuota) {
        this.quota = newQuota == null ? null : newQuota.build();
        return this;
    }

    public QuotaStorageLimitBuilder storageDomain(StorageDomain newStorageDomain) {
        this.storageDomain = newStorageDomain;
        return this;
    }

    public QuotaStorageLimitBuilder storageDomain(StorageDomainBuilder newStorageDomain) {
        this.storageDomain = newStorageDomain == null ? null : newStorageDomain.build();
        return this;
    }

    public QuotaStorageLimitBuilder usage(float newUsage) {
        this.usage = BigDecimal.valueOf(newUsage);
        return this;
    }

    public QuotaStorageLimitBuilder usage(Float newUsage) {
        this.usage = newUsage == null ? null : BigDecimal.valueOf(newUsage.doubleValue());
        return this;
    }

    public QuotaStorageLimitBuilder usage(double newUsage) {
        this.usage = BigDecimal.valueOf(newUsage);
        return this;
    }

    public QuotaStorageLimitBuilder usage(Double newUsage) {
        this.usage = newUsage == null ? null : BigDecimal.valueOf(newUsage);
        return this;
    }

    public QuotaStorageLimitBuilder usage(BigDecimal newUsage) {
        this.usage = newUsage;
        return this;
    }

    public QuotaStorageLimit build() {
        QuotaStorageLimitContainer container = new QuotaStorageLimitContainer();
        container.comment(this.comment);
        container.description(this.description);
        container.href(this.href);
        container.id(this.id);
        container.limit(this.limit);
        container.name(this.name);
        container.quota(this.quota);
        container.storageDomain(this.storageDomain);
        container.usage(this.usage);
        return container;
    }
}

