/*
Copyright (c) 2015 Red Hat, Inc.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.ovirt.engine.sdk4.services;

import java.io.IOException;
import java.util.List;
import org.ovirt.engine.sdk4.Request;
import org.ovirt.engine.sdk4.Response;
import org.ovirt.engine.sdk4.Service;
import org.ovirt.engine.sdk4.builders.ClusterBuilder;
import org.ovirt.engine.sdk4.builders.DiskBuilder;
import org.ovirt.engine.sdk4.builders.HostBuilder;
import org.ovirt.engine.sdk4.builders.SnapshotBuilder;
import org.ovirt.engine.sdk4.builders.StorageDomainBuilder;
import org.ovirt.engine.sdk4.builders.TicketBuilder;
import org.ovirt.engine.sdk4.builders.VmBuilder;
import org.ovirt.engine.sdk4.types.Cluster;
import org.ovirt.engine.sdk4.types.Disk;
import org.ovirt.engine.sdk4.types.Host;
import org.ovirt.engine.sdk4.types.Snapshot;
import org.ovirt.engine.sdk4.types.StorageDomain;
import org.ovirt.engine.sdk4.types.Ticket;
import org.ovirt.engine.sdk4.types.Vm;

public interface VmService extends Service {
    public interface CancelMigrationRequest extends Request<CancelMigrationRequest, CancelMigrationResponse> {
        /**
         * Indicates if the migration should cancelled asynchronously.
         */
        CancelMigrationRequest async(Boolean async);
    }
    
    public interface CancelMigrationResponse extends Response {
    }
    
    CancelMigrationRequest cancelMigration();
    
    public interface CloneRequest extends Request<CloneRequest, CloneResponse> {
        /**
         * Indicates if the clone should be performed asynchronously.
         */
        CloneRequest async(Boolean async);
        CloneRequest vm(Vm vm);
        CloneRequest vm(VmBuilder vm);
    }
    
    public interface CloneResponse extends Response {
    }
    
    CloneRequest clone_();
    
    public interface CommitSnapshotRequest extends Request<CommitSnapshotRequest, CommitSnapshotResponse> {
        /**
         * Indicates if the snapshots should be committed asynchronously.
         */
        CommitSnapshotRequest async(Boolean async);
    }
    
    public interface CommitSnapshotResponse extends Response {
    }
    
    CommitSnapshotRequest commitSnapshot();
    
    public interface DetachRequest extends Request<DetachRequest, DetachResponse> {
        /**
         * Indicates if the detach should be performed asynchronously.
         */
        DetachRequest async(Boolean async);
    }
    
    public interface DetachResponse extends Response {
    }
    
    DetachRequest detach();
    
    public interface ExportRequest extends Request<ExportRequest, ExportResponse> {
        /**
         * Indicates if the export should be performed asynchronously.
         */
        ExportRequest async(Boolean async);
        ExportRequest discardSnapshots(Boolean discardSnapshots);
        ExportRequest exclusive(Boolean exclusive);
        ExportRequest storageDomain(StorageDomain storageDomain);
        ExportRequest storageDomain(StorageDomainBuilder storageDomain);
    }
    
    public interface ExportResponse extends Response {
    }
    
    ExportRequest export();
    
    public interface FreezeFilesystemsRequest extends Request<FreezeFilesystemsRequest, FreezeFilesystemsResponse> {
        /**
         * Indicates if the freeze should be performed asynchronously.
         */
        FreezeFilesystemsRequest async(Boolean async);
    }
    
    public interface FreezeFilesystemsResponse extends Response {
    }
    
    FreezeFilesystemsRequest freezeFilesystems();
    
    /**
     * Retrieves the description of the virtual machine.
     * 
     * Note that some elements of the description of the virtual machine won't be returned unless the `All-Content`
     * header is present in the request and has the value `true`. The elements that aren't currently returned are
     * the following:
     * 
     * - `console`
     * - `initialization.configuration.data` - The OVF document describing the virtual machine.
     * - `rng_source`
     * - `soundcard`
     * - `virtio_scsi`
     * 
     * With the Python SDK the `All-Content` header can be set using the `all_content` parameter of the `get`
     * method:
     * 
     * [source,python]
     * ----
     * api.vms.get(name="myvm", all_content=True)
     * ----
     * 
     * Note that the reason for not including these elements is performance: they are seldom used and they require
     * additional queries in the server. So try to use the `All-Content` header only when it is really needed.
     */
    public interface GetRequest extends Request<GetRequest, GetResponse> {
        /**
         * Indicates if the results should be filtered according to the permissions of the user.
         */
        GetRequest filter(Boolean filter);
        /**
         * Indicates if the returned result describes the virtual machine as it is currently running, or if describes
         * it with the modifications that have already been performed but that will have effect only when it is
         * restarted. By default the values is `false`.
         * 
         * If the parameter is included in the request, but without a value, it is assumed that the value is `true`, so
         * the following request:
         * 
         * [source]
         * ----
         * GET /vms/{vm:id};next_run
         * ----
         * 
         * Is equivalent to using the value `true`:
         * 
         * [source]
         * ----
         * GET /vms/{vm:id};next_run=true
         * ----
         */
        GetRequest nextRun(Boolean nextRun);
    }
    
    /**
     * Retrieves the description of the virtual machine.
     * 
     * Note that some elements of the description of the virtual machine won't be returned unless the `All-Content`
     * header is present in the request and has the value `true`. The elements that aren't currently returned are
     * the following:
     * 
     * - `console`
     * - `initialization.configuration.data` - The OVF document describing the virtual machine.
     * - `rng_source`
     * - `soundcard`
     * - `virtio_scsi`
     * 
     * With the Python SDK the `All-Content` header can be set using the `all_content` parameter of the `get`
     * method:
     * 
     * [source,python]
     * ----
     * api.vms.get(name="myvm", all_content=True)
     * ----
     * 
     * Note that the reason for not including these elements is performance: they are seldom used and they require
     * additional queries in the server. So try to use the `All-Content` header only when it is really needed.
     */
    public interface GetResponse extends Response {
        Vm vm();
    }
    
    /**
     * Retrieves the description of the virtual machine.
     * 
     * Note that some elements of the description of the virtual machine won't be returned unless the `All-Content`
     * header is present in the request and has the value `true`. The elements that aren't currently returned are
     * the following:
     * 
     * - `console`
     * - `initialization.configuration.data` - The OVF document describing the virtual machine.
     * - `rng_source`
     * - `soundcard`
     * - `virtio_scsi`
     * 
     * With the Python SDK the `All-Content` header can be set using the `all_content` parameter of the `get`
     * method:
     * 
     * [source,python]
     * ----
     * api.vms.get(name="myvm", all_content=True)
     * ----
     * 
     * Note that the reason for not including these elements is performance: they are seldom used and they require
     * additional queries in the server. So try to use the `All-Content` header only when it is really needed.
     */
    GetRequest get();
    
    public interface LogonRequest extends Request<LogonRequest, LogonResponse> {
        /**
         * Indicates if the logon should be performed asynchronously.
         */
        LogonRequest async(Boolean async);
    }
    
    public interface LogonResponse extends Response {
    }
    
    LogonRequest logon();
    
    public interface MaintenanceRequest extends Request<MaintenanceRequest, MaintenanceResponse> {
        /**
         * Indicates if the action should be performed asynchronously.
         */
        MaintenanceRequest async(Boolean async);
        MaintenanceRequest maintenanceEnabled(Boolean maintenanceEnabled);
    }
    
    public interface MaintenanceResponse extends Response {
    }
    
    MaintenanceRequest maintenance();
    
    public interface MigrateRequest extends Request<MigrateRequest, MigrateResponse> {
        /**
         * Indicates if the migration should be performed asynchronously.
         */
        MigrateRequest async(Boolean async);
        MigrateRequest cluster(Cluster cluster);
        MigrateRequest cluster(ClusterBuilder cluster);
        MigrateRequest force(Boolean force);
        MigrateRequest host(Host host);
        MigrateRequest host(HostBuilder host);
    }
    
    public interface MigrateResponse extends Response {
    }
    
    MigrateRequest migrate();
    
    public interface PreviewSnapshotRequest extends Request<PreviewSnapshotRequest, PreviewSnapshotResponse> {
        /**
         * Indicates if the preview should be performed asynchronously.
         */
        PreviewSnapshotRequest async(Boolean async);
        PreviewSnapshotRequest disks(List<Disk> disks);
        PreviewSnapshotRequest disks(Disk... disks);
        PreviewSnapshotRequest disks(DiskBuilder... disks);
        PreviewSnapshotRequest restoreMemory(Boolean restoreMemory);
        PreviewSnapshotRequest snapshot(Snapshot snapshot);
        PreviewSnapshotRequest snapshot(SnapshotBuilder snapshot);
        PreviewSnapshotRequest vm(Vm vm);
        PreviewSnapshotRequest vm(VmBuilder vm);
    }
    
    public interface PreviewSnapshotResponse extends Response {
    }
    
    PreviewSnapshotRequest previewSnapshot();
    
    public interface RebootRequest extends Request<RebootRequest, RebootResponse> {
        /**
         * Indicates if the reboot should be performed asynchronously.
         */
        RebootRequest async(Boolean async);
    }
    
    public interface RebootResponse extends Response {
    }
    
    RebootRequest reboot();
    
    public interface RemoveRequest extends Request<RemoveRequest, RemoveResponse> {
        /**
         * Indicates if the remove should be performed asynchronously.
         */
        RemoveRequest async(Boolean async);
    }
    
    public interface RemoveResponse extends Response {
    }
    
    RemoveRequest remove();
    
    public interface ReorderMacAddressesRequest extends Request<ReorderMacAddressesRequest, ReorderMacAddressesResponse> {
        /**
         * Indicates if the action should be performed asynchronously.
         */
        ReorderMacAddressesRequest async(Boolean async);
    }
    
    public interface ReorderMacAddressesResponse extends Response {
    }
    
    ReorderMacAddressesRequest reorderMacAddresses();
    
    public interface ShutdownRequest extends Request<ShutdownRequest, ShutdownResponse> {
        /**
         * Indicates if the shutdown should be performed asynchronously.
         */
        ShutdownRequest async(Boolean async);
    }
    
    public interface ShutdownResponse extends Response {
    }
    
    ShutdownRequest shutdown();
    
    public interface StartRequest extends Request<StartRequest, StartResponse> {
        /**
         * Indicates if the action should be performed asynchronously.
         */
        StartRequest async(Boolean async);
        /**
         * Indicates if the results should be filtered according to the permissions of the user.
         */
        StartRequest filter(Boolean filter);
        StartRequest pause(Boolean pause);
        StartRequest useCloudInit(Boolean useCloudInit);
        StartRequest useSysprep(Boolean useSysprep);
        StartRequest vm(Vm vm);
        StartRequest vm(VmBuilder vm);
    }
    
    public interface StartResponse extends Response {
    }
    
    StartRequest start();
    
    public interface StopRequest extends Request<StopRequest, StopResponse> {
        /**
         * Indicates if the action should be performed asynchronously.
         */
        StopRequest async(Boolean async);
    }
    
    public interface StopResponse extends Response {
    }
    
    StopRequest stop();
    
    public interface SuspendRequest extends Request<SuspendRequest, SuspendResponse> {
        /**
         * Indicates if the action should be performed asynchronously.
         */
        SuspendRequest async(Boolean async);
    }
    
    public interface SuspendResponse extends Response {
    }
    
    SuspendRequest suspend();
    
    public interface ThawFilesystemsRequest extends Request<ThawFilesystemsRequest, ThawFilesystemsResponse> {
        /**
         * Indicates if the action should be performed asynchronously.
         */
        ThawFilesystemsRequest async(Boolean async);
    }
    
    public interface ThawFilesystemsResponse extends Response {
    }
    
    ThawFilesystemsRequest thawFilesystems();
    
    public interface TicketRequest extends Request<TicketRequest, TicketResponse> {
        /**
         * Indicates if the generation of the ticket should be performed asynchronously.
         */
        TicketRequest async(Boolean async);
        TicketRequest ticket(Ticket ticket);
        TicketRequest ticket(TicketBuilder ticket);
    }
    
    public interface TicketResponse extends Response {
        Ticket ticket();
    }
    
    TicketRequest ticket();
    
    public interface UndoSnapshotRequest extends Request<UndoSnapshotRequest, UndoSnapshotResponse> {
        /**
         * Indicates if the action should be performed asynchronously.
         */
        UndoSnapshotRequest async(Boolean async);
    }
    
    public interface UndoSnapshotResponse extends Response {
    }
    
    UndoSnapshotRequest undoSnapshot();
    
    public interface UpdateRequest extends Request<UpdateRequest, UpdateResponse> {
        /**
         * Indicates if the update should be performed asynchronously.
         */
        UpdateRequest async(Boolean async);
        UpdateRequest vm(Vm vm);
        UpdateRequest vm(VmBuilder vm);
    }
    
    public interface UpdateResponse extends Response {
        Vm vm();
    }
    
    UpdateRequest update();
    
    /**
     * List of scheduling labels assigned to this VM.
     */
    AssignedAffinityLabelsService affinityLabelsService();
    VmApplicationsService applicationsService();
    VmCdromsService cdromsService();
    /**
     * List of disks attached to this virtual machine.
     */
    DiskAttachmentsService diskAttachmentsService();
    GraphicsConsolesService graphicsConsolesService();
    VmHostDevicesService hostDevicesService();
    KatelloErrataService katelloErrataService();
    VmNicsService nicsService();
    VmNumaNodesService numaNodesService();
    AssignedPermissionsService permissionsService();
    VmReportedDevicesService reportedDevicesService();
    VmSessionsService sessionsService();
    SnapshotsService snapshotsService();
    AssignedTagsService tagsService();
    VmWatchdogsService watchdogsService();
    /**
     * Service locator method, returns individual service on which the URI is dispatched.
     */
    Service service(String path);
}

