/*
Copyright (c) 2015 Red Hat, Inc.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.ovirt.engine.sdk4.types;


import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum VmStatus {
    
    UNASSIGNED,
    DOWN,
    UP,
    POWERING_UP,
    PAUSED,
    MIGRATING,
    UNKNOWN,
    NOT_RESPONDING,
    WAIT_FOR_LAUNCH,
    REBOOT_IN_PROGRESS,
    SAVING_STATE,
    RESTORING_STATE,
    SUSPENDED,
    IMAGE_LOCKED,
    POWERING_DOWN;
    
    private static final Logger LOG = LoggerFactory.getLogger(VmStatus.class);
    
    public String value() {
        return name().toLowerCase();
    }
    
    public static VmStatus fromValue(String value) {
        try {
            return valueOf(value.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            LOG.error("The string '" + value + "' isn't a valid value for the 'VmStatus' enumerated type. Valid values are: 'unassigned', 'down', 'up', 'powering_up', 'paused', 'migrating', 'unknown', 'not_responding', 'wait_for_launch', 'reboot_in_progress', 'saving_state', 'restoring_state', 'suspended', 'image_locked', 'powering_down'.");
            return null;
        }
    }
    
}
