/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.services;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.util.EntityUtils;
import org.ovirt.api.metamodel.runtime.xml.XmlWriter;
import org.ovirt.engine.sdk4.Error;
import org.ovirt.engine.sdk4.Service;
import org.ovirt.engine.sdk4.builders.DiskBuilder;
import org.ovirt.engine.sdk4.internal.HttpConnection;
import org.ovirt.engine.sdk4.internal.services.ServiceImpl;
import org.ovirt.engine.sdk4.internal.services.SnapshotCdromsServiceImpl;
import org.ovirt.engine.sdk4.internal.services.SnapshotDisksServiceImpl;
import org.ovirt.engine.sdk4.internal.services.SnapshotNicsServiceImpl;
import org.ovirt.engine.sdk4.internal.xml.XmlDiskWriter;
import org.ovirt.engine.sdk4.services.SnapshotCdromsService;
import org.ovirt.engine.sdk4.services.SnapshotDisksService;
import org.ovirt.engine.sdk4.services.SnapshotNicsService;
import org.ovirt.engine.sdk4.services.SnapshotService;
import org.ovirt.engine.sdk4.types.Action;
import org.ovirt.engine.sdk4.types.Disk;
import org.ovirt.engine.sdk4.types.Snapshot;

public class SnapshotServiceImpl
extends ServiceImpl
implements SnapshotService {
    public SnapshotServiceImpl(HttpConnection connection, String path) {
        super(connection, path);
    }

    @Override
    public SnapshotService.GetRequest get() {
        return new GetRequestImpl();
    }

    @Override
    public SnapshotService.RemoveRequest remove() {
        return new RemoveRequestImpl();
    }

    @Override
    public SnapshotService.RestoreRequest restore() {
        return new RestoreRequestImpl();
    }

    @Override
    public SnapshotCdromsService cdromsService() {
        return new SnapshotCdromsServiceImpl(this.getConnection(), this.getPath() + "/cdroms");
    }

    @Override
    public SnapshotDisksService disksService() {
        return new SnapshotDisksServiceImpl(this.getConnection(), this.getPath() + "/disks");
    }

    @Override
    public SnapshotNicsService nicsService() {
        return new SnapshotNicsServiceImpl(this.getConnection(), this.getPath() + "/nics");
    }

    @Override
    public Service service(String path) {
        if (path == null) {
            return this;
        }
        if (path.equals("cdroms")) {
            return this.cdromsService();
        }
        if (path.startsWith("cdroms/")) {
            return this.cdromsService().service(path.substring(7));
        }
        if (path.equals("disks")) {
            return this.disksService();
        }
        if (path.startsWith("disks/")) {
            return this.disksService().service(path.substring(6));
        }
        if (path.equals("nics")) {
            return this.nicsService();
        }
        if (path.startsWith("nics/")) {
            return this.nicsService().service(path.substring(5));
        }
        throw new Error("The path " + path + " doesn't correspond to any service");
    }

    public String toString() {
        return "SnapshotService:" + this.getPath();
    }

    private class RestoreResponseImpl
    implements SnapshotService.RestoreResponse {
        private RestoreResponseImpl() {
        }
    }

    private class RestoreRequestImpl
    implements SnapshotService.RestoreRequest {
        private Boolean async;
        private List<Disk> disks;
        private Boolean restoreMemory;

        private RestoreRequestImpl() {
        }

        @Override
        public SnapshotService.RestoreRequest async(Boolean async) {
            this.async = async;
            return this;
        }

        @Override
        public SnapshotService.RestoreRequest disks(List<Disk> disks) {
            this.disks = disks;
            return this;
        }

        @Override
        public SnapshotService.RestoreRequest disks(Disk ... disks) {
            this.disks = Arrays.asList(disks);
            return this;
        }

        @Override
        public SnapshotService.RestoreRequest disks(DiskBuilder ... disks) {
            this.disks = new ArrayList<Disk>(disks.length);
            for (DiskBuilder element : disks) {
                this.disks.add(element.build());
            }
            return this;
        }

        @Override
        public SnapshotService.RestoreRequest restoreMemory(Boolean restoreMemory) {
            this.restoreMemory = restoreMemory;
            return this;
        }

        @Override
        public SnapshotService.RestoreResponse send() {
            HttpPost request = new HttpPost(SnapshotServiceImpl.this.getConnection().getUrl() + SnapshotServiceImpl.this.getPath() + "/restore");
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();
                 XmlWriter xmlWriter = new XmlWriter(output, true);){
                xmlWriter.writeStartElement("action");
                if (this.disks != null) {
                    XmlDiskWriter.writeMany(this.disks.iterator(), "disk", "disks", xmlWriter);
                }
                if (this.restoreMemory != null) {
                    xmlWriter.writeBoolean("restore_memory", this.restoreMemory);
                }
                if (this.async != null) {
                    xmlWriter.writeBoolean("async", this.async);
                }
                xmlWriter.writeEndElement();
                xmlWriter.flush();
                request.setEntity((HttpEntity)new ByteArrayEntity(output.toByteArray()));
            }
            catch (IOException ex) {
                throw new Error("Failed to write request", ex);
            }
            HttpResponse response = SnapshotServiceImpl.this.getConnection().send((HttpUriRequest)request);
            if (response.getStatusLine().getStatusCode() == 200) {
                Action action = SnapshotServiceImpl.this.checkAction(response);
                EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                return new RestoreResponseImpl();
            }
            SnapshotServiceImpl.this.checkFault(response);
            return null;
        }
    }

    private class RemoveResponseImpl
    implements SnapshotService.RemoveResponse {
        private RemoveResponseImpl() {
        }
    }

    private class RemoveRequestImpl
    implements SnapshotService.RemoveRequest {
        private Boolean async;

        private RemoveRequestImpl() {
        }

        @Override
        public SnapshotService.RemoveRequest async(Boolean async) {
            this.async = async;
            return this;
        }

        @Override
        public SnapshotService.RemoveResponse send() {
            HttpDelete request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(SnapshotServiceImpl.this.getConnection().getUrl() + SnapshotServiceImpl.this.getPath());
                if (this.async != null) {
                    uriBuilder.addParameter("async", XmlWriter.renderBoolean(this.async));
                }
                request = new HttpDelete(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            HttpResponse response = SnapshotServiceImpl.this.getConnection().send((HttpUriRequest)request);
            if (response.getStatusLine().getStatusCode() == 200) {
                EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                return new RemoveResponseImpl();
            }
            SnapshotServiceImpl.this.checkFault(response);
            return null;
        }
    }

    private class GetResponseImpl
    implements SnapshotService.GetResponse {
        private Snapshot snapshot;

        public GetResponseImpl(Snapshot snapshot) {
            this.snapshot = snapshot;
        }

        @Override
        public Snapshot snapshot() {
            return this.snapshot;
        }
    }

    private class GetRequestImpl
    implements SnapshotService.GetRequest {
        private GetRequestImpl() {
        }

        /*
         * Exception decompiling
         */
        @Override
        public SnapshotService.GetResponse send() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }
}

