/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.types;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum GlusterVolumeType {
    DISTRIBUTE,
    REPLICATE,
    DISTRIBUTED_REPLICATE,
    STRIPE,
    DISTRIBUTED_STRIPE,
    STRIPED_REPLICATE,
    DISTRIBUTED_STRIPED_REPLICATE,
    DISPERSE,
    DISTRIBUTED_DISPERSE;

    private static final Logger LOG;

    public String value() {
        return this.name().toLowerCase();
    }

    public static GlusterVolumeType fromValue(String value) {
        try {
            return GlusterVolumeType.valueOf(value.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            LOG.error("The string '" + value + "' isn't a valid value for the 'GlusterVolumeType' enumerated type. Valid values are: 'distribute', 'replicate', 'distributed_replicate', 'stripe', 'distributed_stripe', 'striped_replicate', 'distributed_striped_replicate', 'disperse', 'distributed_disperse'.");
            return null;
        }
    }

    static {
        LOG = LoggerFactory.getLogger(GlusterVolumeType.class);
    }
}

