/*
Copyright (c) 2015 Red Hat, Inc.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.ovirt.engine.sdk4.internal.containers;

import java.lang.String;
import java.math.BigInteger;
import java.util.List;
import org.ovirt.engine.sdk4.types.BlockStatistic;
import org.ovirt.engine.sdk4.types.FopStatistic;
import org.ovirt.engine.sdk4.types.ProfileDetail;
import org.ovirt.engine.sdk4.types.Statistic;

public class ProfileDetailContainer extends Container implements ProfileDetail {
    private List<BlockStatistic> blockStatistics;
    private BigInteger duration;
    private List<FopStatistic> fopStatistics;
    private String profileType;
    private List<Statistic> statistics;
    
    public List<BlockStatistic> blockStatistics() {
        return makeUnmodifiableList(blockStatistics);
    }
    
    public void blockStatistics(List<BlockStatistic> newBlockStatistics) {
        blockStatistics = makeArrayList(newBlockStatistics);
    }
    
    public boolean blockStatisticsPresent() {
        return blockStatistics != null && !blockStatistics.isEmpty();
    }
    
    public BigInteger duration() {
        return duration;
    }
    
    public void duration(BigInteger newDuration) {
        duration = newDuration;
    }
    
    public boolean durationPresent() {
        return duration != null;
    }
    
    public List<FopStatistic> fopStatistics() {
        return makeUnmodifiableList(fopStatistics);
    }
    
    public void fopStatistics(List<FopStatistic> newFopStatistics) {
        fopStatistics = makeArrayList(newFopStatistics);
    }
    
    public boolean fopStatisticsPresent() {
        return fopStatistics != null && !fopStatistics.isEmpty();
    }
    
    public String profileType() {
        return profileType;
    }
    
    public void profileType(String newProfileType) {
        profileType = newProfileType;
    }
    
    public boolean profileTypePresent() {
        return profileType != null;
    }
    
    public List<Statistic> statistics() {
        return makeUnmodifiableList(statistics);
    }
    
    public void statistics(List<Statistic> newStatistics) {
        statistics = makeArrayList(newStatistics);
    }
    
    public boolean statisticsPresent() {
        return statistics != null && !statistics.isEmpty();
    }
    
}
