/*
Copyright (c) 2015 Red Hat, Inc.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.ovirt.engine.sdk4.services;

import java.io.IOException;
import java.math.BigInteger;
import java.util.List;
import org.ovirt.engine.sdk4.Request;
import org.ovirt.engine.sdk4.Response;
import org.ovirt.engine.sdk4.Service;
import org.ovirt.engine.sdk4.builders.DataCenterBuilder;
import org.ovirt.engine.sdk4.types.DataCenter;

public interface DataCentersService extends Service {
    public interface AddRequest extends Request<AddRequest, AddResponse> {
        AddRequest dataCenter(DataCenter dataCenter);
        AddRequest dataCenter(DataCenterBuilder dataCenter);
    }
    
    public interface AddResponse extends Response {
        DataCenter dataCenter();
    }
    
    AddRequest add();
    
    public interface ListRequest extends Request<ListRequest, ListResponse> {
        /**
         * Indicates if the search performed using the `search` parameter should be performed taking case into
         * account. The default value is `true`, which means that case is taken into account. If you want to search
         * ignoring case set it to `false`.
         */
        ListRequest caseSensitive(Boolean caseSensitive);
        /**
         * Indicates if the results should be filtered according to the permissions of the user.
         */
        ListRequest filter(Boolean filter);
        /**
         * Sets the maximum number of data centers to return. If not specified all the data centers are returned.
         */
        ListRequest max(Integer max);
        /**
         * Sets the maximum number of data centers to return. If not specified all the data centers are returned.
         */
        ListRequest max(Long max);
        /**
         * Sets the maximum number of data centers to return. If not specified all the data centers are returned.
         */
        ListRequest max(BigInteger max);
        /**
         * A query string used to restrict the returned data centers.
         */
        ListRequest search(String search);
    }
    
    public interface ListResponse extends Response {
        List<DataCenter> dataCenters();
    }
    
    ListRequest list();
    
    DataCenterService dataCenterService(String id);
    /**
     * Service locator method, returns individual service on which the URI is dispatched.
     */
    Service service(String path);
}

