/*
Copyright (c) 2015 Red Hat, Inc.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.ovirt.engine.sdk4.internal.containers;

import java.util.List;
import org.ovirt.engine.sdk4.types.Dns;
import org.ovirt.engine.sdk4.types.Host;

public class DnsContainer extends Container implements Dns {
    private List<Host> searchDomains;
    private List<Host> servers;
    
    public List<Host> searchDomains() {
        return makeUnmodifiableList(searchDomains);
    }
    
    public void searchDomains(List<Host> newSearchDomains) {
        searchDomains = makeArrayList(newSearchDomains);
    }
    
    public boolean searchDomainsPresent() {
        return searchDomains != null && !searchDomains.isEmpty();
    }
    
    public List<Host> servers() {
        return makeUnmodifiableList(servers);
    }
    
    public void servers(List<Host> newServers) {
        servers = makeArrayList(newServers);
    }
    
    public boolean serversPresent() {
        return servers != null && !servers.isEmpty();
    }
    
}
