/*
Copyright (c) 2015 Red Hat, Inc.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.ovirt.engine.sdk4.types;

import java.math.BigInteger;
import java.util.List;

public interface StorageDomain extends Identified {
    BigInteger available();
    
    boolean availablePresent();
    
    BigInteger committed();
    
    boolean committedPresent();
    
    BigInteger criticalSpaceActionBlocker();
    
    boolean criticalSpaceActionBlockerPresent();
    
    ExternalStatus externalStatus();
    
    boolean externalStatusPresent();
    
    boolean import_();
    
    boolean import_Present();
    
    boolean master();
    
    boolean masterPresent();
    
    StorageDomainStatus status();
    
    boolean statusPresent();
    
    HostStorage storage();
    
    boolean storagePresent();
    
    StorageFormat storageFormat();
    
    boolean storageFormatPresent();
    
    StorageDomainType type();
    
    boolean typePresent();
    
    BigInteger used();
    
    boolean usedPresent();
    
    BigInteger warningLowSpaceIndicator();
    
    boolean warningLowSpaceIndicatorPresent();
    
    boolean wipeAfterDelete();
    
    boolean wipeAfterDeletePresent();
    
    DataCenter dataCenter();
    
    boolean dataCenterPresent();
    
    List<DataCenter> dataCenters();
    
    boolean dataCentersPresent();
    
    List<DiskProfile> diskProfiles();
    
    boolean diskProfilesPresent();
    
    List<DiskSnapshot> diskSnapshots();
    
    boolean diskSnapshotsPresent();
    
    List<Disk> disks();
    
    boolean disksPresent();
    
    List<File> files();
    
    boolean filesPresent();
    
    Host host();
    
    boolean hostPresent();
    
    List<Image> images();
    
    boolean imagesPresent();
    
    List<Permission> permissions();
    
    boolean permissionsPresent();
    
    List<StorageConnection> storageConnections();
    
    boolean storageConnectionsPresent();
    
    List<Template> templates();
    
    boolean templatesPresent();
    
    List<Vm> vms();
    
    boolean vmsPresent();
    
}
