/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.builders;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.ovirt.engine.sdk4.builders.StepBuilder;
import org.ovirt.engine.sdk4.builders.UserBuilder;
import org.ovirt.engine.sdk4.internal.containers.JobContainer;
import org.ovirt.engine.sdk4.types.Job;
import org.ovirt.engine.sdk4.types.JobStatus;
import org.ovirt.engine.sdk4.types.Step;
import org.ovirt.engine.sdk4.types.User;

public class JobBuilder {
    private Boolean autoCleared;
    private String comment;
    private String description;
    private Date endTime;
    private Boolean external;
    private String href;
    private String id;
    private Date lastUpdated;
    private String name;
    private User owner;
    private Date startTime;
    private JobStatus status;
    private List<Step> steps;

    public JobBuilder autoCleared(boolean newAutoCleared) {
        this.autoCleared = newAutoCleared;
        return this;
    }

    public JobBuilder autoCleared(Boolean newAutoCleared) {
        this.autoCleared = newAutoCleared;
        return this;
    }

    public JobBuilder comment(String newComment) {
        this.comment = newComment;
        return this;
    }

    public JobBuilder description(String newDescription) {
        this.description = newDescription;
        return this;
    }

    public JobBuilder endTime(Date newEndTime) {
        this.endTime = newEndTime == null ? null : new Date(newEndTime.getTime());
        return this;
    }

    public JobBuilder external(boolean newExternal) {
        this.external = newExternal;
        return this;
    }

    public JobBuilder external(Boolean newExternal) {
        this.external = newExternal;
        return this;
    }

    public JobBuilder href(String newHref) {
        this.href = newHref;
        return this;
    }

    public JobBuilder id(String newId) {
        this.id = newId;
        return this;
    }

    public JobBuilder lastUpdated(Date newLastUpdated) {
        this.lastUpdated = newLastUpdated == null ? null : new Date(newLastUpdated.getTime());
        return this;
    }

    public JobBuilder name(String newName) {
        this.name = newName;
        return this;
    }

    public JobBuilder owner(User newOwner) {
        this.owner = newOwner;
        return this;
    }

    public JobBuilder owner(UserBuilder newOwner) {
        this.owner = newOwner == null ? null : newOwner.build();
        return this;
    }

    public JobBuilder startTime(Date newStartTime) {
        this.startTime = newStartTime == null ? null : new Date(newStartTime.getTime());
        return this;
    }

    public JobBuilder status(JobStatus newStatus) {
        this.status = newStatus;
        return this;
    }

    public JobBuilder steps(List<Step> newSteps) {
        if (newSteps != null) {
            if (this.steps == null) {
                this.steps = new ArrayList<Step>(newSteps);
            } else {
                this.steps.addAll(newSteps);
            }
        }
        return this;
    }

    public JobBuilder steps(Step ... newSteps) {
        if (newSteps != null) {
            if (this.steps == null) {
                this.steps = new ArrayList<Step>(newSteps.length);
            }
            Collections.addAll(this.steps, newSteps);
        }
        return this;
    }

    public JobBuilder steps(StepBuilder ... newSteps) {
        if (newSteps != null) {
            if (this.steps == null) {
                this.steps = new ArrayList<Step>(newSteps.length);
            }
            for (StepBuilder builder : newSteps) {
                this.steps.add(builder.build());
            }
        }
        return this;
    }

    public Job build() {
        JobContainer container = new JobContainer();
        container.autoCleared(this.autoCleared);
        container.comment(this.comment);
        container.description(this.description);
        container.endTime(this.endTime);
        container.external(this.external);
        container.href(this.href);
        container.id(this.id);
        container.lastUpdated(this.lastUpdated);
        container.name(this.name);
        container.owner(this.owner);
        container.startTime(this.startTime);
        container.status(this.status);
        container.steps(this.steps);
        return container;
    }
}

