/*
Copyright (c) 2015 Red Hat, Inc.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.ovirt.engine.sdk4.internal.containers;

import java.lang.String;
import org.ovirt.engine.sdk4.types.ExternalDiscoveredHost;
import org.ovirt.engine.sdk4.types.ExternalHostProvider;

public class ExternalDiscoveredHostContainer extends IdentifiedContainer implements ExternalDiscoveredHost {
    private String ip;
    private String lastReport;
    private String mac;
    private String subnetName;
    private ExternalHostProvider externalHostProvider;
    
    public String ip() {
        return ip;
    }
    
    public void ip(String newIp) {
        ip = newIp;
    }
    
    public boolean ipPresent() {
        return ip != null;
    }
    
    public String lastReport() {
        return lastReport;
    }
    
    public void lastReport(String newLastReport) {
        lastReport = newLastReport;
    }
    
    public boolean lastReportPresent() {
        return lastReport != null;
    }
    
    public String mac() {
        return mac;
    }
    
    public void mac(String newMac) {
        mac = newMac;
    }
    
    public boolean macPresent() {
        return mac != null;
    }
    
    public String subnetName() {
        return subnetName;
    }
    
    public void subnetName(String newSubnetName) {
        subnetName = newSubnetName;
    }
    
    public boolean subnetNamePresent() {
        return subnetName != null;
    }
    
    public ExternalHostProvider externalHostProvider() {
        return externalHostProvider;
    }
    
    public void externalHostProvider(ExternalHostProvider newExternalHostProvider) {
        externalHostProvider = newExternalHostProvider;
    }
    
    public boolean externalHostProviderPresent() {
        return externalHostProvider != null;
    }
    
}
