/*
Copyright (c) 2015 Red Hat, Inc.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.ovirt.engine.sdk4.builders;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.ovirt.engine.sdk4.internal.containers.DnsContainer;
import org.ovirt.engine.sdk4.types.Dns;
import org.ovirt.engine.sdk4.types.Host;

public class DnsBuilder {
    private List<Host> searchDomains;
    private List<Host> servers;
    
    public DnsBuilder searchDomains(List<Host> newSearchDomains) {
        if (newSearchDomains != null) {
            if (searchDomains == null) {
                searchDomains = new ArrayList<>(newSearchDomains);
            }
            else {
                searchDomains.addAll(newSearchDomains);
            }
        }
        return this;
    }
    
    public DnsBuilder searchDomains(Host... newSearchDomains) {
        if (newSearchDomains != null) {
            if (searchDomains == null) {
                searchDomains = new ArrayList<>(newSearchDomains.length);
            }
            Collections.addAll(searchDomains, newSearchDomains);
        }
        return this;
    }
    
    public DnsBuilder searchDomains(HostBuilder... newSearchDomains) {
        if (newSearchDomains != null) {
            if (searchDomains == null) {
                searchDomains = new ArrayList<>(newSearchDomains.length);
            }
            for (HostBuilder builder : newSearchDomains) {
                searchDomains.add(builder.build());
            }
        }
        return this;
    }
    
    
    public DnsBuilder servers(List<Host> newServers) {
        if (newServers != null) {
            if (servers == null) {
                servers = new ArrayList<>(newServers);
            }
            else {
                servers.addAll(newServers);
            }
        }
        return this;
    }
    
    public DnsBuilder servers(Host... newServers) {
        if (newServers != null) {
            if (servers == null) {
                servers = new ArrayList<>(newServers.length);
            }
            Collections.addAll(servers, newServers);
        }
        return this;
    }
    
    public DnsBuilder servers(HostBuilder... newServers) {
        if (newServers != null) {
            if (servers == null) {
                servers = new ArrayList<>(newServers.length);
            }
            for (HostBuilder builder : newServers) {
                servers.add(builder.build());
            }
        }
        return this;
    }
    
    
    public Dns build() {
        DnsContainer container = new DnsContainer();
        container.searchDomains(searchDomains);
        container.servers(servers);
        return container;
    }
}
