/*
Copyright (c) 2015 Red Hat, Inc.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.ovirt.engine.sdk4.internal.containers;

import java.lang.Boolean;
import java.lang.String;
import java.math.BigInteger;
import java.util.List;
import org.ovirt.engine.sdk4.types.Disk;
import org.ovirt.engine.sdk4.types.DiskFormat;
import org.ovirt.engine.sdk4.types.DiskInterface;
import org.ovirt.engine.sdk4.types.DiskProfile;
import org.ovirt.engine.sdk4.types.DiskStatus;
import org.ovirt.engine.sdk4.types.DiskStorageType;
import org.ovirt.engine.sdk4.types.HostStorage;
import org.ovirt.engine.sdk4.types.OpenStackVolumeType;
import org.ovirt.engine.sdk4.types.Permission;
import org.ovirt.engine.sdk4.types.Quota;
import org.ovirt.engine.sdk4.types.ScsiGenericIO;
import org.ovirt.engine.sdk4.types.Snapshot;
import org.ovirt.engine.sdk4.types.Statistic;
import org.ovirt.engine.sdk4.types.StorageDomain;

public class DiskContainer extends DeviceContainer implements Disk {
    private Boolean active;
    private BigInteger actualSize;
    private String alias;
    private Boolean bootable;
    private DiskFormat format;
    private String imageId;
    private DiskInterface interface_;
    private String logicalName;
    private HostStorage lunStorage;
    private Boolean propagateErrors;
    private BigInteger provisionedSize;
    private Boolean readOnly;
    private ScsiGenericIO sgio;
    private Boolean shareable;
    private Boolean sparse;
    private DiskStatus status;
    private DiskStorageType storageType;
    private Boolean usesScsiReservation;
    private Boolean wipeAfterDelete;
    private DiskProfile diskProfile;
    private OpenStackVolumeType openstackVolumeType;
    private List<Permission> permissions;
    private Quota quota;
    private Snapshot snapshot;
    private List<Statistic> statistics;
    private StorageDomain storageDomain;
    private List<StorageDomain> storageDomains;
    
    public boolean active() {
        return active;
    }
    
    public void active(boolean newActive) {
        active = Boolean.valueOf(newActive);
    }
    
    public void active(Boolean newActive) {
        active = newActive;
    }
    
    public boolean activePresent() {
        return active != null;
    }
    
    public BigInteger actualSize() {
        return actualSize;
    }
    
    public void actualSize(BigInteger newActualSize) {
        actualSize = newActualSize;
    }
    
    public boolean actualSizePresent() {
        return actualSize != null;
    }
    
    public String alias() {
        return alias;
    }
    
    public void alias(String newAlias) {
        alias = newAlias;
    }
    
    public boolean aliasPresent() {
        return alias != null;
    }
    
    public boolean bootable() {
        return bootable;
    }
    
    public void bootable(boolean newBootable) {
        bootable = Boolean.valueOf(newBootable);
    }
    
    public void bootable(Boolean newBootable) {
        bootable = newBootable;
    }
    
    public boolean bootablePresent() {
        return bootable != null;
    }
    
    public DiskFormat format() {
        return format;
    }
    
    public void format(DiskFormat newFormat) {
        format = newFormat;
    }
    
    public boolean formatPresent() {
        return format != null;
    }
    
    public String imageId() {
        return imageId;
    }
    
    public void imageId(String newImageId) {
        imageId = newImageId;
    }
    
    public boolean imageIdPresent() {
        return imageId != null;
    }
    
    public DiskInterface interface_() {
        return interface_;
    }
    
    public void interface_(DiskInterface newInterface) {
        interface_ = newInterface;
    }
    
    public boolean interface_Present() {
        return interface_ != null;
    }
    
    public String logicalName() {
        return logicalName;
    }
    
    public void logicalName(String newLogicalName) {
        logicalName = newLogicalName;
    }
    
    public boolean logicalNamePresent() {
        return logicalName != null;
    }
    
    public HostStorage lunStorage() {
        return lunStorage;
    }
    
    public void lunStorage(HostStorage newLunStorage) {
        lunStorage = newLunStorage;
    }
    
    public boolean lunStoragePresent() {
        return lunStorage != null;
    }
    
    public boolean propagateErrors() {
        return propagateErrors;
    }
    
    public void propagateErrors(boolean newPropagateErrors) {
        propagateErrors = Boolean.valueOf(newPropagateErrors);
    }
    
    public void propagateErrors(Boolean newPropagateErrors) {
        propagateErrors = newPropagateErrors;
    }
    
    public boolean propagateErrorsPresent() {
        return propagateErrors != null;
    }
    
    public BigInteger provisionedSize() {
        return provisionedSize;
    }
    
    public void provisionedSize(BigInteger newProvisionedSize) {
        provisionedSize = newProvisionedSize;
    }
    
    public boolean provisionedSizePresent() {
        return provisionedSize != null;
    }
    
    public boolean readOnly() {
        return readOnly;
    }
    
    public void readOnly(boolean newReadOnly) {
        readOnly = Boolean.valueOf(newReadOnly);
    }
    
    public void readOnly(Boolean newReadOnly) {
        readOnly = newReadOnly;
    }
    
    public boolean readOnlyPresent() {
        return readOnly != null;
    }
    
    public ScsiGenericIO sgio() {
        return sgio;
    }
    
    public void sgio(ScsiGenericIO newSgio) {
        sgio = newSgio;
    }
    
    public boolean sgioPresent() {
        return sgio != null;
    }
    
    public boolean shareable() {
        return shareable;
    }
    
    public void shareable(boolean newShareable) {
        shareable = Boolean.valueOf(newShareable);
    }
    
    public void shareable(Boolean newShareable) {
        shareable = newShareable;
    }
    
    public boolean shareablePresent() {
        return shareable != null;
    }
    
    public boolean sparse() {
        return sparse;
    }
    
    public void sparse(boolean newSparse) {
        sparse = Boolean.valueOf(newSparse);
    }
    
    public void sparse(Boolean newSparse) {
        sparse = newSparse;
    }
    
    public boolean sparsePresent() {
        return sparse != null;
    }
    
    public DiskStatus status() {
        return status;
    }
    
    public void status(DiskStatus newStatus) {
        status = newStatus;
    }
    
    public boolean statusPresent() {
        return status != null;
    }
    
    public DiskStorageType storageType() {
        return storageType;
    }
    
    public void storageType(DiskStorageType newStorageType) {
        storageType = newStorageType;
    }
    
    public boolean storageTypePresent() {
        return storageType != null;
    }
    
    public boolean usesScsiReservation() {
        return usesScsiReservation;
    }
    
    public void usesScsiReservation(boolean newUsesScsiReservation) {
        usesScsiReservation = Boolean.valueOf(newUsesScsiReservation);
    }
    
    public void usesScsiReservation(Boolean newUsesScsiReservation) {
        usesScsiReservation = newUsesScsiReservation;
    }
    
    public boolean usesScsiReservationPresent() {
        return usesScsiReservation != null;
    }
    
    public boolean wipeAfterDelete() {
        return wipeAfterDelete;
    }
    
    public void wipeAfterDelete(boolean newWipeAfterDelete) {
        wipeAfterDelete = Boolean.valueOf(newWipeAfterDelete);
    }
    
    public void wipeAfterDelete(Boolean newWipeAfterDelete) {
        wipeAfterDelete = newWipeAfterDelete;
    }
    
    public boolean wipeAfterDeletePresent() {
        return wipeAfterDelete != null;
    }
    
    public DiskProfile diskProfile() {
        return diskProfile;
    }
    
    public void diskProfile(DiskProfile newDiskProfile) {
        diskProfile = newDiskProfile;
    }
    
    public boolean diskProfilePresent() {
        return diskProfile != null;
    }
    
    public OpenStackVolumeType openstackVolumeType() {
        return openstackVolumeType;
    }
    
    public void openstackVolumeType(OpenStackVolumeType newOpenstackVolumeType) {
        openstackVolumeType = newOpenstackVolumeType;
    }
    
    public boolean openstackVolumeTypePresent() {
        return openstackVolumeType != null;
    }
    
    public List<Permission> permissions() {
        return makeUnmodifiableList(permissions);
    }
    
    public void permissions(List<Permission> newPermissions) {
        permissions = makeArrayList(newPermissions);
    }
    
    public boolean permissionsPresent() {
        return permissions != null && !permissions.isEmpty();
    }
    
    public Quota quota() {
        return quota;
    }
    
    public void quota(Quota newQuota) {
        quota = newQuota;
    }
    
    public boolean quotaPresent() {
        return quota != null;
    }
    
    public Snapshot snapshot() {
        return snapshot;
    }
    
    public void snapshot(Snapshot newSnapshot) {
        snapshot = newSnapshot;
    }
    
    public boolean snapshotPresent() {
        return snapshot != null;
    }
    
    public List<Statistic> statistics() {
        return makeUnmodifiableList(statistics);
    }
    
    public void statistics(List<Statistic> newStatistics) {
        statistics = makeArrayList(newStatistics);
    }
    
    public boolean statisticsPresent() {
        return statistics != null && !statistics.isEmpty();
    }
    
    public StorageDomain storageDomain() {
        return storageDomain;
    }
    
    public void storageDomain(StorageDomain newStorageDomain) {
        storageDomain = newStorageDomain;
    }
    
    public boolean storageDomainPresent() {
        return storageDomain != null;
    }
    
    public List<StorageDomain> storageDomains() {
        return makeUnmodifiableList(storageDomains);
    }
    
    public void storageDomains(List<StorageDomain> newStorageDomains) {
        storageDomains = makeArrayList(newStorageDomains);
    }
    
    public boolean storageDomainsPresent() {
        return storageDomains != null && !storageDomains.isEmpty();
    }
    
}
