/*
Copyright (c) 2015 Red Hat, Inc.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.ovirt.engine.sdk4.internal.xml;

import java.util.Iterator;
import org.ovirt.api.metamodel.runtime.xml.XmlWriter;
import org.ovirt.engine.sdk4.types.VmPlacementPolicy;

public class XmlVmPlacementPolicyWriter {
    
    public static void writeOne(VmPlacementPolicy object, XmlWriter writer) {
        writeOne(object, "vm_placement_policy", writer);
    }
    
    public static void writeOne(VmPlacementPolicy object, String tag, XmlWriter writer) {
        writer.writeStartElement(tag);
        if (object.affinityPresent()) {
            XmlVmAffinityWriter.writeOne(object.affinity(), "affinity", writer);
        }
        if (object.hostsPresent()) {
            XmlHostWriter.writeMany(object.hosts().iterator(), "host", "hosts", writer);
        }
        writer.writeEndElement();
    }
    
    public static void writeMany(Iterator<VmPlacementPolicy> list, XmlWriter writer) {
        writeMany(list, "vm_placement_policy", "vm_placement_policies", writer);
    }
    
    public static void writeMany(Iterator<VmPlacementPolicy> list, String singular, String plural, XmlWriter writer) {
        writer.writeStartElement(plural);
        while (list.hasNext()) {
            XmlVmPlacementPolicyWriter.writeOne(list.next(), singular, writer);
        }
        writer.writeEndElement();
    }
    
}

