/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.builders;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.ovirt.engine.sdk4.builders.CertificateBuilder;
import org.ovirt.engine.sdk4.builders.OpenStackImageBuilder;
import org.ovirt.engine.sdk4.builders.PropertyBuilder;
import org.ovirt.engine.sdk4.internal.containers.OpenStackImageProviderContainer;
import org.ovirt.engine.sdk4.types.Certificate;
import org.ovirt.engine.sdk4.types.OpenStackImage;
import org.ovirt.engine.sdk4.types.OpenStackImageProvider;
import org.ovirt.engine.sdk4.types.Property;

public class OpenStackImageProviderBuilder {
    private String authenticationUrl;
    private List<Certificate> certificates;
    private String comment;
    private String description;
    private String href;
    private String id;
    private List<OpenStackImage> images;
    private String name;
    private String password;
    private List<Property> properties;
    private Boolean requiresAuthentication;
    private String tenantName;
    private String url;
    private String username;

    public OpenStackImageProviderBuilder authenticationUrl(String newAuthenticationUrl) {
        this.authenticationUrl = newAuthenticationUrl;
        return this;
    }

    public OpenStackImageProviderBuilder certificates(List<Certificate> newCertificates) {
        if (newCertificates != null) {
            if (this.certificates == null) {
                this.certificates = new ArrayList<Certificate>(newCertificates);
            } else {
                this.certificates.addAll(newCertificates);
            }
        }
        return this;
    }

    public OpenStackImageProviderBuilder certificates(Certificate ... newCertificates) {
        if (newCertificates != null) {
            if (this.certificates == null) {
                this.certificates = new ArrayList<Certificate>(newCertificates.length);
            }
            Collections.addAll(this.certificates, newCertificates);
        }
        return this;
    }

    public OpenStackImageProviderBuilder certificates(CertificateBuilder ... newCertificates) {
        if (newCertificates != null) {
            if (this.certificates == null) {
                this.certificates = new ArrayList<Certificate>(newCertificates.length);
            }
            for (CertificateBuilder builder : newCertificates) {
                this.certificates.add(builder.build());
            }
        }
        return this;
    }

    public OpenStackImageProviderBuilder comment(String newComment) {
        this.comment = newComment;
        return this;
    }

    public OpenStackImageProviderBuilder description(String newDescription) {
        this.description = newDescription;
        return this;
    }

    public OpenStackImageProviderBuilder href(String newHref) {
        this.href = newHref;
        return this;
    }

    public OpenStackImageProviderBuilder id(String newId) {
        this.id = newId;
        return this;
    }

    public OpenStackImageProviderBuilder images(List<OpenStackImage> newImages) {
        if (newImages != null) {
            if (this.images == null) {
                this.images = new ArrayList<OpenStackImage>(newImages);
            } else {
                this.images.addAll(newImages);
            }
        }
        return this;
    }

    public OpenStackImageProviderBuilder images(OpenStackImage ... newImages) {
        if (newImages != null) {
            if (this.images == null) {
                this.images = new ArrayList<OpenStackImage>(newImages.length);
            }
            Collections.addAll(this.images, newImages);
        }
        return this;
    }

    public OpenStackImageProviderBuilder images(OpenStackImageBuilder ... newImages) {
        if (newImages != null) {
            if (this.images == null) {
                this.images = new ArrayList<OpenStackImage>(newImages.length);
            }
            for (OpenStackImageBuilder builder : newImages) {
                this.images.add(builder.build());
            }
        }
        return this;
    }

    public OpenStackImageProviderBuilder name(String newName) {
        this.name = newName;
        return this;
    }

    public OpenStackImageProviderBuilder password(String newPassword) {
        this.password = newPassword;
        return this;
    }

    public OpenStackImageProviderBuilder properties(List<Property> newProperties) {
        if (newProperties != null) {
            if (this.properties == null) {
                this.properties = new ArrayList<Property>(newProperties);
            } else {
                this.properties.addAll(newProperties);
            }
        }
        return this;
    }

    public OpenStackImageProviderBuilder properties(Property ... newProperties) {
        if (newProperties != null) {
            if (this.properties == null) {
                this.properties = new ArrayList<Property>(newProperties.length);
            }
            Collections.addAll(this.properties, newProperties);
        }
        return this;
    }

    public OpenStackImageProviderBuilder properties(PropertyBuilder ... newProperties) {
        if (newProperties != null) {
            if (this.properties == null) {
                this.properties = new ArrayList<Property>(newProperties.length);
            }
            for (PropertyBuilder builder : newProperties) {
                this.properties.add(builder.build());
            }
        }
        return this;
    }

    public OpenStackImageProviderBuilder requiresAuthentication(boolean newRequiresAuthentication) {
        this.requiresAuthentication = newRequiresAuthentication;
        return this;
    }

    public OpenStackImageProviderBuilder requiresAuthentication(Boolean newRequiresAuthentication) {
        this.requiresAuthentication = newRequiresAuthentication;
        return this;
    }

    public OpenStackImageProviderBuilder tenantName(String newTenantName) {
        this.tenantName = newTenantName;
        return this;
    }

    public OpenStackImageProviderBuilder url(String newUrl) {
        this.url = newUrl;
        return this;
    }

    public OpenStackImageProviderBuilder username(String newUsername) {
        this.username = newUsername;
        return this;
    }

    public OpenStackImageProvider build() {
        OpenStackImageProviderContainer container = new OpenStackImageProviderContainer();
        container.authenticationUrl(this.authenticationUrl);
        container.certificates(this.certificates);
        container.comment(this.comment);
        container.description(this.description);
        container.href(this.href);
        container.id(this.id);
        container.images(this.images);
        container.name(this.name);
        container.password(this.password);
        container.properties(this.properties);
        container.requiresAuthentication(this.requiresAuthentication);
        container.tenantName(this.tenantName);
        container.url(this.url);
        container.username(this.username);
        return container;
    }
}

