/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.builders;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.ovirt.engine.sdk4.builders.CertificateBuilder;
import org.ovirt.engine.sdk4.builders.DataCenterBuilder;
import org.ovirt.engine.sdk4.builders.OpenStackVolumeTypeBuilder;
import org.ovirt.engine.sdk4.builders.OpenstackVolumeAuthenticationKeyBuilder;
import org.ovirt.engine.sdk4.builders.PropertyBuilder;
import org.ovirt.engine.sdk4.internal.containers.OpenStackVolumeProviderContainer;
import org.ovirt.engine.sdk4.types.Certificate;
import org.ovirt.engine.sdk4.types.DataCenter;
import org.ovirt.engine.sdk4.types.OpenStackVolumeProvider;
import org.ovirt.engine.sdk4.types.OpenStackVolumeType;
import org.ovirt.engine.sdk4.types.OpenstackVolumeAuthenticationKey;
import org.ovirt.engine.sdk4.types.Property;

public class OpenStackVolumeProviderBuilder {
    private List<OpenstackVolumeAuthenticationKey> authenticationKeys;
    private String authenticationUrl;
    private List<Certificate> certificates;
    private String comment;
    private DataCenter dataCenter;
    private String description;
    private String href;
    private String id;
    private String name;
    private String password;
    private List<Property> properties;
    private Boolean requiresAuthentication;
    private String tenantName;
    private String url;
    private String username;
    private List<OpenStackVolumeType> volumeTypes;

    public OpenStackVolumeProviderBuilder authenticationKeys(List<OpenstackVolumeAuthenticationKey> newAuthenticationKeys) {
        if (newAuthenticationKeys != null) {
            if (this.authenticationKeys == null) {
                this.authenticationKeys = new ArrayList<OpenstackVolumeAuthenticationKey>(newAuthenticationKeys);
            } else {
                this.authenticationKeys.addAll(newAuthenticationKeys);
            }
        }
        return this;
    }

    public OpenStackVolumeProviderBuilder authenticationKeys(OpenstackVolumeAuthenticationKey ... newAuthenticationKeys) {
        if (newAuthenticationKeys != null) {
            if (this.authenticationKeys == null) {
                this.authenticationKeys = new ArrayList<OpenstackVolumeAuthenticationKey>(newAuthenticationKeys.length);
            }
            Collections.addAll(this.authenticationKeys, newAuthenticationKeys);
        }
        return this;
    }

    public OpenStackVolumeProviderBuilder authenticationKeys(OpenstackVolumeAuthenticationKeyBuilder ... newAuthenticationKeys) {
        if (newAuthenticationKeys != null) {
            if (this.authenticationKeys == null) {
                this.authenticationKeys = new ArrayList<OpenstackVolumeAuthenticationKey>(newAuthenticationKeys.length);
            }
            for (OpenstackVolumeAuthenticationKeyBuilder builder : newAuthenticationKeys) {
                this.authenticationKeys.add(builder.build());
            }
        }
        return this;
    }

    public OpenStackVolumeProviderBuilder authenticationUrl(String newAuthenticationUrl) {
        this.authenticationUrl = newAuthenticationUrl;
        return this;
    }

    public OpenStackVolumeProviderBuilder certificates(List<Certificate> newCertificates) {
        if (newCertificates != null) {
            if (this.certificates == null) {
                this.certificates = new ArrayList<Certificate>(newCertificates);
            } else {
                this.certificates.addAll(newCertificates);
            }
        }
        return this;
    }

    public OpenStackVolumeProviderBuilder certificates(Certificate ... newCertificates) {
        if (newCertificates != null) {
            if (this.certificates == null) {
                this.certificates = new ArrayList<Certificate>(newCertificates.length);
            }
            Collections.addAll(this.certificates, newCertificates);
        }
        return this;
    }

    public OpenStackVolumeProviderBuilder certificates(CertificateBuilder ... newCertificates) {
        if (newCertificates != null) {
            if (this.certificates == null) {
                this.certificates = new ArrayList<Certificate>(newCertificates.length);
            }
            for (CertificateBuilder builder : newCertificates) {
                this.certificates.add(builder.build());
            }
        }
        return this;
    }

    public OpenStackVolumeProviderBuilder comment(String newComment) {
        this.comment = newComment;
        return this;
    }

    public OpenStackVolumeProviderBuilder dataCenter(DataCenter newDataCenter) {
        this.dataCenter = newDataCenter;
        return this;
    }

    public OpenStackVolumeProviderBuilder dataCenter(DataCenterBuilder newDataCenter) {
        this.dataCenter = newDataCenter == null ? null : newDataCenter.build();
        return this;
    }

    public OpenStackVolumeProviderBuilder description(String newDescription) {
        this.description = newDescription;
        return this;
    }

    public OpenStackVolumeProviderBuilder href(String newHref) {
        this.href = newHref;
        return this;
    }

    public OpenStackVolumeProviderBuilder id(String newId) {
        this.id = newId;
        return this;
    }

    public OpenStackVolumeProviderBuilder name(String newName) {
        this.name = newName;
        return this;
    }

    public OpenStackVolumeProviderBuilder password(String newPassword) {
        this.password = newPassword;
        return this;
    }

    public OpenStackVolumeProviderBuilder properties(List<Property> newProperties) {
        if (newProperties != null) {
            if (this.properties == null) {
                this.properties = new ArrayList<Property>(newProperties);
            } else {
                this.properties.addAll(newProperties);
            }
        }
        return this;
    }

    public OpenStackVolumeProviderBuilder properties(Property ... newProperties) {
        if (newProperties != null) {
            if (this.properties == null) {
                this.properties = new ArrayList<Property>(newProperties.length);
            }
            Collections.addAll(this.properties, newProperties);
        }
        return this;
    }

    public OpenStackVolumeProviderBuilder properties(PropertyBuilder ... newProperties) {
        if (newProperties != null) {
            if (this.properties == null) {
                this.properties = new ArrayList<Property>(newProperties.length);
            }
            for (PropertyBuilder builder : newProperties) {
                this.properties.add(builder.build());
            }
        }
        return this;
    }

    public OpenStackVolumeProviderBuilder requiresAuthentication(boolean newRequiresAuthentication) {
        this.requiresAuthentication = newRequiresAuthentication;
        return this;
    }

    public OpenStackVolumeProviderBuilder requiresAuthentication(Boolean newRequiresAuthentication) {
        this.requiresAuthentication = newRequiresAuthentication;
        return this;
    }

    public OpenStackVolumeProviderBuilder tenantName(String newTenantName) {
        this.tenantName = newTenantName;
        return this;
    }

    public OpenStackVolumeProviderBuilder url(String newUrl) {
        this.url = newUrl;
        return this;
    }

    public OpenStackVolumeProviderBuilder username(String newUsername) {
        this.username = newUsername;
        return this;
    }

    public OpenStackVolumeProviderBuilder volumeTypes(List<OpenStackVolumeType> newVolumeTypes) {
        if (newVolumeTypes != null) {
            if (this.volumeTypes == null) {
                this.volumeTypes = new ArrayList<OpenStackVolumeType>(newVolumeTypes);
            } else {
                this.volumeTypes.addAll(newVolumeTypes);
            }
        }
        return this;
    }

    public OpenStackVolumeProviderBuilder volumeTypes(OpenStackVolumeType ... newVolumeTypes) {
        if (newVolumeTypes != null) {
            if (this.volumeTypes == null) {
                this.volumeTypes = new ArrayList<OpenStackVolumeType>(newVolumeTypes.length);
            }
            Collections.addAll(this.volumeTypes, newVolumeTypes);
        }
        return this;
    }

    public OpenStackVolumeProviderBuilder volumeTypes(OpenStackVolumeTypeBuilder ... newVolumeTypes) {
        if (newVolumeTypes != null) {
            if (this.volumeTypes == null) {
                this.volumeTypes = new ArrayList<OpenStackVolumeType>(newVolumeTypes.length);
            }
            for (OpenStackVolumeTypeBuilder builder : newVolumeTypes) {
                this.volumeTypes.add(builder.build());
            }
        }
        return this;
    }

    public OpenStackVolumeProvider build() {
        OpenStackVolumeProviderContainer container = new OpenStackVolumeProviderContainer();
        container.authenticationKeys(this.authenticationKeys);
        container.authenticationUrl(this.authenticationUrl);
        container.certificates(this.certificates);
        container.comment(this.comment);
        container.dataCenter(this.dataCenter);
        container.description(this.description);
        container.href(this.href);
        container.id(this.id);
        container.name(this.name);
        container.password(this.password);
        container.properties(this.properties);
        container.requiresAuthentication(this.requiresAuthentication);
        container.tenantName(this.tenantName);
        container.url(this.url);
        container.username(this.username);
        container.volumeTypes(this.volumeTypes);
        return container;
    }
}

