/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.builders;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.ovirt.engine.sdk4.builders.DomainBuilder;
import org.ovirt.engine.sdk4.builders.GroupBuilder;
import org.ovirt.engine.sdk4.builders.PermissionBuilder;
import org.ovirt.engine.sdk4.builders.RoleBuilder;
import org.ovirt.engine.sdk4.builders.SshPublicKeyBuilder;
import org.ovirt.engine.sdk4.builders.TagBuilder;
import org.ovirt.engine.sdk4.internal.containers.UserContainer;
import org.ovirt.engine.sdk4.types.Domain;
import org.ovirt.engine.sdk4.types.Group;
import org.ovirt.engine.sdk4.types.Permission;
import org.ovirt.engine.sdk4.types.Role;
import org.ovirt.engine.sdk4.types.SshPublicKey;
import org.ovirt.engine.sdk4.types.Tag;
import org.ovirt.engine.sdk4.types.User;

public class UserBuilder {
    private String comment;
    private String department;
    private String description;
    private Domain domain;
    private String domainEntryId;
    private String email;
    private List<Group> groups;
    private String href;
    private String id;
    private String lastName;
    private Boolean loggedIn;
    private String name;
    private String namespace;
    private String password;
    private List<Permission> permissions;
    private String principal;
    private List<Role> roles;
    private List<SshPublicKey> sshPublicKeys;
    private List<Tag> tags;
    private String userName;

    public UserBuilder comment(String newComment) {
        this.comment = newComment;
        return this;
    }

    public UserBuilder department(String newDepartment) {
        this.department = newDepartment;
        return this;
    }

    public UserBuilder description(String newDescription) {
        this.description = newDescription;
        return this;
    }

    public UserBuilder domain(Domain newDomain) {
        this.domain = newDomain;
        return this;
    }

    public UserBuilder domain(DomainBuilder newDomain) {
        this.domain = newDomain == null ? null : newDomain.build();
        return this;
    }

    public UserBuilder domainEntryId(String newDomainEntryId) {
        this.domainEntryId = newDomainEntryId;
        return this;
    }

    public UserBuilder email(String newEmail) {
        this.email = newEmail;
        return this;
    }

    public UserBuilder groups(List<Group> newGroups) {
        if (newGroups != null) {
            if (this.groups == null) {
                this.groups = new ArrayList<Group>(newGroups);
            } else {
                this.groups.addAll(newGroups);
            }
        }
        return this;
    }

    public UserBuilder groups(Group ... newGroups) {
        if (newGroups != null) {
            if (this.groups == null) {
                this.groups = new ArrayList<Group>(newGroups.length);
            }
            Collections.addAll(this.groups, newGroups);
        }
        return this;
    }

    public UserBuilder groups(GroupBuilder ... newGroups) {
        if (newGroups != null) {
            if (this.groups == null) {
                this.groups = new ArrayList<Group>(newGroups.length);
            }
            for (GroupBuilder builder : newGroups) {
                this.groups.add(builder.build());
            }
        }
        return this;
    }

    public UserBuilder href(String newHref) {
        this.href = newHref;
        return this;
    }

    public UserBuilder id(String newId) {
        this.id = newId;
        return this;
    }

    public UserBuilder lastName(String newLastName) {
        this.lastName = newLastName;
        return this;
    }

    public UserBuilder loggedIn(boolean newLoggedIn) {
        this.loggedIn = newLoggedIn;
        return this;
    }

    public UserBuilder loggedIn(Boolean newLoggedIn) {
        this.loggedIn = newLoggedIn;
        return this;
    }

    public UserBuilder name(String newName) {
        this.name = newName;
        return this;
    }

    public UserBuilder namespace(String newNamespace) {
        this.namespace = newNamespace;
        return this;
    }

    public UserBuilder password(String newPassword) {
        this.password = newPassword;
        return this;
    }

    public UserBuilder permissions(List<Permission> newPermissions) {
        if (newPermissions != null) {
            if (this.permissions == null) {
                this.permissions = new ArrayList<Permission>(newPermissions);
            } else {
                this.permissions.addAll(newPermissions);
            }
        }
        return this;
    }

    public UserBuilder permissions(Permission ... newPermissions) {
        if (newPermissions != null) {
            if (this.permissions == null) {
                this.permissions = new ArrayList<Permission>(newPermissions.length);
            }
            Collections.addAll(this.permissions, newPermissions);
        }
        return this;
    }

    public UserBuilder permissions(PermissionBuilder ... newPermissions) {
        if (newPermissions != null) {
            if (this.permissions == null) {
                this.permissions = new ArrayList<Permission>(newPermissions.length);
            }
            for (PermissionBuilder builder : newPermissions) {
                this.permissions.add(builder.build());
            }
        }
        return this;
    }

    public UserBuilder principal(String newPrincipal) {
        this.principal = newPrincipal;
        return this;
    }

    public UserBuilder roles(List<Role> newRoles) {
        if (newRoles != null) {
            if (this.roles == null) {
                this.roles = new ArrayList<Role>(newRoles);
            } else {
                this.roles.addAll(newRoles);
            }
        }
        return this;
    }

    public UserBuilder roles(Role ... newRoles) {
        if (newRoles != null) {
            if (this.roles == null) {
                this.roles = new ArrayList<Role>(newRoles.length);
            }
            Collections.addAll(this.roles, newRoles);
        }
        return this;
    }

    public UserBuilder roles(RoleBuilder ... newRoles) {
        if (newRoles != null) {
            if (this.roles == null) {
                this.roles = new ArrayList<Role>(newRoles.length);
            }
            for (RoleBuilder builder : newRoles) {
                this.roles.add(builder.build());
            }
        }
        return this;
    }

    public UserBuilder sshPublicKeys(List<SshPublicKey> newSshPublicKeys) {
        if (newSshPublicKeys != null) {
            if (this.sshPublicKeys == null) {
                this.sshPublicKeys = new ArrayList<SshPublicKey>(newSshPublicKeys);
            } else {
                this.sshPublicKeys.addAll(newSshPublicKeys);
            }
        }
        return this;
    }

    public UserBuilder sshPublicKeys(SshPublicKey ... newSshPublicKeys) {
        if (newSshPublicKeys != null) {
            if (this.sshPublicKeys == null) {
                this.sshPublicKeys = new ArrayList<SshPublicKey>(newSshPublicKeys.length);
            }
            Collections.addAll(this.sshPublicKeys, newSshPublicKeys);
        }
        return this;
    }

    public UserBuilder sshPublicKeys(SshPublicKeyBuilder ... newSshPublicKeys) {
        if (newSshPublicKeys != null) {
            if (this.sshPublicKeys == null) {
                this.sshPublicKeys = new ArrayList<SshPublicKey>(newSshPublicKeys.length);
            }
            for (SshPublicKeyBuilder builder : newSshPublicKeys) {
                this.sshPublicKeys.add(builder.build());
            }
        }
        return this;
    }

    public UserBuilder tags(List<Tag> newTags) {
        if (newTags != null) {
            if (this.tags == null) {
                this.tags = new ArrayList<Tag>(newTags);
            } else {
                this.tags.addAll(newTags);
            }
        }
        return this;
    }

    public UserBuilder tags(Tag ... newTags) {
        if (newTags != null) {
            if (this.tags == null) {
                this.tags = new ArrayList<Tag>(newTags.length);
            }
            Collections.addAll(this.tags, newTags);
        }
        return this;
    }

    public UserBuilder tags(TagBuilder ... newTags) {
        if (newTags != null) {
            if (this.tags == null) {
                this.tags = new ArrayList<Tag>(newTags.length);
            }
            for (TagBuilder builder : newTags) {
                this.tags.add(builder.build());
            }
        }
        return this;
    }

    public UserBuilder userName(String newUserName) {
        this.userName = newUserName;
        return this;
    }

    public User build() {
        UserContainer container = new UserContainer();
        container.comment(this.comment);
        container.department(this.department);
        container.description(this.description);
        container.domain(this.domain);
        container.domainEntryId(this.domainEntryId);
        container.email(this.email);
        container.groups(this.groups);
        container.href(this.href);
        container.id(this.id);
        container.lastName(this.lastName);
        container.loggedIn(this.loggedIn);
        container.name(this.name);
        container.namespace(this.namespace);
        container.password(this.password);
        container.permissions(this.permissions);
        container.principal(this.principal);
        container.roles(this.roles);
        container.sshPublicKeys(this.sshPublicKeys);
        container.tags(this.tags);
        container.userName(this.userName);
        return container;
    }
}

