/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.builders;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.ovirt.engine.sdk4.builders.InstanceTypeBuilder;
import org.ovirt.engine.sdk4.builders.TemplateBuilder;
import org.ovirt.engine.sdk4.builders.VmBuilder;
import org.ovirt.engine.sdk4.internal.containers.WatchdogContainer;
import org.ovirt.engine.sdk4.types.InstanceType;
import org.ovirt.engine.sdk4.types.Template;
import org.ovirt.engine.sdk4.types.Vm;
import org.ovirt.engine.sdk4.types.Watchdog;
import org.ovirt.engine.sdk4.types.WatchdogAction;
import org.ovirt.engine.sdk4.types.WatchdogModel;

public class WatchdogBuilder {
    private WatchdogAction action;
    private String comment;
    private String description;
    private String href;
    private String id;
    private InstanceType instanceType;
    private WatchdogModel model;
    private String name;
    private Template template;
    private Vm vm;
    private List<Vm> vms;

    public WatchdogBuilder action(WatchdogAction newAction) {
        this.action = newAction;
        return this;
    }

    public WatchdogBuilder comment(String newComment) {
        this.comment = newComment;
        return this;
    }

    public WatchdogBuilder description(String newDescription) {
        this.description = newDescription;
        return this;
    }

    public WatchdogBuilder href(String newHref) {
        this.href = newHref;
        return this;
    }

    public WatchdogBuilder id(String newId) {
        this.id = newId;
        return this;
    }

    public WatchdogBuilder instanceType(InstanceType newInstanceType) {
        this.instanceType = newInstanceType;
        return this;
    }

    public WatchdogBuilder instanceType(InstanceTypeBuilder newInstanceType) {
        this.instanceType = newInstanceType == null ? null : newInstanceType.build();
        return this;
    }

    public WatchdogBuilder model(WatchdogModel newModel) {
        this.model = newModel;
        return this;
    }

    public WatchdogBuilder name(String newName) {
        this.name = newName;
        return this;
    }

    public WatchdogBuilder template(Template newTemplate) {
        this.template = newTemplate;
        return this;
    }

    public WatchdogBuilder template(TemplateBuilder newTemplate) {
        this.template = newTemplate == null ? null : newTemplate.build();
        return this;
    }

    public WatchdogBuilder vm(Vm newVm) {
        this.vm = newVm;
        return this;
    }

    public WatchdogBuilder vm(VmBuilder newVm) {
        this.vm = newVm == null ? null : newVm.build();
        return this;
    }

    public WatchdogBuilder vms(List<Vm> newVms) {
        if (newVms != null) {
            if (this.vms == null) {
                this.vms = new ArrayList<Vm>(newVms);
            } else {
                this.vms.addAll(newVms);
            }
        }
        return this;
    }

    public WatchdogBuilder vms(Vm ... newVms) {
        if (newVms != null) {
            if (this.vms == null) {
                this.vms = new ArrayList<Vm>(newVms.length);
            }
            Collections.addAll(this.vms, newVms);
        }
        return this;
    }

    public WatchdogBuilder vms(VmBuilder ... newVms) {
        if (newVms != null) {
            if (this.vms == null) {
                this.vms = new ArrayList<Vm>(newVms.length);
            }
            for (VmBuilder builder : newVms) {
                this.vms.add(builder.build());
            }
        }
        return this;
    }

    public Watchdog build() {
        WatchdogContainer container = new WatchdogContainer();
        container.action(this.action);
        container.comment(this.comment);
        container.description(this.description);
        container.href(this.href);
        container.id(this.id);
        container.instanceType(this.instanceType);
        container.model(this.model);
        container.name(this.name);
        container.template(this.template);
        container.vm(this.vm);
        container.vms(this.vms);
        return container;
    }
}

