/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.ovirt.api.metamodel.runtime.util.ListWithHref;
import org.ovirt.engine.sdk4.Connection;
import org.ovirt.engine.sdk4.Error;
import org.ovirt.engine.sdk4.HttpClient;
import org.ovirt.engine.sdk4.Service;
import org.ovirt.engine.sdk4.internal.SsoUtils;
import org.ovirt.engine.sdk4.internal.services.SystemServiceImpl;
import org.ovirt.engine.sdk4.services.SystemService;
import org.ovirt.engine.sdk4.types.Identified;

public class HttpConnection
implements Connection {
    private HttpClient client;
    private String url;
    private String user;
    private String password;
    private boolean kerberos;
    private String ssoToken = null;
    private String ssoTokenName = null;
    private String ssoUrl = null;
    private String ssoRevokeUrl = null;

    public HttpClient getClient() {
        return this.client;
    }

    public void setClient(HttpClient client) {
        this.client = client;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getSsoUrl() {
        return this.ssoUrl;
    }

    public void setSsoUrl(String ssoUrl) {
        this.ssoUrl = ssoUrl;
    }

    public String getSsoTokenName() {
        return this.ssoTokenName;
    }

    public void setSsoTokenName(String ssoTokenName) {
        this.ssoTokenName = ssoTokenName;
    }

    public void setKerberos(boolean kerberos) {
        this.kerberos = kerberos;
    }

    public String getSsoRevokeUrl() {
        return this.ssoRevokeUrl;
    }

    public void setSsoRevokeUrl(String ssoRevokeUrl) {
        this.ssoRevokeUrl = ssoRevokeUrl;
    }

    public void setSsoToken(String ssoToken) {
        this.ssoToken = ssoToken;
    }

    @Override
    public SystemService systemService() {
        return new SystemServiceImpl(this, "");
    }

    private String getHref(Object object) {
        if (object instanceof Identified) {
            return ((Identified)object).href();
        }
        if (object instanceof ListWithHref) {
            return ((ListWithHref)object).href();
        }
        return null;
    }

    @Override
    public boolean isLink(Object object) {
        return this.getHref(object) != null;
    }

    @Override
    public <TYPE> TYPE followLink(TYPE object) {
        if (!this.isLink(object)) {
            throw new Error("Can't follow link because object don't have any");
        }
        String href = this.getHref(object);
        if (href == null) {
            throw new Error("Can't follow link because the 'href' attribute does't have a value");
        }
        try {
            URL url = new URL(this.getUrl());
            String prefix = url.getPath();
            if (!prefix.endsWith("/")) {
                prefix = prefix + "/";
            }
            if (!href.startsWith(prefix)) {
                throw new Error("The URL '" + href + "' isn't compatible with the base URL of the connection");
            }
            String path = href.substring(prefix.length());
            Service service = this.systemService().service(path);
            Method get = object instanceof ListWithHref ? service.getClass().getMethod("list", new Class[0]) : service.getClass().getMethod("get", new Class[0]);
            Object getRequest = get.invoke((Object)service, new Object[0]);
            Method send = getRequest.getClass().getMethod("send", new Class[0]);
            send.setAccessible(true);
            Object getResponse = send.invoke(getRequest, new Object[0]);
            Method obtainObject = getResponse.getClass().getDeclaredMethods()[0];
            obtainObject.setAccessible(true);
            return (TYPE)obtainObject.invoke(getResponse, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
            throw new Error(String.format("Unexpected error while following link \"%1$s\"", href), ex);
        }
        catch (MalformedURLException ex) {
            throw new Error(String.format("Error while creating URL \"%1$s\"", this.getUrl()), ex);
        }
    }

    @Override
    public void close() throws Exception {
        this.close(true);
    }

    @Override
    public void close(boolean logout) throws Exception {
        if (logout) {
            this.revokeAccessToken();
        }
        if (this.client != null) {
            this.client.close();
        }
    }

    public HttpResponse send(HttpUriRequest request) {
        try {
            this.injectHeaders(request);
            return this.client.execute(request);
        }
        catch (Exception e) {
            throw new Error("Failed to send request", e);
        }
    }

    @Override
    public String authenticate() {
        if (this.ssoToken == null) {
            this.ssoToken = this.getAccessToken();
        }
        return this.ssoToken;
    }

    private void injectHeaders(HttpUriRequest request) {
        List<Header> updated = this.excludeNullHeaders(request.getAllHeaders());
        if (updated != null && !updated.isEmpty()) {
            request.setHeaders(updated.toArray(new Header[updated.size()]));
        }
        for (NameValuePair nameValuePair : URLEncodedUtils.parse((URI)request.getURI(), (String)"UTF-8")) {
            if (!nameValuePair.getName().equalsIgnoreCase("all_content")) continue;
            request.addHeader("All-Content", nameValuePair.getValue());
        }
        request.addHeader("Version", "4");
        request.addHeader("Content-type", "application/xml");
        request.addHeader("User-Agent", "JavaSDK");
        request.addHeader("Accept", "application/xml");
        request.addHeader("Authorization", "Bearer " + this.getAccessToken());
    }

    private List<Header> excludeNullHeaders(Header[] headers) {
        if (headers != null && headers.length > 0) {
            ArrayList<Header> updated = new ArrayList<Header>();
            for (Header header : headers) {
                if (header.getValue() == null) continue;
                updated.add(header);
            }
            return updated;
        }
        return null;
    }

    private String getAccessToken() {
        if (this.ssoToken == null) {
            URI ssoURI = this.ssoUrl != null ? SsoUtils.buildUrl(this.ssoUrl) : (this.kerberos ? SsoUtils.buildSsoUrlKerberos(this.url) : SsoUtils.buildSsoUrlBasic(this.url));
            ArrayList<NameValuePair> params = new ArrayList<NameValuePair>(4);
            params.add((NameValuePair)new BasicNameValuePair("scope", "ovirt-app-api"));
            if (this.kerberos) {
                params.add((NameValuePair)new BasicNameValuePair("grant_type", "urn:ovirt:params:oauth:grant-type:http"));
            } else {
                params.add((NameValuePair)new BasicNameValuePair("username", this.user));
                params.add((NameValuePair)new BasicNameValuePair("password", this.password));
                params.add((NameValuePair)new BasicNameValuePair("grant_type", "password"));
            }
            JsonNode node = this.getSsoResponse(ssoURI, params);
            if (node.isArray()) {
                node = node.get(0);
            }
            if (node.get("error") != null) {
                throw new Error(String.format("Error during SSO authentication %1$s : %2$s", node.get("error_code"), node.get("error")));
            }
            this.ssoToken = node.get(this.ssoTokenName).getTextValue();
        }
        return this.ssoToken;
    }

    private void revokeAccessToken() {
        URI ssoRevokeURI = this.ssoRevokeUrl != null ? SsoUtils.buildUrl(this.ssoRevokeUrl) : (this.ssoToken != null ? SsoUtils.buildSsoRevokeUrl(this.url) : null);
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>(2);
        params.add((NameValuePair)new BasicNameValuePair("scope", "ovirt-app-api"));
        params.add((NameValuePair)new BasicNameValuePair("token", this.ssoToken));
        if (ssoRevokeURI != null) {
            JsonNode node = this.getSsoResponse(ssoRevokeURI, params);
            if (node.isArray()) {
                node = node.get(0);
            }
            if (node.get("error") != null) {
                throw new Error(String.format("Error during SSO token revoke %1$s : %2$s", node.get("error_code"), node.get("error")));
            }
        }
    }

    private JsonNode getSsoResponse(URI uri, List<NameValuePair> params) {
        HttpResponse response = null;
        try {
            HttpPost requestToken = new HttpPost(uri);
            requestToken.addHeader("User-Agent", "JavaSDK");
            requestToken.addHeader("Accept", "application/json");
            requestToken.setEntity((HttpEntity)new UrlEncodedFormEntity(params));
            response = this.client.execute((HttpUriRequest)requestToken);
            ObjectMapper mapper = new ObjectMapper();
            JsonNode jsonNode = mapper.readTree(response.getEntity().getContent());
            return jsonNode;
        }
        catch (IOException ex) {
            throw new Error("Failed to parse JSON response", ex);
        }
        catch (Exception ex) {
            throw new Error("Failed to send SSO request", ex);
        }
        finally {
            if (response != null) {
                EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
            }
        }
    }
}

