/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.types;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum VmStatus {
    UNASSIGNED,
    DOWN,
    UP,
    POWERING_UP,
    PAUSED,
    MIGRATING,
    UNKNOWN,
    NOT_RESPONDING,
    WAIT_FOR_LAUNCH,
    REBOOT_IN_PROGRESS,
    SAVING_STATE,
    RESTORING_STATE,
    SUSPENDED,
    IMAGE_LOCKED,
    POWERING_DOWN;

    private static final Logger LOG;

    public String value() {
        return this.name().toLowerCase();
    }

    public static VmStatus fromValue(String value) {
        try {
            return VmStatus.valueOf(value.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            LOG.error("The string '" + value + "' isn't a valid value for the 'VmStatus' enumerated type. Valid values are: 'unassigned', 'down', 'up', 'powering_up', 'paused', 'migrating', 'unknown', 'not_responding', 'wait_for_launch', 'reboot_in_progress', 'saving_state', 'restoring_state', 'suspended', 'image_locked', 'powering_down'.");
            return null;
        }
    }

    static {
        LOG = LoggerFactory.getLogger(VmStatus.class);
    }
}

