/*
Copyright (c) 2015 Red Hat, Inc.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.ovirt.engine.sdk4.types;

import java.math.BigInteger;

public interface Qos extends Identified {
    BigInteger cpuLimit();
    
    boolean cpuLimitPresent();
    
    BigInteger inboundAverage();
    
    boolean inboundAveragePresent();
    
    BigInteger inboundBurst();
    
    boolean inboundBurstPresent();
    
    BigInteger inboundPeak();
    
    boolean inboundPeakPresent();
    
    BigInteger maxIops();
    
    boolean maxIopsPresent();
    
    BigInteger maxReadIops();
    
    boolean maxReadIopsPresent();
    
    BigInteger maxReadThroughput();
    
    boolean maxReadThroughputPresent();
    
    BigInteger maxThroughput();
    
    boolean maxThroughputPresent();
    
    BigInteger maxWriteIops();
    
    boolean maxWriteIopsPresent();
    
    BigInteger maxWriteThroughput();
    
    boolean maxWriteThroughputPresent();
    
    BigInteger outboundAverage();
    
    boolean outboundAveragePresent();
    
    BigInteger outboundAverageLinkshare();
    
    boolean outboundAverageLinksharePresent();
    
    BigInteger outboundAverageRealtime();
    
    boolean outboundAverageRealtimePresent();
    
    BigInteger outboundAverageUpperlimit();
    
    boolean outboundAverageUpperlimitPresent();
    
    BigInteger outboundBurst();
    
    boolean outboundBurstPresent();
    
    BigInteger outboundPeak();
    
    boolean outboundPeakPresent();
    
    QosType type();
    
    boolean typePresent();
    
    DataCenter dataCenter();
    
    boolean dataCenterPresent();
    
}
