/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.builders;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.ovirt.engine.sdk4.builders.PropertyBuilder;
import org.ovirt.engine.sdk4.internal.containers.OpenStackProviderContainer;
import org.ovirt.engine.sdk4.types.OpenStackProvider;
import org.ovirt.engine.sdk4.types.Property;

public class OpenStackProviderBuilder {
    private String authenticationUrl;
    private String comment;
    private String description;
    private String href;
    private String id;
    private String name;
    private String password;
    private List<Property> properties;
    private Boolean requiresAuthentication;
    private String tenantName;
    private String url;
    private String username;

    public OpenStackProviderBuilder authenticationUrl(String newAuthenticationUrl) {
        this.authenticationUrl = newAuthenticationUrl;
        return this;
    }

    public OpenStackProviderBuilder comment(String newComment) {
        this.comment = newComment;
        return this;
    }

    public OpenStackProviderBuilder description(String newDescription) {
        this.description = newDescription;
        return this;
    }

    public OpenStackProviderBuilder href(String newHref) {
        this.href = newHref;
        return this;
    }

    public OpenStackProviderBuilder id(String newId) {
        this.id = newId;
        return this;
    }

    public OpenStackProviderBuilder name(String newName) {
        this.name = newName;
        return this;
    }

    public OpenStackProviderBuilder password(String newPassword) {
        this.password = newPassword;
        return this;
    }

    public OpenStackProviderBuilder properties(List<Property> newProperties) {
        if (newProperties != null) {
            if (this.properties == null) {
                this.properties = new ArrayList<Property>(newProperties);
            } else {
                this.properties.addAll(newProperties);
            }
        }
        return this;
    }

    public OpenStackProviderBuilder properties(Property ... newProperties) {
        if (newProperties != null) {
            if (this.properties == null) {
                this.properties = new ArrayList<Property>(newProperties.length);
            }
            Collections.addAll(this.properties, newProperties);
        }
        return this;
    }

    public OpenStackProviderBuilder properties(PropertyBuilder ... newProperties) {
        if (newProperties != null) {
            if (this.properties == null) {
                this.properties = new ArrayList<Property>(newProperties.length);
            }
            for (PropertyBuilder builder : newProperties) {
                this.properties.add(builder.build());
            }
        }
        return this;
    }

    public OpenStackProviderBuilder requiresAuthentication(boolean newRequiresAuthentication) {
        this.requiresAuthentication = newRequiresAuthentication;
        return this;
    }

    public OpenStackProviderBuilder requiresAuthentication(Boolean newRequiresAuthentication) {
        this.requiresAuthentication = newRequiresAuthentication;
        return this;
    }

    public OpenStackProviderBuilder tenantName(String newTenantName) {
        this.tenantName = newTenantName;
        return this;
    }

    public OpenStackProviderBuilder url(String newUrl) {
        this.url = newUrl;
        return this;
    }

    public OpenStackProviderBuilder username(String newUsername) {
        this.username = newUsername;
        return this;
    }

    public OpenStackProvider build() {
        OpenStackProviderContainer container = new OpenStackProviderContainer();
        container.authenticationUrl(this.authenticationUrl);
        container.comment(this.comment);
        container.description(this.description);
        container.href(this.href);
        container.id(this.id);
        container.name(this.name);
        container.password(this.password);
        container.properties(this.properties);
        container.requiresAuthentication(this.requiresAuthentication);
        container.tenantName(this.tenantName);
        container.url(this.url);
        container.username(this.username);
        return container;
    }
}

