/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.builders;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.ovirt.engine.sdk4.builders.HostNicBuilder;
import org.ovirt.engine.sdk4.builders.MacBuilder;
import org.ovirt.engine.sdk4.builders.OptionBuilder;
import org.ovirt.engine.sdk4.internal.containers.BondingContainer;
import org.ovirt.engine.sdk4.types.Bonding;
import org.ovirt.engine.sdk4.types.HostNic;
import org.ovirt.engine.sdk4.types.Mac;
import org.ovirt.engine.sdk4.types.Option;

public class BondingBuilder {
    private HostNic activeSlave;
    private Mac adPartnerMac;
    private List<Option> options;
    private List<HostNic> slaves;

    public BondingBuilder activeSlave(HostNic newActiveSlave) {
        this.activeSlave = newActiveSlave;
        return this;
    }

    public BondingBuilder activeSlave(HostNicBuilder newActiveSlave) {
        this.activeSlave = newActiveSlave == null ? null : newActiveSlave.build();
        return this;
    }

    public BondingBuilder adPartnerMac(Mac newAdPartnerMac) {
        this.adPartnerMac = newAdPartnerMac;
        return this;
    }

    public BondingBuilder adPartnerMac(MacBuilder newAdPartnerMac) {
        this.adPartnerMac = newAdPartnerMac == null ? null : newAdPartnerMac.build();
        return this;
    }

    public BondingBuilder options(List<Option> newOptions) {
        if (newOptions != null) {
            if (this.options == null) {
                this.options = new ArrayList<Option>(newOptions);
            } else {
                this.options.addAll(newOptions);
            }
        }
        return this;
    }

    public BondingBuilder options(Option ... newOptions) {
        if (newOptions != null) {
            if (this.options == null) {
                this.options = new ArrayList<Option>(newOptions.length);
            }
            Collections.addAll(this.options, newOptions);
        }
        return this;
    }

    public BondingBuilder options(OptionBuilder ... newOptions) {
        if (newOptions != null) {
            if (this.options == null) {
                this.options = new ArrayList<Option>(newOptions.length);
            }
            for (OptionBuilder builder : newOptions) {
                this.options.add(builder.build());
            }
        }
        return this;
    }

    public BondingBuilder slaves(List<HostNic> newSlaves) {
        if (newSlaves != null) {
            if (this.slaves == null) {
                this.slaves = new ArrayList<HostNic>(newSlaves);
            } else {
                this.slaves.addAll(newSlaves);
            }
        }
        return this;
    }

    public BondingBuilder slaves(HostNic ... newSlaves) {
        if (newSlaves != null) {
            if (this.slaves == null) {
                this.slaves = new ArrayList<HostNic>(newSlaves.length);
            }
            Collections.addAll(this.slaves, newSlaves);
        }
        return this;
    }

    public BondingBuilder slaves(HostNicBuilder ... newSlaves) {
        if (newSlaves != null) {
            if (this.slaves == null) {
                this.slaves = new ArrayList<HostNic>(newSlaves.length);
            }
            for (HostNicBuilder builder : newSlaves) {
                this.slaves.add(builder.build());
            }
        }
        return this;
    }

    public Bonding build() {
        BondingContainer container = new BondingContainer();
        container.activeSlave(this.activeSlave);
        container.adPartnerMac(this.adPartnerMac);
        container.options(this.options);
        container.slaves(this.slaves);
        return container;
    }
}

