/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.xml;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.ovirt.api.metamodel.runtime.util.ArrayListWithHref;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.engine.sdk4.internal.containers.CdromContainer;
import org.ovirt.engine.sdk4.internal.xml.XmlFileReader;
import org.ovirt.engine.sdk4.internal.xml.XmlInstanceTypeReader;
import org.ovirt.engine.sdk4.internal.xml.XmlTemplateReader;
import org.ovirt.engine.sdk4.internal.xml.XmlVmReader;
import org.ovirt.engine.sdk4.types.Cdrom;
import org.ovirt.engine.sdk4.types.Vm;

public class XmlCdromReader {
    public static Cdrom readOne(XmlReader reader) {
        String name;
        if (!reader.forward()) {
            return null;
        }
        CdromContainer object = new CdromContainer();
        block30: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            name = reader.getAttributeLocalName(i);
            String image = reader.getAttributeValue(i);
            switch (name) {
                case "href": {
                    object.href(image);
                    continue block30;
                }
                case "id": {
                    object.id(image);
                    continue block30;
                }
            }
        }
        ArrayList<String[]> links = new ArrayList<String[]>();
        reader.next();
        block31: while (reader.forward()) {
            switch (name = reader.getLocalName()) {
                case "comment": {
                    object.comment(reader.readString());
                    continue block31;
                }
                case "description": {
                    object.description(reader.readString());
                    continue block31;
                }
                case "file": {
                    object.file(XmlFileReader.readOne(reader));
                    continue block31;
                }
                case "instance_type": {
                    object.instanceType(XmlInstanceTypeReader.readOne(reader));
                    continue block31;
                }
                case "name": {
                    object.name(reader.readString());
                    continue block31;
                }
                case "template": {
                    object.template(XmlTemplateReader.readOne(reader));
                    continue block31;
                }
                case "vm": {
                    object.vm(XmlVmReader.readOne(reader));
                    continue block31;
                }
                case "vms": {
                    object.vms(XmlVmReader.readMany(reader));
                    continue block31;
                }
                case "link": {
                    String rel = reader.getAttributeValue("rel");
                    String href = reader.getAttributeValue("href");
                    if (rel != null && href != null) {
                        links.add(new String[]{rel, href});
                    }
                    reader.next();
                    continue block31;
                }
            }
            reader.skip();
        }
        if (links != null) {
            for (String[] link : links) {
                XmlCdromReader.processLink(object, link);
            }
        }
        reader.next();
        return object;
    }

    public static Iterator<Cdrom> iterateMany(final XmlReader reader) {
        return new Iterator<Cdrom>(){
            private boolean first = true;

            @Override
            public void remove() {
            }

            @Override
            public boolean hasNext() {
                if (this.first) {
                    if (!reader.forward()) {
                        return false;
                    }
                    reader.next();
                    this.first = false;
                }
                if (!reader.forward()) {
                    reader.next();
                    return false;
                }
                return true;
            }

            @Override
            public Cdrom next() {
                Cdrom next = XmlCdromReader.readOne(reader);
                if (next == null) {
                    throw new NoSuchElementException();
                }
                return next;
            }
        };
    }

    public static List<Cdrom> readMany(XmlReader reader) {
        ArrayList<Cdrom> list = new ArrayList<Cdrom>();
        Iterator<Cdrom> iterator = XmlCdromReader.iterateMany(reader);
        while (iterator.hasNext()) {
            list.add(iterator.next());
        }
        return list;
    }

    private static void processLink(CdromContainer object, String[] link) {
        String rel = link[0];
        String href = link[1];
        if (href != null) {
            switch (rel) {
                case "vms": {
                    ArrayListWithHref<Vm> list = new ArrayListWithHref<Vm>(object.vms());
                    list.href(href);
                    object.vms(list);
                    break;
                }
            }
        }
    }
}

