/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.xml;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.ovirt.api.metamodel.runtime.util.ArrayListWithHref;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.engine.sdk4.internal.containers.StorageDomainContainer;
import org.ovirt.engine.sdk4.internal.xml.XmlDataCenterReader;
import org.ovirt.engine.sdk4.internal.xml.XmlDiskProfileReader;
import org.ovirt.engine.sdk4.internal.xml.XmlDiskReader;
import org.ovirt.engine.sdk4.internal.xml.XmlDiskSnapshotReader;
import org.ovirt.engine.sdk4.internal.xml.XmlExternalStatusReader;
import org.ovirt.engine.sdk4.internal.xml.XmlFileReader;
import org.ovirt.engine.sdk4.internal.xml.XmlHostReader;
import org.ovirt.engine.sdk4.internal.xml.XmlHostStorageReader;
import org.ovirt.engine.sdk4.internal.xml.XmlImageReader;
import org.ovirt.engine.sdk4.internal.xml.XmlPermissionReader;
import org.ovirt.engine.sdk4.internal.xml.XmlStorageConnectionReader;
import org.ovirt.engine.sdk4.internal.xml.XmlStorageDomainStatusReader;
import org.ovirt.engine.sdk4.internal.xml.XmlStorageDomainTypeReader;
import org.ovirt.engine.sdk4.internal.xml.XmlStorageFormatReader;
import org.ovirt.engine.sdk4.internal.xml.XmlTemplateReader;
import org.ovirt.engine.sdk4.internal.xml.XmlVmReader;
import org.ovirt.engine.sdk4.types.DataCenter;
import org.ovirt.engine.sdk4.types.Disk;
import org.ovirt.engine.sdk4.types.DiskProfile;
import org.ovirt.engine.sdk4.types.DiskSnapshot;
import org.ovirt.engine.sdk4.types.File;
import org.ovirt.engine.sdk4.types.Image;
import org.ovirt.engine.sdk4.types.Permission;
import org.ovirt.engine.sdk4.types.StorageConnection;
import org.ovirt.engine.sdk4.types.StorageDomain;
import org.ovirt.engine.sdk4.types.Template;
import org.ovirt.engine.sdk4.types.Vm;

public class XmlStorageDomainReader {
    public static StorageDomain readOne(XmlReader reader) {
        String name;
        if (!reader.forward()) {
            return null;
        }
        StorageDomainContainer object = new StorageDomainContainer();
        block76: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            name = reader.getAttributeLocalName(i);
            String image = reader.getAttributeValue(i);
            switch (name) {
                case "href": {
                    object.href(image);
                    continue block76;
                }
                case "id": {
                    object.id(image);
                    continue block76;
                }
            }
        }
        ArrayList<String[]> links = new ArrayList<String[]>();
        reader.next();
        block77: while (reader.forward()) {
            switch (name = reader.getLocalName()) {
                case "available": {
                    object.available(reader.readInteger());
                    continue block77;
                }
                case "comment": {
                    object.comment(reader.readString());
                    continue block77;
                }
                case "committed": {
                    object.committed(reader.readInteger());
                    continue block77;
                }
                case "critical_space_action_blocker": {
                    object.criticalSpaceActionBlocker(reader.readInteger());
                    continue block77;
                }
                case "data_center": {
                    object.dataCenter(XmlDataCenterReader.readOne(reader));
                    continue block77;
                }
                case "data_centers": {
                    object.dataCenters(XmlDataCenterReader.readMany(reader));
                    continue block77;
                }
                case "description": {
                    object.description(reader.readString());
                    continue block77;
                }
                case "discard_after_delete": {
                    object.discardAfterDelete(reader.readBoolean());
                    continue block77;
                }
                case "disk_profiles": {
                    object.diskProfiles(XmlDiskProfileReader.readMany(reader));
                    continue block77;
                }
                case "disk_snapshots": {
                    object.diskSnapshots(XmlDiskSnapshotReader.readMany(reader));
                    continue block77;
                }
                case "disks": {
                    object.disks(XmlDiskReader.readMany(reader));
                    continue block77;
                }
                case "external_status": {
                    object.externalStatus(XmlExternalStatusReader.readOne(reader));
                    continue block77;
                }
                case "files": {
                    object.files(XmlFileReader.readMany(reader));
                    continue block77;
                }
                case "host": {
                    object.host(XmlHostReader.readOne(reader));
                    continue block77;
                }
                case "images": {
                    object.images(XmlImageReader.readMany(reader));
                    continue block77;
                }
                case "import": {
                    object.import_(reader.readBoolean());
                    continue block77;
                }
                case "master": {
                    object.master(reader.readBoolean());
                    continue block77;
                }
                case "name": {
                    object.name(reader.readString());
                    continue block77;
                }
                case "permissions": {
                    object.permissions(XmlPermissionReader.readMany(reader));
                    continue block77;
                }
                case "status": {
                    object.status(XmlStorageDomainStatusReader.readOne(reader));
                    continue block77;
                }
                case "storage": {
                    object.storage(XmlHostStorageReader.readOne(reader));
                    continue block77;
                }
                case "storage_connections": {
                    object.storageConnections(XmlStorageConnectionReader.readMany(reader));
                    continue block77;
                }
                case "storage_format": {
                    object.storageFormat(XmlStorageFormatReader.readOne(reader));
                    continue block77;
                }
                case "supports_discard": {
                    object.supportsDiscard(reader.readBoolean());
                    continue block77;
                }
                case "supports_discard_zeroes_data": {
                    object.supportsDiscardZeroesData(reader.readBoolean());
                    continue block77;
                }
                case "templates": {
                    object.templates(XmlTemplateReader.readMany(reader));
                    continue block77;
                }
                case "type": {
                    object.type(XmlStorageDomainTypeReader.readOne(reader));
                    continue block77;
                }
                case "used": {
                    object.used(reader.readInteger());
                    continue block77;
                }
                case "vms": {
                    object.vms(XmlVmReader.readMany(reader));
                    continue block77;
                }
                case "warning_low_space_indicator": {
                    object.warningLowSpaceIndicator(reader.readInteger());
                    continue block77;
                }
                case "wipe_after_delete": {
                    object.wipeAfterDelete(reader.readBoolean());
                    continue block77;
                }
                case "link": {
                    String rel = reader.getAttributeValue("rel");
                    String href = reader.getAttributeValue("href");
                    if (rel != null && href != null) {
                        links.add(new String[]{rel, href});
                    }
                    reader.next();
                    continue block77;
                }
            }
            reader.skip();
        }
        if (links != null) {
            for (String[] link : links) {
                XmlStorageDomainReader.processLink(object, link);
            }
        }
        reader.next();
        return object;
    }

    public static Iterator<StorageDomain> iterateMany(final XmlReader reader) {
        return new Iterator<StorageDomain>(){
            private boolean first = true;

            @Override
            public void remove() {
            }

            @Override
            public boolean hasNext() {
                if (this.first) {
                    if (!reader.forward()) {
                        return false;
                    }
                    reader.next();
                    this.first = false;
                }
                if (!reader.forward()) {
                    reader.next();
                    return false;
                }
                return true;
            }

            @Override
            public StorageDomain next() {
                StorageDomain next = XmlStorageDomainReader.readOne(reader);
                if (next == null) {
                    throw new NoSuchElementException();
                }
                return next;
            }
        };
    }

    public static List<StorageDomain> readMany(XmlReader reader) {
        ArrayList<StorageDomain> list = new ArrayList<StorageDomain>();
        Iterator<StorageDomain> iterator = XmlStorageDomainReader.iterateMany(reader);
        while (iterator.hasNext()) {
            list.add(iterator.next());
        }
        return list;
    }

    private static void processLink(StorageDomainContainer object, String[] link) {
        String rel = link[0];
        String href = link[1];
        if (href != null) {
            switch (rel) {
                case "datacenters": {
                    ArrayListWithHref<DataCenter> list = new ArrayListWithHref<DataCenter>(object.dataCenters());
                    list.href(href);
                    object.dataCenters(list);
                    break;
                }
                case "diskprofiles": {
                    ArrayListWithHref<DiskProfile> list = new ArrayListWithHref<DiskProfile>(object.diskProfiles());
                    list.href(href);
                    object.diskProfiles(list);
                    break;
                }
                case "disksnapshots": {
                    ArrayListWithHref<DiskSnapshot> list = new ArrayListWithHref<DiskSnapshot>(object.diskSnapshots());
                    list.href(href);
                    object.diskSnapshots(list);
                    break;
                }
                case "disks": {
                    ArrayListWithHref<Disk> list = new ArrayListWithHref<Disk>(object.disks());
                    list.href(href);
                    object.disks(list);
                    break;
                }
                case "files": {
                    ArrayListWithHref<File> list = new ArrayListWithHref<File>(object.files());
                    list.href(href);
                    object.files(list);
                    break;
                }
                case "images": {
                    ArrayListWithHref<Image> list = new ArrayListWithHref<Image>(object.images());
                    list.href(href);
                    object.images(list);
                    break;
                }
                case "permissions": {
                    ArrayListWithHref<Permission> list = new ArrayListWithHref<Permission>(object.permissions());
                    list.href(href);
                    object.permissions(list);
                    break;
                }
                case "storageconnections": {
                    ArrayListWithHref<StorageConnection> list = new ArrayListWithHref<StorageConnection>(object.storageConnections());
                    list.href(href);
                    object.storageConnections(list);
                    break;
                }
                case "templates": {
                    ArrayListWithHref<Template> list = new ArrayListWithHref<Template>(object.templates());
                    list.href(href);
                    object.templates(list);
                    break;
                }
                case "vms": {
                    ArrayListWithHref<Vm> list = new ArrayListWithHref<Vm>(object.vms());
                    list.href(href);
                    object.vms(list);
                    break;
                }
            }
        }
    }
}

