/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.types;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum ValueType {
    DECIMAL,
    INTEGER,
    STRING;

    private static final Logger LOG;

    public String value() {
        return this.name().toLowerCase();
    }

    public static ValueType fromValue(String value) {
        try {
            return ValueType.valueOf(value.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            LOG.error("The string '" + value + "' isn't a valid value for the 'ValueType' enumerated type. Valid values are: 'decimal', 'integer', 'string'.");
            return null;
        }
    }

    static {
        LOG = LoggerFactory.getLogger(ValueType.class);
    }
}

