/*
Copyright (c) 2015 Red Hat, Inc.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.ovirt.engine.sdk4.services;

import java.io.IOException;
import org.ovirt.engine.sdk4.Request;
import org.ovirt.engine.sdk4.Response;
import org.ovirt.engine.sdk4.Service;
import org.ovirt.engine.sdk4.types.StorageDomain;

public interface AttachedStorageDomainService extends Service {
    /**
     * This operation activates an attached storage domain.
     * Once the storage domain is activated it is ready for use with the data center.
     * 
     * [source]
     * ----
     * POST /ovirt-engine/api/datacenters/123/storagedomains/456/activate
     * ----
     * 
     * The activate action does not take any action specific parameters,
     * so the request body should contain an empty `action`:
     * 
     * [source,xml]
     * ----
     * <action/>
     * ----
     */
    public interface ActivateRequest extends Request<ActivateRequest, ActivateResponse> {
        /**
         * Indicates if the activation should be performed asynchronously.
         */
        ActivateRequest async(Boolean async);
    }
    
    /**
     * This operation activates an attached storage domain.
     * Once the storage domain is activated it is ready for use with the data center.
     * 
     * [source]
     * ----
     * POST /ovirt-engine/api/datacenters/123/storagedomains/456/activate
     * ----
     * 
     * The activate action does not take any action specific parameters,
     * so the request body should contain an empty `action`:
     * 
     * [source,xml]
     * ----
     * <action/>
     * ----
     */
    public interface ActivateResponse extends Response {
    }
    
    /**
     * This operation activates an attached storage domain.
     * Once the storage domain is activated it is ready for use with the data center.
     * 
     * [source]
     * ----
     * POST /ovirt-engine/api/datacenters/123/storagedomains/456/activate
     * ----
     * 
     * The activate action does not take any action specific parameters,
     * so the request body should contain an empty `action`:
     * 
     * [source,xml]
     * ----
     * <action/>
     * ----
     */
    ActivateRequest activate();
    
    /**
     * This operation deactivates an attached storage domain.
     * Once the storage domain is deactivated it will not be used with the data center.
     * 
     * [source]
     * ----
     * POST /ovirt-engine/api/datacenters/123/storagedomains/456/deactivate
     * ----
     * 
     * The deactivate action does not take any action specific parameters,
     * so the request body should contain an empty `action`:
     * 
     * [source,xml]
     * ----
     * <action/>
     * ----
     */
    public interface DeactivateRequest extends Request<DeactivateRequest, DeactivateResponse> {
        /**
         * Indicates if the deactivation should be performed asynchronously.
         */
        DeactivateRequest async(Boolean async);
    }
    
    /**
     * This operation deactivates an attached storage domain.
     * Once the storage domain is deactivated it will not be used with the data center.
     * 
     * [source]
     * ----
     * POST /ovirt-engine/api/datacenters/123/storagedomains/456/deactivate
     * ----
     * 
     * The deactivate action does not take any action specific parameters,
     * so the request body should contain an empty `action`:
     * 
     * [source,xml]
     * ----
     * <action/>
     * ----
     */
    public interface DeactivateResponse extends Response {
    }
    
    /**
     * This operation deactivates an attached storage domain.
     * Once the storage domain is deactivated it will not be used with the data center.
     * 
     * [source]
     * ----
     * POST /ovirt-engine/api/datacenters/123/storagedomains/456/deactivate
     * ----
     * 
     * The deactivate action does not take any action specific parameters,
     * so the request body should contain an empty `action`:
     * 
     * [source,xml]
     * ----
     * <action/>
     * ----
     */
    DeactivateRequest deactivate();
    
    public interface GetRequest extends Request<GetRequest, GetResponse> {
    }
    
    public interface GetResponse extends Response {
        StorageDomain storageDomain();
    }
    
    GetRequest get();
    
    public interface RemoveRequest extends Request<RemoveRequest, RemoveResponse> {
        /**
         * Indicates if the remove should be performed asynchronously.
         */
        RemoveRequest async(Boolean async);
    }
    
    public interface RemoveResponse extends Response {
    }
    
    RemoveRequest remove();
    
    AttachedStorageDomainDisksService disksService();
    /**
     * Service locator method, returns individual service on which the URI is dispatched.
     */
    Service service(String path);
}

