/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.builders;

import java.math.BigInteger;
import org.ovirt.engine.sdk4.internal.containers.AgentConfigurationContainer;
import org.ovirt.engine.sdk4.types.AgentConfiguration;
import org.ovirt.engine.sdk4.types.MessageBrokerType;

public class AgentConfigurationBuilder {
    private String address;
    private MessageBrokerType brokerType;
    private String networkMappings;
    private String password;
    private BigInteger port;
    private String username;

    public AgentConfigurationBuilder address(String newAddress) {
        this.address = newAddress;
        return this;
    }

    public AgentConfigurationBuilder brokerType(MessageBrokerType newBrokerType) {
        this.brokerType = newBrokerType;
        return this;
    }

    public AgentConfigurationBuilder networkMappings(String newNetworkMappings) {
        this.networkMappings = newNetworkMappings;
        return this;
    }

    public AgentConfigurationBuilder password(String newPassword) {
        this.password = newPassword;
        return this;
    }

    public AgentConfigurationBuilder port(int newPort) {
        this.port = BigInteger.valueOf(newPort);
        return this;
    }

    public AgentConfigurationBuilder port(Integer newPort) {
        this.port = newPort == null ? null : BigInteger.valueOf(newPort.longValue());
        return this;
    }

    public AgentConfigurationBuilder port(long newPort) {
        this.port = BigInteger.valueOf(newPort);
        return this;
    }

    public AgentConfigurationBuilder port(Long newPort) {
        this.port = newPort == null ? null : BigInteger.valueOf(newPort);
        return this;
    }

    public AgentConfigurationBuilder port(BigInteger newPort) {
        this.port = newPort;
        return this;
    }

    public AgentConfigurationBuilder username(String newUsername) {
        this.username = newUsername;
        return this;
    }

    public AgentConfiguration build() {
        AgentConfigurationContainer container = new AgentConfigurationContainer();
        container.address(this.address);
        container.brokerType(this.brokerType);
        container.networkMappings(this.networkMappings);
        container.password(this.password);
        container.port(this.port);
        container.username(this.username);
        return container;
    }
}

