/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.types;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum ValueType {
    DECIMAL("decimal"),
    INTEGER("integer"),
    STRING("string");

    private static final Logger log;
    private String image;

    private ValueType(String image) {
        this.image = image;
    }

    public String value() {
        return this.image;
    }

    public static ValueType fromValue(String value) {
        try {
            return ValueType.valueOf(value.toUpperCase());
        }
        catch (IllegalArgumentException exception) {
            log.error("The string '" + value + "' isn't a valid value for the 'ValueType' enumerated type. Valid values are 'decimal', 'integer' and 'string'.", (Throwable)exception);
            return null;
        }
    }

    static {
        log = LoggerFactory.getLogger(ValueType.class);
    }
}

