/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.services;

import java.io.IOException;
import java.math.BigInteger;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.util.EntityUtils;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.api.metamodel.runtime.xml.XmlWriter;
import org.ovirt.engine.sdk4.BaseRequest;
import org.ovirt.engine.sdk4.Error;
import org.ovirt.engine.sdk4.Service;
import org.ovirt.engine.sdk4.internal.HttpConnection;
import org.ovirt.engine.sdk4.internal.services.RoleServiceImpl;
import org.ovirt.engine.sdk4.internal.services.ServiceImpl;
import org.ovirt.engine.sdk4.internal.xml.XmlRoleReader;
import org.ovirt.engine.sdk4.services.AssignedRolesService;
import org.ovirt.engine.sdk4.services.RoleService;
import org.ovirt.engine.sdk4.types.Role;

public class AssignedRolesServiceImpl
extends ServiceImpl
implements AssignedRolesService {
    public AssignedRolesServiceImpl(HttpConnection connection, String path) {
        super(connection, path);
    }

    @Override
    public AssignedRolesService.ListRequest list() {
        return new ListRequestImpl();
    }

    @Override
    public RoleService roleService(String id) {
        return new RoleServiceImpl(this.getConnection(), this.getPath() + "/" + id);
    }

    @Override
    public Service service(String path) {
        if (path == null) {
            return this;
        }
        int index = path.indexOf(47);
        if (index == -1) {
            return this.roleService(path);
        }
        return this.roleService(path.substring(0, index)).service(path.substring(index + 1));
    }

    public String toString() {
        return "AssignedRolesService:" + this.getPath();
    }

    private class ListResponseImpl
    implements AssignedRolesService.ListResponse {
        private List<Role> roles;

        private ListResponseImpl() {
        }

        public void roles(List<Role> roles) {
            this.roles = roles;
        }

        @Override
        public List<Role> roles() {
            return this.roles;
        }
    }

    private class ListRequestImpl
    extends BaseRequest<AssignedRolesService.ListRequest, AssignedRolesService.ListResponse>
    implements AssignedRolesService.ListRequest {
        private String follow;
        private BigInteger max;

        private ListRequestImpl() {
        }

        @Override
        public AssignedRolesService.ListRequest follow(String follow) {
            this.follow = follow;
            return this;
        }

        @Override
        public AssignedRolesService.ListRequest max(BigInteger max) {
            this.max = max;
            return this;
        }

        @Override
        public AssignedRolesService.ListRequest max(Integer max) {
            this.max = BigInteger.valueOf(max.intValue());
            return this;
        }

        @Override
        public AssignedRolesService.ListRequest max(Long max) {
            this.max = BigInteger.valueOf(max);
            return this;
        }

        @Override
        public AssignedRolesService.ListResponse send() {
            HttpResponse response;
            HttpGet request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(AssignedRolesServiceImpl.this.getConnection().getUrl() + AssignedRolesServiceImpl.this.getPath());
                if (this.follow != null) {
                    uriBuilder.addParameter("follow", XmlWriter.renderString(this.follow));
                }
                if (this.max != null) {
                    uriBuilder.addParameter("max", XmlWriter.renderInteger(this.max));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpGet(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = AssignedRolesServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        ListResponseImpl actionResponse = new ListResponseImpl();
                        actionResponse.roles(XmlRoleReader.readMany(reader));
                        ListResponseImpl listResponseImpl = actionResponse;
                        reader.close();
                        return listResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            AssignedRolesServiceImpl.this.checkFault(response);
            return new ListResponseImpl();
        }
    }
}

