/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.builders;

import java.math.BigInteger;
import org.ovirt.engine.sdk4.internal.containers.RateContainer;
import org.ovirt.engine.sdk4.types.Rate;

public class RateBuilder {
    private BigInteger bytes;
    private BigInteger period;

    public RateBuilder bytes(int newBytes) {
        this.bytes = BigInteger.valueOf(newBytes);
        return this;
    }

    public RateBuilder bytes(Integer newBytes) {
        this.bytes = newBytes == null ? null : BigInteger.valueOf(newBytes.longValue());
        return this;
    }

    public RateBuilder bytes(long newBytes) {
        this.bytes = BigInteger.valueOf(newBytes);
        return this;
    }

    public RateBuilder bytes(Long newBytes) {
        this.bytes = newBytes == null ? null : BigInteger.valueOf(newBytes);
        return this;
    }

    public RateBuilder bytes(BigInteger newBytes) {
        this.bytes = newBytes;
        return this;
    }

    public RateBuilder period(int newPeriod) {
        this.period = BigInteger.valueOf(newPeriod);
        return this;
    }

    public RateBuilder period(Integer newPeriod) {
        this.period = newPeriod == null ? null : BigInteger.valueOf(newPeriod.longValue());
        return this;
    }

    public RateBuilder period(long newPeriod) {
        this.period = BigInteger.valueOf(newPeriod);
        return this;
    }

    public RateBuilder period(Long newPeriod) {
        this.period = newPeriod == null ? null : BigInteger.valueOf(newPeriod);
        return this;
    }

    public RateBuilder period(BigInteger newPeriod) {
        this.period = newPeriod;
        return this;
    }

    public Rate build() {
        RateContainer container = new RateContainer();
        container.bytes(this.bytes);
        container.period(this.period);
        return container;
    }
}

