/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.services;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.util.EntityUtils;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.api.metamodel.runtime.xml.XmlWriter;
import org.ovirt.engine.sdk4.BaseRequest;
import org.ovirt.engine.sdk4.Error;
import org.ovirt.engine.sdk4.Service;
import org.ovirt.engine.sdk4.builders.ActionBuilder;
import org.ovirt.engine.sdk4.builders.ClusterBuilder;
import org.ovirt.engine.sdk4.builders.DiskBuilder;
import org.ovirt.engine.sdk4.builders.StorageDomainBuilder;
import org.ovirt.engine.sdk4.builders.TemplateBuilder;
import org.ovirt.engine.sdk4.internal.HttpConnection;
import org.ovirt.engine.sdk4.internal.services.ServiceImpl;
import org.ovirt.engine.sdk4.internal.xml.XmlActionWriter;
import org.ovirt.engine.sdk4.internal.xml.XmlImageReader;
import org.ovirt.engine.sdk4.services.ImageService;
import org.ovirt.engine.sdk4.types.Action;
import org.ovirt.engine.sdk4.types.Cluster;
import org.ovirt.engine.sdk4.types.Disk;
import org.ovirt.engine.sdk4.types.Image;
import org.ovirt.engine.sdk4.types.StorageDomain;
import org.ovirt.engine.sdk4.types.Template;

public class ImageServiceImpl
extends ServiceImpl
implements ImageService {
    public ImageServiceImpl(HttpConnection connection, String path) {
        super(connection, path);
    }

    @Override
    public ImageService.GetRequest get() {
        return new GetRequestImpl();
    }

    @Override
    public ImageService.ImportRequest import_() {
        return new ImportRequestImpl();
    }

    @Override
    public Service service(String path) {
        if (path == null) {
            return this;
        }
        throw new Error("The path " + path + " doesn't correspond to any service");
    }

    public String toString() {
        return "ImageService:" + this.getPath();
    }

    private class ImportResponseImpl
    implements ImageService.ImportResponse {
        private ImportResponseImpl() {
        }
    }

    private class ImportRequestImpl
    extends BaseRequest<ImageService.ImportRequest, ImageService.ImportResponse>
    implements ImageService.ImportRequest {
        private Boolean async;
        private Cluster cluster;
        private Disk disk;
        private Boolean importAsTemplate;
        private StorageDomain storageDomain;
        private Template template;

        private ImportRequestImpl() {
        }

        @Override
        public ImageService.ImportRequest async(Boolean async) {
            this.async = async;
            return this;
        }

        @Override
        public ImageService.ImportRequest cluster(Cluster cluster) {
            this.cluster = cluster;
            return this;
        }

        @Override
        public ImageService.ImportRequest cluster(ClusterBuilder cluster) {
            this.cluster = cluster.build();
            return this;
        }

        @Override
        public ImageService.ImportRequest disk(Disk disk) {
            this.disk = disk;
            return this;
        }

        @Override
        public ImageService.ImportRequest disk(DiskBuilder disk) {
            this.disk = disk.build();
            return this;
        }

        @Override
        public ImageService.ImportRequest importAsTemplate(Boolean importAsTemplate) {
            this.importAsTemplate = importAsTemplate;
            return this;
        }

        @Override
        public ImageService.ImportRequest storageDomain(StorageDomain storageDomain) {
            this.storageDomain = storageDomain;
            return this;
        }

        @Override
        public ImageService.ImportRequest storageDomain(StorageDomainBuilder storageDomain) {
            this.storageDomain = storageDomain.build();
            return this;
        }

        @Override
        public ImageService.ImportRequest template(Template template) {
            this.template = template;
            return this;
        }

        @Override
        public ImageService.ImportRequest template(TemplateBuilder template) {
            this.template = template.build();
            return this;
        }

        @Override
        public ImageService.ImportResponse send() {
            HttpPost request = new HttpPost(ImageServiceImpl.this.getConnection().getUrl() + ImageServiceImpl.this.getPath() + "/import");
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();
                 XmlWriter xmlWriter = new XmlWriter(output, true);){
                ActionBuilder action = new ActionBuilder();
                action.async(this.async);
                action.cluster(this.cluster);
                action.disk(this.disk);
                action.importAsTemplate(this.importAsTemplate);
                action.storageDomain(this.storageDomain);
                action.template(this.template);
                XmlActionWriter.writeOne(action.build(), xmlWriter);
                xmlWriter.flush();
                request.setEntity((HttpEntity)new ByteArrayEntity(output.toByteArray()));
            }
            catch (IOException ex) {
                throw new Error("Failed to write request", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            HttpResponse response = ImageServiceImpl.this.getConnection().send((HttpUriRequest)request);
            Action action = ImageServiceImpl.this.checkAction(response);
            EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
            return new ImportResponseImpl();
        }
    }

    private class GetResponseImpl
    implements ImageService.GetResponse {
        private Image image;

        private GetResponseImpl() {
        }

        public void image(Image image) {
            this.image = image;
        }

        @Override
        public Image image() {
            return this.image;
        }
    }

    private class GetRequestImpl
    extends BaseRequest<ImageService.GetRequest, ImageService.GetResponse>
    implements ImageService.GetRequest {
        private String follow;

        private GetRequestImpl() {
        }

        @Override
        public ImageService.GetRequest follow(String follow) {
            this.follow = follow;
            return this;
        }

        @Override
        public ImageService.GetResponse send() {
            HttpResponse response;
            HttpGet request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(ImageServiceImpl.this.getConnection().getUrl() + ImageServiceImpl.this.getPath());
                if (this.follow != null) {
                    uriBuilder.addParameter("follow", XmlWriter.renderString(this.follow));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpGet(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = ImageServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        GetResponseImpl actionResponse = new GetResponseImpl();
                        actionResponse.image(XmlImageReader.readOne(reader));
                        GetResponseImpl getResponseImpl = actionResponse;
                        reader.close();
                        return getResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            ImageServiceImpl.this.checkFault(response);
            return new GetResponseImpl();
        }
    }
}

