/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.services;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.util.EntityUtils;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.api.metamodel.runtime.xml.XmlWriter;
import org.ovirt.engine.sdk4.BaseRequest;
import org.ovirt.engine.sdk4.Error;
import org.ovirt.engine.sdk4.Service;
import org.ovirt.engine.sdk4.builders.NicBuilder;
import org.ovirt.engine.sdk4.internal.HttpConnection;
import org.ovirt.engine.sdk4.internal.services.ServiceImpl;
import org.ovirt.engine.sdk4.internal.services.TemplateNicServiceImpl;
import org.ovirt.engine.sdk4.internal.xml.XmlNicReader;
import org.ovirt.engine.sdk4.internal.xml.XmlNicWriter;
import org.ovirt.engine.sdk4.services.TemplateNicService;
import org.ovirt.engine.sdk4.services.TemplateNicsService;
import org.ovirt.engine.sdk4.types.Nic;

public class TemplateNicsServiceImpl
extends ServiceImpl
implements TemplateNicsService {
    public TemplateNicsServiceImpl(HttpConnection connection, String path) {
        super(connection, path);
    }

    @Override
    public TemplateNicsService.AddRequest add() {
        return new AddRequestImpl();
    }

    @Override
    public TemplateNicsService.ListRequest list() {
        return new ListRequestImpl();
    }

    @Override
    public TemplateNicService nicService(String id) {
        return new TemplateNicServiceImpl(this.getConnection(), this.getPath() + "/" + id);
    }

    @Override
    public Service service(String path) {
        if (path == null) {
            return this;
        }
        int index = path.indexOf(47);
        if (index == -1) {
            return this.nicService(path);
        }
        return this.nicService(path.substring(0, index)).service(path.substring(index + 1));
    }

    public String toString() {
        return "TemplateNicsService:" + this.getPath();
    }

    private class ListResponseImpl
    implements TemplateNicsService.ListResponse {
        private List<Nic> nics;

        private ListResponseImpl() {
        }

        public void nics(List<Nic> nics) {
            this.nics = nics;
        }

        @Override
        public List<Nic> nics() {
            return this.nics;
        }
    }

    private class ListRequestImpl
    extends BaseRequest<TemplateNicsService.ListRequest, TemplateNicsService.ListResponse>
    implements TemplateNicsService.ListRequest {
        private String follow;
        private BigInteger max;

        private ListRequestImpl() {
        }

        @Override
        public TemplateNicsService.ListRequest follow(String follow) {
            this.follow = follow;
            return this;
        }

        @Override
        public TemplateNicsService.ListRequest max(BigInteger max) {
            this.max = max;
            return this;
        }

        @Override
        public TemplateNicsService.ListRequest max(Integer max) {
            this.max = BigInteger.valueOf(max.intValue());
            return this;
        }

        @Override
        public TemplateNicsService.ListRequest max(Long max) {
            this.max = BigInteger.valueOf(max);
            return this;
        }

        @Override
        public TemplateNicsService.ListResponse send() {
            HttpResponse response;
            HttpGet request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(TemplateNicsServiceImpl.this.getConnection().getUrl() + TemplateNicsServiceImpl.this.getPath());
                if (this.follow != null) {
                    uriBuilder.addParameter("follow", XmlWriter.renderString(this.follow));
                }
                if (this.max != null) {
                    uriBuilder.addParameter("max", XmlWriter.renderInteger(this.max));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpGet(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = TemplateNicsServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        ListResponseImpl actionResponse = new ListResponseImpl();
                        actionResponse.nics(XmlNicReader.readMany(reader));
                        ListResponseImpl listResponseImpl = actionResponse;
                        reader.close();
                        return listResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            TemplateNicsServiceImpl.this.checkFault(response);
            return new ListResponseImpl();
        }
    }

    private class AddResponseImpl
    implements TemplateNicsService.AddResponse {
        private Nic nic;

        private AddResponseImpl() {
        }

        public void nic(Nic nic) {
            this.nic = nic;
        }

        @Override
        public Nic nic() {
            return this.nic;
        }
    }

    private class AddRequestImpl
    extends BaseRequest<TemplateNicsService.AddRequest, TemplateNicsService.AddResponse>
    implements TemplateNicsService.AddRequest {
        private Nic nic;

        private AddRequestImpl() {
        }

        @Override
        public TemplateNicsService.AddRequest nic(Nic nic) {
            this.nic = nic;
            return this;
        }

        @Override
        public TemplateNicsService.AddRequest nic(NicBuilder nic) {
            this.nic = nic.build();
            return this;
        }

        @Override
        public TemplateNicsService.AddResponse send() {
            HttpResponse response;
            HttpPost request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(TemplateNicsServiceImpl.this.getConnection().getUrl() + TemplateNicsServiceImpl.this.getPath());
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpPost(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();
                 XmlWriter xmlWriter = new XmlWriter(output, true);){
                XmlNicWriter.writeOne(this.nic, xmlWriter);
                xmlWriter.flush();
                request.setEntity((HttpEntity)new ByteArrayEntity(output.toByteArray()));
            }
            catch (IOException ex) {
                throw new Error("Failed to parse response", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = TemplateNicsServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200 || response.getStatusLine().getStatusCode() == 201 || response.getStatusLine().getStatusCode() == 202) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        AddResponseImpl actionResponse = new AddResponseImpl();
                        actionResponse.nic(XmlNicReader.readOne(reader));
                        AddResponseImpl addResponseImpl = actionResponse;
                        reader.close();
                        return addResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            TemplateNicsServiceImpl.this.checkFault(response);
            return new AddResponseImpl();
        }
    }
}

