/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.xml;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.engine.sdk4.internal.containers.NetworkConfigurationContainer;
import org.ovirt.engine.sdk4.internal.xml.XmlDnsReader;
import org.ovirt.engine.sdk4.internal.xml.XmlNicReader;
import org.ovirt.engine.sdk4.types.NetworkConfiguration;

public class XmlNetworkConfigurationReader {
    public static NetworkConfiguration readOne(XmlReader reader) {
        if (!reader.forward()) {
            return null;
        }
        NetworkConfigurationContainer object = new NetworkConfigurationContainer();
        ArrayList<String[]> links = new ArrayList<String[]>();
        reader.next();
        block10: while (reader.forward()) {
            String name;
            switch (name = reader.getLocalName()) {
                case "dns": {
                    object.dns(XmlDnsReader.readOne(reader));
                    continue block10;
                }
                case "nics": {
                    object.nics(XmlNicReader.readMany(reader));
                    continue block10;
                }
                case "link": {
                    String rel = reader.getAttributeValue("rel");
                    String href = reader.getAttributeValue("href");
                    if (rel != null && href != null) {
                        links.add(new String[]{rel, href});
                    }
                    reader.skip();
                    continue block10;
                }
            }
            reader.skip();
        }
        if (links != null) {
            for (String[] link : links) {
                XmlNetworkConfigurationReader.processLink(object, link);
            }
        }
        reader.next();
        return object;
    }

    public static Iterator<NetworkConfiguration> iterateMany(final XmlReader reader) {
        return new Iterator<NetworkConfiguration>(){
            private boolean first = true;

            @Override
            public void remove() {
            }

            @Override
            public boolean hasNext() {
                if (this.first) {
                    if (!reader.forward()) {
                        return false;
                    }
                    reader.next();
                    this.first = false;
                }
                if (!reader.forward()) {
                    reader.next();
                    return false;
                }
                return true;
            }

            @Override
            public NetworkConfiguration next() {
                NetworkConfiguration next = XmlNetworkConfigurationReader.readOne(reader);
                if (next == null) {
                    throw new NoSuchElementException();
                }
                return next;
            }
        };
    }

    public static List<NetworkConfiguration> readMany(XmlReader reader) {
        ArrayList<NetworkConfiguration> list = new ArrayList<NetworkConfiguration>();
        Iterator<NetworkConfiguration> iterator = XmlNetworkConfigurationReader.iterateMany(reader);
        while (iterator.hasNext()) {
            list.add(iterator.next());
        }
        return list;
    }

    private static void processLink(NetworkConfigurationContainer object, String[] link) {
    }
}

