/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.xml;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.ovirt.api.metamodel.runtime.util.ArrayListWithHref;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.engine.sdk4.internal.containers.CheckpointContainer;
import org.ovirt.engine.sdk4.internal.xml.XmlDiskReader;
import org.ovirt.engine.sdk4.internal.xml.XmlVmReader;
import org.ovirt.engine.sdk4.types.Checkpoint;
import org.ovirt.engine.sdk4.types.Disk;

public class XmlCheckpointReader {
    public static Checkpoint readOne(XmlReader reader) {
        String name;
        if (!reader.forward()) {
            return null;
        }
        CheckpointContainer object = new CheckpointContainer();
        block28: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            name = reader.getAttributeLocalName(i);
            String image = reader.getAttributeValue(i);
            switch (name) {
                case "href": {
                    object.href(image);
                    continue block28;
                }
                case "id": {
                    object.id(image);
                    continue block28;
                }
            }
        }
        ArrayList<String[]> links = new ArrayList<String[]>();
        reader.next();
        block29: while (reader.forward()) {
            switch (name = reader.getLocalName()) {
                case "comment": {
                    object.comment(reader.readString());
                    continue block29;
                }
                case "creation_date": {
                    object.creationDate(reader.readDate());
                    continue block29;
                }
                case "description": {
                    object.description(reader.readString());
                    continue block29;
                }
                case "disks": {
                    object.disks(XmlDiskReader.readMany(reader));
                    continue block29;
                }
                case "name": {
                    object.name(reader.readString());
                    continue block29;
                }
                case "parent_id": {
                    object.parentId(reader.readString());
                    continue block29;
                }
                case "vm": {
                    object.vm(XmlVmReader.readOne(reader));
                    continue block29;
                }
                case "link": {
                    String rel = reader.getAttributeValue("rel");
                    String href = reader.getAttributeValue("href");
                    if (rel != null && href != null) {
                        links.add(new String[]{rel, href});
                    }
                    reader.skip();
                    continue block29;
                }
            }
            reader.skip();
        }
        if (links != null) {
            for (String[] link : links) {
                XmlCheckpointReader.processLink(object, link);
            }
        }
        reader.next();
        return object;
    }

    public static Iterator<Checkpoint> iterateMany(final XmlReader reader) {
        return new Iterator<Checkpoint>(){
            private boolean first = true;

            @Override
            public void remove() {
            }

            @Override
            public boolean hasNext() {
                if (this.first) {
                    if (!reader.forward()) {
                        return false;
                    }
                    reader.next();
                    this.first = false;
                }
                if (!reader.forward()) {
                    reader.next();
                    return false;
                }
                return true;
            }

            @Override
            public Checkpoint next() {
                Checkpoint next = XmlCheckpointReader.readOne(reader);
                if (next == null) {
                    throw new NoSuchElementException();
                }
                return next;
            }
        };
    }

    public static List<Checkpoint> readMany(XmlReader reader) {
        ArrayList<Checkpoint> list = new ArrayList<Checkpoint>();
        Iterator<Checkpoint> iterator = XmlCheckpointReader.iterateMany(reader);
        while (iterator.hasNext()) {
            list.add(iterator.next());
        }
        return list;
    }

    private static void processLink(CheckpointContainer object, String[] link) {
        String rel = link[0];
        String href = link[1];
        if (href != null) {
            switch (rel) {
                case "disks": {
                    ArrayListWithHref<Disk> list = new ArrayListWithHref<Disk>(object.disks());
                    list.href(href);
                    object.disks(list);
                    break;
                }
            }
        }
    }
}

