/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.types;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum NetworkUsage {
    DEFAULT_ROUTE("default_route"),
    DISPLAY("display"),
    GLUSTER("gluster"),
    MANAGEMENT("management"),
    MIGRATION("migration"),
    VM("vm");

    private static final Logger log;
    private String image;

    private NetworkUsage(String image) {
        this.image = image;
    }

    public String value() {
        return this.image;
    }

    public static NetworkUsage fromValue(String value) {
        try {
            return NetworkUsage.valueOf(value.toUpperCase());
        }
        catch (IllegalArgumentException exception) {
            log.error("The string '" + value + "' isn't a valid value for the 'NetworkUsage' enumerated type. Valid values are 'default_route', 'display', 'gluster', 'management', 'migration' and 'vm'.", (Throwable)exception);
            return null;
        }
    }

    static {
        log = LoggerFactory.getLogger(NetworkUsage.class);
    }
}

