/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.types;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum WatchdogAction {
    DUMP("dump"),
    NONE("none"),
    PAUSE("pause"),
    POWEROFF("poweroff"),
    RESET("reset");

    private static final Logger log;
    private String image;

    private WatchdogAction(String image) {
        this.image = image;
    }

    public String value() {
        return this.image;
    }

    public static WatchdogAction fromValue(String value) {
        try {
            return WatchdogAction.valueOf(value.toUpperCase());
        }
        catch (IllegalArgumentException exception) {
            log.error("The string '" + value + "' isn't a valid value for the 'WatchdogAction' enumerated type. Valid values are 'dump', 'none', 'pause', 'poweroff' and 'reset'.", (Throwable)exception);
            return null;
        }
    }

    static {
        log = LoggerFactory.getLogger(WatchdogAction.class);
    }
}

