#
# Copyright (c) 2010 Red Hat, Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#           http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#


########################################
############ GENERATED CODE ############
########################################

'''Generated at: 2016-01-12 10:40:25.000848'''


from ovirtsdk.xml import params
from ovirtsdk.utils.urlhelper import UrlHelper
from ovirtsdk.utils.filterhelper import FilterHelper
from ovirtsdk.utils.parsehelper import ParseHelper
from ovirtsdk.infrastructure.common import Base
from ovirtsdk.infrastructure.context import context
from ovirtsdk.infrastructure.errors import MissingParametersError
from ovirtsdk.infrastructure.errors import DisconnectedError
from ovirtsdk.infrastructure.errors import RequestError


class Bookmark(params.Bookmark, Base):
    def __init__(self, bookmark, context):
        Base.__init__(self, context)
        self.superclass = bookmark

        #SUB_COLLECTIONS
    def __new__(cls, bookmark, context):
        if bookmark is None: return None
        obj = object.__new__(cls)
        obj.__init__(bookmark, context)
        return obj

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def delete(self, async=None):
        '''
        [@param async: boolean (true|false)]

        @return None:
        '''

        url = UrlHelper.replace(
            '/bookmarks/{bookmark:id}',
            {
                '{bookmark:id}': self.get_id(),
            }
        )

        return self.__getProxy().delete(
            url=UrlHelper.appendParameters(
                url,
                {'async:matrix':async}
            ),
            headers={"Content-type":None}
        )

    def update(self):
        '''
        @return Bookmark:
        '''

        url = '/bookmarks/{bookmark:id}'

        result = self.__getProxy().update(
            url=UrlHelper.replace(
                url,
                {
                    '{bookmark:id}': self.get_id(),
                }
            ),
            body=ParseHelper.toXml(self.superclass),
            headers={}
        )

        return Bookmark(result, self.context)

class Bookmarks(Base):
    def __init__(self, context):
        Base.__init__(self, context)

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def add(self, bookmark, correlation_id=None, expect=None):
        '''
        @type Bookmark:

        @param bookmark.name: string
        @param bookmark.value: string
        [@param correlation_id: any string]
        [@param expect: 201-created]

        @return Bookmark:
        '''

        url = '/bookmarks'

        result = self.__getProxy().add(
           url=UrlHelper.appendParameters(
                url=url,
                args={}
           ),
           body=ParseHelper.toXml(bookmark),
           headers={"Correlation-Id":correlation_id, "Expect":expect}
        )

        return Bookmark(result, self.context)

    def get(self, name=None, id=None):
        '''
        [@param id  : string (the id of the entity)]
        [@param name: string (the name of the entity)]

        @return Bookmarks:
        '''

        url = '/bookmarks'

        if id:
            try :
                return Bookmark(
                    self.__getProxy().get(
                                url=UrlHelper.append(url, id),
                                headers={}
                    ),
                    self.context
                )
            except RequestError as err:
                if err.status and err.status == 404:
                    return None
                raise err
        elif name:
            result = self.__getProxy().get(
                    url=url,
                    headers={}
            ).get_bookmark()

            return Bookmark(
                FilterHelper.getItem(
                    FilterHelper.filter(result, {'name':name}),
                    query="name=" + name
                ),
                self.context
            )
        else:
            raise MissingParametersError(['id', 'name'])


    def list(self, max=None, **kwargs):
        '''
        [@param **kwargs: dict (property based filtering)]
        [@param max: int (max results)]

        @return Bookmarks:
        '''

        url='/bookmarks'

        result = self.__getProxy().get(
            url=UrlHelper.appendParameters(url, {'max:matrix':max}),
            headers={}
        ).get_bookmark()

        return ParseHelper.toCollection(
            Bookmark,
            FilterHelper.filter(result, kwargs),
            context=self.context
        )

class Capabilities(Base):
    def __init__(self, context):
        Base.__init__(self, context)

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError


    def get(self, id=None, **kwargs):
        '''
        [@param id: string (the id of the entity)]
        [@param **kwargs: dict (property based filtering)]

        @return VersionCaps:
        '''

        url = '/capabilities'

        if id:
            try :
                return VersionCaps(
                    self.__getProxy().get(url=UrlHelper.append(url, id)),
                    self.context
                )
            except RequestError as err:
                if err.status and err.status == 404:
                    return None
                raise err
        elif kwargs:
            result = self.__getProxy().get(url=url).version

            return VersionCaps(
                FilterHelper.getItem(FilterHelper.filter(result, kwargs)),
                self.context
            )
        else:
            raise MissingParametersError(['id', 'kwargs'])

    def list(self, **kwargs):
        '''
        [@param **kwargs: dict (property based filtering)"]

        @return [VersionCaps]:
        '''

        url='/capabilities'

        result = self.__getProxy().get(url=url).version

        return ParseHelper.toCollection(
            VersionCaps,
            FilterHelper.filter(result, kwargs),
            context=self.context
        )
class Cluster(params.Cluster, Base):
    def __init__(self, cluster, context):
        Base.__init__(self, context)
        self.superclass = cluster

        self.affinitygroups = ClusterAffinityGroups(self, context)
        self.cpuprofiles = ClusterCpuProfiles(self, context)
        self.glusterhooks = ClusterGlusterHooks(self, context)
        self.glustervolumes = ClusterGlusterVolumes(self, context)
        self.networks = ClusterNetworks(self, context)
        self.permissions = ClusterPermissions(self, context)

    def __new__(cls, cluster, context):
        if cluster is None: return None
        obj = object.__new__(cls)
        obj.__init__(cluster, context)
        return obj

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def delete(self, async=None, correlation_id=None):
        '''
        [@param async: boolean (true|false)]
        [@param correlation_id: any string]

        @return None:
        '''

        url = UrlHelper.replace(
            '/clusters/{cluster:id}',
            {
                '{cluster:id}': self.get_id(),
            }
        )

        return self.__getProxy().delete(
            url=UrlHelper.appendParameters(
                url,
                {'async:matrix':async}
            ),
            headers={"Correlation-Id":correlation_id,"Content-type":None}
        )

    def update(self, correlation_id=None, expect=None):
        '''
        [@param cluster.name: string]
        [@param cluster.description: string]
        [@param cluster.comment: string]
        [@param cluster.data_center.id: string]
        [@param cluster.cpu.id: string]
        [@param cluster.version.major: int]
        [@param cluster.version.minor: int,]
        [@param cluster.memory_policy.overcommit.percent: double]
        [@param cluster.memory_policy.transparent_hugepages.enabled: boolean]
        [@param cluster.scheduling_policy.policy: string]
        [@param cluster.scheduling_policy.thresholds.low: int]
        [@param cluster.scheduling_policy.thresholds.high: int]
        [@param cluster.scheduling_policy.thresholds.duration: int]
        [@param cluster.scheduling_policy.id: string]
        [@param cluster.scheduling_policy.properties.property: collection]
        {
          [@ivar property.name: string]
          [@ivar property.value: string]
        }
        [@param cluster.error_handling.on_error: string]
        [@param cluster.virt_service: boolean]
        [@param cluster.gluster_service: boolean]
        [@param cluster.threads_as_cores: boolean]
        [@param cluster.tunnel_migration: boolean]
        [@param cluster.ballooning_enabled: boolean]
        [@param cluster.cpu.architecture: string]
        [@param cluster.display.proxy: string]
        [@param cluster.ksm.enabled: boolean]
        [@param cluster.fencing_policy.enabled: boolean]
        [@param cluster.fencing_policy.skip_if_sd_active.enabled: boolean]
        [@param cluster.fencing_policy.skip_if_connectivity_broken.enabled: boolean]
        [@param cluster.fencing_policy.skip_if_connectivity_broken.threshold: int]
        [@param cluster.maintenance_reason_required: boolean]
        [@param cluster.management_network.id|name: string]
        [@param cluster.ha_reservation: boolean]
        [@param cluster.ksm.merge_across_nodes: boolean]
        [@param correlation_id: any string]
        [@param expect: 202-accepted]

        @return Cluster:
        '''

        url = '/clusters/{cluster:id}'

        result = self.__getProxy().update(
            url=UrlHelper.replace(
                url,
                {
                    '{cluster:id}': self.get_id(),
                }
            ),
            body=ParseHelper.toXml(self.superclass),
            headers={"Correlation-Id":correlation_id, "Expect":expect}
        )

        return Cluster(result, self.context)

    def resetemulatedmachine(self, action=params.Action(), correlation_id=None):
        '''
        @type Action:

        [@param correlation_id: any string]

        @return Action:
        '''

        url = '/clusters/{cluster:id}/resetemulatedmachine'

        result = self.__getProxy().request(
            method='POST',
            url=UrlHelper.replace(
                url,
                {
                    '{cluster:id}': self.get_id(),
                }
            ),
            body=ParseHelper.toXml(action),
            headers={"Correlation-Id":correlation_id}
        )

        return result

class ClusterAffinityGroup(params.AffinityGroup, Base):
    def __init__(self, cluster, affinitygroup, context):
        Base.__init__(self, context)
        self.parentclass = cluster
        self.superclass  =  affinitygroup

        self.vms = ClusterAffinityGroupVMs(self, context)

    def __new__(cls, cluster, affinitygroup, context):
        if affinitygroup is None: return None
        obj = object.__new__(cls)
        obj.__init__(cluster, affinitygroup, context)
        return obj

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def delete(self, async=None, correlation_id=None):
        '''
        [@param async: boolean (true|false)]
        [@param correlation_id: any string]

        @return None:
        '''

        url = UrlHelper.replace(
            '/clusters/{cluster:id}/affinitygroups/{affinitygroup:id}',
            {
                '{cluster:id}': self.parentclass.get_id(),
                '{affinitygroup:id}': self.get_id(),
            }
        )

        return self.__getProxy().delete(
            url=UrlHelper.appendParameters(
                url,
                {'async:matrix':async}
            ),
            headers={"Correlation-Id":correlation_id,"Content-type":None}
        )

    def update(self, async=None, correlation_id=None, expect=None):
        '''
        [@param affinitygroup.name: string]
        [@param affinitygroup.positive: boolean]
        [@param affinitygroup.enforcing: boolean]
        [@param async: boolean (true|false)]
        [@param correlation_id: any string]
        [@param expect: 202-accepted]

        @return AffinityGroup:
        '''

        url = '/clusters/{cluster:id}/affinitygroups/{affinitygroup:id}'
        url = UrlHelper.replace(
            url,
            {
                '{cluster:id}': self.parentclass.get_id(),
                '{affinitygroup:id}': self.get_id(),
            }
        )

        result = self.__getProxy().update(
            url=UrlHelper.appendParameters(url, {'async:matrix':async}),
            body=ParseHelper.toXml(self.superclass),
            headers={"Correlation-Id":correlation_id, "Expect":expect}
        )

        return ClusterAffinityGroup(
            self.parentclass,
            result,
            self.context
        )

class ClusterAffinityGroupVM(params.VM, Base):
    def __init__(self, clusteraffinitygroup, vm, context):
        Base.__init__(self, context)
        self.parentclass = clusteraffinitygroup
        self.superclass  =  vm

        #SUB_COLLECTIONS
    def __new__(cls, clusteraffinitygroup, vm, context):
        if vm is None: return None
        obj = object.__new__(cls)
        obj.__init__(clusteraffinitygroup, vm, context)
        return obj

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def delete(self, async=None, correlation_id=None):
        '''
        [@param async: boolean (true|false)]
        [@param correlation_id: any string]

        @return None:
        '''

        url = UrlHelper.replace(
            '/clusters/{cluster:id}/affinitygroups/{affinitygroup:id}/vms/{vm:id}',
            {
                '{cluster:id}': self.parentclass.parentclass.get_id(),
                '{affinitygroup:id}': self.parentclass.get_id(),
                '{vm:id}': self.get_id(),
            }
        )

        return self.__getProxy().delete(
            url=UrlHelper.appendParameters(
                url,
                {'async:matrix':async}
            ),
            headers={"Correlation-Id":correlation_id,"Content-type":None}
        )

class ClusterAffinityGroupVMs(Base):

    def __init__(self, affinitygroup , context):
        Base.__init__(self, context)
        self.parentclass = affinitygroup

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def add(self, vm, correlation_id=None, expect=None):

        '''
        @type VM:

        @param vm.id|name: string
        [@param correlation_id: any string]
        [@param expect: 201-created]

        @return VM:
        '''

        url = '/clusters/{cluster:id}/affinitygroups/{affinitygroup:id}/vms'

        result = self.__getProxy().add(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{cluster:id}': self.parentclass.parentclass.get_id(),
                        '{affinitygroup:id}': self.parentclass.get_id(),
                    }
                ),
                args={}
            ),
            body=ParseHelper.toXml(vm),
            headers={"Correlation-Id":correlation_id, "Expect":expect}
        )

        return ClusterAffinityGroupVM(
            self.parentclass,
            result,
            self.context
        )

    def get(self, name=None, id=None):

        '''
        [@param id  : string (the id of the entity)]
        [@param name: string (the name of the entity)]

        @return VMs:
        '''

        url = '/clusters/{cluster:id}/affinitygroups/{affinitygroup:id}/vms'

        if id:
            try :
                result = self.__getProxy().get(
                    url=UrlHelper.append(
                        UrlHelper.replace(
                            url,
                            {
                                '{cluster:id}': self.parentclass.parentclass.get_id(),
                                '{affinitygroup:id}': self.parentclass.get_id(),
                            }
                        ),
                        id
                    ),
                    headers={}
                )

                return ClusterAffinityGroupVM(
                    self.parentclass,
                    result,
                    self.context
                )
            except RequestError as err:
                if err.status and err.status == 404:
                    return None
                raise err
        elif name:
            result = self.__getProxy().get(
                url=UrlHelper.replace(
                    url,
                    {
                        '{cluster:id}': self.parentclass.parentclass.get_id(),
                        '{affinitygroup:id}': self.parentclass.get_id(),
                    }
                ),
                headers={}
            ).get_vm()

            return ClusterAffinityGroupVM(
                self.parentclass,
                FilterHelper.getItem(
                    FilterHelper.filter(
                        result,
                        {'name':name}
                    ),
                    query="name=" + name
                ),
                self.context
            )
        else:
            raise MissingParametersError(['id', 'name'])

    def list(self, max=None, **kwargs):
        '''
        [@param **kwargs: dict (property based filtering)"]
        [@param max: int (max results)]

        @return VMs:
        '''

        url = '/clusters/{cluster:id}/affinitygroups/{affinitygroup:id}/vms'

        result = self.__getProxy().get(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{cluster:id}': self.parentclass.parentclass.get_id(),
                        '{affinitygroup:id}': self.parentclass.get_id(),
                    }
                ),
                args={'max:matrix':max}
            ),
            headers={}
        ).get_vm()

        return ParseHelper.toSubCollection(
            ClusterAffinityGroupVM,
            self.parentclass,
            FilterHelper.filter(
                result,
                kwargs
            ),
            context=self.context
        )

class ClusterAffinityGroups(Base):

    def __init__(self, cluster , context):
        Base.__init__(self, context)
        self.parentclass = cluster

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def add(self, affinitygroup, correlation_id=None, expect=None):

        '''
        @type AffinityGroup:

        @param affinitygroup.name: string
        @param affinitygroup.positive: boolean
        @param affinitygroup.enforcing: boolean
        [@param correlation_id: any string]
        [@param expect: 201-created]

        @return AffinityGroup:
        '''

        url = '/clusters/{cluster:id}/affinitygroups'

        result = self.__getProxy().add(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{cluster:id}': self.parentclass.get_id(),
                    }
                ),
                args={}
            ),
            body=ParseHelper.toXml(affinitygroup),
            headers={"Correlation-Id":correlation_id, "Expect":expect}
        )

        return ClusterAffinityGroup(
            self.parentclass,
            result,
            self.context
        )

    def get(self, name=None, id=None):

        '''
        [@param id  : string (the id of the entity)]
        [@param name: string (the name of the entity)]

        @return AffinityGroups:
        '''

        url = '/clusters/{cluster:id}/affinitygroups'

        if id:
            try :
                result = self.__getProxy().get(
                    url=UrlHelper.append(
                        UrlHelper.replace(
                            url,
                            {
                                '{cluster:id}': self.parentclass.get_id(),
                            }
                        ),
                        id
                    ),
                    headers={}
                )

                return ClusterAffinityGroup(
                    self.parentclass,
                    result,
                    self.context
                )
            except RequestError as err:
                if err.status and err.status == 404:
                    return None
                raise err
        elif name:
            result = self.__getProxy().get(
                url=UrlHelper.replace(
                    url,
                    {
                        '{cluster:id}': self.parentclass.get_id(),
                    }
                ),
                headers={}
            ).get_affinity_group()

            return ClusterAffinityGroup(
                self.parentclass,
                FilterHelper.getItem(
                    FilterHelper.filter(
                        result,
                        {'name':name}
                    ),
                    query="name=" + name
                ),
                self.context
            )
        else:
            raise MissingParametersError(['id', 'name'])

    def list(self, max=None, **kwargs):
        '''
        [@param **kwargs: dict (property based filtering)"]
        [@param max: int (max results)]

        @return AffinityGroups:
        '''

        url = '/clusters/{cluster:id}/affinitygroups'

        result = self.__getProxy().get(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{cluster:id}': self.parentclass.get_id(),
                    }
                ),
                args={'max:matrix':max}
            ),
            headers={}
        ).get_affinity_group()

        return ParseHelper.toSubCollection(
            ClusterAffinityGroup,
            self.parentclass,
            FilterHelper.filter(
                result,
                kwargs
            ),
            context=self.context
        )

class ClusterCpuProfile(params.CpuProfile, Base):
    def __init__(self, cluster, cpuprofile, context):
        Base.__init__(self, context)
        self.parentclass = cluster
        self.superclass  =  cpuprofile

        #SUB_COLLECTIONS
    def __new__(cls, cluster, cpuprofile, context):
        if cpuprofile is None: return None
        obj = object.__new__(cls)
        obj.__init__(cluster, cpuprofile, context)
        return obj

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def delete(self, async=None, correlation_id=None):
        '''
        [@param async: boolean (true|false)]
        [@param correlation_id: any string]

        @return None:
        '''

        url = UrlHelper.replace(
            '/clusters/{cluster:id}/cpuprofiles/{cpuprofile:id}',
            {
                '{cluster:id}': self.parentclass.get_id(),
                '{cpuprofile:id}': self.get_id(),
            }
        )

        return self.__getProxy().delete(
            url=UrlHelper.appendParameters(
                url,
                {'async:matrix':async}
            ),
            headers={"Correlation-Id":correlation_id,"Content-type":None}
        )

class ClusterCpuProfiles(Base):

    def __init__(self, cluster , context):
        Base.__init__(self, context)
        self.parentclass = cluster

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def add(self, cpuprofile, correlation_id=None, expect=None):

        '''
        @type CpuProfile:

        @param cpuprofile.name: string
        [@param cpuprofile.description: string]
        [@param cpuprofile.qos.id: string]
        [@param correlation_id: any string]
        [@param expect: 201-created]

        @return CpuProfile:
        '''

        url = '/clusters/{cluster:id}/cpuprofiles'

        result = self.__getProxy().add(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{cluster:id}': self.parentclass.get_id(),
                    }
                ),
                args={}
            ),
            body=ParseHelper.toXml(cpuprofile),
            headers={"Correlation-Id":correlation_id, "Expect":expect}
        )

        return ClusterCpuProfile(
            self.parentclass,
            result,
            self.context
        )

    def get(self, name=None, id=None):

        '''
        [@param id  : string (the id of the entity)]
        [@param name: string (the name of the entity)]

        @return CpuProfiles:
        '''

        url = '/clusters/{cluster:id}/cpuprofiles'

        if id:
            try :
                result = self.__getProxy().get(
                    url=UrlHelper.append(
                        UrlHelper.replace(
                            url,
                            {
                                '{cluster:id}': self.parentclass.get_id(),
                            }
                        ),
                        id
                    ),
                    headers={}
                )

                return ClusterCpuProfile(
                    self.parentclass,
                    result,
                    self.context
                )
            except RequestError as err:
                if err.status and err.status == 404:
                    return None
                raise err
        elif name:
            result = self.__getProxy().get(
                url=UrlHelper.replace(
                    url,
                    {
                        '{cluster:id}': self.parentclass.get_id(),
                    }
                ),
                headers={}
            ).get_cpu_profile()

            return ClusterCpuProfile(
                self.parentclass,
                FilterHelper.getItem(
                    FilterHelper.filter(
                        result,
                        {'name':name}
                    ),
                    query="name=" + name
                ),
                self.context
            )
        else:
            raise MissingParametersError(['id', 'name'])

    def list(self, max=None, **kwargs):
        '''
        [@param **kwargs: dict (property based filtering)"]
        [@param max: int (max results)]

        @return CpuProfiles:
        '''

        url = '/clusters/{cluster:id}/cpuprofiles'

        result = self.__getProxy().get(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{cluster:id}': self.parentclass.get_id(),
                    }
                ),
                args={'max:matrix':max}
            ),
            headers={}
        ).get_cpu_profile()

        return ParseHelper.toSubCollection(
            ClusterCpuProfile,
            self.parentclass,
            FilterHelper.filter(
                result,
                kwargs
            ),
            context=self.context
        )

class ClusterGlusterHook(params.GlusterHook, Base):
    def __init__(self, cluster, glusterhook, context):
        Base.__init__(self, context)
        self.parentclass = cluster
        self.superclass  =  glusterhook

        #SUB_COLLECTIONS
    def __new__(cls, cluster, glusterhook, context):
        if glusterhook is None: return None
        obj = object.__new__(cls)
        obj.__init__(cluster, glusterhook, context)
        return obj

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def delete(self, async=None, correlation_id=None):
        '''
        [@param async: boolean (true|false)]
        [@param correlation_id: any string]

        @return None:
        '''

        url = UrlHelper.replace(
            '/clusters/{cluster:id}/glusterhooks/{glusterhook:id}',
            {
                '{cluster:id}': self.parentclass.get_id(),
                '{glusterhook:id}': self.get_id(),
            }
        )

        return self.__getProxy().delete(
            url=UrlHelper.appendParameters(
                url,
                {'async:matrix':async}
            ),
            headers={"Correlation-Id":correlation_id,"Content-type":None}
        )

    def disable(self, action=params.Action(), correlation_id=None):
        '''
        @type Action:

        [@param action.async: boolean]
        [@param action.grace_period.expiry: long]
        [@param correlation_id: any string]

        @return Action:
        '''

        url = '/clusters/{cluster:id}/glusterhooks/{glusterhook:id}/disable'

        result = self.__getProxy().request(
            method='POST',
            url=UrlHelper.replace(
                url,
                {
                    '{cluster:id}': self.parentclass.get_id(),
                    '{glusterhook:id}': self.get_id(),
                }
            ),
            body=ParseHelper.toXml(action),
            headers={"Correlation-Id":correlation_id}
        )

        return result

    def enable(self, action=params.Action(), correlation_id=None):
        '''
        @type Action:

        [@param action.async: boolean]
        [@param action.grace_period.expiry: long]
        [@param correlation_id: any string]

        @return Action:
        '''

        url = '/clusters/{cluster:id}/glusterhooks/{glusterhook:id}/enable'

        result = self.__getProxy().request(
            method='POST',
            url=UrlHelper.replace(
                url,
                {
                    '{cluster:id}': self.parentclass.get_id(),
                    '{glusterhook:id}': self.get_id(),
                }
            ),
            body=ParseHelper.toXml(action),
            headers={"Correlation-Id":correlation_id}
        )

        return result

    def resolve(self, action=params.Action(), correlation_id=None):
        '''
        @type Action:

        @param action.resolution_type: string
        [@param action.host.id|name: string]
        [@param action.async: boolean]
        [@param action.grace_period.expiry: long]
        [@param correlation_id: any string]

        @return Action:
        '''

        url = '/clusters/{cluster:id}/glusterhooks/{glusterhook:id}/resolve'

        result = self.__getProxy().request(
            method='POST',
            url=UrlHelper.replace(
                url,
                {
                    '{cluster:id}': self.parentclass.get_id(),
                    '{glusterhook:id}': self.get_id(),
                }
            ),
            body=ParseHelper.toXml(action),
            headers={"Correlation-Id":correlation_id}
        )

        return result

class ClusterGlusterHooks(Base):

    def __init__(self, cluster , context):
        Base.__init__(self, context)
        self.parentclass = cluster

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def get(self, name=None, id=None):

        '''
        [@param id  : string (the id of the entity)]
        [@param name: string (the name of the entity)]

        @return GlusterHooks:
        '''

        url = '/clusters/{cluster:id}/glusterhooks'

        if id:
            try :
                result = self.__getProxy().get(
                    url=UrlHelper.append(
                        UrlHelper.replace(
                            url,
                            {
                                '{cluster:id}': self.parentclass.get_id(),
                            }
                        ),
                        id
                    ),
                    headers={}
                )

                return ClusterGlusterHook(
                    self.parentclass,
                    result,
                    self.context
                )
            except RequestError as err:
                if err.status and err.status == 404:
                    return None
                raise err
        elif name:
            result = self.__getProxy().get(
                url=UrlHelper.replace(
                    url,
                    {
                        '{cluster:id}': self.parentclass.get_id(),
                    }
                ),
                headers={}
            ).get_gluster_hook()

            return ClusterGlusterHook(
                self.parentclass,
                FilterHelper.getItem(
                    FilterHelper.filter(
                        result,
                        {'name':name}
                    ),
                    query="name=" + name
                ),
                self.context
            )
        else:
            raise MissingParametersError(['id', 'name'])

    def list(self, max=None, **kwargs):
        '''
        [@param **kwargs: dict (property based filtering)"]
        [@param max: int (max results)]

        @return GlusterHooks:
        '''

        url = '/clusters/{cluster:id}/glusterhooks'

        result = self.__getProxy().get(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{cluster:id}': self.parentclass.get_id(),
                    }
                ),
                args={'max:matrix':max}
            ),
            headers={}
        ).get_gluster_hook()

        return ParseHelper.toSubCollection(
            ClusterGlusterHook,
            self.parentclass,
            FilterHelper.filter(
                result,
                kwargs
            ),
            context=self.context
        )

class ClusterGlusterVolume(params.GlusterVolume, Base):
    def __init__(self, cluster, glustervolume, context):
        Base.__init__(self, context)
        self.parentclass = cluster
        self.superclass  =  glustervolume

        self.bricks = ClusterGlusterVolumeGlusterBricks(self, context)
        self.statistics = ClusterGlusterVolumeStatistics(self, context)

    def __new__(cls, cluster, glustervolume, context):
        if glustervolume is None: return None
        obj = object.__new__(cls)
        obj.__init__(cluster, glustervolume, context)
        return obj

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def delete(self, async=None):
        '''
        [@param async: boolean (true|false)]

        @return None:
        '''

        url = UrlHelper.replace(
            '/clusters/{cluster:id}/glustervolumes/{glustervolume:id}',
            {
                '{cluster:id}': self.parentclass.get_id(),
                '{glustervolume:id}': self.get_id(),
            }
        )

        return self.__getProxy().delete(
            url=UrlHelper.appendParameters(
                url,
                {'async:matrix':async}
            ),
            headers={"Content-type":None}
        )

    def activate(self, action=params.Action(), correlation_id=None):
        '''
        @type Action:

        @param action.bricks: collection
        {
          @ivar brick.name: string
        }
        [@param action.async: boolean]
        [@param action.grace_period.expiry: long]
        [@param correlation_id: any string]

        @return Action:
        '''

        url = '/clusters/{cluster:id}/glustervolumes/{glustervolume:id}/bricks/activate'

        result = self.__getProxy().request(
            method='POST',
            url=UrlHelper.replace(
                url,
                {
                    '{cluster:id}': self.parentclass.get_id(),
                    '{glustervolume:id}': self.get_id(),
                }
            ),
            body=ParseHelper.toXml(action),
            headers={"Correlation-Id":correlation_id}
        )

        return result

    def migrate(self, action=params.Action(), correlation_id=None):
        '''
        @type Action:

        @param action.bricks: collection
        {
          @ivar brick.name: string
        }
        [@param action.async: boolean]
        [@param action.grace_period.expiry: long]
        [@param correlation_id: any string]

        @return Action:
        '''

        url = '/clusters/{cluster:id}/glustervolumes/{glustervolume:id}/bricks/migrate'

        result = self.__getProxy().request(
            method='POST',
            url=UrlHelper.replace(
                url,
                {
                    '{cluster:id}': self.parentclass.get_id(),
                    '{glustervolume:id}': self.get_id(),
                }
            ),
            body=ParseHelper.toXml(action),
            headers={"Correlation-Id":correlation_id}
        )

        return result

    def stopmigrate(self, action=params.Action(), correlation_id=None):
        '''
        @type Action:

        @param action.bricks: collection
        {
          @ivar brick.name: string
        }
        [@param action.async: boolean]
        [@param action.grace_period.expiry: long]
        [@param correlation_id: any string]

        @return Action:
        '''

        url = '/clusters/{cluster:id}/glustervolumes/{glustervolume:id}/bricks/stopmigrate'

        result = self.__getProxy().request(
            method='POST',
            url=UrlHelper.replace(
                url,
                {
                    '{cluster:id}': self.parentclass.get_id(),
                    '{glustervolume:id}': self.get_id(),
                }
            ),
            body=ParseHelper.toXml(action),
            headers={"Correlation-Id":correlation_id}
        )

        return result

    def rebalance(self, action=params.Action(), correlation_id=None):
        '''
        @type Action:

        [@param action.fix_layout: boolean]
        [@param action.force: boolean]
        [@param action.async: boolean]
        [@param action.grace_period.expiry: long]
        [@param correlation_id: any string]

        @return Action:
        '''

        url = '/clusters/{cluster:id}/glustervolumes/{glustervolume:id}/rebalance'

        result = self.__getProxy().request(
            method='POST',
            url=UrlHelper.replace(
                url,
                {
                    '{cluster:id}': self.parentclass.get_id(),
                    '{glustervolume:id}': self.get_id(),
                }
            ),
            body=ParseHelper.toXml(action),
            headers={"Correlation-Id":correlation_id}
        )

        return result

    def resetalloptions(self, action=params.Action(), correlation_id=None):
        '''
        @type Action:

        [@param action.async: boolean]
        [@param action.grace_period.expiry: long]
        [@param correlation_id: any string]

        @return Action:
        '''

        url = '/clusters/{cluster:id}/glustervolumes/{glustervolume:id}/resetalloptions'

        result = self.__getProxy().request(
            method='POST',
            url=UrlHelper.replace(
                url,
                {
                    '{cluster:id}': self.parentclass.get_id(),
                    '{glustervolume:id}': self.get_id(),
                }
            ),
            body=ParseHelper.toXml(action),
            headers={"Correlation-Id":correlation_id}
        )

        return result

    def resetoption(self, action=params.Action(), correlation_id=None):
        '''
        @type Action:

        @param action.option.name: string
        @param action.force: boolean
        [@param action.async: boolean]
        [@param action.grace_period.expiry: long]
        [@param correlation_id: any string]

        @return Action:
        '''

        url = '/clusters/{cluster:id}/glustervolumes/{glustervolume:id}/resetoption'

        result = self.__getProxy().request(
            method='POST',
            url=UrlHelper.replace(
                url,
                {
                    '{cluster:id}': self.parentclass.get_id(),
                    '{glustervolume:id}': self.get_id(),
                }
            ),
            body=ParseHelper.toXml(action),
            headers={"Correlation-Id":correlation_id}
        )

        return result

    def setoption(self, action=params.Action(), correlation_id=None):
        '''
        @type Action:

        @param action.option.name: string
        @param action.option.value: string
        [@param action.async: boolean]
        [@param action.grace_period.expiry: long]
        [@param correlation_id: any string]

        @return Action:
        '''

        url = '/clusters/{cluster:id}/glustervolumes/{glustervolume:id}/setoption'

        result = self.__getProxy().request(
            method='POST',
            url=UrlHelper.replace(
                url,
                {
                    '{cluster:id}': self.parentclass.get_id(),
                    '{glustervolume:id}': self.get_id(),
                }
            ),
            body=ParseHelper.toXml(action),
            headers={"Correlation-Id":correlation_id}
        )

        return result

    def start(self, action=params.Action(), correlation_id=None):
        '''
        @type Action:

        [@param action.force: boolean]
        [@param action.async: boolean]
        [@param action.grace_period.expiry: long]
        [@param correlation_id: any string]

        @return Action:
        '''

        url = '/clusters/{cluster:id}/glustervolumes/{glustervolume:id}/start'

        result = self.__getProxy().request(
            method='POST',
            url=UrlHelper.replace(
                url,
                {
                    '{cluster:id}': self.parentclass.get_id(),
                    '{glustervolume:id}': self.get_id(),
                }
            ),
            body=ParseHelper.toXml(action),
            headers={"Correlation-Id":correlation_id}
        )

        return result

    def startprofile(self, action=params.Action(), correlation_id=None):
        '''
        @type Action:

        [@param action.async: boolean]
        [@param action.grace_period.expiry: long]
        [@param correlation_id: any string]

        @return Action:
        '''

        url = '/clusters/{cluster:id}/glustervolumes/{glustervolume:id}/startprofile'

        result = self.__getProxy().request(
            method='POST',
            url=UrlHelper.replace(
                url,
                {
                    '{cluster:id}': self.parentclass.get_id(),
                    '{glustervolume:id}': self.get_id(),
                }
            ),
            body=ParseHelper.toXml(action),
            headers={"Correlation-Id":correlation_id}
        )

        return result

    def stop(self, action=params.Action(), correlation_id=None):
        '''
        @type Action:

        [@param action.force: boolean]
        [@param action.async: boolean]
        [@param action.grace_period.expiry: long]
        [@param correlation_id: any string]

        @return Action:
        '''

        url = '/clusters/{cluster:id}/glustervolumes/{glustervolume:id}/stop'

        result = self.__getProxy().request(
            method='POST',
            url=UrlHelper.replace(
                url,
                {
                    '{cluster:id}': self.parentclass.get_id(),
                    '{glustervolume:id}': self.get_id(),
                }
            ),
            body=ParseHelper.toXml(action),
            headers={"Correlation-Id":correlation_id}
        )

        return result

    def stopprofile(self, action=params.Action(), correlation_id=None):
        '''
        @type Action:

        [@param action.async: boolean]
        [@param action.grace_period.expiry: long]
        [@param correlation_id: any string]

        @return Action:
        '''

        url = '/clusters/{cluster:id}/glustervolumes/{glustervolume:id}/stopprofile'

        result = self.__getProxy().request(
            method='POST',
            url=UrlHelper.replace(
                url,
                {
                    '{cluster:id}': self.parentclass.get_id(),
                    '{glustervolume:id}': self.get_id(),
                }
            ),
            body=ParseHelper.toXml(action),
            headers={"Correlation-Id":correlation_id}
        )

        return result

    def stoprebalance(self, action=params.Action(), correlation_id=None):
        '''
        @type Action:

        [@param action.async: boolean]
        [@param action.grace_period.expiry: long]
        [@param correlation_id: any string]

        @return Action:
        '''

        url = '/clusters/{cluster:id}/glustervolumes/{glustervolume:id}/stoprebalance'

        result = self.__getProxy().request(
            method='POST',
            url=UrlHelper.replace(
                url,
                {
                    '{cluster:id}': self.parentclass.get_id(),
                    '{glustervolume:id}': self.get_id(),
                }
            ),
            body=ParseHelper.toXml(action),
            headers={"Correlation-Id":correlation_id}
        )

        return result

class ClusterGlusterVolumeGlusterBrick(params.GlusterBrick, Base):
    def __init__(self, clusterglustervolume, glusterbrick, context):
        Base.__init__(self, context)
        self.parentclass = clusterglustervolume
        self.superclass  =  glusterbrick

        self.statistics = ClusterGlusterVolumeGlusterBrickStatistics(self, context)

    def __new__(cls, clusterglustervolume, glusterbrick, context):
        if glusterbrick is None: return None
        obj = object.__new__(cls)
        obj.__init__(clusterglustervolume, glusterbrick, context)
        return obj

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def delete(self, async=None):
        '''
        [@param async: boolean (true|false)]

        @return None:
        '''

        url = UrlHelper.replace(
            '/clusters/{cluster:id}/glustervolumes/{glustervolume:id}/bricks/{brick:id}',
            {
                '{cluster:id}': self.parentclass.parentclass.get_id(),
                '{glustervolume:id}': self.parentclass.get_id(),
                '{brick:id}': self.get_id(),
            }
        )

        return self.__getProxy().delete(
            url=UrlHelper.appendParameters(
                url,
                {'async:matrix':async}
            ),
            headers={"Content-type":None}
        )

    def replace(self, action=params.Action(), correlation_id=None):
        '''
        @type Action:

        @param action.brick.server_id: string
        @param action.brick.brick_dir: string
        [@param action.force: boolean]
        [@param action.async: boolean]
        [@param action.grace_period.expiry: long]
        [@param correlation_id: any string]

        @return Action:
        '''

        url = '/clusters/{cluster:id}/glustervolumes/{glustervolume:id}/bricks/{brick:id}/replace'

        result = self.__getProxy().request(
            method='POST',
            url=UrlHelper.replace(
                url,
                {
                    '{cluster:id}': self.parentclass.parentclass.get_id(),
                    '{glustervolume:id}': self.parentclass.get_id(),
                    '{brick:id}': self.get_id(),
                }
            ),
            body=ParseHelper.toXml(action),
            headers={"Correlation-Id":correlation_id}
        )

        return result

class ClusterGlusterVolumeGlusterBrickStatistic(params.Statistic, Base):
    def __init__(self, clusterglustervolumeglusterbrick, statistic, context):
        Base.__init__(self, context)
        self.parentclass = clusterglustervolumeglusterbrick
        self.superclass  =  statistic

        #SUB_COLLECTIONS
    def __new__(cls, clusterglustervolumeglusterbrick, statistic, context):
        if statistic is None: return None
        obj = object.__new__(cls)
        obj.__init__(clusterglustervolumeglusterbrick, statistic, context)
        return obj

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

class ClusterGlusterVolumeGlusterBrickStatistics(Base):

    def __init__(self, glusterbrick , context):
        Base.__init__(self, context)
        self.parentclass = glusterbrick

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def get(self, name=None, id=None):

        '''
        [@param id  : string (the id of the entity)]
        [@param name: string (the name of the entity)]

        @return Statistics:
        '''

        url = '/clusters/{cluster:id}/glustervolumes/{glustervolume:id}/bricks/{brick:id}/statistics'

        if id:
            try :
                result = self.__getProxy().get(
                    url=UrlHelper.append(
                        UrlHelper.replace(
                            url,
                            {
                                '{cluster:id}': self.parentclass.parentclass.parentclass.get_id(),
                                '{glustervolume:id}': self.parentclass.parentclass.get_id(),
                                '{brick:id}': self.parentclass.get_id(),
                            }
                        ),
                        id
                    ),
                    headers={}
                )

                return ClusterGlusterVolumeGlusterBrickStatistic(
                    self.parentclass,
                    result,
                    self.context
                )
            except RequestError as err:
                if err.status and err.status == 404:
                    return None
                raise err
        elif name:
            result = self.__getProxy().get(
                url=UrlHelper.replace(
                    url,
                    {
                        '{cluster:id}': self.parentclass.parentclass.parentclass.get_id(),
                        '{glustervolume:id}': self.parentclass.parentclass.get_id(),
                        '{brick:id}': self.parentclass.get_id(),
                    }
                ),
                headers={}
            ).get_statistic()

            return ClusterGlusterVolumeGlusterBrickStatistic(
                self.parentclass,
                FilterHelper.getItem(
                    FilterHelper.filter(
                        result,
                        {'name':name}
                    ),
                    query="name=" + name
                ),
                self.context
            )
        else:
            raise MissingParametersError(['id', 'name'])

    def list(self, **kwargs):
        '''
        [@param **kwargs: dict (property based filtering)"]

        @return Statistics:
        '''

        url = '/clusters/{cluster:id}/glustervolumes/{glustervolume:id}/bricks/{brick:id}/statistics'

        result = self.__getProxy().get(
            url=UrlHelper.replace(
                url,
                {
                    '{cluster:id}': self.parentclass.parentclass.parentclass.get_id(),
                    '{glustervolume:id}': self.parentclass.parentclass.get_id(),
                    '{brick:id}': self.parentclass.get_id(),
                }
            )
        ).get_statistic()

        return ParseHelper.toSubCollection(
            ClusterGlusterVolumeGlusterBrickStatistic,
            self.parentclass,
            FilterHelper.filter(
                result,
                kwargs
            ),
            context=self.context
        )

class ClusterGlusterVolumeGlusterBricks(Base):

    def __init__(self, glustervolume , context):
        Base.__init__(self, context)
        self.parentclass = glustervolume

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def add(self, brick, correlation_id=None, expect=None, force=None):

        '''
        @type GlusterBricks:

        @param brick: collection
        {
          @ivar brick.server_id: string
          @ivar brick.brick_dir: string
        }
        [@param replica_count: unsignedShort]
        [@param stripe_count: unsignedShort]
        [@param force: boolean (true|false)]
        [@param correlation_id: any string]
        [@param expect: 201-created]

        @return GlusterBricks:
        '''

        url = '/clusters/{cluster:id}/glustervolumes/{glustervolume:id}/bricks'

        result = self.__getProxy().add(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{cluster:id}': self.parentclass.parentclass.get_id(),
                        '{glustervolume:id}': self.parentclass.get_id(),
                    }
                ),
                args={'force:matrix':force}
            ),
            body=ParseHelper.toXml(brick),
            headers={"Correlation-Id":correlation_id, "Expect":expect}
        )

        return ClusterGlusterVolumeGlusterBrick(
            self.parentclass,
            result,
            self.context
        )

    def get(self, name=None, all_content=None, id=None):

        '''
        [@param id  : string (the id of the entity)]
        [@param name: string (the name of the entity)]
        [@param all_content: true|false]

        @return GlusterBricks:
        '''

        url = '/clusters/{cluster:id}/glustervolumes/{glustervolume:id}/bricks'

        if id:
            try :
                result = self.__getProxy().get(
                    url=UrlHelper.append(
                        UrlHelper.replace(
                            url,
                            {
                                '{cluster:id}': self.parentclass.parentclass.get_id(),
                                '{glustervolume:id}': self.parentclass.get_id(),
                            }
                        ),
                        id
                    ),
                    headers={"All-Content":all_content}
                )

                return ClusterGlusterVolumeGlusterBrick(
                    self.parentclass,
                    result,
                    self.context
                )
            except RequestError as err:
                if err.status and err.status == 404:
                    return None
                raise err
        elif name:
            result = self.__getProxy().get(
                url=UrlHelper.replace(
                    url,
                    {
                        '{cluster:id}': self.parentclass.parentclass.get_id(),
                        '{glustervolume:id}': self.parentclass.get_id(),
                    }
                ),
                headers={"All-Content":all_content}
            ).get_brick()

            return ClusterGlusterVolumeGlusterBrick(
                self.parentclass,
                FilterHelper.getItem(
                    FilterHelper.filter(
                        result,
                        {'name':name}
                    ),
                    query="name=" + name
                ),
                self.context
            )
        else:
            raise MissingParametersError(['id', 'name'])

    def list(self, max=None, all_content=None, **kwargs):
        '''
        [@param **kwargs: dict (property based filtering)"]
        [@param max: int (max results)]
        [@param all_content: true|false]

        @return GlusterBricks:
        '''

        url = '/clusters/{cluster:id}/glustervolumes/{glustervolume:id}/bricks'

        result = self.__getProxy().get(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{cluster:id}': self.parentclass.parentclass.get_id(),
                        '{glustervolume:id}': self.parentclass.get_id(),
                    }
                ),
                args={'max:matrix':max}
            ),
            headers={"All-Content":all_content}
        ).get_brick()

        return ParseHelper.toSubCollection(
            ClusterGlusterVolumeGlusterBrick,
            self.parentclass,
            FilterHelper.filter(
                result,
                kwargs
            ),
            context=self.context
        )

class ClusterGlusterVolumeStatistic(params.Statistic, Base):
    def __init__(self, clusterglustervolume, statistic, context):
        Base.__init__(self, context)
        self.parentclass = clusterglustervolume
        self.superclass  =  statistic

        #SUB_COLLECTIONS
    def __new__(cls, clusterglustervolume, statistic, context):
        if statistic is None: return None
        obj = object.__new__(cls)
        obj.__init__(clusterglustervolume, statistic, context)
        return obj

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

class ClusterGlusterVolumeStatistics(Base):

    def __init__(self, glustervolume , context):
        Base.__init__(self, context)
        self.parentclass = glustervolume

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def get(self, name=None, id=None):

        '''
        [@param id  : string (the id of the entity)]
        [@param name: string (the name of the entity)]

        @return Statistics:
        '''

        url = '/clusters/{cluster:id}/glustervolumes/{glustervolume:id}/statistics'

        if id:
            try :
                result = self.__getProxy().get(
                    url=UrlHelper.append(
                        UrlHelper.replace(
                            url,
                            {
                                '{cluster:id}': self.parentclass.parentclass.get_id(),
                                '{glustervolume:id}': self.parentclass.get_id(),
                            }
                        ),
                        id
                    ),
                    headers={}
                )

                return ClusterGlusterVolumeStatistic(
                    self.parentclass,
                    result,
                    self.context
                )
            except RequestError as err:
                if err.status and err.status == 404:
                    return None
                raise err
        elif name:
            result = self.__getProxy().get(
                url=UrlHelper.replace(
                    url,
                    {
                        '{cluster:id}': self.parentclass.parentclass.get_id(),
                        '{glustervolume:id}': self.parentclass.get_id(),
                    }
                ),
                headers={}
            ).get_statistic()

            return ClusterGlusterVolumeStatistic(
                self.parentclass,
                FilterHelper.getItem(
                    FilterHelper.filter(
                        result,
                        {'name':name}
                    ),
                    query="name=" + name
                ),
                self.context
            )
        else:
            raise MissingParametersError(['id', 'name'])

    def list(self, **kwargs):
        '''
        [@param **kwargs: dict (property based filtering)"]

        @return Statistics:
        '''

        url = '/clusters/{cluster:id}/glustervolumes/{glustervolume:id}/statistics'

        result = self.__getProxy().get(
            url=UrlHelper.replace(
                url,
                {
                    '{cluster:id}': self.parentclass.parentclass.get_id(),
                    '{glustervolume:id}': self.parentclass.get_id(),
                }
            )
        ).get_statistic()

        return ParseHelper.toSubCollection(
            ClusterGlusterVolumeStatistic,
            self.parentclass,
            FilterHelper.filter(
                result,
                kwargs
            ),
            context=self.context
        )

class ClusterGlusterVolumes(Base):

    def __init__(self, cluster , context):
        Base.__init__(self, context)
        self.parentclass = cluster

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def add(self, glustervolume, correlation_id=None, expect=None, force=None):

        '''
        @type GlusterVolume:

        @param gluster_volume.name: string
        @param gluster_volume.volume_type: string
        @param gluster_volume.bricks.brick: collection
        {
          @ivar brick.server_id: string
          @ivar brick.brick_dir: string
        }
        [@param gluster_volume.transport_types: collection]
        {
          [@ivar transport_type: string]
        }
        [@param gluster_volume.replica_count: unsignedShort]
        [@param gluster_volume.stripe_count: unsignedShort]
        [@param gluster_volume.options.option: collection]
        {
          [@ivar option.name: string]
          [@ivar option.value: string]
        }
        [@param force: boolean (true|false)]
        [@param correlation_id: any string]
        [@param expect: 201-created]

        @return GlusterVolume:
        '''

        url = '/clusters/{cluster:id}/glustervolumes'

        result = self.__getProxy().add(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{cluster:id}': self.parentclass.get_id(),
                    }
                ),
                args={'force:matrix':force}
            ),
            body=ParseHelper.toXml(glustervolume),
            headers={"Correlation-Id":correlation_id, "Expect":expect}
        )

        return ClusterGlusterVolume(
            self.parentclass,
            result,
            self.context
        )

    def get(self, name=None, id=None):

        '''
        [@param id  : string (the id of the entity)]
        [@param name: string (the name of the entity)]

        @return GlusterVolumes:
        '''

        url = '/clusters/{cluster:id}/glustervolumes'

        if id:
            try :
                result = self.__getProxy().get(
                    url=UrlHelper.append(
                        UrlHelper.replace(
                            url,
                            {
                                '{cluster:id}': self.parentclass.get_id(),
                            }
                        ),
                        id
                    ),
                    headers={}
                )

                return ClusterGlusterVolume(
                    self.parentclass,
                    result,
                    self.context
                )
            except RequestError as err:
                if err.status and err.status == 404:
                    return None
                raise err
        elif name:
            result = self.__getProxy().get(
                url=UrlHelper.replace(
                    url,
                    {
                        '{cluster:id}': self.parentclass.get_id(),
                    }
                ),
                headers={}
            ).get_gluster_volume()

            return ClusterGlusterVolume(
                self.parentclass,
                FilterHelper.getItem(
                    FilterHelper.filter(
                        result,
                        {'name':name}
                    ),
                    query="name=" + name
                ),
                self.context
            )
        else:
            raise MissingParametersError(['id', 'name'])

    def list(self, query=None, case_sensitive=True, max=None, **kwargs):
        '''
        [@param **kwargs: dict (property based filtering)"]
        [@param query: string (oVirt engine search dialect query)]
        [@param case_sensitive: boolean (true|false)]
        [@param max: int (max results)]

        @return GlusterVolumes:
        '''

        url = '/clusters/{cluster:id}/glustervolumes'

        result = self.__getProxy().get(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{cluster:id}': self.parentclass.get_id(),
                    }
                ),
                args={'search:query':query,'case_sensitive:matrix':case_sensitive,'max:matrix':max}
            ),
            headers={}
        ).get_gluster_volume()

        return ParseHelper.toSubCollection(
            ClusterGlusterVolume,
            self.parentclass,
            FilterHelper.filter(
                result,
                kwargs
            ),
            context=self.context
        )

class ClusterNetwork(params.Network, Base):
    def __init__(self, cluster, network, context):
        Base.__init__(self, context)
        self.parentclass = cluster
        self.superclass  =  network

        #SUB_COLLECTIONS
    def __new__(cls, cluster, network, context):
        if network is None: return None
        obj = object.__new__(cls)
        obj.__init__(cluster, network, context)
        return obj

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def delete(self, async=None, correlation_id=None):
        '''
        [@param async: boolean (true|false)]
        [@param correlation_id: any string]

        @return None:
        '''

        url = UrlHelper.replace(
            '/clusters/{cluster:id}/networks/{network:id}',
            {
                '{cluster:id}': self.parentclass.get_id(),
                '{network:id}': self.get_id(),
            }
        )

        return self.__getProxy().delete(
            url=UrlHelper.appendParameters(
                url,
                {'async:matrix':async}
            ),
            headers={"Correlation-Id":correlation_id,"Content-type":None}
        )

    def update(self, async=None, correlation_id=None, expect=None):
        '''
        [@param network.display: boolean]
        [@param network.usages.usage: collection]
        {
          [@ivar usage: string]
        }
        [@param async: boolean (true|false)]
        [@param correlation_id: any string]
        [@param expect: 202-accepted]

        @return Network:
        '''

        url = '/clusters/{cluster:id}/networks/{network:id}'
        url = UrlHelper.replace(
            url,
            {
                '{cluster:id}': self.parentclass.get_id(),
                '{network:id}': self.get_id(),
            }
        )

        result = self.__getProxy().update(
            url=UrlHelper.appendParameters(url, {'async:matrix':async}),
            body=ParseHelper.toXml(self.superclass),
            headers={"Correlation-Id":correlation_id, "Expect":expect}
        )

        return ClusterNetwork(
            self.parentclass,
            result,
            self.context
        )

class ClusterNetworks(Base):

    def __init__(self, cluster , context):
        Base.__init__(self, context)
        self.parentclass = cluster

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def add(self, network, correlation_id=None, expect=None):

        '''
        @type Network:

        @param network.id|name: string
        [@param network.usages.usage: collection]
        {
          [@ivar usage: string]
        }
        [@param correlation_id: any string]
        [@param expect: 201-created]

        @return Network:
        '''

        url = '/clusters/{cluster:id}/networks'

        result = self.__getProxy().add(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{cluster:id}': self.parentclass.get_id(),
                    }
                ),
                args={}
            ),
            body=ParseHelper.toXml(network),
            headers={"Correlation-Id":correlation_id, "Expect":expect}
        )

        return ClusterNetwork(
            self.parentclass,
            result,
            self.context
        )

    def get(self, name=None, id=None):

        '''
        [@param id  : string (the id of the entity)]
        [@param name: string (the name of the entity)]

        @return Networks:
        '''

        url = '/clusters/{cluster:id}/networks'

        if id:
            try :
                result = self.__getProxy().get(
                    url=UrlHelper.append(
                        UrlHelper.replace(
                            url,
                            {
                                '{cluster:id}': self.parentclass.get_id(),
                            }
                        ),
                        id
                    ),
                    headers={}
                )

                return ClusterNetwork(
                    self.parentclass,
                    result,
                    self.context
                )
            except RequestError as err:
                if err.status and err.status == 404:
                    return None
                raise err
        elif name:
            result = self.__getProxy().get(
                url=UrlHelper.replace(
                    url,
                    {
                        '{cluster:id}': self.parentclass.get_id(),
                    }
                ),
                headers={}
            ).get_network()

            return ClusterNetwork(
                self.parentclass,
                FilterHelper.getItem(
                    FilterHelper.filter(
                        result,
                        {'name':name}
                    ),
                    query="name=" + name
                ),
                self.context
            )
        else:
            raise MissingParametersError(['id', 'name'])

    def list(self, max=None, **kwargs):
        '''
        [@param **kwargs: dict (property based filtering)"]
        [@param max: int (max results)]

        @return Networks:
        '''

        url = '/clusters/{cluster:id}/networks'

        result = self.__getProxy().get(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{cluster:id}': self.parentclass.get_id(),
                    }
                ),
                args={'max:matrix':max}
            ),
            headers={}
        ).get_network()

        return ParseHelper.toSubCollection(
            ClusterNetwork,
            self.parentclass,
            FilterHelper.filter(
                result,
                kwargs
            ),
            context=self.context
        )

class ClusterPermission(params.Permission, Base):
    def __init__(self, cluster, permission, context):
        Base.__init__(self, context)
        self.parentclass = cluster
        self.superclass  =  permission

        #SUB_COLLECTIONS
    def __new__(cls, cluster, permission, context):
        if permission is None: return None
        obj = object.__new__(cls)
        obj.__init__(cluster, permission, context)
        return obj

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def delete(self, async=None, correlation_id=None):
        '''
        [@param async: boolean (true|false)]
        [@param correlation_id: any string]

        @return None:
        '''

        url = UrlHelper.replace(
            '/clusters/{cluster:id}/permissions/{permission:id}',
            {
                '{cluster:id}': self.parentclass.get_id(),
                '{permission:id}': self.get_id(),
            }
        )

        return self.__getProxy().delete(
            url=UrlHelper.appendParameters(
                url,
                {'async:matrix':async}
            ),
            headers={"Correlation-Id":correlation_id,"Content-type":None}
        )

class ClusterPermissions(Base):

    def __init__(self, cluster , context):
        Base.__init__(self, context)
        self.parentclass = cluster

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def add(self, permission, correlation_id=None, expect=None):

        '''
        @type Permission:

        Overload 1:
          @param permission.user.id: string
          @param permission.role.id|name: string
        Overload 2:
          @param permission.group.id: string
          @param permission.role.id|name: string
        [@param correlation_id: any string]
        [@param expect: 201-created]

        @return Permission:
        '''

        url = '/clusters/{cluster:id}/permissions'

        result = self.__getProxy().add(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{cluster:id}': self.parentclass.get_id(),
                    }
                ),
                args={}
            ),
            body=ParseHelper.toXml(permission),
            headers={"Correlation-Id":correlation_id, "Expect":expect}
        )

        return ClusterPermission(
            self.parentclass,
            result,
            self.context
        )

    def get(self, name=None, id=None):

        '''
        [@param id  : string (the id of the entity)]
        [@param name: string (the name of the entity)]

        @return Permissions:
        '''

        url = '/clusters/{cluster:id}/permissions'

        if id:
            try :
                result = self.__getProxy().get(
                    url=UrlHelper.append(
                        UrlHelper.replace(
                            url,
                            {
                                '{cluster:id}': self.parentclass.get_id(),
                            }
                        ),
                        id
                    ),
                    headers={}
                )

                return ClusterPermission(
                    self.parentclass,
                    result,
                    self.context
                )
            except RequestError as err:
                if err.status and err.status == 404:
                    return None
                raise err
        elif name:
            result = self.__getProxy().get(
                url=UrlHelper.replace(
                    url,
                    {
                        '{cluster:id}': self.parentclass.get_id(),
                    }
                ),
                headers={}
            ).get_permission()

            return ClusterPermission(
                self.parentclass,
                FilterHelper.getItem(
                    FilterHelper.filter(
                        result,
                        {'name':name}
                    ),
                    query="name=" + name
                ),
                self.context
            )
        else:
            raise MissingParametersError(['id', 'name'])

    def list(self, max=None, **kwargs):
        '''
        [@param **kwargs: dict (property based filtering)"]
        [@param max: int (max results)]

        @return Permissions:
        '''

        url = '/clusters/{cluster:id}/permissions'

        result = self.__getProxy().get(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{cluster:id}': self.parentclass.get_id(),
                    }
                ),
                args={'max:matrix':max}
            ),
            headers={}
        ).get_permission()

        return ParseHelper.toSubCollection(
            ClusterPermission,
            self.parentclass,
            FilterHelper.filter(
                result,
                kwargs
            ),
            context=self.context
        )

class Clusters(Base):
    def __init__(self, context):
        Base.__init__(self, context)

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def add(self, cluster, correlation_id=None, expect=None):
        '''
        @type Cluster:

        @param cluster.data_center.id|name: string
        @param cluster.name: string
        @param cluster.version.major: int
        @param cluster.version.minor: int
        @param cluster.cpu.id: string
        [@param cluster.description: string]
        [@param cluster.comment: string]
        [@param cluster.memory_policy.overcommit.percent: double]
        [@param cluster.memory_policy.transparent_hugepages.enabled: boolean]
        [@param cluster.scheduling_policy.policy: string]
        [@param cluster.scheduling_policy.thresholds.low: int]
        [@param cluster.scheduling_policy.thresholds.high: int]
        [@param cluster.scheduling_policy.thresholds.duration: int]
        [@param cluster.scheduling_policy.id: string]
        [@param cluster.scheduling_policy.properties.property: collection]
        {
          [@ivar property.name: string]
          [@ivar property.value: string]
        }
        [@param cluster.error_handling.on_error: string]
        [@param cluster.virt_service: boolean]
        [@param cluster.gluster_service: boolean]
        [@param cluster.threads_as_cores: boolean]
        [@param cluster.tunnel_migration: boolean]
        [@param cluster.trusted_service: boolean]
        [@param cluster.ha_reservation: boolean]
        [@param cluster.ballooning_enabled: boolean]
        [@param cluster.cpu.architecture: string]
        [@param cluster.display.proxy: string]
        [@param cluster.ksm.enabled: boolean]
        [@param cluster.ksm.merge_across_nodes: boolean]
        [@param cluster.fencing_policy.enabled: boolean]
        [@param cluster.fencing_policy.skip_if_sd_active.enabled: boolean]
        [@param cluster.fencing_policy.skip_if_connectivity_broken.enabled: boolean]
        [@param cluster.fencing_policy.skip_if_connectivity_broken.threshold: int]
        [@param cluster.management_network.id|name: string]
        [@param cluster.maintenance_reason_required: boolean]
        [@param correlation_id: any string]
        [@param expect: 201-created]

        @return Cluster:
        '''

        url = '/clusters'

        result = self.__getProxy().add(
           url=UrlHelper.appendParameters(
                url=url,
                args={}
           ),
           body=ParseHelper.toXml(cluster),
           headers={"Correlation-Id":correlation_id, "Expect":expect}
        )

        return Cluster(result, self.context)

    def get(self, name=None, all_content=None, id=None):
        '''
        [@param id  : string (the id of the entity)]
        [@param name: string (the name of the entity)]
        [@param all_content: true|false]

        @return Clusters:
        '''

        url = '/clusters'

        if id:
            try :
                return Cluster(
                    self.__getProxy().get(
                        url=UrlHelper.append(url, id),
                        headers={"All-Content":all_content}
                    ),
                    self.context
                )
            except RequestError as err:
                if err.status and err.status == 404:
                    return None
                raise err
        elif name:
            result = self.__getProxy().get(
                url=UrlHelper.appendParameters(url, {'search:query':'name='+name}),
                headers={"All-Content":all_content}
            ).get_cluster()

            return Cluster(
                FilterHelper.getItem(
                    FilterHelper.filter(result, {'name':name}),
                    query="name=" + name
                ),
                self.context
            )
        else:
            raise MissingParametersError(['id', 'name'])

    def list(self, query=None, case_sensitive=True, max=None, all_content=None, **kwargs):
        '''
        [@param **kwargs: dict (property based filtering)]
        [@param query: string (oVirt engine search dialect query)]
        [@param case_sensitive: boolean (true|false)]
        [@param max: int (max results)]
        [@param all_content: true|false]

        @return Clusters:
        '''

        url='/clusters'

        result = self.__getProxy().get(
            url=UrlHelper.appendParameters(url, {'search:query':query,'case_sensitive:matrix':case_sensitive,'max:matrix':max}),
            headers={"All-Content":all_content}
        ).get_cluster()

        return ParseHelper.toCollection(
            Cluster,
            FilterHelper.filter(result, kwargs),
            context=self.context
        )

class CpuProfile(params.CpuProfile, Base):
    def __init__(self, cpuprofile, context):
        Base.__init__(self, context)
        self.superclass = cpuprofile

        self.permissions = CpuProfilePermissions(self, context)

    def __new__(cls, cpuprofile, context):
        if cpuprofile is None: return None
        obj = object.__new__(cls)
        obj.__init__(cpuprofile, context)
        return obj

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def delete(self, async=None, correlation_id=None):
        '''
        [@param async: boolean (true|false)]
        [@param correlation_id: any string]

        @return None:
        '''

        url = UrlHelper.replace(
            '/cpuprofiles/{cpuprofile:id}',
            {
                '{cpuprofile:id}': self.get_id(),
            }
        )

        return self.__getProxy().delete(
            url=UrlHelper.appendParameters(
                url,
                {'async:matrix':async}
            ),
            headers={"Correlation-Id":correlation_id,"Content-type":None}
        )

    def update(self, correlation_id=None, expect=None):
        '''
        [@param cpuprofile.name: string]
        [@param cpuprofile.description: string]
        [@param cpuprofile.qos.id: string]
        [@param correlation_id: any string]
        [@param expect: 202-accepted]

        @return CpuProfile:
        '''

        url = '/cpuprofiles/{cpuprofile:id}'

        result = self.__getProxy().update(
            url=UrlHelper.replace(
                url,
                {
                    '{cpuprofile:id}': self.get_id(),
                }
            ),
            body=ParseHelper.toXml(self.superclass),
            headers={"Correlation-Id":correlation_id, "Expect":expect}
        )

        return CpuProfile(result, self.context)

class CpuProfilePermission(params.Permission, Base):
    def __init__(self, cpuprofile, permission, context):
        Base.__init__(self, context)
        self.parentclass = cpuprofile
        self.superclass  =  permission

        #SUB_COLLECTIONS
    def __new__(cls, cpuprofile, permission, context):
        if permission is None: return None
        obj = object.__new__(cls)
        obj.__init__(cpuprofile, permission, context)
        return obj

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def delete(self, async=None, correlation_id=None):
        '''
        [@param async: boolean (true|false)]
        [@param correlation_id: any string]

        @return None:
        '''

        url = UrlHelper.replace(
            '/cpuprofiles/{cpuprofile:id}/permissions/{permission:id}',
            {
                '{cpuprofile:id}': self.parentclass.get_id(),
                '{permission:id}': self.get_id(),
            }
        )

        return self.__getProxy().delete(
            url=UrlHelper.appendParameters(
                url,
                {'async:matrix':async}
            ),
            headers={"Correlation-Id":correlation_id,"Content-type":None}
        )

class CpuProfilePermissions(Base):

    def __init__(self, cpuprofile , context):
        Base.__init__(self, context)
        self.parentclass = cpuprofile

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def add(self, permission, correlation_id=None, expect=None):

        '''
        @type Permission:

        Overload 1:
          @param permission.user.id: string
          @param permission.role.id|name: string
        Overload 2:
          @param permission.group.id: string
          @param permission.role.id|name: string
        [@param correlation_id: any string]
        [@param expect: 201-created]

        @return Permission:
        '''

        url = '/cpuprofiles/{cpuprofile:id}/permissions'

        result = self.__getProxy().add(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{cpuprofile:id}': self.parentclass.get_id(),
                    }
                ),
                args={}
            ),
            body=ParseHelper.toXml(permission),
            headers={"Correlation-Id":correlation_id, "Expect":expect}
        )

        return CpuProfilePermission(
            self.parentclass,
            result,
            self.context
        )

    def get(self, name=None, id=None):

        '''
        [@param id  : string (the id of the entity)]
        [@param name: string (the name of the entity)]

        @return Permissions:
        '''

        url = '/cpuprofiles/{cpuprofile:id}/permissions'

        if id:
            try :
                result = self.__getProxy().get(
                    url=UrlHelper.append(
                        UrlHelper.replace(
                            url,
                            {
                                '{cpuprofile:id}': self.parentclass.get_id(),
                            }
                        ),
                        id
                    ),
                    headers={}
                )

                return CpuProfilePermission(
                    self.parentclass,
                    result,
                    self.context
                )
            except RequestError as err:
                if err.status and err.status == 404:
                    return None
                raise err
        elif name:
            result = self.__getProxy().get(
                url=UrlHelper.replace(
                    url,
                    {
                        '{cpuprofile:id}': self.parentclass.get_id(),
                    }
                ),
                headers={}
            ).get_permission()

            return CpuProfilePermission(
                self.parentclass,
                FilterHelper.getItem(
                    FilterHelper.filter(
                        result,
                        {'name':name}
                    ),
                    query="name=" + name
                ),
                self.context
            )
        else:
            raise MissingParametersError(['id', 'name'])

    def list(self, max=None, **kwargs):
        '''
        [@param **kwargs: dict (property based filtering)"]
        [@param max: int (max results)]

        @return Permissions:
        '''

        url = '/cpuprofiles/{cpuprofile:id}/permissions'

        result = self.__getProxy().get(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{cpuprofile:id}': self.parentclass.get_id(),
                    }
                ),
                args={'max:matrix':max}
            ),
            headers={}
        ).get_permission()

        return ParseHelper.toSubCollection(
            CpuProfilePermission,
            self.parentclass,
            FilterHelper.filter(
                result,
                kwargs
            ),
            context=self.context
        )

class CpuProfiles(Base):
    def __init__(self, context):
        Base.__init__(self, context)

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def add(self, cpuprofile, correlation_id=None, expect=None):
        '''
        @type CpuProfile:

        @param cpuprofile.cluster.id: string
        @param cpuprofile.name: string
        [@param cpuprofile.description: string]
        [@param cpuprofile.qos.id: string]
        [@param correlation_id: any string]
        [@param expect: 201-created]

        @return CpuProfile:
        '''

        url = '/cpuprofiles'

        result = self.__getProxy().add(
           url=UrlHelper.appendParameters(
                url=url,
                args={}
           ),
           body=ParseHelper.toXml(cpuprofile),
           headers={"Correlation-Id":correlation_id, "Expect":expect}
        )

        return CpuProfile(result, self.context)

    def get(self, name=None, id=None):
        '''
        [@param id  : string (the id of the entity)]
        [@param name: string (the name of the entity)]

        @return CpuProfiles:
        '''

        url = '/cpuprofiles'

        if id:
            try :
                return CpuProfile(
                    self.__getProxy().get(
                                url=UrlHelper.append(url, id),
                                headers={}
                    ),
                    self.context
                )
            except RequestError as err:
                if err.status and err.status == 404:
                    return None
                raise err
        elif name:
            result = self.__getProxy().get(
                    url=url,
                    headers={}
            ).get_cpu_profile()

            return CpuProfile(
                FilterHelper.getItem(
                    FilterHelper.filter(result, {'name':name}),
                    query="name=" + name
                ),
                self.context
            )
        else:
            raise MissingParametersError(['id', 'name'])


    def list(self, max=None, **kwargs):
        '''
        [@param **kwargs: dict (property based filtering)]
        [@param max: int (max results)]

        @return CpuProfiles:
        '''

        url='/cpuprofiles'

        result = self.__getProxy().get(
            url=UrlHelper.appendParameters(url, {'max:matrix':max}),
            headers={}
        ).get_cpu_profile()

        return ParseHelper.toCollection(
            CpuProfile,
            FilterHelper.filter(result, kwargs),
            context=self.context
        )

class DataCenter(params.DataCenter, Base):
    def __init__(self, datacenter, context):
        Base.__init__(self, context)
        self.superclass = datacenter

        self.clusters = DataCenterClusters(self, context)
        self.iscsibonds = DataCenterIscsiBonds(self, context)
        self.networks = DataCenterNetworks(self, context)
        self.permissions = DataCenterPermissions(self, context)
        self.qoss = DataCenterQoSs(self, context)
        self.quotas = DataCenterQuotas(self, context)
        self.storagedomains = DataCenterStorageDomains(self, context)

    def __new__(cls, datacenter, context):
        if datacenter is None: return None
        obj = object.__new__(cls)
        obj.__init__(datacenter, context)
        return obj

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def delete(self, action=params.Action(), async=None, correlation_id=None):
        '''
        @type Action:

        [@param action.force: boolean]
        [@param action.async: boolean]
        [@param action.grace_period.expiry: long]
        [@param correlation_id: any string]

        @return None:
        '''

        url = UrlHelper.replace(
            '/datacenters/{datacenter:id}',
            {
                '{datacenter:id}': self.get_id(),
            }
        )

        return self.__getProxy().delete(
            url=UrlHelper.appendParameters(
                url,
                {'async:matrix':async}
            ),
            body=ParseHelper.toXml(action),
            headers={"Correlation-Id":correlation_id}
        )

    def update(self, correlation_id=None, expect=None):
        '''
        [@param datacenter.name: string]
        [@param datacenter.description: string]
        [@param datacenter.comment: string]
        [@param datacenter.storage_type: string]
        [@param datacenter.local: boolean]
        [@param datacenter.version.major: int]
        [@param datacenter.version.minor: int]
        [@param datacenter.storage_format: string]
        [@param datacenter.mac_pool.id: string]
        [@param correlation_id: any string]
        [@param expect: 202-accepted]

        @return DataCenter:
        '''

        url = '/datacenters/{datacenter:id}'

        result = self.__getProxy().update(
            url=UrlHelper.replace(
                url,
                {
                    '{datacenter:id}': self.get_id(),
                }
            ),
            body=ParseHelper.toXml(self.superclass),
            headers={"Correlation-Id":correlation_id, "Expect":expect}
        )

        return DataCenter(result, self.context)

class DataCenterCluster(params.Cluster, Base):
    def __init__(self, datacenter, cluster, context):
        Base.__init__(self, context)
        self.parentclass = datacenter
        self.superclass  =  cluster

        self.affinitygroups = DataCenterClusterAffinityGroups(self, context)
        self.cpuprofiles = DataCenterClusterCpuProfiles(self, context)
        self.glusterhooks = DataCenterClusterGlusterHooks(self, context)
        self.glustervolumes = DataCenterClusterGlusterVolumes(self, context)
        self.networks = DataCenterClusterNetworks(self, context)
        self.permissions = DataCenterClusterPermissions(self, context)

    def __new__(cls, datacenter, cluster, context):
        if cluster is None: return None
        obj = object.__new__(cls)
        obj.__init__(datacenter, cluster, context)
        return obj

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def delete(self, async=None, correlation_id=None):
        '''
        [@param async: boolean (true|false)]
        [@param correlation_id: any string]

        @return None:
        '''

        url = UrlHelper.replace(
            '/datacenters/{datacenter:id}/clusters/{cluster:id}',
            {
                '{datacenter:id}': self.parentclass.get_id(),
                '{cluster:id}': self.get_id(),
            }
        )

        return self.__getProxy().delete(
            url=UrlHelper.appendParameters(
                url,
                {'async:matrix':async}
            ),
            headers={"Correlation-Id":correlation_id,"Content-type":None}
        )

    def update(self, async=None, correlation_id=None, expect=None):
        '''
        [@param cluster.name: string]
        [@param cluster.description: string]
        [@param cluster.cpu.id: string]
        [@param cluster.version.major: int]
        [@param cluster.version.minor: int]
        [@param cluster.memory_policy.overcommit.percent: double]
        [@param cluster.memory_policy.transparent_hugepages.enabled: boolean]
        [@param cluster.scheduling_policy.policy: string]
        [@param cluster.scheduling_policy.thresholds.low: int]
        [@param cluster.scheduling_policy.thresholds.high: int]
        [@param cluster.scheduling_policy.thresholds.duration: int]
        [@param cluster.scheduling_policy.id: string]
        [@param cluster.scheduling_policy.properties.property: collection]
        {
          [@ivar property.name: string]
          [@ivar property.value: string]
        }
        [@param cluster.error_handling.on_error: string]
        [@param cluster.virt_service: boolean]
        [@param cluster.gluster_service: boolean]
        [@param cluster.threads_as_cores: boolean]
        [@param cluster.tunnel_migration: boolean]
        [@param cluster.trusted_service: boolean]
        [@param cluster.ha_reservation: boolean]
        [@param cluster.ballooning_enabled: boolean]
        [@param cluster.cpu.architecture: string]
        [@param cluster.display.proxy: string]
        [@param cluster.ksm.enabled: boolean]
        [@param async: boolean (true|false)]
        [@param correlation_id: any string]
        [@param expect: 202-accepted]

        @return Cluster:
        '''

        url = '/datacenters/{datacenter:id}/clusters/{cluster:id}'
        url = UrlHelper.replace(
            url,
            {
                '{datacenter:id}': self.parentclass.get_id(),
                '{cluster:id}': self.get_id(),
            }
        )

        result = self.__getProxy().update(
            url=UrlHelper.appendParameters(url, {'async:matrix':async}),
            body=ParseHelper.toXml(self.superclass),
            headers={"Correlation-Id":correlation_id, "Expect":expect}
        )

        return DataCenterCluster(
            self.parentclass,
            result,
            self.context
        )

    def resetemulatedmachine(self, action=params.Action()):
        '''
        @type Action:


        @return Action:
        '''

        url = '/datacenters/{datacenter:id}/clusters/{cluster:id}/resetemulatedmachine'

        result = self.__getProxy().request(
            method='POST',
            url=UrlHelper.replace(
                url,
                {
                    '{datacenter:id}': self.parentclass.get_id(),
                    '{cluster:id}': self.get_id(),
                }
            ),
            body=ParseHelper.toXml(action),
            headers={}
        )

        return result

class DataCenterClusterAffinityGroup(params.AffinityGroup, Base):
    def __init__(self, datacentercluster, affinitygroup, context):
        Base.__init__(self, context)
        self.parentclass = datacentercluster
        self.superclass  =  affinitygroup

        self.vms = DataCenterClusterAffinityGroupVMs(self, context)

    def __new__(cls, datacentercluster, affinitygroup, context):
        if affinitygroup is None: return None
        obj = object.__new__(cls)
        obj.__init__(datacentercluster, affinitygroup, context)
        return obj

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def delete(self, async=None):
        '''
        [@param async: boolean (true|false)]

        @return None:
        '''

        url = UrlHelper.replace(
            '/datacenters/{datacenter:id}/clusters/{cluster:id}/affinitygroups/{affinitygroup:id}',
            {
                '{datacenter:id}': self.parentclass.parentclass.get_id(),
                '{cluster:id}': self.parentclass.get_id(),
                '{affinitygroup:id}': self.get_id(),
            }
        )

        return self.__getProxy().delete(
            url=UrlHelper.appendParameters(
                url,
                {'async:matrix':async}
            ),
            headers={"Content-type":None}
        )

    def update(self, async=None):
        '''
        [@param async: boolean (true|false)]

        @return AffinityGroup:
        '''

        url = '/datacenters/{datacenter:id}/clusters/{cluster:id}/affinitygroups/{affinitygroup:id}'
        url = UrlHelper.replace(
            url,
            {
                '{datacenter:id}': self.parentclass.parentclass.get_id(),
                '{cluster:id}': self.parentclass.get_id(),
                '{affinitygroup:id}': self.get_id(),
            }
        )

        result = self.__getProxy().update(
            url=UrlHelper.appendParameters(url, {'async:matrix':async}),
            body=ParseHelper.toXml(self.superclass),
            headers={}
        )

        return DataCenterClusterAffinityGroup(
            self.parentclass,
            result,
            self.context
        )

class DataCenterClusterAffinityGroupVM(params.VM, Base):
    def __init__(self, datacenterclusteraffinitygroup, vm, context):
        Base.__init__(self, context)
        self.parentclass = datacenterclusteraffinitygroup
        self.superclass  =  vm

        #SUB_COLLECTIONS
    def __new__(cls, datacenterclusteraffinitygroup, vm, context):
        if vm is None: return None
        obj = object.__new__(cls)
        obj.__init__(datacenterclusteraffinitygroup, vm, context)
        return obj

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def delete(self, async=None):
        '''
        [@param async: boolean (true|false)]

        @return None:
        '''

        url = UrlHelper.replace(
            '/datacenters/{datacenter:id}/clusters/{cluster:id}/affinitygroups/{affinitygroup:id}/vms/{vm:id}',
            {
                '{datacenter:id}': self.parentclass.parentclass.parentclass.get_id(),
                '{cluster:id}': self.parentclass.parentclass.get_id(),
                '{affinitygroup:id}': self.parentclass.get_id(),
                '{vm:id}': self.get_id(),
            }
        )

        return self.__getProxy().delete(
            url=UrlHelper.appendParameters(
                url,
                {'async:matrix':async}
            ),
            headers={"Content-type":None}
        )

class DataCenterClusterAffinityGroupVMs(Base):

    def __init__(self, affinitygroup , context):
        Base.__init__(self, context)
        self.parentclass = affinitygroup

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def add(self, vm):

        '''
        @type VM:


        @return VM:
        '''

        url = '/datacenters/{datacenter:id}/clusters/{cluster:id}/affinitygroups/{affinitygroup:id}/vms'

        result = self.__getProxy().add(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{datacenter:id}': self.parentclass.parentclass.parentclass.get_id(),
                        '{cluster:id}': self.parentclass.parentclass.get_id(),
                        '{affinitygroup:id}': self.parentclass.get_id(),
                    }
                ),
                args={}
            ),
            body=ParseHelper.toXml(vm),
            headers={}
        )

        return DataCenterClusterAffinityGroupVM(
            self.parentclass,
            result,
            self.context
        )

    def get(self, name=None, id=None):

        '''
        [@param id  : string (the id of the entity)]
        [@param name: string (the name of the entity)]

        @return VMs:
        '''

        url = '/datacenters/{datacenter:id}/clusters/{cluster:id}/affinitygroups/{affinitygroup:id}/vms'

        if id:
            try :
                result = self.__getProxy().get(
                    url=UrlHelper.append(
                        UrlHelper.replace(
                            url,
                            {
                                '{datacenter:id}': self.parentclass.parentclass.parentclass.get_id(),
                                '{cluster:id}': self.parentclass.parentclass.get_id(),
                                '{affinitygroup:id}': self.parentclass.get_id(),
                            }
                        ),
                        id
                    ),
                    headers={}
                )

                return DataCenterClusterAffinityGroupVM(
                    self.parentclass,
                    result,
                    self.context
                )
            except RequestError as err:
                if err.status and err.status == 404:
                    return None
                raise err
        elif name:
            result = self.__getProxy().get(
                url=UrlHelper.replace(
                    url,
                    {
                        '{datacenter:id}': self.parentclass.parentclass.parentclass.get_id(),
                        '{cluster:id}': self.parentclass.parentclass.get_id(),
                        '{affinitygroup:id}': self.parentclass.get_id(),
                    }
                ),
                headers={}
            ).get_vm()

            return DataCenterClusterAffinityGroupVM(
                self.parentclass,
                FilterHelper.getItem(
                    FilterHelper.filter(
                        result,
                        {'name':name}
                    ),
                    query="name=" + name
                ),
                self.context
            )
        else:
            raise MissingParametersError(['id', 'name'])

    def list(self, max=None, **kwargs):
        '''
        [@param **kwargs: dict (property based filtering)"]
        [@param max: int (max results)]

        @return VMs:
        '''

        url = '/datacenters/{datacenter:id}/clusters/{cluster:id}/affinitygroups/{affinitygroup:id}/vms'

        result = self.__getProxy().get(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{datacenter:id}': self.parentclass.parentclass.parentclass.get_id(),
                        '{cluster:id}': self.parentclass.parentclass.get_id(),
                        '{affinitygroup:id}': self.parentclass.get_id(),
                    }
                ),
                args={'max:matrix':max}
            ),
            headers={}
        ).get_vm()

        return ParseHelper.toSubCollection(
            DataCenterClusterAffinityGroupVM,
            self.parentclass,
            FilterHelper.filter(
                result,
                kwargs
            ),
            context=self.context
        )

class DataCenterClusterAffinityGroups(Base):

    def __init__(self, cluster , context):
        Base.__init__(self, context)
        self.parentclass = cluster

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def add(self, affinitygroup):

        '''
        @type AffinityGroup:


        @return AffinityGroup:
        '''

        url = '/datacenters/{datacenter:id}/clusters/{cluster:id}/affinitygroups'

        result = self.__getProxy().add(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{datacenter:id}': self.parentclass.parentclass.get_id(),
                        '{cluster:id}': self.parentclass.get_id(),
                    }
                ),
                args={}
            ),
            body=ParseHelper.toXml(affinitygroup),
            headers={}
        )

        return DataCenterClusterAffinityGroup(
            self.parentclass,
            result,
            self.context
        )

    def get(self, name=None, id=None):

        '''
        [@param id  : string (the id of the entity)]
        [@param name: string (the name of the entity)]

        @return AffinityGroups:
        '''

        url = '/datacenters/{datacenter:id}/clusters/{cluster:id}/affinitygroups'

        if id:
            try :
                result = self.__getProxy().get(
                    url=UrlHelper.append(
                        UrlHelper.replace(
                            url,
                            {
                                '{datacenter:id}': self.parentclass.parentclass.get_id(),
                                '{cluster:id}': self.parentclass.get_id(),
                            }
                        ),
                        id
                    ),
                    headers={}
                )

                return DataCenterClusterAffinityGroup(
                    self.parentclass,
                    result,
                    self.context
                )
            except RequestError as err:
                if err.status and err.status == 404:
                    return None
                raise err
        elif name:
            result = self.__getProxy().get(
                url=UrlHelper.replace(
                    url,
                    {
                        '{datacenter:id}': self.parentclass.parentclass.get_id(),
                        '{cluster:id}': self.parentclass.get_id(),
                    }
                ),
                headers={}
            ).get_affinity_group()

            return DataCenterClusterAffinityGroup(
                self.parentclass,
                FilterHelper.getItem(
                    FilterHelper.filter(
                        result,
                        {'name':name}
                    ),
                    query="name=" + name
                ),
                self.context
            )
        else:
            raise MissingParametersError(['id', 'name'])

    def list(self, max=None, **kwargs):
        '''
        [@param **kwargs: dict (property based filtering)"]
        [@param max: int (max results)]

        @return AffinityGroups:
        '''

        url = '/datacenters/{datacenter:id}/clusters/{cluster:id}/affinitygroups'

        result = self.__getProxy().get(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{datacenter:id}': self.parentclass.parentclass.get_id(),
                        '{cluster:id}': self.parentclass.get_id(),
                    }
                ),
                args={'max:matrix':max}
            ),
            headers={}
        ).get_affinity_group()

        return ParseHelper.toSubCollection(
            DataCenterClusterAffinityGroup,
            self.parentclass,
            FilterHelper.filter(
                result,
                kwargs
            ),
            context=self.context
        )

class DataCenterClusterCpuProfile(params.CpuProfile, Base):
    def __init__(self, datacentercluster, cpuprofile, context):
        Base.__init__(self, context)
        self.parentclass = datacentercluster
        self.superclass  =  cpuprofile

        #SUB_COLLECTIONS
    def __new__(cls, datacentercluster, cpuprofile, context):
        if cpuprofile is None: return None
        obj = object.__new__(cls)
        obj.__init__(datacentercluster, cpuprofile, context)
        return obj

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def delete(self, async=None):
        '''
        [@param async: boolean (true|false)]

        @return None:
        '''

        url = UrlHelper.replace(
            '/datacenters/{datacenter:id}/clusters/{cluster:id}/cpuprofiles/{cpuprofile:id}',
            {
                '{datacenter:id}': self.parentclass.parentclass.get_id(),
                '{cluster:id}': self.parentclass.get_id(),
                '{cpuprofile:id}': self.get_id(),
            }
        )

        return self.__getProxy().delete(
            url=UrlHelper.appendParameters(
                url,
                {'async:matrix':async}
            ),
            headers={"Content-type":None}
        )

class DataCenterClusterCpuProfiles(Base):

    def __init__(self, cluster , context):
        Base.__init__(self, context)
        self.parentclass = cluster

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def add(self, cpuprofile):

        '''
        @type CpuProfile:


        @return CpuProfile:
        '''

        url = '/datacenters/{datacenter:id}/clusters/{cluster:id}/cpuprofiles'

        result = self.__getProxy().add(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{datacenter:id}': self.parentclass.parentclass.get_id(),
                        '{cluster:id}': self.parentclass.get_id(),
                    }
                ),
                args={}
            ),
            body=ParseHelper.toXml(cpuprofile),
            headers={}
        )

        return DataCenterClusterCpuProfile(
            self.parentclass,
            result,
            self.context
        )

    def get(self, name=None, id=None):

        '''
        [@param id  : string (the id of the entity)]
        [@param name: string (the name of the entity)]

        @return CpuProfiles:
        '''

        url = '/datacenters/{datacenter:id}/clusters/{cluster:id}/cpuprofiles'

        if id:
            try :
                result = self.__getProxy().get(
                    url=UrlHelper.append(
                        UrlHelper.replace(
                            url,
                            {
                                '{datacenter:id}': self.parentclass.parentclass.get_id(),
                                '{cluster:id}': self.parentclass.get_id(),
                            }
                        ),
                        id
                    ),
                    headers={}
                )

                return DataCenterClusterCpuProfile(
                    self.parentclass,
                    result,
                    self.context
                )
            except RequestError as err:
                if err.status and err.status == 404:
                    return None
                raise err
        elif name:
            result = self.__getProxy().get(
                url=UrlHelper.replace(
                    url,
                    {
                        '{datacenter:id}': self.parentclass.parentclass.get_id(),
                        '{cluster:id}': self.parentclass.get_id(),
                    }
                ),
                headers={}
            ).get_cpu_profile()

            return DataCenterClusterCpuProfile(
                self.parentclass,
                FilterHelper.getItem(
                    FilterHelper.filter(
                        result,
                        {'name':name}
                    ),
                    query="name=" + name
                ),
                self.context
            )
        else:
            raise MissingParametersError(['id', 'name'])

    def list(self, max=None, **kwargs):
        '''
        [@param **kwargs: dict (property based filtering)"]
        [@param max: int (max results)]

        @return CpuProfiles:
        '''

        url = '/datacenters/{datacenter:id}/clusters/{cluster:id}/cpuprofiles'

        result = self.__getProxy().get(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{datacenter:id}': self.parentclass.parentclass.get_id(),
                        '{cluster:id}': self.parentclass.get_id(),
                    }
                ),
                args={'max:matrix':max}
            ),
            headers={}
        ).get_cpu_profile()

        return ParseHelper.toSubCollection(
            DataCenterClusterCpuProfile,
            self.parentclass,
            FilterHelper.filter(
                result,
                kwargs
            ),
            context=self.context
        )

class DataCenterClusterGlusterHook(params.GlusterHook, Base):
    def __init__(self, datacentercluster, glusterhook, context):
        Base.__init__(self, context)
        self.parentclass = datacentercluster
        self.superclass  =  glusterhook

        #SUB_COLLECTIONS
    def __new__(cls, datacentercluster, glusterhook, context):
        if glusterhook is None: return None
        obj = object.__new__(cls)
        obj.__init__(datacentercluster, glusterhook, context)
        return obj

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def delete(self, async=None):
        '''
        [@param async: boolean (true|false)]

        @return None:
        '''

        url = UrlHelper.replace(
            '/datacenters/{datacenter:id}/clusters/{cluster:id}/glusterhooks/{glusterhook:id}',
            {
                '{datacenter:id}': self.parentclass.parentclass.get_id(),
                '{cluster:id}': self.parentclass.get_id(),
                '{glusterhook:id}': self.get_id(),
            }
        )

        return self.__getProxy().delete(
            url=UrlHelper.appendParameters(
                url,
                {'async:matrix':async}
            ),
            headers={"Content-type":None}
        )

    def disable(self, action=params.Action()):
        '''
        @type Action:


        @return Action:
        '''

        url = '/datacenters/{datacenter:id}/clusters/{cluster:id}/glusterhooks/{glusterhook:id}/disable'

        result = self.__getProxy().request(
            method='POST',
            url=UrlHelper.replace(
                url,
                {
                    '{datacenter:id}': self.parentclass.parentclass.get_id(),
                    '{cluster:id}': self.parentclass.get_id(),
                    '{glusterhook:id}': self.get_id(),
                }
            ),
            body=ParseHelper.toXml(action),
            headers={}
        )

        return result

    def enable(self, action=params.Action()):
        '''
        @type Action:


        @return Action:
        '''

        url = '/datacenters/{datacenter:id}/clusters/{cluster:id}/glusterhooks/{glusterhook:id}/enable'

        result = self.__getProxy().request(
            method='POST',
            url=UrlHelper.replace(
                url,
                {
                    '{datacenter:id}': self.parentclass.parentclass.get_id(),
                    '{cluster:id}': self.parentclass.get_id(),
                    '{glusterhook:id}': self.get_id(),
                }
            ),
            body=ParseHelper.toXml(action),
            headers={}
        )

        return result

    def resolve(self, action=params.Action()):
        '''
        @type Action:


        @return Action:
        '''

        url = '/datacenters/{datacenter:id}/clusters/{cluster:id}/glusterhooks/{glusterhook:id}/resolve'

        result = self.__getProxy().request(
            method='POST',
            url=UrlHelper.replace(
                url,
                {
                    '{datacenter:id}': self.parentclass.parentclass.get_id(),
                    '{cluster:id}': self.parentclass.get_id(),
                    '{glusterhook:id}': self.get_id(),
                }
            ),
            body=ParseHelper.toXml(action),
            headers={}
        )

        return result

class DataCenterClusterGlusterHooks(Base):

    def __init__(self, cluster , context):
        Base.__init__(self, context)
        self.parentclass = cluster

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def get(self, name=None, id=None):

        '''
        [@param id  : string (the id of the entity)]
        [@param name: string (the name of the entity)]

        @return GlusterHooks:
        '''

        url = '/datacenters/{datacenter:id}/clusters/{cluster:id}/glusterhooks'

        if id:
            try :
                result = self.__getProxy().get(
                    url=UrlHelper.append(
                        UrlHelper.replace(
                            url,
                            {
                                '{datacenter:id}': self.parentclass.parentclass.get_id(),
                                '{cluster:id}': self.parentclass.get_id(),
                            }
                        ),
                        id
                    ),
                    headers={}
                )

                return DataCenterClusterGlusterHook(
                    self.parentclass,
                    result,
                    self.context
                )
            except RequestError as err:
                if err.status and err.status == 404:
                    return None
                raise err
        elif name:
            result = self.__getProxy().get(
                url=UrlHelper.replace(
                    url,
                    {
                        '{datacenter:id}': self.parentclass.parentclass.get_id(),
                        '{cluster:id}': self.parentclass.get_id(),
                    }
                ),
                headers={}
            ).get_gluster_hook()

            return DataCenterClusterGlusterHook(
                self.parentclass,
                FilterHelper.getItem(
                    FilterHelper.filter(
                        result,
                        {'name':name}
                    ),
                    query="name=" + name
                ),
                self.context
            )
        else:
            raise MissingParametersError(['id', 'name'])

    def list(self, max=None, **kwargs):
        '''
        [@param **kwargs: dict (property based filtering)"]
        [@param max: int (max results)]

        @return GlusterHooks:
        '''

        url = '/datacenters/{datacenter:id}/clusters/{cluster:id}/glusterhooks'

        result = self.__getProxy().get(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{datacenter:id}': self.parentclass.parentclass.get_id(),
                        '{cluster:id}': self.parentclass.get_id(),
                    }
                ),
                args={'max:matrix':max}
            ),
            headers={}
        ).get_gluster_hook()

        return ParseHelper.toSubCollection(
            DataCenterClusterGlusterHook,
            self.parentclass,
            FilterHelper.filter(
                result,
                kwargs
            ),
            context=self.context
        )

class DataCenterClusterGlusterVolume(params.GlusterVolume, Base):
    def __init__(self, datacentercluster, glustervolume, context):
        Base.__init__(self, context)
        self.parentclass = datacentercluster
        self.superclass  =  glustervolume

        self.bricks = DataCenterClusterGlusterVolumeGlusterBricks(self, context)
        self.statistics = DataCenterClusterGlusterVolumeStatistics(self, context)

    def __new__(cls, datacentercluster, glustervolume, context):
        if glustervolume is None: return None
        obj = object.__new__(cls)
        obj.__init__(datacentercluster, glustervolume, context)
        return obj

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def delete(self, async=None):
        '''
        [@param async: boolean (true|false)]

        @return None:
        '''

        url = UrlHelper.replace(
            '/datacenters/{datacenter:id}/clusters/{cluster:id}/glustervolumes/{glustervolume:id}',
            {
                '{datacenter:id}': self.parentclass.parentclass.get_id(),
                '{cluster:id}': self.parentclass.get_id(),
                '{glustervolume:id}': self.get_id(),
            }
        )

        return self.__getProxy().delete(
            url=UrlHelper.appendParameters(
                url,
                {'async:matrix':async}
            ),
            headers={"Content-type":None}
        )

    def activate(self, action=params.Action()):
        '''
        @type Action:


        @return Action:
        '''

        url = '/datacenters/{datacenter:id}/clusters/{cluster:id}/glustervolumes/{glustervolume:id}/bricks/activate'

        result = self.__getProxy().request(
            method='POST',
            url=UrlHelper.replace(
                url,
                {
                    '{datacenter:id}': self.parentclass.parentclass.get_id(),
                    '{cluster:id}': self.parentclass.get_id(),
                    '{glustervolume:id}': self.get_id(),
                }
            ),
            body=ParseHelper.toXml(action),
            headers={}
        )

        return result

    def migrate(self, action=params.Action()):
        '''
        @type Action:


        @return Action:
        '''

        url = '/datacenters/{datacenter:id}/clusters/{cluster:id}/glustervolumes/{glustervolume:id}/bricks/migrate'

        result = self.__getProxy().request(
            method='POST',
            url=UrlHelper.replace(
                url,
                {
                    '{datacenter:id}': self.parentclass.parentclass.get_id(),
                    '{cluster:id}': self.parentclass.get_id(),
                    '{glustervolume:id}': self.get_id(),
                }
            ),
            body=ParseHelper.toXml(action),
            headers={}
        )

        return result

    def stopmigrate(self, action=params.Action()):
        '''
        @type Action:


        @return Action:
        '''

        url = '/datacenters/{datacenter:id}/clusters/{cluster:id}/glustervolumes/{glustervolume:id}/bricks/stopmigrate'

        result = self.__getProxy().request(
            method='POST',
            url=UrlHelper.replace(
                url,
                {
                    '{datacenter:id}': self.parentclass.parentclass.get_id(),
                    '{cluster:id}': self.parentclass.get_id(),
                    '{glustervolume:id}': self.get_id(),
                }
            ),
            body=ParseHelper.toXml(action),
            headers={}
        )

        return result

    def rebalance(self, action=params.Action()):
        '''
        @type Action:


        @return Action:
        '''

        url = '/datacenters/{datacenter:id}/clusters/{cluster:id}/glustervolumes/{glustervolume:id}/rebalance'

        result = self.__getProxy().request(
            method='POST',
            url=UrlHelper.replace(
                url,
                {
                    '{datacenter:id}': self.parentclass.parentclass.get_id(),
                    '{cluster:id}': self.parentclass.get_id(),
                    '{glustervolume:id}': self.get_id(),
                }
            ),
            body=ParseHelper.toXml(action),
            headers={}
        )

        return result

    def resetalloptions(self, action=params.Action()):
        '''
        @type Action:


        @return Action:
        '''

        url = '/datacenters/{datacenter:id}/clusters/{cluster:id}/glustervolumes/{glustervolume:id}/resetalloptions'

        result = self.__getProxy().request(
            method='POST',
            url=UrlHelper.replace(
                url,
                {
                    '{datacenter:id}': self.parentclass.parentclass.get_id(),
                    '{cluster:id}': self.parentclass.get_id(),
                    '{glustervolume:id}': self.get_id(),
                }
            ),
            body=ParseHelper.toXml(action),
            headers={}
        )

        return result

    def resetoption(self, action=params.Action()):
        '''
        @type Action:


        @return Action:
        '''

        url = '/datacenters/{datacenter:id}/clusters/{cluster:id}/glustervolumes/{glustervolume:id}/resetoption'

        result = self.__getProxy().request(
            method='POST',
            url=UrlHelper.replace(
                url,
                {
                    '{datacenter:id}': self.parentclass.parentclass.get_id(),
                    '{cluster:id}': self.parentclass.get_id(),
                    '{glustervolume:id}': self.get_id(),
                }
            ),
            body=ParseHelper.toXml(action),
            headers={}
        )

        return result

    def setoption(self, action=params.Action()):
        '''
        @type Action:


        @return Action:
        '''

        url = '/datacenters/{datacenter:id}/clusters/{cluster:id}/glustervolumes/{glustervolume:id}/setoption'

        result = self.__getProxy().request(
            method='POST',
            url=UrlHelper.replace(
                url,
                {
                    '{datacenter:id}': self.parentclass.parentclass.get_id(),
                    '{cluster:id}': self.parentclass.get_id(),
                    '{glustervolume:id}': self.get_id(),
                }
            ),
            body=ParseHelper.toXml(action),
            headers={}
        )

        return result

    def start(self, action=params.Action()):
        '''
        @type Action:


        @return Action:
        '''

        url = '/datacenters/{datacenter:id}/clusters/{cluster:id}/glustervolumes/{glustervolume:id}/start'

        result = self.__getProxy().request(
            method='POST',
            url=UrlHelper.replace(
                url,
                {
                    '{datacenter:id}': self.parentclass.parentclass.get_id(),
                    '{cluster:id}': self.parentclass.get_id(),
                    '{glustervolume:id}': self.get_id(),
                }
            ),
            body=ParseHelper.toXml(action),
            headers={}
        )

        return result

    def startprofile(self, action=params.Action()):
        '''
        @type Action:


        @return Action:
        '''

        url = '/datacenters/{datacenter:id}/clusters/{cluster:id}/glustervolumes/{glustervolume:id}/startprofile'

        result = self.__getProxy().request(
            method='POST',
            url=UrlHelper.replace(
                url,
                {
                    '{datacenter:id}': self.parentclass.parentclass.get_id(),
                    '{cluster:id}': self.parentclass.get_id(),
                    '{glustervolume:id}': self.get_id(),
                }
            ),
            body=ParseHelper.toXml(action),
            headers={}
        )

        return result

    def stop(self, action=params.Action()):
        '''
        @type Action:


        @return Action:
        '''

        url = '/datacenters/{datacenter:id}/clusters/{cluster:id}/glustervolumes/{glustervolume:id}/stop'

        result = self.__getProxy().request(
            method='POST',
            url=UrlHelper.replace(
                url,
                {
                    '{datacenter:id}': self.parentclass.parentclass.get_id(),
                    '{cluster:id}': self.parentclass.get_id(),
                    '{glustervolume:id}': self.get_id(),
                }
            ),
            body=ParseHelper.toXml(action),
            headers={}
        )

        return result

    def stopprofile(self, action=params.Action()):
        '''
        @type Action:


        @return Action:
        '''

        url = '/datacenters/{datacenter:id}/clusters/{cluster:id}/glustervolumes/{glustervolume:id}/stopprofile'

        result = self.__getProxy().request(
            method='POST',
            url=UrlHelper.replace(
                url,
                {
                    '{datacenter:id}': self.parentclass.parentclass.get_id(),
                    '{cluster:id}': self.parentclass.get_id(),
                    '{glustervolume:id}': self.get_id(),
                }
            ),
            body=ParseHelper.toXml(action),
            headers={}
        )

        return result

    def stoprebalance(self, action=params.Action()):
        '''
        @type Action:


        @return Action:
        '''

        url = '/datacenters/{datacenter:id}/clusters/{cluster:id}/glustervolumes/{glustervolume:id}/stoprebalance'

        result = self.__getProxy().request(
            method='POST',
            url=UrlHelper.replace(
                url,
                {
                    '{datacenter:id}': self.parentclass.parentclass.get_id(),
                    '{cluster:id}': self.parentclass.get_id(),
                    '{glustervolume:id}': self.get_id(),
                }
            ),
            body=ParseHelper.toXml(action),
            headers={}
        )

        return result

class DataCenterClusterGlusterVolumeGlusterBrick(params.GlusterBrick, Base):
    def __init__(self, datacenterclusterglustervolume, glusterbrick, context):
        Base.__init__(self, context)
        self.parentclass = datacenterclusterglustervolume
        self.superclass  =  glusterbrick

        self.statistics = DataCenterClusterGlusterVolumeGlusterBrickStatistics(self, context)

    def __new__(cls, datacenterclusterglustervolume, glusterbrick, context):
        if glusterbrick is None: return None
        obj = object.__new__(cls)
        obj.__init__(datacenterclusterglustervolume, glusterbrick, context)
        return obj

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def delete(self, async=None):
        '''
        [@param async: boolean (true|false)]

        @return None:
        '''

        url = UrlHelper.replace(
            '/datacenters/{datacenter:id}/clusters/{cluster:id}/glustervolumes/{glustervolume:id}/bricks/{brick:id}',
            {
                '{datacenter:id}': self.parentclass.parentclass.parentclass.get_id(),
                '{cluster:id}': self.parentclass.parentclass.get_id(),
                '{glustervolume:id}': self.parentclass.get_id(),
                '{brick:id}': self.get_id(),
            }
        )

        return self.__getProxy().delete(
            url=UrlHelper.appendParameters(
                url,
                {'async:matrix':async}
            ),
            headers={"Content-type":None}
        )

    def replace(self, action=params.Action()):
        '''
        @type Action:


        @return Action:
        '''

        url = '/datacenters/{datacenter:id}/clusters/{cluster:id}/glustervolumes/{glustervolume:id}/bricks/{brick:id}/replace'

        result = self.__getProxy().request(
            method='POST',
            url=UrlHelper.replace(
                url,
                {
                    '{datacenter:id}': self.parentclass.parentclass.parentclass.get_id(),
                    '{cluster:id}': self.parentclass.parentclass.get_id(),
                    '{glustervolume:id}': self.parentclass.get_id(),
                    '{brick:id}': self.get_id(),
                }
            ),
            body=ParseHelper.toXml(action),
            headers={}
        )

        return result

class DataCenterClusterGlusterVolumeGlusterBrickStatistic(params.Statistic, Base):
    def __init__(self, datacenterclusterglustervolumeglusterbrick, statistic, context):
        Base.__init__(self, context)
        self.parentclass = datacenterclusterglustervolumeglusterbrick
        self.superclass  =  statistic

        #SUB_COLLECTIONS
    def __new__(cls, datacenterclusterglustervolumeglusterbrick, statistic, context):
        if statistic is None: return None
        obj = object.__new__(cls)
        obj.__init__(datacenterclusterglustervolumeglusterbrick, statistic, context)
        return obj

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

class DataCenterClusterGlusterVolumeGlusterBrickStatistics(Base):

    def __init__(self, glusterbrick , context):
        Base.__init__(self, context)
        self.parentclass = glusterbrick

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def get(self, name=None, id=None):

        '''
        [@param id  : string (the id of the entity)]
        [@param name: string (the name of the entity)]

        @return Statistics:
        '''

        url = '/datacenters/{datacenter:id}/clusters/{cluster:id}/glustervolumes/{glustervolume:id}/bricks/{brick:id}/statistics'

        if id:
            try :
                result = self.__getProxy().get(
                    url=UrlHelper.append(
                        UrlHelper.replace(
                            url,
                            {
                                '{datacenter:id}': self.parentclass.parentclass.parentclass.parentclass.get_id(),
                                '{cluster:id}': self.parentclass.parentclass.parentclass.get_id(),
                                '{glustervolume:id}': self.parentclass.parentclass.get_id(),
                                '{brick:id}': self.parentclass.get_id(),
                            }
                        ),
                        id
                    ),
                    headers={}
                )

                return DataCenterClusterGlusterVolumeGlusterBrickStatistic(
                    self.parentclass,
                    result,
                    self.context
                )
            except RequestError as err:
                if err.status and err.status == 404:
                    return None
                raise err
        elif name:
            result = self.__getProxy().get(
                url=UrlHelper.replace(
                    url,
                    {
                        '{datacenter:id}': self.parentclass.parentclass.parentclass.parentclass.get_id(),
                        '{cluster:id}': self.parentclass.parentclass.parentclass.get_id(),
                        '{glustervolume:id}': self.parentclass.parentclass.get_id(),
                        '{brick:id}': self.parentclass.get_id(),
                    }
                ),
                headers={}
            ).get_statistic()

            return DataCenterClusterGlusterVolumeGlusterBrickStatistic(
                self.parentclass,
                FilterHelper.getItem(
                    FilterHelper.filter(
                        result,
                        {'name':name}
                    ),
                    query="name=" + name
                ),
                self.context
            )
        else:
            raise MissingParametersError(['id', 'name'])

    def list(self, **kwargs):
        '''
        [@param **kwargs: dict (property based filtering)"]

        @return Statistics:
        '''

        url = '/datacenters/{datacenter:id}/clusters/{cluster:id}/glustervolumes/{glustervolume:id}/bricks/{brick:id}/statistics'

        result = self.__getProxy().get(
            url=UrlHelper.replace(
                url,
                {
                    '{datacenter:id}': self.parentclass.parentclass.parentclass.parentclass.get_id(),
                    '{cluster:id}': self.parentclass.parentclass.parentclass.get_id(),
                    '{glustervolume:id}': self.parentclass.parentclass.get_id(),
                    '{brick:id}': self.parentclass.get_id(),
                }
            )
        ).get_statistic()

        return ParseHelper.toSubCollection(
            DataCenterClusterGlusterVolumeGlusterBrickStatistic,
            self.parentclass,
            FilterHelper.filter(
                result,
                kwargs
            ),
            context=self.context
        )

class DataCenterClusterGlusterVolumeGlusterBricks(Base):

    def __init__(self, glustervolume , context):
        Base.__init__(self, context)
        self.parentclass = glustervolume

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def add(self, brick):

        '''
        @type GlusterBricks:


        @return GlusterBricks:
        '''

        url = '/datacenters/{datacenter:id}/clusters/{cluster:id}/glustervolumes/{glustervolume:id}/bricks'

        result = self.__getProxy().add(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{datacenter:id}': self.parentclass.parentclass.parentclass.get_id(),
                        '{cluster:id}': self.parentclass.parentclass.get_id(),
                        '{glustervolume:id}': self.parentclass.get_id(),
                    }
                ),
                args={}
            ),
            body=ParseHelper.toXml(brick),
            headers={}
        )

        return DataCenterClusterGlusterVolumeGlusterBrick(
            self.parentclass,
            result,
            self.context
        )

    def get(self, name=None, id=None):

        '''
        [@param id  : string (the id of the entity)]
        [@param name: string (the name of the entity)]

        @return GlusterBricks:
        '''

        url = '/datacenters/{datacenter:id}/clusters/{cluster:id}/glustervolumes/{glustervolume:id}/bricks'

        if id:
            try :
                result = self.__getProxy().get(
                    url=UrlHelper.append(
                        UrlHelper.replace(
                            url,
                            {
                                '{datacenter:id}': self.parentclass.parentclass.parentclass.get_id(),
                                '{cluster:id}': self.parentclass.parentclass.get_id(),
                                '{glustervolume:id}': self.parentclass.get_id(),
                            }
                        ),
                        id
                    ),
                    headers={}
                )

                return DataCenterClusterGlusterVolumeGlusterBrick(
                    self.parentclass,
                    result,
                    self.context
                )
            except RequestError as err:
                if err.status and err.status == 404:
                    return None
                raise err
        elif name:
            result = self.__getProxy().get(
                url=UrlHelper.replace(
                    url,
                    {
                        '{datacenter:id}': self.parentclass.parentclass.parentclass.get_id(),
                        '{cluster:id}': self.parentclass.parentclass.get_id(),
                        '{glustervolume:id}': self.parentclass.get_id(),
                    }
                ),
                headers={}
            ).get_brick()

            return DataCenterClusterGlusterVolumeGlusterBrick(
                self.parentclass,
                FilterHelper.getItem(
                    FilterHelper.filter(
                        result,
                        {'name':name}
                    ),
                    query="name=" + name
                ),
                self.context
            )
        else:
            raise MissingParametersError(['id', 'name'])

    def list(self, max=None, **kwargs):
        '''
        [@param **kwargs: dict (property based filtering)"]
        [@param max: int (max results)]

        @return GlusterBricks:
        '''

        url = '/datacenters/{datacenter:id}/clusters/{cluster:id}/glustervolumes/{glustervolume:id}/bricks'

        result = self.__getProxy().get(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{datacenter:id}': self.parentclass.parentclass.parentclass.get_id(),
                        '{cluster:id}': self.parentclass.parentclass.get_id(),
                        '{glustervolume:id}': self.parentclass.get_id(),
                    }
                ),
                args={'max:matrix':max}
            ),
            headers={}
        ).get_brick()

        return ParseHelper.toSubCollection(
            DataCenterClusterGlusterVolumeGlusterBrick,
            self.parentclass,
            FilterHelper.filter(
                result,
                kwargs
            ),
            context=self.context
        )

class DataCenterClusterGlusterVolumeStatistic(params.Statistic, Base):
    def __init__(self, datacenterclusterglustervolume, statistic, context):
        Base.__init__(self, context)
        self.parentclass = datacenterclusterglustervolume
        self.superclass  =  statistic

        #SUB_COLLECTIONS
    def __new__(cls, datacenterclusterglustervolume, statistic, context):
        if statistic is None: return None
        obj = object.__new__(cls)
        obj.__init__(datacenterclusterglustervolume, statistic, context)
        return obj

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

class DataCenterClusterGlusterVolumeStatistics(Base):

    def __init__(self, glustervolume , context):
        Base.__init__(self, context)
        self.parentclass = glustervolume

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def get(self, name=None, id=None):

        '''
        [@param id  : string (the id of the entity)]
        [@param name: string (the name of the entity)]

        @return Statistics:
        '''

        url = '/datacenters/{datacenter:id}/clusters/{cluster:id}/glustervolumes/{glustervolume:id}/statistics'

        if id:
            try :
                result = self.__getProxy().get(
                    url=UrlHelper.append(
                        UrlHelper.replace(
                            url,
                            {
                                '{datacenter:id}': self.parentclass.parentclass.parentclass.get_id(),
                                '{cluster:id}': self.parentclass.parentclass.get_id(),
                                '{glustervolume:id}': self.parentclass.get_id(),
                            }
                        ),
                        id
                    ),
                    headers={}
                )

                return DataCenterClusterGlusterVolumeStatistic(
                    self.parentclass,
                    result,
                    self.context
                )
            except RequestError as err:
                if err.status and err.status == 404:
                    return None
                raise err
        elif name:
            result = self.__getProxy().get(
                url=UrlHelper.replace(
                    url,
                    {
                        '{datacenter:id}': self.parentclass.parentclass.parentclass.get_id(),
                        '{cluster:id}': self.parentclass.parentclass.get_id(),
                        '{glustervolume:id}': self.parentclass.get_id(),
                    }
                ),
                headers={}
            ).get_statistic()

            return DataCenterClusterGlusterVolumeStatistic(
                self.parentclass,
                FilterHelper.getItem(
                    FilterHelper.filter(
                        result,
                        {'name':name}
                    ),
                    query="name=" + name
                ),
                self.context
            )
        else:
            raise MissingParametersError(['id', 'name'])

    def list(self, **kwargs):
        '''
        [@param **kwargs: dict (property based filtering)"]

        @return Statistics:
        '''

        url = '/datacenters/{datacenter:id}/clusters/{cluster:id}/glustervolumes/{glustervolume:id}/statistics'

        result = self.__getProxy().get(
            url=UrlHelper.replace(
                url,
                {
                    '{datacenter:id}': self.parentclass.parentclass.parentclass.get_id(),
                    '{cluster:id}': self.parentclass.parentclass.get_id(),
                    '{glustervolume:id}': self.parentclass.get_id(),
                }
            )
        ).get_statistic()

        return ParseHelper.toSubCollection(
            DataCenterClusterGlusterVolumeStatistic,
            self.parentclass,
            FilterHelper.filter(
                result,
                kwargs
            ),
            context=self.context
        )

class DataCenterClusterGlusterVolumes(Base):

    def __init__(self, cluster , context):
        Base.__init__(self, context)
        self.parentclass = cluster

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def add(self, glustervolume):

        '''
        @type GlusterVolume:


        @return GlusterVolume:
        '''

        url = '/datacenters/{datacenter:id}/clusters/{cluster:id}/glustervolumes'

        result = self.__getProxy().add(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{datacenter:id}': self.parentclass.parentclass.get_id(),
                        '{cluster:id}': self.parentclass.get_id(),
                    }
                ),
                args={}
            ),
            body=ParseHelper.toXml(glustervolume),
            headers={}
        )

        return DataCenterClusterGlusterVolume(
            self.parentclass,
            result,
            self.context
        )

    def get(self, name=None, id=None):

        '''
        [@param id  : string (the id of the entity)]
        [@param name: string (the name of the entity)]

        @return GlusterVolumes:
        '''

        url = '/datacenters/{datacenter:id}/clusters/{cluster:id}/glustervolumes'

        if id:
            try :
                result = self.__getProxy().get(
                    url=UrlHelper.append(
                        UrlHelper.replace(
                            url,
                            {
                                '{datacenter:id}': self.parentclass.parentclass.get_id(),
                                '{cluster:id}': self.parentclass.get_id(),
                            }
                        ),
                        id
                    ),
                    headers={}
                )

                return DataCenterClusterGlusterVolume(
                    self.parentclass,
                    result,
                    self.context
                )
            except RequestError as err:
                if err.status and err.status == 404:
                    return None
                raise err
        elif name:
            result = self.__getProxy().get(
                url=UrlHelper.replace(
                    url,
                    {
                        '{datacenter:id}': self.parentclass.parentclass.get_id(),
                        '{cluster:id}': self.parentclass.get_id(),
                    }
                ),
                headers={}
            ).get_gluster_volume()

            return DataCenterClusterGlusterVolume(
                self.parentclass,
                FilterHelper.getItem(
                    FilterHelper.filter(
                        result,
                        {'name':name}
                    ),
                    query="name=" + name
                ),
                self.context
            )
        else:
            raise MissingParametersError(['id', 'name'])

    def list(self, max=None, **kwargs):
        '''
        [@param **kwargs: dict (property based filtering)"]
        [@param max: int (max results)]

        @return GlusterVolumes:
        '''

        url = '/datacenters/{datacenter:id}/clusters/{cluster:id}/glustervolumes'

        result = self.__getProxy().get(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{datacenter:id}': self.parentclass.parentclass.get_id(),
                        '{cluster:id}': self.parentclass.get_id(),
                    }
                ),
                args={'max:matrix':max}
            ),
            headers={}
        ).get_gluster_volume()

        return ParseHelper.toSubCollection(
            DataCenterClusterGlusterVolume,
            self.parentclass,
            FilterHelper.filter(
                result,
                kwargs
            ),
            context=self.context
        )

class DataCenterClusterNetwork(params.Network, Base):
    def __init__(self, datacentercluster, network, context):
        Base.__init__(self, context)
        self.parentclass = datacentercluster
        self.superclass  =  network

        #SUB_COLLECTIONS
    def __new__(cls, datacentercluster, network, context):
        if network is None: return None
        obj = object.__new__(cls)
        obj.__init__(datacentercluster, network, context)
        return obj

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def delete(self, async=None, correlation_id=None):
        '''
        [@param async: boolean (true|false)]
        [@param correlation_id: any string]

        @return None:
        '''

        url = UrlHelper.replace(
            '/datacenters/{datacenter:id}/clusters/{cluster:id}/networks/{network:id}',
            {
                '{datacenter:id}': self.parentclass.parentclass.get_id(),
                '{cluster:id}': self.parentclass.get_id(),
                '{network:id}': self.get_id(),
            }
        )

        return self.__getProxy().delete(
            url=UrlHelper.appendParameters(
                url,
                {'async:matrix':async}
            ),
            headers={"Correlation-Id":correlation_id,"Content-type":None}
        )

    def update(self, async=None, correlation_id=None, expect=None):
        '''
        [@param network.display: boolean]
        [@param network.usages.usage: collection]
        {
          [@ivar usage: string]
        }
        [@param async: boolean (true|false)]
        [@param correlation_id: any string]
        [@param expect: 202-accepted]

        @return Network:
        '''

        url = '/datacenters/{datacenter:id}/clusters/{cluster:id}/networks/{network:id}'
        url = UrlHelper.replace(
            url,
            {
                '{datacenter:id}': self.parentclass.parentclass.get_id(),
                '{cluster:id}': self.parentclass.get_id(),
                '{network:id}': self.get_id(),
            }
        )

        result = self.__getProxy().update(
            url=UrlHelper.appendParameters(url, {'async:matrix':async}),
            body=ParseHelper.toXml(self.superclass),
            headers={"Correlation-Id":correlation_id, "Expect":expect}
        )

        return DataCenterClusterNetwork(
            self.parentclass,
            result,
            self.context
        )

class DataCenterClusterNetworks(Base):

    def __init__(self, cluster , context):
        Base.__init__(self, context)
        self.parentclass = cluster

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def add(self, network, correlation_id=None, expect=None):

        '''
        @type Network:

        @param network.id|name: string
        [@param network.usages.usage: collection]
        {
          [@ivar usage: string]
        }
        [@param correlation_id: any string]
        [@param expect: 201-created]

        @return Network:
        '''

        url = '/datacenters/{datacenter:id}/clusters/{cluster:id}/networks'

        result = self.__getProxy().add(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{datacenter:id}': self.parentclass.parentclass.get_id(),
                        '{cluster:id}': self.parentclass.get_id(),
                    }
                ),
                args={}
            ),
            body=ParseHelper.toXml(network),
            headers={"Correlation-Id":correlation_id, "Expect":expect}
        )

        return DataCenterClusterNetwork(
            self.parentclass,
            result,
            self.context
        )

    def get(self, name=None, id=None):

        '''
        [@param id  : string (the id of the entity)]
        [@param name: string (the name of the entity)]

        @return Networks:
        '''

        url = '/datacenters/{datacenter:id}/clusters/{cluster:id}/networks'

        if id:
            try :
                result = self.__getProxy().get(
                    url=UrlHelper.append(
                        UrlHelper.replace(
                            url,
                            {
                                '{datacenter:id}': self.parentclass.parentclass.get_id(),
                                '{cluster:id}': self.parentclass.get_id(),
                            }
                        ),
                        id
                    ),
                    headers={}
                )

                return DataCenterClusterNetwork(
                    self.parentclass,
                    result,
                    self.context
                )
            except RequestError as err:
                if err.status and err.status == 404:
                    return None
                raise err
        elif name:
            result = self.__getProxy().get(
                url=UrlHelper.replace(
                    url,
                    {
                        '{datacenter:id}': self.parentclass.parentclass.get_id(),
                        '{cluster:id}': self.parentclass.get_id(),
                    }
                ),
                headers={}
            ).get_network()

            return DataCenterClusterNetwork(
                self.parentclass,
                FilterHelper.getItem(
                    FilterHelper.filter(
                        result,
                        {'name':name}
                    ),
                    query="name=" + name
                ),
                self.context
            )
        else:
            raise MissingParametersError(['id', 'name'])

    def list(self, max=None, **kwargs):
        '''
        [@param **kwargs: dict (property based filtering)"]
        [@param max: int (max results)]

        @return Networks:
        '''

        url = '/datacenters/{datacenter:id}/clusters/{cluster:id}/networks'

        result = self.__getProxy().get(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{datacenter:id}': self.parentclass.parentclass.get_id(),
                        '{cluster:id}': self.parentclass.get_id(),
                    }
                ),
                args={'max:matrix':max}
            ),
            headers={}
        ).get_network()

        return ParseHelper.toSubCollection(
            DataCenterClusterNetwork,
            self.parentclass,
            FilterHelper.filter(
                result,
                kwargs
            ),
            context=self.context
        )

class DataCenterClusterPermission(params.Permission, Base):
    def __init__(self, datacentercluster, permission, context):
        Base.__init__(self, context)
        self.parentclass = datacentercluster
        self.superclass  =  permission

        #SUB_COLLECTIONS
    def __new__(cls, datacentercluster, permission, context):
        if permission is None: return None
        obj = object.__new__(cls)
        obj.__init__(datacentercluster, permission, context)
        return obj

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def delete(self, async=None, correlation_id=None):
        '''
        [@param async: boolean (true|false)]
        [@param correlation_id: any string]

        @return None:
        '''

        url = UrlHelper.replace(
            '/datacenters/{datacenter:id}/clusters/{cluster:id}/permissions/{permission:id}',
            {
                '{datacenter:id}': self.parentclass.parentclass.get_id(),
                '{cluster:id}': self.parentclass.get_id(),
                '{permission:id}': self.get_id(),
            }
        )

        return self.__getProxy().delete(
            url=UrlHelper.appendParameters(
                url,
                {'async:matrix':async}
            ),
            headers={"Correlation-Id":correlation_id,"Content-type":None}
        )

class DataCenterClusterPermissions(Base):

    def __init__(self, cluster , context):
        Base.__init__(self, context)
        self.parentclass = cluster

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def add(self, permission, correlation_id=None, expect=None):

        '''
        @type Permission:

        Overload 1:
          @param permission.user.id: string
          @param permission.role.id|name: string
        Overload 2:
          @param permission.group.id: string
          @param permission.role.id|name: string
        [@param correlation_id: any string]
        [@param expect: 201-created]

        @return Permission:
        '''

        url = '/datacenters/{datacenter:id}/clusters/{cluster:id}/permissions'

        result = self.__getProxy().add(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{datacenter:id}': self.parentclass.parentclass.get_id(),
                        '{cluster:id}': self.parentclass.get_id(),
                    }
                ),
                args={}
            ),
            body=ParseHelper.toXml(permission),
            headers={"Correlation-Id":correlation_id, "Expect":expect}
        )

        return DataCenterClusterPermission(
            self.parentclass,
            result,
            self.context
        )

    def get(self, name=None, id=None):

        '''
        [@param id  : string (the id of the entity)]
        [@param name: string (the name of the entity)]

        @return Permissions:
        '''

        url = '/datacenters/{datacenter:id}/clusters/{cluster:id}/permissions'

        if id:
            try :
                result = self.__getProxy().get(
                    url=UrlHelper.append(
                        UrlHelper.replace(
                            url,
                            {
                                '{datacenter:id}': self.parentclass.parentclass.get_id(),
                                '{cluster:id}': self.parentclass.get_id(),
                            }
                        ),
                        id
                    ),
                    headers={}
                )

                return DataCenterClusterPermission(
                    self.parentclass,
                    result,
                    self.context
                )
            except RequestError as err:
                if err.status and err.status == 404:
                    return None
                raise err
        elif name:
            result = self.__getProxy().get(
                url=UrlHelper.replace(
                    url,
                    {
                        '{datacenter:id}': self.parentclass.parentclass.get_id(),
                        '{cluster:id}': self.parentclass.get_id(),
                    }
                ),
                headers={}
            ).get_permission()

            return DataCenterClusterPermission(
                self.parentclass,
                FilterHelper.getItem(
                    FilterHelper.filter(
                        result,
                        {'name':name}
                    ),
                    query="name=" + name
                ),
                self.context
            )
        else:
            raise MissingParametersError(['id', 'name'])

    def list(self, max=None, **kwargs):
        '''
        [@param **kwargs: dict (property based filtering)"]
        [@param max: int (max results)]

        @return Permissions:
        '''

        url = '/datacenters/{datacenter:id}/clusters/{cluster:id}/permissions'

        result = self.__getProxy().get(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{datacenter:id}': self.parentclass.parentclass.get_id(),
                        '{cluster:id}': self.parentclass.get_id(),
                    }
                ),
                args={'max:matrix':max}
            ),
            headers={}
        ).get_permission()

        return ParseHelper.toSubCollection(
            DataCenterClusterPermission,
            self.parentclass,
            FilterHelper.filter(
                result,
                kwargs
            ),
            context=self.context
        )

class DataCenterClusters(Base):

    def __init__(self, datacenter , context):
        Base.__init__(self, context)
        self.parentclass = datacenter

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def add(self, cluster, correlation_id=None, expect=None):

        '''
        @type Cluster:

        @param cluster.name: string
        @param cluster.version.major: int
        @param cluster.version.minor: int
        @param cluster.cpu.id: string
        [@param cluster.description: string]
        [@param cluster.memory_policy.overcommit.percent: double]
        [@param cluster.memory_policy.transparent_hugepages.enabled: boolean]
        [@param cluster.scheduling_policy.policy: string]
        [@param cluster.scheduling_policy.thresholds.low: int]
        [@param cluster.scheduling_policy.thresholds.high: int]
        [@param cluster.scheduling_policy.thresholds.duration: int]
        [@param cluster.scheduling_policy.id: string]
        [@param cluster.scheduling_policy.properties.property: collection]
        {
          [@ivar property.name: string]
          [@ivar property.value: string]
        }
        [@param cluster.error_handling.on_error: string]
        [@param cluster.virt_service: boolean]
        [@param cluster.gluster_service: boolean]
        [@param cluster.threads_as_cores: boolean]
        [@param cluster.tunnel_migration: boolean]
        [@param cluster.ballooning_enabled: boolean]
        [@param cluster.cpu.architecture: string]
        [@param cluster.display.proxy: string]
        [@param cluster.ksm.enabled: boolean]
        [@param cluster.management_network.id|name: string]
        [@param correlation_id: any string]
        [@param expect: 201-created]

        @return Cluster:
        '''

        url = '/datacenters/{datacenter:id}/clusters'

        result = self.__getProxy().add(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{datacenter:id}': self.parentclass.get_id(),
                    }
                ),
                args={}
            ),
            body=ParseHelper.toXml(cluster),
            headers={"Correlation-Id":correlation_id, "Expect":expect}
        )

        return DataCenterCluster(
            self.parentclass,
            result,
            self.context
        )

    def get(self, name=None, id=None):

        '''
        [@param id  : string (the id of the entity)]
        [@param name: string (the name of the entity)]

        @return Clusters:
        '''

        url = '/datacenters/{datacenter:id}/clusters'

        if id:
            try :
                result = self.__getProxy().get(
                    url=UrlHelper.append(
                        UrlHelper.replace(
                            url,
                            {
                                '{datacenter:id}': self.parentclass.get_id(),
                            }
                        ),
                        id
                    ),
                    headers={}
                )

                return DataCenterCluster(
                    self.parentclass,
                    result,
                    self.context
                )
            except RequestError as err:
                if err.status and err.status == 404:
                    return None
                raise err
        elif name:
            result = self.__getProxy().get(
                url=UrlHelper.replace(
                    url,
                    {
                        '{datacenter:id}': self.parentclass.get_id(),
                    }
                ),
                headers={}
            ).get_cluster()

            return DataCenterCluster(
                self.parentclass,
                FilterHelper.getItem(
                    FilterHelper.filter(
                        result,
                        {'name':name}
                    ),
                    query="name=" + name
                ),
                self.context
            )
        else:
            raise MissingParametersError(['id', 'name'])

    def list(self, max=None, **kwargs):
        '''
        [@param **kwargs: dict (property based filtering)"]
        [@param max: int (max results)]

        @return Clusters:
        '''

        url = '/datacenters/{datacenter:id}/clusters'

        result = self.__getProxy().get(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{datacenter:id}': self.parentclass.get_id(),
                    }
                ),
                args={'max:matrix':max}
            ),
            headers={}
        ).get_cluster()

        return ParseHelper.toSubCollection(
            DataCenterCluster,
            self.parentclass,
            FilterHelper.filter(
                result,
                kwargs
            ),
            context=self.context
        )

class DataCenterIscsiBond(params.IscsiBond, Base):
    def __init__(self, datacenter, iscsibond, context):
        Base.__init__(self, context)
        self.parentclass = datacenter
        self.superclass  =  iscsibond

        self.networks = DataCenterIscsiBondNetworks(self, context)
        self.storageconnections = DataCenterIscsiBondStorageConnections(self, context)

    def __new__(cls, datacenter, iscsibond, context):
        if iscsibond is None: return None
        obj = object.__new__(cls)
        obj.__init__(datacenter, iscsibond, context)
        return obj

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def delete(self, async=None, correlation_id=None):
        '''
        [@param async: boolean (true|false)]
        [@param correlation_id: any string]

        @return None:
        '''

        url = UrlHelper.replace(
            '/datacenters/{datacenter:id}/iscsibonds/{iscsibond:id}',
            {
                '{datacenter:id}': self.parentclass.get_id(),
                '{iscsibond:id}': self.get_id(),
            }
        )

        return self.__getProxy().delete(
            url=UrlHelper.appendParameters(
                url,
                {'async:matrix':async}
            ),
            headers={"Correlation-Id":correlation_id,"Content-type":None}
        )

    def update(self, async=None, correlation_id=None, expect=None):
        '''
        [@param async: boolean (true|false)]
        [@param correlation_id: any string]
        [@param expect: 202-accepted]

        @return IscsiBond:
        '''

        url = '/datacenters/{datacenter:id}/iscsibonds/{iscsibond:id}'
        url = UrlHelper.replace(
            url,
            {
                '{datacenter:id}': self.parentclass.get_id(),
                '{iscsibond:id}': self.get_id(),
            }
        )

        result = self.__getProxy().update(
            url=UrlHelper.appendParameters(url, {'async:matrix':async}),
            body=ParseHelper.toXml(self.superclass),
            headers={"Correlation-Id":correlation_id, "Expect":expect}
        )

        return DataCenterIscsiBond(
            self.parentclass,
            result,
            self.context
        )

class DataCenterIscsiBondNetwork(params.Network, Base):
    def __init__(self, datacenteriscsibond, network, context):
        Base.__init__(self, context)
        self.parentclass = datacenteriscsibond
        self.superclass  =  network

        self.labels = DataCenterIscsiBondNetworkLabels(self, context)
        self.permissions = DataCenterIscsiBondNetworkPermissions(self, context)
        self.vnicprofiles = DataCenterIscsiBondNetworkVnicProfiles(self, context)

    def __new__(cls, datacenteriscsibond, network, context):
        if network is None: return None
        obj = object.__new__(cls)
        obj.__init__(datacenteriscsibond, network, context)
        return obj

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def delete(self, async=None):
        '''
        [@param async: boolean (true|false)]

        @return None:
        '''

        url = UrlHelper.replace(
            '/datacenters/{datacenter:id}/iscsibonds/{iscsibond:id}/networks/{network:id}',
            {
                '{datacenter:id}': self.parentclass.parentclass.get_id(),
                '{iscsibond:id}': self.parentclass.get_id(),
                '{network:id}': self.get_id(),
            }
        )

        return self.__getProxy().delete(
            url=UrlHelper.appendParameters(
                url,
                {'async:matrix':async}
            ),
            headers={"Content-type":None}
        )

    def update(self, async=None):
        '''
        [@param async: boolean (true|false)]

        @return Network:
        '''

        url = '/datacenters/{datacenter:id}/iscsibonds/{iscsibond:id}/networks/{network:id}'
        url = UrlHelper.replace(
            url,
            {
                '{datacenter:id}': self.parentclass.parentclass.get_id(),
                '{iscsibond:id}': self.parentclass.get_id(),
                '{network:id}': self.get_id(),
            }
        )

        result = self.__getProxy().update(
            url=UrlHelper.appendParameters(url, {'async:matrix':async}),
            body=ParseHelper.toXml(self.superclass),
            headers={}
        )

        return DataCenterIscsiBondNetwork(
            self.parentclass,
            result,
            self.context
        )

class DataCenterIscsiBondNetworkLabel(params.Label, Base):
    def __init__(self, datacenteriscsibondnetwork, label, context):
        Base.__init__(self, context)
        self.parentclass = datacenteriscsibondnetwork
        self.superclass  =  label

        #SUB_COLLECTIONS
    def __new__(cls, datacenteriscsibondnetwork, label, context):
        if label is None: return None
        obj = object.__new__(cls)
        obj.__init__(datacenteriscsibondnetwork, label, context)
        return obj

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def delete(self, async=None):
        '''
        [@param async: boolean (true|false)]

        @return None:
        '''

        url = UrlHelper.replace(
            '/datacenters/{datacenter:id}/iscsibonds/{iscsibond:id}/networks/{network:id}/labels/{label:id}',
            {
                '{datacenter:id}': self.parentclass.parentclass.parentclass.get_id(),
                '{iscsibond:id}': self.parentclass.parentclass.get_id(),
                '{network:id}': self.parentclass.get_id(),
                '{label:id}': self.get_id(),
            }
        )

        return self.__getProxy().delete(
            url=UrlHelper.appendParameters(
                url,
                {'async:matrix':async}
            ),
            headers={"Content-type":None}
        )

class DataCenterIscsiBondNetworkLabels(Base):

    def __init__(self, network , context):
        Base.__init__(self, context)
        self.parentclass = network

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def add(self, label):

        '''
        @type Label:


        @return Label:
        '''

        url = '/datacenters/{datacenter:id}/iscsibonds/{iscsibond:id}/networks/{network:id}/labels'

        result = self.__getProxy().add(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{datacenter:id}': self.parentclass.parentclass.parentclass.get_id(),
                        '{iscsibond:id}': self.parentclass.parentclass.get_id(),
                        '{network:id}': self.parentclass.get_id(),
                    }
                ),
                args={}
            ),
            body=ParseHelper.toXml(label),
            headers={}
        )

        return DataCenterIscsiBondNetworkLabel(
            self.parentclass,
            result,
            self.context
        )

    def get(self, name=None, id=None):

        '''
        [@param id  : string (the id of the entity)]
        [@param name: string (the name of the entity)]

        @return Labels:
        '''

        url = '/datacenters/{datacenter:id}/iscsibonds/{iscsibond:id}/networks/{network:id}/labels'

        if id:
            try :
                result = self.__getProxy().get(
                    url=UrlHelper.append(
                        UrlHelper.replace(
                            url,
                            {
                                '{datacenter:id}': self.parentclass.parentclass.parentclass.get_id(),
                                '{iscsibond:id}': self.parentclass.parentclass.get_id(),
                                '{network:id}': self.parentclass.get_id(),
                            }
                        ),
                        id
                    ),
                    headers={}
                )

                return DataCenterIscsiBondNetworkLabel(
                    self.parentclass,
                    result,
                    self.context
                )
            except RequestError as err:
                if err.status and err.status == 404:
                    return None
                raise err
        elif name:
            result = self.__getProxy().get(
                url=UrlHelper.replace(
                    url,
                    {
                        '{datacenter:id}': self.parentclass.parentclass.parentclass.get_id(),
                        '{iscsibond:id}': self.parentclass.parentclass.get_id(),
                        '{network:id}': self.parentclass.get_id(),
                    }
                ),
                headers={}
            ).get_label()

            return DataCenterIscsiBondNetworkLabel(
                self.parentclass,
                FilterHelper.getItem(
                    FilterHelper.filter(
                        result,
                        {'name':name}
                    ),
                    query="name=" + name
                ),
                self.context
            )
        else:
            raise MissingParametersError(['id', 'name'])

    def list(self, max=None, **kwargs):
        '''
        [@param **kwargs: dict (property based filtering)"]
        [@param max: int (max results)]

        @return Labels:
        '''

        url = '/datacenters/{datacenter:id}/iscsibonds/{iscsibond:id}/networks/{network:id}/labels'

        result = self.__getProxy().get(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{datacenter:id}': self.parentclass.parentclass.parentclass.get_id(),
                        '{iscsibond:id}': self.parentclass.parentclass.get_id(),
                        '{network:id}': self.parentclass.get_id(),
                    }
                ),
                args={'max:matrix':max}
            ),
            headers={}
        ).get_label()

        return ParseHelper.toSubCollection(
            DataCenterIscsiBondNetworkLabel,
            self.parentclass,
            FilterHelper.filter(
                result,
                kwargs
            ),
            context=self.context
        )

class DataCenterIscsiBondNetworkPermission(params.Permission, Base):
    def __init__(self, datacenteriscsibondnetwork, permission, context):
        Base.__init__(self, context)
        self.parentclass = datacenteriscsibondnetwork
        self.superclass  =  permission

        #SUB_COLLECTIONS
    def __new__(cls, datacenteriscsibondnetwork, permission, context):
        if permission is None: return None
        obj = object.__new__(cls)
        obj.__init__(datacenteriscsibondnetwork, permission, context)
        return obj

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def delete(self, async=None):
        '''
        [@param async: boolean (true|false)]

        @return None:
        '''

        url = UrlHelper.replace(
            '/datacenters/{datacenter:id}/iscsibonds/{iscsibond:id}/networks/{network:id}/permissions/{permission:id}',
            {
                '{datacenter:id}': self.parentclass.parentclass.parentclass.get_id(),
                '{iscsibond:id}': self.parentclass.parentclass.get_id(),
                '{network:id}': self.parentclass.get_id(),
                '{permission:id}': self.get_id(),
            }
        )

        return self.__getProxy().delete(
            url=UrlHelper.appendParameters(
                url,
                {'async:matrix':async}
            ),
            headers={"Content-type":None}
        )

class DataCenterIscsiBondNetworkPermissions(Base):

    def __init__(self, network , context):
        Base.__init__(self, context)
        self.parentclass = network

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def add(self, permission):

        '''
        @type Permission:


        @return Permission:
        '''

        url = '/datacenters/{datacenter:id}/iscsibonds/{iscsibond:id}/networks/{network:id}/permissions'

        result = self.__getProxy().add(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{datacenter:id}': self.parentclass.parentclass.parentclass.get_id(),
                        '{iscsibond:id}': self.parentclass.parentclass.get_id(),
                        '{network:id}': self.parentclass.get_id(),
                    }
                ),
                args={}
            ),
            body=ParseHelper.toXml(permission),
            headers={}
        )

        return DataCenterIscsiBondNetworkPermission(
            self.parentclass,
            result,
            self.context
        )

    def get(self, name=None, id=None):

        '''
        [@param id  : string (the id of the entity)]
        [@param name: string (the name of the entity)]

        @return Permissions:
        '''

        url = '/datacenters/{datacenter:id}/iscsibonds/{iscsibond:id}/networks/{network:id}/permissions'

        if id:
            try :
                result = self.__getProxy().get(
                    url=UrlHelper.append(
                        UrlHelper.replace(
                            url,
                            {
                                '{datacenter:id}': self.parentclass.parentclass.parentclass.get_id(),
                                '{iscsibond:id}': self.parentclass.parentclass.get_id(),
                                '{network:id}': self.parentclass.get_id(),
                            }
                        ),
                        id
                    ),
                    headers={}
                )

                return DataCenterIscsiBondNetworkPermission(
                    self.parentclass,
                    result,
                    self.context
                )
            except RequestError as err:
                if err.status and err.status == 404:
                    return None
                raise err
        elif name:
            result = self.__getProxy().get(
                url=UrlHelper.replace(
                    url,
                    {
                        '{datacenter:id}': self.parentclass.parentclass.parentclass.get_id(),
                        '{iscsibond:id}': self.parentclass.parentclass.get_id(),
                        '{network:id}': self.parentclass.get_id(),
                    }
                ),
                headers={}
            ).get_permission()

            return DataCenterIscsiBondNetworkPermission(
                self.parentclass,
                FilterHelper.getItem(
                    FilterHelper.filter(
                        result,
                        {'name':name}
                    ),
                    query="name=" + name
                ),
                self.context
            )
        else:
            raise MissingParametersError(['id', 'name'])

    def list(self, max=None, **kwargs):
        '''
        [@param **kwargs: dict (property based filtering)"]
        [@param max: int (max results)]

        @return Permissions:
        '''

        url = '/datacenters/{datacenter:id}/iscsibonds/{iscsibond:id}/networks/{network:id}/permissions'

        result = self.__getProxy().get(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{datacenter:id}': self.parentclass.parentclass.parentclass.get_id(),
                        '{iscsibond:id}': self.parentclass.parentclass.get_id(),
                        '{network:id}': self.parentclass.get_id(),
                    }
                ),
                args={'max:matrix':max}
            ),
            headers={}
        ).get_permission()

        return ParseHelper.toSubCollection(
            DataCenterIscsiBondNetworkPermission,
            self.parentclass,
            FilterHelper.filter(
                result,
                kwargs
            ),
            context=self.context
        )

class DataCenterIscsiBondNetworkVnicProfile(params.VnicProfile, Base):
    def __init__(self, datacenteriscsibondnetwork, vnicprofile, context):
        Base.__init__(self, context)
        self.parentclass = datacenteriscsibondnetwork
        self.superclass  =  vnicprofile

        self.permissions = DataCenterIscsiBondNetworkVnicProfilePermissions(self, context)

    def __new__(cls, datacenteriscsibondnetwork, vnicprofile, context):
        if vnicprofile is None: return None
        obj = object.__new__(cls)
        obj.__init__(datacenteriscsibondnetwork, vnicprofile, context)
        return obj

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def delete(self, async=None):
        '''
        [@param async: boolean (true|false)]

        @return None:
        '''

        url = UrlHelper.replace(
            '/datacenters/{datacenter:id}/iscsibonds/{iscsibond:id}/networks/{network:id}/vnicprofiles/{vnicprofile:id}',
            {
                '{datacenter:id}': self.parentclass.parentclass.parentclass.get_id(),
                '{iscsibond:id}': self.parentclass.parentclass.get_id(),
                '{network:id}': self.parentclass.get_id(),
                '{vnicprofile:id}': self.get_id(),
            }
        )

        return self.__getProxy().delete(
            url=UrlHelper.appendParameters(
                url,
                {'async:matrix':async}
            ),
            headers={"Content-type":None}
        )

class DataCenterIscsiBondNetworkVnicProfilePermission(params.Permission, Base):
    def __init__(self, datacenteriscsibondnetworkvnicprofile, permission, context):
        Base.__init__(self, context)
        self.parentclass = datacenteriscsibondnetworkvnicprofile
        self.superclass  =  permission

        #SUB_COLLECTIONS
    def __new__(cls, datacenteriscsibondnetworkvnicprofile, permission, context):
        if permission is None: return None
        obj = object.__new__(cls)
        obj.__init__(datacenteriscsibondnetworkvnicprofile, permission, context)
        return obj

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def delete(self, async=None):
        '''
        [@param async: boolean (true|false)]

        @return None:
        '''

        url = UrlHelper.replace(
            '/datacenters/{datacenter:id}/iscsibonds/{iscsibond:id}/networks/{network:id}/vnicprofiles/{vnicprofile:id}/permissions/{permission:id}',
            {
                '{datacenter:id}': self.parentclass.parentclass.parentclass.parentclass.get_id(),
                '{iscsibond:id}': self.parentclass.parentclass.parentclass.get_id(),
                '{network:id}': self.parentclass.parentclass.get_id(),
                '{vnicprofile:id}': self.parentclass.get_id(),
                '{permission:id}': self.get_id(),
            }
        )

        return self.__getProxy().delete(
            url=UrlHelper.appendParameters(
                url,
                {'async:matrix':async}
            ),
            headers={"Content-type":None}
        )

class DataCenterIscsiBondNetworkVnicProfilePermissions(Base):

    def __init__(self, vnicprofile , context):
        Base.__init__(self, context)
        self.parentclass = vnicprofile

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def add(self, permission):

        '''
        @type Permission:


        @return Permission:
        '''

        url = '/datacenters/{datacenter:id}/iscsibonds/{iscsibond:id}/networks/{network:id}/vnicprofiles/{vnicprofile:id}/permissions'

        result = self.__getProxy().add(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{datacenter:id}': self.parentclass.parentclass.parentclass.parentclass.get_id(),
                        '{iscsibond:id}': self.parentclass.parentclass.parentclass.get_id(),
                        '{network:id}': self.parentclass.parentclass.get_id(),
                        '{vnicprofile:id}': self.parentclass.get_id(),
                    }
                ),
                args={}
            ),
            body=ParseHelper.toXml(permission),
            headers={}
        )

        return DataCenterIscsiBondNetworkVnicProfilePermission(
            self.parentclass,
            result,
            self.context
        )

    def get(self, name=None, id=None):

        '''
        [@param id  : string (the id of the entity)]
        [@param name: string (the name of the entity)]

        @return Permissions:
        '''

        url = '/datacenters/{datacenter:id}/iscsibonds/{iscsibond:id}/networks/{network:id}/vnicprofiles/{vnicprofile:id}/permissions'

        if id:
            try :
                result = self.__getProxy().get(
                    url=UrlHelper.append(
                        UrlHelper.replace(
                            url,
                            {
                                '{datacenter:id}': self.parentclass.parentclass.parentclass.parentclass.get_id(),
                                '{iscsibond:id}': self.parentclass.parentclass.parentclass.get_id(),
                                '{network:id}': self.parentclass.parentclass.get_id(),
                                '{vnicprofile:id}': self.parentclass.get_id(),
                            }
                        ),
                        id
                    ),
                    headers={}
                )

                return DataCenterIscsiBondNetworkVnicProfilePermission(
                    self.parentclass,
                    result,
                    self.context
                )
            except RequestError as err:
                if err.status and err.status == 404:
                    return None
                raise err
        elif name:
            result = self.__getProxy().get(
                url=UrlHelper.replace(
                    url,
                    {
                        '{datacenter:id}': self.parentclass.parentclass.parentclass.parentclass.get_id(),
                        '{iscsibond:id}': self.parentclass.parentclass.parentclass.get_id(),
                        '{network:id}': self.parentclass.parentclass.get_id(),
                        '{vnicprofile:id}': self.parentclass.get_id(),
                    }
                ),
                headers={}
            ).get_permission()

            return DataCenterIscsiBondNetworkVnicProfilePermission(
                self.parentclass,
                FilterHelper.getItem(
                    FilterHelper.filter(
                        result,
                        {'name':name}
                    ),
                    query="name=" + name
                ),
                self.context
            )
        else:
            raise MissingParametersError(['id', 'name'])

    def list(self, max=None, **kwargs):
        '''
        [@param **kwargs: dict (property based filtering)"]
        [@param max: int (max results)]

        @return Permissions:
        '''

        url = '/datacenters/{datacenter:id}/iscsibonds/{iscsibond:id}/networks/{network:id}/vnicprofiles/{vnicprofile:id}/permissions'

        result = self.__getProxy().get(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{datacenter:id}': self.parentclass.parentclass.parentclass.parentclass.get_id(),
                        '{iscsibond:id}': self.parentclass.parentclass.parentclass.get_id(),
                        '{network:id}': self.parentclass.parentclass.get_id(),
                        '{vnicprofile:id}': self.parentclass.get_id(),
                    }
                ),
                args={'max:matrix':max}
            ),
            headers={}
        ).get_permission()

        return ParseHelper.toSubCollection(
            DataCenterIscsiBondNetworkVnicProfilePermission,
            self.parentclass,
            FilterHelper.filter(
                result,
                kwargs
            ),
            context=self.context
        )

class DataCenterIscsiBondNetworkVnicProfiles(Base):

    def __init__(self, network , context):
        Base.__init__(self, context)
        self.parentclass = network

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def add(self, vnicprofile):

        '''
        @type VnicProfile:


        @return VnicProfile:
        '''

        url = '/datacenters/{datacenter:id}/iscsibonds/{iscsibond:id}/networks/{network:id}/vnicprofiles'

        result = self.__getProxy().add(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{datacenter:id}': self.parentclass.parentclass.parentclass.get_id(),
                        '{iscsibond:id}': self.parentclass.parentclass.get_id(),
                        '{network:id}': self.parentclass.get_id(),
                    }
                ),
                args={}
            ),
            body=ParseHelper.toXml(vnicprofile),
            headers={}
        )

        return DataCenterIscsiBondNetworkVnicProfile(
            self.parentclass,
            result,
            self.context
        )

    def get(self, name=None, id=None):

        '''
        [@param id  : string (the id of the entity)]
        [@param name: string (the name of the entity)]

        @return VnicProfiles:
        '''

        url = '/datacenters/{datacenter:id}/iscsibonds/{iscsibond:id}/networks/{network:id}/vnicprofiles'

        if id:
            try :
                result = self.__getProxy().get(
                    url=UrlHelper.append(
                        UrlHelper.replace(
                            url,
                            {
                                '{datacenter:id}': self.parentclass.parentclass.parentclass.get_id(),
                                '{iscsibond:id}': self.parentclass.parentclass.get_id(),
                                '{network:id}': self.parentclass.get_id(),
                            }
                        ),
                        id
                    ),
                    headers={}
                )

                return DataCenterIscsiBondNetworkVnicProfile(
                    self.parentclass,
                    result,
                    self.context
                )
            except RequestError as err:
                if err.status and err.status == 404:
                    return None
                raise err
        elif name:
            result = self.__getProxy().get(
                url=UrlHelper.replace(
                    url,
                    {
                        '{datacenter:id}': self.parentclass.parentclass.parentclass.get_id(),
                        '{iscsibond:id}': self.parentclass.parentclass.get_id(),
                        '{network:id}': self.parentclass.get_id(),
                    }
                ),
                headers={}
            ).get_vnic_profile()

            return DataCenterIscsiBondNetworkVnicProfile(
                self.parentclass,
                FilterHelper.getItem(
                    FilterHelper.filter(
                        result,
                        {'name':name}
                    ),
                    query="name=" + name
                ),
                self.context
            )
        else:
            raise MissingParametersError(['id', 'name'])

    def list(self, max=None, **kwargs):
        '''
        [@param **kwargs: dict (property based filtering)"]
        [@param max: int (max results)]

        @return VnicProfiles:
        '''

        url = '/datacenters/{datacenter:id}/iscsibonds/{iscsibond:id}/networks/{network:id}/vnicprofiles'

        result = self.__getProxy().get(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{datacenter:id}': self.parentclass.parentclass.parentclass.get_id(),
                        '{iscsibond:id}': self.parentclass.parentclass.get_id(),
                        '{network:id}': self.parentclass.get_id(),
                    }
                ),
                args={'max:matrix':max}
            ),
            headers={}
        ).get_vnic_profile()

        return ParseHelper.toSubCollection(
            DataCenterIscsiBondNetworkVnicProfile,
            self.parentclass,
            FilterHelper.filter(
                result,
                kwargs
            ),
            context=self.context
        )

class DataCenterIscsiBondNetworks(Base):

    def __init__(self, iscsibond , context):
        Base.__init__(self, context)
        self.parentclass = iscsibond

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def add(self, network, correlation_id=None, expect=None):

        '''
        @type Network:

        [@param correlation_id: any string]
        [@param expect: 201-created]

        @return Network:
        '''

        url = '/datacenters/{datacenter:id}/iscsibonds/{iscsibond:id}/networks'

        result = self.__getProxy().add(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{datacenter:id}': self.parentclass.parentclass.get_id(),
                        '{iscsibond:id}': self.parentclass.get_id(),
                    }
                ),
                args={}
            ),
            body=ParseHelper.toXml(network),
            headers={"Correlation-Id":correlation_id, "Expect":expect}
        )

        return DataCenterIscsiBondNetwork(
            self.parentclass,
            result,
            self.context
        )

    def get(self, name=None, id=None):

        '''
        [@param id  : string (the id of the entity)]
        [@param name: string (the name of the entity)]

        @return Networks:
        '''

        url = '/datacenters/{datacenter:id}/iscsibonds/{iscsibond:id}/networks'

        if id:
            try :
                result = self.__getProxy().get(
                    url=UrlHelper.append(
                        UrlHelper.replace(
                            url,
                            {
                                '{datacenter:id}': self.parentclass.parentclass.get_id(),
                                '{iscsibond:id}': self.parentclass.get_id(),
                            }
                        ),
                        id
                    ),
                    headers={}
                )

                return DataCenterIscsiBondNetwork(
                    self.parentclass,
                    result,
                    self.context
                )
            except RequestError as err:
                if err.status and err.status == 404:
                    return None
                raise err
        elif name:
            result = self.__getProxy().get(
                url=UrlHelper.replace(
                    url,
                    {
                        '{datacenter:id}': self.parentclass.parentclass.get_id(),
                        '{iscsibond:id}': self.parentclass.get_id(),
                    }
                ),
                headers={}
            ).get_network()

            return DataCenterIscsiBondNetwork(
                self.parentclass,
                FilterHelper.getItem(
                    FilterHelper.filter(
                        result,
                        {'name':name}
                    ),
                    query="name=" + name
                ),
                self.context
            )
        else:
            raise MissingParametersError(['id', 'name'])

    def list(self, max=None, **kwargs):
        '''
        [@param **kwargs: dict (property based filtering)"]
        [@param max: int (max results)]

        @return Networks:
        '''

        url = '/datacenters/{datacenter:id}/iscsibonds/{iscsibond:id}/networks'

        result = self.__getProxy().get(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{datacenter:id}': self.parentclass.parentclass.get_id(),
                        '{iscsibond:id}': self.parentclass.get_id(),
                    }
                ),
                args={'max:matrix':max}
            ),
            headers={}
        ).get_network()

        return ParseHelper.toSubCollection(
            DataCenterIscsiBondNetwork,
            self.parentclass,
            FilterHelper.filter(
                result,
                kwargs
            ),
            context=self.context
        )

class DataCenterIscsiBondStorageConnection(params.StorageConnection, Base):
    def __init__(self, datacenteriscsibond, storageconnection, context):
        Base.__init__(self, context)
        self.parentclass = datacenteriscsibond
        self.superclass  =  storageconnection

        #SUB_COLLECTIONS
    def __new__(cls, datacenteriscsibond, storageconnection, context):
        if storageconnection is None: return None
        obj = object.__new__(cls)
        obj.__init__(datacenteriscsibond, storageconnection, context)
        return obj

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def delete(self, action, async=None):
        '''
        @type Action:

        [@param async: boolean (true|false)]

        @return None:
        '''

        url = UrlHelper.replace(
            '/datacenters/{datacenter:id}/iscsibonds/{iscsibond:id}/storageconnections/{storageconnection:id}',
            {
                '{datacenter:id}': self.parentclass.parentclass.get_id(),
                '{iscsibond:id}': self.parentclass.get_id(),
                '{storageconnection:id}': self.get_id(),
            }
        )

        return self.__getProxy().delete(
            url=UrlHelper.appendParameters(
                url,
                {'async:matrix':async}
            ),
            body=ParseHelper.toXml(action),
            headers={}
        )

    def delete(self, async=None):
        '''
        [@param async: boolean (true|false)]

        @return None:
        '''

        url = UrlHelper.replace(
            '/datacenters/{datacenter:id}/iscsibonds/{iscsibond:id}/storageconnections/{storageconnection:id}',
            {
                '{datacenter:id}': self.parentclass.parentclass.get_id(),
                '{iscsibond:id}': self.parentclass.get_id(),
                '{storageconnection:id}': self.get_id(),
            }
        )

        return self.__getProxy().delete(
            url=UrlHelper.appendParameters(
                url,
                {'async:matrix':async}
            ),
            headers={"Content-type":None}
        )

    def update(self, async=None):
        '''
        [@param async: boolean (true|false)]

        @return StorageConnection:
        '''

        url = '/datacenters/{datacenter:id}/iscsibonds/{iscsibond:id}/storageconnections/{storageconnection:id}'
        url = UrlHelper.replace(
            url,
            {
                '{datacenter:id}': self.parentclass.parentclass.get_id(),
                '{iscsibond:id}': self.parentclass.get_id(),
                '{storageconnection:id}': self.get_id(),
            }
        )

        result = self.__getProxy().update(
            url=UrlHelper.appendParameters(url, {'async:matrix':async}),
            body=ParseHelper.toXml(self.superclass),
            headers={}
        )

        return DataCenterIscsiBondStorageConnection(
            self.parentclass,
            result,
            self.context
        )

class DataCenterIscsiBondStorageConnections(Base):

    def __init__(self, iscsibond , context):
        Base.__init__(self, context)
        self.parentclass = iscsibond

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def add(self, storageconnection):

        '''
        @type StorageConnection:


        @return StorageConnection:
        '''

        url = '/datacenters/{datacenter:id}/iscsibonds/{iscsibond:id}/storageconnections'

        result = self.__getProxy().add(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{datacenter:id}': self.parentclass.parentclass.get_id(),
                        '{iscsibond:id}': self.parentclass.get_id(),
                    }
                ),
                args={}
            ),
            body=ParseHelper.toXml(storageconnection),
            headers={}
        )

        return DataCenterIscsiBondStorageConnection(
            self.parentclass,
            result,
            self.context
        )

    def get(self, name=None, id=None):

        '''
        [@param id  : string (the id of the entity)]
        [@param name: string (the name of the entity)]

        @return StorageConnections:
        '''

        url = '/datacenters/{datacenter:id}/iscsibonds/{iscsibond:id}/storageconnections'

        if id:
            try :
                result = self.__getProxy().get(
                    url=UrlHelper.append(
                        UrlHelper.replace(
                            url,
                            {
                                '{datacenter:id}': self.parentclass.parentclass.get_id(),
                                '{iscsibond:id}': self.parentclass.get_id(),
                            }
                        ),
                        id
                    ),
                    headers={}
                )

                return DataCenterIscsiBondStorageConnection(
                    self.parentclass,
                    result,
                    self.context
                )
            except RequestError as err:
                if err.status and err.status == 404:
                    return None
                raise err
        elif name:
            result = self.__getProxy().get(
                url=UrlHelper.replace(
                    url,
                    {
                        '{datacenter:id}': self.parentclass.parentclass.get_id(),
                        '{iscsibond:id}': self.parentclass.get_id(),
                    }
                ),
                headers={}
            ).get_storage_connection()

            return DataCenterIscsiBondStorageConnection(
                self.parentclass,
                FilterHelper.getItem(
                    FilterHelper.filter(
                        result,
                        {'name':name}
                    ),
                    query="name=" + name
                ),
                self.context
            )
        else:
            raise MissingParametersError(['id', 'name'])

    def list(self, max=None, **kwargs):
        '''
        [@param **kwargs: dict (property based filtering)"]
        [@param max: int (max results)]

        @return StorageConnections:
        '''

        url = '/datacenters/{datacenter:id}/iscsibonds/{iscsibond:id}/storageconnections'

        result = self.__getProxy().get(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{datacenter:id}': self.parentclass.parentclass.get_id(),
                        '{iscsibond:id}': self.parentclass.get_id(),
                    }
                ),
                args={'max:matrix':max}
            ),
            headers={}
        ).get_storage_connection()

        return ParseHelper.toSubCollection(
            DataCenterIscsiBondStorageConnection,
            self.parentclass,
            FilterHelper.filter(
                result,
                kwargs
            ),
            context=self.context
        )

class DataCenterIscsiBonds(Base):

    def __init__(self, datacenter , context):
        Base.__init__(self, context)
        self.parentclass = datacenter

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def add(self, iscsibond, correlation_id=None, expect=None):

        '''
        @type IscsiBond:

        @param iscsibond.name: string
        [@param correlation_id: any string]
        [@param expect: 201-created]

        @return IscsiBond:
        '''

        url = '/datacenters/{datacenter:id}/iscsibonds'

        result = self.__getProxy().add(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{datacenter:id}': self.parentclass.get_id(),
                    }
                ),
                args={}
            ),
            body=ParseHelper.toXml(iscsibond),
            headers={"Correlation-Id":correlation_id, "Expect":expect}
        )

        return DataCenterIscsiBond(
            self.parentclass,
            result,
            self.context
        )

    def get(self, name=None, id=None):

        '''
        [@param id  : string (the id of the entity)]
        [@param name: string (the name of the entity)]

        @return IscsiBonds:
        '''

        url = '/datacenters/{datacenter:id}/iscsibonds'

        if id:
            try :
                result = self.__getProxy().get(
                    url=UrlHelper.append(
                        UrlHelper.replace(
                            url,
                            {
                                '{datacenter:id}': self.parentclass.get_id(),
                            }
                        ),
                        id
                    ),
                    headers={}
                )

                return DataCenterIscsiBond(
                    self.parentclass,
                    result,
                    self.context
                )
            except RequestError as err:
                if err.status and err.status == 404:
                    return None
                raise err
        elif name:
            result = self.__getProxy().get(
                url=UrlHelper.replace(
                    url,
                    {
                        '{datacenter:id}': self.parentclass.get_id(),
                    }
                ),
                headers={}
            ).get_iscsi_bond()

            return DataCenterIscsiBond(
                self.parentclass,
                FilterHelper.getItem(
                    FilterHelper.filter(
                        result,
                        {'name':name}
                    ),
                    query="name=" + name
                ),
                self.context
            )
        else:
            raise MissingParametersError(['id', 'name'])

    def list(self, max=None, **kwargs):
        '''
        [@param **kwargs: dict (property based filtering)"]
        [@param max: int (max results)]

        @return IscsiBonds:
        '''

        url = '/datacenters/{datacenter:id}/iscsibonds'

        result = self.__getProxy().get(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{datacenter:id}': self.parentclass.get_id(),
                    }
                ),
                args={'max:matrix':max}
            ),
            headers={}
        ).get_iscsi_bond()

        return ParseHelper.toSubCollection(
            DataCenterIscsiBond,
            self.parentclass,
            FilterHelper.filter(
                result,
                kwargs
            ),
            context=self.context
        )

class DataCenterNetwork(params.Network, Base):
    def __init__(self, datacenter, network, context):
        Base.__init__(self, context)
        self.parentclass = datacenter
        self.superclass  =  network

        self.labels = DataCenterNetworkLabels(self, context)
        self.permissions = DataCenterNetworkPermissions(self, context)
        self.vnicprofiles = DataCenterNetworkVnicProfiles(self, context)

    def __new__(cls, datacenter, network, context):
        if network is None: return None
        obj = object.__new__(cls)
        obj.__init__(datacenter, network, context)
        return obj

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def delete(self, async=None, correlation_id=None):
        '''
        [@param async: boolean (true|false)]
        [@param correlation_id: any string]

        @return None:
        '''

        url = UrlHelper.replace(
            '/datacenters/{datacenter:id}/networks/{network:id}',
            {
                '{datacenter:id}': self.parentclass.get_id(),
                '{network:id}': self.get_id(),
            }
        )

        return self.__getProxy().delete(
            url=UrlHelper.appendParameters(
                url,
                {'async:matrix':async}
            ),
            headers={"Correlation-Id":correlation_id,"Content-type":None}
        )

    def update(self, async=None, correlation_id=None, expect=None):
        '''
        [@param network.display: boolean]
        [@param network.usages.usage: collection]
        {
          [@ivar usage: string]
        }
        [@param async: boolean (true|false)]
        [@param correlation_id: any string]
        [@param expect: 202-accepted]

        @return Network:
        '''

        url = '/datacenters/{datacenter:id}/networks/{network:id}'
        url = UrlHelper.replace(
            url,
            {
                '{datacenter:id}': self.parentclass.get_id(),
                '{network:id}': self.get_id(),
            }
        )

        result = self.__getProxy().update(
            url=UrlHelper.appendParameters(url, {'async:matrix':async}),
            body=ParseHelper.toXml(self.superclass),
            headers={"Correlation-Id":correlation_id, "Expect":expect}
        )

        return DataCenterNetwork(
            self.parentclass,
            result,
            self.context
        )

class DataCenterNetworkLabel(params.Label, Base):
    def __init__(self, datacenternetwork, label, context):
        Base.__init__(self, context)
        self.parentclass = datacenternetwork
        self.superclass  =  label

        #SUB_COLLECTIONS
    def __new__(cls, datacenternetwork, label, context):
        if label is None: return None
        obj = object.__new__(cls)
        obj.__init__(datacenternetwork, label, context)
        return obj

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def delete(self, async=None, correlation_id=None):
        '''
        [@param async: boolean (true|false)]
        [@param correlation_id: any string]

        @return None:
        '''

        url = UrlHelper.replace(
            '/datacenters/{datacenter:id}/networks/{network:id}/labels/{label:id}',
            {
                '{datacenter:id}': self.parentclass.parentclass.get_id(),
                '{network:id}': self.parentclass.get_id(),
                '{label:id}': self.get_id(),
            }
        )

        return self.__getProxy().delete(
            url=UrlHelper.appendParameters(
                url,
                {'async:matrix':async}
            ),
            headers={"Correlation-Id":correlation_id,"Content-type":None}
        )

class DataCenterNetworkLabels(Base):

    def __init__(self, network , context):
        Base.__init__(self, context)
        self.parentclass = network

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def add(self, label, correlation_id=None, expect=None):

        '''
        @type Label:

        @param label.id: string
        [@param correlation_id: any string]
        [@param expect: 201-created]

        @return Label:
        '''

        url = '/datacenters/{datacenter:id}/networks/{network:id}/labels'

        result = self.__getProxy().add(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{datacenter:id}': self.parentclass.parentclass.get_id(),
                        '{network:id}': self.parentclass.get_id(),
                    }
                ),
                args={}
            ),
            body=ParseHelper.toXml(label),
            headers={"Correlation-Id":correlation_id, "Expect":expect}
        )

        return DataCenterNetworkLabel(
            self.parentclass,
            result,
            self.context
        )

    def get(self, name=None, id=None):

        '''
        [@param id  : string (the id of the entity)]
        [@param name: string (the name of the entity)]

        @return Labels:
        '''

        url = '/datacenters/{datacenter:id}/networks/{network:id}/labels'

        if id:
            try :
                result = self.__getProxy().get(
                    url=UrlHelper.append(
                        UrlHelper.replace(
                            url,
                            {
                                '{datacenter:id}': self.parentclass.parentclass.get_id(),
                                '{network:id}': self.parentclass.get_id(),
                            }
                        ),
                        id
                    ),
                    headers={}
                )

                return DataCenterNetworkLabel(
                    self.parentclass,
                    result,
                    self.context
                )
            except RequestError as err:
                if err.status and err.status == 404:
                    return None
                raise err
        elif name:
            result = self.__getProxy().get(
                url=UrlHelper.replace(
                    url,
                    {
                        '{datacenter:id}': self.parentclass.parentclass.get_id(),
                        '{network:id}': self.parentclass.get_id(),
                    }
                ),
                headers={}
            ).get_label()

            return DataCenterNetworkLabel(
                self.parentclass,
                FilterHelper.getItem(
                    FilterHelper.filter(
                        result,
                        {'name':name}
                    ),
                    query="name=" + name
                ),
                self.context
            )
        else:
            raise MissingParametersError(['id', 'name'])

    def list(self, max=None, **kwargs):
        '''
        [@param **kwargs: dict (property based filtering)"]
        [@param max: int (max results)]

        @return Labels:
        '''

        url = '/datacenters/{datacenter:id}/networks/{network:id}/labels'

        result = self.__getProxy().get(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{datacenter:id}': self.parentclass.parentclass.get_id(),
                        '{network:id}': self.parentclass.get_id(),
                    }
                ),
                args={'max:matrix':max}
            ),
            headers={}
        ).get_label()

        return ParseHelper.toSubCollection(
            DataCenterNetworkLabel,
            self.parentclass,
            FilterHelper.filter(
                result,
                kwargs
            ),
            context=self.context
        )

class DataCenterNetworkPermission(params.Permission, Base):
    def __init__(self, datacenternetwork, permission, context):
        Base.__init__(self, context)
        self.parentclass = datacenternetwork
        self.superclass  =  permission

        #SUB_COLLECTIONS
    def __new__(cls, datacenternetwork, permission, context):
        if permission is None: return None
        obj = object.__new__(cls)
        obj.__init__(datacenternetwork, permission, context)
        return obj

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def delete(self, async=None):
        '''
        [@param async: boolean (true|false)]

        @return None:
        '''

        url = UrlHelper.replace(
            '/datacenters/{datacenter:id}/networks/{network:id}/permissions/{permission:id}',
            {
                '{datacenter:id}': self.parentclass.parentclass.get_id(),
                '{network:id}': self.parentclass.get_id(),
                '{permission:id}': self.get_id(),
            }
        )

        return self.__getProxy().delete(
            url=UrlHelper.appendParameters(
                url,
                {'async:matrix':async}
            ),
            headers={"Content-type":None}
        )

class DataCenterNetworkPermissions(Base):

    def __init__(self, network , context):
        Base.__init__(self, context)
        self.parentclass = network

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def add(self, permission):

        '''
        @type Permission:


        @return Permission:
        '''

        url = '/datacenters/{datacenter:id}/networks/{network:id}/permissions'

        result = self.__getProxy().add(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{datacenter:id}': self.parentclass.parentclass.get_id(),
                        '{network:id}': self.parentclass.get_id(),
                    }
                ),
                args={}
            ),
            body=ParseHelper.toXml(permission),
            headers={}
        )

        return DataCenterNetworkPermission(
            self.parentclass,
            result,
            self.context
        )

    def get(self, name=None, id=None):

        '''
        [@param id  : string (the id of the entity)]
        [@param name: string (the name of the entity)]

        @return Permissions:
        '''

        url = '/datacenters/{datacenter:id}/networks/{network:id}/permissions'

        if id:
            try :
                result = self.__getProxy().get(
                    url=UrlHelper.append(
                        UrlHelper.replace(
                            url,
                            {
                                '{datacenter:id}': self.parentclass.parentclass.get_id(),
                                '{network:id}': self.parentclass.get_id(),
                            }
                        ),
                        id
                    ),
                    headers={}
                )

                return DataCenterNetworkPermission(
                    self.parentclass,
                    result,
                    self.context
                )
            except RequestError as err:
                if err.status and err.status == 404:
                    return None
                raise err
        elif name:
            result = self.__getProxy().get(
                url=UrlHelper.replace(
                    url,
                    {
                        '{datacenter:id}': self.parentclass.parentclass.get_id(),
                        '{network:id}': self.parentclass.get_id(),
                    }
                ),
                headers={}
            ).get_permission()

            return DataCenterNetworkPermission(
                self.parentclass,
                FilterHelper.getItem(
                    FilterHelper.filter(
                        result,
                        {'name':name}
                    ),
                    query="name=" + name
                ),
                self.context
            )
        else:
            raise MissingParametersError(['id', 'name'])

    def list(self, max=None, **kwargs):
        '''
        [@param **kwargs: dict (property based filtering)"]
        [@param max: int (max results)]

        @return Permissions:
        '''

        url = '/datacenters/{datacenter:id}/networks/{network:id}/permissions'

        result = self.__getProxy().get(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{datacenter:id}': self.parentclass.parentclass.get_id(),
                        '{network:id}': self.parentclass.get_id(),
                    }
                ),
                args={'max:matrix':max}
            ),
            headers={}
        ).get_permission()

        return ParseHelper.toSubCollection(
            DataCenterNetworkPermission,
            self.parentclass,
            FilterHelper.filter(
                result,
                kwargs
            ),
            context=self.context
        )

class DataCenterNetworkVnicProfile(params.VnicProfile, Base):
    def __init__(self, datacenternetwork, vnicprofile, context):
        Base.__init__(self, context)
        self.parentclass = datacenternetwork
        self.superclass  =  vnicprofile

        self.permissions = DataCenterNetworkVnicProfilePermissions(self, context)

    def __new__(cls, datacenternetwork, vnicprofile, context):
        if vnicprofile is None: return None
        obj = object.__new__(cls)
        obj.__init__(datacenternetwork, vnicprofile, context)
        return obj

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def delete(self, async=None):
        '''
        [@param async: boolean (true|false)]

        @return None:
        '''

        url = UrlHelper.replace(
            '/datacenters/{datacenter:id}/networks/{network:id}/vnicprofiles/{vnicprofile:id}',
            {
                '{datacenter:id}': self.parentclass.parentclass.get_id(),
                '{network:id}': self.parentclass.get_id(),
                '{vnicprofile:id}': self.get_id(),
            }
        )

        return self.__getProxy().delete(
            url=UrlHelper.appendParameters(
                url,
                {'async:matrix':async}
            ),
            headers={"Content-type":None}
        )

class DataCenterNetworkVnicProfilePermission(params.Permission, Base):
    def __init__(self, datacenternetworkvnicprofile, permission, context):
        Base.__init__(self, context)
        self.parentclass = datacenternetworkvnicprofile
        self.superclass  =  permission

        #SUB_COLLECTIONS
    def __new__(cls, datacenternetworkvnicprofile, permission, context):
        if permission is None: return None
        obj = object.__new__(cls)
        obj.__init__(datacenternetworkvnicprofile, permission, context)
        return obj

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def delete(self, async=None):
        '''
        [@param async: boolean (true|false)]

        @return None:
        '''

        url = UrlHelper.replace(
            '/datacenters/{datacenter:id}/networks/{network:id}/vnicprofiles/{vnicprofile:id}/permissions/{permission:id}',
            {
                '{datacenter:id}': self.parentclass.parentclass.parentclass.get_id(),
                '{network:id}': self.parentclass.parentclass.get_id(),
                '{vnicprofile:id}': self.parentclass.get_id(),
                '{permission:id}': self.get_id(),
            }
        )

        return self.__getProxy().delete(
            url=UrlHelper.appendParameters(
                url,
                {'async:matrix':async}
            ),
            headers={"Content-type":None}
        )

class DataCenterNetworkVnicProfilePermissions(Base):

    def __init__(self, vnicprofile , context):
        Base.__init__(self, context)
        self.parentclass = vnicprofile

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def add(self, permission):

        '''
        @type Permission:


        @return Permission:
        '''

        url = '/datacenters/{datacenter:id}/networks/{network:id}/vnicprofiles/{vnicprofile:id}/permissions'

        result = self.__getProxy().add(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{datacenter:id}': self.parentclass.parentclass.parentclass.get_id(),
                        '{network:id}': self.parentclass.parentclass.get_id(),
                        '{vnicprofile:id}': self.parentclass.get_id(),
                    }
                ),
                args={}
            ),
            body=ParseHelper.toXml(permission),
            headers={}
        )

        return DataCenterNetworkVnicProfilePermission(
            self.parentclass,
            result,
            self.context
        )

    def get(self, name=None, id=None):

        '''
        [@param id  : string (the id of the entity)]
        [@param name: string (the name of the entity)]

        @return Permissions:
        '''

        url = '/datacenters/{datacenter:id}/networks/{network:id}/vnicprofiles/{vnicprofile:id}/permissions'

        if id:
            try :
                result = self.__getProxy().get(
                    url=UrlHelper.append(
                        UrlHelper.replace(
                            url,
                            {
                                '{datacenter:id}': self.parentclass.parentclass.parentclass.get_id(),
                                '{network:id}': self.parentclass.parentclass.get_id(),
                                '{vnicprofile:id}': self.parentclass.get_id(),
                            }
                        ),
                        id
                    ),
                    headers={}
                )

                return DataCenterNetworkVnicProfilePermission(
                    self.parentclass,
                    result,
                    self.context
                )
            except RequestError as err:
                if err.status and err.status == 404:
                    return None
                raise err
        elif name:
            result = self.__getProxy().get(
                url=UrlHelper.replace(
                    url,
                    {
                        '{datacenter:id}': self.parentclass.parentclass.parentclass.get_id(),
                        '{network:id}': self.parentclass.parentclass.get_id(),
                        '{vnicprofile:id}': self.parentclass.get_id(),
                    }
                ),
                headers={}
            ).get_permission()

            return DataCenterNetworkVnicProfilePermission(
                self.parentclass,
                FilterHelper.getItem(
                    FilterHelper.filter(
                        result,
                        {'name':name}
                    ),
                    query="name=" + name
                ),
                self.context
            )
        else:
            raise MissingParametersError(['id', 'name'])

    def list(self, max=None, **kwargs):
        '''
        [@param **kwargs: dict (property based filtering)"]
        [@param max: int (max results)]

        @return Permissions:
        '''

        url = '/datacenters/{datacenter:id}/networks/{network:id}/vnicprofiles/{vnicprofile:id}/permissions'

        result = self.__getProxy().get(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{datacenter:id}': self.parentclass.parentclass.parentclass.get_id(),
                        '{network:id}': self.parentclass.parentclass.get_id(),
                        '{vnicprofile:id}': self.parentclass.get_id(),
                    }
                ),
                args={'max:matrix':max}
            ),
            headers={}
        ).get_permission()

        return ParseHelper.toSubCollection(
            DataCenterNetworkVnicProfilePermission,
            self.parentclass,
            FilterHelper.filter(
                result,
                kwargs
            ),
            context=self.context
        )

class DataCenterNetworkVnicProfiles(Base):

    def __init__(self, network , context):
        Base.__init__(self, context)
        self.parentclass = network

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def add(self, vnicprofile):

        '''
        @type VnicProfile:


        @return VnicProfile:
        '''

        url = '/datacenters/{datacenter:id}/networks/{network:id}/vnicprofiles'

        result = self.__getProxy().add(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{datacenter:id}': self.parentclass.parentclass.get_id(),
                        '{network:id}': self.parentclass.get_id(),
                    }
                ),
                args={}
            ),
            body=ParseHelper.toXml(vnicprofile),
            headers={}
        )

        return DataCenterNetworkVnicProfile(
            self.parentclass,
            result,
            self.context
        )

    def get(self, name=None, id=None):

        '''
        [@param id  : string (the id of the entity)]
        [@param name: string (the name of the entity)]

        @return VnicProfiles:
        '''

        url = '/datacenters/{datacenter:id}/networks/{network:id}/vnicprofiles'

        if id:
            try :
                result = self.__getProxy().get(
                    url=UrlHelper.append(
                        UrlHelper.replace(
                            url,
                            {
                                '{datacenter:id}': self.parentclass.parentclass.get_id(),
                                '{network:id}': self.parentclass.get_id(),
                            }
                        ),
                        id
                    ),
                    headers={}
                )

                return DataCenterNetworkVnicProfile(
                    self.parentclass,
                    result,
                    self.context
                )
            except RequestError as err:
                if err.status and err.status == 404:
                    return None
                raise err
        elif name:
            result = self.__getProxy().get(
                url=UrlHelper.replace(
                    url,
                    {
                        '{datacenter:id}': self.parentclass.parentclass.get_id(),
                        '{network:id}': self.parentclass.get_id(),
                    }
                ),
                headers={}
            ).get_vnic_profile()

            return DataCenterNetworkVnicProfile(
                self.parentclass,
                FilterHelper.getItem(
                    FilterHelper.filter(
                        result,
                        {'name':name}
                    ),
                    query="name=" + name
                ),
                self.context
            )
        else:
            raise MissingParametersError(['id', 'name'])

    def list(self, max=None, **kwargs):
        '''
        [@param **kwargs: dict (property based filtering)"]
        [@param max: int (max results)]

        @return VnicProfiles:
        '''

        url = '/datacenters/{datacenter:id}/networks/{network:id}/vnicprofiles'

        result = self.__getProxy().get(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{datacenter:id}': self.parentclass.parentclass.get_id(),
                        '{network:id}': self.parentclass.get_id(),
                    }
                ),
                args={'max:matrix':max}
            ),
            headers={}
        ).get_vnic_profile()

        return ParseHelper.toSubCollection(
            DataCenterNetworkVnicProfile,
            self.parentclass,
            FilterHelper.filter(
                result,
                kwargs
            ),
            context=self.context
        )

class DataCenterNetworks(Base):

    def __init__(self, datacenter , context):
        Base.__init__(self, context)
        self.parentclass = datacenter

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def add(self, network, correlation_id=None, expect=None):

        '''
        @type Network:

        @param network.id|name: string
        [@param network.description: string]
        [@param network.comment: string]
        [@param network.vlan.id: string]
        [@param network.ip.address: string]
        [@param network.ip.gateway: string]
        [@param network.ip.netmask: string]
        [@param network.stp: boolean]
        [@param network.mtu: int]
        [@param network.profile_required: boolean]
        [@param network.usages.usage: collection]
        {
          [@ivar usage: string]
        }
        [@param correlation_id: any string]
        [@param expect: 201-created]

        @return Network:
        '''

        url = '/datacenters/{datacenter:id}/networks'

        result = self.__getProxy().add(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{datacenter:id}': self.parentclass.get_id(),
                    }
                ),
                args={}
            ),
            body=ParseHelper.toXml(network),
            headers={"Correlation-Id":correlation_id, "Expect":expect}
        )

        return DataCenterNetwork(
            self.parentclass,
            result,
            self.context
        )

    def get(self, name=None, id=None):

        '''
        [@param id  : string (the id of the entity)]
        [@param name: string (the name of the entity)]

        @return Networks:
        '''

        url = '/datacenters/{datacenter:id}/networks'

        if id:
            try :
                result = self.__getProxy().get(
                    url=UrlHelper.append(
                        UrlHelper.replace(
                            url,
                            {
                                '{datacenter:id}': self.parentclass.get_id(),
                            }
                        ),
                        id
                    ),
                    headers={}
                )

                return DataCenterNetwork(
                    self.parentclass,
                    result,
                    self.context
                )
            except RequestError as err:
                if err.status and err.status == 404:
                    return None
                raise err
        elif name:
            result = self.__getProxy().get(
                url=UrlHelper.replace(
                    url,
                    {
                        '{datacenter:id}': self.parentclass.get_id(),
                    }
                ),
                headers={}
            ).get_network()

            return DataCenterNetwork(
                self.parentclass,
                FilterHelper.getItem(
                    FilterHelper.filter(
                        result,
                        {'name':name}
                    ),
                    query="name=" + name
                ),
                self.context
            )
        else:
            raise MissingParametersError(['id', 'name'])

    def list(self, max=None, **kwargs):
        '''
        [@param **kwargs: dict (property based filtering)"]
        [@param max: int (max results)]

        @return Networks:
        '''

        url = '/datacenters/{datacenter:id}/networks'

        result = self.__getProxy().get(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{datacenter:id}': self.parentclass.get_id(),
                    }
                ),
                args={'max:matrix':max}
            ),
            headers={}
        ).get_network()

        return ParseHelper.toSubCollection(
            DataCenterNetwork,
            self.parentclass,
            FilterHelper.filter(
                result,
                kwargs
            ),
            context=self.context
        )

class DataCenterPermission(params.Permission, Base):
    def __init__(self, datacenter, permission, context):
        Base.__init__(self, context)
        self.parentclass = datacenter
        self.superclass  =  permission

        #SUB_COLLECTIONS
    def __new__(cls, datacenter, permission, context):
        if permission is None: return None
        obj = object.__new__(cls)
        obj.__init__(datacenter, permission, context)
        return obj

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def delete(self, async=None, correlation_id=None):
        '''
        [@param async: boolean (true|false)]
        [@param correlation_id: any string]

        @return None:
        '''

        url = UrlHelper.replace(
            '/datacenters/{datacenter:id}/permissions/{permission:id}',
            {
                '{datacenter:id}': self.parentclass.get_id(),
                '{permission:id}': self.get_id(),
            }
        )

        return self.__getProxy().delete(
            url=UrlHelper.appendParameters(
                url,
                {'async:matrix':async}
            ),
            headers={"Correlation-Id":correlation_id,"Content-type":None}
        )

class DataCenterPermissions(Base):

    def __init__(self, datacenter , context):
        Base.__init__(self, context)
        self.parentclass = datacenter

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def add(self, permission, correlation_id=None, expect=None):

        '''
        @type Permission:

        Overload 1:
          @param permission.user.id: string
          @param permission.role.id|name: string
        Overload 2:
          @param permission.group.id: string
          @param permission.role.id|name: string
        [@param correlation_id: any string]
        [@param expect: 201-created]

        @return Permission:
        '''

        url = '/datacenters/{datacenter:id}/permissions'

        result = self.__getProxy().add(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{datacenter:id}': self.parentclass.get_id(),
                    }
                ),
                args={}
            ),
            body=ParseHelper.toXml(permission),
            headers={"Correlation-Id":correlation_id, "Expect":expect}
        )

        return DataCenterPermission(
            self.parentclass,
            result,
            self.context
        )

    def get(self, name=None, id=None):

        '''
        [@param id  : string (the id of the entity)]
        [@param name: string (the name of the entity)]

        @return Permissions:
        '''

        url = '/datacenters/{datacenter:id}/permissions'

        if id:
            try :
                result = self.__getProxy().get(
                    url=UrlHelper.append(
                        UrlHelper.replace(
                            url,
                            {
                                '{datacenter:id}': self.parentclass.get_id(),
                            }
                        ),
                        id
                    ),
                    headers={}
                )

                return DataCenterPermission(
                    self.parentclass,
                    result,
                    self.context
                )
            except RequestError as err:
                if err.status and err.status == 404:
                    return None
                raise err
        elif name:
            result = self.__getProxy().get(
                url=UrlHelper.replace(
                    url,
                    {
                        '{datacenter:id}': self.parentclass.get_id(),
                    }
                ),
                headers={}
            ).get_permission()

            return DataCenterPermission(
                self.parentclass,
                FilterHelper.getItem(
                    FilterHelper.filter(
                        result,
                        {'name':name}
                    ),
                    query="name=" + name
                ),
                self.context
            )
        else:
            raise MissingParametersError(['id', 'name'])

    def list(self, max=None, **kwargs):
        '''
        [@param **kwargs: dict (property based filtering)"]
        [@param max: int (max results)]

        @return Permissions:
        '''

        url = '/datacenters/{datacenter:id}/permissions'

        result = self.__getProxy().get(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{datacenter:id}': self.parentclass.get_id(),
                    }
                ),
                args={'max:matrix':max}
            ),
            headers={}
        ).get_permission()

        return ParseHelper.toSubCollection(
            DataCenterPermission,
            self.parentclass,
            FilterHelper.filter(
                result,
                kwargs
            ),
            context=self.context
        )

class DataCenterQoS(params.QoS, Base):
    def __init__(self, datacenter, qos, context):
        Base.__init__(self, context)
        self.parentclass = datacenter
        self.superclass  =  qos

        #SUB_COLLECTIONS
    def __new__(cls, datacenter, qos, context):
        if qos is None: return None
        obj = object.__new__(cls)
        obj.__init__(datacenter, qos, context)
        return obj

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def delete(self, async=None, correlation_id=None):
        '''
        [@param async: boolean (true|false)]
        [@param correlation_id: any string]

        @return None:
        '''

        url = UrlHelper.replace(
            '/datacenters/{datacenter:id}/qoss/{qos:id}',
            {
                '{datacenter:id}': self.parentclass.get_id(),
                '{qos:id}': self.get_id(),
            }
        )

        return self.__getProxy().delete(
            url=UrlHelper.appendParameters(
                url,
                {'async:matrix':async}
            ),
            headers={"Correlation-Id":correlation_id,"Content-type":None}
        )

    def update(self, async=None, correlation_id=None, expect=None):
        '''
        [@param qos.name: string]
        [@param qos.description: string]
        [@param qos.max_throughput: int]
        [@param qos.max_read_throughput: int]
        [@param qos.max_write_throughput: int]
        [@param qos.max_iops: int]
        [@param qos.max_read_iops: int]
        [@param qos.max_write_iops: int]
        [@param qos.cpu_limit: int]
        [@param qos.inbound_average: int]
        [@param qos.inbound_peak: int]
        [@param qos.inbound_burst: int]
        [@param qos.outbound_average: int]
        [@param qos.outbound_peak: int]
        [@param qos.outbound_burst: int]
        [@param qos.outbound_average_linkshare: int]
        [@param qos.outbound_average_upperlimit: int]
        [@param qos.outbound_average_realtime: int]
        [@param async: boolean (true|false)]
        [@param correlation_id: any string]
        [@param expect: 202-accepted]

        @return QoS:
        '''

        url = '/datacenters/{datacenter:id}/qoss/{qos:id}'
        url = UrlHelper.replace(
            url,
            {
                '{datacenter:id}': self.parentclass.get_id(),
                '{qos:id}': self.get_id(),
            }
        )

        result = self.__getProxy().update(
            url=UrlHelper.appendParameters(url, {'async:matrix':async}),
            body=ParseHelper.toXml(self.superclass),
            headers={"Correlation-Id":correlation_id, "Expect":expect}
        )

        return DataCenterQoS(
            self.parentclass,
            result,
            self.context
        )

class DataCenterQoSs(Base):

    def __init__(self, datacenter , context):
        Base.__init__(self, context)
        self.parentclass = datacenter

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def add(self, qos, correlation_id=None, expect=None):

        '''
        @type QoS:

        @param qos.name: string
        @param qos.type: string
        [@param qos.description: string]
        [@param qos.max_throughput: int]
        [@param qos.max_read_throughput: int]
        [@param qos.max_write_throughput: int]
        [@param qos.max_iops: int]
        [@param qos.max_read_iops: int]
        [@param qos.max_write_iops: int]
        [@param qos.cpu_limit: int]
        [@param qos.inbound_average: int]
        [@param qos.inbound_peak: int]
        [@param qos.inbound_burst: int]
        [@param qos.outbound_average: int]
        [@param qos.outbound_peak: int]
        [@param qos.outbound_burst: int]
        [@param qos.outbound_average_linkshare: int]
        [@param qos.outbound_average_upperlimit: int]
        [@param qos.outbound_average_realtime: int]
        [@param correlation_id: any string]
        [@param expect: 201-created]

        @return QoS:
        '''

        url = '/datacenters/{datacenter:id}/qoss'

        result = self.__getProxy().add(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{datacenter:id}': self.parentclass.get_id(),
                    }
                ),
                args={}
            ),
            body=ParseHelper.toXml(qos),
            headers={"Correlation-Id":correlation_id, "Expect":expect}
        )

        return DataCenterQoS(
            self.parentclass,
            result,
            self.context
        )

    def get(self, name=None, id=None):

        '''
        [@param id  : string (the id of the entity)]
        [@param name: string (the name of the entity)]

        @return QoSs:
        '''

        url = '/datacenters/{datacenter:id}/qoss'

        if id:
            try :
                result = self.__getProxy().get(
                    url=UrlHelper.append(
                        UrlHelper.replace(
                            url,
                            {
                                '{datacenter:id}': self.parentclass.get_id(),
                            }
                        ),
                        id
                    ),
                    headers={}
                )

                return DataCenterQoS(
                    self.parentclass,
                    result,
                    self.context
                )
            except RequestError as err:
                if err.status and err.status == 404:
                    return None
                raise err
        elif name:
            result = self.__getProxy().get(
                url=UrlHelper.replace(
                    url,
                    {
                        '{datacenter:id}': self.parentclass.get_id(),
                    }
                ),
                headers={}
            ).get_qos()

            return DataCenterQoS(
                self.parentclass,
                FilterHelper.getItem(
                    FilterHelper.filter(
                        result,
                        {'name':name}
                    ),
                    query="name=" + name
                ),
                self.context
            )
        else:
            raise MissingParametersError(['id', 'name'])

    def list(self, max=None, **kwargs):
        '''
        [@param **kwargs: dict (property based filtering)"]
        [@param max: int (max results)]

        @return QoSs:
        '''

        url = '/datacenters/{datacenter:id}/qoss'

        result = self.__getProxy().get(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{datacenter:id}': self.parentclass.get_id(),
                    }
                ),
                args={'max:matrix':max}
            ),
            headers={}
        ).get_qos()

        return ParseHelper.toSubCollection(
            DataCenterQoS,
            self.parentclass,
            FilterHelper.filter(
                result,
                kwargs
            ),
            context=self.context
        )

class DataCenterQuota(params.Quota, Base):
    def __init__(self, datacenter, quota, context):
        Base.__init__(self, context)
        self.parentclass = datacenter
        self.superclass  =  quota

        self.permissions = DataCenterQuotaPermissions(self, context)
        self.quotaclusterlimits = DataCenterQuotaQuotaClusterLimits(self, context)
        self.quotastoragelimits = DataCenterQuotaQuotaStorageLimits(self, context)

    def __new__(cls, datacenter, quota, context):
        if quota is None: return None
        obj = object.__new__(cls)
        obj.__init__(datacenter, quota, context)
        return obj

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def delete(self, async=None, correlation_id=None):
        '''
        [@param async: boolean (true|false)]
        [@param correlation_id: any string]

        @return None:
        '''

        url = UrlHelper.replace(
            '/datacenters/{datacenter:id}/quotas/{quota:id}',
            {
                '{datacenter:id}': self.parentclass.get_id(),
                '{quota:id}': self.get_id(),
            }
        )

        return self.__getProxy().delete(
            url=UrlHelper.appendParameters(
                url,
                {'async:matrix':async}
            ),
            headers={"Correlation-Id":correlation_id,"Content-type":None}
        )

    def update(self, async=None, correlation_id=None, expect=None):
        '''
        [@param quota.name: string]
        [@param quota.description: string]
        [@param quota.cluster_soft_limit_pct: int]
        [@param quota.cluster_hard_limit_pct: int]
        [@param quota.storage_soft_limit_pct: int]
        [@param quota.storage_hard_limit_pct: int]
        [@param async: boolean (true|false)]
        [@param correlation_id: any string]
        [@param expect: 202-accepted]

        @return Quota:
        '''

        url = '/datacenters/{datacenter:id}/quotas/{quota:id}'
        url = UrlHelper.replace(
            url,
            {
                '{datacenter:id}': self.parentclass.get_id(),
                '{quota:id}': self.get_id(),
            }
        )

        result = self.__getProxy().update(
            url=UrlHelper.appendParameters(url, {'async:matrix':async}),
            body=ParseHelper.toXml(self.superclass),
            headers={"Correlation-Id":correlation_id, "Expect":expect}
        )

        return DataCenterQuota(
            self.parentclass,
            result,
            self.context
        )

class DataCenterQuotaPermission(params.Permission, Base):
    def __init__(self, datacenterquota, permission, context):
        Base.__init__(self, context)
        self.parentclass = datacenterquota
        self.superclass  =  permission

        #SUB_COLLECTIONS
    def __new__(cls, datacenterquota, permission, context):
        if permission is None: return None
        obj = object.__new__(cls)
        obj.__init__(datacenterquota, permission, context)
        return obj

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def delete(self, async=None):
        '''
        [@param async: boolean (true|false)]

        @return None:
        '''

        url = UrlHelper.replace(
            '/datacenters/{datacenter:id}/quotas/{quota:id}/permissions/{permission:id}',
            {
                '{datacenter:id}': self.parentclass.parentclass.get_id(),
                '{quota:id}': self.parentclass.get_id(),
                '{permission:id}': self.get_id(),
            }
        )

        return self.__getProxy().delete(
            url=UrlHelper.appendParameters(
                url,
                {'async:matrix':async}
            ),
            headers={"Content-type":None}
        )

class DataCenterQuotaPermissions(Base):

    def __init__(self, quota , context):
        Base.__init__(self, context)
        self.parentclass = quota

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def add(self, permission):

        '''
        @type Permission:


        @return Permission:
        '''

        url = '/datacenters/{datacenter:id}/quotas/{quota:id}/permissions'

        result = self.__getProxy().add(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{datacenter:id}': self.parentclass.parentclass.get_id(),
                        '{quota:id}': self.parentclass.get_id(),
                    }
                ),
                args={}
            ),
            body=ParseHelper.toXml(permission),
            headers={}
        )

        return DataCenterQuotaPermission(
            self.parentclass,
            result,
            self.context
        )

    def get(self, name=None, id=None):

        '''
        [@param id  : string (the id of the entity)]
        [@param name: string (the name of the entity)]

        @return Permissions:
        '''

        url = '/datacenters/{datacenter:id}/quotas/{quota:id}/permissions'

        if id:
            try :
                result = self.__getProxy().get(
                    url=UrlHelper.append(
                        UrlHelper.replace(
                            url,
                            {
                                '{datacenter:id}': self.parentclass.parentclass.get_id(),
                                '{quota:id}': self.parentclass.get_id(),
                            }
                        ),
                        id
                    ),
                    headers={}
                )

                return DataCenterQuotaPermission(
                    self.parentclass,
                    result,
                    self.context
                )
            except RequestError as err:
                if err.status and err.status == 404:
                    return None
                raise err
        elif name:
            result = self.__getProxy().get(
                url=UrlHelper.replace(
                    url,
                    {
                        '{datacenter:id}': self.parentclass.parentclass.get_id(),
                        '{quota:id}': self.parentclass.get_id(),
                    }
                ),
                headers={}
            ).get_permission()

            return DataCenterQuotaPermission(
                self.parentclass,
                FilterHelper.getItem(
                    FilterHelper.filter(
                        result,
                        {'name':name}
                    ),
                    query="name=" + name
                ),
                self.context
            )
        else:
            raise MissingParametersError(['id', 'name'])

    def list(self, max=None, **kwargs):
        '''
        [@param **kwargs: dict (property based filtering)"]
        [@param max: int (max results)]

        @return Permissions:
        '''

        url = '/datacenters/{datacenter:id}/quotas/{quota:id}/permissions'

        result = self.__getProxy().get(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{datacenter:id}': self.parentclass.parentclass.get_id(),
                        '{quota:id}': self.parentclass.get_id(),
                    }
                ),
                args={'max:matrix':max}
            ),
            headers={}
        ).get_permission()

        return ParseHelper.toSubCollection(
            DataCenterQuotaPermission,
            self.parentclass,
            FilterHelper.filter(
                result,
                kwargs
            ),
            context=self.context
        )

class DataCenterQuotaQuotaClusterLimit(params.QuotaClusterLimit, Base):
    def __init__(self, datacenterquota, quotaclusterlimit, context):
        Base.__init__(self, context)
        self.parentclass = datacenterquota
        self.superclass  =  quotaclusterlimit

        #SUB_COLLECTIONS
    def __new__(cls, datacenterquota, quotaclusterlimit, context):
        if quotaclusterlimit is None: return None
        obj = object.__new__(cls)
        obj.__init__(datacenterquota, quotaclusterlimit, context)
        return obj

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def delete(self, async=None):
        '''
        [@param async: boolean (true|false)]

        @return None:
        '''

        url = UrlHelper.replace(
            '/datacenters/{datacenter:id}/quotas/{quota:id}/quotaclusterlimits/{quotaclusterlimit:id}',
            {
                '{datacenter:id}': self.parentclass.parentclass.get_id(),
                '{quota:id}': self.parentclass.get_id(),
                '{quotaclusterlimit:id}': self.get_id(),
            }
        )

        return self.__getProxy().delete(
            url=UrlHelper.appendParameters(
                url,
                {'async:matrix':async}
            ),
            headers={"Content-type":None}
        )

class DataCenterQuotaQuotaClusterLimits(Base):

    def __init__(self, quota , context):
        Base.__init__(self, context)
        self.parentclass = quota

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def add(self, clusterquotalimit):

        '''
        @type QuotaClusterLimit:


        @return QuotaClusterLimit:
        '''

        url = '/datacenters/{datacenter:id}/quotas/{quota:id}/quotaclusterlimits'

        result = self.__getProxy().add(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{datacenter:id}': self.parentclass.parentclass.get_id(),
                        '{quota:id}': self.parentclass.get_id(),
                    }
                ),
                args={}
            ),
            body=ParseHelper.toXml(clusterquotalimit),
            headers={}
        )

        return DataCenterQuotaQuotaClusterLimit(
            self.parentclass,
            result,
            self.context
        )

    def get(self, name=None, id=None):

        '''
        [@param id  : string (the id of the entity)]
        [@param name: string (the name of the entity)]

        @return QuotaClusterLimits:
        '''

        url = '/datacenters/{datacenter:id}/quotas/{quota:id}/quotaclusterlimits'

        if id:
            try :
                result = self.__getProxy().get(
                    url=UrlHelper.append(
                        UrlHelper.replace(
                            url,
                            {
                                '{datacenter:id}': self.parentclass.parentclass.get_id(),
                                '{quota:id}': self.parentclass.get_id(),
                            }
                        ),
                        id
                    ),
                    headers={}
                )

                return DataCenterQuotaQuotaClusterLimit(
                    self.parentclass,
                    result,
                    self.context
                )
            except RequestError as err:
                if err.status and err.status == 404:
                    return None
                raise err
        elif name:
            result = self.__getProxy().get(
                url=UrlHelper.replace(
                    url,
                    {
                        '{datacenter:id}': self.parentclass.parentclass.get_id(),
                        '{quota:id}': self.parentclass.get_id(),
                    }
                ),
                headers={}
            ).get_cluster_quota_limit()

            return DataCenterQuotaQuotaClusterLimit(
                self.parentclass,
                FilterHelper.getItem(
                    FilterHelper.filter(
                        result,
                        {'name':name}
                    ),
                    query="name=" + name
                ),
                self.context
            )
        else:
            raise MissingParametersError(['id', 'name'])

    def list(self, max=None, **kwargs):
        '''
        [@param **kwargs: dict (property based filtering)"]
        [@param max: int (max results)]

        @return QuotaClusterLimits:
        '''

        url = '/datacenters/{datacenter:id}/quotas/{quota:id}/quotaclusterlimits'

        result = self.__getProxy().get(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{datacenter:id}': self.parentclass.parentclass.get_id(),
                        '{quota:id}': self.parentclass.get_id(),
                    }
                ),
                args={'max:matrix':max}
            ),
            headers={}
        ).get_cluster_quota_limit()

        return ParseHelper.toSubCollection(
            DataCenterQuotaQuotaClusterLimit,
            self.parentclass,
            FilterHelper.filter(
                result,
                kwargs
            ),
            context=self.context
        )

class DataCenterQuotaQuotaStorageLimit(params.QuotaStorageLimit, Base):
    def __init__(self, datacenterquota, quotastoragelimit, context):
        Base.__init__(self, context)
        self.parentclass = datacenterquota
        self.superclass  =  quotastoragelimit

        #SUB_COLLECTIONS
    def __new__(cls, datacenterquota, quotastoragelimit, context):
        if quotastoragelimit is None: return None
        obj = object.__new__(cls)
        obj.__init__(datacenterquota, quotastoragelimit, context)
        return obj

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def delete(self, async=None):
        '''
        [@param async: boolean (true|false)]

        @return None:
        '''

        url = UrlHelper.replace(
            '/datacenters/{datacenter:id}/quotas/{quota:id}/quotastoragelimits/{quotastoragelimit:id}',
            {
                '{datacenter:id}': self.parentclass.parentclass.get_id(),
                '{quota:id}': self.parentclass.get_id(),
                '{quotastoragelimit:id}': self.get_id(),
            }
        )

        return self.__getProxy().delete(
            url=UrlHelper.appendParameters(
                url,
                {'async:matrix':async}
            ),
            headers={"Content-type":None}
        )

class DataCenterQuotaQuotaStorageLimits(Base):

    def __init__(self, quota , context):
        Base.__init__(self, context)
        self.parentclass = quota

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def add(self, storagequotalimit):

        '''
        @type QuotaStorageLimit:


        @return QuotaStorageLimit:
        '''

        url = '/datacenters/{datacenter:id}/quotas/{quota:id}/quotastoragelimits'

        result = self.__getProxy().add(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{datacenter:id}': self.parentclass.parentclass.get_id(),
                        '{quota:id}': self.parentclass.get_id(),
                    }
                ),
                args={}
            ),
            body=ParseHelper.toXml(storagequotalimit),
            headers={}
        )

        return DataCenterQuotaQuotaStorageLimit(
            self.parentclass,
            result,
            self.context
        )

    def get(self, name=None, id=None):

        '''
        [@param id  : string (the id of the entity)]
        [@param name: string (the name of the entity)]

        @return QuotaStorageLimits:
        '''

        url = '/datacenters/{datacenter:id}/quotas/{quota:id}/quotastoragelimits'

        if id:
            try :
                result = self.__getProxy().get(
                    url=UrlHelper.append(
                        UrlHelper.replace(
                            url,
                            {
                                '{datacenter:id}': self.parentclass.parentclass.get_id(),
                                '{quota:id}': self.parentclass.get_id(),
                            }
                        ),
                        id
                    ),
                    headers={}
                )

                return DataCenterQuotaQuotaStorageLimit(
                    self.parentclass,
                    result,
                    self.context
                )
            except RequestError as err:
                if err.status and err.status == 404:
                    return None
                raise err
        elif name:
            result = self.__getProxy().get(
                url=UrlHelper.replace(
                    url,
                    {
                        '{datacenter:id}': self.parentclass.parentclass.get_id(),
                        '{quota:id}': self.parentclass.get_id(),
                    }
                ),
                headers={}
            ).get_storage_quota_limit()

            return DataCenterQuotaQuotaStorageLimit(
                self.parentclass,
                FilterHelper.getItem(
                    FilterHelper.filter(
                        result,
                        {'name':name}
                    ),
                    query="name=" + name
                ),
                self.context
            )
        else:
            raise MissingParametersError(['id', 'name'])

    def list(self, max=None, **kwargs):
        '''
        [@param **kwargs: dict (property based filtering)"]
        [@param max: int (max results)]

        @return QuotaStorageLimits:
        '''

        url = '/datacenters/{datacenter:id}/quotas/{quota:id}/quotastoragelimits'

        result = self.__getProxy().get(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{datacenter:id}': self.parentclass.parentclass.get_id(),
                        '{quota:id}': self.parentclass.get_id(),
                    }
                ),
                args={'max:matrix':max}
            ),
            headers={}
        ).get_storage_quota_limit()

        return ParseHelper.toSubCollection(
            DataCenterQuotaQuotaStorageLimit,
            self.parentclass,
            FilterHelper.filter(
                result,
                kwargs
            ),
            context=self.context
        )

class DataCenterQuotas(Base):

    def __init__(self, datacenter , context):
        Base.__init__(self, context)
        self.parentclass = datacenter

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def add(self, quota, correlation_id=None, expect=None):

        '''
        @type Quota:

        @param quota.name: string
        [@param quota.description: string]
        [@param quota.cluster_soft_limit_pct: int]
        [@param quota.cluster_hard_limit_pct: int]
        [@param quota.storage_soft_limit_pct: int]
        [@param quota.storage_hard_limit_pct: int]
        [@param correlation_id: any string]
        [@param expect: 201-created]

        @return Quota:
        '''

        url = '/datacenters/{datacenter:id}/quotas'

        result = self.__getProxy().add(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{datacenter:id}': self.parentclass.get_id(),
                    }
                ),
                args={}
            ),
            body=ParseHelper.toXml(quota),
            headers={"Correlation-Id":correlation_id, "Expect":expect}
        )

        return DataCenterQuota(
            self.parentclass,
            result,
            self.context
        )

    def get(self, name=None, id=None):

        '''
        [@param id  : string (the id of the entity)]
        [@param name: string (the name of the entity)]

        @return Quotas:
        '''

        url = '/datacenters/{datacenter:id}/quotas'

        if id:
            try :
                result = self.__getProxy().get(
                    url=UrlHelper.append(
                        UrlHelper.replace(
                            url,
                            {
                                '{datacenter:id}': self.parentclass.get_id(),
                            }
                        ),
                        id
                    ),
                    headers={}
                )

                return DataCenterQuota(
                    self.parentclass,
                    result,
                    self.context
                )
            except RequestError as err:
                if err.status and err.status == 404:
                    return None
                raise err
        elif name:
            result = self.__getProxy().get(
                url=UrlHelper.replace(
                    url,
                    {
                        '{datacenter:id}': self.parentclass.get_id(),
                    }
                ),
                headers={}
            ).get_quota()

            return DataCenterQuota(
                self.parentclass,
                FilterHelper.getItem(
                    FilterHelper.filter(
                        result,
                        {'name':name}
                    ),
                    query="name=" + name
                ),
                self.context
            )
        else:
            raise MissingParametersError(['id', 'name'])

    def list(self, max=None, **kwargs):
        '''
        [@param **kwargs: dict (property based filtering)"]
        [@param max: int (max results)]

        @return Quotas:
        '''

        url = '/datacenters/{datacenter:id}/quotas'

        result = self.__getProxy().get(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{datacenter:id}': self.parentclass.get_id(),
                    }
                ),
                args={'max:matrix':max}
            ),
            headers={}
        ).get_quota()

        return ParseHelper.toSubCollection(
            DataCenterQuota,
            self.parentclass,
            FilterHelper.filter(
                result,
                kwargs
            ),
            context=self.context
        )

class DataCenterStorageDomain(params.StorageDomain, Base):
    def __init__(self, datacenter, storagedomain, context):
        Base.__init__(self, context)
        self.parentclass = datacenter
        self.superclass  =  storagedomain

        self.disks = DataCenterStorageDomainDisks(self, context)

    def __new__(cls, datacenter, storagedomain, context):
        if storagedomain is None: return None
        obj = object.__new__(cls)
        obj.__init__(datacenter, storagedomain, context)
        return obj

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def delete(self, async=None, correlation_id=None):
        '''
        [@param async: boolean (true|false)]
        [@param correlation_id: any string]

        @return None:
        '''

        url = UrlHelper.replace(
            '/datacenters/{datacenter:id}/storagedomains/{storagedomain:id}',
            {
                '{datacenter:id}': self.parentclass.get_id(),
                '{storagedomain:id}': self.get_id(),
            }
        )

        return self.__getProxy().delete(
            url=UrlHelper.appendParameters(
                url,
                {'async:matrix':async}
            ),
            headers={"Correlation-Id":correlation_id,"Content-type":None}
        )

    def activate(self, action=params.Action(), correlation_id=None):
        '''
        @type Action:

        [@param action.async: boolean]
        [@param action.grace_period.expiry: long]
        [@param correlation_id: any string]

        @return Action:
        '''

        url = '/datacenters/{datacenter:id}/storagedomains/{storagedomain:id}/activate'

        result = self.__getProxy().request(
            method='POST',
            url=UrlHelper.replace(
                url,
                {
                    '{datacenter:id}': self.parentclass.get_id(),
                    '{storagedomain:id}': self.get_id(),
                }
            ),
            body=ParseHelper.toXml(action),
            headers={"Correlation-Id":correlation_id}
        )

        return result

    def deactivate(self, action=params.Action(), correlation_id=None):
        '''
        @type Action:

        [@param action.async: boolean]
        [@param action.grace_period.expiry: long]
        [@param correlation_id: any string]

        @return Action:
        '''

        url = '/datacenters/{datacenter:id}/storagedomains/{storagedomain:id}/deactivate'

        result = self.__getProxy().request(
            method='POST',
            url=UrlHelper.replace(
                url,
                {
                    '{datacenter:id}': self.parentclass.get_id(),
                    '{storagedomain:id}': self.get_id(),
                }
            ),
            body=ParseHelper.toXml(action),
            headers={"Correlation-Id":correlation_id}
        )

        return result

class DataCenterStorageDomainDisk(params.Disk, Base):
    def __init__(self, datacenterstoragedomain, disk, context):
        Base.__init__(self, context)
        self.parentclass = datacenterstoragedomain
        self.superclass  =  disk

        self.permissions = DataCenterStorageDomainDiskPermissions(self, context)
        self.statistics = DataCenterStorageDomainDiskStatistics(self, context)

    def __new__(cls, datacenterstoragedomain, disk, context):
        if disk is None: return None
        obj = object.__new__(cls)
        obj.__init__(datacenterstoragedomain, disk, context)
        return obj

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def delete(self, async=None, correlation_id=None):
        '''
        [@param async: boolean (true|false)]
        [@param correlation_id: any string]

        @return None:
        '''

        url = UrlHelper.replace(
            '/datacenters/{datacenter:id}/storagedomains/{storagedomain:id}/disks/{disk:id}',
            {
                '{datacenter:id}': self.parentclass.parentclass.get_id(),
                '{storagedomain:id}': self.parentclass.get_id(),
                '{disk:id}': self.get_id(),
            }
        )

        return self.__getProxy().delete(
            url=UrlHelper.appendParameters(
                url,
                {'async:matrix':async}
            ),
            headers={"Correlation-Id":correlation_id,"Content-type":None}
        )

    def copy(self, action=params.Action()):
        '''
        @type Action:


        @return Action:
        '''

        url = '/datacenters/{datacenter:id}/storagedomains/{storagedomain:id}/disks/{disk:id}/copy'

        result = self.__getProxy().request(
            method='POST',
            url=UrlHelper.replace(
                url,
                {
                    '{datacenter:id}': self.parentclass.parentclass.get_id(),
                    '{storagedomain:id}': self.parentclass.get_id(),
                    '{disk:id}': self.get_id(),
                }
            ),
            body=ParseHelper.toXml(action),
            headers={}
        )

        return result

    def export(self, action=params.Action(), correlation_id=None):
        '''
        @type Action:

        @param storagedomain.id|name: string
        [@param action.async: boolean]
        [@param action.grace_period.expiry: long]
        [@param correlation_id: any string]

        @return Action:
        '''

        url = '/datacenters/{datacenter:id}/storagedomains/{storagedomain:id}/disks/{disk:id}/export'

        result = self.__getProxy().request(
            method='POST',
            url=UrlHelper.replace(
                url,
                {
                    '{datacenter:id}': self.parentclass.parentclass.get_id(),
                    '{storagedomain:id}': self.parentclass.get_id(),
                    '{disk:id}': self.get_id(),
                }
            ),
            body=ParseHelper.toXml(action),
            headers={"Correlation-Id":correlation_id}
        )

        return result

    def move(self, action=params.Action()):
        '''
        @type Action:


        @return Action:
        '''

        url = '/datacenters/{datacenter:id}/storagedomains/{storagedomain:id}/disks/{disk:id}/move'

        result = self.__getProxy().request(
            method='POST',
            url=UrlHelper.replace(
                url,
                {
                    '{datacenter:id}': self.parentclass.parentclass.get_id(),
                    '{storagedomain:id}': self.parentclass.get_id(),
                    '{disk:id}': self.get_id(),
                }
            ),
            body=ParseHelper.toXml(action),
            headers={}
        )

        return result

class DataCenterStorageDomainDiskPermission(params.Permission, Base):
    def __init__(self, datacenterstoragedomaindisk, permission, context):
        Base.__init__(self, context)
        self.parentclass = datacenterstoragedomaindisk
        self.superclass  =  permission

        #SUB_COLLECTIONS
    def __new__(cls, datacenterstoragedomaindisk, permission, context):
        if permission is None: return None
        obj = object.__new__(cls)
        obj.__init__(datacenterstoragedomaindisk, permission, context)
        return obj

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def delete(self, async=None):
        '''
        [@param async: boolean (true|false)]

        @return None:
        '''

        url = UrlHelper.replace(
            '/datacenters/{datacenter:id}/storagedomains/{storagedomain:id}/disks/{disk:id}/permissions/{permission:id}',
            {
                '{datacenter:id}': self.parentclass.parentclass.parentclass.get_id(),
                '{storagedomain:id}': self.parentclass.parentclass.get_id(),
                '{disk:id}': self.parentclass.get_id(),
                '{permission:id}': self.get_id(),
            }
        )

        return self.__getProxy().delete(
            url=UrlHelper.appendParameters(
                url,
                {'async:matrix':async}
            ),
            headers={"Content-type":None}
        )

class DataCenterStorageDomainDiskPermissions(Base):

    def __init__(self, disk , context):
        Base.__init__(self, context)
        self.parentclass = disk

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def add(self, permission):

        '''
        @type Permission:


        @return Permission:
        '''

        url = '/datacenters/{datacenter:id}/storagedomains/{storagedomain:id}/disks/{disk:id}/permissions'

        result = self.__getProxy().add(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{datacenter:id}': self.parentclass.parentclass.parentclass.get_id(),
                        '{storagedomain:id}': self.parentclass.parentclass.get_id(),
                        '{disk:id}': self.parentclass.get_id(),
                    }
                ),
                args={}
            ),
            body=ParseHelper.toXml(permission),
            headers={}
        )

        return DataCenterStorageDomainDiskPermission(
            self.parentclass,
            result,
            self.context
        )

    def get(self, name=None, id=None):

        '''
        [@param id  : string (the id of the entity)]
        [@param name: string (the name of the entity)]

        @return Permissions:
        '''

        url = '/datacenters/{datacenter:id}/storagedomains/{storagedomain:id}/disks/{disk:id}/permissions'

        if id:
            try :
                result = self.__getProxy().get(
                    url=UrlHelper.append(
                        UrlHelper.replace(
                            url,
                            {
                                '{datacenter:id}': self.parentclass.parentclass.parentclass.get_id(),
                                '{storagedomain:id}': self.parentclass.parentclass.get_id(),
                                '{disk:id}': self.parentclass.get_id(),
                            }
                        ),
                        id
                    ),
                    headers={}
                )

                return DataCenterStorageDomainDiskPermission(
                    self.parentclass,
                    result,
                    self.context
                )
            except RequestError as err:
                if err.status and err.status == 404:
                    return None
                raise err
        elif name:
            result = self.__getProxy().get(
                url=UrlHelper.replace(
                    url,
                    {
                        '{datacenter:id}': self.parentclass.parentclass.parentclass.get_id(),
                        '{storagedomain:id}': self.parentclass.parentclass.get_id(),
                        '{disk:id}': self.parentclass.get_id(),
                    }
                ),
                headers={}
            ).get_permission()

            return DataCenterStorageDomainDiskPermission(
                self.parentclass,
                FilterHelper.getItem(
                    FilterHelper.filter(
                        result,
                        {'name':name}
                    ),
                    query="name=" + name
                ),
                self.context
            )
        else:
            raise MissingParametersError(['id', 'name'])

    def list(self, max=None, **kwargs):
        '''
        [@param **kwargs: dict (property based filtering)"]
        [@param max: int (max results)]

        @return Permissions:
        '''

        url = '/datacenters/{datacenter:id}/storagedomains/{storagedomain:id}/disks/{disk:id}/permissions'

        result = self.__getProxy().get(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{datacenter:id}': self.parentclass.parentclass.parentclass.get_id(),
                        '{storagedomain:id}': self.parentclass.parentclass.get_id(),
                        '{disk:id}': self.parentclass.get_id(),
                    }
                ),
                args={'max:matrix':max}
            ),
            headers={}
        ).get_permission()

        return ParseHelper.toSubCollection(
            DataCenterStorageDomainDiskPermission,
            self.parentclass,
            FilterHelper.filter(
                result,
                kwargs
            ),
            context=self.context
        )

class DataCenterStorageDomainDiskStatistic(params.Statistic, Base):
    def __init__(self, datacenterstoragedomaindisk, statistic, context):
        Base.__init__(self, context)
        self.parentclass = datacenterstoragedomaindisk
        self.superclass  =  statistic

        #SUB_COLLECTIONS
    def __new__(cls, datacenterstoragedomaindisk, statistic, context):
        if statistic is None: return None
        obj = object.__new__(cls)
        obj.__init__(datacenterstoragedomaindisk, statistic, context)
        return obj

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

class DataCenterStorageDomainDiskStatistics(Base):

    def __init__(self, disk , context):
        Base.__init__(self, context)
        self.parentclass = disk

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def get(self, name=None, id=None):

        '''
        [@param id  : string (the id of the entity)]
        [@param name: string (the name of the entity)]

        @return Statistics:
        '''

        url = '/datacenters/{datacenter:id}/storagedomains/{storagedomain:id}/disks/{disk:id}/statistics'

        if id:
            try :
                result = self.__getProxy().get(
                    url=UrlHelper.append(
                        UrlHelper.replace(
                            url,
                            {
                                '{datacenter:id}': self.parentclass.parentclass.parentclass.get_id(),
                                '{storagedomain:id}': self.parentclass.parentclass.get_id(),
                                '{disk:id}': self.parentclass.get_id(),
                            }
                        ),
                        id
                    ),
                    headers={}
                )

                return DataCenterStorageDomainDiskStatistic(
                    self.parentclass,
                    result,
                    self.context
                )
            except RequestError as err:
                if err.status and err.status == 404:
                    return None
                raise err
        elif name:
            result = self.__getProxy().get(
                url=UrlHelper.replace(
                    url,
                    {
                        '{datacenter:id}': self.parentclass.parentclass.parentclass.get_id(),
                        '{storagedomain:id}': self.parentclass.parentclass.get_id(),
                        '{disk:id}': self.parentclass.get_id(),
                    }
                ),
                headers={}
            ).get_statistic()

            return DataCenterStorageDomainDiskStatistic(
                self.parentclass,
                FilterHelper.getItem(
                    FilterHelper.filter(
                        result,
                        {'name':name}
                    ),
                    query="name=" + name
                ),
                self.context
            )
        else:
            raise MissingParametersError(['id', 'name'])

    def list(self, **kwargs):
        '''
        [@param **kwargs: dict (property based filtering)"]

        @return Statistics:
        '''

        url = '/datacenters/{datacenter:id}/storagedomains/{storagedomain:id}/disks/{disk:id}/statistics'

        result = self.__getProxy().get(
            url=UrlHelper.replace(
                url,
                {
                    '{datacenter:id}': self.parentclass.parentclass.parentclass.get_id(),
                    '{storagedomain:id}': self.parentclass.parentclass.get_id(),
                    '{disk:id}': self.parentclass.get_id(),
                }
            )
        ).get_statistic()

        return ParseHelper.toSubCollection(
            DataCenterStorageDomainDiskStatistic,
            self.parentclass,
            FilterHelper.filter(
                result,
                kwargs
            ),
            context=self.context
        )

class DataCenterStorageDomainDisks(Base):

    def __init__(self, storagedomain , context):
        Base.__init__(self, context)
        self.parentclass = storagedomain

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def add(self, disk, correlation_id=None, expect=None, unregistered=None):

        '''
        @type Disk:

        Overload 1:
          @param disk.format: string
          @param disk.interface: string
          @param disk.provisioned_size: int
          [@param disk.alias: string]
          [@param disk.name: string]
          [@param disk.size: int]
          [@param disk.sparse: boolean]
          [@param disk.description: string]
          [@param disk.bootable: boolean]
          [@param disk.shareable: boolean]
          [@param disk.propagate_errors: boolean]
          [@param disk.wipe_after_delete: boolean]
          [@param disk.quota.id: string]
          [@param disk.disk_profile.id: string]
          [@param disk.openstack_volume_type.name: string]
        Overload 2:
          @param disk.interface: string
          @param disk.format: string
          @param disk.lun_storage.type: string
          @param disk.lun_storage.logical_unit: collection
          {
            @ivar logical_unit.id: string
            @ivar logical_unit.address: string
            @ivar logical_unit.port: int
            @ivar logical_unit.target: string
          }
          [@param disk.alias: string]
          [@param disk.sparse: boolean]
          [@param disk.description: string]
          [@param disk.bootable: boolean]
          [@param disk.shareable: boolean]
          [@param disk.propagate_errors: boolean]
          [@param disk.wipe_after_delete: boolean]
          [@param disk.quota.id: string]
          [@param disk.sgio: string]
        [@param unregistered: boolean (true|false)]
        [@param correlation_id: any string]
        [@param expect: 201-created]

        @return Disk:
        '''

        url = '/datacenters/{datacenter:id}/storagedomains/{storagedomain:id}/disks'

        result = self.__getProxy().add(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{datacenter:id}': self.parentclass.parentclass.get_id(),
                        '{storagedomain:id}': self.parentclass.get_id(),
                    }
                ),
                args={'unregistered:matrix':unregistered}
            ),
            body=ParseHelper.toXml(disk),
            headers={"Correlation-Id":correlation_id, "Expect":expect}
        )

        return DataCenterStorageDomainDisk(
            self.parentclass,
            result,
            self.context
        )

    def get(self, name=None, id=None):

        '''
        [@param id  : string (the id of the entity)]
        [@param name: string (the name of the entity)]

        @return Disks:
        '''

        url = '/datacenters/{datacenter:id}/storagedomains/{storagedomain:id}/disks'

        if id:
            try :
                result = self.__getProxy().get(
                    url=UrlHelper.append(
                        UrlHelper.replace(
                            url,
                            {
                                '{datacenter:id}': self.parentclass.parentclass.get_id(),
                                '{storagedomain:id}': self.parentclass.get_id(),
                            }
                        ),
                        id
                    ),
                    headers={}
                )

                return DataCenterStorageDomainDisk(
                    self.parentclass,
                    result,
                    self.context
                )
            except RequestError as err:
                if err.status and err.status == 404:
                    return None
                raise err
        elif name:
            result = self.__getProxy().get(
                url=UrlHelper.replace(
                    url,
                    {
                        '{datacenter:id}': self.parentclass.parentclass.get_id(),
                        '{storagedomain:id}': self.parentclass.get_id(),
                    }
                ),
                headers={}
            ).get_disk()

            return DataCenterStorageDomainDisk(
                self.parentclass,
                FilterHelper.getItem(
                    FilterHelper.filter(
                        result,
                        {'name':name}
                    ),
                    query="name=" + name
                ),
                self.context
            )
        else:
            raise MissingParametersError(['id', 'name'])

    def list(self, query=None, case_sensitive=True, unregistered=None, max=None, **kwargs):
        '''
        [@param **kwargs: dict (property based filtering)"]
        [@param query: string (oVirt engine search dialect query)]
        [@param case_sensitive: boolean (true|false)]
        [@param unregistered: boolean (true|false)]
        [@param max: int (max results)]

        @return Disks:
        '''

        url = '/datacenters/{datacenter:id}/storagedomains/{storagedomain:id}/disks'

        result = self.__getProxy().get(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{datacenter:id}': self.parentclass.parentclass.get_id(),
                        '{storagedomain:id}': self.parentclass.get_id(),
                    }
                ),
                args={'search:query':query,'case_sensitive:matrix':case_sensitive,'unregistered:matrix':unregistered,'max:matrix':max}
            ),
            headers={}
        ).get_disk()

        return ParseHelper.toSubCollection(
            DataCenterStorageDomainDisk,
            self.parentclass,
            FilterHelper.filter(
                result,
                kwargs
            ),
            context=self.context
        )

class DataCenterStorageDomains(Base):

    def __init__(self, datacenter , context):
        Base.__init__(self, context)
        self.parentclass = datacenter

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def add(self, storagedomain, correlation_id=None, expect=None):

        '''
        @type StorageDomain:

        @param storagedomain.id|name: string
        [@param correlation_id: any string]
        [@param expect: 201-created]

        @return StorageDomain:
        '''

        url = '/datacenters/{datacenter:id}/storagedomains'

        result = self.__getProxy().add(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{datacenter:id}': self.parentclass.get_id(),
                    }
                ),
                args={}
            ),
            body=ParseHelper.toXml(storagedomain),
            headers={"Correlation-Id":correlation_id, "Expect":expect}
        )

        return DataCenterStorageDomain(
            self.parentclass,
            result,
            self.context
        )

    def get(self, name=None, id=None):

        '''
        [@param id  : string (the id of the entity)]
        [@param name: string (the name of the entity)]

        @return StorageDomains:
        '''

        url = '/datacenters/{datacenter:id}/storagedomains'

        if id:
            try :
                result = self.__getProxy().get(
                    url=UrlHelper.append(
                        UrlHelper.replace(
                            url,
                            {
                                '{datacenter:id}': self.parentclass.get_id(),
                            }
                        ),
                        id
                    ),
                    headers={}
                )

                return DataCenterStorageDomain(
                    self.parentclass,
                    result,
                    self.context
                )
            except RequestError as err:
                if err.status and err.status == 404:
                    return None
                raise err
        elif name:
            result = self.__getProxy().get(
                url=UrlHelper.replace(
                    url,
                    {
                        '{datacenter:id}': self.parentclass.get_id(),
                    }
                ),
                headers={}
            ).get_storage_domain()

            return DataCenterStorageDomain(
                self.parentclass,
                FilterHelper.getItem(
                    FilterHelper.filter(
                        result,
                        {'name':name}
                    ),
                    query="name=" + name
                ),
                self.context
            )
        else:
            raise MissingParametersError(['id', 'name'])

    def list(self, max=None, **kwargs):
        '''
        [@param **kwargs: dict (property based filtering)"]
        [@param max: int (max results)]

        @return StorageDomains:
        '''

        url = '/datacenters/{datacenter:id}/storagedomains'

        result = self.__getProxy().get(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{datacenter:id}': self.parentclass.get_id(),
                    }
                ),
                args={'max:matrix':max}
            ),
            headers={}
        ).get_storage_domain()

        return ParseHelper.toSubCollection(
            DataCenterStorageDomain,
            self.parentclass,
            FilterHelper.filter(
                result,
                kwargs
            ),
            context=self.context
        )

class DataCenters(Base):
    def __init__(self, context):
        Base.__init__(self, context)

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def add(self, datacenter, correlation_id=None, expect=None):
        '''
        @type DataCenter:

        @param datacenter.local: boolean
        @param datacenter.name: string
        [@param datacenter.comment: string]
        [@param datacenter.description: string]
        [@param datacenter.storage_format: string]
        [@param datacenter.storage_type: string]
        [@param datacenter.version.major: int]
        [@param datacenter.version.minor: int]
        [@param datacenter.mac_pool.id: string]
        [@param correlation_id: any string]
        [@param expect: 201-created]

        @return DataCenter:
        '''

        url = '/datacenters'

        result = self.__getProxy().add(
           url=UrlHelper.appendParameters(
                url=url,
                args={}
           ),
           body=ParseHelper.toXml(datacenter),
           headers={"Correlation-Id":correlation_id, "Expect":expect}
        )

        return DataCenter(result, self.context)

    def get(self, name=None, id=None):
        '''
        [@param id  : string (the id of the entity)]
        [@param name: string (the name of the entity)]

        @return DataCenters:
        '''

        url = '/datacenters'

        if id:
            try :
                return DataCenter(
                    self.__getProxy().get(
                        url=UrlHelper.append(url, id),
                        headers={}
                    ),
                    self.context
                )
            except RequestError as err:
                if err.status and err.status == 404:
                    return None
                raise err
        elif name:
            result = self.__getProxy().get(
                url=UrlHelper.appendParameters(url, {'search:query':'name='+name}),
                headers={}
            ).get_data_center()

            return DataCenter(
                FilterHelper.getItem(
                    FilterHelper.filter(result, {'name':name}),
                    query="name=" + name
                ),
                self.context
            )
        else:
            raise MissingParametersError(['id', 'name'])

    def list(self, query=None, case_sensitive=True, max=None, **kwargs):
        '''
        [@param **kwargs: dict (property based filtering)]
        [@param query: string (oVirt engine search dialect query)]
        [@param case_sensitive: boolean (true|false)]
        [@param max: int (max results)]

        @return DataCenters:
        '''

        url='/datacenters'

        result = self.__getProxy().get(
            url=UrlHelper.appendParameters(url, {'search:query':query,'case_sensitive:matrix':case_sensitive,'max:matrix':max}),
            headers={}
        ).get_data_center()

        return ParseHelper.toCollection(
            DataCenter,
            FilterHelper.filter(result, kwargs),
            context=self.context
        )

class Disk(params.Disk, Base):
    def __init__(self, disk, context):
        Base.__init__(self, context)
        self.superclass = disk

        self.permissions = DiskPermissions(self, context)
        self.statistics = DiskStatistics(self, context)

    def __new__(cls, disk, context):
        if disk is None: return None
        obj = object.__new__(cls)
        obj.__init__(disk, context)
        return obj

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def delete(self, async=None, correlation_id=None):
        '''
        [@param async: boolean (true|false)]
        [@param correlation_id: any string]

        @return None:
        '''

        url = UrlHelper.replace(
            '/disks/{disk:id}',
            {
                '{disk:id}': self.get_id(),
            }
        )

        return self.__getProxy().delete(
            url=UrlHelper.appendParameters(
                url,
                {'async:matrix':async}
            ),
            headers={"Correlation-Id":correlation_id,"Content-type":None}
        )

    def copy(self, action=params.Action(), correlation_id=None):
        '''
        @type Action:

        @param action.storage_domain.id|name: string
        [@param action.disk.name|alias: string]
        [@param action.async: boolean]
        [@param action.grace_period.expiry: long]
        [@param correlation_id: any string]

        @return Action:
        '''

        url = '/disks/{disk:id}/copy'

        result = self.__getProxy().request(
            method='POST',
            url=UrlHelper.replace(
                url,
                {
                    '{disk:id}': self.get_id(),
                }
            ),
            body=ParseHelper.toXml(action),
            headers={"Correlation-Id":correlation_id}
        )

        return result

    def export(self, action=params.Action(), correlation_id=None):
        '''
        @type Action:

        @param action.storage_domain.id|name: string
        [@param action.async: boolean]
        [@param action.grace_period.expiry: long]
        [@param correlation_id: any string]

        @return Action:
        '''

        url = '/disks/{disk:id}/export'

        result = self.__getProxy().request(
            method='POST',
            url=UrlHelper.replace(
                url,
                {
                    '{disk:id}': self.get_id(),
                }
            ),
            body=ParseHelper.toXml(action),
            headers={"Correlation-Id":correlation_id}
        )

        return result

    def move(self, action=params.Action(), correlation_id=None):
        '''
        @type Action:

        @param action.storage_domain.id|name: string
        [@param action.async: boolean]
        [@param action.grace_period.expiry: long]
        [@param correlation_id: any string]

        @return Action:
        '''

        url = '/disks/{disk:id}/move'

        result = self.__getProxy().request(
            method='POST',
            url=UrlHelper.replace(
                url,
                {
                    '{disk:id}': self.get_id(),
                }
            ),
            body=ParseHelper.toXml(action),
            headers={"Correlation-Id":correlation_id}
        )

        return result

class DiskPermission(params.Permission, Base):
    def __init__(self, disk, permission, context):
        Base.__init__(self, context)
        self.parentclass = disk
        self.superclass  =  permission

        #SUB_COLLECTIONS
    def __new__(cls, disk, permission, context):
        if permission is None: return None
        obj = object.__new__(cls)
        obj.__init__(disk, permission, context)
        return obj

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def delete(self, async=None):
        '''
        [@param async: boolean (true|false)]

        @return None:
        '''

        url = UrlHelper.replace(
            '/disks/{disk:id}/permissions/{permission:id}',
            {
                '{disk:id}': self.parentclass.get_id(),
                '{permission:id}': self.get_id(),
            }
        )

        return self.__getProxy().delete(
            url=UrlHelper.appendParameters(
                url,
                {'async:matrix':async}
            ),
            headers={"Content-type":None}
        )

class DiskPermissions(Base):

    def __init__(self, disk , context):
        Base.__init__(self, context)
        self.parentclass = disk

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def add(self, permission):

        '''
        @type Permission:


        @return Permission:
        '''

        url = '/disks/{disk:id}/permissions'

        result = self.__getProxy().add(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{disk:id}': self.parentclass.get_id(),
                    }
                ),
                args={}
            ),
            body=ParseHelper.toXml(permission),
            headers={}
        )

        return DiskPermission(
            self.parentclass,
            result,
            self.context
        )

    def get(self, name=None, id=None):

        '''
        [@param id  : string (the id of the entity)]
        [@param name: string (the name of the entity)]

        @return Permissions:
        '''

        url = '/disks/{disk:id}/permissions'

        if id:
            try :
                result = self.__getProxy().get(
                    url=UrlHelper.append(
                        UrlHelper.replace(
                            url,
                            {
                                '{disk:id}': self.parentclass.get_id(),
                            }
                        ),
                        id
                    ),
                    headers={}
                )

                return DiskPermission(
                    self.parentclass,
                    result,
                    self.context
                )
            except RequestError as err:
                if err.status and err.status == 404:
                    return None
                raise err
        elif name:
            result = self.__getProxy().get(
                url=UrlHelper.replace(
                    url,
                    {
                        '{disk:id}': self.parentclass.get_id(),
                    }
                ),
                headers={}
            ).get_permission()

            return DiskPermission(
                self.parentclass,
                FilterHelper.getItem(
                    FilterHelper.filter(
                        result,
                        {'name':name}
                    ),
                    query="name=" + name
                ),
                self.context
            )
        else:
            raise MissingParametersError(['id', 'name'])

    def list(self, max=None, **kwargs):
        '''
        [@param **kwargs: dict (property based filtering)"]
        [@param max: int (max results)]

        @return Permissions:
        '''

        url = '/disks/{disk:id}/permissions'

        result = self.__getProxy().get(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{disk:id}': self.parentclass.get_id(),
                    }
                ),
                args={'max:matrix':max}
            ),
            headers={}
        ).get_permission()

        return ParseHelper.toSubCollection(
            DiskPermission,
            self.parentclass,
            FilterHelper.filter(
                result,
                kwargs
            ),
            context=self.context
        )

class DiskProfile(params.DiskProfile, Base):
    def __init__(self, diskprofile, context):
        Base.__init__(self, context)
        self.superclass = diskprofile

        self.permissions = DiskProfilePermissions(self, context)

    def __new__(cls, diskprofile, context):
        if diskprofile is None: return None
        obj = object.__new__(cls)
        obj.__init__(diskprofile, context)
        return obj

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def delete(self, async=None, correlation_id=None):
        '''
        [@param async: boolean (true|false)]
        [@param correlation_id: any string]

        @return None:
        '''

        url = UrlHelper.replace(
            '/diskprofiles/{diskprofile:id}',
            {
                '{diskprofile:id}': self.get_id(),
            }
        )

        return self.__getProxy().delete(
            url=UrlHelper.appendParameters(
                url,
                {'async:matrix':async}
            ),
            headers={"Correlation-Id":correlation_id,"Content-type":None}
        )

    def update(self, correlation_id=None, expect=None):
        '''
        [@param diskprofile.name: string]
        [@param diskprofile.description: string]
        [@param diskprofile.qos.id: string]
        [@param correlation_id: any string]
        [@param expect: 202-accepted]

        @return DiskProfile:
        '''

        url = '/diskprofiles/{diskprofile:id}'

        result = self.__getProxy().update(
            url=UrlHelper.replace(
                url,
                {
                    '{diskprofile:id}': self.get_id(),
                }
            ),
            body=ParseHelper.toXml(self.superclass),
            headers={"Correlation-Id":correlation_id, "Expect":expect}
        )

        return DiskProfile(result, self.context)

class DiskProfilePermission(params.Permission, Base):
    def __init__(self, diskprofile, permission, context):
        Base.__init__(self, context)
        self.parentclass = diskprofile
        self.superclass  =  permission

        #SUB_COLLECTIONS
    def __new__(cls, diskprofile, permission, context):
        if permission is None: return None
        obj = object.__new__(cls)
        obj.__init__(diskprofile, permission, context)
        return obj

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def delete(self, async=None, correlation_id=None):
        '''
        [@param async: boolean (true|false)]
        [@param correlation_id: any string]

        @return None:
        '''

        url = UrlHelper.replace(
            '/diskprofiles/{diskprofile:id}/permissions/{permission:id}',
            {
                '{diskprofile:id}': self.parentclass.get_id(),
                '{permission:id}': self.get_id(),
            }
        )

        return self.__getProxy().delete(
            url=UrlHelper.appendParameters(
                url,
                {'async:matrix':async}
            ),
            headers={"Correlation-Id":correlation_id,"Content-type":None}
        )

class DiskProfilePermissions(Base):

    def __init__(self, diskprofile , context):
        Base.__init__(self, context)
        self.parentclass = diskprofile

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def add(self, permission, correlation_id=None, expect=None):

        '''
        @type Permission:

        Overload 1:
          @param permission.user.id: string
          @param permission.role.id|name: string
        Overload 2:
          @param permission.group.id: string
          @param permission.role.id|name: string
        [@param correlation_id: any string]
        [@param expect: 201-created]

        @return Permission:
        '''

        url = '/diskprofiles/{diskprofile:id}/permissions'

        result = self.__getProxy().add(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{diskprofile:id}': self.parentclass.get_id(),
                    }
                ),
                args={}
            ),
            body=ParseHelper.toXml(permission),
            headers={"Correlation-Id":correlation_id, "Expect":expect}
        )

        return DiskProfilePermission(
            self.parentclass,
            result,
            self.context
        )

    def get(self, name=None, id=None):

        '''
        [@param id  : string (the id of the entity)]
        [@param name: string (the name of the entity)]

        @return Permissions:
        '''

        url = '/diskprofiles/{diskprofile:id}/permissions'

        if id:
            try :
                result = self.__getProxy().get(
                    url=UrlHelper.append(
                        UrlHelper.replace(
                            url,
                            {
                                '{diskprofile:id}': self.parentclass.get_id(),
                            }
                        ),
                        id
                    ),
                    headers={}
                )

                return DiskProfilePermission(
                    self.parentclass,
                    result,
                    self.context
                )
            except RequestError as err:
                if err.status and err.status == 404:
                    return None
                raise err
        elif name:
            result = self.__getProxy().get(
                url=UrlHelper.replace(
                    url,
                    {
                        '{diskprofile:id}': self.parentclass.get_id(),
                    }
                ),
                headers={}
            ).get_permission()

            return DiskProfilePermission(
                self.parentclass,
                FilterHelper.getItem(
                    FilterHelper.filter(
                        result,
                        {'name':name}
                    ),
                    query="name=" + name
                ),
                self.context
            )
        else:
            raise MissingParametersError(['id', 'name'])

    def list(self, max=None, **kwargs):
        '''
        [@param **kwargs: dict (property based filtering)"]
        [@param max: int (max results)]

        @return Permissions:
        '''

        url = '/diskprofiles/{diskprofile:id}/permissions'

        result = self.__getProxy().get(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{diskprofile:id}': self.parentclass.get_id(),
                    }
                ),
                args={'max:matrix':max}
            ),
            headers={}
        ).get_permission()

        return ParseHelper.toSubCollection(
            DiskProfilePermission,
            self.parentclass,
            FilterHelper.filter(
                result,
                kwargs
            ),
            context=self.context
        )

class DiskProfiles(Base):
    def __init__(self, context):
        Base.__init__(self, context)

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def add(self, diskprofile, correlation_id=None, expect=None):
        '''
        @type DiskProfile:

        @param diskprofile.storagedomain.id: string
        @param diskprofile.name: string
        [@param diskprofile.description: string]
        [@param diskprofile.qos.id: string]
        [@param correlation_id: any string]
        [@param expect: 201-created]

        @return DiskProfile:
        '''

        url = '/diskprofiles'

        result = self.__getProxy().add(
           url=UrlHelper.appendParameters(
                url=url,
                args={}
           ),
           body=ParseHelper.toXml(diskprofile),
           headers={"Correlation-Id":correlation_id, "Expect":expect}
        )

        return DiskProfile(result, self.context)

    def get(self, name=None, id=None):
        '''
        [@param id  : string (the id of the entity)]
        [@param name: string (the name of the entity)]

        @return DiskProfiles:
        '''

        url = '/diskprofiles'

        if id:
            try :
                return DiskProfile(
                    self.__getProxy().get(
                                url=UrlHelper.append(url, id),
                                headers={}
                    ),
                    self.context
                )
            except RequestError as err:
                if err.status and err.status == 404:
                    return None
                raise err
        elif name:
            result = self.__getProxy().get(
                    url=url,
                    headers={}
            ).get_disk_profile()

            return DiskProfile(
                FilterHelper.getItem(
                    FilterHelper.filter(result, {'name':name}),
                    query="name=" + name
                ),
                self.context
            )
        else:
            raise MissingParametersError(['id', 'name'])


    def list(self, max=None, **kwargs):
        '''
        [@param **kwargs: dict (property based filtering)]
        [@param max: int (max results)]

        @return DiskProfiles:
        '''

        url='/diskprofiles'

        result = self.__getProxy().get(
            url=UrlHelper.appendParameters(url, {'max:matrix':max}),
            headers={}
        ).get_disk_profile()

        return ParseHelper.toCollection(
            DiskProfile,
            FilterHelper.filter(result, kwargs),
            context=self.context
        )

class DiskStatistic(params.Statistic, Base):
    def __init__(self, disk, statistic, context):
        Base.__init__(self, context)
        self.parentclass = disk
        self.superclass  =  statistic

        #SUB_COLLECTIONS
    def __new__(cls, disk, statistic, context):
        if statistic is None: return None
        obj = object.__new__(cls)
        obj.__init__(disk, statistic, context)
        return obj

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

class DiskStatistics(Base):

    def __init__(self, disk , context):
        Base.__init__(self, context)
        self.parentclass = disk

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def get(self, name=None, id=None):

        '''
        [@param id  : string (the id of the entity)]
        [@param name: string (the name of the entity)]

        @return Statistics:
        '''

        url = '/disks/{disk:id}/statistics'

        if id:
            try :
                result = self.__getProxy().get(
                    url=UrlHelper.append(
                        UrlHelper.replace(
                            url,
                            {
                                '{disk:id}': self.parentclass.get_id(),
                            }
                        ),
                        id
                    ),
                    headers={}
                )

                return DiskStatistic(
                    self.parentclass,
                    result,
                    self.context
                )
            except RequestError as err:
                if err.status and err.status == 404:
                    return None
                raise err
        elif name:
            result = self.__getProxy().get(
                url=UrlHelper.replace(
                    url,
                    {
                        '{disk:id}': self.parentclass.get_id(),
                    }
                ),
                headers={}
            ).get_statistic()

            return DiskStatistic(
                self.parentclass,
                FilterHelper.getItem(
                    FilterHelper.filter(
                        result,
                        {'name':name}
                    ),
                    query="name=" + name
                ),
                self.context
            )
        else:
            raise MissingParametersError(['id', 'name'])

    def list(self, **kwargs):
        '''
        [@param **kwargs: dict (property based filtering)"]

        @return Statistics:
        '''

        url = '/disks/{disk:id}/statistics'

        result = self.__getProxy().get(
            url=UrlHelper.replace(
                url,
                {
                    '{disk:id}': self.parentclass.get_id(),
                }
            )
        ).get_statistic()

        return ParseHelper.toSubCollection(
            DiskStatistic,
            self.parentclass,
            FilterHelper.filter(
                result,
                kwargs
            ),
            context=self.context
        )

class Disks(Base):
    def __init__(self, context):
        Base.__init__(self, context)

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def add(self, disk, correlation_id=None, expect=None):
        '''
        @type Disk:

        Overload 1:
          @param disk.format: string
          @param disk.interface: string
          @param disk.provisioned_size: int
          [@param disk.alias: string]
          [@param disk.name: string]
          [@param disk.size: int]
          [@param disk.sparse: boolean]
          [@param disk.description: string]
          [@param disk.bootable: boolean]
          [@param disk.shareable: boolean]
          [@param disk.propagate_errors: boolean]
          [@param disk.wipe_after_delete: boolean]
          [@param disk.quota.id: string]
          [@param disk.disk_profile.id: string]
          [@param disk.storage_domains.storage_domain: collection]
          {
            [@ivar storage_domain.id|name: string]
          }
          [@param disk.openstack_volume_type.name: string]
        Overload 2:
          @param disk.interface: string
          @param disk.lun_storage.type: string
          @param disk.lun_storage.logical_unit: collection
          {
            @ivar logical_unit.id: string
            @ivar logical_unit.address: string
            @ivar logical_unit.port: int
            @ivar logical_unit.target: string
          }
          [@param disk.alias: string]
          [@param disk.sparse: boolean]
          [@param disk.description: string]
          [@param disk.bootable: boolean]
          [@param disk.shareable: boolean]
          [@param disk.propagate_errors: boolean]
          [@param disk.wipe_after_delete: boolean]
          [@param disk.quota.id: string]
          [@param disk.sgio: string]
          [@param disk.lun_storage.host: string]
        [@param correlation_id: any string]
        [@param expect: 201-created]

        @return Disk:
        '''

        url = '/disks'

        result = self.__getProxy().add(
           url=UrlHelper.appendParameters(
                url=url,
                args={}
           ),
           body=ParseHelper.toXml(disk),
           headers={"Correlation-Id":correlation_id, "Expect":expect}
        )

        return Disk(result, self.context)

    def get(self, alias=None, id=None):
        '''
        [@param id   : string (the id of the entity)]
        [@param alias: string (the alias of the entity)]

        @return Disks:
        '''

        url = '/disks'

        if id:
            try :
                return Disk(
                    self.__getProxy().get(url=UrlHelper.append(url, id),
                    headers={}),
                    self.context
                )
            except RequestError as err:
                if err.status and err.status == 404:
                    return None
                raise err
        elif alias:
            result = self.__getProxy().get(
                url=UrlHelper.appendParameters(url, {'search:query':'alias='+alias}),
                headers={}
            ).get_disk()

            return Disk(
                        FilterHelper.getItem(
                            FilterHelper.filter(result, {'alias':alias}),
                            query="alias=" + alias
                        ),
                        self.context
            )
        else:
            raise MissingParametersError(['id', 'alias'])

    def list(self, query=None, case_sensitive=True, max=None, **kwargs):
        '''
        [@param **kwargs: dict (property based filtering)]
        [@param query: string (oVirt engine search dialect query)]
        [@param case_sensitive: boolean (true|false)]
        [@param max: int (max results)]

        @return Disks:
        '''

        url='/disks'

        result = self.__getProxy().get(
            url=UrlHelper.appendParameters(url, {'search:query':query,'case_sensitive:matrix':case_sensitive,'max:matrix':max}),
            headers={}
        ).get_disk()

        return ParseHelper.toCollection(
            Disk,
            FilterHelper.filter(result, kwargs),
            context=self.context
        )

class Domain(params.Domain, Base):
    def __init__(self, domain, context):
        Base.__init__(self, context)
        self.superclass = domain

        self.groups = DomainGroups(self, context)
        self.users = DomainUsers(self, context)

    def __new__(cls, domain, context):
        if domain is None: return None
        obj = object.__new__(cls)
        obj.__init__(domain, context)
        return obj

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

class DomainGroup(params.Group, Base):
    def __init__(self, domain, group, context):
        Base.__init__(self, context)
        self.parentclass = domain
        self.superclass  =  group

        #SUB_COLLECTIONS
    def __new__(cls, domain, group, context):
        if group is None: return None
        obj = object.__new__(cls)
        obj.__init__(domain, group, context)
        return obj

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

class DomainGroups(Base):

    def __init__(self, domain , context):
        Base.__init__(self, context)
        self.parentclass = domain

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def get(self, name=None, id=None):

        '''
        [@param id  : string (the id of the entity)]
        [@param name: string (the name of the entity)]

        @return Groups:
        '''

        url = '/domains/{domain:id}/groups'

        if id:
            try :
                result = self.__getProxy().get(
                    url=UrlHelper.append(
                        UrlHelper.replace(
                            url,
                            {
                                '{domain:id}': self.parentclass.get_id(),
                            }
                        ),
                        id
                    ),
                    headers={}
                )

                return DomainGroup(
                    self.parentclass,
                    result,
                    self.context
                )
            except RequestError as err:
                if err.status and err.status == 404:
                    return None
                raise err
        elif name:
            result = self.__getProxy().get(
                url=UrlHelper.replace(
                    url,
                    {
                        '{domain:id}': self.parentclass.get_id(),
                    }
                ),
                headers={}
            ).get_group()

            return DomainGroup(
                self.parentclass,
                FilterHelper.getItem(
                    FilterHelper.filter(
                        result,
                        {'name':name}
                    ),
                    query="name=" + name
                ),
                self.context
            )
        else:
            raise MissingParametersError(['id', 'name'])

    def list(self, query=None, case_sensitive=True, max=None, **kwargs):
        '''
        [@param **kwargs: dict (property based filtering)"]
        [@param query: string (oVirt engine search dialect query)]
        [@param case_sensitive: boolean (true|false)]
        [@param max: int (max results)]

        @return Groups:
        '''

        url = '/domains/{domain:id}/groups'

        result = self.__getProxy().get(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{domain:id}': self.parentclass.get_id(),
                    }
                ),
                args={'search:query':query,'case_sensitive:matrix':case_sensitive,'max:matrix':max}
            ),
            headers={}
        ).get_group()

        return ParseHelper.toSubCollection(
            DomainGroup,
            self.parentclass,
            FilterHelper.filter(
                result,
                kwargs
            ),
            context=self.context
        )

class DomainUser(params.User, Base):
    def __init__(self, domain, user, context):
        Base.__init__(self, context)
        self.parentclass = domain
        self.superclass  =  user

        #SUB_COLLECTIONS
    def __new__(cls, domain, user, context):
        if user is None: return None
        obj = object.__new__(cls)
        obj.__init__(domain, user, context)
        return obj

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

class DomainUsers(Base):

    def __init__(self, domain , context):
        Base.__init__(self, context)
        self.parentclass = domain

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def get(self, name=None, id=None):

        '''
        [@param id  : string (the id of the entity)]
        [@param name: string (the name of the entity)]

        @return Users:
        '''

        url = '/domains/{domain:id}/users'

        if id:
            try :
                result = self.__getProxy().get(
                    url=UrlHelper.append(
                        UrlHelper.replace(
                            url,
                            {
                                '{domain:id}': self.parentclass.get_id(),
                            }
                        ),
                        id
                    ),
                    headers={}
                )

                return DomainUser(
                    self.parentclass,
                    result,
                    self.context
                )
            except RequestError as err:
                if err.status and err.status == 404:
                    return None
                raise err
        elif name:
            result = self.__getProxy().get(
                url=UrlHelper.replace(
                    url,
                    {
                        '{domain:id}': self.parentclass.get_id(),
                    }
                ),
                headers={}
            ).get_user()

            return DomainUser(
                self.parentclass,
                FilterHelper.getItem(
                    FilterHelper.filter(
                        result,
                        {'name':name}
                    ),
                    query="name=" + name
                ),
                self.context
            )
        else:
            raise MissingParametersError(['id', 'name'])

    def list(self, query=None, case_sensitive=True, max=None, **kwargs):
        '''
        [@param **kwargs: dict (property based filtering)"]
        [@param query: string (oVirt engine search dialect query)]
        [@param case_sensitive: boolean (true|false)]
        [@param max: int (max results)]

        @return Users:
        '''

        url = '/domains/{domain:id}/users'

        result = self.__getProxy().get(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{domain:id}': self.parentclass.get_id(),
                    }
                ),
                args={'search:query':query,'case_sensitive:matrix':case_sensitive,'max:matrix':max}
            ),
            headers={}
        ).get_user()

        return ParseHelper.toSubCollection(
            DomainUser,
            self.parentclass,
            FilterHelper.filter(
                result,
                kwargs
            ),
            context=self.context
        )

class Domains(Base):
    def __init__(self, context):
        Base.__init__(self, context)

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def get(self, name=None, id=None):
        '''
        [@param id  : string (the id of the entity)]
        [@param name: string (the name of the entity)]

        @return Domains:
        '''

        url = '/domains'

        if id:
            try :
                return Domain(
                    self.__getProxy().get(
                                url=UrlHelper.append(url, id),
                                headers={}
                    ),
                    self.context
                )
            except RequestError as err:
                if err.status and err.status == 404:
                    return None
                raise err
        elif name:
            result = self.__getProxy().get(
                    url=url,
                    headers={}
            ).get_domain()

            return Domain(
                FilterHelper.getItem(
                    FilterHelper.filter(result, {'name':name}),
                    query="name=" + name
                ),
                self.context
            )
        else:
            raise MissingParametersError(['id', 'name'])


    def list(self, max=None, **kwargs):
        '''
        [@param **kwargs: dict (property based filtering)]
        [@param max: int (max results)]

        @return Domains:
        '''

        url='/domains'

        result = self.__getProxy().get(
            url=UrlHelper.appendParameters(url, {'max:matrix':max}),
            headers={}
        ).get_domain()

        return ParseHelper.toCollection(
            Domain,
            FilterHelper.filter(result, kwargs),
            context=self.context
        )

class Event(params.Event, Base):
    def __init__(self, event, context):
        Base.__init__(self, context)
        self.superclass = event

        #SUB_COLLECTIONS
    def __new__(cls, event, context):
        if event is None: return None
        obj = object.__new__(cls)
        obj.__init__(event, context)
        return obj

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def delete(self, async=None, correlation_id=None):
        '''
        [@param async: boolean (true|false)]
        [@param correlation_id: any string]

        @return None:
        '''

        url = UrlHelper.replace(
            '/events/{event:id}',
            {
                '{event:id}': self.get_id(),
            }
        )

        return self.__getProxy().delete(
            url=UrlHelper.appendParameters(
                url,
                {'async:matrix':async}
            ),
            headers={"Correlation-Id":correlation_id,"Content-type":None}
        )

class Events(Base):
    def __init__(self, context):
        Base.__init__(self, context)

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def add(self, event, correlation_id=None, expect=None):
        '''
        @type Event:

        @param event.description: string
        @param event.severity: string
        @param event.origin: string
        @param event.custom_id: int
        [@param event.flood_rate: int]
        [@param event.host.id: string]
        [@param event.host.external_status.state: string]
        [@param event.user.id: string]
        [@param event.vm.id: string]
        [@param event.storage_domain.id: string]
        [@param event.storage_domain.external_status.state: string]
        [@param event.template.id: string]
        [@param event.cluster.id: string]
        [@param event.data_center.id: string]
        [@param correlation_id: any string]
        [@param expect: 201-created]

        @return Event:
        '''

        url = '/events'

        result = self.__getProxy().add(
           url=UrlHelper.appendParameters(
                url=url,
                args={}
           ),
           body=ParseHelper.toXml(event),
           headers={"Correlation-Id":correlation_id, "Expect":expect}
        )

        return Event(result, self.context)

    def get(self, name=None, id=None):
        '''
        [@param id  : string (the id of the entity)]
        [@param name: string (the name of the entity)]

        @return Events:
        '''

        url = '/events'

        if id:
            try :
                return Event(
                    self.__getProxy().get(
                        url=UrlHelper.append(url, id),
                        headers={}
                    ),
                    self.context
                )
            except RequestError as err:
                if err.status and err.status == 404:
                    return None
                raise err
        elif name:
            result = self.__getProxy().get(
                url=UrlHelper.appendParameters(url, {'search:query':'name='+name}),
                headers={}
            ).get_event()

            return Event(
                FilterHelper.getItem(
                    FilterHelper.filter(result, {'name':name}),
                    query="name=" + name
                ),
                self.context
            )
        else:
            raise MissingParametersError(['id', 'name'])

    def list(self, query=None, case_sensitive=True, from_event_id=None, max=None, **kwargs):
        '''
        [@param **kwargs: dict (property based filtering)]
        [@param query: string (oVirt engine search dialect query)]
        [@param case_sensitive: boolean (true|false)]
        [@param from_event_id: string (event_id)]
        [@param max: int (max results)]

        @return Events:
        '''

        url='/events'

        result = self.__getProxy().get(
            url=UrlHelper.appendParameters(url, {'search:query':query,'case_sensitive:matrix':case_sensitive,'from:matrix':from_event_id,'max:matrix':max}),
            headers={}
        ).get_event()

        return ParseHelper.toCollection(
            Event,
            FilterHelper.filter(result, kwargs),
            context=self.context
        )

class ExternalHostProvider(params.ExternalHostProvider, Base):
    def __init__(self, externalhostprovider, context):
        Base.__init__(self, context)
        self.superclass = externalhostprovider

        self.certificates = ExternalHostProviderCertificates(self, context)
        self.computeresources = ExternalHostProviderExternalComputeResources(self, context)
        self.discoveredhosts = ExternalHostProviderExternalDiscoveredHosts(self, context)
        self.hostgroups = ExternalHostProviderExternalHostGroups(self, context)
        self.hosts = ExternalHostProviderExternalHosts(self, context)

    def __new__(cls, externalhostprovider, context):
        if externalhostprovider is None: return None
        obj = object.__new__(cls)
        obj.__init__(externalhostprovider, context)
        return obj

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def delete(self, async=None, correlation_id=None):
        '''
        [@param async: boolean (true|false)]
        [@param correlation_id: any string]

        @return None:
        '''

        url = UrlHelper.replace(
            '/externalhostproviders/{externalhostprovider:id}',
            {
                '{externalhostprovider:id}': self.get_id(),
            }
        )

        return self.__getProxy().delete(
            url=UrlHelper.appendParameters(
                url,
                {'async:matrix':async}
            ),
            headers={"Correlation-Id":correlation_id,"Content-type":None}
        )

    def update(self, correlation_id=None, expect=None):
        '''
        [@param external_host_provider.name: string]
        [@param external_host_provider.description: string]
        [@param external_host_provider.requires_authentication: boolean]
        [@param external_host_provider.username: string]
        [@param external_host_provider.password: string]
        [@param correlation_id: any string]
        [@param expect: 202-accepted]

        @return ExternalHostProvider:
        '''

        url = '/externalhostproviders/{externalhostprovider:id}'

        result = self.__getProxy().update(
            url=UrlHelper.replace(
                url,
                {
                    '{externalhostprovider:id}': self.get_id(),
                }
            ),
            body=ParseHelper.toXml(self.superclass),
            headers={"Correlation-Id":correlation_id, "Expect":expect}
        )

        return ExternalHostProvider(result, self.context)

    def importcertificates(self, action=params.Action(), correlation_id=None):
        '''
        @type Action:

        @param certificates.certificate: collection
        {
          @ivar content: string
        }
        [@param action.async: boolean]
        [@param action.grace_period.expiry: long]
        [@param correlation_id: any string]

        @return Action:
        '''

        url = '/externalhostproviders/{externalhostprovider:id}/importcertificates'

        result = self.__getProxy().request(
            method='POST',
            url=UrlHelper.replace(
                url,
                {
                    '{externalhostprovider:id}': self.get_id(),
                }
            ),
            body=ParseHelper.toXml(action),
            headers={"Correlation-Id":correlation_id}
        )

        return result

    def testconnectivity(self, action=params.Action(), correlation_id=None):
        '''
        @type Action:

        [@param action.async: boolean]
        [@param action.grace_period.expiry: long]
        [@param correlation_id: any string]

        @return Action:
        '''

        url = '/externalhostproviders/{externalhostprovider:id}/testconnectivity'

        result = self.__getProxy().request(
            method='POST',
            url=UrlHelper.replace(
                url,
                {
                    '{externalhostprovider:id}': self.get_id(),
                }
            ),
            body=ParseHelper.toXml(action),
            headers={"Correlation-Id":correlation_id}
        )

        return result

class ExternalHostProviderCertificate(params.Certificate, Base):
    def __init__(self, externalhostprovider, certificate, context):
        Base.__init__(self, context)
        self.parentclass = externalhostprovider
        self.superclass  =  certificate

        #SUB_COLLECTIONS
    def __new__(cls, externalhostprovider, certificate, context):
        if certificate is None: return None
        obj = object.__new__(cls)
        obj.__init__(externalhostprovider, certificate, context)
        return obj

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

class ExternalHostProviderCertificates(Base):

    def __init__(self, externalhostprovider , context):
        Base.__init__(self, context)
        self.parentclass = externalhostprovider

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def get(self, name=None, id=None):

        '''
        [@param id  : string (the id of the entity)]
        [@param name: string (the name of the entity)]

        @return Certificates:
        '''

        url = '/externalhostproviders/{externalhostprovider:id}/certificates'

        if id:
            try :
                result = self.__getProxy().get(
                    url=UrlHelper.append(
                        UrlHelper.replace(
                            url,
                            {
                                '{externalhostprovider:id}': self.parentclass.get_id(),
                            }
                        ),
                        id
                    ),
                    headers={}
                )

                return ExternalHostProviderCertificate(
                    self.parentclass,
                    result,
                    self.context
                )
            except RequestError as err:
                if err.status and err.status == 404:
                    return None
                raise err
        elif name:
            result = self.__getProxy().get(
                url=UrlHelper.replace(
                    url,
                    {
                        '{externalhostprovider:id}': self.parentclass.get_id(),
                    }
                ),
                headers={}
            ).get_certificate()

            return ExternalHostProviderCertificate(
                self.parentclass,
                FilterHelper.getItem(
                    FilterHelper.filter(
                        result,
                        {'name':name}
                    ),
                    query="name=" + name
                ),
                self.context
            )
        else:
            raise MissingParametersError(['id', 'name'])

    def list(self, max=None, **kwargs):
        '''
        [@param **kwargs: dict (property based filtering)"]
        [@param max: int (max results)]

        @return Certificates:
        '''

        url = '/externalhostproviders/{externalhostprovider:id}/certificates'

        result = self.__getProxy().get(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{externalhostprovider:id}': self.parentclass.get_id(),
                    }
                ),
                args={'max:matrix':max}
            ),
            headers={}
        ).get_certificate()

        return ParseHelper.toSubCollection(
            ExternalHostProviderCertificate,
            self.parentclass,
            FilterHelper.filter(
                result,
                kwargs
            ),
            context=self.context
        )

class ExternalHostProviderExternalComputeResource(params.ExternalComputeResource, Base):
    def __init__(self, externalhostprovider, externalcomputeresource, context):
        Base.__init__(self, context)
        self.parentclass = externalhostprovider
        self.superclass  =  externalcomputeresource

        #SUB_COLLECTIONS
    def __new__(cls, externalhostprovider, externalcomputeresource, context):
        if externalcomputeresource is None: return None
        obj = object.__new__(cls)
        obj.__init__(externalhostprovider, externalcomputeresource, context)
        return obj

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

class ExternalHostProviderExternalComputeResources(Base):

    def __init__(self, externalhostprovider , context):
        Base.__init__(self, context)
        self.parentclass = externalhostprovider

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def get(self, name=None, id=None):

        '''
        [@param id  : string (the id of the entity)]
        [@param name: string (the name of the entity)]

        @return ExternalComputeResources:
        '''

        url = '/externalhostproviders/{externalhostprovider:id}/computeresources'

        if id:
            try :
                result = self.__getProxy().get(
                    url=UrlHelper.append(
                        UrlHelper.replace(
                            url,
                            {
                                '{externalhostprovider:id}': self.parentclass.get_id(),
                            }
                        ),
                        id
                    ),
                    headers={}
                )

                return ExternalHostProviderExternalComputeResource(
                    self.parentclass,
                    result,
                    self.context
                )
            except RequestError as err:
                if err.status and err.status == 404:
                    return None
                raise err
        elif name:
            result = self.__getProxy().get(
                url=UrlHelper.replace(
                    url,
                    {
                        '{externalhostprovider:id}': self.parentclass.get_id(),
                    }
                ),
                headers={}
            ).get_external_compute_resource()

            return ExternalHostProviderExternalComputeResource(
                self.parentclass,
                FilterHelper.getItem(
                    FilterHelper.filter(
                        result,
                        {'name':name}
                    ),
                    query="name=" + name
                ),
                self.context
            )
        else:
            raise MissingParametersError(['id', 'name'])

    def list(self, max=None, **kwargs):
        '''
        [@param **kwargs: dict (property based filtering)"]
        [@param max: int (max results)]

        @return ExternalComputeResources:
        '''

        url = '/externalhostproviders/{externalhostprovider:id}/computeresources'

        result = self.__getProxy().get(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{externalhostprovider:id}': self.parentclass.get_id(),
                    }
                ),
                args={'max:matrix':max}
            ),
            headers={}
        ).get_external_compute_resource()

        return ParseHelper.toSubCollection(
            ExternalHostProviderExternalComputeResource,
            self.parentclass,
            FilterHelper.filter(
                result,
                kwargs
            ),
            context=self.context
        )

class ExternalHostProviderExternalDiscoveredHost(params.ExternalDiscoveredHost, Base):
    def __init__(self, externalhostprovider, externaldiscoveredhost, context):
        Base.__init__(self, context)
        self.parentclass = externalhostprovider
        self.superclass  =  externaldiscoveredhost

        #SUB_COLLECTIONS
    def __new__(cls, externalhostprovider, externaldiscoveredhost, context):
        if externaldiscoveredhost is None: return None
        obj = object.__new__(cls)
        obj.__init__(externalhostprovider, externaldiscoveredhost, context)
        return obj

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

class ExternalHostProviderExternalDiscoveredHosts(Base):

    def __init__(self, externalhostprovider , context):
        Base.__init__(self, context)
        self.parentclass = externalhostprovider

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def get(self, name=None, id=None):

        '''
        [@param id  : string (the id of the entity)]
        [@param name: string (the name of the entity)]

        @return ExternalDiscoveredHosts:
        '''

        url = '/externalhostproviders/{externalhostprovider:id}/discoveredhosts'

        if id:
            try :
                result = self.__getProxy().get(
                    url=UrlHelper.append(
                        UrlHelper.replace(
                            url,
                            {
                                '{externalhostprovider:id}': self.parentclass.get_id(),
                            }
                        ),
                        id
                    ),
                    headers={}
                )

                return ExternalHostProviderExternalDiscoveredHost(
                    self.parentclass,
                    result,
                    self.context
                )
            except RequestError as err:
                if err.status and err.status == 404:
                    return None
                raise err
        elif name:
            result = self.__getProxy().get(
                url=UrlHelper.replace(
                    url,
                    {
                        '{externalhostprovider:id}': self.parentclass.get_id(),
                    }
                ),
                headers={}
            ).get_external_discovered_host()

            return ExternalHostProviderExternalDiscoveredHost(
                self.parentclass,
                FilterHelper.getItem(
                    FilterHelper.filter(
                        result,
                        {'name':name}
                    ),
                    query="name=" + name
                ),
                self.context
            )
        else:
            raise MissingParametersError(['id', 'name'])

    def list(self, max=None, **kwargs):
        '''
        [@param **kwargs: dict (property based filtering)"]
        [@param max: int (max results)]

        @return ExternalDiscoveredHosts:
        '''

        url = '/externalhostproviders/{externalhostprovider:id}/discoveredhosts'

        result = self.__getProxy().get(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{externalhostprovider:id}': self.parentclass.get_id(),
                    }
                ),
                args={'max:matrix':max}
            ),
            headers={}
        ).get_external_discovered_host()

        return ParseHelper.toSubCollection(
            ExternalHostProviderExternalDiscoveredHost,
            self.parentclass,
            FilterHelper.filter(
                result,
                kwargs
            ),
            context=self.context
        )

class ExternalHostProviderExternalHost(params.ExternalHost, Base):
    def __init__(self, externalhostprovider, externalhost, context):
        Base.__init__(self, context)
        self.parentclass = externalhostprovider
        self.superclass  =  externalhost

        #SUB_COLLECTIONS
    def __new__(cls, externalhostprovider, externalhost, context):
        if externalhost is None: return None
        obj = object.__new__(cls)
        obj.__init__(externalhostprovider, externalhost, context)
        return obj

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

class ExternalHostProviderExternalHostGroup(params.ExternalHostGroup, Base):
    def __init__(self, externalhostprovider, externalhostgroup, context):
        Base.__init__(self, context)
        self.parentclass = externalhostprovider
        self.superclass  =  externalhostgroup

        #SUB_COLLECTIONS
    def __new__(cls, externalhostprovider, externalhostgroup, context):
        if externalhostgroup is None: return None
        obj = object.__new__(cls)
        obj.__init__(externalhostprovider, externalhostgroup, context)
        return obj

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

class ExternalHostProviderExternalHostGroups(Base):

    def __init__(self, externalhostprovider , context):
        Base.__init__(self, context)
        self.parentclass = externalhostprovider

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def get(self, name=None, id=None):

        '''
        [@param id  : string (the id of the entity)]
        [@param name: string (the name of the entity)]

        @return ExternalHostGroups:
        '''

        url = '/externalhostproviders/{externalhostprovider:id}/hostgroups'

        if id:
            try :
                result = self.__getProxy().get(
                    url=UrlHelper.append(
                        UrlHelper.replace(
                            url,
                            {
                                '{externalhostprovider:id}': self.parentclass.get_id(),
                            }
                        ),
                        id
                    ),
                    headers={}
                )

                return ExternalHostProviderExternalHostGroup(
                    self.parentclass,
                    result,
                    self.context
                )
            except RequestError as err:
                if err.status and err.status == 404:
                    return None
                raise err
        elif name:
            result = self.__getProxy().get(
                url=UrlHelper.replace(
                    url,
                    {
                        '{externalhostprovider:id}': self.parentclass.get_id(),
                    }
                ),
                headers={}
            ).get_external_host_group()

            return ExternalHostProviderExternalHostGroup(
                self.parentclass,
                FilterHelper.getItem(
                    FilterHelper.filter(
                        result,
                        {'name':name}
                    ),
                    query="name=" + name
                ),
                self.context
            )
        else:
            raise MissingParametersError(['id', 'name'])

    def list(self, max=None, **kwargs):
        '''
        [@param **kwargs: dict (property based filtering)"]
        [@param max: int (max results)]

        @return ExternalHostGroups:
        '''

        url = '/externalhostproviders/{externalhostprovider:id}/hostgroups'

        result = self.__getProxy().get(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{externalhostprovider:id}': self.parentclass.get_id(),
                    }
                ),
                args={'max:matrix':max}
            ),
            headers={}
        ).get_external_host_group()

        return ParseHelper.toSubCollection(
            ExternalHostProviderExternalHostGroup,
            self.parentclass,
            FilterHelper.filter(
                result,
                kwargs
            ),
            context=self.context
        )

class ExternalHostProviderExternalHosts(Base):

    def __init__(self, externalhostprovider , context):
        Base.__init__(self, context)
        self.parentclass = externalhostprovider

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def get(self, name=None, id=None):

        '''
        [@param id  : string (the id of the entity)]
        [@param name: string (the name of the entity)]

        @return ExternalHosts:
        '''

        url = '/externalhostproviders/{externalhostprovider:id}/hosts'

        if id:
            try :
                result = self.__getProxy().get(
                    url=UrlHelper.append(
                        UrlHelper.replace(
                            url,
                            {
                                '{externalhostprovider:id}': self.parentclass.get_id(),
                            }
                        ),
                        id
                    ),
                    headers={}
                )

                return ExternalHostProviderExternalHost(
                    self.parentclass,
                    result,
                    self.context
                )
            except RequestError as err:
                if err.status and err.status == 404:
                    return None
                raise err
        elif name:
            result = self.__getProxy().get(
                url=UrlHelper.replace(
                    url,
                    {
                        '{externalhostprovider:id}': self.parentclass.get_id(),
                    }
                ),
                headers={}
            ).get_external_host()

            return ExternalHostProviderExternalHost(
                self.parentclass,
                FilterHelper.getItem(
                    FilterHelper.filter(
                        result,
                        {'name':name}
                    ),
                    query="name=" + name
                ),
                self.context
            )
        else:
            raise MissingParametersError(['id', 'name'])

    def list(self, max=None, **kwargs):
        '''
        [@param **kwargs: dict (property based filtering)"]
        [@param max: int (max results)]

        @return ExternalHosts:
        '''

        url = '/externalhostproviders/{externalhostprovider:id}/hosts'

        result = self.__getProxy().get(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{externalhostprovider:id}': self.parentclass.get_id(),
                    }
                ),
                args={'max:matrix':max}
            ),
            headers={}
        ).get_external_host()

        return ParseHelper.toSubCollection(
            ExternalHostProviderExternalHost,
            self.parentclass,
            FilterHelper.filter(
                result,
                kwargs
            ),
            context=self.context
        )

class ExternalHostProviders(Base):
    def __init__(self, context):
        Base.__init__(self, context)

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def add(self, externalhostprovider, correlation_id=None, expect=None):
        '''
        @type ExternalHostProvider:

        @param external_host_provider.name: string
        [@param external_host_provider.description: string]
        [@param external_host_provider.url: string]
        [@param external_host_provider.requires_authentication: boolean]
        [@param external_host_provider.username: string]
        [@param external_host_provider.password: string]
        [@param correlation_id: any string]
        [@param expect: 201-created]

        @return ExternalHostProvider:
        '''

        url = '/externalhostproviders'

        result = self.__getProxy().add(
           url=UrlHelper.appendParameters(
                url=url,
                args={}
           ),
           body=ParseHelper.toXml(externalhostprovider),
           headers={"Correlation-Id":correlation_id, "Expect":expect}
        )

        return ExternalHostProvider(result, self.context)

    def get(self, name=None, id=None):
        '''
        [@param id  : string (the id of the entity)]
        [@param name: string (the name of the entity)]

        @return ExternalHostProviders:
        '''

        url = '/externalhostproviders'

        if id:
            try :
                return ExternalHostProvider(
                    self.__getProxy().get(
                                url=UrlHelper.append(url, id),
                                headers={}
                    ),
                    self.context
                )
            except RequestError as err:
                if err.status and err.status == 404:
                    return None
                raise err
        elif name:
            result = self.__getProxy().get(
                    url=url,
                    headers={}
            ).get_external_host_provider()

            return ExternalHostProvider(
                FilterHelper.getItem(
                    FilterHelper.filter(result, {'name':name}),
                    query="name=" + name
                ),
                self.context
            )
        else:
            raise MissingParametersError(['id', 'name'])


    def list(self, max=None, **kwargs):
        '''
        [@param **kwargs: dict (property based filtering)]
        [@param max: int (max results)]

        @return ExternalHostProviders:
        '''

        url='/externalhostproviders'

        result = self.__getProxy().get(
            url=UrlHelper.appendParameters(url, {'max:matrix':max}),
            headers={}
        ).get_external_host_provider()

        return ParseHelper.toCollection(
            ExternalHostProvider,
            FilterHelper.filter(result, kwargs),
            context=self.context
        )

class Group(params.Group, Base):
    def __init__(self, group, context):
        Base.__init__(self, context)
        self.superclass = group

        self.permissions = GroupPermissions(self, context)
        self.roles = GroupRoles(self, context)
        self.tags = GroupTags(self, context)

    def __new__(cls, group, context):
        if group is None: return None
        obj = object.__new__(cls)
        obj.__init__(group, context)
        return obj

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def delete(self, async=None, correlation_id=None):
        '''
        [@param async: boolean (true|false)]
        [@param correlation_id: any string]

        @return None:
        '''

        url = UrlHelper.replace(
            '/groups/{group:id}',
            {
                '{group:id}': self.get_id(),
            }
        )

        return self.__getProxy().delete(
            url=UrlHelper.appendParameters(
                url,
                {'async:matrix':async}
            ),
            headers={"Correlation-Id":correlation_id,"Content-type":None}
        )

class GroupPermission(params.Permission, Base):
    def __init__(self, group, permission, context):
        Base.__init__(self, context)
        self.parentclass = group
        self.superclass  =  permission

        #SUB_COLLECTIONS
    def __new__(cls, group, permission, context):
        if permission is None: return None
        obj = object.__new__(cls)
        obj.__init__(group, permission, context)
        return obj

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def delete(self, async=None, correlation_id=None):
        '''
        [@param async: boolean (true|false)]
        [@param correlation_id: any string]

        @return None:
        '''

        url = UrlHelper.replace(
            '/groups/{group:id}/permissions/{permission:id}',
            {
                '{group:id}': self.parentclass.get_id(),
                '{permission:id}': self.get_id(),
            }
        )

        return self.__getProxy().delete(
            url=UrlHelper.appendParameters(
                url,
                {'async:matrix':async}
            ),
            headers={"Correlation-Id":correlation_id,"Content-type":None}
        )

class GroupPermissions(Base):

    def __init__(self, group , context):
        Base.__init__(self, context)
        self.parentclass = group

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def add(self, permission, correlation_id=None, expect=None):

        '''
        @type Permission:

        Overload 1:
          @param permission.role.id|name: string
          @param permission.data_center.id: string
        Overload 2:
          @param permission.role.id|name: string
          @param permission.cluster.id: string
        Overload 3:
          @param permission.role.id|name: string
          @param permission.host.id: string
        Overload 4:
          @param permission.role.id|name: string
          @param permission.storage_domain.id: string
        Overload 5:
          @param permission.role.id|name: string
          @param permission.vm.id: string
        Overload 6:
          @param permission.role.id|name: string
          @param permission.vmpool.id: string
        Overload 7:
          @param permission.role.id|name: string
          @param permission.template.id: string
        [@param correlation_id: any string]
        [@param expect: 201-created]

        @return Permission:
        '''

        url = '/groups/{group:id}/permissions'

        result = self.__getProxy().add(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{group:id}': self.parentclass.get_id(),
                    }
                ),
                args={}
            ),
            body=ParseHelper.toXml(permission),
            headers={"Correlation-Id":correlation_id, "Expect":expect}
        )

        return GroupPermission(
            self.parentclass,
            result,
            self.context
        )

    def get(self, name=None, id=None):

        '''
        [@param id  : string (the id of the entity)]
        [@param name: string (the name of the entity)]

        @return Permissions:
        '''

        url = '/groups/{group:id}/permissions'

        if id:
            try :
                result = self.__getProxy().get(
                    url=UrlHelper.append(
                        UrlHelper.replace(
                            url,
                            {
                                '{group:id}': self.parentclass.get_id(),
                            }
                        ),
                        id
                    ),
                    headers={}
                )

                return GroupPermission(
                    self.parentclass,
                    result,
                    self.context
                )
            except RequestError as err:
                if err.status and err.status == 404:
                    return None
                raise err
        elif name:
            result = self.__getProxy().get(
                url=UrlHelper.replace(
                    url,
                    {
                        '{group:id}': self.parentclass.get_id(),
                    }
                ),
                headers={}
            ).get_permission()

            return GroupPermission(
                self.parentclass,
                FilterHelper.getItem(
                    FilterHelper.filter(
                        result,
                        {'name':name}
                    ),
                    query="name=" + name
                ),
                self.context
            )
        else:
            raise MissingParametersError(['id', 'name'])

    def list(self, max=None, **kwargs):
        '''
        [@param **kwargs: dict (property based filtering)"]
        [@param max: int (max results)]

        @return Permissions:
        '''

        url = '/groups/{group:id}/permissions'

        result = self.__getProxy().get(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{group:id}': self.parentclass.get_id(),
                    }
                ),
                args={'max:matrix':max}
            ),
            headers={}
        ).get_permission()

        return ParseHelper.toSubCollection(
            GroupPermission,
            self.parentclass,
            FilterHelper.filter(
                result,
                kwargs
            ),
            context=self.context
        )

class GroupRole(params.Role, Base):
    def __init__(self, group, role, context):
        Base.__init__(self, context)
        self.parentclass = group
        self.superclass  =  role

        self.permits = GroupRolePermits(self, context)

    def __new__(cls, group, role, context):
        if role is None: return None
        obj = object.__new__(cls)
        obj.__init__(group, role, context)
        return obj

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def delete(self, async=None):
        '''
        [@param async: boolean (true|false)]

        @return None:
        '''

        url = UrlHelper.replace(
            '/groups/{group:id}/roles/{role:id}',
            {
                '{group:id}': self.parentclass.get_id(),
                '{role:id}': self.get_id(),
            }
        )

        return self.__getProxy().delete(
            url=UrlHelper.appendParameters(
                url,
                {'async:matrix':async}
            ),
            headers={"Content-type":None}
        )

class GroupRolePermit(params.Permit, Base):
    def __init__(self, grouprole, permit, context):
        Base.__init__(self, context)
        self.parentclass = grouprole
        self.superclass  =  permit

        #SUB_COLLECTIONS
    def __new__(cls, grouprole, permit, context):
        if permit is None: return None
        obj = object.__new__(cls)
        obj.__init__(grouprole, permit, context)
        return obj

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def delete(self, async=None, correlation_id=None):
        '''
        [@param async: boolean (true|false)]
        [@param correlation_id: any string]

        @return None:
        '''

        url = UrlHelper.replace(
            '/groups/{group:id}/roles/{role:id}/permits/{permit:id}',
            {
                '{group:id}': self.parentclass.parentclass.get_id(),
                '{role:id}': self.parentclass.get_id(),
                '{permit:id}': self.get_id(),
            }
        )

        return self.__getProxy().delete(
            url=UrlHelper.appendParameters(
                url,
                {'async:matrix':async}
            ),
            headers={"Correlation-Id":correlation_id,"Content-type":None}
        )

class GroupRolePermits(Base):

    def __init__(self, role , context):
        Base.__init__(self, context)
        self.parentclass = role

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def add(self, permit, correlation_id=None, expect=None):

        '''
        @type Permit:

        @param permit.id|name: string
        [@param correlation_id: any string]
        [@param expect: 201-created]

        @return Permit:
        '''

        url = '/groups/{group:id}/roles/{role:id}/permits'

        result = self.__getProxy().add(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{group:id}': self.parentclass.parentclass.get_id(),
                        '{role:id}': self.parentclass.get_id(),
                    }
                ),
                args={}
            ),
            body=ParseHelper.toXml(permit),
            headers={"Correlation-Id":correlation_id, "Expect":expect}
        )

        return GroupRolePermit(
            self.parentclass,
            result,
            self.context
        )

    def get(self, name=None, id=None):

        '''
        [@param id  : string (the id of the entity)]
        [@param name: string (the name of the entity)]

        @return Permits:
        '''

        url = '/groups/{group:id}/roles/{role:id}/permits'

        if id:
            try :
                result = self.__getProxy().get(
                    url=UrlHelper.append(
                        UrlHelper.replace(
                            url,
                            {
                                '{group:id}': self.parentclass.parentclass.get_id(),
                                '{role:id}': self.parentclass.get_id(),
                            }
                        ),
                        id
                    ),
                    headers={}
                )

                return GroupRolePermit(
                    self.parentclass,
                    result,
                    self.context
                )
            except RequestError as err:
                if err.status and err.status == 404:
                    return None
                raise err
        elif name:
            result = self.__getProxy().get(
                url=UrlHelper.replace(
                    url,
                    {
                        '{group:id}': self.parentclass.parentclass.get_id(),
                        '{role:id}': self.parentclass.get_id(),
                    }
                ),
                headers={}
            ).get_permit()

            return GroupRolePermit(
                self.parentclass,
                FilterHelper.getItem(
                    FilterHelper.filter(
                        result,
                        {'name':name}
                    ),
                    query="name=" + name
                ),
                self.context
            )
        else:
            raise MissingParametersError(['id', 'name'])

    def list(self, max=None, **kwargs):
        '''
        [@param **kwargs: dict (property based filtering)"]
        [@param max: int (max results)]

        @return Permits:
        '''

        url = '/groups/{group:id}/roles/{role:id}/permits'

        result = self.__getProxy().get(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{group:id}': self.parentclass.parentclass.get_id(),
                        '{role:id}': self.parentclass.get_id(),
                    }
                ),
                args={'max:matrix':max}
            ),
            headers={}
        ).get_permit()

        return ParseHelper.toSubCollection(
            GroupRolePermit,
            self.parentclass,
            FilterHelper.filter(
                result,
                kwargs
            ),
            context=self.context
        )

class GroupRoles(Base):

    def __init__(self, group , context):
        Base.__init__(self, context)
        self.parentclass = group

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def get(self, name=None, id=None):

        '''
        [@param id  : string (the id of the entity)]
        [@param name: string (the name of the entity)]

        @return Roles:
        '''

        url = '/groups/{group:id}/roles'

        if id:
            try :
                result = self.__getProxy().get(
                    url=UrlHelper.append(
                        UrlHelper.replace(
                            url,
                            {
                                '{group:id}': self.parentclass.get_id(),
                            }
                        ),
                        id
                    ),
                    headers={}
                )

                return GroupRole(
                    self.parentclass,
                    result,
                    self.context
                )
            except RequestError as err:
                if err.status and err.status == 404:
                    return None
                raise err
        elif name:
            result = self.__getProxy().get(
                url=UrlHelper.replace(
                    url,
                    {
                        '{group:id}': self.parentclass.get_id(),
                    }
                ),
                headers={}
            ).get_role()

            return GroupRole(
                self.parentclass,
                FilterHelper.getItem(
                    FilterHelper.filter(
                        result,
                        {'name':name}
                    ),
                    query="name=" + name
                ),
                self.context
            )
        else:
            raise MissingParametersError(['id', 'name'])

    def list(self, max=None, **kwargs):
        '''
        [@param **kwargs: dict (property based filtering)"]
        [@param max: int (max results)]

        @return Roles:
        '''

        url = '/groups/{group:id}/roles'

        result = self.__getProxy().get(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{group:id}': self.parentclass.get_id(),
                    }
                ),
                args={'max:matrix':max}
            ),
            headers={}
        ).get_role()

        return ParseHelper.toSubCollection(
            GroupRole,
            self.parentclass,
            FilterHelper.filter(
                result,
                kwargs
            ),
            context=self.context
        )

class GroupTag(params.Tag, Base):
    def __init__(self, group, tag, context):
        Base.__init__(self, context)
        self.parentclass = group
        self.superclass  =  tag

        #SUB_COLLECTIONS
    def __new__(cls, group, tag, context):
        if tag is None: return None
        obj = object.__new__(cls)
        obj.__init__(group, tag, context)
        return obj

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def delete(self, async=None, correlation_id=None):
        '''
        [@param async: boolean (true|false)]
        [@param correlation_id: any string]

        @return None:
        '''

        url = UrlHelper.replace(
            '/groups/{group:id}/tags/{tag:id}',
            {
                '{group:id}': self.parentclass.get_id(),
                '{tag:id}': self.get_id(),
            }
        )

        return self.__getProxy().delete(
            url=UrlHelper.appendParameters(
                url,
                {'async:matrix':async}
            ),
            headers={"Correlation-Id":correlation_id,"Content-type":None}
        )

class GroupTags(Base):

    def __init__(self, group , context):
        Base.__init__(self, context)
        self.parentclass = group

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def add(self, tag, correlation_id=None, expect=None):

        '''
        @type Tag:

        @param tag.id|name: string
        [@param correlation_id: any string]
        [@param expect: 201-created]

        @return Tag:
        '''

        url = '/groups/{group:id}/tags'

        result = self.__getProxy().add(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{group:id}': self.parentclass.get_id(),
                    }
                ),
                args={}
            ),
            body=ParseHelper.toXml(tag),
            headers={"Correlation-Id":correlation_id, "Expect":expect}
        )

        return GroupTag(
            self.parentclass,
            result,
            self.context
        )

    def get(self, name=None, id=None):

        '''
        [@param id  : string (the id of the entity)]
        [@param name: string (the name of the entity)]

        @return Tags:
        '''

        url = '/groups/{group:id}/tags'

        if id:
            try :
                result = self.__getProxy().get(
                    url=UrlHelper.append(
                        UrlHelper.replace(
                            url,
                            {
                                '{group:id}': self.parentclass.get_id(),
                            }
                        ),
                        id
                    ),
                    headers={}
                )

                return GroupTag(
                    self.parentclass,
                    result,
                    self.context
                )
            except RequestError as err:
                if err.status and err.status == 404:
                    return None
                raise err
        elif name:
            result = self.__getProxy().get(
                url=UrlHelper.replace(
                    url,
                    {
                        '{group:id}': self.parentclass.get_id(),
                    }
                ),
                headers={}
            ).get_tag()

            return GroupTag(
                self.parentclass,
                FilterHelper.getItem(
                    FilterHelper.filter(
                        result,
                        {'name':name}
                    ),
                    query="name=" + name
                ),
                self.context
            )
        else:
            raise MissingParametersError(['id', 'name'])

    def list(self, max=None, **kwargs):
        '''
        [@param **kwargs: dict (property based filtering)"]
        [@param max: int (max results)]

        @return Tags:
        '''

        url = '/groups/{group:id}/tags'

        result = self.__getProxy().get(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{group:id}': self.parentclass.get_id(),
                    }
                ),
                args={'max:matrix':max}
            ),
            headers={}
        ).get_tag()

        return ParseHelper.toSubCollection(
            GroupTag,
            self.parentclass,
            FilterHelper.filter(
                result,
                kwargs
            ),
            context=self.context
        )

class Groups(Base):
    def __init__(self, context):
        Base.__init__(self, context)

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def add(self, group, correlation_id=None, expect=None):
        '''
        @type Group:

        @param group.name: string
        [@param group.namespace: string]
        [@param group.principal: string]
        [@param correlation_id: any string]
        [@param expect: 201-created]

        @return Group:
        '''

        url = '/groups'

        result = self.__getProxy().add(
           url=UrlHelper.appendParameters(
                url=url,
                args={}
           ),
           body=ParseHelper.toXml(group),
           headers={"Correlation-Id":correlation_id, "Expect":expect}
        )

        return Group(result, self.context)

    def get(self, name=None, id=None):
        '''
        [@param id  : string (the id of the entity)]
        [@param name: string (the name of the entity)]

        @return Groups:
        '''

        url = '/groups'

        if id:
            try :
                return Group(
                    self.__getProxy().get(
                        url=UrlHelper.append(url, id),
                        headers={}
                    ),
                    self.context
                )
            except RequestError as err:
                if err.status and err.status == 404:
                    return None
                raise err
        elif name:
            result = self.__getProxy().get(
                url=UrlHelper.appendParameters(url, {'search:query':'name='+name}),
                headers={}
            ).get_group()

            return Group(
                FilterHelper.getItem(
                    FilterHelper.filter(result, {'name':name}),
                    query="name=" + name
                ),
                self.context
            )
        else:
            raise MissingParametersError(['id', 'name'])

    def list(self, query=None, case_sensitive=True, max=None, **kwargs):
        '''
        [@param **kwargs: dict (property based filtering)]
        [@param query: string (oVirt engine search dialect query)]
        [@param case_sensitive: boolean (true|false)]
        [@param max: int (max results)]

        @return Groups:
        '''

        url='/groups'

        result = self.__getProxy().get(
            url=UrlHelper.appendParameters(url, {'search:query':query,'case_sensitive:matrix':case_sensitive,'max:matrix':max}),
            headers={}
        ).get_group()

        return ParseHelper.toCollection(
            Group,
            FilterHelper.filter(result, kwargs),
            context=self.context
        )

class Host(params.Host, Base):
    def __init__(self, host, context):
        Base.__init__(self, context)
        self.superclass = host

        self.devices = HostHostDevices(self, context)
        self.fenceagents = HostAgents(self, context)
        self.hooks = HostHooks(self, context)
        self.katelloerrata = HostKatelloErrata(self, context)
        self.networkattachments = HostNetworkAttachments(self, context)
        self.nics = HostNICs(self, context)
        self.numanodes = HostNumaNodes(self, context)
        self.permissions = HostPermissions(self, context)
        self.statistics = HostStatistics(self, context)
        self.storage = HostStorages(self, context)
        self.storageconnectionextensions = HostStorageConnectionExtensions(self, context)
        self.tags = HostTags(self, context)
        self.unmanagednetworks = HostUnmanagedNetworks(self, context)

    def __new__(cls, host, context):
        if host is None: return None
        obj = object.__new__(cls)
        obj.__init__(host, context)
        return obj

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def delete(self, action=params.Action(), async=None, correlation_id=None):
        '''
        @type Action:

        [@param action.async: boolean]
        [@param action.grace_period.expiry: long]
        [@param correlation_id: any string]

        @return None:
        '''

        url = UrlHelper.replace(
            '/hosts/{host:id}',
            {
                '{host:id}': self.get_id(),
            }
        )

        return self.__getProxy().delete(
            url=UrlHelper.appendParameters(
                url,
                {'async:matrix':async}
            ),
            body=ParseHelper.toXml(action),
            headers={"Correlation-Id":correlation_id}
        )

    def update(self, correlation_id=None, expect=None):
        '''
        Overload 1:
          [@param host.name: string]
          [@param host.comment: string]
          [@param host.address: string]
          [@param host.root_password: string]
          [@param host.display.address: string]
          [@param host.cluster.id|name: string]
          [@param host.port: int]
          [@param host.spm.priority: int]
          [@param host.power_management.type: string]
          [@param host.power_management.enabled: boolean]
          [@param host.power_management.address: string]
          [@param host.power_management.username: string]
          [@param host.power_management.password: string]
          [@param host.power_management.automatic_pm_enabled: boolean]
          [@param host.power_management.options.option: collection]
          {
            [@ivar option.name: string]
            [@ivar option.value: string]
          }
          [@param host.power_management.pm_proxy: collection]
          {
            [@ivar propietary: string]
          }
          [@param host.power_management.agents.agent: collection]
          {
            [@ivar type: string]
            [@ivar address: string]
            [@ivar username: string]
            [@ivar password: string]
            [@ivar options.option: collection]
            {
              [@param option.name: string]
              [@param option.value: string]
            }
            [@ivar encrypt_options: boolean]
          }
          [@param host.power_management.kdump_detection: boolean]
          [@param host.external_host_provider.id: string]
        Overload 2:
          [@param host.name: string]
          [@param host.comment: string]
          [@param host.address: string]
          [@param host.ssh.port: int]
          [@param host.ssh.user.user_name: string]
          [@param host.ssh.fingerprint: string]
          [@param host.display.address: string]
          [@param host.cluster.id|name: string]
          [@param host.port: int]
          [@param host.spm.priority: int]
          [@param host.power_management.type: string]
          [@param host.power_management.automatic_pm_enabled: boolean]
          [@param host.power_management.enabled: boolean]
          [@param host.power_management.address: string]
          [@param host.power_management.username: string]
          [@param host.power_management.password: string]
          [@param host.power_management.options.option: collection]
          {
            [@ivar option.name: string]
            [@ivar option.value: string]
          }
          [@param host.power_management.pm_proxy: collection]
          {
            [@ivar propietary: string]
          }
          [@param host.power_management.agents.agent: collection]
          {
            [@ivar type: string]
            [@ivar address: string]
            [@ivar username: string]
            [@ivar password: string]
            [@ivar options.option: collection]
            {
              [@param option.name: string]
              [@param option.value: string]
            }
            [@ivar encrypt_options: boolean]
          }
          [@param host.power_management.kdump_detection: boolean]
        [@param correlation_id: any string]
        [@param expect: 202-accepted]

        @return Host:
        '''

        url = '/hosts/{host:id}'

        result = self.__getProxy().update(
            url=UrlHelper.replace(
                url,
                {
                    '{host:id}': self.get_id(),
                }
            ),
            body=ParseHelper.toXml(self.superclass),
            headers={"Correlation-Id":correlation_id, "Expect":expect}
        )

        return Host(result, self.context)

    def activate(self, action=params.Action(), correlation_id=None):
        '''
        @type Action:

        [@param action.async: boolean]
        [@param action.grace_period.expiry: long]
        [@param correlation_id: any string]

        @return Action:
        '''

        url = '/hosts/{host:id}/activate'

        result = self.__getProxy().request(
            method='POST',
            url=UrlHelper.replace(
                url,
                {
                    '{host:id}': self.get_id(),
                }
            ),
            body=ParseHelper.toXml(action),
            headers={"Correlation-Id":correlation_id}
        )

        return result

    def approve(self, action=params.Action(), correlation_id=None):
        '''
        @type Action:

        Overload 1:
          [@param action.cluster.id|name: string]
          [@param host.root_password: string]
          [@param action.async: boolean]
          [@param action.grace_period.expiry: long]
        Overload 2:
          [@param action.cluster.id|name: string]
          [@param host.ssh.authentication_method: string]
          [@param host.ssh.user.user_name: string]
          [@param host.ssh.user.password: string]
          [@param action.async: boolean]
          [@param action.grace_period.expiry: long]
        [@param correlation_id: any string]

        @return Action:
        '''

        url = '/hosts/{host:id}/approve'

        result = self.__getProxy().request(
            method='POST',
            url=UrlHelper.replace(
                url,
                {
                    '{host:id}': self.get_id(),
                }
            ),
            body=ParseHelper.toXml(action),
            headers={"Correlation-Id":correlation_id}
        )

        return result

    def commitnetconfig(self, action=params.Action(), correlation_id=None):
        '''
        @type Action:

        [@param action.async: boolean]
        [@param action.grace_period.expiry: long]
        [@param correlation_id: any string]

        @return Action:
        '''

        url = '/hosts/{host:id}/commitnetconfig'

        result = self.__getProxy().request(
            method='POST',
            url=UrlHelper.replace(
                url,
                {
                    '{host:id}': self.get_id(),
                }
            ),
            body=ParseHelper.toXml(action),
            headers={"Correlation-Id":correlation_id}
        )

        return result

    def deactivate(self, action=params.Action(), correlation_id=None):
        '''
        @type Action:

        [@param action.reason: string]
        [@param action.async: boolean]
        [@param action.grace_period.expiry: long]
        [@param correlation_id: any string]

        @return Action:
        '''

        url = '/hosts/{host:id}/deactivate'

        result = self.__getProxy().request(
            method='POST',
            url=UrlHelper.replace(
                url,
                {
                    '{host:id}': self.get_id(),
                }
            ),
            body=ParseHelper.toXml(action),
            headers={"Correlation-Id":correlation_id}
        )

        return result

    def enrollcertificate(self, action=params.Action(), correlation_id=None):
        '''
        @type Action:

        [@param correlation_id: any string]

        @return Action:
        '''

        url = '/hosts/{host:id}/enrollcertificate'

        result = self.__getProxy().request(
            method='POST',
            url=UrlHelper.replace(
                url,
                {
                    '{host:id}': self.get_id(),
                }
            ),
            body=ParseHelper.toXml(action),
            headers={"Correlation-Id":correlation_id}
        )

        return result

    def fence(self, action=params.Action(), correlation_id=None):
        '''
        @type Action:

        @param action.fence_type: string
        [@param action.async: boolean]
        [@param action.grace_period.expiry: long]
        [@param correlation_id: any string]

        @return Action:
        '''

        url = '/hosts/{host:id}/fence'

        result = self.__getProxy().request(
            method='POST',
            url=UrlHelper.replace(
                url,
                {
                    '{host:id}': self.get_id(),
                }
            ),
            body=ParseHelper.toXml(action),
            headers={"Correlation-Id":correlation_id}
        )

        return result

    def forceselectspm(self, action=params.Action(), correlation_id=None):
        '''
        @type Action:

        [@param action.async: boolean]
        [@param action.grace_period.expiry: long]
        [@param correlation_id: any string]

        @return Action:
        '''

        url = '/hosts/{host:id}/forceselectspm'

        result = self.__getProxy().request(
            method='POST',
            url=UrlHelper.replace(
                url,
                {
                    '{host:id}': self.get_id(),
                }
            ),
            body=ParseHelper.toXml(action),
            headers={"Correlation-Id":correlation_id}
        )

        return result

    def install(self, action=params.Action(), correlation_id=None):
        '''
        @type Action:

        Overload 1:
          [@param action.root_password: string]
          [@param action.image: string]
          [@param action.host.override_iptables: boolean]
          [@param action.async: boolean]
          [@param action.grace_period.expiry: long]
        Overload 2:
          [@param action.ssh.port: int]
          [@param action.ssh.fingerprint: string]
          [@param action.ssh.authentication_method: string]
          [@param action.ssh.user.user_name: string]
          [@param action.ssh.user.password: string]
          [@param action.image: string]
          [@param action.host.override_iptables: boolean]
          [@param action.async: boolean]
          [@param action.grace_period.expiry: long]
        [@param correlation_id: any string]

        @return Action:
        '''

        url = '/hosts/{host:id}/install'

        result = self.__getProxy().request(
            method='POST',
            url=UrlHelper.replace(
                url,
                {
                    '{host:id}': self.get_id(),
                }
            ),
            body=ParseHelper.toXml(action),
            headers={"Correlation-Id":correlation_id}
        )

        return result

    def iscsidiscover(self, action=params.Action(), correlation_id=None):
        '''
        @type Action:

        @param action.iscsi.address: string
        [@param action.async: boolean]
        [@param action.grace_period.expiry: long]
        [@param correlation_id: any string]

        @return Action:
        '''

        url = '/hosts/{host:id}/iscsidiscover'

        result = self.__getProxy().request(
            method='POST',
            url=UrlHelper.replace(
                url,
                {
                    '{host:id}': self.get_id(),
                }
            ),
            body=ParseHelper.toXml(action),
            headers={"Correlation-Id":correlation_id}
        )

        return result

    def iscsilogin(self, action=params.Action(), correlation_id=None):
        '''
        @type Action:

        @param action.iscsi.address: string
        @param action.iscsi.target: string
        [@param action.async: boolean]
        [@param action.grace_period.expiry: long]
        [@param correlation_id: any string]

        @return Action:
        '''

        url = '/hosts/{host:id}/iscsilogin'

        result = self.__getProxy().request(
            method='POST',
            url=UrlHelper.replace(
                url,
                {
                    '{host:id}': self.get_id(),
                }
            ),
            body=ParseHelper.toXml(action),
            headers={"Correlation-Id":correlation_id}
        )

        return result

    def refresh(self, action=params.Action(), correlation_id=None):
        '''
        @type Action:

        [@param action.async: boolean]
        [@param action.grace_period.expiry: long]
        [@param correlation_id: any string]

        @return Action:
        '''

        url = '/hosts/{host:id}/refresh'

        result = self.__getProxy().request(
            method='POST',
            url=UrlHelper.replace(
                url,
                {
                    '{host:id}': self.get_id(),
                }
            ),
            body=ParseHelper.toXml(action),
            headers={"Correlation-Id":correlation_id}
        )

        return result

    def setupnetworks(self, action=params.Action(), correlation_id=None):
        '''
        @type Action:

        [@param action.modified_network_attachments.network_attachment: collection]
        {
          [@ivar network_attachment.id: string]
          [@ivar network_attachment.network.name|id: string]
          [@ivar network_attachment.host_nic.name|id: string]
          [@ivar network_attachment.ip_address_assignments.ip_address_assignment: collection]
          {
            [@param ip_address_assignment.assignment_method: string]
            [@param ip_address_assignment.ip.address: string]
            [@param ip_address_assignment.ip.netmask: string]
            [@param ip_address_assignment.ip.gateawy: string]
          }
          [@ivar network_attachment.properties.property: collection]
          {
            [@param property.name: string]
            [@param property.value: string]
          }
        }
        [@param action.removed_network_attachments.network_attachment: collection]
        {
          [@ivar network_attachment.id: string]
        }
        [@param action.modified_bonds.host_nic: collection]
        {
          [@ivar host_nic.name|id: string]
          [@ivar host_nic.bonding.options.option: collection]
          {
            [@param option.name: string]
            [@param option.value: string]
            [@param option.type: string]
          }
          [@ivar bonding.slaves.host_nic: collection]
          {
            [@param host_nic.name|id: string]
          }
        }
        [@param action.removed_bonds.host_nic: collection]
        {
          [@ivar host_nic.name|id: string]
        }
        [@param action.synchronized_network_attachments.network_attachment: collection]
        {
          [@ivar network_attachment.id: string]
        }
        [@param action.modified_labels.label: collection]
        {
          [@ivar label.host_nic.name|id: string]
          [@ivar label.id: string]
        }
        [@param action.removed_labels.label: collection]
        {
          [@ivar label.id: string]
        }
        [@param action.check_connectivity: boolean]
        [@param action.connectivity_timeout: int]
        [@param action.async: boolean]
        [@param action.grace_period.expiry: long]
        [@param correlation_id: any string]

        @return Action:
        '''

        url = '/hosts/{host:id}/setupnetworks'

        result = self.__getProxy().request(
            method='POST',
            url=UrlHelper.replace(
                url,
                {
                    '{host:id}': self.get_id(),
                }
            ),
            body=ParseHelper.toXml(action),
            headers={"Correlation-Id":correlation_id}
        )

        return result

    def unregisteredstoragedomainsdiscover(self, action=params.Action(), correlation_id=None):
        '''
        @type Action:

        [@param action.iscsi.address: string]
        [@param action.iscsi_target: string]
        [@param action.async: boolean]
        [@param action.grace_period.expiry: long]
        [@param correlation_id: any string]

        @return Action:
        '''

        url = '/hosts/{host:id}/unregisteredstoragedomainsdiscover'

        result = self.__getProxy().request(
            method='POST',
            url=UrlHelper.replace(
                url,
                {
                    '{host:id}': self.get_id(),
                }
            ),
            body=ParseHelper.toXml(action),
            headers={"Correlation-Id":correlation_id}
        )

        return result

    def upgrade(self, action=params.Action(), correlation_id=None):
        '''
        @type Action:

        [@param action.image: string]
        [@param action.async: boolean]
        [@param action.grace_period.expiry: long]
        [@param correlation_id: any string]

        @return Action:
        '''

        url = '/hosts/{host:id}/upgrade'

        result = self.__getProxy().request(
            method='POST',
            url=UrlHelper.replace(
                url,
                {
                    '{host:id}': self.get_id(),
                }
            ),
            body=ParseHelper.toXml(action),
            headers={"Correlation-Id":correlation_id}
        )

        return result

class HostAgent(params.Agent, Base):
    def __init__(self, host, agent, context):
        Base.__init__(self, context)
        self.parentclass = host
        self.superclass  =  agent

        #SUB_COLLECTIONS
    def __new__(cls, host, agent, context):
        if agent is None: return None
        obj = object.__new__(cls)
        obj.__init__(host, agent, context)
        return obj

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def delete(self, async=None, correlation_id=None):
        '''
        [@param async: boolean (true|false)]
        [@param correlation_id: any string]

        @return None:
        '''

        url = UrlHelper.replace(
            '/hosts/{host:id}/fenceagents/{fenceagent:id}',
            {
                '{host:id}': self.parentclass.get_id(),
                '{fenceagent:id}': self.get_id(),
            }
        )

        return self.__getProxy().delete(
            url=UrlHelper.appendParameters(
                url,
                {'async:matrix':async}
            ),
            headers={"Correlation-Id":correlation_id,"Content-type":None}
        )

    def update(self, async=None, correlation_id=None, expect=None):
        '''
        [@param agent.address: string]
        [@param agent.order: int]
        [@param agent.type: string]
        [@param agent.username: string]
        [@param agent.password: string]
        [@param agent.port: int]
        [@param agent.options: collection]
        {
          [@ivar option.name: string]
          [@ivar option.value: string]
        }
        [@param encrypt_options: boolean]
        [@param async: boolean (true|false)]
        [@param correlation_id: any string]
        [@param expect: 202-accepted]

        @return Agent:
        '''

        url = '/hosts/{host:id}/fenceagents/{fenceagent:id}'
        url = UrlHelper.replace(
            url,
            {
                '{host:id}': self.parentclass.get_id(),
                '{fenceagent:id}': self.get_id(),
            }
        )

        result = self.__getProxy().update(
            url=UrlHelper.appendParameters(url, {'async:matrix':async}),
            body=ParseHelper.toXml(self.superclass),
            headers={"Correlation-Id":correlation_id, "Expect":expect}
        )

        return HostAgent(
            self.parentclass,
            result,
            self.context
        )

class HostAgents(Base):

    def __init__(self, host , context):
        Base.__init__(self, context)
        self.parentclass = host

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def add(self, agent, correlation_id=None, expect=None):

        '''
        @type Agent:

        @param agent.address: string
        @param agent.order: int
        @param agent.type: string
        @param agent.username: string
        @param agent.password: string
        [@param agent.port: int]
        [@param agent.options: collection]
        {
          [@ivar option.name: string]
          [@ivar option.value: string]
        }
        [@param encrypt_options: boolean]
        [@param correlation_id: any string]
        [@param expect: 201-created]

        @return Agent:
        '''

        url = '/hosts/{host:id}/fenceagents'

        result = self.__getProxy().add(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{host:id}': self.parentclass.get_id(),
                    }
                ),
                args={}
            ),
            body=ParseHelper.toXml(agent),
            headers={"Correlation-Id":correlation_id, "Expect":expect}
        )

        return HostAgent(
            self.parentclass,
            result,
            self.context
        )

    def get(self, name=None, id=None):

        '''
        [@param id  : string (the id of the entity)]
        [@param name: string (the name of the entity)]

        @return Agents:
        '''

        url = '/hosts/{host:id}/fenceagents'

        if id:
            try :
                result = self.__getProxy().get(
                    url=UrlHelper.append(
                        UrlHelper.replace(
                            url,
                            {
                                '{host:id}': self.parentclass.get_id(),
                            }
                        ),
                        id
                    ),
                    headers={}
                )

                return HostAgent(
                    self.parentclass,
                    result,
                    self.context
                )
            except RequestError as err:
                if err.status and err.status == 404:
                    return None
                raise err
        elif name:
            result = self.__getProxy().get(
                url=UrlHelper.replace(
                    url,
                    {
                        '{host:id}': self.parentclass.get_id(),
                    }
                ),
                headers={}
            ).get_agent()

            return HostAgent(
                self.parentclass,
                FilterHelper.getItem(
                    FilterHelper.filter(
                        result,
                        {'name':name}
                    ),
                    query="name=" + name
                ),
                self.context
            )
        else:
            raise MissingParametersError(['id', 'name'])

    def list(self, max=None, **kwargs):
        '''
        [@param **kwargs: dict (property based filtering)"]
        [@param max: int (max results)]

        @return Agents:
        '''

        url = '/hosts/{host:id}/fenceagents'

        result = self.__getProxy().get(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{host:id}': self.parentclass.get_id(),
                    }
                ),
                args={'max:matrix':max}
            ),
            headers={}
        ).get_agent()

        return ParseHelper.toSubCollection(
            HostAgent,
            self.parentclass,
            FilterHelper.filter(
                result,
                kwargs
            ),
            context=self.context
        )

class HostHook(params.Hook, Base):
    def __init__(self, host, hook, context):
        Base.__init__(self, context)
        self.parentclass = host
        self.superclass  =  hook

        #SUB_COLLECTIONS
    def __new__(cls, host, hook, context):
        if hook is None: return None
        obj = object.__new__(cls)
        obj.__init__(host, hook, context)
        return obj

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

class HostHooks(Base):

    def __init__(self, host , context):
        Base.__init__(self, context)
        self.parentclass = host

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def get(self, name=None, id=None):

        '''
        [@param id  : string (the id of the entity)]
        [@param name: string (the name of the entity)]

        @return Hooks:
        '''

        url = '/hosts/{host:id}/hooks'

        if id:
            try :
                result = self.__getProxy().get(
                    url=UrlHelper.append(
                        UrlHelper.replace(
                            url,
                            {
                                '{host:id}': self.parentclass.get_id(),
                            }
                        ),
                        id
                    ),
                    headers={}
                )

                return HostHook(
                    self.parentclass,
                    result,
                    self.context
                )
            except RequestError as err:
                if err.status and err.status == 404:
                    return None
                raise err
        elif name:
            result = self.__getProxy().get(
                url=UrlHelper.replace(
                    url,
                    {
                        '{host:id}': self.parentclass.get_id(),
                    }
                ),
                headers={}
            ).get_hook()

            return HostHook(
                self.parentclass,
                FilterHelper.getItem(
                    FilterHelper.filter(
                        result,
                        {'name':name}
                    ),
                    query="name=" + name
                ),
                self.context
            )
        else:
            raise MissingParametersError(['id', 'name'])

    def list(self, max=None, **kwargs):
        '''
        [@param **kwargs: dict (property based filtering)"]
        [@param max: int (max results)]

        @return Hooks:
        '''

        url = '/hosts/{host:id}/hooks'

        result = self.__getProxy().get(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{host:id}': self.parentclass.get_id(),
                    }
                ),
                args={'max:matrix':max}
            ),
            headers={}
        ).get_hook()

        return ParseHelper.toSubCollection(
            HostHook,
            self.parentclass,
            FilterHelper.filter(
                result,
                kwargs
            ),
            context=self.context
        )

class HostHostDevice(params.HostDevice, Base):
    def __init__(self, host, hostdevice, context):
        Base.__init__(self, context)
        self.parentclass = host
        self.superclass  =  hostdevice

        #SUB_COLLECTIONS
    def __new__(cls, host, hostdevice, context):
        if hostdevice is None: return None
        obj = object.__new__(cls)
        obj.__init__(host, hostdevice, context)
        return obj

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

class HostHostDevices(Base):

    def __init__(self, host , context):
        Base.__init__(self, context)
        self.parentclass = host

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def get(self, name=None, id=None):

        '''
        [@param id  : string (the id of the entity)]
        [@param name: string (the name of the entity)]

        @return HostDevices:
        '''

        url = '/hosts/{host:id}/devices'

        if id:
            try :
                result = self.__getProxy().get(
                    url=UrlHelper.append(
                        UrlHelper.replace(
                            url,
                            {
                                '{host:id}': self.parentclass.get_id(),
                            }
                        ),
                        id
                    ),
                    headers={}
                )

                return HostHostDevice(
                    self.parentclass,
                    result,
                    self.context
                )
            except RequestError as err:
                if err.status and err.status == 404:
                    return None
                raise err
        elif name:
            result = self.__getProxy().get(
                url=UrlHelper.replace(
                    url,
                    {
                        '{host:id}': self.parentclass.get_id(),
                    }
                ),
                headers={}
            ).get_host_device()

            return HostHostDevice(
                self.parentclass,
                FilterHelper.getItem(
                    FilterHelper.filter(
                        result,
                        {'name':name}
                    ),
                    query="name=" + name
                ),
                self.context
            )
        else:
            raise MissingParametersError(['id', 'name'])

    def list(self, max=None, **kwargs):
        '''
        [@param **kwargs: dict (property based filtering)"]
        [@param max: int (max results)]

        @return HostDevices:
        '''

        url = '/hosts/{host:id}/devices'

        result = self.__getProxy().get(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{host:id}': self.parentclass.get_id(),
                    }
                ),
                args={'max:matrix':max}
            ),
            headers={}
        ).get_host_device()

        return ParseHelper.toSubCollection(
            HostHostDevice,
            self.parentclass,
            FilterHelper.filter(
                result,
                kwargs
            ),
            context=self.context
        )

class HostHostNICLabel(params.Label, Base):
    def __init__(self, hostnic, label, context):
        Base.__init__(self, context)
        self.parentclass = hostnic
        self.superclass  =  label

        #SUB_COLLECTIONS
    def __new__(cls, hostnic, label, context):
        if label is None: return None
        obj = object.__new__(cls)
        obj.__init__(hostnic, label, context)
        return obj

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def delete(self, async=None):
        '''
        [@param async: boolean (true|false)]

        @return None:
        '''

        url = UrlHelper.replace(
            '/hosts/{host:id}/nics/{nic:id}/virtualfunctionallowedlabels/{virtualfunctionallowedlabel:id}',
            {
                '{host:id}': self.parentclass.parentclass.get_id(),
                '{nic:id}': self.parentclass.get_id(),
                '{virtualfunctionallowedlabel:id}': self.get_id(),
            }
        )

        return self.__getProxy().delete(
            url=UrlHelper.appendParameters(
                url,
                {'async:matrix':async}
            ),
            headers={"Content-type":None}
        )

class HostHostNICLabels(Base):

    def __init__(self, hostnic , context):
        Base.__init__(self, context)
        self.parentclass = hostnic

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def add(self, label, correlation_id=None, expect=None):

        '''
        @type Label:

        @param label.id: string
        [@param correlation_id: any string]
        [@param expect: 201-created]

        @return Label:
        '''

        url = '/hosts/{host:id}/nics/{nic:id}/virtualfunctionallowedlabels'

        result = self.__getProxy().add(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{host:id}': self.parentclass.parentclass.get_id(),
                        '{nic:id}': self.parentclass.get_id(),
                    }
                ),
                args={}
            ),
            body=ParseHelper.toXml(label),
            headers={"Correlation-Id":correlation_id, "Expect":expect}
        )

        return HostHostNICLabel(
            self.parentclass,
            result,
            self.context
        )

    def get(self, name=None, id=None):

        '''
        [@param id  : string (the id of the entity)]
        [@param name: string (the name of the entity)]

        @return Labels:
        '''

        url = '/hosts/{host:id}/nics/{nic:id}/virtualfunctionallowedlabels'

        if id:
            try :
                result = self.__getProxy().get(
                    url=UrlHelper.append(
                        UrlHelper.replace(
                            url,
                            {
                                '{host:id}': self.parentclass.parentclass.get_id(),
                                '{nic:id}': self.parentclass.get_id(),
                            }
                        ),
                        id
                    ),
                    headers={}
                )

                return HostHostNICLabel(
                    self.parentclass,
                    result,
                    self.context
                )
            except RequestError as err:
                if err.status and err.status == 404:
                    return None
                raise err
        elif name:
            result = self.__getProxy().get(
                url=UrlHelper.replace(
                    url,
                    {
                        '{host:id}': self.parentclass.parentclass.get_id(),
                        '{nic:id}': self.parentclass.get_id(),
                    }
                ),
                headers={}
            ).get_label()

            return HostHostNICLabel(
                self.parentclass,
                FilterHelper.getItem(
                    FilterHelper.filter(
                        result,
                        {'name':name}
                    ),
                    query="name=" + name
                ),
                self.context
            )
        else:
            raise MissingParametersError(['id', 'name'])

    def list(self, max=None, **kwargs):
        '''
        [@param **kwargs: dict (property based filtering)"]
        [@param max: int (max results)]

        @return Labels:
        '''

        url = '/hosts/{host:id}/nics/{nic:id}/virtualfunctionallowedlabels'

        result = self.__getProxy().get(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{host:id}': self.parentclass.parentclass.get_id(),
                        '{nic:id}': self.parentclass.get_id(),
                    }
                ),
                args={'max:matrix':max}
            ),
            headers={}
        ).get_label()

        return ParseHelper.toSubCollection(
            HostHostNICLabel,
            self.parentclass,
            FilterHelper.filter(
                result,
                kwargs
            ),
            context=self.context
        )

class HostHostNICNetwork(params.Network, Base):
    def __init__(self, hostnic, network, context):
        Base.__init__(self, context)
        self.parentclass = hostnic
        self.superclass  =  network

        #SUB_COLLECTIONS
    def __new__(cls, hostnic, network, context):
        if network is None: return None
        obj = object.__new__(cls)
        obj.__init__(hostnic, network, context)
        return obj

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def delete(self, async=None):
        '''
        [@param async: boolean (true|false)]

        @return None:
        '''

        url = UrlHelper.replace(
            '/hosts/{host:id}/nics/{nic:id}/virtualfunctionallowednetworks/{virtualfunctionallowednetwork:id}',
            {
                '{host:id}': self.parentclass.parentclass.get_id(),
                '{nic:id}': self.parentclass.get_id(),
                '{virtualfunctionallowednetwork:id}': self.get_id(),
            }
        )

        return self.__getProxy().delete(
            url=UrlHelper.appendParameters(
                url,
                {'async:matrix':async}
            ),
            headers={"Content-type":None}
        )

class HostHostNICNetworkAttachment(params.NetworkAttachment, Base):
    def __init__(self, hostnic, networkattachment, context):
        Base.__init__(self, context)
        self.parentclass = hostnic
        self.superclass  =  networkattachment

        #SUB_COLLECTIONS
    def __new__(cls, hostnic, networkattachment, context):
        if networkattachment is None: return None
        obj = object.__new__(cls)
        obj.__init__(hostnic, networkattachment, context)
        return obj

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def delete(self, async=None, correlation_id=None):
        '''
        [@param async: boolean (true|false)]
        [@param correlation_id: any string]

        @return None:
        '''

        url = UrlHelper.replace(
            '/hosts/{host:id}/nics/{nic:id}/networkattachments/{networkattachment:id}',
            {
                '{host:id}': self.parentclass.parentclass.get_id(),
                '{nic:id}': self.parentclass.get_id(),
                '{networkattachment:id}': self.get_id(),
            }
        )

        return self.__getProxy().delete(
            url=UrlHelper.appendParameters(
                url,
                {'async:matrix':async}
            ),
            headers={"Correlation-Id":correlation_id,"Content-type":None}
        )

    def update(self, override_configuration=None, async=None, correlation_id=None, expect=None):
        '''
        [@param network_attachment.ip_address_assignments.ip_address_assignment: collection]
        {
          [@ivar ip_address_assignment.assignment_method: string]
          [@ivar ip_address_assignment.ip.address: string]
          [@ivar ip_address_assignment.ip.netmask: string]
          [@ivar ip_address_assignment.ip.gateawy: string]
        }
        [@param network_attachment.properties.property: collection]
        {
          [@ivar property.name: string]
          [@ivar property.value: string]
        }
        [@param override_configuration: boolean (true|false)]
        [@param async: boolean (true|false)]
        [@param correlation_id: any string]
        [@param expect: 202-accepted]

        @return NetworkAttachment:
        '''

        url = '/hosts/{host:id}/nics/{nic:id}/networkattachments/{networkattachment:id}'
        url = UrlHelper.replace(
            url,
            {
                '{host:id}': self.parentclass.parentclass.get_id(),
                '{nic:id}': self.parentclass.get_id(),
                '{networkattachment:id}': self.get_id(),
            }
        )

        result = self.__getProxy().update(
            url=UrlHelper.appendParameters(url, {'override_configuration:matrix':override_configuration,'async:matrix':async}),
            body=ParseHelper.toXml(self.superclass),
            headers={"Correlation-Id":correlation_id, "Expect":expect}
        )

        return HostHostNICNetworkAttachment(
            self.parentclass,
            result,
            self.context
        )

class HostHostNICNetworkAttachments(Base):

    def __init__(self, hostnic , context):
        Base.__init__(self, context)
        self.parentclass = hostnic

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def add(self, networkattachment, correlation_id=None, expect=None):

        '''
        @type NetworkAttachment:

        @param network_attachment.network.name|id: string
        [@param network_attachment.ip_address_assignments.ip_address_assignment: collection]
        {
          [@ivar ip_address_assignment.assignment_method: string]
          [@ivar ip_address_assignment.ip.address: string]
          [@ivar ip_address_assignment.ip.netmask: string]
          [@ivar ip_address_assignment.ip.gateawy: string]
        }
        [@param network_attachment.properties.property: collection]
        {
          [@ivar property.name: string]
          [@ivar property.value: string]
        }
        [@param correlation_id: any string]
        [@param expect: 201-created]

        @return NetworkAttachment:
        '''

        url = '/hosts/{host:id}/nics/{nic:id}/networkattachments'

        result = self.__getProxy().add(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{host:id}': self.parentclass.parentclass.get_id(),
                        '{nic:id}': self.parentclass.get_id(),
                    }
                ),
                args={}
            ),
            body=ParseHelper.toXml(networkattachment),
            headers={"Correlation-Id":correlation_id, "Expect":expect}
        )

        return HostHostNICNetworkAttachment(
            self.parentclass,
            result,
            self.context
        )

    def get(self, name=None, id=None):

        '''
        [@param id  : string (the id of the entity)]
        [@param name: string (the name of the entity)]

        @return NetworkAttachments:
        '''

        url = '/hosts/{host:id}/nics/{nic:id}/networkattachments'

        if id:
            try :
                result = self.__getProxy().get(
                    url=UrlHelper.append(
                        UrlHelper.replace(
                            url,
                            {
                                '{host:id}': self.parentclass.parentclass.get_id(),
                                '{nic:id}': self.parentclass.get_id(),
                            }
                        ),
                        id
                    ),
                    headers={}
                )

                return HostHostNICNetworkAttachment(
                    self.parentclass,
                    result,
                    self.context
                )
            except RequestError as err:
                if err.status and err.status == 404:
                    return None
                raise err
        elif name:
            result = self.__getProxy().get(
                url=UrlHelper.replace(
                    url,
                    {
                        '{host:id}': self.parentclass.parentclass.get_id(),
                        '{nic:id}': self.parentclass.get_id(),
                    }
                ),
                headers={}
            ).get_network_attachment()

            return HostHostNICNetworkAttachment(
                self.parentclass,
                FilterHelper.getItem(
                    FilterHelper.filter(
                        result,
                        {'name':name}
                    ),
                    query="name=" + name
                ),
                self.context
            )
        else:
            raise MissingParametersError(['id', 'name'])

    def list(self, max=None, **kwargs):
        '''
        [@param **kwargs: dict (property based filtering)"]
        [@param max: int (max results)]

        @return NetworkAttachments:
        '''

        url = '/hosts/{host:id}/nics/{nic:id}/networkattachments'

        result = self.__getProxy().get(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{host:id}': self.parentclass.parentclass.get_id(),
                        '{nic:id}': self.parentclass.get_id(),
                    }
                ),
                args={'max:matrix':max}
            ),
            headers={}
        ).get_network_attachment()

        return ParseHelper.toSubCollection(
            HostHostNICNetworkAttachment,
            self.parentclass,
            FilterHelper.filter(
                result,
                kwargs
            ),
            context=self.context
        )

class HostHostNICNetworks(Base):

    def __init__(self, hostnic , context):
        Base.__init__(self, context)
        self.parentclass = hostnic

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def add(self, network, correlation_id=None, expect=None):

        '''
        @type Network:

        @param network.id|name: string
        [@param correlation_id: any string]
        [@param expect: 201-created]

        @return Network:
        '''

        url = '/hosts/{host:id}/nics/{nic:id}/virtualfunctionallowednetworks'

        result = self.__getProxy().add(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{host:id}': self.parentclass.parentclass.get_id(),
                        '{nic:id}': self.parentclass.get_id(),
                    }
                ),
                args={}
            ),
            body=ParseHelper.toXml(network),
            headers={"Correlation-Id":correlation_id, "Expect":expect}
        )

        return HostHostNICNetwork(
            self.parentclass,
            result,
            self.context
        )

    def get(self, name=None, id=None):

        '''
        [@param id  : string (the id of the entity)]
        [@param name: string (the name of the entity)]

        @return Networks:
        '''

        url = '/hosts/{host:id}/nics/{nic:id}/virtualfunctionallowednetworks'

        if id:
            try :
                result = self.__getProxy().get(
                    url=UrlHelper.append(
                        UrlHelper.replace(
                            url,
                            {
                                '{host:id}': self.parentclass.parentclass.get_id(),
                                '{nic:id}': self.parentclass.get_id(),
                            }
                        ),
                        id
                    ),
                    headers={}
                )

                return HostHostNICNetwork(
                    self.parentclass,
                    result,
                    self.context
                )
            except RequestError as err:
                if err.status and err.status == 404:
                    return None
                raise err
        elif name:
            result = self.__getProxy().get(
                url=UrlHelper.replace(
                    url,
                    {
                        '{host:id}': self.parentclass.parentclass.get_id(),
                        '{nic:id}': self.parentclass.get_id(),
                    }
                ),
                headers={}
            ).get_network()

            return HostHostNICNetwork(
                self.parentclass,
                FilterHelper.getItem(
                    FilterHelper.filter(
                        result,
                        {'name':name}
                    ),
                    query="name=" + name
                ),
                self.context
            )
        else:
            raise MissingParametersError(['id', 'name'])

    def list(self, max=None, **kwargs):
        '''
        [@param **kwargs: dict (property based filtering)"]
        [@param max: int (max results)]

        @return Networks:
        '''

        url = '/hosts/{host:id}/nics/{nic:id}/virtualfunctionallowednetworks'

        result = self.__getProxy().get(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{host:id}': self.parentclass.parentclass.get_id(),
                        '{nic:id}': self.parentclass.get_id(),
                    }
                ),
                args={'max:matrix':max}
            ),
            headers={}
        ).get_network()

        return ParseHelper.toSubCollection(
            HostHostNICNetwork,
            self.parentclass,
            FilterHelper.filter(
                result,
                kwargs
            ),
            context=self.context
        )

class HostKatelloErrata(Base):

    def __init__(self, host , context):
        Base.__init__(self, context)
        self.parentclass = host

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def get(self, name=None, id=None):

        '''
        [@param id  : string (the id of the entity)]
        [@param name: string (the name of the entity)]

        @return KatelloErrata:
        '''

        url = '/hosts/{host:id}/katelloerrata'

        if id:
            try :
                result = self.__getProxy().get(
                    url=UrlHelper.append(
                        UrlHelper.replace(
                            url,
                            {
                                '{host:id}': self.parentclass.get_id(),
                            }
                        ),
                        id
                    ),
                    headers={}
                )

                return HostKatelloErratum(
                    self.parentclass,
                    result,
                    self.context
                )
            except RequestError as err:
                if err.status and err.status == 404:
                    return None
                raise err
        elif name:
            result = self.__getProxy().get(
                url=UrlHelper.replace(
                    url,
                    {
                        '{host:id}': self.parentclass.get_id(),
                    }
                ),
                headers={}
            ).get_katello_erratum()

            return HostKatelloErratum(
                self.parentclass,
                FilterHelper.getItem(
                    FilterHelper.filter(
                        result,
                        {'name':name}
                    ),
                    query="name=" + name
                ),
                self.context
            )
        else:
            raise MissingParametersError(['id', 'name'])

    def list(self, max=None, **kwargs):
        '''
        [@param **kwargs: dict (property based filtering)"]
        [@param max: int (max results)]

        @return KatelloErrata:
        '''

        url = '/hosts/{host:id}/katelloerrata'

        result = self.__getProxy().get(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{host:id}': self.parentclass.get_id(),
                    }
                ),
                args={'max:matrix':max}
            ),
            headers={}
        ).get_katello_erratum()

        return ParseHelper.toSubCollection(
            HostKatelloErratum,
            self.parentclass,
            FilterHelper.filter(
                result,
                kwargs
            ),
            context=self.context
        )

class HostKatelloErratum(params.KatelloErratum, Base):
    def __init__(self, host, katelloerratum, context):
        Base.__init__(self, context)
        self.parentclass = host
        self.superclass  =  katelloerratum

        #SUB_COLLECTIONS
    def __new__(cls, host, katelloerratum, context):
        if katelloerratum is None: return None
        obj = object.__new__(cls)
        obj.__init__(host, katelloerratum, context)
        return obj

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

class HostNIC(params.HostNIC, Base):
    def __init__(self, host, hostnic, context):
        Base.__init__(self, context)
        self.parentclass = host
        self.superclass  =  hostnic

        self.labels = HostNICLabels(self, context)
        self.networkattachments = HostHostNICNetworkAttachments(self, context)
        self.statistics = HostNICStatistics(self, context)
        self.virtualfunctionallowedlabels = HostHostNICLabels(self, context)
        self.virtualfunctionallowednetworks = HostHostNICNetworks(self, context)

    def __new__(cls, host, hostnic, context):
        if hostnic is None: return None
        obj = object.__new__(cls)
        obj.__init__(host, hostnic, context)
        return obj

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def delete(self, async=None, correlation_id=None):
        '''
        [@param async: boolean (true|false)]
        [@param correlation_id: any string]

        @return None:
        '''

        url = UrlHelper.replace(
            '/hosts/{host:id}/nics/{nic:id}',
            {
                '{host:id}': self.parentclass.get_id(),
                '{nic:id}': self.get_id(),
            }
        )

        return self.__getProxy().delete(
            url=UrlHelper.appendParameters(
                url,
                {'async:matrix':async}
            ),
            headers={"Correlation-Id":correlation_id,"Content-type":None}
        )

    def update(self, async=None, correlation_id=None, expect=None):
        '''
        [@param hostnic.bonding.slaves.host_nic: collection]
        {
          [@ivar host_nic.id|name: string]
        }
        [@param hostnic.network.id|name: string]
        [@param hostnic.name: string]
        [@param hostnic.bonding.options.option: collection]
        {
          [@ivar option.name: string]
          [@ivar option.value: string]
          [@ivar type: string]
        }
        [@param hostnic.ip.gateway: string]
        [@param hostnic.boot_protocol: string]
        [@param hostnic.mac: string]
        [@param hostnic.ip.address: string]
        [@param hostnic.ip.netmask: string]
        [@param async: boolean (true|false)]
        [@param correlation_id: any string]
        [@param expect: 202-accepted]

        @return HostNIC:
        '''

        url = '/hosts/{host:id}/nics/{nic:id}'
        url = UrlHelper.replace(
            url,
            {
                '{host:id}': self.parentclass.get_id(),
                '{nic:id}': self.get_id(),
            }
        )

        result = self.__getProxy().update(
            url=UrlHelper.appendParameters(url, {'async:matrix':async}),
            body=ParseHelper.toXml(self.superclass),
            headers={"Correlation-Id":correlation_id, "Expect":expect}
        )

        return HostNIC(
            self.parentclass,
            result,
            self.context
        )

    def attach(self, action=params.Action(), correlation_id=None):
        '''
        @type Action:

        @param action.network.id|name: string
        [@param action.async: boolean]
        [@param action.grace_period.expiry: long]
        [@param correlation_id: any string]

        @return Action:
        '''

        url = '/hosts/{host:id}/nics/{nic:id}/attach'

        result = self.__getProxy().request(
            method='POST',
            url=UrlHelper.replace(
                url,
                {
                    '{host:id}': self.parentclass.get_id(),
                    '{nic:id}': self.get_id(),
                }
            ),
            body=ParseHelper.toXml(action),
            headers={"Correlation-Id":correlation_id}
        )

        return result

    def detach(self, action=params.Action(), correlation_id=None):
        '''
        @type Action:

        [@param action.async: boolean]
        [@param action.grace_period.expiry: long]
        [@param correlation_id: any string]

        @return Action:
        '''

        url = '/hosts/{host:id}/nics/{nic:id}/detach'

        result = self.__getProxy().request(
            method='POST',
            url=UrlHelper.replace(
                url,
                {
                    '{host:id}': self.parentclass.get_id(),
                    '{nic:id}': self.get_id(),
                }
            ),
            body=ParseHelper.toXml(action),
            headers={"Correlation-Id":correlation_id}
        )

        return result

    def updatevirtualfunctionsconfiguration(self, action=params.Action(), correlation_id=None):
        '''
        @type Action:

        [@param action.virtual_functions_configuration.number_of_virtual_functions: int]
        [@param action.virtual_functions_configuration.all_networks_allowed: boolean]
        [@param action.async: boolean]
        [@param action.grace_period.expiry: long]
        [@param correlation_id: any string]

        @return Action:
        '''

        url = '/hosts/{host:id}/nics/{nic:id}/updatevirtualfunctionsconfiguration'

        result = self.__getProxy().request(
            method='POST',
            url=UrlHelper.replace(
                url,
                {
                    '{host:id}': self.parentclass.get_id(),
                    '{nic:id}': self.get_id(),
                }
            ),
            body=ParseHelper.toXml(action),
            headers={"Correlation-Id":correlation_id}
        )

        return result

class HostNICLabel(params.Label, Base):
    def __init__(self, hostnic, label, context):
        Base.__init__(self, context)
        self.parentclass = hostnic
        self.superclass  =  label

        #SUB_COLLECTIONS
    def __new__(cls, hostnic, label, context):
        if label is None: return None
        obj = object.__new__(cls)
        obj.__init__(hostnic, label, context)
        return obj

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def delete(self, async=None, correlation_id=None):
        '''
        [@param async: boolean (true|false)]
        [@param correlation_id: any string]

        @return None:
        '''

        url = UrlHelper.replace(
            '/hosts/{host:id}/nics/{nic:id}/labels/{label:id}',
            {
                '{host:id}': self.parentclass.parentclass.get_id(),
                '{nic:id}': self.parentclass.get_id(),
                '{label:id}': self.get_id(),
            }
        )

        return self.__getProxy().delete(
            url=UrlHelper.appendParameters(
                url,
                {'async:matrix':async}
            ),
            headers={"Correlation-Id":correlation_id,"Content-type":None}
        )

class HostNICLabels(Base):

    def __init__(self, hostnic , context):
        Base.__init__(self, context)
        self.parentclass = hostnic

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def add(self, label, correlation_id=None, expect=None):

        '''
        @type Label:

        @param label.id: string
        [@param correlation_id: any string]
        [@param expect: 201-created]

        @return Label:
        '''

        url = '/hosts/{host:id}/nics/{nic:id}/labels'

        result = self.__getProxy().add(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{host:id}': self.parentclass.parentclass.get_id(),
                        '{nic:id}': self.parentclass.get_id(),
                    }
                ),
                args={}
            ),
            body=ParseHelper.toXml(label),
            headers={"Correlation-Id":correlation_id, "Expect":expect}
        )

        return HostNICLabel(
            self.parentclass,
            result,
            self.context
        )

    def get(self, name=None, id=None):

        '''
        [@param id  : string (the id of the entity)]
        [@param name: string (the name of the entity)]

        @return Labels:
        '''

        url = '/hosts/{host:id}/nics/{nic:id}/labels'

        if id:
            try :
                result = self.__getProxy().get(
                    url=UrlHelper.append(
                        UrlHelper.replace(
                            url,
                            {
                                '{host:id}': self.parentclass.parentclass.get_id(),
                                '{nic:id}': self.parentclass.get_id(),
                            }
                        ),
                        id
                    ),
                    headers={}
                )

                return HostNICLabel(
                    self.parentclass,
                    result,
                    self.context
                )
            except RequestError as err:
                if err.status and err.status == 404:
                    return None
                raise err
        elif name:
            result = self.__getProxy().get(
                url=UrlHelper.replace(
                    url,
                    {
                        '{host:id}': self.parentclass.parentclass.get_id(),
                        '{nic:id}': self.parentclass.get_id(),
                    }
                ),
                headers={}
            ).get_label()

            return HostNICLabel(
                self.parentclass,
                FilterHelper.getItem(
                    FilterHelper.filter(
                        result,
                        {'name':name}
                    ),
                    query="name=" + name
                ),
                self.context
            )
        else:
            raise MissingParametersError(['id', 'name'])

    def list(self, max=None, **kwargs):
        '''
        [@param **kwargs: dict (property based filtering)"]
        [@param max: int (max results)]

        @return Labels:
        '''

        url = '/hosts/{host:id}/nics/{nic:id}/labels'

        result = self.__getProxy().get(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{host:id}': self.parentclass.parentclass.get_id(),
                        '{nic:id}': self.parentclass.get_id(),
                    }
                ),
                args={'max:matrix':max}
            ),
            headers={}
        ).get_label()

        return ParseHelper.toSubCollection(
            HostNICLabel,
            self.parentclass,
            FilterHelper.filter(
                result,
                kwargs
            ),
            context=self.context
        )

class HostNICStatistic(params.Statistic, Base):
    def __init__(self, hostnic, statistic, context):
        Base.__init__(self, context)
        self.parentclass = hostnic
        self.superclass  =  statistic

        #SUB_COLLECTIONS
    def __new__(cls, hostnic, statistic, context):
        if statistic is None: return None
        obj = object.__new__(cls)
        obj.__init__(hostnic, statistic, context)
        return obj

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

class HostNICStatistics(Base):

    def __init__(self, hostnic , context):
        Base.__init__(self, context)
        self.parentclass = hostnic

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def get(self, name=None, id=None):

        '''
        [@param id  : string (the id of the entity)]
        [@param name: string (the name of the entity)]

        @return Statistics:
        '''

        url = '/hosts/{host:id}/nics/{nic:id}/statistics'

        if id:
            try :
                result = self.__getProxy().get(
                    url=UrlHelper.append(
                        UrlHelper.replace(
                            url,
                            {
                                '{host:id}': self.parentclass.parentclass.get_id(),
                                '{nic:id}': self.parentclass.get_id(),
                            }
                        ),
                        id
                    ),
                    headers={}
                )

                return HostNICStatistic(
                    self.parentclass,
                    result,
                    self.context
                )
            except RequestError as err:
                if err.status and err.status == 404:
                    return None
                raise err
        elif name:
            result = self.__getProxy().get(
                url=UrlHelper.replace(
                    url,
                    {
                        '{host:id}': self.parentclass.parentclass.get_id(),
                        '{nic:id}': self.parentclass.get_id(),
                    }
                ),
                headers={}
            ).get_statistic()

            return HostNICStatistic(
                self.parentclass,
                FilterHelper.getItem(
                    FilterHelper.filter(
                        result,
                        {'name':name}
                    ),
                    query="name=" + name
                ),
                self.context
            )
        else:
            raise MissingParametersError(['id', 'name'])

    def list(self, **kwargs):
        '''
        [@param **kwargs: dict (property based filtering)"]

        @return Statistics:
        '''

        url = '/hosts/{host:id}/nics/{nic:id}/statistics'

        result = self.__getProxy().get(
            url=UrlHelper.replace(
                url,
                {
                    '{host:id}': self.parentclass.parentclass.get_id(),
                    '{nic:id}': self.parentclass.get_id(),
                }
            )
        ).get_statistic()

        return ParseHelper.toSubCollection(
            HostNICStatistic,
            self.parentclass,
            FilterHelper.filter(
                result,
                kwargs
            ),
            context=self.context
        )

class HostNICs(Base):

    def __init__(self, host , context):
        Base.__init__(self, context)
        self.parentclass = host

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def add(self, hostnic, correlation_id=None, expect=None):

        '''
        @type HostNIC:

        @param hostnic.network.id|name: string
        @param hostnic.name: string
        @param hostnic.bonding.slaves.host_nic: collection
        {
          @ivar host_nic.id|name: string
        }
        [@param hostnic.bonding.options.option: collection]
        {
          [@ivar option.name: string]
          [@ivar option.value: string]
          [@ivar type: string]
        }
        [@param correlation_id: any string]
        [@param expect: 201-created]

        @return HostNIC:
        '''

        url = '/hosts/{host:id}/nics'

        result = self.__getProxy().add(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{host:id}': self.parentclass.get_id(),
                    }
                ),
                args={}
            ),
            body=ParseHelper.toXml(hostnic),
            headers={"Correlation-Id":correlation_id, "Expect":expect}
        )

        return HostNIC(
            self.parentclass,
            result,
            self.context
        )

    def get(self, name=None, id=None):

        '''
        [@param id  : string (the id of the entity)]
        [@param name: string (the name of the entity)]

        @return HostNics:
        '''

        url = '/hosts/{host:id}/nics'

        if id:
            try :
                result = self.__getProxy().get(
                    url=UrlHelper.append(
                        UrlHelper.replace(
                            url,
                            {
                                '{host:id}': self.parentclass.get_id(),
                            }
                        ),
                        id
                    ),
                    headers={}
                )

                return HostNIC(
                    self.parentclass,
                    result,
                    self.context
                )
            except RequestError as err:
                if err.status and err.status == 404:
                    return None
                raise err
        elif name:
            result = self.__getProxy().get(
                url=UrlHelper.replace(
                    url,
                    {
                        '{host:id}': self.parentclass.get_id(),
                    }
                ),
                headers={}
            ).get_host_nic()

            return HostNIC(
                self.parentclass,
                FilterHelper.getItem(
                    FilterHelper.filter(
                        result,
                        {'name':name}
                    ),
                    query="name=" + name
                ),
                self.context
            )
        else:
            raise MissingParametersError(['id', 'name'])

    def list(self, max=None, **kwargs):
        '''
        [@param **kwargs: dict (property based filtering)"]
        [@param max: int (max results)]

        @return HostNics:
        '''

        url = '/hosts/{host:id}/nics'

        result = self.__getProxy().get(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{host:id}': self.parentclass.get_id(),
                    }
                ),
                args={'max:matrix':max}
            ),
            headers={}
        ).get_host_nic()

        return ParseHelper.toSubCollection(
            HostNIC,
            self.parentclass,
            FilterHelper.filter(
                result,
                kwargs
            ),
            context=self.context
        )

    def setupnetworks(self, action=params.Action(), correlation_id=None):
        '''
        @type Action:

        [@param action.host_nics.host_nic: collection]
        {
          [@ivar host_nic.network.id|name: string]
          [@ivar host_nic.name: string]
          [@ivar host_nic.base_interface: string]
          [@ivar host_nic.ip.gateway: string]
          [@ivar host_nic.boot_protocol: string]
          [@ivar host_nic.mac: string]
          [@ivar host_nic.ip.address: string]
          [@ivar host_nic.ip.netmask: string]
          [@ivar host_nic.bonding.options.option: collection]
          {
            [@param option.name: string]
            [@param option.value: string]
            [@param option.type: string]
          }
          [@ivar bonding.slaves.host_nic: collection]
          {
            [@param host_nic.name|id: string]
          }
          [@ivar host_nic.override_configuration: boolean]
          [@ivar host_nic.properties.property: collection]
          {
            [@param property.name: string]
            [@param property.value: string]
          }
        }
        [@param action.checkConnectivity: boolean]
        [@param action.connectivityTimeout: int]
        [@param action.force: boolean]
        [@param action.async: boolean]
        [@param action.grace_period.expiry: long]
        [@param correlation_id: any string]

        @return Action:
        '''

        url = '/hosts/{host:id}/nics/setupnetworks'

        result = self.__getProxy().request(
            method='POST',
            url=UrlHelper.replace(
                url,
                {
                    '{host:id}': self.parentclass.get_id(),
                }
            ),
            body=ParseHelper.toXml(action),
            headers={"Correlation-Id":correlation_id}
        )

        return result

class HostNetworkAttachment(params.NetworkAttachment, Base):
    def __init__(self, host, networkattachment, context):
        Base.__init__(self, context)
        self.parentclass = host
        self.superclass  =  networkattachment

        #SUB_COLLECTIONS
    def __new__(cls, host, networkattachment, context):
        if networkattachment is None: return None
        obj = object.__new__(cls)
        obj.__init__(host, networkattachment, context)
        return obj

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def delete(self, async=None, correlation_id=None):
        '''
        [@param async: boolean (true|false)]
        [@param correlation_id: any string]

        @return None:
        '''

        url = UrlHelper.replace(
            '/hosts/{host:id}/networkattachments/{networkattachment:id}',
            {
                '{host:id}': self.parentclass.get_id(),
                '{networkattachment:id}': self.get_id(),
            }
        )

        return self.__getProxy().delete(
            url=UrlHelper.appendParameters(
                url,
                {'async:matrix':async}
            ),
            headers={"Correlation-Id":correlation_id,"Content-type":None}
        )

    def update(self, override_configuration=None, async=None, correlation_id=None, expect=None):
        '''
        [@param network_attachment.host_nic.id|name: string]
        [@param network_attachment.ip_address_assignments.ip_address_assignment: collection]
        {
          [@ivar ip_address_assignment.assignment_method: string]
          [@ivar ip_address_assignment.ip.address: string]
          [@ivar ip_address_assignment.ip.netmask: string]
          [@ivar ip_address_assignment.ip.gateawy: string]
        }
        [@param network_attachment.properties.property: collection]
        {
          [@ivar property.name: string]
          [@ivar property.value: string]
        }
        [@param override_configuration: boolean (true|false)]
        [@param async: boolean (true|false)]
        [@param correlation_id: any string]
        [@param expect: 202-accepted]

        @return NetworkAttachment:
        '''

        url = '/hosts/{host:id}/networkattachments/{networkattachment:id}'
        url = UrlHelper.replace(
            url,
            {
                '{host:id}': self.parentclass.get_id(),
                '{networkattachment:id}': self.get_id(),
            }
        )

        result = self.__getProxy().update(
            url=UrlHelper.appendParameters(url, {'override_configuration:matrix':override_configuration,'async:matrix':async}),
            body=ParseHelper.toXml(self.superclass),
            headers={"Correlation-Id":correlation_id, "Expect":expect}
        )

        return HostNetworkAttachment(
            self.parentclass,
            result,
            self.context
        )

class HostNetworkAttachments(Base):

    def __init__(self, host , context):
        Base.__init__(self, context)
        self.parentclass = host

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def add(self, networkattachment, correlation_id=None, expect=None):

        '''
        @type NetworkAttachment:

        @param network_attachment.network.name|id: string
        [@param network_attachment.host_nic.id|name: string]
        [@param network_attachment.ip_address_assignments.ip_address_assignment: collection]
        {
          [@ivar ip_address_assignment.assignment_method: string]
          [@ivar ip_address_assignment.ip.address: string]
          [@ivar ip_address_assignment.ip.netmask: string]
          [@ivar ip_address_assignment.ip.gateawy: string]
        }
        [@param network_attachment.properties.property: collection]
        {
          [@ivar property.name: string]
          [@ivar property.value: string]
        }
        [@param correlation_id: any string]
        [@param expect: 201-created]

        @return NetworkAttachment:
        '''

        url = '/hosts/{host:id}/networkattachments'

        result = self.__getProxy().add(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{host:id}': self.parentclass.get_id(),
                    }
                ),
                args={}
            ),
            body=ParseHelper.toXml(networkattachment),
            headers={"Correlation-Id":correlation_id, "Expect":expect}
        )

        return HostNetworkAttachment(
            self.parentclass,
            result,
            self.context
        )

    def get(self, name=None, id=None):

        '''
        [@param id  : string (the id of the entity)]
        [@param name: string (the name of the entity)]

        @return NetworkAttachments:
        '''

        url = '/hosts/{host:id}/networkattachments'

        if id:
            try :
                result = self.__getProxy().get(
                    url=UrlHelper.append(
                        UrlHelper.replace(
                            url,
                            {
                                '{host:id}': self.parentclass.get_id(),
                            }
                        ),
                        id
                    ),
                    headers={}
                )

                return HostNetworkAttachment(
                    self.parentclass,
                    result,
                    self.context
                )
            except RequestError as err:
                if err.status and err.status == 404:
                    return None
                raise err
        elif name:
            result = self.__getProxy().get(
                url=UrlHelper.replace(
                    url,
                    {
                        '{host:id}': self.parentclass.get_id(),
                    }
                ),
                headers={}
            ).get_network_attachment()

            return HostNetworkAttachment(
                self.parentclass,
                FilterHelper.getItem(
                    FilterHelper.filter(
                        result,
                        {'name':name}
                    ),
                    query="name=" + name
                ),
                self.context
            )
        else:
            raise MissingParametersError(['id', 'name'])

    def list(self, max=None, **kwargs):
        '''
        [@param **kwargs: dict (property based filtering)"]
        [@param max: int (max results)]

        @return NetworkAttachments:
        '''

        url = '/hosts/{host:id}/networkattachments'

        result = self.__getProxy().get(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{host:id}': self.parentclass.get_id(),
                    }
                ),
                args={'max:matrix':max}
            ),
            headers={}
        ).get_network_attachment()

        return ParseHelper.toSubCollection(
            HostNetworkAttachment,
            self.parentclass,
            FilterHelper.filter(
                result,
                kwargs
            ),
            context=self.context
        )

class HostNumaNode(params.NumaNode, Base):
    def __init__(self, host, numanode, context):
        Base.__init__(self, context)
        self.parentclass = host
        self.superclass  =  numanode

        self.statistics = HostNumaNodeStatistics(self, context)

    def __new__(cls, host, numanode, context):
        if numanode is None: return None
        obj = object.__new__(cls)
        obj.__init__(host, numanode, context)
        return obj

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

class HostNumaNodeStatistic(params.Statistic, Base):
    def __init__(self, hostnumanode, statistic, context):
        Base.__init__(self, context)
        self.parentclass = hostnumanode
        self.superclass  =  statistic

        #SUB_COLLECTIONS
    def __new__(cls, hostnumanode, statistic, context):
        if statistic is None: return None
        obj = object.__new__(cls)
        obj.__init__(hostnumanode, statistic, context)
        return obj

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

class HostNumaNodeStatistics(Base):

    def __init__(self, numanode , context):
        Base.__init__(self, context)
        self.parentclass = numanode

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def get(self, name=None, id=None):

        '''
        [@param id  : string (the id of the entity)]
        [@param name: string (the name of the entity)]

        @return Statistics:
        '''

        url = '/hosts/{host:id}/numanodes/{numanode:id}/statistics'

        if id:
            try :
                result = self.__getProxy().get(
                    url=UrlHelper.append(
                        UrlHelper.replace(
                            url,
                            {
                                '{host:id}': self.parentclass.parentclass.get_id(),
                                '{numanode:id}': self.parentclass.get_id(),
                            }
                        ),
                        id
                    ),
                    headers={}
                )

                return HostNumaNodeStatistic(
                    self.parentclass,
                    result,
                    self.context
                )
            except RequestError as err:
                if err.status and err.status == 404:
                    return None
                raise err
        elif name:
            result = self.__getProxy().get(
                url=UrlHelper.replace(
                    url,
                    {
                        '{host:id}': self.parentclass.parentclass.get_id(),
                        '{numanode:id}': self.parentclass.get_id(),
                    }
                ),
                headers={}
            ).get_statistic()

            return HostNumaNodeStatistic(
                self.parentclass,
                FilterHelper.getItem(
                    FilterHelper.filter(
                        result,
                        {'name':name}
                    ),
                    query="name=" + name
                ),
                self.context
            )
        else:
            raise MissingParametersError(['id', 'name'])

    def list(self, **kwargs):
        '''
        [@param **kwargs: dict (property based filtering)"]

        @return Statistics:
        '''

        url = '/hosts/{host:id}/numanodes/{numanode:id}/statistics'

        result = self.__getProxy().get(
            url=UrlHelper.replace(
                url,
                {
                    '{host:id}': self.parentclass.parentclass.get_id(),
                    '{numanode:id}': self.parentclass.get_id(),
                }
            )
        ).get_statistic()

        return ParseHelper.toSubCollection(
            HostNumaNodeStatistic,
            self.parentclass,
            FilterHelper.filter(
                result,
                kwargs
            ),
            context=self.context
        )

class HostNumaNodes(Base):

    def __init__(self, host , context):
        Base.__init__(self, context)
        self.parentclass = host

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def get(self, name=None, id=None):

        '''
        [@param id  : string (the id of the entity)]
        [@param name: string (the name of the entity)]

        @return NumaNodes:
        '''

        url = '/hosts/{host:id}/numanodes'

        if id:
            try :
                result = self.__getProxy().get(
                    url=UrlHelper.append(
                        UrlHelper.replace(
                            url,
                            {
                                '{host:id}': self.parentclass.get_id(),
                            }
                        ),
                        id
                    ),
                    headers={}
                )

                return HostNumaNode(
                    self.parentclass,
                    result,
                    self.context
                )
            except RequestError as err:
                if err.status and err.status == 404:
                    return None
                raise err
        elif name:
            result = self.__getProxy().get(
                url=UrlHelper.replace(
                    url,
                    {
                        '{host:id}': self.parentclass.get_id(),
                    }
                ),
                headers={}
            ).get_host_numa_node()

            return HostNumaNode(
                self.parentclass,
                FilterHelper.getItem(
                    FilterHelper.filter(
                        result,
                        {'name':name}
                    ),
                    query="name=" + name
                ),
                self.context
            )
        else:
            raise MissingParametersError(['id', 'name'])

    def list(self, max=None, **kwargs):
        '''
        [@param **kwargs: dict (property based filtering)"]
        [@param max: int (max results)]

        @return NumaNodes:
        '''

        url = '/hosts/{host:id}/numanodes'

        result = self.__getProxy().get(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{host:id}': self.parentclass.get_id(),
                    }
                ),
                args={'max:matrix':max}
            ),
            headers={}
        ).get_host_numa_node()

        return ParseHelper.toSubCollection(
            HostNumaNode,
            self.parentclass,
            FilterHelper.filter(
                result,
                kwargs
            ),
            context=self.context
        )

class HostPermission(params.Permission, Base):
    def __init__(self, host, permission, context):
        Base.__init__(self, context)
        self.parentclass = host
        self.superclass  =  permission

        #SUB_COLLECTIONS
    def __new__(cls, host, permission, context):
        if permission is None: return None
        obj = object.__new__(cls)
        obj.__init__(host, permission, context)
        return obj

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def delete(self, async=None, correlation_id=None):
        '''
        [@param async: boolean (true|false)]
        [@param correlation_id: any string]

        @return None:
        '''

        url = UrlHelper.replace(
            '/hosts/{host:id}/permissions/{permission:id}',
            {
                '{host:id}': self.parentclass.get_id(),
                '{permission:id}': self.get_id(),
            }
        )

        return self.__getProxy().delete(
            url=UrlHelper.appendParameters(
                url,
                {'async:matrix':async}
            ),
            headers={"Correlation-Id":correlation_id,"Content-type":None}
        )

class HostPermissions(Base):

    def __init__(self, host , context):
        Base.__init__(self, context)
        self.parentclass = host

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def add(self, permission, correlation_id=None, expect=None):

        '''
        @type Permission:

        Overload 1:
          @param permission.user.id: string
          @param permission.role.id|name: string
        Overload 2:
          @param permission.role.id|name: string
          @param permission.group.id: string
        [@param correlation_id: any string]
        [@param expect: 201-created]

        @return Permission:
        '''

        url = '/hosts/{host:id}/permissions'

        result = self.__getProxy().add(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{host:id}': self.parentclass.get_id(),
                    }
                ),
                args={}
            ),
            body=ParseHelper.toXml(permission),
            headers={"Correlation-Id":correlation_id, "Expect":expect}
        )

        return HostPermission(
            self.parentclass,
            result,
            self.context
        )

    def get(self, name=None, id=None):

        '''
        [@param id  : string (the id of the entity)]
        [@param name: string (the name of the entity)]

        @return Permissions:
        '''

        url = '/hosts/{host:id}/permissions'

        if id:
            try :
                result = self.__getProxy().get(
                    url=UrlHelper.append(
                        UrlHelper.replace(
                            url,
                            {
                                '{host:id}': self.parentclass.get_id(),
                            }
                        ),
                        id
                    ),
                    headers={}
                )

                return HostPermission(
                    self.parentclass,
                    result,
                    self.context
                )
            except RequestError as err:
                if err.status and err.status == 404:
                    return None
                raise err
        elif name:
            result = self.__getProxy().get(
                url=UrlHelper.replace(
                    url,
                    {
                        '{host:id}': self.parentclass.get_id(),
                    }
                ),
                headers={}
            ).get_permission()

            return HostPermission(
                self.parentclass,
                FilterHelper.getItem(
                    FilterHelper.filter(
                        result,
                        {'name':name}
                    ),
                    query="name=" + name
                ),
                self.context
            )
        else:
            raise MissingParametersError(['id', 'name'])

    def list(self, max=None, **kwargs):
        '''
        [@param **kwargs: dict (property based filtering)"]
        [@param max: int (max results)]

        @return Permissions:
        '''

        url = '/hosts/{host:id}/permissions'

        result = self.__getProxy().get(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{host:id}': self.parentclass.get_id(),
                    }
                ),
                args={'max:matrix':max}
            ),
            headers={}
        ).get_permission()

        return ParseHelper.toSubCollection(
            HostPermission,
            self.parentclass,
            FilterHelper.filter(
                result,
                kwargs
            ),
            context=self.context
        )

class HostStatistic(params.Statistic, Base):
    def __init__(self, host, statistic, context):
        Base.__init__(self, context)
        self.parentclass = host
        self.superclass  =  statistic

        #SUB_COLLECTIONS
    def __new__(cls, host, statistic, context):
        if statistic is None: return None
        obj = object.__new__(cls)
        obj.__init__(host, statistic, context)
        return obj

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

class HostStatistics(Base):

    def __init__(self, host , context):
        Base.__init__(self, context)
        self.parentclass = host

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def get(self, name=None, id=None):

        '''
        [@param id  : string (the id of the entity)]
        [@param name: string (the name of the entity)]

        @return Statistics:
        '''

        url = '/hosts/{host:id}/statistics'

        if id:
            try :
                result = self.__getProxy().get(
                    url=UrlHelper.append(
                        UrlHelper.replace(
                            url,
                            {
                                '{host:id}': self.parentclass.get_id(),
                            }
                        ),
                        id
                    ),
                    headers={}
                )

                return HostStatistic(
                    self.parentclass,
                    result,
                    self.context
                )
            except RequestError as err:
                if err.status and err.status == 404:
                    return None
                raise err
        elif name:
            result = self.__getProxy().get(
                url=UrlHelper.replace(
                    url,
                    {
                        '{host:id}': self.parentclass.get_id(),
                    }
                ),
                headers={}
            ).get_statistic()

            return HostStatistic(
                self.parentclass,
                FilterHelper.getItem(
                    FilterHelper.filter(
                        result,
                        {'name':name}
                    ),
                    query="name=" + name
                ),
                self.context
            )
        else:
            raise MissingParametersError(['id', 'name'])

    def list(self, **kwargs):
        '''
        [@param **kwargs: dict (property based filtering)"]

        @return Statistics:
        '''

        url = '/hosts/{host:id}/statistics'

        result = self.__getProxy().get(
            url=UrlHelper.replace(
                url,
                {
                    '{host:id}': self.parentclass.get_id(),
                }
            )
        ).get_statistic()

        return ParseHelper.toSubCollection(
            HostStatistic,
            self.parentclass,
            FilterHelper.filter(
                result,
                kwargs
            ),
            context=self.context
        )

class HostStorage(params.Storage, Base):
    def __init__(self, host, storage, context):
        Base.__init__(self, context)
        self.parentclass = host
        self.superclass  =  storage

        #SUB_COLLECTIONS
    def __new__(cls, host, storage, context):
        if storage is None: return None
        obj = object.__new__(cls)
        obj.__init__(host, storage, context)
        return obj

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

class HostStorageConnectionExtension(params.StorageConnectionExtension, Base):
    def __init__(self, host, storageconnectionextension, context):
        Base.__init__(self, context)
        self.parentclass = host
        self.superclass  =  storageconnectionextension

        #SUB_COLLECTIONS
    def __new__(cls, host, storageconnectionextension, context):
        if storageconnectionextension is None: return None
        obj = object.__new__(cls)
        obj.__init__(host, storageconnectionextension, context)
        return obj

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def delete(self, async=None):
        '''
        [@param async: boolean (true|false)]

        @return None:
        '''

        url = UrlHelper.replace(
            '/hosts/{host:id}/storageconnectionextensions/{storageconnectionextension:id}',
            {
                '{host:id}': self.parentclass.get_id(),
                '{storageconnectionextension:id}': self.get_id(),
            }
        )

        return self.__getProxy().delete(
            url=UrlHelper.appendParameters(
                url,
                {'async:matrix':async}
            ),
            headers={"Content-type":None}
        )

    def update(self, async=None):
        '''
        [@param async: boolean (true|false)]

        @return StorageConnectionExtension:
        '''

        url = '/hosts/{host:id}/storageconnectionextensions/{storageconnectionextension:id}'
        url = UrlHelper.replace(
            url,
            {
                '{host:id}': self.parentclass.get_id(),
                '{storageconnectionextension:id}': self.get_id(),
            }
        )

        result = self.__getProxy().update(
            url=UrlHelper.appendParameters(url, {'async:matrix':async}),
            body=ParseHelper.toXml(self.superclass),
            headers={}
        )

        return HostStorageConnectionExtension(
            self.parentclass,
            result,
            self.context
        )

class HostStorageConnectionExtensions(Base):

    def __init__(self, host , context):
        Base.__init__(self, context)
        self.parentclass = host

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def add(self, storageconnectionextension, correlation_id=None, expect=None):

        '''
        @type StorageConnectionExtension:

        @param storageconnectionextension.target: string
        @param storageconnectionextension.username: string
        @param storageconnectionextension.password: string
        [@param correlation_id: any string]
        [@param expect: 201-created]

        @return StorageConnectionExtension:
        '''

        url = '/hosts/{host:id}/storageconnectionextensions'

        result = self.__getProxy().add(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{host:id}': self.parentclass.get_id(),
                    }
                ),
                args={}
            ),
            body=ParseHelper.toXml(storageconnectionextension),
            headers={"Correlation-Id":correlation_id, "Expect":expect}
        )

        return HostStorageConnectionExtension(
            self.parentclass,
            result,
            self.context
        )

    def get(self, name=None, id=None):

        '''
        [@param id  : string (the id of the entity)]
        [@param name: string (the name of the entity)]

        @return StorageConnectionExtensions:
        '''

        url = '/hosts/{host:id}/storageconnectionextensions'

        if id:
            try :
                result = self.__getProxy().get(
                    url=UrlHelper.append(
                        UrlHelper.replace(
                            url,
                            {
                                '{host:id}': self.parentclass.get_id(),
                            }
                        ),
                        id
                    ),
                    headers={}
                )

                return HostStorageConnectionExtension(
                    self.parentclass,
                    result,
                    self.context
                )
            except RequestError as err:
                if err.status and err.status == 404:
                    return None
                raise err
        elif name:
            result = self.__getProxy().get(
                url=UrlHelper.replace(
                    url,
                    {
                        '{host:id}': self.parentclass.get_id(),
                    }
                ),
                headers={}
            ).get_storage_connection_extension()

            return HostStorageConnectionExtension(
                self.parentclass,
                FilterHelper.getItem(
                    FilterHelper.filter(
                        result,
                        {'name':name}
                    ),
                    query="name=" + name
                ),
                self.context
            )
        else:
            raise MissingParametersError(['id', 'name'])

    def list(self, max=None, **kwargs):
        '''
        [@param **kwargs: dict (property based filtering)"]
        [@param max: int (max results)]

        @return StorageConnectionExtensions:
        '''

        url = '/hosts/{host:id}/storageconnectionextensions'

        result = self.__getProxy().get(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{host:id}': self.parentclass.get_id(),
                    }
                ),
                args={'max:matrix':max}
            ),
            headers={}
        ).get_storage_connection_extension()

        return ParseHelper.toSubCollection(
            HostStorageConnectionExtension,
            self.parentclass,
            FilterHelper.filter(
                result,
                kwargs
            ),
            context=self.context
        )

class HostStorages(Base):

    def __init__(self, host , context):
        Base.__init__(self, context)
        self.parentclass = host

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def get(self, name=None, id=None):

        '''
        [@param id  : string (the id of the entity)]
        [@param name: string (the name of the entity)]

        @return HostStorage:
        '''

        url = '/hosts/{host:id}/storage'

        if id:
            try :
                result = self.__getProxy().get(
                    url=UrlHelper.append(
                        UrlHelper.replace(
                            url,
                            {
                                '{host:id}': self.parentclass.get_id(),
                            }
                        ),
                        id
                    ),
                    headers={}
                )

                return HostStorage(
                    self.parentclass,
                    result,
                    self.context
                )
            except RequestError as err:
                if err.status and err.status == 404:
                    return None
                raise err
        elif name:
            result = self.__getProxy().get(
                url=UrlHelper.replace(
                    url,
                    {
                        '{host:id}': self.parentclass.get_id(),
                    }
                ),
                headers={}
            ).get_storage()

            return HostStorage(
                self.parentclass,
                FilterHelper.getItem(
                    FilterHelper.filter(
                        result,
                        {'name':name}
                    ),
                    query="name=" + name
                ),
                self.context
            )
        else:
            raise MissingParametersError(['id', 'name'])

    def list(self, max=None, **kwargs):
        '''
        [@param **kwargs: dict (property based filtering)"]
        [@param max: int (max results)]

        @return HostStorage:
        '''

        url = '/hosts/{host:id}/storage'

        result = self.__getProxy().get(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{host:id}': self.parentclass.get_id(),
                    }
                ),
                args={'max:matrix':max}
            ),
            headers={}
        ).get_storage()

        return ParseHelper.toSubCollection(
            HostStorage,
            self.parentclass,
            FilterHelper.filter(
                result,
                kwargs
            ),
            context=self.context
        )

class HostTag(params.Tag, Base):
    def __init__(self, host, tag, context):
        Base.__init__(self, context)
        self.parentclass = host
        self.superclass  =  tag

        #SUB_COLLECTIONS
    def __new__(cls, host, tag, context):
        if tag is None: return None
        obj = object.__new__(cls)
        obj.__init__(host, tag, context)
        return obj

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def delete(self, async=None, correlation_id=None):
        '''
        [@param async: boolean (true|false)]
        [@param correlation_id: any string]

        @return None:
        '''

        url = UrlHelper.replace(
            '/hosts/{host:id}/tags/{tag:id}',
            {
                '{host:id}': self.parentclass.get_id(),
                '{tag:id}': self.get_id(),
            }
        )

        return self.__getProxy().delete(
            url=UrlHelper.appendParameters(
                url,
                {'async:matrix':async}
            ),
            headers={"Correlation-Id":correlation_id,"Content-type":None}
        )

class HostTags(Base):

    def __init__(self, host , context):
        Base.__init__(self, context)
        self.parentclass = host

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def add(self, tag, correlation_id=None, expect=None):

        '''
        @type Tag:

        @param tag.id|name: string
        [@param correlation_id: any string]
        [@param expect: 201-created]

        @return Tag:
        '''

        url = '/hosts/{host:id}/tags'

        result = self.__getProxy().add(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{host:id}': self.parentclass.get_id(),
                    }
                ),
                args={}
            ),
            body=ParseHelper.toXml(tag),
            headers={"Correlation-Id":correlation_id, "Expect":expect}
        )

        return HostTag(
            self.parentclass,
            result,
            self.context
        )

    def get(self, name=None, id=None):

        '''
        [@param id  : string (the id of the entity)]
        [@param name: string (the name of the entity)]

        @return Tags:
        '''

        url = '/hosts/{host:id}/tags'

        if id:
            try :
                result = self.__getProxy().get(
                    url=UrlHelper.append(
                        UrlHelper.replace(
                            url,
                            {
                                '{host:id}': self.parentclass.get_id(),
                            }
                        ),
                        id
                    ),
                    headers={}
                )

                return HostTag(
                    self.parentclass,
                    result,
                    self.context
                )
            except RequestError as err:
                if err.status and err.status == 404:
                    return None
                raise err
        elif name:
            result = self.__getProxy().get(
                url=UrlHelper.replace(
                    url,
                    {
                        '{host:id}': self.parentclass.get_id(),
                    }
                ),
                headers={}
            ).get_tag()

            return HostTag(
                self.parentclass,
                FilterHelper.getItem(
                    FilterHelper.filter(
                        result,
                        {'name':name}
                    ),
                    query="name=" + name
                ),
                self.context
            )
        else:
            raise MissingParametersError(['id', 'name'])

    def list(self, max=None, **kwargs):
        '''
        [@param **kwargs: dict (property based filtering)"]
        [@param max: int (max results)]

        @return Tags:
        '''

        url = '/hosts/{host:id}/tags'

        result = self.__getProxy().get(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{host:id}': self.parentclass.get_id(),
                    }
                ),
                args={'max:matrix':max}
            ),
            headers={}
        ).get_tag()

        return ParseHelper.toSubCollection(
            HostTag,
            self.parentclass,
            FilterHelper.filter(
                result,
                kwargs
            ),
            context=self.context
        )

class HostUnmanagedNetwork(params.UnmanagedNetwork, Base):
    def __init__(self, host, unmanagednetwork, context):
        Base.__init__(self, context)
        self.parentclass = host
        self.superclass  =  unmanagednetwork

        #SUB_COLLECTIONS
    def __new__(cls, host, unmanagednetwork, context):
        if unmanagednetwork is None: return None
        obj = object.__new__(cls)
        obj.__init__(host, unmanagednetwork, context)
        return obj

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def delete(self, async=None, correlation_id=None):
        '''
        [@param async: boolean (true|false)]
        [@param correlation_id: any string]

        @return None:
        '''

        url = UrlHelper.replace(
            '/hosts/{host:id}/unmanagednetworks/{unmanagednetwork:id}',
            {
                '{host:id}': self.parentclass.get_id(),
                '{unmanagednetwork:id}': self.get_id(),
            }
        )

        return self.__getProxy().delete(
            url=UrlHelper.appendParameters(
                url,
                {'async:matrix':async}
            ),
            headers={"Correlation-Id":correlation_id,"Content-type":None}
        )

class HostUnmanagedNetworks(Base):

    def __init__(self, host , context):
        Base.__init__(self, context)
        self.parentclass = host

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def get(self, name=None, id=None):

        '''
        [@param id  : string (the id of the entity)]
        [@param name: string (the name of the entity)]

        @return UnmanagedNetworks:
        '''

        url = '/hosts/{host:id}/unmanagednetworks'

        if id:
            try :
                result = self.__getProxy().get(
                    url=UrlHelper.append(
                        UrlHelper.replace(
                            url,
                            {
                                '{host:id}': self.parentclass.get_id(),
                            }
                        ),
                        id
                    ),
                    headers={}
                )

                return HostUnmanagedNetwork(
                    self.parentclass,
                    result,
                    self.context
                )
            except RequestError as err:
                if err.status and err.status == 404:
                    return None
                raise err
        elif name:
            result = self.__getProxy().get(
                url=UrlHelper.replace(
                    url,
                    {
                        '{host:id}': self.parentclass.get_id(),
                    }
                ),
                headers={}
            ).get_unmanaged_network()

            return HostUnmanagedNetwork(
                self.parentclass,
                FilterHelper.getItem(
                    FilterHelper.filter(
                        result,
                        {'name':name}
                    ),
                    query="name=" + name
                ),
                self.context
            )
        else:
            raise MissingParametersError(['id', 'name'])

    def list(self, max=None, **kwargs):
        '''
        [@param **kwargs: dict (property based filtering)"]
        [@param max: int (max results)]

        @return UnmanagedNetworks:
        '''

        url = '/hosts/{host:id}/unmanagednetworks'

        result = self.__getProxy().get(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{host:id}': self.parentclass.get_id(),
                    }
                ),
                args={'max:matrix':max}
            ),
            headers={}
        ).get_unmanaged_network()

        return ParseHelper.toSubCollection(
            HostUnmanagedNetwork,
            self.parentclass,
            FilterHelper.filter(
                result,
                kwargs
            ),
            context=self.context
        )

class Hosts(Base):
    def __init__(self, context):
        Base.__init__(self, context)

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def add(self, host, correlation_id=None, expect=None):
        '''
        @type Host:

        Overload 1:
          @param host.name: string
          @param host.address: string
          @param host.root_password: string
          @param host.cluster.id|name: string
          [@param host.comment: string]
          [@param host.port: int]
          [@param host.display.address: string]
          [@param host.spm.priority: int]
          [@param host.power_management.type: string]
          [@param host.power_management.enabled: boolean]
          [@param host.power_management.address: string]
          [@param host.power_management.username: string]
          [@param host.power_management.automatic_pm_enabled: boolean]
          [@param host.power_management.password: string]
          [@param host.power_management.options.option: collection]
          {
            [@ivar option.name: string]
            [@ivar option.value: string]
          }
          [@param host.power_management.pm_proxy: collection]
          {
            [@ivar propietary: string]
          }
          [@param host.power_management.agents.agent: collection]
          {
            [@ivar type: string]
            [@ivar address: string]
            [@ivar username: string]
            [@ivar password: string]
            [@ivar options.option: collection]
            {
              [@param option.name: string]
              [@param option.value: string]
            }
            [@ivar encrypt_options: boolean]
          }
          [@param host.reboot_after_installation: boolean]
          [@param host.override_iptables: boolean]
          [@param host.power_management.kdump_detection: boolean]
          [@param host.protocol: int]
        Overload 2:
          @param host.name: string
          @param host.address: string
          @param host.cluster.id|name: string
          [@param host.comment: string]
          [@param host.ssh.port: int]
          [@param host.ssh.fingerprint: string]
          [@param host.ssh.authentication_method: string]
          [@param host.ssh.user.user_name: string]
          [@param host.ssh.user.password: string]
          [@param host.port: int]
          [@param host.display.address: string]
          [@param host.spm.priority: int]
          [@param host.power_management.type: string]
          [@param host.power_management.automatic_pm_enabled: boolean]
          [@param host.power_management.enabled: boolean]
          [@param host.power_management.address: string]
          [@param host.power_management.username: string]
          [@param host.power_management.password: string]
          [@param host.power_management.options.option: collection]
          {
            [@ivar option.name: string]
            [@ivar option.value: string]
          }
          [@param host.power_management.pm_proxy: collection]
          {
            [@ivar propietary: string]
          }
          [@param host.power_management.agents.agent: collection]
          {
            [@ivar type: string]
            [@ivar address: string]
            [@ivar username: string]
            [@ivar password: string]
            [@ivar options.option: collection]
            {
              [@param option.name: string]
              [@param option.value: string]
            }
            [@ivar encrypt_options: boolean]
          }
          [@param host.reboot_after_installation: boolean]
          [@param host.override_iptables: boolean]
          [@param host.power_management.kdump_detection: boolean]
          [@param host.protocol: int]
        [@param correlation_id: any string]
        [@param expect: 201-created]

        @return Host:
        '''

        url = '/hosts'

        result = self.__getProxy().add(
           url=UrlHelper.appendParameters(
                url=url,
                args={}
           ),
           body=ParseHelper.toXml(host),
           headers={"Correlation-Id":correlation_id, "Expect":expect}
        )

        return Host(result, self.context)

    def get(self, name=None, all_content=None, id=None):
        '''
        [@param id  : string (the id of the entity)]
        [@param name: string (the name of the entity)]
        [@param all_content: true|false]

        @return Hosts:
        '''

        url = '/hosts'

        if id:
            try :
                return Host(
                    self.__getProxy().get(
                        url=UrlHelper.append(url, id),
                        headers={"All-Content":all_content}
                    ),
                    self.context
                )
            except RequestError as err:
                if err.status and err.status == 404:
                    return None
                raise err
        elif name:
            result = self.__getProxy().get(
                url=UrlHelper.appendParameters(url, {'search:query':'name='+name}),
                headers={"All-Content":all_content}
            ).get_host()

            return Host(
                FilterHelper.getItem(
                    FilterHelper.filter(result, {'name':name}),
                    query="name=" + name
                ),
                self.context
            )
        else:
            raise MissingParametersError(['id', 'name'])

    def list(self, query=None, case_sensitive=True, max=None, all_content=None, **kwargs):
        '''
        [@param **kwargs: dict (property based filtering)]
        [@param query: string (oVirt engine search dialect query)]
        [@param case_sensitive: boolean (true|false)]
        [@param max: int (max results)]
        [@param all_content: true|false]

        @return Hosts:
        '''

        url='/hosts'

        result = self.__getProxy().get(
            url=UrlHelper.appendParameters(url, {'search:query':query,'case_sensitive:matrix':case_sensitive,'max:matrix':max}),
            headers={"All-Content":all_content}
        ).get_host()

        return ParseHelper.toCollection(
            Host,
            FilterHelper.filter(result, kwargs),
            context=self.context
        )

class Icon(params.Icon, Base):
    def __init__(self, icon, context):
        Base.__init__(self, context)
        self.superclass = icon

        #SUB_COLLECTIONS
    def __new__(cls, icon, context):
        if icon is None: return None
        obj = object.__new__(cls)
        obj.__init__(icon, context)
        return obj

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

class Icons(Base):
    def __init__(self, context):
        Base.__init__(self, context)

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def get(self, name=None, id=None):
        '''
        [@param id  : string (the id of the entity)]
        [@param name: string (the name of the entity)]

        @return Icons:
        '''

        url = '/icons'

        if id:
            try :
                return Icon(
                    self.__getProxy().get(
                                url=UrlHelper.append(url, id),
                                headers={}
                    ),
                    self.context
                )
            except RequestError as err:
                if err.status and err.status == 404:
                    return None
                raise err
        elif name:
            result = self.__getProxy().get(
                    url=url,
                    headers={}
            ).get_icon()

            return Icon(
                FilterHelper.getItem(
                    FilterHelper.filter(result, {'name':name}),
                    query="name=" + name
                ),
                self.context
            )
        else:
            raise MissingParametersError(['id', 'name'])


    def list(self, max=None, **kwargs):
        '''
        [@param **kwargs: dict (property based filtering)]
        [@param max: int (max results)]

        @return Icons:
        '''

        url='/icons'

        result = self.__getProxy().get(
            url=UrlHelper.appendParameters(url, {'max:matrix':max}),
            headers={}
        ).get_icon()

        return ParseHelper.toCollection(
            Icon,
            FilterHelper.filter(result, kwargs),
            context=self.context
        )

class InstanceType(params.InstanceType, Base):
    def __init__(self, instancetype, context):
        Base.__init__(self, context)
        self.superclass = instancetype

        self.graphicsconsoles = InstanceTypeGraphicsConsoles(self, context)
        self.nics = InstanceTypeNICs(self, context)
        self.watchdogs = InstanceTypeWatchDogs(self, context)

    def __new__(cls, instancetype, context):
        if instancetype is None: return None
        obj = object.__new__(cls)
        obj.__init__(instancetype, context)
        return obj

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def delete(self, async=None, correlation_id=None):
        '''
        [@param async: boolean (true|false)]
        [@param correlation_id: any string]

        @return None:
        '''

        url = UrlHelper.replace(
            '/instancetypes/{instancetype:id}',
            {
                '{instancetype:id}': self.get_id(),
            }
        )

        return self.__getProxy().delete(
            url=UrlHelper.appendParameters(
                url,
                {'async:matrix':async}
            ),
            headers={"Correlation-Id":correlation_id,"Content-type":None}
        )

    def update(self):
        '''
        @return InstanceType:
        '''

        url = '/instancetypes/{instancetype:id}'

        result = self.__getProxy().update(
            url=UrlHelper.replace(
                url,
                {
                    '{instancetype:id}': self.get_id(),
                }
            ),
            body=ParseHelper.toXml(self.superclass),
            headers={}
        )

        return InstanceType(result, self.context)

class InstanceTypeGraphicsConsole(params.GraphicsConsole, Base):
    def __init__(self, instancetype, graphicsconsole, context):
        Base.__init__(self, context)
        self.parentclass = instancetype
        self.superclass  =  graphicsconsole

        #SUB_COLLECTIONS
    def __new__(cls, instancetype, graphicsconsole, context):
        if graphicsconsole is None: return None
        obj = object.__new__(cls)
        obj.__init__(instancetype, graphicsconsole, context)
        return obj

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def delete(self, async=None, correlation_id=None):
        '''
        [@param async: boolean (true|false)]
        [@param correlation_id: any string]

        @return None:
        '''

        url = UrlHelper.replace(
            '/instancetypes/{instancetype:id}/graphicsconsoles/{graphicsconsole:id}',
            {
                '{instancetype:id}': self.parentclass.get_id(),
                '{graphicsconsole:id}': self.get_id(),
            }
        )

        return self.__getProxy().delete(
            url=UrlHelper.appendParameters(
                url,
                {'async:matrix':async}
            ),
            headers={"Correlation-Id":correlation_id,"Content-type":None}
        )

class InstanceTypeGraphicsConsoles(Base):

    def __init__(self, instancetype , context):
        Base.__init__(self, context)
        self.parentclass = instancetype

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def add(self, graphicsconsole, correlation_id=None, expect=None):

        '''
        @type GraphicsConsole:

        @param graphics_console.protocol: string
        [@param correlation_id: any string]
        [@param expect: 201-created]

        @return GraphicsConsole:
        '''

        url = '/instancetypes/{instancetype:id}/graphicsconsoles'

        result = self.__getProxy().add(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{instancetype:id}': self.parentclass.get_id(),
                    }
                ),
                args={}
            ),
            body=ParseHelper.toXml(graphicsconsole),
            headers={"Correlation-Id":correlation_id, "Expect":expect}
        )

        return InstanceTypeGraphicsConsole(
            self.parentclass,
            result,
            self.context
        )

    def get(self, name=None, id=None):

        '''
        [@param id  : string (the id of the entity)]
        [@param name: string (the name of the entity)]

        @return GraphicsConsoles:
        '''

        url = '/instancetypes/{instancetype:id}/graphicsconsoles'

        if id:
            try :
                result = self.__getProxy().get(
                    url=UrlHelper.append(
                        UrlHelper.replace(
                            url,
                            {
                                '{instancetype:id}': self.parentclass.get_id(),
                            }
                        ),
                        id
                    ),
                    headers={}
                )

                return InstanceTypeGraphicsConsole(
                    self.parentclass,
                    result,
                    self.context
                )
            except RequestError as err:
                if err.status and err.status == 404:
                    return None
                raise err
        elif name:
            result = self.__getProxy().get(
                url=UrlHelper.replace(
                    url,
                    {
                        '{instancetype:id}': self.parentclass.get_id(),
                    }
                ),
                headers={}
            ).get_graphics_console()

            return InstanceTypeGraphicsConsole(
                self.parentclass,
                FilterHelper.getItem(
                    FilterHelper.filter(
                        result,
                        {'name':name}
                    ),
                    query="name=" + name
                ),
                self.context
            )
        else:
            raise MissingParametersError(['id', 'name'])

    def list(self, max=None, **kwargs):
        '''
        [@param **kwargs: dict (property based filtering)"]
        [@param max: int (max results)]

        @return GraphicsConsoles:
        '''

        url = '/instancetypes/{instancetype:id}/graphicsconsoles'

        result = self.__getProxy().get(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{instancetype:id}': self.parentclass.get_id(),
                    }
                ),
                args={'max:matrix':max}
            ),
            headers={}
        ).get_graphics_console()

        return ParseHelper.toSubCollection(
            InstanceTypeGraphicsConsole,
            self.parentclass,
            FilterHelper.filter(
                result,
                kwargs
            ),
            context=self.context
        )

class InstanceTypeNIC(params.NIC, Base):
    def __init__(self, instancetype, nic, context):
        Base.__init__(self, context)
        self.parentclass = instancetype
        self.superclass  =  nic

        #SUB_COLLECTIONS
    def __new__(cls, instancetype, nic, context):
        if nic is None: return None
        obj = object.__new__(cls)
        obj.__init__(instancetype, nic, context)
        return obj

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def update(self, async=None):
        '''
        [@param async: boolean (true|false)]

        @return NIC:
        '''

        url = '/instancetypes/{instancetype:id}/nics/{nic:id}'
        url = UrlHelper.replace(
            url,
            {
                '{instancetype:id}': self.parentclass.get_id(),
                '{nic:id}': self.get_id(),
            }
        )

        result = self.__getProxy().update(
            url=UrlHelper.appendParameters(url, {'async:matrix':async}),
            body=ParseHelper.toXml(self.superclass),
            headers={}
        )

        return InstanceTypeNIC(
            self.parentclass,
            result,
            self.context
        )

class InstanceTypeNICs(Base):

    def __init__(self, instancetype , context):
        Base.__init__(self, context)
        self.parentclass = instancetype

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def add(self, nic):

        '''
        @type NIC:


        @return NIC:
        '''

        url = '/instancetypes/{instancetype:id}/nics'

        result = self.__getProxy().add(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{instancetype:id}': self.parentclass.get_id(),
                    }
                ),
                args={}
            ),
            body=ParseHelper.toXml(nic),
            headers={}
        )

        return InstanceTypeNIC(
            self.parentclass,
            result,
            self.context
        )

    def get(self, name=None, id=None):

        '''
        [@param id  : string (the id of the entity)]
        [@param name: string (the name of the entity)]

        @return Nics:
        '''

        url = '/instancetypes/{instancetype:id}/nics'

        if id:
            try :
                result = self.__getProxy().get(
                    url=UrlHelper.append(
                        UrlHelper.replace(
                            url,
                            {
                                '{instancetype:id}': self.parentclass.get_id(),
                            }
                        ),
                        id
                    ),
                    headers={}
                )

                return InstanceTypeNIC(
                    self.parentclass,
                    result,
                    self.context
                )
            except RequestError as err:
                if err.status and err.status == 404:
                    return None
                raise err
        elif name:
            result = self.__getProxy().get(
                url=UrlHelper.replace(
                    url,
                    {
                        '{instancetype:id}': self.parentclass.get_id(),
                    }
                ),
                headers={}
            ).get_nic()

            return InstanceTypeNIC(
                self.parentclass,
                FilterHelper.getItem(
                    FilterHelper.filter(
                        result,
                        {'name':name}
                    ),
                    query="name=" + name
                ),
                self.context
            )
        else:
            raise MissingParametersError(['id', 'name'])

    def list(self, max=None, **kwargs):
        '''
        [@param **kwargs: dict (property based filtering)"]
        [@param max: int (max results)]

        @return Nics:
        '''

        url = '/instancetypes/{instancetype:id}/nics'

        result = self.__getProxy().get(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{instancetype:id}': self.parentclass.get_id(),
                    }
                ),
                args={'max:matrix':max}
            ),
            headers={}
        ).get_nic()

        return ParseHelper.toSubCollection(
            InstanceTypeNIC,
            self.parentclass,
            FilterHelper.filter(
                result,
                kwargs
            ),
            context=self.context
        )

class InstanceTypeWatchDog(params.WatchDog, Base):
    def __init__(self, instancetype, watchdog, context):
        Base.__init__(self, context)
        self.parentclass = instancetype
        self.superclass  =  watchdog

        #SUB_COLLECTIONS
    def __new__(cls, instancetype, watchdog, context):
        if watchdog is None: return None
        obj = object.__new__(cls)
        obj.__init__(instancetype, watchdog, context)
        return obj

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def delete(self, async=None):
        '''
        [@param async: boolean (true|false)]

        @return None:
        '''

        url = UrlHelper.replace(
            '/instancetypes/{instancetype:id}/watchdogs/{watchdog:id}',
            {
                '{instancetype:id}': self.parentclass.get_id(),
                '{watchdog:id}': self.get_id(),
            }
        )

        return self.__getProxy().delete(
            url=UrlHelper.appendParameters(
                url,
                {'async:matrix':async}
            ),
            headers={"Content-type":None}
        )

    def update(self, async=None):
        '''
        [@param async: boolean (true|false)]

        @return WatchDog:
        '''

        url = '/instancetypes/{instancetype:id}/watchdogs/{watchdog:id}'
        url = UrlHelper.replace(
            url,
            {
                '{instancetype:id}': self.parentclass.get_id(),
                '{watchdog:id}': self.get_id(),
            }
        )

        result = self.__getProxy().update(
            url=UrlHelper.appendParameters(url, {'async:matrix':async}),
            body=ParseHelper.toXml(self.superclass),
            headers={}
        )

        return InstanceTypeWatchDog(
            self.parentclass,
            result,
            self.context
        )

class InstanceTypeWatchDogs(Base):

    def __init__(self, instancetype , context):
        Base.__init__(self, context)
        self.parentclass = instancetype

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def add(self, watchdog):

        '''
        @type WatchDog:


        @return WatchDog:
        '''

        url = '/instancetypes/{instancetype:id}/watchdogs'

        result = self.__getProxy().add(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{instancetype:id}': self.parentclass.get_id(),
                    }
                ),
                args={}
            ),
            body=ParseHelper.toXml(watchdog),
            headers={}
        )

        return InstanceTypeWatchDog(
            self.parentclass,
            result,
            self.context
        )

    def get(self, name=None, id=None):

        '''
        [@param id  : string (the id of the entity)]
        [@param name: string (the name of the entity)]

        @return WatchDogs:
        '''

        url = '/instancetypes/{instancetype:id}/watchdogs'

        if id:
            try :
                result = self.__getProxy().get(
                    url=UrlHelper.append(
                        UrlHelper.replace(
                            url,
                            {
                                '{instancetype:id}': self.parentclass.get_id(),
                            }
                        ),
                        id
                    ),
                    headers={}
                )

                return InstanceTypeWatchDog(
                    self.parentclass,
                    result,
                    self.context
                )
            except RequestError as err:
                if err.status and err.status == 404:
                    return None
                raise err
        elif name:
            result = self.__getProxy().get(
                url=UrlHelper.replace(
                    url,
                    {
                        '{instancetype:id}': self.parentclass.get_id(),
                    }
                ),
                headers={}
            ).get_watchdog()

            return InstanceTypeWatchDog(
                self.parentclass,
                FilterHelper.getItem(
                    FilterHelper.filter(
                        result,
                        {'name':name}
                    ),
                    query="name=" + name
                ),
                self.context
            )
        else:
            raise MissingParametersError(['id', 'name'])

    def list(self, max=None, **kwargs):
        '''
        [@param **kwargs: dict (property based filtering)"]
        [@param max: int (max results)]

        @return WatchDogs:
        '''

        url = '/instancetypes/{instancetype:id}/watchdogs'

        result = self.__getProxy().get(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{instancetype:id}': self.parentclass.get_id(),
                    }
                ),
                args={'max:matrix':max}
            ),
            headers={}
        ).get_watchdog()

        return ParseHelper.toSubCollection(
            InstanceTypeWatchDog,
            self.parentclass,
            FilterHelper.filter(
                result,
                kwargs
            ),
            context=self.context
        )

class InstanceTypes(Base):
    def __init__(self, context):
        Base.__init__(self, context)

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def add(self, instancetype, correlation_id=None, expect=None):
        '''
        @type InstanceType:

        @param instance_type.name: string
        [@param instance_type.memory: long]
        [@param instance_type.io.threads: int]
        [@param instance_type.memory_policy.guaranteed: long]
        [@param instance_type.memory_policy.ballooning: boolean]
        [@param instance_type.cpu.topology.cores: int]
        [@param instance_type.cpu.topology.threads: int]
        [@param instance_type.high_availability.enabled: boolean]
        [@param instance_type.origin: string]
        [@param instance_type.high_availability.priority: int]
        [@param instance_type.console.enabled: boolean]
        [@param instance_type.description: string]
        [@param instance_type.os.boot: collection]
        {
          [@ivar boot.dev: string]
        }
        [@param instance_type.cpu.topology.sockets: int]
        [@param instance_type.cpu_shares: int]
        [@param instance_type.cpu.architecture: string]
        [@param instance_type.display.type: string]
        [@param instance_type.display.monitors: int]
        [@param instance_typeay.single_qxl_pci: boolean]
        [@param instance_type.display.smartcard_enabled: boolean]
        [@param instance_type.usb.enabled: boolean]
        [@param instance_type.usb.type: string]
        [@param instance_type.migration_downtime: int]
        [@param instance_type.virtio_scsi.enabled: boolean]
        [@param instance_type.soundcard_enabled: boolean]
        [@param instance_type.custom_emulated_machine: string]
        [@param instance_type.custom_cpu_model: string]
        [@param correlation_id: any string]
        [@param expect: 201-created]

        @return InstanceType:
        '''

        url = '/instancetypes'

        result = self.__getProxy().add(
           url=UrlHelper.appendParameters(
                url=url,
                args={}
           ),
           body=ParseHelper.toXml(instancetype),
           headers={"Correlation-Id":correlation_id, "Expect":expect}
        )

        return InstanceType(result, self.context)

    def get(self, name=None, id=None):
        '''
        [@param id  : string (the id of the entity)]
        [@param name: string (the name of the entity)]

        @return InstanceTypes:
        '''

        url = '/instancetypes'

        if id:
            try :
                return InstanceType(
                    self.__getProxy().get(
                                url=UrlHelper.append(url, id),
                                headers={}
                    ),
                    self.context
                )
            except RequestError as err:
                if err.status and err.status == 404:
                    return None
                raise err
        elif name:
            result = self.__getProxy().get(
                    url=url,
                    headers={}
            ).get_instance_type()

            return InstanceType(
                FilterHelper.getItem(
                    FilterHelper.filter(result, {'name':name}),
                    query="name=" + name
                ),
                self.context
            )
        else:
            raise MissingParametersError(['id', 'name'])


    def list(self, max=None, **kwargs):
        '''
        [@param **kwargs: dict (property based filtering)]
        [@param max: int (max results)]

        @return InstanceTypes:
        '''

        url='/instancetypes'

        result = self.__getProxy().get(
            url=UrlHelper.appendParameters(url, {'max:matrix':max}),
            headers={}
        ).get_instance_type()

        return ParseHelper.toCollection(
            InstanceType,
            FilterHelper.filter(result, kwargs),
            context=self.context
        )

class Job(params.Job, Base):
    def __init__(self, job, context):
        Base.__init__(self, context)
        self.superclass = job

        self.steps = JobSteps(self, context)

    def __new__(cls, job, context):
        if job is None: return None
        obj = object.__new__(cls)
        obj.__init__(job, context)
        return obj

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def clear(self, action=params.Action(), correlation_id=None):
        '''
        @type Action:

        [@param action.async: boolean]
        [@param action.grace_period.expiry: long]
        [@param correlation_id: any string]

        @return Action:
        '''

        url = '/jobs/{job:id}/clear'

        result = self.__getProxy().request(
            method='POST',
            url=UrlHelper.replace(
                url,
                {
                    '{job:id}': self.get_id(),
                }
            ),
            body=ParseHelper.toXml(action),
            headers={"Correlation-Id":correlation_id}
        )

        return result

    def end(self, action=params.Action(), correlation_id=None):
        '''
        @type Action:

        @param action.status.state: string
        [@param action.force: boolean]
        [@param action.async: boolean]
        [@param action.grace_period.expiry: long]
        [@param correlation_id: any string]

        @return Action:
        '''

        url = '/jobs/{job:id}/end'

        result = self.__getProxy().request(
            method='POST',
            url=UrlHelper.replace(
                url,
                {
                    '{job:id}': self.get_id(),
                }
            ),
            body=ParseHelper.toXml(action),
            headers={"Correlation-Id":correlation_id}
        )

        return result

class JobStep(params.Step, Base):
    def __init__(self, job, step, context):
        Base.__init__(self, context)
        self.parentclass = job
        self.superclass  =  step

        self.statistics = JobStepStatistics(self, context)

    def __new__(cls, job, step, context):
        if step is None: return None
        obj = object.__new__(cls)
        obj.__init__(job, step, context)
        return obj

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def end(self, action=params.Action(), correlation_id=None):
        '''
        @type Action:

        @param action.succeeded: boolean
        [@param action.force: boolean]
        [@param action.status.state: string]
        [@param action.async: boolean]
        [@param action.grace_period.expiry: long]
        [@param correlation_id: any string]

        @return Action:
        '''

        url = '/jobs/{job:id}/steps/{step:id}/end'

        result = self.__getProxy().request(
            method='POST',
            url=UrlHelper.replace(
                url,
                {
                    '{job:id}': self.parentclass.get_id(),
                    '{step:id}': self.get_id(),
                }
            ),
            body=ParseHelper.toXml(action),
            headers={"Correlation-Id":correlation_id}
        )

        return result

class JobStepStatistic(params.Statistic, Base):
    def __init__(self, jobstep, statistic, context):
        Base.__init__(self, context)
        self.parentclass = jobstep
        self.superclass  =  statistic

        #SUB_COLLECTIONS
    def __new__(cls, jobstep, statistic, context):
        if statistic is None: return None
        obj = object.__new__(cls)
        obj.__init__(jobstep, statistic, context)
        return obj

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

class JobStepStatistics(Base):

    def __init__(self, step , context):
        Base.__init__(self, context)
        self.parentclass = step

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def get(self, name=None, id=None):

        '''
        [@param id  : string (the id of the entity)]
        [@param name: string (the name of the entity)]

        @return Statistics:
        '''

        url = '/jobs/{job:id}/steps/{step:id}/statistics'

        if id:
            try :
                result = self.__getProxy().get(
                    url=UrlHelper.append(
                        UrlHelper.replace(
                            url,
                            {
                                '{job:id}': self.parentclass.parentclass.get_id(),
                                '{step:id}': self.parentclass.get_id(),
                            }
                        ),
                        id
                    ),
                    headers={}
                )

                return JobStepStatistic(
                    self.parentclass,
                    result,
                    self.context
                )
            except RequestError as err:
                if err.status and err.status == 404:
                    return None
                raise err
        elif name:
            result = self.__getProxy().get(
                url=UrlHelper.replace(
                    url,
                    {
                        '{job:id}': self.parentclass.parentclass.get_id(),
                        '{step:id}': self.parentclass.get_id(),
                    }
                ),
                headers={}
            ).get_statistic()

            return JobStepStatistic(
                self.parentclass,
                FilterHelper.getItem(
                    FilterHelper.filter(
                        result,
                        {'name':name}
                    ),
                    query="name=" + name
                ),
                self.context
            )
        else:
            raise MissingParametersError(['id', 'name'])

    def list(self, **kwargs):
        '''
        [@param **kwargs: dict (property based filtering)"]

        @return Statistics:
        '''

        url = '/jobs/{job:id}/steps/{step:id}/statistics'

        result = self.__getProxy().get(
            url=UrlHelper.replace(
                url,
                {
                    '{job:id}': self.parentclass.parentclass.get_id(),
                    '{step:id}': self.parentclass.get_id(),
                }
            )
        ).get_statistic()

        return ParseHelper.toSubCollection(
            JobStepStatistic,
            self.parentclass,
            FilterHelper.filter(
                result,
                kwargs
            ),
            context=self.context
        )

class JobSteps(Base):

    def __init__(self, job , context):
        Base.__init__(self, context)
        self.parentclass = job

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def add(self, step, correlation_id=None, expect=None):

        '''
        @type Step:

        @param step.type: string
        @param step.description: string
        [@param step.job.id: string]
        [@param step.parent_step.id: string]
        [@param correlation_id: any string]
        [@param expect: 201-created]

        @return Step:
        '''

        url = '/jobs/{job:id}/steps'

        result = self.__getProxy().add(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{job:id}': self.parentclass.get_id(),
                    }
                ),
                args={}
            ),
            body=ParseHelper.toXml(step),
            headers={"Correlation-Id":correlation_id, "Expect":expect}
        )

        return JobStep(
            self.parentclass,
            result,
            self.context
        )

    def get(self, name=None, id=None):

        '''
        [@param id  : string (the id of the entity)]
        [@param name: string (the name of the entity)]

        @return Steps:
        '''

        url = '/jobs/{job:id}/steps'

        if id:
            try :
                result = self.__getProxy().get(
                    url=UrlHelper.append(
                        UrlHelper.replace(
                            url,
                            {
                                '{job:id}': self.parentclass.get_id(),
                            }
                        ),
                        id
                    ),
                    headers={}
                )

                return JobStep(
                    self.parentclass,
                    result,
                    self.context
                )
            except RequestError as err:
                if err.status and err.status == 404:
                    return None
                raise err
        elif name:
            result = self.__getProxy().get(
                url=UrlHelper.replace(
                    url,
                    {
                        '{job:id}': self.parentclass.get_id(),
                    }
                ),
                headers={}
            ).get_step()

            return JobStep(
                self.parentclass,
                FilterHelper.getItem(
                    FilterHelper.filter(
                        result,
                        {'name':name}
                    ),
                    query="name=" + name
                ),
                self.context
            )
        else:
            raise MissingParametersError(['id', 'name'])

    def list(self, max=None, **kwargs):
        '''
        [@param **kwargs: dict (property based filtering)"]
        [@param max: int (max results)]

        @return Steps:
        '''

        url = '/jobs/{job:id}/steps'

        result = self.__getProxy().get(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{job:id}': self.parentclass.get_id(),
                    }
                ),
                args={'max:matrix':max}
            ),
            headers={}
        ).get_step()

        return ParseHelper.toSubCollection(
            JobStep,
            self.parentclass,
            FilterHelper.filter(
                result,
                kwargs
            ),
            context=self.context
        )

class Jobs(Base):
    def __init__(self, context):
        Base.__init__(self, context)

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def add(self, job, correlation_id=None, expect=None):
        '''
        @type Job:

        @param job.description: string
        [@param job.auto_cleared: boolean]
        [@param correlation_id: any string]
        [@param expect: 201-created]

        @return Job:
        '''

        url = '/jobs'

        result = self.__getProxy().add(
           url=UrlHelper.appendParameters(
                url=url,
                args={}
           ),
           body=ParseHelper.toXml(job),
           headers={"Correlation-Id":correlation_id, "Expect":expect}
        )

        return Job(result, self.context)

    def get(self, name=None, id=None):
        '''
        [@param id  : string (the id of the entity)]
        [@param name: string (the name of the entity)]

        @return Jobs:
        '''

        url = '/jobs'

        if id:
            try :
                return Job(
                    self.__getProxy().get(
                                url=UrlHelper.append(url, id),
                                headers={}
                    ),
                    self.context
                )
            except RequestError as err:
                if err.status and err.status == 404:
                    return None
                raise err
        elif name:
            result = self.__getProxy().get(
                    url=url,
                    headers={}
            ).get_job()

            return Job(
                FilterHelper.getItem(
                    FilterHelper.filter(result, {'name':name}),
                    query="name=" + name
                ),
                self.context
            )
        else:
            raise MissingParametersError(['id', 'name'])


    def list(self, max=None, **kwargs):
        '''
        [@param **kwargs: dict (property based filtering)]
        [@param max: int (max results)]

        @return Jobs:
        '''

        url='/jobs'

        result = self.__getProxy().get(
            url=UrlHelper.appendParameters(url, {'max:matrix':max}),
            headers={}
        ).get_job()

        return ParseHelper.toCollection(
            Job,
            FilterHelper.filter(result, kwargs),
            context=self.context
        )

class KatelloErrata(Base):
    def __init__(self, context):
        Base.__init__(self, context)

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def get(self, name=None, id=None):
        '''
        [@param id  : string (the id of the entity)]
        [@param name: string (the name of the entity)]

        @return KatelloErrata:
        '''

        url = '/katelloerrata'

        if id:
            try :
                return KatelloErratum(
                    self.__getProxy().get(
                                url=UrlHelper.append(url, id),
                                headers={}
                    ),
                    self.context
                )
            except RequestError as err:
                if err.status and err.status == 404:
                    return None
                raise err
        elif name:
            result = self.__getProxy().get(
                    url=url,
                    headers={}
            ).get_katello_erratum()

            return KatelloErratum(
                FilterHelper.getItem(
                    FilterHelper.filter(result, {'name':name}),
                    query="name=" + name
                ),
                self.context
            )
        else:
            raise MissingParametersError(['id', 'name'])


    def list(self, max=None, **kwargs):
        '''
        [@param **kwargs: dict (property based filtering)]
        [@param max: int (max results)]

        @return KatelloErrata:
        '''

        url='/katelloerrata'

        result = self.__getProxy().get(
            url=UrlHelper.appendParameters(url, {'max:matrix':max}),
            headers={}
        ).get_katello_erratum()

        return ParseHelper.toCollection(
            KatelloErratum,
            FilterHelper.filter(result, kwargs),
            context=self.context
        )

class KatelloErratum(params.KatelloErratum, Base):
    def __init__(self, katelloerratum, context):
        Base.__init__(self, context)
        self.superclass = katelloerratum

        #SUB_COLLECTIONS
    def __new__(cls, katelloerratum, context):
        if katelloerratum is None: return None
        obj = object.__new__(cls)
        obj.__init__(katelloerratum, context)
        return obj

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

class MacPool(params.MacPool, Base):
    def __init__(self, macpool, context):
        Base.__init__(self, context)
        self.superclass = macpool

        #SUB_COLLECTIONS
    def __new__(cls, macpool, context):
        if macpool is None: return None
        obj = object.__new__(cls)
        obj.__init__(macpool, context)
        return obj

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def delete(self, async=None, correlation_id=None):
        '''
        [@param async: boolean (true|false)]
        [@param correlation_id: any string]

        @return None:
        '''

        url = UrlHelper.replace(
            '/macpools/{macpool:id}',
            {
                '{macpool:id}': self.get_id(),
            }
        )

        return self.__getProxy().delete(
            url=UrlHelper.appendParameters(
                url,
                {'async:matrix':async}
            ),
            headers={"Correlation-Id":correlation_id,"Content-type":None}
        )

    def update(self, correlation_id=None, expect=None):
        '''
        [@param macpool.name: string]
        [@param macpool.description: string]
        [@param macpool.allow_duplicates: boolean]
        [@param macpool.default_pool: boolean]
        [@param macpool.ranges.range: collection]
        {
          [@ivar range.from: string]
          [@ivar range.to: string]
        }
        [@param correlation_id: any string]
        [@param expect: 202-accepted]

        @return MacPool:
        '''

        url = '/macpools/{macpool:id}'

        result = self.__getProxy().update(
            url=UrlHelper.replace(
                url,
                {
                    '{macpool:id}': self.get_id(),
                }
            ),
            body=ParseHelper.toXml(self.superclass),
            headers={"Correlation-Id":correlation_id, "Expect":expect}
        )

        return MacPool(result, self.context)

class MacPools(Base):
    def __init__(self, context):
        Base.__init__(self, context)

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def add(self, macpool, correlation_id=None, expect=None):
        '''
        @type MacPool:

        @param macpool.name: string
        @param macpool.ranges.range: collection
        {
          @ivar range.from: string
          @ivar range.to: string
        }
        [@param macpool.description: string]
        [@param macpool.allow_duplicates: boolean]
        [@param macpool.default_pool: boolean]
        [@param correlation_id: any string]
        [@param expect: 201-created]

        @return MacPool:
        '''

        url = '/macpools'

        result = self.__getProxy().add(
           url=UrlHelper.appendParameters(
                url=url,
                args={}
           ),
           body=ParseHelper.toXml(macpool),
           headers={"Correlation-Id":correlation_id, "Expect":expect}
        )

        return MacPool(result, self.context)

    def get(self, name=None, id=None):
        '''
        [@param id  : string (the id of the entity)]
        [@param name: string (the name of the entity)]

        @return MacPools:
        '''

        url = '/macpools'

        if id:
            try :
                return MacPool(
                    self.__getProxy().get(
                                url=UrlHelper.append(url, id),
                                headers={}
                    ),
                    self.context
                )
            except RequestError as err:
                if err.status and err.status == 404:
                    return None
                raise err
        elif name:
            result = self.__getProxy().get(
                    url=url,
                    headers={}
            ).get_mac_pool()

            return MacPool(
                FilterHelper.getItem(
                    FilterHelper.filter(result, {'name':name}),
                    query="name=" + name
                ),
                self.context
            )
        else:
            raise MissingParametersError(['id', 'name'])


    def list(self, max=None, **kwargs):
        '''
        [@param **kwargs: dict (property based filtering)]
        [@param max: int (max results)]

        @return MacPools:
        '''

        url='/macpools'

        result = self.__getProxy().get(
            url=UrlHelper.appendParameters(url, {'max:matrix':max}),
            headers={}
        ).get_mac_pool()

        return ParseHelper.toCollection(
            MacPool,
            FilterHelper.filter(result, kwargs),
            context=self.context
        )

class Network(params.Network, Base):
    def __init__(self, network, context):
        Base.__init__(self, context)
        self.superclass = network

        self.labels = NetworkLabels(self, context)
        self.permissions = NetworkPermissions(self, context)
        self.vnicprofiles = NetworkVnicProfiles(self, context)

    def __new__(cls, network, context):
        if network is None: return None
        obj = object.__new__(cls)
        obj.__init__(network, context)
        return obj

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def delete(self, async=None, correlation_id=None):
        '''
        [@param async: boolean (true|false)]
        [@param correlation_id: any string]

        @return None:
        '''

        url = UrlHelper.replace(
            '/networks/{network:id}',
            {
                '{network:id}': self.get_id(),
            }
        )

        return self.__getProxy().delete(
            url=UrlHelper.appendParameters(
                url,
                {'async:matrix':async}
            ),
            headers={"Correlation-Id":correlation_id,"Content-type":None}
        )

    def update(self, correlation_id=None, expect=None):
        '''
        [@param network.name: string]
        [@param network.description: string]
        [@param network.comment: string]
        [@param network.vlan.id: string]
        [@param network.ip.address: string]
        [@param network.ip.gateway: string]
        [@param network.ip.netmask: string]
        [@param network.display: boolean]
        [@param network.stp: boolean]
        [@param network.mtu: int]
        [@param correlation_id: any string]
        [@param expect: 202-accepted]

        @return Network:
        '''

        url = '/networks/{network:id}'

        result = self.__getProxy().update(
            url=UrlHelper.replace(
                url,
                {
                    '{network:id}': self.get_id(),
                }
            ),
            body=ParseHelper.toXml(self.superclass),
            headers={"Correlation-Id":correlation_id, "Expect":expect}
        )

        return Network(result, self.context)

class NetworkLabel(params.Label, Base):
    def __init__(self, network, label, context):
        Base.__init__(self, context)
        self.parentclass = network
        self.superclass  =  label

        #SUB_COLLECTIONS
    def __new__(cls, network, label, context):
        if label is None: return None
        obj = object.__new__(cls)
        obj.__init__(network, label, context)
        return obj

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def delete(self, async=None, correlation_id=None):
        '''
        [@param async: boolean (true|false)]
        [@param correlation_id: any string]

        @return None:
        '''

        url = UrlHelper.replace(
            '/networks/{network:id}/labels/{label:id}',
            {
                '{network:id}': self.parentclass.get_id(),
                '{label:id}': self.get_id(),
            }
        )

        return self.__getProxy().delete(
            url=UrlHelper.appendParameters(
                url,
                {'async:matrix':async}
            ),
            headers={"Correlation-Id":correlation_id,"Content-type":None}
        )

class NetworkLabels(Base):

    def __init__(self, network , context):
        Base.__init__(self, context)
        self.parentclass = network

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def add(self, label, correlation_id=None, expect=None):

        '''
        @type Label:

        @param label.id: string
        [@param correlation_id: any string]
        [@param expect: 201-created]

        @return Label:
        '''

        url = '/networks/{network:id}/labels'

        result = self.__getProxy().add(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{network:id}': self.parentclass.get_id(),
                    }
                ),
                args={}
            ),
            body=ParseHelper.toXml(label),
            headers={"Correlation-Id":correlation_id, "Expect":expect}
        )

        return NetworkLabel(
            self.parentclass,
            result,
            self.context
        )

    def get(self, name=None, id=None):

        '''
        [@param id  : string (the id of the entity)]
        [@param name: string (the name of the entity)]

        @return Labels:
        '''

        url = '/networks/{network:id}/labels'

        if id:
            try :
                result = self.__getProxy().get(
                    url=UrlHelper.append(
                        UrlHelper.replace(
                            url,
                            {
                                '{network:id}': self.parentclass.get_id(),
                            }
                        ),
                        id
                    ),
                    headers={}
                )

                return NetworkLabel(
                    self.parentclass,
                    result,
                    self.context
                )
            except RequestError as err:
                if err.status and err.status == 404:
                    return None
                raise err
        elif name:
            result = self.__getProxy().get(
                url=UrlHelper.replace(
                    url,
                    {
                        '{network:id}': self.parentclass.get_id(),
                    }
                ),
                headers={}
            ).get_label()

            return NetworkLabel(
                self.parentclass,
                FilterHelper.getItem(
                    FilterHelper.filter(
                        result,
                        {'name':name}
                    ),
                    query="name=" + name
                ),
                self.context
            )
        else:
            raise MissingParametersError(['id', 'name'])

    def list(self, max=None, **kwargs):
        '''
        [@param **kwargs: dict (property based filtering)"]
        [@param max: int (max results)]

        @return Labels:
        '''

        url = '/networks/{network:id}/labels'

        result = self.__getProxy().get(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{network:id}': self.parentclass.get_id(),
                    }
                ),
                args={'max:matrix':max}
            ),
            headers={}
        ).get_label()

        return ParseHelper.toSubCollection(
            NetworkLabel,
            self.parentclass,
            FilterHelper.filter(
                result,
                kwargs
            ),
            context=self.context
        )

class NetworkPermission(params.Permission, Base):
    def __init__(self, network, permission, context):
        Base.__init__(self, context)
        self.parentclass = network
        self.superclass  =  permission

        #SUB_COLLECTIONS
    def __new__(cls, network, permission, context):
        if permission is None: return None
        obj = object.__new__(cls)
        obj.__init__(network, permission, context)
        return obj

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def delete(self, async=None, correlation_id=None):
        '''
        [@param async: boolean (true|false)]
        [@param correlation_id: any string]

        @return None:
        '''

        url = UrlHelper.replace(
            '/networks/{network:id}/permissions/{permission:id}',
            {
                '{network:id}': self.parentclass.get_id(),
                '{permission:id}': self.get_id(),
            }
        )

        return self.__getProxy().delete(
            url=UrlHelper.appendParameters(
                url,
                {'async:matrix':async}
            ),
            headers={"Correlation-Id":correlation_id,"Content-type":None}
        )

class NetworkPermissions(Base):

    def __init__(self, network , context):
        Base.__init__(self, context)
        self.parentclass = network

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def add(self, permission, correlation_id=None, expect=None):

        '''
        @type Permission:

        Overload 1:
          @param permission.user.id: string
          @param permission.role.id|name: string
        Overload 2:
          @param permission.group.id: string
          @param permission.role.id|name: string
        [@param correlation_id: any string]
        [@param expect: 201-created]

        @return Permission:
        '''

        url = '/networks/{network:id}/permissions'

        result = self.__getProxy().add(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{network:id}': self.parentclass.get_id(),
                    }
                ),
                args={}
            ),
            body=ParseHelper.toXml(permission),
            headers={"Correlation-Id":correlation_id, "Expect":expect}
        )

        return NetworkPermission(
            self.parentclass,
            result,
            self.context
        )

    def get(self, name=None, id=None):

        '''
        [@param id  : string (the id of the entity)]
        [@param name: string (the name of the entity)]

        @return Permissions:
        '''

        url = '/networks/{network:id}/permissions'

        if id:
            try :
                result = self.__getProxy().get(
                    url=UrlHelper.append(
                        UrlHelper.replace(
                            url,
                            {
                                '{network:id}': self.parentclass.get_id(),
                            }
                        ),
                        id
                    ),
                    headers={}
                )

                return NetworkPermission(
                    self.parentclass,
                    result,
                    self.context
                )
            except RequestError as err:
                if err.status and err.status == 404:
                    return None
                raise err
        elif name:
            result = self.__getProxy().get(
                url=UrlHelper.replace(
                    url,
                    {
                        '{network:id}': self.parentclass.get_id(),
                    }
                ),
                headers={}
            ).get_permission()

            return NetworkPermission(
                self.parentclass,
                FilterHelper.getItem(
                    FilterHelper.filter(
                        result,
                        {'name':name}
                    ),
                    query="name=" + name
                ),
                self.context
            )
        else:
            raise MissingParametersError(['id', 'name'])

    def list(self, max=None, **kwargs):
        '''
        [@param **kwargs: dict (property based filtering)"]
        [@param max: int (max results)]

        @return Permissions:
        '''

        url = '/networks/{network:id}/permissions'

        result = self.__getProxy().get(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{network:id}': self.parentclass.get_id(),
                    }
                ),
                args={'max:matrix':max}
            ),
            headers={}
        ).get_permission()

        return ParseHelper.toSubCollection(
            NetworkPermission,
            self.parentclass,
            FilterHelper.filter(
                result,
                kwargs
            ),
            context=self.context
        )

class NetworkVnicProfile(params.VnicProfile, Base):
    def __init__(self, network, vnicprofile, context):
        Base.__init__(self, context)
        self.parentclass = network
        self.superclass  =  vnicprofile

        self.permissions = NetworkVnicProfilePermissions(self, context)

    def __new__(cls, network, vnicprofile, context):
        if vnicprofile is None: return None
        obj = object.__new__(cls)
        obj.__init__(network, vnicprofile, context)
        return obj

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def delete(self, async=None, correlation_id=None):
        '''
        [@param async: boolean (true|false)]
        [@param correlation_id: any string]

        @return None:
        '''

        url = UrlHelper.replace(
            '/networks/{network:id}/vnicprofiles/{vnicprofile:id}',
            {
                '{network:id}': self.parentclass.get_id(),
                '{vnicprofile:id}': self.get_id(),
            }
        )

        return self.__getProxy().delete(
            url=UrlHelper.appendParameters(
                url,
                {'async:matrix':async}
            ),
            headers={"Correlation-Id":correlation_id,"Content-type":None}
        )

class NetworkVnicProfilePermission(params.Permission, Base):
    def __init__(self, networkvnicprofile, permission, context):
        Base.__init__(self, context)
        self.parentclass = networkvnicprofile
        self.superclass  =  permission

        #SUB_COLLECTIONS
    def __new__(cls, networkvnicprofile, permission, context):
        if permission is None: return None
        obj = object.__new__(cls)
        obj.__init__(networkvnicprofile, permission, context)
        return obj

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def delete(self, async=None):
        '''
        [@param async: boolean (true|false)]

        @return None:
        '''

        url = UrlHelper.replace(
            '/networks/{network:id}/vnicprofiles/{vnicprofile:id}/permissions/{permission:id}',
            {
                '{network:id}': self.parentclass.parentclass.get_id(),
                '{vnicprofile:id}': self.parentclass.get_id(),
                '{permission:id}': self.get_id(),
            }
        )

        return self.__getProxy().delete(
            url=UrlHelper.appendParameters(
                url,
                {'async:matrix':async}
            ),
            headers={"Content-type":None}
        )

class NetworkVnicProfilePermissions(Base):

    def __init__(self, vnicprofile , context):
        Base.__init__(self, context)
        self.parentclass = vnicprofile

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def add(self, permission):

        '''
        @type Permission:


        @return Permission:
        '''

        url = '/networks/{network:id}/vnicprofiles/{vnicprofile:id}/permissions'

        result = self.__getProxy().add(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{network:id}': self.parentclass.parentclass.get_id(),
                        '{vnicprofile:id}': self.parentclass.get_id(),
                    }
                ),
                args={}
            ),
            body=ParseHelper.toXml(permission),
            headers={}
        )

        return NetworkVnicProfilePermission(
            self.parentclass,
            result,
            self.context
        )

    def get(self, name=None, id=None):

        '''
        [@param id  : string (the id of the entity)]
        [@param name: string (the name of the entity)]

        @return Permissions:
        '''

        url = '/networks/{network:id}/vnicprofiles/{vnicprofile:id}/permissions'

        if id:
            try :
                result = self.__getProxy().get(
                    url=UrlHelper.append(
                        UrlHelper.replace(
                            url,
                            {
                                '{network:id}': self.parentclass.parentclass.get_id(),
                                '{vnicprofile:id}': self.parentclass.get_id(),
                            }
                        ),
                        id
                    ),
                    headers={}
                )

                return NetworkVnicProfilePermission(
                    self.parentclass,
                    result,
                    self.context
                )
            except RequestError as err:
                if err.status and err.status == 404:
                    return None
                raise err
        elif name:
            result = self.__getProxy().get(
                url=UrlHelper.replace(
                    url,
                    {
                        '{network:id}': self.parentclass.parentclass.get_id(),
                        '{vnicprofile:id}': self.parentclass.get_id(),
                    }
                ),
                headers={}
            ).get_permission()

            return NetworkVnicProfilePermission(
                self.parentclass,
                FilterHelper.getItem(
                    FilterHelper.filter(
                        result,
                        {'name':name}
                    ),
                    query="name=" + name
                ),
                self.context
            )
        else:
            raise MissingParametersError(['id', 'name'])

    def list(self, max=None, **kwargs):
        '''
        [@param **kwargs: dict (property based filtering)"]
        [@param max: int (max results)]

        @return Permissions:
        '''

        url = '/networks/{network:id}/vnicprofiles/{vnicprofile:id}/permissions'

        result = self.__getProxy().get(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{network:id}': self.parentclass.parentclass.get_id(),
                        '{vnicprofile:id}': self.parentclass.get_id(),
                    }
                ),
                args={'max:matrix':max}
            ),
            headers={}
        ).get_permission()

        return ParseHelper.toSubCollection(
            NetworkVnicProfilePermission,
            self.parentclass,
            FilterHelper.filter(
                result,
                kwargs
            ),
            context=self.context
        )

class NetworkVnicProfiles(Base):

    def __init__(self, network , context):
        Base.__init__(self, context)
        self.parentclass = network

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def add(self, vnicprofile, correlation_id=None, expect=None):

        '''
        @type VnicProfile:

        @param vnicprofile.name: string
        [@param vnicprofile.description: string]
        [@param vnicprofile.port_mirroring: boolean]
        [@param vnicprofile.custom_properties.custom_property: collection]
        {
          [@ivar custom_property.name: string]
          [@ivar custom_property.value: string]
        }
        [@param vnicprofile.pass_through.mode: string]
        [@param correlation_id: any string]
        [@param expect: 201-created]

        @return VnicProfile:
        '''

        url = '/networks/{network:id}/vnicprofiles'

        result = self.__getProxy().add(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{network:id}': self.parentclass.get_id(),
                    }
                ),
                args={}
            ),
            body=ParseHelper.toXml(vnicprofile),
            headers={"Correlation-Id":correlation_id, "Expect":expect}
        )

        return NetworkVnicProfile(
            self.parentclass,
            result,
            self.context
        )

    def get(self, name=None, id=None):

        '''
        [@param id  : string (the id of the entity)]
        [@param name: string (the name of the entity)]

        @return VnicProfiles:
        '''

        url = '/networks/{network:id}/vnicprofiles'

        if id:
            try :
                result = self.__getProxy().get(
                    url=UrlHelper.append(
                        UrlHelper.replace(
                            url,
                            {
                                '{network:id}': self.parentclass.get_id(),
                            }
                        ),
                        id
                    ),
                    headers={}
                )

                return NetworkVnicProfile(
                    self.parentclass,
                    result,
                    self.context
                )
            except RequestError as err:
                if err.status and err.status == 404:
                    return None
                raise err
        elif name:
            result = self.__getProxy().get(
                url=UrlHelper.replace(
                    url,
                    {
                        '{network:id}': self.parentclass.get_id(),
                    }
                ),
                headers={}
            ).get_vnic_profile()

            return NetworkVnicProfile(
                self.parentclass,
                FilterHelper.getItem(
                    FilterHelper.filter(
                        result,
                        {'name':name}
                    ),
                    query="name=" + name
                ),
                self.context
            )
        else:
            raise MissingParametersError(['id', 'name'])

    def list(self, max=None, **kwargs):
        '''
        [@param **kwargs: dict (property based filtering)"]
        [@param max: int (max results)]

        @return VnicProfiles:
        '''

        url = '/networks/{network:id}/vnicprofiles'

        result = self.__getProxy().get(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{network:id}': self.parentclass.get_id(),
                    }
                ),
                args={'max:matrix':max}
            ),
            headers={}
        ).get_vnic_profile()

        return ParseHelper.toSubCollection(
            NetworkVnicProfile,
            self.parentclass,
            FilterHelper.filter(
                result,
                kwargs
            ),
            context=self.context
        )

class Networks(Base):
    def __init__(self, context):
        Base.__init__(self, context)

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def add(self, network, correlation_id=None, expect=None):
        '''
        @type Network:

        @param network.data_center.id|name: string
        @param network.name: string
        [@param network.description: string]
        [@param network.comment: string]
        [@param network.vlan.id: string]
        [@param network.ip.address: string]
        [@param network.ip.gateway: string]
        [@param network.ip.netmask: string]
        [@param network.stp: boolean]
        [@param network.mtu: int]
        [@param network.profile_required: boolean]
        [@param network.usages.usage: collection]
        {
          [@ivar usage: string]
        }
        [@param correlation_id: any string]
        [@param expect: 201-created]

        @return Network:
        '''

        url = '/networks'

        result = self.__getProxy().add(
           url=UrlHelper.appendParameters(
                url=url,
                args={}
           ),
           body=ParseHelper.toXml(network),
           headers={"Correlation-Id":correlation_id, "Expect":expect}
        )

        return Network(result, self.context)

    def get(self, name=None, id=None):
        '''
        [@param id  : string (the id of the entity)]
        [@param name: string (the name of the entity)]

        @return Networks:
        '''

        url = '/networks'

        if id:
            try :
                return Network(
                    self.__getProxy().get(
                        url=UrlHelper.append(url, id),
                        headers={}
                    ),
                    self.context
                )
            except RequestError as err:
                if err.status and err.status == 404:
                    return None
                raise err
        elif name:
            result = self.__getProxy().get(
                url=UrlHelper.appendParameters(url, {'search:query':'name='+name}),
                headers={}
            ).get_network()

            return Network(
                FilterHelper.getItem(
                    FilterHelper.filter(result, {'name':name}),
                    query="name=" + name
                ),
                self.context
            )
        else:
            raise MissingParametersError(['id', 'name'])

    def list(self, query=None, case_sensitive=True, max=None, **kwargs):
        '''
        [@param **kwargs: dict (property based filtering)]
        [@param query: string (oVirt engine search dialect query)]
        [@param case_sensitive: boolean (true|false)]
        [@param max: int (max results)]

        @return Networks:
        '''

        url='/networks'

        result = self.__getProxy().get(
            url=UrlHelper.appendParameters(url, {'search:query':query,'case_sensitive:matrix':case_sensitive,'max:matrix':max}),
            headers={}
        ).get_network()

        return ParseHelper.toCollection(
            Network,
            FilterHelper.filter(result, kwargs),
            context=self.context
        )

class OpenStackImageProvider(params.OpenStackImageProvider, Base):
    def __init__(self, openstackimageprovider, context):
        Base.__init__(self, context)
        self.superclass = openstackimageprovider

        self.certificates = OpenStackImageProviderCertificates(self, context)
        self.images = OpenStackImageProviderOpenStackImages(self, context)

    def __new__(cls, openstackimageprovider, context):
        if openstackimageprovider is None: return None
        obj = object.__new__(cls)
        obj.__init__(openstackimageprovider, context)
        return obj

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def delete(self, async=None, correlation_id=None):
        '''
        [@param async: boolean (true|false)]
        [@param correlation_id: any string]

        @return None:
        '''

        url = UrlHelper.replace(
            '/openstackimageproviders/{openstackimageprovider:id}',
            {
                '{openstackimageprovider:id}': self.get_id(),
            }
        )

        return self.__getProxy().delete(
            url=UrlHelper.appendParameters(
                url,
                {'async:matrix':async}
            ),
            headers={"Correlation-Id":correlation_id,"Content-type":None}
        )

    def update(self, correlation_id=None, expect=None):
        '''
        [@param openstack_image_provider.name: string]
        [@param openstack_image_provider.description: string]
        [@param openstack_image_provider.requires_authentication: boolean]
        [@param openstack_image_provider.username: string]
        [@param openstack_image_provider.password: string]
        [@param openstack_image_provider.authentication_url: string]
        [@param openstack_image_provider.properties.property: collection]
        {
          [@ivar property.name: string]
          [@ivar property.value: string]
        }
        [@param openstack_image_provider.tenant_name: string]
        [@param correlation_id: any string]
        [@param expect: 202-accepted]

        @return OpenStackImageProvider:
        '''

        url = '/openstackimageproviders/{openstackimageprovider:id}'

        result = self.__getProxy().update(
            url=UrlHelper.replace(
                url,
                {
                    '{openstackimageprovider:id}': self.get_id(),
                }
            ),
            body=ParseHelper.toXml(self.superclass),
            headers={"Correlation-Id":correlation_id, "Expect":expect}
        )

        return OpenStackImageProvider(result, self.context)

    def importcertificates(self, action=params.Action(), correlation_id=None):
        '''
        @type Action:

        @param certificates.certificate: collection
        {
          @ivar content: string
        }
        [@param action.async: boolean]
        [@param action.grace_period.expiry: long]
        [@param correlation_id: any string]

        @return Action:
        '''

        url = '/openstackimageproviders/{openstackimageprovider:id}/importcertificates'

        result = self.__getProxy().request(
            method='POST',
            url=UrlHelper.replace(
                url,
                {
                    '{openstackimageprovider:id}': self.get_id(),
                }
            ),
            body=ParseHelper.toXml(action),
            headers={"Correlation-Id":correlation_id}
        )

        return result

    def testconnectivity(self, action=params.Action(), correlation_id=None):
        '''
        @type Action:

        [@param action.async: boolean]
        [@param action.grace_period.expiry: long]
        [@param correlation_id: any string]

        @return Action:
        '''

        url = '/openstackimageproviders/{openstackimageprovider:id}/testconnectivity'

        result = self.__getProxy().request(
            method='POST',
            url=UrlHelper.replace(
                url,
                {
                    '{openstackimageprovider:id}': self.get_id(),
                }
            ),
            body=ParseHelper.toXml(action),
            headers={"Correlation-Id":correlation_id}
        )

        return result

class OpenStackImageProviderCertificate(params.Certificate, Base):
    def __init__(self, openstackimageprovider, certificate, context):
        Base.__init__(self, context)
        self.parentclass = openstackimageprovider
        self.superclass  =  certificate

        #SUB_COLLECTIONS
    def __new__(cls, openstackimageprovider, certificate, context):
        if certificate is None: return None
        obj = object.__new__(cls)
        obj.__init__(openstackimageprovider, certificate, context)
        return obj

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

class OpenStackImageProviderCertificates(Base):

    def __init__(self, openstackimageprovider , context):
        Base.__init__(self, context)
        self.parentclass = openstackimageprovider

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def get(self, name=None, id=None):

        '''
        [@param id  : string (the id of the entity)]
        [@param name: string (the name of the entity)]

        @return Certificates:
        '''

        url = '/openstackimageproviders/{openstackimageprovider:id}/certificates'

        if id:
            try :
                result = self.__getProxy().get(
                    url=UrlHelper.append(
                        UrlHelper.replace(
                            url,
                            {
                                '{openstackimageprovider:id}': self.parentclass.get_id(),
                            }
                        ),
                        id
                    ),
                    headers={}
                )

                return OpenStackImageProviderCertificate(
                    self.parentclass,
                    result,
                    self.context
                )
            except RequestError as err:
                if err.status and err.status == 404:
                    return None
                raise err
        elif name:
            result = self.__getProxy().get(
                url=UrlHelper.replace(
                    url,
                    {
                        '{openstackimageprovider:id}': self.parentclass.get_id(),
                    }
                ),
                headers={}
            ).get_certificate()

            return OpenStackImageProviderCertificate(
                self.parentclass,
                FilterHelper.getItem(
                    FilterHelper.filter(
                        result,
                        {'name':name}
                    ),
                    query="name=" + name
                ),
                self.context
            )
        else:
            raise MissingParametersError(['id', 'name'])

    def list(self, max=None, **kwargs):
        '''
        [@param **kwargs: dict (property based filtering)"]
        [@param max: int (max results)]

        @return Certificates:
        '''

        url = '/openstackimageproviders/{openstackimageprovider:id}/certificates'

        result = self.__getProxy().get(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{openstackimageprovider:id}': self.parentclass.get_id(),
                    }
                ),
                args={'max:matrix':max}
            ),
            headers={}
        ).get_certificate()

        return ParseHelper.toSubCollection(
            OpenStackImageProviderCertificate,
            self.parentclass,
            FilterHelper.filter(
                result,
                kwargs
            ),
            context=self.context
        )

class OpenStackImageProviderOpenStackImage(params.OpenStackImage, Base):
    def __init__(self, openstackimageprovider, openstackimage, context):
        Base.__init__(self, context)
        self.parentclass = openstackimageprovider
        self.superclass  =  openstackimage

        #SUB_COLLECTIONS
    def __new__(cls, openstackimageprovider, openstackimage, context):
        if openstackimage is None: return None
        obj = object.__new__(cls)
        obj.__init__(openstackimageprovider, openstackimage, context)
        return obj

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def import_image(self, action=params.Action(), correlation_id=None):
        '''
        @type Action:

        @param action.storagedomain.id|name: string
        [@param action.import_as_template: boolean]
        [@param action.cluster.id|name: string]
        [@param action.disk.alias|name: string]
        [@param action.template.name: string]
        [@param action.async: boolean]
        [@param action.grace_period.expiry: long]
        [@param correlation_id: any string]

        @return Action:
        '''

        url = '/openstackimageproviders/{openstackimageprovider:id}/images/{image:id}/import'

        result = self.__getProxy().request(
            method='POST',
            url=UrlHelper.replace(
                url,
                {
                    '{openstackimageprovider:id}': self.parentclass.get_id(),
                    '{image:id}': self.get_id(),
                }
            ),
            body=ParseHelper.toXml(action),
            headers={"Correlation-Id":correlation_id}
        )

        return result

class OpenStackImageProviderOpenStackImages(Base):

    def __init__(self, openstackimageprovider , context):
        Base.__init__(self, context)
        self.parentclass = openstackimageprovider

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def get(self, name=None, id=None):

        '''
        [@param id  : string (the id of the entity)]
        [@param name: string (the name of the entity)]

        @return OpenStackImages:
        '''

        url = '/openstackimageproviders/{openstackimageprovider:id}/images'

        if id:
            try :
                result = self.__getProxy().get(
                    url=UrlHelper.append(
                        UrlHelper.replace(
                            url,
                            {
                                '{openstackimageprovider:id}': self.parentclass.get_id(),
                            }
                        ),
                        id
                    ),
                    headers={}
                )

                return OpenStackImageProviderOpenStackImage(
                    self.parentclass,
                    result,
                    self.context
                )
            except RequestError as err:
                if err.status and err.status == 404:
                    return None
                raise err
        elif name:
            result = self.__getProxy().get(
                url=UrlHelper.replace(
                    url,
                    {
                        '{openstackimageprovider:id}': self.parentclass.get_id(),
                    }
                ),
                headers={}
            ).get_openstack_image()

            return OpenStackImageProviderOpenStackImage(
                self.parentclass,
                FilterHelper.getItem(
                    FilterHelper.filter(
                        result,
                        {'name':name}
                    ),
                    query="name=" + name
                ),
                self.context
            )
        else:
            raise MissingParametersError(['id', 'name'])

    def list(self, max=None, **kwargs):
        '''
        [@param **kwargs: dict (property based filtering)"]
        [@param max: int (max results)]

        @return OpenStackImages:
        '''

        url = '/openstackimageproviders/{openstackimageprovider:id}/images'

        result = self.__getProxy().get(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{openstackimageprovider:id}': self.parentclass.get_id(),
                    }
                ),
                args={'max:matrix':max}
            ),
            headers={}
        ).get_openstack_image()

        return ParseHelper.toSubCollection(
            OpenStackImageProviderOpenStackImage,
            self.parentclass,
            FilterHelper.filter(
                result,
                kwargs
            ),
            context=self.context
        )

class OpenStackImageProviders(Base):
    def __init__(self, context):
        Base.__init__(self, context)

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def add(self, openstackimageprovider, correlation_id=None, expect=None):
        '''
        @type OpenStackImageProvider:

        @param openstack_image_provider.name: string
        [@param openstack_image_provider.description: string]
        [@param openstack_image_provider.url: string]
        [@param openstack_image_provider.requires_authentication: boolean]
        [@param openstack_image_provider.username: string]
        [@param openstack_image_provider.password: string]
        [@param openstack_image_provider.authentication_url: string]
        [@param openstack_image_provider.properties.property: collection]
        {
          [@ivar property.name: string]
          [@ivar property.value: string]
        }
        [@param openstack_image_provider.tenant_name: string]
        [@param correlation_id: any string]
        [@param expect: 201-created]

        @return OpenStackImageProvider:
        '''

        url = '/openstackimageproviders'

        result = self.__getProxy().add(
           url=UrlHelper.appendParameters(
                url=url,
                args={}
           ),
           body=ParseHelper.toXml(openstackimageprovider),
           headers={"Correlation-Id":correlation_id, "Expect":expect}
        )

        return OpenStackImageProvider(result, self.context)

    def get(self, name=None, id=None):
        '''
        [@param id  : string (the id of the entity)]
        [@param name: string (the name of the entity)]

        @return OpenStackImageProviders:
        '''

        url = '/openstackimageproviders'

        if id:
            try :
                return OpenStackImageProvider(
                    self.__getProxy().get(
                                url=UrlHelper.append(url, id),
                                headers={}
                    ),
                    self.context
                )
            except RequestError as err:
                if err.status and err.status == 404:
                    return None
                raise err
        elif name:
            result = self.__getProxy().get(
                    url=url,
                    headers={}
            ).get_openstack_image_provider()

            return OpenStackImageProvider(
                FilterHelper.getItem(
                    FilterHelper.filter(result, {'name':name}),
                    query="name=" + name
                ),
                self.context
            )
        else:
            raise MissingParametersError(['id', 'name'])


    def list(self, max=None, **kwargs):
        '''
        [@param **kwargs: dict (property based filtering)]
        [@param max: int (max results)]

        @return OpenStackImageProviders:
        '''

        url='/openstackimageproviders'

        result = self.__getProxy().get(
            url=UrlHelper.appendParameters(url, {'max:matrix':max}),
            headers={}
        ).get_openstack_image_provider()

        return ParseHelper.toCollection(
            OpenStackImageProvider,
            FilterHelper.filter(result, kwargs),
            context=self.context
        )

class OpenStackNetworkProvider(params.OpenStackNetworkProvider, Base):
    def __init__(self, openstacknetworkprovider, context):
        Base.__init__(self, context)
        self.superclass = openstacknetworkprovider

        self.certificates = OpenStackNetworkProviderCertificates(self, context)
        self.networks = OpenStackNetworkProviderOpenStackNetworks(self, context)

    def __new__(cls, openstacknetworkprovider, context):
        if openstacknetworkprovider is None: return None
        obj = object.__new__(cls)
        obj.__init__(openstacknetworkprovider, context)
        return obj

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def delete(self, async=None, correlation_id=None):
        '''
        [@param async: boolean (true|false)]
        [@param correlation_id: any string]

        @return None:
        '''

        url = UrlHelper.replace(
            '/openstacknetworkproviders/{openstacknetworkprovider:id}',
            {
                '{openstacknetworkprovider:id}': self.get_id(),
            }
        )

        return self.__getProxy().delete(
            url=UrlHelper.appendParameters(
                url,
                {'async:matrix':async}
            ),
            headers={"Correlation-Id":correlation_id,"Content-type":None}
        )

    def update(self, correlation_id=None, expect=None):
        '''
        [@param openstack_network_provider.name: string]
        [@param openstack_network_provider.description: string]
        [@param openstack_network_provider.requires_authentication: boolean]
        [@param openstack_network_provider.username: string]
        [@param openstack_network_provider.password: string]
        [@param openstack_network_provider.authentication_url: string]
        [@param openstack_network_provider.properties.property: collection]
        {
          [@ivar property.name: string]
          [@ivar property.value: string]
        }
        [@param openstack_network_provider.tenant_name: string]
        [@param correlation_id: any string]
        [@param expect: 202-accepted]

        @return OpenStackNetworkProvider:
        '''

        url = '/openstacknetworkproviders/{openstacknetworkprovider:id}'

        result = self.__getProxy().update(
            url=UrlHelper.replace(
                url,
                {
                    '{openstacknetworkprovider:id}': self.get_id(),
                }
            ),
            body=ParseHelper.toXml(self.superclass),
            headers={"Correlation-Id":correlation_id, "Expect":expect}
        )

        return OpenStackNetworkProvider(result, self.context)

    def importcertificates(self, action=params.Action()):
        '''
        @type Action:


        @return Action:
        '''

        url = '/openstacknetworkproviders/{openstacknetworkprovider:id}/importcertificates'

        result = self.__getProxy().request(
            method='POST',
            url=UrlHelper.replace(
                url,
                {
                    '{openstacknetworkprovider:id}': self.get_id(),
                }
            ),
            body=ParseHelper.toXml(action),
            headers={}
        )

        return result

    def testconnectivity(self, action=params.Action()):
        '''
        @type Action:


        @return Action:
        '''

        url = '/openstacknetworkproviders/{openstacknetworkprovider:id}/testconnectivity'

        result = self.__getProxy().request(
            method='POST',
            url=UrlHelper.replace(
                url,
                {
                    '{openstacknetworkprovider:id}': self.get_id(),
                }
            ),
            body=ParseHelper.toXml(action),
            headers={}
        )

        return result

class OpenStackNetworkProviderCertificate(params.Certificate, Base):
    def __init__(self, openstacknetworkprovider, certificate, context):
        Base.__init__(self, context)
        self.parentclass = openstacknetworkprovider
        self.superclass  =  certificate

        #SUB_COLLECTIONS
    def __new__(cls, openstacknetworkprovider, certificate, context):
        if certificate is None: return None
        obj = object.__new__(cls)
        obj.__init__(openstacknetworkprovider, certificate, context)
        return obj

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

class OpenStackNetworkProviderCertificates(Base):

    def __init__(self, openstacknetworkprovider , context):
        Base.__init__(self, context)
        self.parentclass = openstacknetworkprovider

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def get(self, name=None, id=None):

        '''
        [@param id  : string (the id of the entity)]
        [@param name: string (the name of the entity)]

        @return Certificates:
        '''

        url = '/openstacknetworkproviders/{openstacknetworkprovider:id}/certificates'

        if id:
            try :
                result = self.__getProxy().get(
                    url=UrlHelper.append(
                        UrlHelper.replace(
                            url,
                            {
                                '{openstacknetworkprovider:id}': self.parentclass.get_id(),
                            }
                        ),
                        id
                    ),
                    headers={}
                )

                return OpenStackNetworkProviderCertificate(
                    self.parentclass,
                    result,
                    self.context
                )
            except RequestError as err:
                if err.status and err.status == 404:
                    return None
                raise err
        elif name:
            result = self.__getProxy().get(
                url=UrlHelper.replace(
                    url,
                    {
                        '{openstacknetworkprovider:id}': self.parentclass.get_id(),
                    }
                ),
                headers={}
            ).get_certificate()

            return OpenStackNetworkProviderCertificate(
                self.parentclass,
                FilterHelper.getItem(
                    FilterHelper.filter(
                        result,
                        {'name':name}
                    ),
                    query="name=" + name
                ),
                self.context
            )
        else:
            raise MissingParametersError(['id', 'name'])

    def list(self, max=None, **kwargs):
        '''
        [@param **kwargs: dict (property based filtering)"]
        [@param max: int (max results)]

        @return Certificates:
        '''

        url = '/openstacknetworkproviders/{openstacknetworkprovider:id}/certificates'

        result = self.__getProxy().get(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{openstacknetworkprovider:id}': self.parentclass.get_id(),
                    }
                ),
                args={'max:matrix':max}
            ),
            headers={}
        ).get_certificate()

        return ParseHelper.toSubCollection(
            OpenStackNetworkProviderCertificate,
            self.parentclass,
            FilterHelper.filter(
                result,
                kwargs
            ),
            context=self.context
        )

class OpenStackNetworkProviderOpenStackNetwork(params.OpenStackNetwork, Base):
    def __init__(self, openstacknetworkprovider, openstacknetwork, context):
        Base.__init__(self, context)
        self.parentclass = openstacknetworkprovider
        self.superclass  =  openstacknetwork

        self.subnets = OpenStackNetworkProviderOpenStackNetworkOpenStackSubnets(self, context)

    def __new__(cls, openstacknetworkprovider, openstacknetwork, context):
        if openstacknetwork is None: return None
        obj = object.__new__(cls)
        obj.__init__(openstacknetworkprovider, openstacknetwork, context)
        return obj

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

class OpenStackNetworkProviderOpenStackNetworkOpenStackSubnet(params.OpenStackSubnet, Base):
    def __init__(self, openstacknetworkprovideropenstacknetwork, openstacksubnet, context):
        Base.__init__(self, context)
        self.parentclass = openstacknetworkprovideropenstacknetwork
        self.superclass  =  openstacksubnet

        #SUB_COLLECTIONS
    def __new__(cls, openstacknetworkprovideropenstacknetwork, openstacksubnet, context):
        if openstacksubnet is None: return None
        obj = object.__new__(cls)
        obj.__init__(openstacknetworkprovideropenstacknetwork, openstacksubnet, context)
        return obj

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def delete(self, async=None):
        '''
        [@param async: boolean (true|false)]

        @return None:
        '''

        url = UrlHelper.replace(
            '/openstacknetworkproviders/{openstacknetworkprovider:id}/networks/{network:id}/subnets/{subnet:id}',
            {
                '{openstacknetworkprovider:id}': self.parentclass.parentclass.get_id(),
                '{network:id}': self.parentclass.get_id(),
                '{subnet:id}': self.get_id(),
            }
        )

        return self.__getProxy().delete(
            url=UrlHelper.appendParameters(
                url,
                {'async:matrix':async}
            ),
            headers={"Content-type":None}
        )

class OpenStackNetworkProviderOpenStackNetworkOpenStackSubnets(Base):

    def __init__(self, openstacknetwork , context):
        Base.__init__(self, context)
        self.parentclass = openstacknetwork

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def add(self, openstacksubnet):

        '''
        @type OpenStackSubnet:


        @return OpenStackSubnet:
        '''

        url = '/openstacknetworkproviders/{openstacknetworkprovider:id}/networks/{network:id}/subnets'

        result = self.__getProxy().add(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{openstacknetworkprovider:id}': self.parentclass.parentclass.get_id(),
                        '{network:id}': self.parentclass.get_id(),
                    }
                ),
                args={}
            ),
            body=ParseHelper.toXml(openstacksubnet),
            headers={}
        )

        return OpenStackNetworkProviderOpenStackNetworkOpenStackSubnet(
            self.parentclass,
            result,
            self.context
        )

    def get(self, name=None, id=None):

        '''
        [@param id  : string (the id of the entity)]
        [@param name: string (the name of the entity)]

        @return OpenStackSubnets:
        '''

        url = '/openstacknetworkproviders/{openstacknetworkprovider:id}/networks/{network:id}/subnets'

        if id:
            try :
                result = self.__getProxy().get(
                    url=UrlHelper.append(
                        UrlHelper.replace(
                            url,
                            {
                                '{openstacknetworkprovider:id}': self.parentclass.parentclass.get_id(),
                                '{network:id}': self.parentclass.get_id(),
                            }
                        ),
                        id
                    ),
                    headers={}
                )

                return OpenStackNetworkProviderOpenStackNetworkOpenStackSubnet(
                    self.parentclass,
                    result,
                    self.context
                )
            except RequestError as err:
                if err.status and err.status == 404:
                    return None
                raise err
        elif name:
            result = self.__getProxy().get(
                url=UrlHelper.replace(
                    url,
                    {
                        '{openstacknetworkprovider:id}': self.parentclass.parentclass.get_id(),
                        '{network:id}': self.parentclass.get_id(),
                    }
                ),
                headers={}
            ).get_openstack_subnet()

            return OpenStackNetworkProviderOpenStackNetworkOpenStackSubnet(
                self.parentclass,
                FilterHelper.getItem(
                    FilterHelper.filter(
                        result,
                        {'name':name}
                    ),
                    query="name=" + name
                ),
                self.context
            )
        else:
            raise MissingParametersError(['id', 'name'])

    def list(self, max=None, **kwargs):
        '''
        [@param **kwargs: dict (property based filtering)"]
        [@param max: int (max results)]

        @return OpenStackSubnets:
        '''

        url = '/openstacknetworkproviders/{openstacknetworkprovider:id}/networks/{network:id}/subnets'

        result = self.__getProxy().get(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{openstacknetworkprovider:id}': self.parentclass.parentclass.get_id(),
                        '{network:id}': self.parentclass.get_id(),
                    }
                ),
                args={'max:matrix':max}
            ),
            headers={}
        ).get_openstack_subnet()

        return ParseHelper.toSubCollection(
            OpenStackNetworkProviderOpenStackNetworkOpenStackSubnet,
            self.parentclass,
            FilterHelper.filter(
                result,
                kwargs
            ),
            context=self.context
        )

class OpenStackNetworkProviderOpenStackNetworks(Base):

    def __init__(self, openstacknetworkprovider , context):
        Base.__init__(self, context)
        self.parentclass = openstacknetworkprovider

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def get(self, name=None, id=None):

        '''
        [@param id  : string (the id of the entity)]
        [@param name: string (the name of the entity)]

        @return OpenStackNetworks:
        '''

        url = '/openstacknetworkproviders/{openstacknetworkprovider:id}/networks'

        if id:
            try :
                result = self.__getProxy().get(
                    url=UrlHelper.append(
                        UrlHelper.replace(
                            url,
                            {
                                '{openstacknetworkprovider:id}': self.parentclass.get_id(),
                            }
                        ),
                        id
                    ),
                    headers={}
                )

                return OpenStackNetworkProviderOpenStackNetwork(
                    self.parentclass,
                    result,
                    self.context
                )
            except RequestError as err:
                if err.status and err.status == 404:
                    return None
                raise err
        elif name:
            result = self.__getProxy().get(
                url=UrlHelper.replace(
                    url,
                    {
                        '{openstacknetworkprovider:id}': self.parentclass.get_id(),
                    }
                ),
                headers={}
            ).get_openstack_network()

            return OpenStackNetworkProviderOpenStackNetwork(
                self.parentclass,
                FilterHelper.getItem(
                    FilterHelper.filter(
                        result,
                        {'name':name}
                    ),
                    query="name=" + name
                ),
                self.context
            )
        else:
            raise MissingParametersError(['id', 'name'])

    def list(self, max=None, **kwargs):
        '''
        [@param **kwargs: dict (property based filtering)"]
        [@param max: int (max results)]

        @return OpenStackNetworks:
        '''

        url = '/openstacknetworkproviders/{openstacknetworkprovider:id}/networks'

        result = self.__getProxy().get(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{openstacknetworkprovider:id}': self.parentclass.get_id(),
                    }
                ),
                args={'max:matrix':max}
            ),
            headers={}
        ).get_openstack_network()

        return ParseHelper.toSubCollection(
            OpenStackNetworkProviderOpenStackNetwork,
            self.parentclass,
            FilterHelper.filter(
                result,
                kwargs
            ),
            context=self.context
        )

class OpenStackNetworkProviders(Base):
    def __init__(self, context):
        Base.__init__(self, context)

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def add(self, openstacknetworkprovider, correlation_id=None, expect=None):
        '''
        @type OpenStackNetworkProvider:

        @param openstack_network_provider.name: string
        [@param openstack_network_provider.description: string]
        [@param openstack_network_provider.url: string]
        [@param openstack_network_provider.requires_authentication: boolean]
        [@param openstack_network_provider.username: string]
        [@param openstack_network_provider.password: string]
        [@param openstack_network_provider.authentication_url: string]
        [@param openstack_network_provider.properties.property: collection]
        {
          [@ivar property.name: string]
          [@ivar property.value: string]
        }
        [@param openstack_network_provider.tenant_name: string]
        [@param correlation_id: any string]
        [@param expect: 201-created]

        @return OpenStackNetworkProvider:
        '''

        url = '/openstacknetworkproviders'

        result = self.__getProxy().add(
           url=UrlHelper.appendParameters(
                url=url,
                args={}
           ),
           body=ParseHelper.toXml(openstacknetworkprovider),
           headers={"Correlation-Id":correlation_id, "Expect":expect}
        )

        return OpenStackNetworkProvider(result, self.context)

    def get(self, name=None, id=None):
        '''
        [@param id  : string (the id of the entity)]
        [@param name: string (the name of the entity)]

        @return OpenStackNetworkProviders:
        '''

        url = '/openstacknetworkproviders'

        if id:
            try :
                return OpenStackNetworkProvider(
                    self.__getProxy().get(
                                url=UrlHelper.append(url, id),
                                headers={}
                    ),
                    self.context
                )
            except RequestError as err:
                if err.status and err.status == 404:
                    return None
                raise err
        elif name:
            result = self.__getProxy().get(
                    url=url,
                    headers={}
            ).get_openstack_network_provider()

            return OpenStackNetworkProvider(
                FilterHelper.getItem(
                    FilterHelper.filter(result, {'name':name}),
                    query="name=" + name
                ),
                self.context
            )
        else:
            raise MissingParametersError(['id', 'name'])


    def list(self, max=None, **kwargs):
        '''
        [@param **kwargs: dict (property based filtering)]
        [@param max: int (max results)]

        @return OpenStackNetworkProviders:
        '''

        url='/openstacknetworkproviders'

        result = self.__getProxy().get(
            url=UrlHelper.appendParameters(url, {'max:matrix':max}),
            headers={}
        ).get_openstack_network_provider()

        return ParseHelper.toCollection(
            OpenStackNetworkProvider,
            FilterHelper.filter(result, kwargs),
            context=self.context
        )

class OpenStackVolumeProvider(params.OpenStackVolumeProvider, Base):
    def __init__(self, openstackvolumeprovider, context):
        Base.__init__(self, context)
        self.superclass = openstackvolumeprovider

        self.authenticationkeys = OpenStackVolumeProviderOpenstackVolumeAuthenticationKeys(self, context)
        self.certificates = OpenStackVolumeProviderCertificates(self, context)
        self.volumetypes = OpenStackVolumeProviderOpenStackVolumeTypes(self, context)

    def __new__(cls, openstackvolumeprovider, context):
        if openstackvolumeprovider is None: return None
        obj = object.__new__(cls)
        obj.__init__(openstackvolumeprovider, context)
        return obj

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def delete(self, async=None, correlation_id=None):
        '''
        [@param async: boolean (true|false)]
        [@param correlation_id: any string]

        @return None:
        '''

        url = UrlHelper.replace(
            '/openstackvolumeproviders/{openstackvolumeprovider:id}',
            {
                '{openstackvolumeprovider:id}': self.get_id(),
            }
        )

        return self.__getProxy().delete(
            url=UrlHelper.appendParameters(
                url,
                {'async:matrix':async}
            ),
            headers={"Correlation-Id":correlation_id,"Content-type":None}
        )

    def update(self, correlation_id=None, expect=None):
        '''
        [@param openstack_volume_provider.name: string]
        [@param openstack_volume_provider.description: string]
        [@param openstack_volume_provider.data_center.id|name: string,]
        [@param openstack_volume_provider.requires_authentication: boolean]
        [@param openstack_volume_provider.username: string]
        [@param openstack_volume_provider.password: string]
        [@param openstack_volume_provider.authentication_url: string]
        [@param openstack_volume_provider.properties.property: collection]
        {
          [@ivar property.name: string]
          [@ivar property.value: string]
        }
        [@param openstack_volume_provider.tenant_name: string]
        [@param correlation_id: any string]
        [@param expect: 202-accepted]

        @return OpenStackVolumeProvider:
        '''

        url = '/openstackvolumeproviders/{openstackvolumeprovider:id}'

        result = self.__getProxy().update(
            url=UrlHelper.replace(
                url,
                {
                    '{openstackvolumeprovider:id}': self.get_id(),
                }
            ),
            body=ParseHelper.toXml(self.superclass),
            headers={"Correlation-Id":correlation_id, "Expect":expect}
        )

        return OpenStackVolumeProvider(result, self.context)

    def importcertificates(self, action=params.Action()):
        '''
        @type Action:


        @return Action:
        '''

        url = '/openstackvolumeproviders/{openstackvolumeprovider:id}/importcertificates'

        result = self.__getProxy().request(
            method='POST',
            url=UrlHelper.replace(
                url,
                {
                    '{openstackvolumeprovider:id}': self.get_id(),
                }
            ),
            body=ParseHelper.toXml(action),
            headers={}
        )

        return result

    def testconnectivity(self, action=params.Action()):
        '''
        @type Action:


        @return Action:
        '''

        url = '/openstackvolumeproviders/{openstackvolumeprovider:id}/testconnectivity'

        result = self.__getProxy().request(
            method='POST',
            url=UrlHelper.replace(
                url,
                {
                    '{openstackvolumeprovider:id}': self.get_id(),
                }
            ),
            body=ParseHelper.toXml(action),
            headers={}
        )

        return result

class OpenStackVolumeProviderCertificate(params.Certificate, Base):
    def __init__(self, openstackvolumeprovider, certificate, context):
        Base.__init__(self, context)
        self.parentclass = openstackvolumeprovider
        self.superclass  =  certificate

        #SUB_COLLECTIONS
    def __new__(cls, openstackvolumeprovider, certificate, context):
        if certificate is None: return None
        obj = object.__new__(cls)
        obj.__init__(openstackvolumeprovider, certificate, context)
        return obj

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

class OpenStackVolumeProviderCertificates(Base):

    def __init__(self, openstackvolumeprovider , context):
        Base.__init__(self, context)
        self.parentclass = openstackvolumeprovider

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def get(self, name=None, id=None):

        '''
        [@param id  : string (the id of the entity)]
        [@param name: string (the name of the entity)]

        @return Certificates:
        '''

        url = '/openstackvolumeproviders/{openstackvolumeprovider:id}/certificates'

        if id:
            try :
                result = self.__getProxy().get(
                    url=UrlHelper.append(
                        UrlHelper.replace(
                            url,
                            {
                                '{openstackvolumeprovider:id}': self.parentclass.get_id(),
                            }
                        ),
                        id
                    ),
                    headers={}
                )

                return OpenStackVolumeProviderCertificate(
                    self.parentclass,
                    result,
                    self.context
                )
            except RequestError as err:
                if err.status and err.status == 404:
                    return None
                raise err
        elif name:
            result = self.__getProxy().get(
                url=UrlHelper.replace(
                    url,
                    {
                        '{openstackvolumeprovider:id}': self.parentclass.get_id(),
                    }
                ),
                headers={}
            ).get_certificate()

            return OpenStackVolumeProviderCertificate(
                self.parentclass,
                FilterHelper.getItem(
                    FilterHelper.filter(
                        result,
                        {'name':name}
                    ),
                    query="name=" + name
                ),
                self.context
            )
        else:
            raise MissingParametersError(['id', 'name'])

    def list(self, max=None, **kwargs):
        '''
        [@param **kwargs: dict (property based filtering)"]
        [@param max: int (max results)]

        @return Certificates:
        '''

        url = '/openstackvolumeproviders/{openstackvolumeprovider:id}/certificates'

        result = self.__getProxy().get(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{openstackvolumeprovider:id}': self.parentclass.get_id(),
                    }
                ),
                args={'max:matrix':max}
            ),
            headers={}
        ).get_certificate()

        return ParseHelper.toSubCollection(
            OpenStackVolumeProviderCertificate,
            self.parentclass,
            FilterHelper.filter(
                result,
                kwargs
            ),
            context=self.context
        )

class OpenStackVolumeProviderOpenStackVolumeType(params.OpenStackVolumeType, Base):
    def __init__(self, openstackvolumeprovider, openstackvolumetype, context):
        Base.__init__(self, context)
        self.parentclass = openstackvolumeprovider
        self.superclass  =  openstackvolumetype

        #SUB_COLLECTIONS
    def __new__(cls, openstackvolumeprovider, openstackvolumetype, context):
        if openstackvolumetype is None: return None
        obj = object.__new__(cls)
        obj.__init__(openstackvolumeprovider, openstackvolumetype, context)
        return obj

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

class OpenStackVolumeProviderOpenStackVolumeTypes(Base):

    def __init__(self, openstackvolumeprovider , context):
        Base.__init__(self, context)
        self.parentclass = openstackvolumeprovider

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def get(self, name=None, id=None):

        '''
        [@param id  : string (the id of the entity)]
        [@param name: string (the name of the entity)]

        @return OpenStackVolumeTypes:
        '''

        url = '/openstackvolumeproviders/{openstackvolumeprovider:id}/volumetypes'

        if id:
            try :
                result = self.__getProxy().get(
                    url=UrlHelper.append(
                        UrlHelper.replace(
                            url,
                            {
                                '{openstackvolumeprovider:id}': self.parentclass.get_id(),
                            }
                        ),
                        id
                    ),
                    headers={}
                )

                return OpenStackVolumeProviderOpenStackVolumeType(
                    self.parentclass,
                    result,
                    self.context
                )
            except RequestError as err:
                if err.status and err.status == 404:
                    return None
                raise err
        elif name:
            result = self.__getProxy().get(
                url=UrlHelper.replace(
                    url,
                    {
                        '{openstackvolumeprovider:id}': self.parentclass.get_id(),
                    }
                ),
                headers={}
            ).get_openstack_volume_type()

            return OpenStackVolumeProviderOpenStackVolumeType(
                self.parentclass,
                FilterHelper.getItem(
                    FilterHelper.filter(
                        result,
                        {'name':name}
                    ),
                    query="name=" + name
                ),
                self.context
            )
        else:
            raise MissingParametersError(['id', 'name'])

    def list(self, max=None, **kwargs):
        '''
        [@param **kwargs: dict (property based filtering)"]
        [@param max: int (max results)]

        @return OpenStackVolumeTypes:
        '''

        url = '/openstackvolumeproviders/{openstackvolumeprovider:id}/volumetypes'

        result = self.__getProxy().get(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{openstackvolumeprovider:id}': self.parentclass.get_id(),
                    }
                ),
                args={'max:matrix':max}
            ),
            headers={}
        ).get_openstack_volume_type()

        return ParseHelper.toSubCollection(
            OpenStackVolumeProviderOpenStackVolumeType,
            self.parentclass,
            FilterHelper.filter(
                result,
                kwargs
            ),
            context=self.context
        )

class OpenStackVolumeProviderOpenstackVolumeAuthenticationKey(params.OpenstackVolumeAuthenticationKey, Base):
    def __init__(self, openstackvolumeprovider, openstackvolumeauthenticationkey, context):
        Base.__init__(self, context)
        self.parentclass = openstackvolumeprovider
        self.superclass  =  openstackvolumeauthenticationkey

        #SUB_COLLECTIONS
    def __new__(cls, openstackvolumeprovider, openstackvolumeauthenticationkey, context):
        if openstackvolumeauthenticationkey is None: return None
        obj = object.__new__(cls)
        obj.__init__(openstackvolumeprovider, openstackvolumeauthenticationkey, context)
        return obj

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def delete(self, async=None):
        '''
        [@param async: boolean (true|false)]

        @return None:
        '''

        url = UrlHelper.replace(
            '/openstackvolumeproviders/{openstackvolumeprovider:id}/authenticationkeys/{authenticationkey:id}',
            {
                '{openstackvolumeprovider:id}': self.parentclass.get_id(),
                '{authenticationkey:id}': self.get_id(),
            }
        )

        return self.__getProxy().delete(
            url=UrlHelper.appendParameters(
                url,
                {'async:matrix':async}
            ),
            headers={"Content-type":None}
        )

    def update(self, async=None, correlation_id=None, expect=None):
        '''
        [@param openstack_volume_authentication_key.value: string]
        [@param openstack_volume_authentication_key.usage_type: string]
        [@param openstack_volume_authentication_key.description: string]
        [@param async: boolean (true|false)]
        [@param correlation_id: any string]
        [@param expect: 202-accepted]

        @return OpenstackVolumeAuthenticationKey:
        '''

        url = '/openstackvolumeproviders/{openstackvolumeprovider:id}/authenticationkeys/{authenticationkey:id}'
        url = UrlHelper.replace(
            url,
            {
                '{openstackvolumeprovider:id}': self.parentclass.get_id(),
                '{authenticationkey:id}': self.get_id(),
            }
        )

        result = self.__getProxy().update(
            url=UrlHelper.appendParameters(url, {'async:matrix':async}),
            body=ParseHelper.toXml(self.superclass),
            headers={"Correlation-Id":correlation_id, "Expect":expect}
        )

        return OpenStackVolumeProviderOpenstackVolumeAuthenticationKey(
            self.parentclass,
            result,
            self.context
        )

class OpenStackVolumeProviderOpenstackVolumeAuthenticationKeys(Base):

    def __init__(self, openstackvolumeprovider , context):
        Base.__init__(self, context)
        self.parentclass = openstackvolumeprovider

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def add(self, openstackvolumeauthenticationkey, correlation_id=None, expect=None):

        '''
        @type OpenstackVolumeAuthenticationKey:

        @param openstack_volume_authentication_key.uuid: string
        @param openstack_volume_authentication_key.value: string
        @param openstack_volume_authentication_key.usage_type: string
        [@param openstack_volume_authentication_key.description: string]
        [@param correlation_id: any string]
        [@param expect: 201-created]

        @return OpenstackVolumeAuthenticationKey:
        '''

        url = '/openstackvolumeproviders/{openstackvolumeprovider:id}/authenticationkeys'

        result = self.__getProxy().add(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{openstackvolumeprovider:id}': self.parentclass.get_id(),
                    }
                ),
                args={}
            ),
            body=ParseHelper.toXml(openstackvolumeauthenticationkey),
            headers={"Correlation-Id":correlation_id, "Expect":expect}
        )

        return OpenStackVolumeProviderOpenstackVolumeAuthenticationKey(
            self.parentclass,
            result,
            self.context
        )

    def get(self, name=None, id=None):

        '''
        [@param id  : string (the id of the entity)]
        [@param name: string (the name of the entity)]

        @return OpenstackVolumeAuthenticationKeys:
        '''

        url = '/openstackvolumeproviders/{openstackvolumeprovider:id}/authenticationkeys'

        if id:
            try :
                result = self.__getProxy().get(
                    url=UrlHelper.append(
                        UrlHelper.replace(
                            url,
                            {
                                '{openstackvolumeprovider:id}': self.parentclass.get_id(),
                            }
                        ),
                        id
                    ),
                    headers={}
                )

                return OpenStackVolumeProviderOpenstackVolumeAuthenticationKey(
                    self.parentclass,
                    result,
                    self.context
                )
            except RequestError as err:
                if err.status and err.status == 404:
                    return None
                raise err
        elif name:
            result = self.__getProxy().get(
                url=UrlHelper.replace(
                    url,
                    {
                        '{openstackvolumeprovider:id}': self.parentclass.get_id(),
                    }
                ),
                headers={}
            ).get_openstack_volume_authentication_key()

            return OpenStackVolumeProviderOpenstackVolumeAuthenticationKey(
                self.parentclass,
                FilterHelper.getItem(
                    FilterHelper.filter(
                        result,
                        {'name':name}
                    ),
                    query="name=" + name
                ),
                self.context
            )
        else:
            raise MissingParametersError(['id', 'name'])

    def list(self, max=None, **kwargs):
        '''
        [@param **kwargs: dict (property based filtering)"]
        [@param max: int (max results)]

        @return OpenstackVolumeAuthenticationKeys:
        '''

        url = '/openstackvolumeproviders/{openstackvolumeprovider:id}/authenticationkeys'

        result = self.__getProxy().get(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{openstackvolumeprovider:id}': self.parentclass.get_id(),
                    }
                ),
                args={'max:matrix':max}
            ),
            headers={}
        ).get_openstack_volume_authentication_key()

        return ParseHelper.toSubCollection(
            OpenStackVolumeProviderOpenstackVolumeAuthenticationKey,
            self.parentclass,
            FilterHelper.filter(
                result,
                kwargs
            ),
            context=self.context
        )

class OpenStackVolumeProviders(Base):
    def __init__(self, context):
        Base.__init__(self, context)

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def add(self, openstackvolumeprovider, correlation_id=None, expect=None):
        '''
        @type OpenStackVolumeProvider:

        @param openstack_volume_provider.name: string
        [@param openstack_volume_provider.description: string]
        [@param openstack_volume_provider.url: string]
        [@param openstack_volume_provider.data_center.id|name: string]
        [@param openstack_volume_provider.requires_authentication: boolean]
        [@param openstack_volume_provider.username: string]
        [@param openstack_volume_provider.password: string]
        [@param openstack_volume_provider.authentication_url: string]
        [@param openstack_volume_provider.properties.property: collection]
        {
          [@ivar property.name: string]
          [@ivar property.value: string]
        }
        [@param openstack_volume_provider.tenant_name: string]
        [@param correlation_id: any string]
        [@param expect: 201-created]

        @return OpenStackVolumeProvider:
        '''

        url = '/openstackvolumeproviders'

        result = self.__getProxy().add(
           url=UrlHelper.appendParameters(
                url=url,
                args={}
           ),
           body=ParseHelper.toXml(openstackvolumeprovider),
           headers={"Correlation-Id":correlation_id, "Expect":expect}
        )

        return OpenStackVolumeProvider(result, self.context)

    def get(self, name=None, id=None):
        '''
        [@param id  : string (the id of the entity)]
        [@param name: string (the name of the entity)]

        @return OpenStackVolumeProviders:
        '''

        url = '/openstackvolumeproviders'

        if id:
            try :
                return OpenStackVolumeProvider(
                    self.__getProxy().get(
                                url=UrlHelper.append(url, id),
                                headers={}
                    ),
                    self.context
                )
            except RequestError as err:
                if err.status and err.status == 404:
                    return None
                raise err
        elif name:
            result = self.__getProxy().get(
                    url=url,
                    headers={}
            ).get_openstack_volume_provider()

            return OpenStackVolumeProvider(
                FilterHelper.getItem(
                    FilterHelper.filter(result, {'name':name}),
                    query="name=" + name
                ),
                self.context
            )
        else:
            raise MissingParametersError(['id', 'name'])


    def list(self, max=None, **kwargs):
        '''
        [@param **kwargs: dict (property based filtering)]
        [@param max: int (max results)]

        @return OpenStackVolumeProviders:
        '''

        url='/openstackvolumeproviders'

        result = self.__getProxy().get(
            url=UrlHelper.appendParameters(url, {'max:matrix':max}),
            headers={}
        ).get_openstack_volume_provider()

        return ParseHelper.toCollection(
            OpenStackVolumeProvider,
            FilterHelper.filter(result, kwargs),
            context=self.context
        )

class OperatingSystemInfo(params.OperatingSystemInfo, Base):
    def __init__(self, operatingsysteminfo, context):
        Base.__init__(self, context)
        self.superclass = operatingsysteminfo

        #SUB_COLLECTIONS
    def __new__(cls, operatingsysteminfo, context):
        if operatingsysteminfo is None: return None
        obj = object.__new__(cls)
        obj.__init__(operatingsysteminfo, context)
        return obj

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

class OperatingSystemInfos(Base):
    def __init__(self, context):
        Base.__init__(self, context)

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def get(self, name=None, id=None):
        '''
        [@param id  : string (the id of the entity)]
        [@param name: string (the name of the entity)]

        @return OperatingSystemInfos:
        '''

        url = '/operatingsystems'

        if id:
            try :
                return OperatingSystemInfo(
                    self.__getProxy().get(
                                url=UrlHelper.append(url, id),
                                headers={}
                    ),
                    self.context
                )
            except RequestError as err:
                if err.status and err.status == 404:
                    return None
                raise err
        elif name:
            result = self.__getProxy().get(
                    url=url,
                    headers={}
            ).get_operating_system()

            return OperatingSystemInfo(
                FilterHelper.getItem(
                    FilterHelper.filter(result, {'name':name}),
                    query="name=" + name
                ),
                self.context
            )
        else:
            raise MissingParametersError(['id', 'name'])


    def list(self, max=None, **kwargs):
        '''
        [@param **kwargs: dict (property based filtering)]
        [@param max: int (max results)]

        @return OperatingSystemInfos:
        '''

        url='/operatingsystems'

        result = self.__getProxy().get(
            url=UrlHelper.appendParameters(url, {'max:matrix':max}),
            headers={}
        ).get_operating_system()

        return ParseHelper.toCollection(
            OperatingSystemInfo,
            FilterHelper.filter(result, kwargs),
            context=self.context
        )

class Permission(params.Permission, Base):
    def __init__(self, permission, context):
        Base.__init__(self, context)
        self.superclass = permission

        #SUB_COLLECTIONS
    def __new__(cls, permission, context):
        if permission is None: return None
        obj = object.__new__(cls)
        obj.__init__(permission, context)
        return obj

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def delete(self, async=None, correlation_id=None):
        '''
        [@param async: boolean (true|false)]
        [@param correlation_id: any string]

        @return None:
        '''

        url = UrlHelper.replace(
            '/permissions/{permission:id}',
            {
                '{permission:id}': self.get_id(),
            }
        )

        return self.__getProxy().delete(
            url=UrlHelper.appendParameters(
                url,
                {'async:matrix':async}
            ),
            headers={"Correlation-Id":correlation_id,"Content-type":None}
        )

class Permissions(Base):
    def __init__(self, context):
        Base.__init__(self, context)

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def add(self, permission, correlation_id=None, expect=None):
        '''
        @type Permission:

        Overload 1:
          @param permission.user.id: string
          @param permission.role.id|name: string
        Overload 2:
          @param permission.group.id: string
          @param permission.role.id|name: string
        [@param correlation_id: any string]
        [@param expect: 201-created]

        @return Permission:
        '''

        url = '/permissions'

        result = self.__getProxy().add(
           url=UrlHelper.appendParameters(
                url=url,
                args={}
           ),
           body=ParseHelper.toXml(permission),
           headers={"Correlation-Id":correlation_id, "Expect":expect}
        )

        return Permission(result, self.context)

    def get(self, name=None, id=None):
        '''
        [@param id  : string (the id of the entity)]
        [@param name: string (the name of the entity)]

        @return Permissions:
        '''

        url = '/permissions'

        if id:
            try :
                return Permission(
                    self.__getProxy().get(
                                url=UrlHelper.append(url, id),
                                headers={}
                    ),
                    self.context
                )
            except RequestError as err:
                if err.status and err.status == 404:
                    return None
                raise err
        elif name:
            result = self.__getProxy().get(
                    url=url,
                    headers={}
            ).get_permission()

            return Permission(
                FilterHelper.getItem(
                    FilterHelper.filter(result, {'name':name}),
                    query="name=" + name
                ),
                self.context
            )
        else:
            raise MissingParametersError(['id', 'name'])


    def list(self, max=None, **kwargs):
        '''
        [@param **kwargs: dict (property based filtering)]
        [@param max: int (max results)]

        @return Permissions:
        '''

        url='/permissions'

        result = self.__getProxy().get(
            url=UrlHelper.appendParameters(url, {'max:matrix':max}),
            headers={}
        ).get_permission()

        return ParseHelper.toCollection(
            Permission,
            FilterHelper.filter(result, kwargs),
            context=self.context
        )

class Role(params.Role, Base):
    def __init__(self, role, context):
        Base.__init__(self, context)
        self.superclass = role

        self.permits = RolePermits(self, context)

    def __new__(cls, role, context):
        if role is None: return None
        obj = object.__new__(cls)
        obj.__init__(role, context)
        return obj

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def delete(self, async=None, correlation_id=None):
        '''
        [@param async: boolean (true|false)]
        [@param correlation_id: any string]

        @return None:
        '''

        url = UrlHelper.replace(
            '/roles/{role:id}',
            {
                '{role:id}': self.get_id(),
            }
        )

        return self.__getProxy().delete(
            url=UrlHelper.appendParameters(
                url,
                {'async:matrix':async}
            ),
            headers={"Correlation-Id":correlation_id,"Content-type":None}
        )

    def update(self, correlation_id=None, expect=None):
        '''
        [@param role.permits.permit: collection]
        {
          [@ivar permit.id: string]
        }
        [@param role.description: string]
        [@param correlation_id: any string]
        [@param expect: 202-accepted]

        @return Role:
        '''

        url = '/roles/{role:id}'

        result = self.__getProxy().update(
            url=UrlHelper.replace(
                url,
                {
                    '{role:id}': self.get_id(),
                }
            ),
            body=ParseHelper.toXml(self.superclass),
            headers={"Correlation-Id":correlation_id, "Expect":expect}
        )

        return Role(result, self.context)

class RolePermit(params.Permit, Base):
    def __init__(self, role, permit, context):
        Base.__init__(self, context)
        self.parentclass = role
        self.superclass  =  permit

        #SUB_COLLECTIONS
    def __new__(cls, role, permit, context):
        if permit is None: return None
        obj = object.__new__(cls)
        obj.__init__(role, permit, context)
        return obj

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def delete(self, async=None, correlation_id=None):
        '''
        [@param async: boolean (true|false)]
        [@param correlation_id: any string]

        @return None:
        '''

        url = UrlHelper.replace(
            '/roles/{role:id}/permits/{permit:id}',
            {
                '{role:id}': self.parentclass.get_id(),
                '{permit:id}': self.get_id(),
            }
        )

        return self.__getProxy().delete(
            url=UrlHelper.appendParameters(
                url,
                {'async:matrix':async}
            ),
            headers={"Correlation-Id":correlation_id,"Content-type":None}
        )

class RolePermits(Base):

    def __init__(self, role , context):
        Base.__init__(self, context)
        self.parentclass = role

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def add(self, permit, correlation_id=None, expect=None):

        '''
        @type Permit:

        @param permit.id|name: string
        [@param correlation_id: any string]
        [@param expect: 201-created]

        @return Permit:
        '''

        url = '/roles/{role:id}/permits'

        result = self.__getProxy().add(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{role:id}': self.parentclass.get_id(),
                    }
                ),
                args={}
            ),
            body=ParseHelper.toXml(permit),
            headers={"Correlation-Id":correlation_id, "Expect":expect}
        )

        return RolePermit(
            self.parentclass,
            result,
            self.context
        )

    def get(self, name=None, id=None):

        '''
        [@param id  : string (the id of the entity)]
        [@param name: string (the name of the entity)]

        @return Permits:
        '''

        url = '/roles/{role:id}/permits'

        if id:
            try :
                result = self.__getProxy().get(
                    url=UrlHelper.append(
                        UrlHelper.replace(
                            url,
                            {
                                '{role:id}': self.parentclass.get_id(),
                            }
                        ),
                        id
                    ),
                    headers={}
                )

                return RolePermit(
                    self.parentclass,
                    result,
                    self.context
                )
            except RequestError as err:
                if err.status and err.status == 404:
                    return None
                raise err
        elif name:
            result = self.__getProxy().get(
                url=UrlHelper.replace(
                    url,
                    {
                        '{role:id}': self.parentclass.get_id(),
                    }
                ),
                headers={}
            ).get_permit()

            return RolePermit(
                self.parentclass,
                FilterHelper.getItem(
                    FilterHelper.filter(
                        result,
                        {'name':name}
                    ),
                    query="name=" + name
                ),
                self.context
            )
        else:
            raise MissingParametersError(['id', 'name'])

    def list(self, max=None, **kwargs):
        '''
        [@param **kwargs: dict (property based filtering)"]
        [@param max: int (max results)]

        @return Permits:
        '''

        url = '/roles/{role:id}/permits'

        result = self.__getProxy().get(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{role:id}': self.parentclass.get_id(),
                    }
                ),
                args={'max:matrix':max}
            ),
            headers={}
        ).get_permit()

        return ParseHelper.toSubCollection(
            RolePermit,
            self.parentclass,
            FilterHelper.filter(
                result,
                kwargs
            ),
            context=self.context
        )

class Roles(Base):
    def __init__(self, context):
        Base.__init__(self, context)

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def add(self, role, correlation_id=None, expect=None):
        '''
        @type Role:

        @param role.name: string
        @param role.permits.permit: collection
        {
          @ivar permit.id: string
        }
        [@param role.description: string]
        [@param role.administrative: boolean]
        [@param correlation_id: any string]
        [@param expect: 201-created]

        @return Role:
        '''

        url = '/roles'

        result = self.__getProxy().add(
           url=UrlHelper.appendParameters(
                url=url,
                args={}
           ),
           body=ParseHelper.toXml(role),
           headers={"Correlation-Id":correlation_id, "Expect":expect}
        )

        return Role(result, self.context)

    def get(self, name=None, id=None):
        '''
        [@param id  : string (the id of the entity)]
        [@param name: string (the name of the entity)]

        @return Roles:
        '''

        url = '/roles'

        if id:
            try :
                return Role(
                    self.__getProxy().get(
                                url=UrlHelper.append(url, id),
                                headers={}
                    ),
                    self.context
                )
            except RequestError as err:
                if err.status and err.status == 404:
                    return None
                raise err
        elif name:
            result = self.__getProxy().get(
                    url=url,
                    headers={}
            ).get_role()

            return Role(
                FilterHelper.getItem(
                    FilterHelper.filter(result, {'name':name}),
                    query="name=" + name
                ),
                self.context
            )
        else:
            raise MissingParametersError(['id', 'name'])


    def list(self, max=None, **kwargs):
        '''
        [@param **kwargs: dict (property based filtering)]
        [@param max: int (max results)]

        @return Roles:
        '''

        url='/roles'

        result = self.__getProxy().get(
            url=UrlHelper.appendParameters(url, {'max:matrix':max}),
            headers={}
        ).get_role()

        return ParseHelper.toCollection(
            Role,
            FilterHelper.filter(result, kwargs),
            context=self.context
        )

class SchedulingPolicies(Base):
    def __init__(self, context):
        Base.__init__(self, context)

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def add(self, schedulingpolicy, correlation_id=None, expect=None):
        '''
        @type SchedulingPolicy:

        @param schedulingpolicy.name: string
        [@param schedulingpolicy.description: string]
        [@param schedulingpolicy.properties.property: collection]
        {
          [@ivar property.name: string]
          [@ivar property.value: string]
        }
        [@param correlation_id: any string]
        [@param expect: 201-created]

        @return SchedulingPolicy:
        '''

        url = '/schedulingpolicies'

        result = self.__getProxy().add(
           url=UrlHelper.appendParameters(
                url=url,
                args={}
           ),
           body=ParseHelper.toXml(schedulingpolicy),
           headers={"Correlation-Id":correlation_id, "Expect":expect}
        )

        return SchedulingPolicy(result, self.context)

    def get(self, name=None, id=None):
        '''
        [@param id  : string (the id of the entity)]
        [@param name: string (the name of the entity)]

        @return SchedulingPolicies:
        '''

        url = '/schedulingpolicies'

        if id:
            try :
                return SchedulingPolicy(
                    self.__getProxy().get(
                                url=UrlHelper.append(url, id),
                                headers={}
                    ),
                    self.context
                )
            except RequestError as err:
                if err.status and err.status == 404:
                    return None
                raise err
        elif name:
            result = self.__getProxy().get(
                    url=url,
                    headers={}
            ).get_scheduling_policy()

            return SchedulingPolicy(
                FilterHelper.getItem(
                    FilterHelper.filter(result, {'name':name}),
                    query="name=" + name
                ),
                self.context
            )
        else:
            raise MissingParametersError(['id', 'name'])


    def list(self, case_sensitive=True, max=None, **kwargs):
        '''
        [@param **kwargs: dict (property based filtering)]
        [@param case_sensitive: boolean (true|false)]
        [@param max: int (max results)]

        @return SchedulingPolicies:
        '''

        url='/schedulingpolicies'

        result = self.__getProxy().get(
            url=UrlHelper.appendParameters(url, {'case_sensitive:matrix':case_sensitive,'max:matrix':max}),
            headers={}
        ).get_scheduling_policy()

        return ParseHelper.toCollection(
            SchedulingPolicy,
            FilterHelper.filter(result, kwargs),
            context=self.context
        )

class SchedulingPolicy(params.SchedulingPolicy, Base):
    def __init__(self, schedulingpolicy, context):
        Base.__init__(self, context)
        self.superclass = schedulingpolicy

        self.balances = SchedulingPolicyBalances(self, context)
        self.filters = SchedulingPolicyFilters(self, context)
        self.weights = SchedulingPolicyWeights(self, context)

    def __new__(cls, schedulingpolicy, context):
        if schedulingpolicy is None: return None
        obj = object.__new__(cls)
        obj.__init__(schedulingpolicy, context)
        return obj

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def delete(self, async=None, correlation_id=None):
        '''
        [@param async: boolean (true|false)]
        [@param correlation_id: any string]

        @return None:
        '''

        url = UrlHelper.replace(
            '/schedulingpolicies/{schedulingpolicy:id}',
            {
                '{schedulingpolicy:id}': self.get_id(),
            }
        )

        return self.__getProxy().delete(
            url=UrlHelper.appendParameters(
                url,
                {'async:matrix':async}
            ),
            headers={"Correlation-Id":correlation_id,"Content-type":None}
        )

    def update(self, correlation_id=None, expect=None):
        '''
        [@param schedulingpolicy.name: string]
        [@param schedulingpolicy.description: string]
        [@param schedulingpolicy.properties.property: collection]
        {
          [@ivar property.name: string]
          [@ivar property.value: string]
        }
        [@param correlation_id: any string]
        [@param expect: 202-accepted]

        @return SchedulingPolicy:
        '''

        url = '/schedulingpolicies/{schedulingpolicy:id}'

        result = self.__getProxy().update(
            url=UrlHelper.replace(
                url,
                {
                    '{schedulingpolicy:id}': self.get_id(),
                }
            ),
            body=ParseHelper.toXml(self.superclass),
            headers={"Correlation-Id":correlation_id, "Expect":expect}
        )

        return SchedulingPolicy(result, self.context)

class SchedulingPolicyBalance(params.Balance, Base):
    def __init__(self, schedulingpolicy, balance, context):
        Base.__init__(self, context)
        self.parentclass = schedulingpolicy
        self.superclass  =  balance

        #SUB_COLLECTIONS
    def __new__(cls, schedulingpolicy, balance, context):
        if balance is None: return None
        obj = object.__new__(cls)
        obj.__init__(schedulingpolicy, balance, context)
        return obj

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def delete(self, async=None, correlation_id=None):
        '''
        [@param async: boolean (true|false)]
        [@param correlation_id: any string]

        @return None:
        '''

        url = UrlHelper.replace(
            '/schedulingpolicies/{schedulingpolicy:id}/balances/{balance:id}',
            {
                '{schedulingpolicy:id}': self.parentclass.get_id(),
                '{balance:id}': self.get_id(),
            }
        )

        return self.__getProxy().delete(
            url=UrlHelper.appendParameters(
                url,
                {'async:matrix':async}
            ),
            headers={"Correlation-Id":correlation_id,"Content-type":None}
        )

class SchedulingPolicyBalances(Base):

    def __init__(self, schedulingpolicy , context):
        Base.__init__(self, context)
        self.parentclass = schedulingpolicy

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def add(self, balance, correlation_id=None, expect=None):

        '''
        @type Balance:

        @param balance.scheduling_policy_unit.id: string
        [@param correlation_id: any string]
        [@param expect: 201-created]

        @return Balance:
        '''

        url = '/schedulingpolicies/{schedulingpolicy:id}/balances'

        result = self.__getProxy().add(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{schedulingpolicy:id}': self.parentclass.get_id(),
                    }
                ),
                args={}
            ),
            body=ParseHelper.toXml(balance),
            headers={"Correlation-Id":correlation_id, "Expect":expect}
        )

        return SchedulingPolicyBalance(
            self.parentclass,
            result,
            self.context
        )

    def get(self, name=None, id=None):

        '''
        [@param id  : string (the id of the entity)]
        [@param name: string (the name of the entity)]

        @return Balances:
        '''

        url = '/schedulingpolicies/{schedulingpolicy:id}/balances'

        if id:
            try :
                result = self.__getProxy().get(
                    url=UrlHelper.append(
                        UrlHelper.replace(
                            url,
                            {
                                '{schedulingpolicy:id}': self.parentclass.get_id(),
                            }
                        ),
                        id
                    ),
                    headers={}
                )

                return SchedulingPolicyBalance(
                    self.parentclass,
                    result,
                    self.context
                )
            except RequestError as err:
                if err.status and err.status == 404:
                    return None
                raise err
        elif name:
            result = self.__getProxy().get(
                url=UrlHelper.replace(
                    url,
                    {
                        '{schedulingpolicy:id}': self.parentclass.get_id(),
                    }
                ),
                headers={}
            ).get_balance()

            return SchedulingPolicyBalance(
                self.parentclass,
                FilterHelper.getItem(
                    FilterHelper.filter(
                        result,
                        {'name':name}
                    ),
                    query="name=" + name
                ),
                self.context
            )
        else:
            raise MissingParametersError(['id', 'name'])

    def list(self, case_sensitive=True, max=None, **kwargs):
        '''
        [@param **kwargs: dict (property based filtering)"]
        [@param case_sensitive: boolean (true|false)]
        [@param max: int (max results)]

        @return Balances:
        '''

        url = '/schedulingpolicies/{schedulingpolicy:id}/balances'

        result = self.__getProxy().get(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{schedulingpolicy:id}': self.parentclass.get_id(),
                    }
                ),
                args={'case_sensitive:matrix':case_sensitive,'max:matrix':max}
            ),
            headers={}
        ).get_balance()

        return ParseHelper.toSubCollection(
            SchedulingPolicyBalance,
            self.parentclass,
            FilterHelper.filter(
                result,
                kwargs
            ),
            context=self.context
        )

class SchedulingPolicyFilter(params.Filter, Base):
    def __init__(self, schedulingpolicy, filter, context):
        Base.__init__(self, context)
        self.parentclass = schedulingpolicy
        self.superclass  =  filter

        #SUB_COLLECTIONS
    def __new__(cls, schedulingpolicy, filter, context):
        if filter is None: return None
        obj = object.__new__(cls)
        obj.__init__(schedulingpolicy, filter, context)
        return obj

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def delete(self, async=None, correlation_id=None):
        '''
        [@param async: boolean (true|false)]
        [@param correlation_id: any string]

        @return None:
        '''

        url = UrlHelper.replace(
            '/schedulingpolicies/{schedulingpolicy:id}/filters/{filter:id}',
            {
                '{schedulingpolicy:id}': self.parentclass.get_id(),
                '{filter:id}': self.get_id(),
            }
        )

        return self.__getProxy().delete(
            url=UrlHelper.appendParameters(
                url,
                {'async:matrix':async}
            ),
            headers={"Correlation-Id":correlation_id,"Content-type":None}
        )

class SchedulingPolicyFilters(Base):

    def __init__(self, schedulingpolicy , context):
        Base.__init__(self, context)
        self.parentclass = schedulingpolicy

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def add(self, filter, correlation_id=None, expect=None):

        '''
        @type Filter:

        @param filter.scheduling_policy_unit.id: string
        [@param filter.scheduling_policy_unit.position: int]
        [@param correlation_id: any string]
        [@param expect: 201-created]

        @return Filter:
        '''

        url = '/schedulingpolicies/{schedulingpolicy:id}/filters'

        result = self.__getProxy().add(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{schedulingpolicy:id}': self.parentclass.get_id(),
                    }
                ),
                args={}
            ),
            body=ParseHelper.toXml(filter),
            headers={"Correlation-Id":correlation_id, "Expect":expect}
        )

        return SchedulingPolicyFilter(
            self.parentclass,
            result,
            self.context
        )

    def get(self, name=None, id=None):

        '''
        [@param id  : string (the id of the entity)]
        [@param name: string (the name of the entity)]

        @return Filters:
        '''

        url = '/schedulingpolicies/{schedulingpolicy:id}/filters'

        if id:
            try :
                result = self.__getProxy().get(
                    url=UrlHelper.append(
                        UrlHelper.replace(
                            url,
                            {
                                '{schedulingpolicy:id}': self.parentclass.get_id(),
                            }
                        ),
                        id
                    ),
                    headers={}
                )

                return SchedulingPolicyFilter(
                    self.parentclass,
                    result,
                    self.context
                )
            except RequestError as err:
                if err.status and err.status == 404:
                    return None
                raise err
        elif name:
            result = self.__getProxy().get(
                url=UrlHelper.replace(
                    url,
                    {
                        '{schedulingpolicy:id}': self.parentclass.get_id(),
                    }
                ),
                headers={}
            ).get_filter()

            return SchedulingPolicyFilter(
                self.parentclass,
                FilterHelper.getItem(
                    FilterHelper.filter(
                        result,
                        {'name':name}
                    ),
                    query="name=" + name
                ),
                self.context
            )
        else:
            raise MissingParametersError(['id', 'name'])

    def list(self, case_sensitive=True, max=None, **kwargs):
        '''
        [@param **kwargs: dict (property based filtering)"]
        [@param case_sensitive: boolean (true|false)]
        [@param max: int (max results)]

        @return Filters:
        '''

        url = '/schedulingpolicies/{schedulingpolicy:id}/filters'

        result = self.__getProxy().get(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{schedulingpolicy:id}': self.parentclass.get_id(),
                    }
                ),
                args={'case_sensitive:matrix':case_sensitive,'max:matrix':max}
            ),
            headers={}
        ).get_filter()

        return ParseHelper.toSubCollection(
            SchedulingPolicyFilter,
            self.parentclass,
            FilterHelper.filter(
                result,
                kwargs
            ),
            context=self.context
        )

class SchedulingPolicyUnit(params.SchedulingPolicyUnit, Base):
    def __init__(self, schedulingpolicyunit, context):
        Base.__init__(self, context)
        self.superclass = schedulingpolicyunit

        #SUB_COLLECTIONS
    def __new__(cls, schedulingpolicyunit, context):
        if schedulingpolicyunit is None: return None
        obj = object.__new__(cls)
        obj.__init__(schedulingpolicyunit, context)
        return obj

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def delete(self, async=None, correlation_id=None):
        '''
        [@param async: boolean (true|false)]
        [@param correlation_id: any string]

        @return None:
        '''

        url = UrlHelper.replace(
            '/schedulingpolicyunits/{schedulingpolicyunit:id}',
            {
                '{schedulingpolicyunit:id}': self.get_id(),
            }
        )

        return self.__getProxy().delete(
            url=UrlHelper.appendParameters(
                url,
                {'async:matrix':async}
            ),
            headers={"Correlation-Id":correlation_id,"Content-type":None}
        )

class SchedulingPolicyUnits(Base):
    def __init__(self, context):
        Base.__init__(self, context)

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def get(self, name=None, id=None):
        '''
        [@param id  : string (the id of the entity)]
        [@param name: string (the name of the entity)]

        @return SchedulingPolicyUnits:
        '''

        url = '/schedulingpolicyunits'

        if id:
            try :
                return SchedulingPolicyUnit(
                    self.__getProxy().get(
                                url=UrlHelper.append(url, id),
                                headers={}
                    ),
                    self.context
                )
            except RequestError as err:
                if err.status and err.status == 404:
                    return None
                raise err
        elif name:
            result = self.__getProxy().get(
                    url=url,
                    headers={}
            ).get_scheduling_policy_unit()

            return SchedulingPolicyUnit(
                FilterHelper.getItem(
                    FilterHelper.filter(result, {'name':name}),
                    query="name=" + name
                ),
                self.context
            )
        else:
            raise MissingParametersError(['id', 'name'])


    def list(self, case_sensitive=True, max=None, **kwargs):
        '''
        [@param **kwargs: dict (property based filtering)]
        [@param case_sensitive: boolean (true|false)]
        [@param max: int (max results)]

        @return SchedulingPolicyUnits:
        '''

        url='/schedulingpolicyunits'

        result = self.__getProxy().get(
            url=UrlHelper.appendParameters(url, {'case_sensitive:matrix':case_sensitive,'max:matrix':max}),
            headers={}
        ).get_scheduling_policy_unit()

        return ParseHelper.toCollection(
            SchedulingPolicyUnit,
            FilterHelper.filter(result, kwargs),
            context=self.context
        )

class SchedulingPolicyWeight(params.Weight, Base):
    def __init__(self, schedulingpolicy, weight, context):
        Base.__init__(self, context)
        self.parentclass = schedulingpolicy
        self.superclass  =  weight

        #SUB_COLLECTIONS
    def __new__(cls, schedulingpolicy, weight, context):
        if weight is None: return None
        obj = object.__new__(cls)
        obj.__init__(schedulingpolicy, weight, context)
        return obj

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def delete(self, async=None, correlation_id=None):
        '''
        [@param async: boolean (true|false)]
        [@param correlation_id: any string]

        @return None:
        '''

        url = UrlHelper.replace(
            '/schedulingpolicies/{schedulingpolicy:id}/weights/{weight:id}',
            {
                '{schedulingpolicy:id}': self.parentclass.get_id(),
                '{weight:id}': self.get_id(),
            }
        )

        return self.__getProxy().delete(
            url=UrlHelper.appendParameters(
                url,
                {'async:matrix':async}
            ),
            headers={"Correlation-Id":correlation_id,"Content-type":None}
        )

class SchedulingPolicyWeights(Base):

    def __init__(self, schedulingpolicy , context):
        Base.__init__(self, context)
        self.parentclass = schedulingpolicy

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def add(self, weight, correlation_id=None, expect=None):

        '''
        @type Weight:

        @param weight.scheduling_policy_unit.id: string
        [@param weight.scheduling_policy_unit.factor: int]
        [@param correlation_id: any string]
        [@param expect: 201-created]

        @return Weight:
        '''

        url = '/schedulingpolicies/{schedulingpolicy:id}/weights'

        result = self.__getProxy().add(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{schedulingpolicy:id}': self.parentclass.get_id(),
                    }
                ),
                args={}
            ),
            body=ParseHelper.toXml(weight),
            headers={"Correlation-Id":correlation_id, "Expect":expect}
        )

        return SchedulingPolicyWeight(
            self.parentclass,
            result,
            self.context
        )

    def get(self, name=None, id=None):

        '''
        [@param id  : string (the id of the entity)]
        [@param name: string (the name of the entity)]

        @return Weights:
        '''

        url = '/schedulingpolicies/{schedulingpolicy:id}/weights'

        if id:
            try :
                result = self.__getProxy().get(
                    url=UrlHelper.append(
                        UrlHelper.replace(
                            url,
                            {
                                '{schedulingpolicy:id}': self.parentclass.get_id(),
                            }
                        ),
                        id
                    ),
                    headers={}
                )

                return SchedulingPolicyWeight(
                    self.parentclass,
                    result,
                    self.context
                )
            except RequestError as err:
                if err.status and err.status == 404:
                    return None
                raise err
        elif name:
            result = self.__getProxy().get(
                url=UrlHelper.replace(
                    url,
                    {
                        '{schedulingpolicy:id}': self.parentclass.get_id(),
                    }
                ),
                headers={}
            ).get_weight()

            return SchedulingPolicyWeight(
                self.parentclass,
                FilterHelper.getItem(
                    FilterHelper.filter(
                        result,
                        {'name':name}
                    ),
                    query="name=" + name
                ),
                self.context
            )
        else:
            raise MissingParametersError(['id', 'name'])

    def list(self, case_sensitive=True, max=None, **kwargs):
        '''
        [@param **kwargs: dict (property based filtering)"]
        [@param case_sensitive: boolean (true|false)]
        [@param max: int (max results)]

        @return Weights:
        '''

        url = '/schedulingpolicies/{schedulingpolicy:id}/weights'

        result = self.__getProxy().get(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{schedulingpolicy:id}': self.parentclass.get_id(),
                    }
                ),
                args={'case_sensitive:matrix':case_sensitive,'max:matrix':max}
            ),
            headers={}
        ).get_weight()

        return ParseHelper.toSubCollection(
            SchedulingPolicyWeight,
            self.parentclass,
            FilterHelper.filter(
                result,
                kwargs
            ),
            context=self.context
        )

class StorageConnection(params.StorageConnection, Base):
    def __init__(self, storageconnection, context):
        Base.__init__(self, context)
        self.superclass = storageconnection

        #SUB_COLLECTIONS
    def __new__(cls, storageconnection, context):
        if storageconnection is None: return None
        obj = object.__new__(cls)
        obj.__init__(storageconnection, context)
        return obj

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def delete(self, action=params.Action(), async=None, correlation_id=None):
        '''
        @type Action:

        [@param action.host.id|name: string]
        [@param action.async: boolean]
        [@param action.grace_period.expiry: long]
        [@param correlation_id: any string]

        @return None:
        '''

        url = UrlHelper.replace(
            '/storageconnections/{storageconnection:id}',
            {
                '{storageconnection:id}': self.get_id(),
            }
        )

        return self.__getProxy().delete(
            url=UrlHelper.appendParameters(
                url,
                {'async:matrix':async}
            ),
            body=ParseHelper.toXml(action),
            headers={"Correlation-Id":correlation_id}
        )

    def update(self, correlation_id=None, expect=None):
        '''
        Overload 1:
          [@param storage_connection.password: string]
          [@param storage_connection.port: int]
          [@param storage_connection.target: string]
          [@param storage_connection.username: string]
        Overload 2:
          [@param storage_connection.address: string]
          [@param storage_connection.nfs_retrans: string]
          [@param storage_connection.nfs_timeo: string]
          [@param storage_connection.nfs_version: string]
          [@param storage_connection.path: string]
        Overload 3:
          [@param storage_connection.address: string]
          [@param storage_connection.mount_options: string]
          [@param storage_connection.path: string]
          [@param storage_connection.vfs_type: string]
        Overload 4:
          [@param storage_connection.path: string]
        [@param correlation_id: any string]
        [@param expect: 202-accepted]

        @return StorageConnection:
        '''

        url = '/storageconnections/{storageconnection:id}'

        result = self.__getProxy().update(
            url=UrlHelper.replace(
                url,
                {
                    '{storageconnection:id}': self.get_id(),
                }
            ),
            body=ParseHelper.toXml(self.superclass),
            headers={"Correlation-Id":correlation_id, "Expect":expect}
        )

        return StorageConnection(result, self.context)

class StorageConnections(Base):
    def __init__(self, context):
        Base.__init__(self, context)

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def add(self, storageconnection, correlation_id=None, expect=None):
        '''
        @type StorageConnection:

        Overload 1:
          @param storage_connection.address: string
          @param storage_connection.port: int
          @param storage_connection.target: string
          @param storage_connection.type: string
          [@param storage_connection.password: string]
          [@param storage_connection.username: string]
        Overload 2:
          @param storage_connection.address: string
          @param storage_connection.path: string
          @param storage_connection.type: string
          [@param storage_connection.nfs_retrans: string]
          [@param storage_connection.nfs_timeo: string]
          [@param storage_connection.nfs_version: string]
        Overload 3:
          @param storage_connection.path: string
          @param storage_connection.type: string
          @param storage_connection.vfs_type: string
          [@param storage_connection.address: string]
          [@param storage_connection.mount_options: string]
        Overload 4:
          @param storage_connection.path: string
          @param storage_connection.type: string
        [@param correlation_id: any string]
        [@param expect: 201-created]

        @return StorageConnection:
        '''

        url = '/storageconnections'

        result = self.__getProxy().add(
           url=UrlHelper.appendParameters(
                url=url,
                args={}
           ),
           body=ParseHelper.toXml(storageconnection),
           headers={"Correlation-Id":correlation_id, "Expect":expect}
        )

        return StorageConnection(result, self.context)

    def get(self, name=None, id=None):
        '''
        [@param id  : string (the id of the entity)]
        [@param name: string (the name of the entity)]

        @return StorageConnections:
        '''

        url = '/storageconnections'

        if id:
            try :
                return StorageConnection(
                    self.__getProxy().get(
                                url=UrlHelper.append(url, id),
                                headers={}
                    ),
                    self.context
                )
            except RequestError as err:
                if err.status and err.status == 404:
                    return None
                raise err
        elif name:
            result = self.__getProxy().get(
                    url=url,
                    headers={}
            ).get_storage_connection()

            return StorageConnection(
                FilterHelper.getItem(
                    FilterHelper.filter(result, {'name':name}),
                    query="name=" + name
                ),
                self.context
            )
        else:
            raise MissingParametersError(['id', 'name'])


    def list(self, max=None, **kwargs):
        '''
        [@param **kwargs: dict (property based filtering)]
        [@param max: int (max results)]

        @return StorageConnections:
        '''

        url='/storageconnections'

        result = self.__getProxy().get(
            url=UrlHelper.appendParameters(url, {'max:matrix':max}),
            headers={}
        ).get_storage_connection()

        return ParseHelper.toCollection(
            StorageConnection,
            FilterHelper.filter(result, kwargs),
            context=self.context
        )

class StorageDomain(params.StorageDomain, Base):
    def __init__(self, storagedomain, context):
        Base.__init__(self, context)
        self.superclass = storagedomain

        self.diskprofiles = StorageDomainDiskProfiles(self, context)
        self.disks = StorageDomainDisks(self, context)
        self.disksnapshots = StorageDomainDiskSnapshots(self, context)
        self.files = StorageDomainFiles(self, context)
        self.images = StorageDomainImages(self, context)
        self.permissions = StorageDomainPermissions(self, context)
        self.storageconnections = StorageDomainStorageConnections(self, context)
        self.templates = StorageDomainTemplates(self, context)
        self.vms = StorageDomainVMs(self, context)

    def __new__(cls, storagedomain, context):
        if storagedomain is None: return None
        obj = object.__new__(cls)
        obj.__init__(storagedomain, context)
        return obj

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def delete(self, storagedomain, async=None, correlation_id=None):
        '''
        @type StorageDomain:

        @param storagedomain.host.id|name: string
        [@param storagedomain.format: boolean]
        [@param async: boolean (true|false)]
        [@param correlation_id: any string]

        @return None:
        '''

        url = UrlHelper.replace(
            '/storagedomains/{storagedomain:id}',
            {
                '{storagedomain:id}': self.get_id(),
            }
        )

        return self.__getProxy().delete(
            url=UrlHelper.appendParameters(
                url,
                {'async:matrix':async}
            ),
            body=ParseHelper.toXml(storagedomain),
            headers={"Correlation-Id":correlation_id}
        )

    def update(self, correlation_id=None, expect=None):
        '''
        Overload 1:
          [@param storagedomain.name: string]
        Overload 2:
          @param storagedomain.storage.logical_unit: collection
          {
            @ivar logical_unit.address: string
            @ivar logical_unit.port: int
            @ivar logical_unit.target: string
            @ivar logical_unit.username: string
            @ivar logical_unit.password: string
            @ivar logical_unit.serial: string
            @ivar logical_unit.vendor_id: string
            @ivar logical_unit.product_id: string
            @ivar logical_unit.lun_mapping: int
            @ivar logical_unit.portal: string
            @ivar logical_unit.paths: int
            @ivar logical_unit.id: string
          }
          [@param storagedomain.host.id: string]
          [@param storagedomain.name: string]
          [@param storagedomain.comment: string]
          [@param storagedomain.storage.override_luns: boolean]
          [@param storagedomain.wipe_after_delete: boolean]
          [@param storagedomain.warning_low_space_indicator: int]
          [@param storagedomain.critical_space_action_blocker: int]
        [@param correlation_id: any string]
        [@param expect: 202-accepted]

        @return StorageDomain:
        '''

        url = '/storagedomains/{storagedomain:id}'

        result = self.__getProxy().update(
            url=UrlHelper.replace(
                url,
                {
                    '{storagedomain:id}': self.get_id(),
                }
            ),
            body=ParseHelper.toXml(self.superclass),
            headers={"Correlation-Id":correlation_id, "Expect":expect}
        )

        return StorageDomain(result, self.context)

    def isattached(self, action=params.Action(), correlation_id=None):
        '''
        @type Action:

        @param action.host.id: string
        [@param action.async: boolean]
        [@param action.grace_period.expiry: long]
        [@param correlation_id: any string]

        @return Action:
        '''

        url = '/storagedomains/{storagedomain:id}/isattached'

        result = self.__getProxy().request(
            method='POST',
            url=UrlHelper.replace(
                url,
                {
                    '{storagedomain:id}': self.get_id(),
                }
            ),
            body=ParseHelper.toXml(action),
            headers={"Correlation-Id":correlation_id}
        )

        return result

    def refreshluns(self, action=params.Action(), correlation_id=None):
        '''
        @type Action:

        [@param action.logical_units.logical_unit: collection]
        {
          [@ivar logical_unit.id: string]
        }
        [@param action.async: boolean]
        [@param action.grace_period.expiry: long]
        [@param correlation_id: any string]

        @return Action:
        '''

        url = '/storagedomains/{storagedomain:id}/refreshluns'

        result = self.__getProxy().request(
            method='POST',
            url=UrlHelper.replace(
                url,
                {
                    '{storagedomain:id}': self.get_id(),
                }
            ),
            body=ParseHelper.toXml(action),
            headers={"Correlation-Id":correlation_id}
        )

        return result

class StorageDomainDisk(params.Disk, Base):
    def __init__(self, storagedomain, disk, context):
        Base.__init__(self, context)
        self.parentclass = storagedomain
        self.superclass  =  disk

        self.permissions = StorageDomainDiskPermissions(self, context)
        self.statistics = StorageDomainDiskStatistics(self, context)

    def __new__(cls, storagedomain, disk, context):
        if disk is None: return None
        obj = object.__new__(cls)
        obj.__init__(storagedomain, disk, context)
        return obj

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def delete(self, async=None, correlation_id=None):
        '''
        [@param async: boolean (true|false)]
        [@param correlation_id: any string]

        @return None:
        '''

        url = UrlHelper.replace(
            '/storagedomains/{storagedomain:id}/disks/{disk:id}',
            {
                '{storagedomain:id}': self.parentclass.get_id(),
                '{disk:id}': self.get_id(),
            }
        )

        return self.__getProxy().delete(
            url=UrlHelper.appendParameters(
                url,
                {'async:matrix':async}
            ),
            headers={"Correlation-Id":correlation_id,"Content-type":None}
        )

    def copy(self, action=params.Action()):
        '''
        @type Action:


        @return Action:
        '''

        url = '/storagedomains/{storagedomain:id}/disks/{disk:id}/copy'

        result = self.__getProxy().request(
            method='POST',
            url=UrlHelper.replace(
                url,
                {
                    '{storagedomain:id}': self.parentclass.get_id(),
                    '{disk:id}': self.get_id(),
                }
            ),
            body=ParseHelper.toXml(action),
            headers={}
        )

        return result

    def export(self, action=params.Action(), correlation_id=None):
        '''
        @type Action:

        @param storagedomain.id|name: string
        [@param action.async: boolean]
        [@param action.grace_period.expiry: long]
        [@param correlation_id: any string]

        @return Action:
        '''

        url = '/storagedomains/{storagedomain:id}/disks/{disk:id}/export'

        result = self.__getProxy().request(
            method='POST',
            url=UrlHelper.replace(
                url,
                {
                    '{storagedomain:id}': self.parentclass.get_id(),
                    '{disk:id}': self.get_id(),
                }
            ),
            body=ParseHelper.toXml(action),
            headers={"Correlation-Id":correlation_id}
        )

        return result

    def move(self, action=params.Action()):
        '''
        @type Action:


        @return Action:
        '''

        url = '/storagedomains/{storagedomain:id}/disks/{disk:id}/move'

        result = self.__getProxy().request(
            method='POST',
            url=UrlHelper.replace(
                url,
                {
                    '{storagedomain:id}': self.parentclass.get_id(),
                    '{disk:id}': self.get_id(),
                }
            ),
            body=ParseHelper.toXml(action),
            headers={}
        )

        return result

class StorageDomainDiskPermission(params.Permission, Base):
    def __init__(self, storagedomaindisk, permission, context):
        Base.__init__(self, context)
        self.parentclass = storagedomaindisk
        self.superclass  =  permission

        #SUB_COLLECTIONS
    def __new__(cls, storagedomaindisk, permission, context):
        if permission is None: return None
        obj = object.__new__(cls)
        obj.__init__(storagedomaindisk, permission, context)
        return obj

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def delete(self, async=None):
        '''
        [@param async: boolean (true|false)]

        @return None:
        '''

        url = UrlHelper.replace(
            '/storagedomains/{storagedomain:id}/disks/{disk:id}/permissions/{permission:id}',
            {
                '{storagedomain:id}': self.parentclass.parentclass.get_id(),
                '{disk:id}': self.parentclass.get_id(),
                '{permission:id}': self.get_id(),
            }
        )

        return self.__getProxy().delete(
            url=UrlHelper.appendParameters(
                url,
                {'async:matrix':async}
            ),
            headers={"Content-type":None}
        )

class StorageDomainDiskPermissions(Base):

    def __init__(self, disk , context):
        Base.__init__(self, context)
        self.parentclass = disk

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def add(self, permission):

        '''
        @type Permission:


        @return Permission:
        '''

        url = '/storagedomains/{storagedomain:id}/disks/{disk:id}/permissions'

        result = self.__getProxy().add(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{storagedomain:id}': self.parentclass.parentclass.get_id(),
                        '{disk:id}': self.parentclass.get_id(),
                    }
                ),
                args={}
            ),
            body=ParseHelper.toXml(permission),
            headers={}
        )

        return StorageDomainDiskPermission(
            self.parentclass,
            result,
            self.context
        )

    def get(self, name=None, id=None):

        '''
        [@param id  : string (the id of the entity)]
        [@param name: string (the name of the entity)]

        @return Permissions:
        '''

        url = '/storagedomains/{storagedomain:id}/disks/{disk:id}/permissions'

        if id:
            try :
                result = self.__getProxy().get(
                    url=UrlHelper.append(
                        UrlHelper.replace(
                            url,
                            {
                                '{storagedomain:id}': self.parentclass.parentclass.get_id(),
                                '{disk:id}': self.parentclass.get_id(),
                            }
                        ),
                        id
                    ),
                    headers={}
                )

                return StorageDomainDiskPermission(
                    self.parentclass,
                    result,
                    self.context
                )
            except RequestError as err:
                if err.status and err.status == 404:
                    return None
                raise err
        elif name:
            result = self.__getProxy().get(
                url=UrlHelper.replace(
                    url,
                    {
                        '{storagedomain:id}': self.parentclass.parentclass.get_id(),
                        '{disk:id}': self.parentclass.get_id(),
                    }
                ),
                headers={}
            ).get_permission()

            return StorageDomainDiskPermission(
                self.parentclass,
                FilterHelper.getItem(
                    FilterHelper.filter(
                        result,
                        {'name':name}
                    ),
                    query="name=" + name
                ),
                self.context
            )
        else:
            raise MissingParametersError(['id', 'name'])

    def list(self, max=None, **kwargs):
        '''
        [@param **kwargs: dict (property based filtering)"]
        [@param max: int (max results)]

        @return Permissions:
        '''

        url = '/storagedomains/{storagedomain:id}/disks/{disk:id}/permissions'

        result = self.__getProxy().get(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{storagedomain:id}': self.parentclass.parentclass.get_id(),
                        '{disk:id}': self.parentclass.get_id(),
                    }
                ),
                args={'max:matrix':max}
            ),
            headers={}
        ).get_permission()

        return ParseHelper.toSubCollection(
            StorageDomainDiskPermission,
            self.parentclass,
            FilterHelper.filter(
                result,
                kwargs
            ),
            context=self.context
        )

class StorageDomainDiskProfile(params.DiskProfile, Base):
    def __init__(self, storagedomain, diskprofile, context):
        Base.__init__(self, context)
        self.parentclass = storagedomain
        self.superclass  =  diskprofile

        #SUB_COLLECTIONS
    def __new__(cls, storagedomain, diskprofile, context):
        if diskprofile is None: return None
        obj = object.__new__(cls)
        obj.__init__(storagedomain, diskprofile, context)
        return obj

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def delete(self, async=None, correlation_id=None):
        '''
        [@param async: boolean (true|false)]
        [@param correlation_id: any string]

        @return None:
        '''

        url = UrlHelper.replace(
            '/storagedomains/{storagedomain:id}/diskprofiles/{diskprofile:id}',
            {
                '{storagedomain:id}': self.parentclass.get_id(),
                '{diskprofile:id}': self.get_id(),
            }
        )

        return self.__getProxy().delete(
            url=UrlHelper.appendParameters(
                url,
                {'async:matrix':async}
            ),
            headers={"Correlation-Id":correlation_id,"Content-type":None}
        )

class StorageDomainDiskProfiles(Base):

    def __init__(self, storagedomain , context):
        Base.__init__(self, context)
        self.parentclass = storagedomain

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def add(self, diskprofile, correlation_id=None, expect=None):

        '''
        @type DiskProfile:

        @param diskprofile.name: string
        [@param diskprofile.description: string]
        [@param diskprofile.qos.id: string]
        [@param correlation_id: any string]
        [@param expect: 201-created]

        @return DiskProfile:
        '''

        url = '/storagedomains/{storagedomain:id}/diskprofiles'

        result = self.__getProxy().add(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{storagedomain:id}': self.parentclass.get_id(),
                    }
                ),
                args={}
            ),
            body=ParseHelper.toXml(diskprofile),
            headers={"Correlation-Id":correlation_id, "Expect":expect}
        )

        return StorageDomainDiskProfile(
            self.parentclass,
            result,
            self.context
        )

    def get(self, name=None, id=None):

        '''
        [@param id  : string (the id of the entity)]
        [@param name: string (the name of the entity)]

        @return DiskProfiles:
        '''

        url = '/storagedomains/{storagedomain:id}/diskprofiles'

        if id:
            try :
                result = self.__getProxy().get(
                    url=UrlHelper.append(
                        UrlHelper.replace(
                            url,
                            {
                                '{storagedomain:id}': self.parentclass.get_id(),
                            }
                        ),
                        id
                    ),
                    headers={}
                )

                return StorageDomainDiskProfile(
                    self.parentclass,
                    result,
                    self.context
                )
            except RequestError as err:
                if err.status and err.status == 404:
                    return None
                raise err
        elif name:
            result = self.__getProxy().get(
                url=UrlHelper.replace(
                    url,
                    {
                        '{storagedomain:id}': self.parentclass.get_id(),
                    }
                ),
                headers={}
            ).get_disk_profile()

            return StorageDomainDiskProfile(
                self.parentclass,
                FilterHelper.getItem(
                    FilterHelper.filter(
                        result,
                        {'name':name}
                    ),
                    query="name=" + name
                ),
                self.context
            )
        else:
            raise MissingParametersError(['id', 'name'])

    def list(self, max=None, **kwargs):
        '''
        [@param **kwargs: dict (property based filtering)"]
        [@param max: int (max results)]

        @return DiskProfiles:
        '''

        url = '/storagedomains/{storagedomain:id}/diskprofiles'

        result = self.__getProxy().get(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{storagedomain:id}': self.parentclass.get_id(),
                    }
                ),
                args={'max:matrix':max}
            ),
            headers={}
        ).get_disk_profile()

        return ParseHelper.toSubCollection(
            StorageDomainDiskProfile,
            self.parentclass,
            FilterHelper.filter(
                result,
                kwargs
            ),
            context=self.context
        )

class StorageDomainDiskSnapshot(params.DiskSnapshot, Base):
    def __init__(self, storagedomain, disksnapshot, context):
        Base.__init__(self, context)
        self.parentclass = storagedomain
        self.superclass  =  disksnapshot

        #SUB_COLLECTIONS
    def __new__(cls, storagedomain, disksnapshot, context):
        if disksnapshot is None: return None
        obj = object.__new__(cls)
        obj.__init__(storagedomain, disksnapshot, context)
        return obj

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def delete(self, async=None, correlation_id=None):
        '''
        [@param async: boolean (true|false)]
        [@param correlation_id: any string]

        @return None:
        '''

        url = UrlHelper.replace(
            '/storagedomains/{storagedomain:id}/disksnapshots/{disksnapshot:id}',
            {
                '{storagedomain:id}': self.parentclass.get_id(),
                '{disksnapshot:id}': self.get_id(),
            }
        )

        return self.__getProxy().delete(
            url=UrlHelper.appendParameters(
                url,
                {'async:matrix':async}
            ),
            headers={"Correlation-Id":correlation_id,"Content-type":None}
        )

class StorageDomainDiskSnapshots(Base):

    def __init__(self, storagedomain , context):
        Base.__init__(self, context)
        self.parentclass = storagedomain

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def get(self, name=None, id=None):

        '''
        [@param id  : string (the id of the entity)]
        [@param name: string (the name of the entity)]

        @return DiskSnapshots:
        '''

        url = '/storagedomains/{storagedomain:id}/disksnapshots'

        if id:
            try :
                result = self.__getProxy().get(
                    url=UrlHelper.append(
                        UrlHelper.replace(
                            url,
                            {
                                '{storagedomain:id}': self.parentclass.get_id(),
                            }
                        ),
                        id
                    ),
                    headers={}
                )

                return StorageDomainDiskSnapshot(
                    self.parentclass,
                    result,
                    self.context
                )
            except RequestError as err:
                if err.status and err.status == 404:
                    return None
                raise err
        elif name:
            result = self.__getProxy().get(
                url=UrlHelper.replace(
                    url,
                    {
                        '{storagedomain:id}': self.parentclass.get_id(),
                    }
                ),
                headers={}
            ).get_disk_snapshot()

            return StorageDomainDiskSnapshot(
                self.parentclass,
                FilterHelper.getItem(
                    FilterHelper.filter(
                        result,
                        {'name':name}
                    ),
                    query="name=" + name
                ),
                self.context
            )
        else:
            raise MissingParametersError(['id', 'name'])

    def list(self, max=None, **kwargs):
        '''
        [@param **kwargs: dict (property based filtering)"]
        [@param max: int (max results)]

        @return DiskSnapshots:
        '''

        url = '/storagedomains/{storagedomain:id}/disksnapshots'

        result = self.__getProxy().get(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{storagedomain:id}': self.parentclass.get_id(),
                    }
                ),
                args={'max:matrix':max}
            ),
            headers={}
        ).get_disk_snapshot()

        return ParseHelper.toSubCollection(
            StorageDomainDiskSnapshot,
            self.parentclass,
            FilterHelper.filter(
                result,
                kwargs
            ),
            context=self.context
        )

class StorageDomainDiskStatistic(params.Statistic, Base):
    def __init__(self, storagedomaindisk, statistic, context):
        Base.__init__(self, context)
        self.parentclass = storagedomaindisk
        self.superclass  =  statistic

        #SUB_COLLECTIONS
    def __new__(cls, storagedomaindisk, statistic, context):
        if statistic is None: return None
        obj = object.__new__(cls)
        obj.__init__(storagedomaindisk, statistic, context)
        return obj

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

class StorageDomainDiskStatistics(Base):

    def __init__(self, disk , context):
        Base.__init__(self, context)
        self.parentclass = disk

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def get(self, name=None, id=None):

        '''
        [@param id  : string (the id of the entity)]
        [@param name: string (the name of the entity)]

        @return Statistics:
        '''

        url = '/storagedomains/{storagedomain:id}/disks/{disk:id}/statistics'

        if id:
            try :
                result = self.__getProxy().get(
                    url=UrlHelper.append(
                        UrlHelper.replace(
                            url,
                            {
                                '{storagedomain:id}': self.parentclass.parentclass.get_id(),
                                '{disk:id}': self.parentclass.get_id(),
                            }
                        ),
                        id
                    ),
                    headers={}
                )

                return StorageDomainDiskStatistic(
                    self.parentclass,
                    result,
                    self.context
                )
            except RequestError as err:
                if err.status and err.status == 404:
                    return None
                raise err
        elif name:
            result = self.__getProxy().get(
                url=UrlHelper.replace(
                    url,
                    {
                        '{storagedomain:id}': self.parentclass.parentclass.get_id(),
                        '{disk:id}': self.parentclass.get_id(),
                    }
                ),
                headers={}
            ).get_statistic()

            return StorageDomainDiskStatistic(
                self.parentclass,
                FilterHelper.getItem(
                    FilterHelper.filter(
                        result,
                        {'name':name}
                    ),
                    query="name=" + name
                ),
                self.context
            )
        else:
            raise MissingParametersError(['id', 'name'])

    def list(self, **kwargs):
        '''
        [@param **kwargs: dict (property based filtering)"]

        @return Statistics:
        '''

        url = '/storagedomains/{storagedomain:id}/disks/{disk:id}/statistics'

        result = self.__getProxy().get(
            url=UrlHelper.replace(
                url,
                {
                    '{storagedomain:id}': self.parentclass.parentclass.get_id(),
                    '{disk:id}': self.parentclass.get_id(),
                }
            )
        ).get_statistic()

        return ParseHelper.toSubCollection(
            StorageDomainDiskStatistic,
            self.parentclass,
            FilterHelper.filter(
                result,
                kwargs
            ),
            context=self.context
        )

class StorageDomainDisks(Base):

    def __init__(self, storagedomain , context):
        Base.__init__(self, context)
        self.parentclass = storagedomain

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def add(self, disk, correlation_id=None, expect=None, unregistered=None):

        '''
        @type Disk:

        Overload 1:
          @param disk.format: string
          @param disk.interface: string
          @param disk.provisioned_size: int
          [@param disk.alias: string]
          [@param disk.name: string]
          [@param disk.size: int]
          [@param disk.sparse: boolean]
          [@param disk.description: string]
          [@param disk.bootable: boolean]
          [@param disk.shareable: boolean]
          [@param disk.propagate_errors: boolean]
          [@param disk.wipe_after_delete: boolean]
          [@param disk.quota.id: string]
          [@param disk.disk_profile.id: string]
          [@param disk.openstack_volume_type.name: string]
        Overload 2:
          @param disk.interface: string
          @param disk.format: string
          @param disk.lun_storage.type: string
          @param disk.lun_storage.logical_unit: collection
          {
            @ivar logical_unit.id: string
            @ivar logical_unit.address: string
            @ivar logical_unit.port: int
            @ivar logical_unit.target: string
          }
          [@param disk.alias: string]
          [@param disk.sparse: boolean]
          [@param disk.description: string]
          [@param disk.bootable: boolean]
          [@param disk.shareable: boolean]
          [@param disk.propagate_errors: boolean]
          [@param disk.wipe_after_delete: boolean]
          [@param disk.quota.id: string]
          [@param disk.sgio: string]
        [@param unregistered: boolean (true|false)]
        [@param correlation_id: any string]
        [@param expect: 201-created]

        @return Disk:
        '''

        url = '/storagedomains/{storagedomain:id}/disks'

        result = self.__getProxy().add(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{storagedomain:id}': self.parentclass.get_id(),
                    }
                ),
                args={'unregistered:matrix':unregistered}
            ),
            body=ParseHelper.toXml(disk),
            headers={"Correlation-Id":correlation_id, "Expect":expect}
        )

        return StorageDomainDisk(
            self.parentclass,
            result,
            self.context
        )

    def get(self, name=None, id=None):

        '''
        [@param id  : string (the id of the entity)]
        [@param name: string (the name of the entity)]

        @return Disks:
        '''

        url = '/storagedomains/{storagedomain:id}/disks'

        if id:
            try :
                result = self.__getProxy().get(
                    url=UrlHelper.append(
                        UrlHelper.replace(
                            url,
                            {
                                '{storagedomain:id}': self.parentclass.get_id(),
                            }
                        ),
                        id
                    ),
                    headers={}
                )

                return StorageDomainDisk(
                    self.parentclass,
                    result,
                    self.context
                )
            except RequestError as err:
                if err.status and err.status == 404:
                    return None
                raise err
        elif name:
            result = self.__getProxy().get(
                url=UrlHelper.replace(
                    url,
                    {
                        '{storagedomain:id}': self.parentclass.get_id(),
                    }
                ),
                headers={}
            ).get_disk()

            return StorageDomainDisk(
                self.parentclass,
                FilterHelper.getItem(
                    FilterHelper.filter(
                        result,
                        {'name':name}
                    ),
                    query="name=" + name
                ),
                self.context
            )
        else:
            raise MissingParametersError(['id', 'name'])

    def list(self, query=None, case_sensitive=True, unregistered=None, max=None, **kwargs):
        '''
        [@param **kwargs: dict (property based filtering)"]
        [@param query: string (oVirt engine search dialect query)]
        [@param case_sensitive: boolean (true|false)]
        [@param unregistered: boolean (true|false)]
        [@param max: int (max results)]

        @return Disks:
        '''

        url = '/storagedomains/{storagedomain:id}/disks'

        result = self.__getProxy().get(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{storagedomain:id}': self.parentclass.get_id(),
                    }
                ),
                args={'search:query':query,'case_sensitive:matrix':case_sensitive,'unregistered:matrix':unregistered,'max:matrix':max}
            ),
            headers={}
        ).get_disk()

        return ParseHelper.toSubCollection(
            StorageDomainDisk,
            self.parentclass,
            FilterHelper.filter(
                result,
                kwargs
            ),
            context=self.context
        )

class StorageDomainFile(params.File, Base):
    def __init__(self, storagedomain, file, context):
        Base.__init__(self, context)
        self.parentclass = storagedomain
        self.superclass  =  file

        #SUB_COLLECTIONS
    def __new__(cls, storagedomain, file, context):
        if file is None: return None
        obj = object.__new__(cls)
        obj.__init__(storagedomain, file, context)
        return obj

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

class StorageDomainFiles(Base):

    def __init__(self, storagedomain , context):
        Base.__init__(self, context)
        self.parentclass = storagedomain

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def get(self, name=None, id=None):

        '''
        [@param id  : string (the id of the entity)]
        [@param name: string (the name of the entity)]

        @return Files:
        '''

        url = '/storagedomains/{storagedomain:id}/files'

        if id:
            try :
                result = self.__getProxy().get(
                    url=UrlHelper.append(
                        UrlHelper.replace(
                            url,
                            {
                                '{storagedomain:id}': self.parentclass.get_id(),
                            }
                        ),
                        id
                    ),
                    headers={}
                )

                return StorageDomainFile(
                    self.parentclass,
                    result,
                    self.context
                )
            except RequestError as err:
                if err.status and err.status == 404:
                    return None
                raise err
        elif name:
            result = self.__getProxy().get(
                url=UrlHelper.replace(
                    url,
                    {
                        '{storagedomain:id}': self.parentclass.get_id(),
                    }
                ),
                headers={}
            ).get_file()

            return StorageDomainFile(
                self.parentclass,
                FilterHelper.getItem(
                    FilterHelper.filter(
                        result,
                        {'name':name}
                    ),
                    query="name=" + name
                ),
                self.context
            )
        else:
            raise MissingParametersError(['id', 'name'])

    def list(self, query=None, case_sensitive=True, max=None, **kwargs):
        '''
        [@param **kwargs: dict (property based filtering)"]
        [@param query: string (oVirt engine search dialect query)]
        [@param case_sensitive: boolean (true|false)]
        [@param max: int (max results)]

        @return Files:
        '''

        url = '/storagedomains/{storagedomain:id}/files'

        result = self.__getProxy().get(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{storagedomain:id}': self.parentclass.get_id(),
                    }
                ),
                args={'search:query':query,'case_sensitive:matrix':case_sensitive,'max:matrix':max}
            ),
            headers={}
        ).get_file()

        return ParseHelper.toSubCollection(
            StorageDomainFile,
            self.parentclass,
            FilterHelper.filter(
                result,
                kwargs
            ),
            context=self.context
        )

class StorageDomainImage(params.Image, Base):
    def __init__(self, storagedomain, image, context):
        Base.__init__(self, context)
        self.parentclass = storagedomain
        self.superclass  =  image

        #SUB_COLLECTIONS
    def __new__(cls, storagedomain, image, context):
        if image is None: return None
        obj = object.__new__(cls)
        obj.__init__(storagedomain, image, context)
        return obj

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def import_image(self, action=params.Action(), correlation_id=None):
        '''
        @type Action:

        @param storagedomain.id|name: string
        [@param action.import_as_template: boolean]
        [@param action.cluster.id|name: string]
        [@param action.disk.alias|name: string]
        [@param action.async: boolean]
        [@param action.grace_period.expiry: long]
        [@param correlation_id: any string]

        @return Action:
        '''

        url = '/storagedomains/{storagedomain:id}/images/{image:id}/import'

        result = self.__getProxy().request(
            method='POST',
            url=UrlHelper.replace(
                url,
                {
                    '{storagedomain:id}': self.parentclass.get_id(),
                    '{image:id}': self.get_id(),
                }
            ),
            body=ParseHelper.toXml(action),
            headers={"Correlation-Id":correlation_id}
        )

        return result

class StorageDomainImages(Base):

    def __init__(self, storagedomain , context):
        Base.__init__(self, context)
        self.parentclass = storagedomain

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def get(self, name=None, id=None):

        '''
        [@param id  : string (the id of the entity)]
        [@param name: string (the name of the entity)]

        @return Images:
        '''

        url = '/storagedomains/{storagedomain:id}/images'

        if id:
            try :
                result = self.__getProxy().get(
                    url=UrlHelper.append(
                        UrlHelper.replace(
                            url,
                            {
                                '{storagedomain:id}': self.parentclass.get_id(),
                            }
                        ),
                        id
                    ),
                    headers={}
                )

                return StorageDomainImage(
                    self.parentclass,
                    result,
                    self.context
                )
            except RequestError as err:
                if err.status and err.status == 404:
                    return None
                raise err
        elif name:
            result = self.__getProxy().get(
                url=UrlHelper.replace(
                    url,
                    {
                        '{storagedomain:id}': self.parentclass.get_id(),
                    }
                ),
                headers={}
            ).get_image()

            return StorageDomainImage(
                self.parentclass,
                FilterHelper.getItem(
                    FilterHelper.filter(
                        result,
                        {'name':name}
                    ),
                    query="name=" + name
                ),
                self.context
            )
        else:
            raise MissingParametersError(['id', 'name'])

    def list(self, max=None, **kwargs):
        '''
        [@param **kwargs: dict (property based filtering)"]
        [@param max: int (max results)]

        @return Images:
        '''

        url = '/storagedomains/{storagedomain:id}/images'

        result = self.__getProxy().get(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{storagedomain:id}': self.parentclass.get_id(),
                    }
                ),
                args={'max:matrix':max}
            ),
            headers={}
        ).get_image()

        return ParseHelper.toSubCollection(
            StorageDomainImage,
            self.parentclass,
            FilterHelper.filter(
                result,
                kwargs
            ),
            context=self.context
        )

class StorageDomainPermission(params.Permission, Base):
    def __init__(self, storagedomain, permission, context):
        Base.__init__(self, context)
        self.parentclass = storagedomain
        self.superclass  =  permission

        #SUB_COLLECTIONS
    def __new__(cls, storagedomain, permission, context):
        if permission is None: return None
        obj = object.__new__(cls)
        obj.__init__(storagedomain, permission, context)
        return obj

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def delete(self, async=None, correlation_id=None):
        '''
        [@param async: boolean (true|false)]
        [@param correlation_id: any string]

        @return None:
        '''

        url = UrlHelper.replace(
            '/storagedomains/{storagedomain:id}/permissions/{permission:id}',
            {
                '{storagedomain:id}': self.parentclass.get_id(),
                '{permission:id}': self.get_id(),
            }
        )

        return self.__getProxy().delete(
            url=UrlHelper.appendParameters(
                url,
                {'async:matrix':async}
            ),
            headers={"Correlation-Id":correlation_id,"Content-type":None}
        )

class StorageDomainPermissions(Base):

    def __init__(self, storagedomain , context):
        Base.__init__(self, context)
        self.parentclass = storagedomain

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def add(self, permission, correlation_id=None, expect=None):

        '''
        @type Permission:

        Overload 1:
          @param permission.user.id: string
          @param permission.role.id|name: string
        Overload 2:
          @param permission.group.id: string
          @param permission.role.id|name: string
        [@param correlation_id: any string]
        [@param expect: 201-created]

        @return Permission:
        '''

        url = '/storagedomains/{storagedomain:id}/permissions'

        result = self.__getProxy().add(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{storagedomain:id}': self.parentclass.get_id(),
                    }
                ),
                args={}
            ),
            body=ParseHelper.toXml(permission),
            headers={"Correlation-Id":correlation_id, "Expect":expect}
        )

        return StorageDomainPermission(
            self.parentclass,
            result,
            self.context
        )

    def get(self, name=None, id=None):

        '''
        [@param id  : string (the id of the entity)]
        [@param name: string (the name of the entity)]

        @return Permissions:
        '''

        url = '/storagedomains/{storagedomain:id}/permissions'

        if id:
            try :
                result = self.__getProxy().get(
                    url=UrlHelper.append(
                        UrlHelper.replace(
                            url,
                            {
                                '{storagedomain:id}': self.parentclass.get_id(),
                            }
                        ),
                        id
                    ),
                    headers={}
                )

                return StorageDomainPermission(
                    self.parentclass,
                    result,
                    self.context
                )
            except RequestError as err:
                if err.status and err.status == 404:
                    return None
                raise err
        elif name:
            result = self.__getProxy().get(
                url=UrlHelper.replace(
                    url,
                    {
                        '{storagedomain:id}': self.parentclass.get_id(),
                    }
                ),
                headers={}
            ).get_permission()

            return StorageDomainPermission(
                self.parentclass,
                FilterHelper.getItem(
                    FilterHelper.filter(
                        result,
                        {'name':name}
                    ),
                    query="name=" + name
                ),
                self.context
            )
        else:
            raise MissingParametersError(['id', 'name'])

    def list(self, max=None, **kwargs):
        '''
        [@param **kwargs: dict (property based filtering)"]
        [@param max: int (max results)]

        @return Permissions:
        '''

        url = '/storagedomains/{storagedomain:id}/permissions'

        result = self.__getProxy().get(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{storagedomain:id}': self.parentclass.get_id(),
                    }
                ),
                args={'max:matrix':max}
            ),
            headers={}
        ).get_permission()

        return ParseHelper.toSubCollection(
            StorageDomainPermission,
            self.parentclass,
            FilterHelper.filter(
                result,
                kwargs
            ),
            context=self.context
        )

class StorageDomainStorageConnection(params.StorageConnection, Base):
    def __init__(self, storagedomain, storageconnection, context):
        Base.__init__(self, context)
        self.parentclass = storagedomain
        self.superclass  =  storageconnection

        #SUB_COLLECTIONS
    def __new__(cls, storagedomain, storageconnection, context):
        if storageconnection is None: return None
        obj = object.__new__(cls)
        obj.__init__(storagedomain, storageconnection, context)
        return obj

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def delete(self, async=None, correlation_id=None):
        '''
        [@param async: boolean (true|false)]
        [@param correlation_id: any string]

        @return None:
        '''

        url = UrlHelper.replace(
            '/storagedomains/{storagedomain:id}/storageconnections/{storageconnection:id}',
            {
                '{storagedomain:id}': self.parentclass.get_id(),
                '{storageconnection:id}': self.get_id(),
            }
        )

        return self.__getProxy().delete(
            url=UrlHelper.appendParameters(
                url,
                {'async:matrix':async}
            ),
            headers={"Correlation-Id":correlation_id,"Content-type":None}
        )

class StorageDomainStorageConnections(Base):

    def __init__(self, storagedomain , context):
        Base.__init__(self, context)
        self.parentclass = storagedomain

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def add(self, storageconnection, correlation_id=None, expect=None):

        '''
        @type StorageConnection:

        @param storageconnection.id: string
        [@param correlation_id: any string]
        [@param expect: 201-created]

        @return StorageConnection:
        '''

        url = '/storagedomains/{storagedomain:id}/storageconnections'

        result = self.__getProxy().add(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{storagedomain:id}': self.parentclass.get_id(),
                    }
                ),
                args={}
            ),
            body=ParseHelper.toXml(storageconnection),
            headers={"Correlation-Id":correlation_id, "Expect":expect}
        )

        return StorageDomainStorageConnection(
            self.parentclass,
            result,
            self.context
        )

    def get(self, name=None, id=None):

        '''
        [@param id  : string (the id of the entity)]
        [@param name: string (the name of the entity)]

        @return StorageConnections:
        '''

        url = '/storagedomains/{storagedomain:id}/storageconnections'

        if id:
            try :
                result = self.__getProxy().get(
                    url=UrlHelper.append(
                        UrlHelper.replace(
                            url,
                            {
                                '{storagedomain:id}': self.parentclass.get_id(),
                            }
                        ),
                        id
                    ),
                    headers={}
                )

                return StorageDomainStorageConnection(
                    self.parentclass,
                    result,
                    self.context
                )
            except RequestError as err:
                if err.status and err.status == 404:
                    return None
                raise err
        elif name:
            result = self.__getProxy().get(
                url=UrlHelper.replace(
                    url,
                    {
                        '{storagedomain:id}': self.parentclass.get_id(),
                    }
                ),
                headers={}
            ).get_storage_connection()

            return StorageDomainStorageConnection(
                self.parentclass,
                FilterHelper.getItem(
                    FilterHelper.filter(
                        result,
                        {'name':name}
                    ),
                    query="name=" + name
                ),
                self.context
            )
        else:
            raise MissingParametersError(['id', 'name'])

    def list(self, max=None, **kwargs):
        '''
        [@param **kwargs: dict (property based filtering)"]
        [@param max: int (max results)]

        @return StorageConnections:
        '''

        url = '/storagedomains/{storagedomain:id}/storageconnections'

        result = self.__getProxy().get(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{storagedomain:id}': self.parentclass.get_id(),
                    }
                ),
                args={'max:matrix':max}
            ),
            headers={}
        ).get_storage_connection()

        return ParseHelper.toSubCollection(
            StorageDomainStorageConnection,
            self.parentclass,
            FilterHelper.filter(
                result,
                kwargs
            ),
            context=self.context
        )

class StorageDomainTemplate(params.Template, Base):
    def __init__(self, storagedomain, template, context):
        Base.__init__(self, context)
        self.parentclass = storagedomain
        self.superclass  =  template

        self.disks = StorageDomainTemplateDisks(self, context)

    def __new__(cls, storagedomain, template, context):
        if template is None: return None
        obj = object.__new__(cls)
        obj.__init__(storagedomain, template, context)
        return obj

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def delete(self, async=None, correlation_id=None):
        '''
        [@param async: boolean (true|false)]
        [@param correlation_id: any string]

        @return None:
        '''

        url = UrlHelper.replace(
            '/storagedomains/{storagedomain:id}/templates/{template:id}',
            {
                '{storagedomain:id}': self.parentclass.get_id(),
                '{template:id}': self.get_id(),
            }
        )

        return self.__getProxy().delete(
            url=UrlHelper.appendParameters(
                url,
                {'async:matrix':async}
            ),
            headers={"Correlation-Id":correlation_id,"Content-type":None}
        )

    def import_template(self, action=params.Action(), correlation_id=None):
        '''
        @type Action:

        @param action.cluster.id|name: string
        [@param action.storage_domain.id|name: string]
        [@param action.clone: boolen]
        [@param action.exclusive: boolen]
        [@param action.template.name: string]
        [@param action.vm.disks.disk: collection]
        {
          [@ivar disk.id: string]
        }
        [@param action.async: boolean]
        [@param action.grace_period.expiry: long]
        [@param correlation_id: any string]

        @return Action:
        '''

        url = '/storagedomains/{storagedomain:id}/templates/{template:id}/import'

        result = self.__getProxy().request(
            method='POST',
            url=UrlHelper.replace(
                url,
                {
                    '{storagedomain:id}': self.parentclass.get_id(),
                    '{template:id}': self.get_id(),
                }
            ),
            body=ParseHelper.toXml(action),
            headers={"Correlation-Id":correlation_id}
        )

        return result

    def register(self, action=params.Action(), correlation_id=None):
        '''
        @type Action:

        @param action.cluster.id|name: string
        [@param action.clone: boolen]
        [@param action.exclusive: boolen]
        [@param action.template.name: string]
        [@param action.async: boolean]
        [@param action.grace_period.expiry: long]
        [@param correlation_id: any string]

        @return Action:
        '''

        url = '/storagedomains/{storagedomain:id}/templates/{template:id}/register'

        result = self.__getProxy().request(
            method='POST',
            url=UrlHelper.replace(
                url,
                {
                    '{storagedomain:id}': self.parentclass.get_id(),
                    '{template:id}': self.get_id(),
                }
            ),
            body=ParseHelper.toXml(action),
            headers={"Correlation-Id":correlation_id}
        )

        return result

class StorageDomainTemplateDisk(params.Disk, Base):
    def __init__(self, storagedomaintemplate, disk, context):
        Base.__init__(self, context)
        self.parentclass = storagedomaintemplate
        self.superclass  =  disk

        #SUB_COLLECTIONS
    def __new__(cls, storagedomaintemplate, disk, context):
        if disk is None: return None
        obj = object.__new__(cls)
        obj.__init__(storagedomaintemplate, disk, context)
        return obj

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

class StorageDomainTemplateDisks(Base):

    def __init__(self, template , context):
        Base.__init__(self, context)
        self.parentclass = template

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def get(self, name=None, id=None):

        '''
        [@param id  : string (the id of the entity)]
        [@param name: string (the name of the entity)]

        @return Disks:
        '''

        url = '/storagedomains/{storagedomain:id}/templates/{template:id}/disks'

        if id:
            try :
                result = self.__getProxy().get(
                    url=UrlHelper.append(
                        UrlHelper.replace(
                            url,
                            {
                                '{storagedomain:id}': self.parentclass.parentclass.get_id(),
                                '{template:id}': self.parentclass.get_id(),
                            }
                        ),
                        id
                    ),
                    headers={}
                )

                return StorageDomainTemplateDisk(
                    self.parentclass,
                    result,
                    self.context
                )
            except RequestError as err:
                if err.status and err.status == 404:
                    return None
                raise err
        elif name:
            result = self.__getProxy().get(
                url=UrlHelper.replace(
                    url,
                    {
                        '{storagedomain:id}': self.parentclass.parentclass.get_id(),
                        '{template:id}': self.parentclass.get_id(),
                    }
                ),
                headers={}
            ).get_disk()

            return StorageDomainTemplateDisk(
                self.parentclass,
                FilterHelper.getItem(
                    FilterHelper.filter(
                        result,
                        {'name':name}
                    ),
                    query="name=" + name
                ),
                self.context
            )
        else:
            raise MissingParametersError(['id', 'name'])

    def list(self, max=None, **kwargs):
        '''
        [@param **kwargs: dict (property based filtering)"]
        [@param max: int (max results)]

        @return Disks:
        '''

        url = '/storagedomains/{storagedomain:id}/templates/{template:id}/disks'

        result = self.__getProxy().get(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{storagedomain:id}': self.parentclass.parentclass.get_id(),
                        '{template:id}': self.parentclass.get_id(),
                    }
                ),
                args={'max:matrix':max}
            ),
            headers={}
        ).get_disk()

        return ParseHelper.toSubCollection(
            StorageDomainTemplateDisk,
            self.parentclass,
            FilterHelper.filter(
                result,
                kwargs
            ),
            context=self.context
        )

class StorageDomainTemplates(Base):

    def __init__(self, storagedomain , context):
        Base.__init__(self, context)
        self.parentclass = storagedomain

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def get(self, name=None, id=None):

        '''
        [@param id  : string (the id of the entity)]
        [@param name: string (the name of the entity)]

        @return Templates:
        '''

        url = '/storagedomains/{storagedomain:id}/templates'

        if id:
            try :
                result = self.__getProxy().get(
                    url=UrlHelper.append(
                        UrlHelper.replace(
                            url,
                            {
                                '{storagedomain:id}': self.parentclass.get_id(),
                            }
                        ),
                        id
                    ),
                    headers={}
                )

                return StorageDomainTemplate(
                    self.parentclass,
                    result,
                    self.context
                )
            except RequestError as err:
                if err.status and err.status == 404:
                    return None
                raise err
        elif name:
            result = self.__getProxy().get(
                url=UrlHelper.replace(
                    url,
                    {
                        '{storagedomain:id}': self.parentclass.get_id(),
                    }
                ),
                headers={}
            ).get_template()

            return StorageDomainTemplate(
                self.parentclass,
                FilterHelper.getItem(
                    FilterHelper.filter(
                        result,
                        {'name':name}
                    ),
                    query="name=" + name
                ),
                self.context
            )
        else:
            raise MissingParametersError(['id', 'name'])

    def list(self, unregistered=None, max=None, **kwargs):
        '''
        [@param **kwargs: dict (property based filtering)"]
        [@param unregistered: boolean (true|false)]
        [@param max: int (max results)]

        @return Templates:
        '''

        url = '/storagedomains/{storagedomain:id}/templates'

        result = self.__getProxy().get(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{storagedomain:id}': self.parentclass.get_id(),
                    }
                ),
                args={'unregistered:matrix':unregistered,'max:matrix':max}
            ),
            headers={}
        ).get_template()

        return ParseHelper.toSubCollection(
            StorageDomainTemplate,
            self.parentclass,
            FilterHelper.filter(
                result,
                kwargs
            ),
            context=self.context
        )

class StorageDomainVM(params.VM, Base):
    def __init__(self, storagedomain, vm, context):
        Base.__init__(self, context)
        self.parentclass = storagedomain
        self.superclass  =  vm

        self.disks = StorageDomainVMDisks(self, context)

    def __new__(cls, storagedomain, vm, context):
        if vm is None: return None
        obj = object.__new__(cls)
        obj.__init__(storagedomain, vm, context)
        return obj

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def delete(self, async=None, correlation_id=None):
        '''
        [@param async: boolean (true|false)]
        [@param correlation_id: any string]

        @return None:
        '''

        url = UrlHelper.replace(
            '/storagedomains/{storagedomain:id}/vms/{vm:id}',
            {
                '{storagedomain:id}': self.parentclass.get_id(),
                '{vm:id}': self.get_id(),
            }
        )

        return self.__getProxy().delete(
            url=UrlHelper.appendParameters(
                url,
                {'async:matrix':async}
            ),
            headers={"Correlation-Id":correlation_id,"Content-type":None}
        )

    def import_vm(self, action=params.Action(), correlation_id=None):
        '''
        @type Action:

        @param action.cluster.id|name: string
        [@param action.storage_domain.id|name: string]
        [@param action.vm.snapshots.collapse_snapshots: boolean]
        [@param action.clone: boolen]
        [@param action.exclusive: boolen]
        [@param action.vm.name: string]
        [@param action.vm.disks.disk: collection]
        {
          [@ivar disk.id: string]
          [@ivar disk.format: string]
          [@ivar disk.sparse: string]
        }
        [@param action.async: boolean]
        [@param action.grace_period.expiry: long]
        [@param correlation_id: any string]

        @return Action:
        '''

        url = '/storagedomains/{storagedomain:id}/vms/{vm:id}/import'

        result = self.__getProxy().request(
            method='POST',
            url=UrlHelper.replace(
                url,
                {
                    '{storagedomain:id}': self.parentclass.get_id(),
                    '{vm:id}': self.get_id(),
                }
            ),
            body=ParseHelper.toXml(action),
            headers={"Correlation-Id":correlation_id}
        )

        return result

    def register(self, action=params.Action(), correlation_id=None):
        '''
        @type Action:

        @param action.cluster.id|name: string
        [@param action.clone: boolen]
        [@param action.vm.name: string]
        [@param action.async: boolean]
        [@param action.grace_period.expiry: long]
        [@param correlation_id: any string]

        @return Action:
        '''

        url = '/storagedomains/{storagedomain:id}/vms/{vm:id}/register'

        result = self.__getProxy().request(
            method='POST',
            url=UrlHelper.replace(
                url,
                {
                    '{storagedomain:id}': self.parentclass.get_id(),
                    '{vm:id}': self.get_id(),
                }
            ),
            body=ParseHelper.toXml(action),
            headers={"Correlation-Id":correlation_id}
        )

        return result

class StorageDomainVMDisk(params.Disk, Base):
    def __init__(self, storagedomainvm, disk, context):
        Base.__init__(self, context)
        self.parentclass = storagedomainvm
        self.superclass  =  disk

        #SUB_COLLECTIONS
    def __new__(cls, storagedomainvm, disk, context):
        if disk is None: return None
        obj = object.__new__(cls)
        obj.__init__(storagedomainvm, disk, context)
        return obj

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

class StorageDomainVMDisks(Base):

    def __init__(self, vm , context):
        Base.__init__(self, context)
        self.parentclass = vm

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def get(self, name=None, id=None):

        '''
        [@param id  : string (the id of the entity)]
        [@param name: string (the name of the entity)]

        @return Disks:
        '''

        url = '/storagedomains/{storagedomain:id}/vms/{vm:id}/disks'

        if id:
            try :
                result = self.__getProxy().get(
                    url=UrlHelper.append(
                        UrlHelper.replace(
                            url,
                            {
                                '{storagedomain:id}': self.parentclass.parentclass.get_id(),
                                '{vm:id}': self.parentclass.get_id(),
                            }
                        ),
                        id
                    ),
                    headers={}
                )

                return StorageDomainVMDisk(
                    self.parentclass,
                    result,
                    self.context
                )
            except RequestError as err:
                if err.status and err.status == 404:
                    return None
                raise err
        elif name:
            result = self.__getProxy().get(
                url=UrlHelper.replace(
                    url,
                    {
                        '{storagedomain:id}': self.parentclass.parentclass.get_id(),
                        '{vm:id}': self.parentclass.get_id(),
                    }
                ),
                headers={}
            ).get_disk()

            return StorageDomainVMDisk(
                self.parentclass,
                FilterHelper.getItem(
                    FilterHelper.filter(
                        result,
                        {'name':name}
                    ),
                    query="name=" + name
                ),
                self.context
            )
        else:
            raise MissingParametersError(['id', 'name'])

    def list(self, max=None, **kwargs):
        '''
        [@param **kwargs: dict (property based filtering)"]
        [@param max: int (max results)]

        @return Disks:
        '''

        url = '/storagedomains/{storagedomain:id}/vms/{vm:id}/disks'

        result = self.__getProxy().get(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{storagedomain:id}': self.parentclass.parentclass.get_id(),
                        '{vm:id}': self.parentclass.get_id(),
                    }
                ),
                args={'max:matrix':max}
            ),
            headers={}
        ).get_disk()

        return ParseHelper.toSubCollection(
            StorageDomainVMDisk,
            self.parentclass,
            FilterHelper.filter(
                result,
                kwargs
            ),
            context=self.context
        )

class StorageDomainVMs(Base):

    def __init__(self, storagedomain , context):
        Base.__init__(self, context)
        self.parentclass = storagedomain

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def get(self, name=None, id=None):

        '''
        [@param id  : string (the id of the entity)]
        [@param name: string (the name of the entity)]

        @return VMs:
        '''

        url = '/storagedomains/{storagedomain:id}/vms'

        if id:
            try :
                result = self.__getProxy().get(
                    url=UrlHelper.append(
                        UrlHelper.replace(
                            url,
                            {
                                '{storagedomain:id}': self.parentclass.get_id(),
                            }
                        ),
                        id
                    ),
                    headers={}
                )

                return StorageDomainVM(
                    self.parentclass,
                    result,
                    self.context
                )
            except RequestError as err:
                if err.status and err.status == 404:
                    return None
                raise err
        elif name:
            result = self.__getProxy().get(
                url=UrlHelper.replace(
                    url,
                    {
                        '{storagedomain:id}': self.parentclass.get_id(),
                    }
                ),
                headers={}
            ).get_vm()

            return StorageDomainVM(
                self.parentclass,
                FilterHelper.getItem(
                    FilterHelper.filter(
                        result,
                        {'name':name}
                    ),
                    query="name=" + name
                ),
                self.context
            )
        else:
            raise MissingParametersError(['id', 'name'])

    def list(self, unregistered=None, max=None, **kwargs):
        '''
        [@param **kwargs: dict (property based filtering)"]
        [@param unregistered: boolean (true|false)]
        [@param max: int (max results)]

        @return VMs:
        '''

        url = '/storagedomains/{storagedomain:id}/vms'

        result = self.__getProxy().get(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{storagedomain:id}': self.parentclass.get_id(),
                    }
                ),
                args={'unregistered:matrix':unregistered,'max:matrix':max}
            ),
            headers={}
        ).get_vm()

        return ParseHelper.toSubCollection(
            StorageDomainVM,
            self.parentclass,
            FilterHelper.filter(
                result,
                kwargs
            ),
            context=self.context
        )

class StorageDomains(Base):
    def __init__(self, context):
        Base.__init__(self, context)

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def add(self, storagedomain, correlation_id=None, expect=None):
        '''
        @type StorageDomain:

        Overload 1:
          @param storagedomain.host.id|name: string
          @param storagedomain.type: string
          @param storagedomain.storage.type: string
          @param storagedomain.storage.address: string
          @param storagedomain.storage.logical_unit: collection
          {
            @ivar logical_unit.address: string
            @ivar logical_unit.port: int
            @ivar logical_unit.target: string
            @ivar logical_unit.username: string
            @ivar logical_unit.password: string
            @ivar logical_unit.serial: string
            @ivar logical_unit.vendor_id: string
            @ivar logical_unit.product_id: string
            @ivar logical_unit.lun_mapping: int
            @ivar logical_unit.portal: string
            @ivar logical_unit.paths: int
            @ivar logical_unit.id: string
          }
          [@param storagedomain.name: string]
          [@param storagedomain.comment: string]
          [@param storagedomain.storage.override_luns: boolean]
          [@param storagedomain.storage_format: string]
          [@param storagedomain.wipe_after_delete: boolean]
          [@param storagedomain.warning_low_space_indicator: int]
          [@param storagedomain.critical_space_action_blocker: int]
        Overload 2:
          @param storagedomain.host.id|name: string
          @param storagedomain.type: string
          @param storagedomain.storage.type: string
          @param storagedomain.import: boolean
          [@param storagedomain.storage.address: string]
          [@param storagedomain.comment: string]
          [@param storagedomain.warning_low_space_indicator: int]
          [@param storagedomain.critical_space_action_blocker: int]
        Overload 3:
          @param storagedomain.host.id|name: string
          @param storagedomain.type: string
          @param storagedomain.storage.type: string
          @param storagedomain.storage.address: string
          @param storagedomain.storage.path: string
          [@param storagedomain.name: string]
          [@param storagedomain.comment: string]
          [@param storagedomain.storage_format: string]
          [@param storagedomain.wipe_after_delete: boolean]
          [@param storagedomain.warning_low_space_indicator: int]
          [@param storagedomain.critical_space_action_blocker: int]
        Overload 4:
          @param storagedomain.host.id|name: string
          @param storagedomain.type: string
          @param storagedomain.storage.type: string
          @param storagedomain.storage.path: string
          [@param storagedomain.name: string]
          [@param storagedomain.comment: string]
          [@param storagedomain.storage_format: string]
          [@param storagedomain.wipe_after_delete: boolean]
          [@param storagedomain.warning_low_space_indicator: int]
          [@param storagedomain.critical_space_action_blocker: int]
        Overload 5:
          @param storagedomain.host.id|name: string
          @param storagedomain.type: string
          @param storagedomain.storage.type: string
          @param storagedomain.storage.path: string
          @param storagedomain.storage.vfs_type: string
          [@param storagedomain.name: string]
          [@param storagedomain.comment: string]
          [@param storagedomain.storage.address: string]
          [@param storagedomain.storage.mount_options: string]
          [@param storagedomain.storage_format: string]
          [@param storagedomain.wipe_after_delete: boolean]
          [@param storagedomain.warning_low_space_indicator: int]
          [@param storagedomain.critical_space_action_blocker: int]
        [@param correlation_id: any string]
        [@param expect: 201-created]

        @return StorageDomain:
        '''

        url = '/storagedomains'

        result = self.__getProxy().add(
           url=UrlHelper.appendParameters(
                url=url,
                args={}
           ),
           body=ParseHelper.toXml(storagedomain),
           headers={"Correlation-Id":correlation_id, "Expect":expect}
        )

        return StorageDomain(result, self.context)

    def get(self, name=None, id=None):
        '''
        [@param id  : string (the id of the entity)]
        [@param name: string (the name of the entity)]

        @return StorageDomains:
        '''

        url = '/storagedomains'

        if id:
            try :
                return StorageDomain(
                    self.__getProxy().get(
                        url=UrlHelper.append(url, id),
                        headers={}
                    ),
                    self.context
                )
            except RequestError as err:
                if err.status and err.status == 404:
                    return None
                raise err
        elif name:
            result = self.__getProxy().get(
                url=UrlHelper.appendParameters(url, {'search:query':'name='+name}),
                headers={}
            ).get_storage_domain()

            return StorageDomain(
                FilterHelper.getItem(
                    FilterHelper.filter(result, {'name':name}),
                    query="name=" + name
                ),
                self.context
            )
        else:
            raise MissingParametersError(['id', 'name'])

    def list(self, query=None, case_sensitive=True, max=None, **kwargs):
        '''
        [@param **kwargs: dict (property based filtering)]
        [@param query: string (oVirt engine search dialect query)]
        [@param case_sensitive: boolean (true|false)]
        [@param max: int (max results)]

        @return StorageDomains:
        '''

        url='/storagedomains'

        result = self.__getProxy().get(
            url=UrlHelper.appendParameters(url, {'search:query':query,'case_sensitive:matrix':case_sensitive,'max:matrix':max}),
            headers={}
        ).get_storage_domain()

        return ParseHelper.toCollection(
            StorageDomain,
            FilterHelper.filter(result, kwargs),
            context=self.context
        )

class Tag(params.Tag, Base):
    def __init__(self, tag, context):
        Base.__init__(self, context)
        self.superclass = tag

        #SUB_COLLECTIONS
    def __new__(cls, tag, context):
        if tag is None: return None
        obj = object.__new__(cls)
        obj.__init__(tag, context)
        return obj

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def delete(self, async=None, correlation_id=None):
        '''
        [@param async: boolean (true|false)]
        [@param correlation_id: any string]

        @return None:
        '''

        url = UrlHelper.replace(
            '/tags/{tag:id}',
            {
                '{tag:id}': self.get_id(),
            }
        )

        return self.__getProxy().delete(
            url=UrlHelper.appendParameters(
                url,
                {'async:matrix':async}
            ),
            headers={"Correlation-Id":correlation_id,"Content-type":None}
        )

    def update(self, correlation_id=None, expect=None):
        '''
        [@param tag.name: string]
        [@param tag.description: string]
        [@param tag.parent.tag.id|name: string]
        [@param correlation_id: any string]
        [@param expect: 202-accepted]

        @return Tag:
        '''

        url = '/tags/{tag:id}'

        result = self.__getProxy().update(
            url=UrlHelper.replace(
                url,
                {
                    '{tag:id}': self.get_id(),
                }
            ),
            body=ParseHelper.toXml(self.superclass),
            headers={"Correlation-Id":correlation_id, "Expect":expect}
        )

        return Tag(result, self.context)

class Tags(Base):
    def __init__(self, context):
        Base.__init__(self, context)

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def add(self, tag, correlation_id=None, expect=None):
        '''
        @type Tag:

        @param tag.name: string
        [@param tag.description: string]
        [@param tag.parent.tag.id|name: string]
        [@param correlation_id: any string]
        [@param expect: 201-created]

        @return Tag:
        '''

        url = '/tags'

        result = self.__getProxy().add(
           url=UrlHelper.appendParameters(
                url=url,
                args={}
           ),
           body=ParseHelper.toXml(tag),
           headers={"Correlation-Id":correlation_id, "Expect":expect}
        )

        return Tag(result, self.context)

    def get(self, name=None, id=None):
        '''
        [@param id  : string (the id of the entity)]
        [@param name: string (the name of the entity)]

        @return Tags:
        '''

        url = '/tags'

        if id:
            try :
                return Tag(
                    self.__getProxy().get(
                                url=UrlHelper.append(url, id),
                                headers={}
                    ),
                    self.context
                )
            except RequestError as err:
                if err.status and err.status == 404:
                    return None
                raise err
        elif name:
            result = self.__getProxy().get(
                    url=url,
                    headers={}
            ).get_tag()

            return Tag(
                FilterHelper.getItem(
                    FilterHelper.filter(result, {'name':name}),
                    query="name=" + name
                ),
                self.context
            )
        else:
            raise MissingParametersError(['id', 'name'])


    def list(self, max=None, **kwargs):
        '''
        [@param **kwargs: dict (property based filtering)]
        [@param max: int (max results)]

        @return Tags:
        '''

        url='/tags'

        result = self.__getProxy().get(
            url=UrlHelper.appendParameters(url, {'max:matrix':max}),
            headers={}
        ).get_tag()

        return ParseHelper.toCollection(
            Tag,
            FilterHelper.filter(result, kwargs),
            context=self.context
        )

class Template(params.Template, Base):
    def __init__(self, template, context):
        Base.__init__(self, context)
        self.superclass = template

        self.cdroms = TemplateCdRoms(self, context)
        self.disks = TemplateDisks(self, context)
        self.graphicsconsoles = TemplateGraphicsConsoles(self, context)
        self.nics = TemplateNICs(self, context)
        self.permissions = TemplatePermissions(self, context)
        self.tags = TemplateTags(self, context)
        self.watchdogs = TemplateWatchDogs(self, context)

    def __new__(cls, template, context):
        if template is None: return None
        obj = object.__new__(cls)
        obj.__init__(template, context)
        return obj

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def delete(self, async=None, correlation_id=None):
        '''
        [@param async: boolean (true|false)]
        [@param correlation_id: any string]

        @return None:
        '''

        url = UrlHelper.replace(
            '/templates/{template:id}',
            {
                '{template:id}': self.get_id(),
            }
        )

        return self.__getProxy().delete(
            url=UrlHelper.appendParameters(
                url,
                {'async:matrix':async}
            ),
            headers={"Correlation-Id":correlation_id,"Content-type":None}
        )

    def update(self, correlation_id=None, expect=None):
        '''
        [@param template.name: string]
        [@param template.memory: long]
        [@param template.io.threads: int]
        [@param template.memory_policy.guaranteed: long]
        [@param template.memory_policy.ballooning: boolean]
        [@param template.cpu.topology.cores: int]
        [@param template.high_availability.enabled: boolean]
        [@param template.os.cmdline: string]
        [@param template.origin: string]
        [@param template.high_availability.priority: int]
        [@param template.timezone: string]
        [@param template.time_zone.name: string]
        [@param template.domain.name: string]
        [@param template.type: string]
        [@param template.stateless: boolean]
        [@param template.delete_protected: boolean]
        [@param template.sso.methods.method: collection]
        {
          [@ivar method.id: string]
        }
        [@param vm.rng_device.rate.bytes: int]
        [@param vm.rng_device.rate.period: int]
        [@param vm.rng_device.source: string]
        [@param template.console.enabled: boolean]
        [@param template.placement_policy.affinity: string]
        [@param template.description: string]
        [@param template.comment: string]
        [@param template.custom_properties.custom_property: collection]
        {
          [@ivar custom_property.name: string]
          [@ivar custom_property.value: string]
        }
        [@param template.os.type: string]
        [@param template.os.boot: collection]
        {
          [@ivar boot.dev: string]
        }
        [@param template.cpu.topology.sockets: int]
        [@param template.cpu_shares: int]
        [@param template.cpu.architecture: string]
        [@param template.os.kernel: string]
        [@param template.display.type: string]
        [@param template.display.monitors: int]
        [@param vm.display.single_qxl_pci: boolean]
        [@param template.display.allow_override: boolean]
        [@param template.display.smartcard_enabled: boolean]
        [@param vm.display.file_transfer_enabled: boolean]
        [@param vm.display.copy_paste_enabled: boolean]
        [@param template.display.keyboard_layout: string]
        [@param template.display.disconnect_action: string]
        [@param template.os.initRd: string]
        [@param template.usb.enabled: boolean]
        [@param template.usb.type: string]
        [@param template.tunnel_migration: boolean]
        [@param template.migration_downtime: int]
        [@param template.virtio_scsi.enabled: boolean]
        [@param template.soundcard_enabled: boolean]
        [@param template.custom_emulated_machine: string]
        [@param template.custom_cpu_model: string]
        [@param template.version.version_name: string]
        [@param template.serial_number.policy: string]
        [@param template.serial_number.value: string]
        [@param template.bios.boot_menu.enabled: boolean]
        [@param template.start_paused: boolean]
        [@param template.cpu_profile.id: string]
        [@param template.migration.auto_converge: string]
        [@param template.migration.compressed: string]
        [@param template.small_icon.id: string]
        [@param template.large_icon.id: string]
        [@param template.large_icon.media_type: string]
        [@param template.large_icon.data: string]
        [@param correlation_id: any string]
        [@param expect: 202-accepted]

        @return Template:
        '''

        url = '/templates/{template:id}'

        result = self.__getProxy().update(
            url=UrlHelper.replace(
                url,
                {
                    '{template:id}': self.get_id(),
                }
            ),
            body=ParseHelper.toXml(self.superclass),
            headers={"Correlation-Id":correlation_id, "Expect":expect}
        )

        return Template(result, self.context)

    def export(self, action=params.Action(), correlation_id=None):
        '''
        @type Action:

        @param action.storage_domain.id|name: string
        [@param action.exclusive: boolean]
        [@param action.async: boolean]
        [@param action.grace_period.expiry: long]
        [@param correlation_id: any string]

        @return Action:
        '''

        url = '/templates/{template:id}/export'

        result = self.__getProxy().request(
            method='POST',
            url=UrlHelper.replace(
                url,
                {
                    '{template:id}': self.get_id(),
                }
            ),
            body=ParseHelper.toXml(action),
            headers={"Correlation-Id":correlation_id}
        )

        return result

class TemplateCdRom(params.CdRom, Base):
    def __init__(self, template, cdrom, context):
        Base.__init__(self, context)
        self.parentclass = template
        self.superclass  =  cdrom

        #SUB_COLLECTIONS
    def __new__(cls, template, cdrom, context):
        if cdrom is None: return None
        obj = object.__new__(cls)
        obj.__init__(template, cdrom, context)
        return obj

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

class TemplateCdRoms(Base):

    def __init__(self, template , context):
        Base.__init__(self, context)
        self.parentclass = template

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def get(self, name=None, id=None):

        '''
        [@param id  : string (the id of the entity)]
        [@param name: string (the name of the entity)]

        @return CdRoms:
        '''

        url = '/templates/{template:id}/cdroms'

        if id:
            try :
                result = self.__getProxy().get(
                    url=UrlHelper.append(
                        UrlHelper.replace(
                            url,
                            {
                                '{template:id}': self.parentclass.get_id(),
                            }
                        ),
                        id
                    ),
                    headers={}
                )

                return TemplateCdRom(
                    self.parentclass,
                    result,
                    self.context
                )
            except RequestError as err:
                if err.status and err.status == 404:
                    return None
                raise err
        elif name:
            result = self.__getProxy().get(
                url=UrlHelper.replace(
                    url,
                    {
                        '{template:id}': self.parentclass.get_id(),
                    }
                ),
                headers={}
            ).get_cdrom()

            return TemplateCdRom(
                self.parentclass,
                FilterHelper.getItem(
                    FilterHelper.filter(
                        result,
                        {'name':name}
                    ),
                    query="name=" + name
                ),
                self.context
            )
        else:
            raise MissingParametersError(['id', 'name'])

    def list(self, max=None, **kwargs):
        '''
        [@param **kwargs: dict (property based filtering)"]
        [@param max: int (max results)]

        @return CdRoms:
        '''

        url = '/templates/{template:id}/cdroms'

        result = self.__getProxy().get(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{template:id}': self.parentclass.get_id(),
                    }
                ),
                args={'max:matrix':max}
            ),
            headers={}
        ).get_cdrom()

        return ParseHelper.toSubCollection(
            TemplateCdRom,
            self.parentclass,
            FilterHelper.filter(
                result,
                kwargs
            ),
            context=self.context
        )

class TemplateDisk(params.Disk, Base):
    def __init__(self, template, disk, context):
        Base.__init__(self, context)
        self.parentclass = template
        self.superclass  =  disk

        #SUB_COLLECTIONS
    def __new__(cls, template, disk, context):
        if disk is None: return None
        obj = object.__new__(cls)
        obj.__init__(template, disk, context)
        return obj

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def delete(self, action=params.Action(), async=None, correlation_id=None):
        '''
        @type Action:

        [@param action.storage_domain.id: string]
        [@param action.force: boolean]
        [@param action.async: boolean]
        [@param action.grace_period.expiry: long]
        [@param correlation_id: any string]

        @return None:
        '''

        url = UrlHelper.replace(
            '/templates/{template:id}/disks/{disk:id}',
            {
                '{template:id}': self.parentclass.get_id(),
                '{disk:id}': self.get_id(),
            }
        )

        return self.__getProxy().delete(
            url=UrlHelper.appendParameters(
                url,
                {'async:matrix':async}
            ),
            body=ParseHelper.toXml(action),
            headers={"Correlation-Id":correlation_id}
        )

    def copy(self, action=params.Action(), correlation_id=None):
        '''
        @type Action:

        @param storagedomain.id|name: string
        [@param action.async: boolean]
        [@param action.grace_period.expiry: long]
        [@param correlation_id: any string]

        @return Action:
        '''

        url = '/templates/{template:id}/disks/{disk:id}/copy'

        result = self.__getProxy().request(
            method='POST',
            url=UrlHelper.replace(
                url,
                {
                    '{template:id}': self.parentclass.get_id(),
                    '{disk:id}': self.get_id(),
                }
            ),
            body=ParseHelper.toXml(action),
            headers={"Correlation-Id":correlation_id}
        )

        return result

    def export(self, action=params.Action(), correlation_id=None):
        '''
        @type Action:

        @param storagedomain.id|name: string
        [@param action.async: boolean]
        [@param action.grace_period.expiry: long]
        [@param correlation_id: any string]

        @return Action:
        '''

        url = '/templates/{template:id}/disks/{disk:id}/export'

        result = self.__getProxy().request(
            method='POST',
            url=UrlHelper.replace(
                url,
                {
                    '{template:id}': self.parentclass.get_id(),
                    '{disk:id}': self.get_id(),
                }
            ),
            body=ParseHelper.toXml(action),
            headers={"Correlation-Id":correlation_id}
        )

        return result

class TemplateDisks(Base):

    def __init__(self, template , context):
        Base.__init__(self, context)
        self.parentclass = template

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def get(self, name=None, id=None):

        '''
        [@param id  : string (the id of the entity)]
        [@param name: string (the name of the entity)]

        @return Disks:
        '''

        url = '/templates/{template:id}/disks'

        if id:
            try :
                result = self.__getProxy().get(
                    url=UrlHelper.append(
                        UrlHelper.replace(
                            url,
                            {
                                '{template:id}': self.parentclass.get_id(),
                            }
                        ),
                        id
                    ),
                    headers={}
                )

                return TemplateDisk(
                    self.parentclass,
                    result,
                    self.context
                )
            except RequestError as err:
                if err.status and err.status == 404:
                    return None
                raise err
        elif name:
            result = self.__getProxy().get(
                url=UrlHelper.replace(
                    url,
                    {
                        '{template:id}': self.parentclass.get_id(),
                    }
                ),
                headers={}
            ).get_disk()

            return TemplateDisk(
                self.parentclass,
                FilterHelper.getItem(
                    FilterHelper.filter(
                        result,
                        {'name':name}
                    ),
                    query="name=" + name
                ),
                self.context
            )
        else:
            raise MissingParametersError(['id', 'name'])

    def list(self, max=None, **kwargs):
        '''
        [@param **kwargs: dict (property based filtering)"]
        [@param max: int (max results)]

        @return Disks:
        '''

        url = '/templates/{template:id}/disks'

        result = self.__getProxy().get(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{template:id}': self.parentclass.get_id(),
                    }
                ),
                args={'max:matrix':max}
            ),
            headers={}
        ).get_disk()

        return ParseHelper.toSubCollection(
            TemplateDisk,
            self.parentclass,
            FilterHelper.filter(
                result,
                kwargs
            ),
            context=self.context
        )

class TemplateGraphicsConsole(params.GraphicsConsole, Base):
    def __init__(self, template, graphicsconsole, context):
        Base.__init__(self, context)
        self.parentclass = template
        self.superclass  =  graphicsconsole

        #SUB_COLLECTIONS
    def __new__(cls, template, graphicsconsole, context):
        if graphicsconsole is None: return None
        obj = object.__new__(cls)
        obj.__init__(template, graphicsconsole, context)
        return obj

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def delete(self, async=None, correlation_id=None):
        '''
        [@param async: boolean (true|false)]
        [@param correlation_id: any string]

        @return None:
        '''

        url = UrlHelper.replace(
            '/templates/{template:id}/graphicsconsoles/{graphicsconsole:id}',
            {
                '{template:id}': self.parentclass.get_id(),
                '{graphicsconsole:id}': self.get_id(),
            }
        )

        return self.__getProxy().delete(
            url=UrlHelper.appendParameters(
                url,
                {'async:matrix':async}
            ),
            headers={"Correlation-Id":correlation_id,"Content-type":None}
        )

class TemplateGraphicsConsoles(Base):

    def __init__(self, template , context):
        Base.__init__(self, context)
        self.parentclass = template

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def add(self, graphicsconsole, correlation_id=None, expect=None):

        '''
        @type GraphicsConsole:

        @param graphics_console.protocol: string
        [@param correlation_id: any string]
        [@param expect: 201-created]

        @return GraphicsConsole:
        '''

        url = '/templates/{template:id}/graphicsconsoles'

        result = self.__getProxy().add(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{template:id}': self.parentclass.get_id(),
                    }
                ),
                args={}
            ),
            body=ParseHelper.toXml(graphicsconsole),
            headers={"Correlation-Id":correlation_id, "Expect":expect}
        )

        return TemplateGraphicsConsole(
            self.parentclass,
            result,
            self.context
        )

    def get(self, name=None, id=None):

        '''
        [@param id  : string (the id of the entity)]
        [@param name: string (the name of the entity)]

        @return GraphicsConsoles:
        '''

        url = '/templates/{template:id}/graphicsconsoles'

        if id:
            try :
                result = self.__getProxy().get(
                    url=UrlHelper.append(
                        UrlHelper.replace(
                            url,
                            {
                                '{template:id}': self.parentclass.get_id(),
                            }
                        ),
                        id
                    ),
                    headers={}
                )

                return TemplateGraphicsConsole(
                    self.parentclass,
                    result,
                    self.context
                )
            except RequestError as err:
                if err.status and err.status == 404:
                    return None
                raise err
        elif name:
            result = self.__getProxy().get(
                url=UrlHelper.replace(
                    url,
                    {
                        '{template:id}': self.parentclass.get_id(),
                    }
                ),
                headers={}
            ).get_graphics_console()

            return TemplateGraphicsConsole(
                self.parentclass,
                FilterHelper.getItem(
                    FilterHelper.filter(
                        result,
                        {'name':name}
                    ),
                    query="name=" + name
                ),
                self.context
            )
        else:
            raise MissingParametersError(['id', 'name'])

    def list(self, max=None, **kwargs):
        '''
        [@param **kwargs: dict (property based filtering)"]
        [@param max: int (max results)]

        @return GraphicsConsoles:
        '''

        url = '/templates/{template:id}/graphicsconsoles'

        result = self.__getProxy().get(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{template:id}': self.parentclass.get_id(),
                    }
                ),
                args={'max:matrix':max}
            ),
            headers={}
        ).get_graphics_console()

        return ParseHelper.toSubCollection(
            TemplateGraphicsConsole,
            self.parentclass,
            FilterHelper.filter(
                result,
                kwargs
            ),
            context=self.context
        )

class TemplateNIC(params.NIC, Base):
    def __init__(self, template, nic, context):
        Base.__init__(self, context)
        self.parentclass = template
        self.superclass  =  nic

        #SUB_COLLECTIONS
    def __new__(cls, template, nic, context):
        if nic is None: return None
        obj = object.__new__(cls)
        obj.__init__(template, nic, context)
        return obj

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def update(self, async=None, correlation_id=None, expect=None):
        '''
        Overload 1:
          [@param nic.vnic_profile.id: string]
          [@param nic.linked: boolean]
          [@param nic.name: string]
          [@param nic.mac.address: string]
          [@param nic.interface: string]
          [@param nic.plugged: boolean]
        Overload 2:
          [@param nic.network.id|name: string]
          [@param nic.linked: boolean]
          [@param nic.name: string]
          [@param nic.mac.address: string]
          [@param nic.interface: string]
          [@param nic.port_mirroring.networks.network: collection]
          {
            [@ivar network.id: string]
          }
        [@param async: boolean (true|false)]
        [@param correlation_id: any string]
        [@param expect: 202-accepted]

        @return NIC:
        '''

        url = '/templates/{template:id}/nics/{nic:id}'
        url = UrlHelper.replace(
            url,
            {
                '{template:id}': self.parentclass.get_id(),
                '{nic:id}': self.get_id(),
            }
        )

        result = self.__getProxy().update(
            url=UrlHelper.appendParameters(url, {'async:matrix':async}),
            body=ParseHelper.toXml(self.superclass),
            headers={"Correlation-Id":correlation_id, "Expect":expect}
        )

        return TemplateNIC(
            self.parentclass,
            result,
            self.context
        )

class TemplateNICs(Base):

    def __init__(self, template , context):
        Base.__init__(self, context)
        self.parentclass = template

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def add(self, nic, correlation_id=None, expect=None):

        '''
        @type NIC:

        Overload 1:
          @param nic.name: string
          [@param nic.vnic_profile.id: string]
          [@param nic.linked: boolean]
          [@param nic.mac.address: string]
          [@param nic.interface: string]
          [@param nic.plugged: boolean]
        Overload 2:
          @param nic.name: string
          [@param nic.network.id|name: string]
          [@param nic.linked: boolean]
          [@param nic.mac.address: string]
          [@param nic.interface: string]
          [@param nic.port_mirroring.networks.network: collection]
          {
            [@ivar network.id: string]
          }
        [@param correlation_id: any string]
        [@param expect: 201-created]

        @return NIC:
        '''

        url = '/templates/{template:id}/nics'

        result = self.__getProxy().add(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{template:id}': self.parentclass.get_id(),
                    }
                ),
                args={}
            ),
            body=ParseHelper.toXml(nic),
            headers={"Correlation-Id":correlation_id, "Expect":expect}
        )

        return TemplateNIC(
            self.parentclass,
            result,
            self.context
        )

    def get(self, name=None, id=None):

        '''
        [@param id  : string (the id of the entity)]
        [@param name: string (the name of the entity)]

        @return Nics:
        '''

        url = '/templates/{template:id}/nics'

        if id:
            try :
                result = self.__getProxy().get(
                    url=UrlHelper.append(
                        UrlHelper.replace(
                            url,
                            {
                                '{template:id}': self.parentclass.get_id(),
                            }
                        ),
                        id
                    ),
                    headers={}
                )

                return TemplateNIC(
                    self.parentclass,
                    result,
                    self.context
                )
            except RequestError as err:
                if err.status and err.status == 404:
                    return None
                raise err
        elif name:
            result = self.__getProxy().get(
                url=UrlHelper.replace(
                    url,
                    {
                        '{template:id}': self.parentclass.get_id(),
                    }
                ),
                headers={}
            ).get_nic()

            return TemplateNIC(
                self.parentclass,
                FilterHelper.getItem(
                    FilterHelper.filter(
                        result,
                        {'name':name}
                    ),
                    query="name=" + name
                ),
                self.context
            )
        else:
            raise MissingParametersError(['id', 'name'])

    def list(self, max=None, **kwargs):
        '''
        [@param **kwargs: dict (property based filtering)"]
        [@param max: int (max results)]

        @return Nics:
        '''

        url = '/templates/{template:id}/nics'

        result = self.__getProxy().get(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{template:id}': self.parentclass.get_id(),
                    }
                ),
                args={'max:matrix':max}
            ),
            headers={}
        ).get_nic()

        return ParseHelper.toSubCollection(
            TemplateNIC,
            self.parentclass,
            FilterHelper.filter(
                result,
                kwargs
            ),
            context=self.context
        )

class TemplatePermission(params.Permission, Base):
    def __init__(self, template, permission, context):
        Base.__init__(self, context)
        self.parentclass = template
        self.superclass  =  permission

        #SUB_COLLECTIONS
    def __new__(cls, template, permission, context):
        if permission is None: return None
        obj = object.__new__(cls)
        obj.__init__(template, permission, context)
        return obj

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def delete(self, async=None, correlation_id=None):
        '''
        [@param async: boolean (true|false)]
        [@param correlation_id: any string]

        @return None:
        '''

        url = UrlHelper.replace(
            '/templates/{template:id}/permissions/{permission:id}',
            {
                '{template:id}': self.parentclass.get_id(),
                '{permission:id}': self.get_id(),
            }
        )

        return self.__getProxy().delete(
            url=UrlHelper.appendParameters(
                url,
                {'async:matrix':async}
            ),
            headers={"Correlation-Id":correlation_id,"Content-type":None}
        )

class TemplatePermissions(Base):

    def __init__(self, template , context):
        Base.__init__(self, context)
        self.parentclass = template

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def add(self, permission, correlation_id=None, expect=None):

        '''
        @type Permission:

        Overload 1:
          @param permission.user.id: string
          @param permission.role.id|name: string
        Overload 2:
          @param permission.group.id: string
          @param permission.role.id|name: string
        [@param correlation_id: any string]
        [@param expect: 201-created]

        @return Permission:
        '''

        url = '/templates/{template:id}/permissions'

        result = self.__getProxy().add(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{template:id}': self.parentclass.get_id(),
                    }
                ),
                args={}
            ),
            body=ParseHelper.toXml(permission),
            headers={"Correlation-Id":correlation_id, "Expect":expect}
        )

        return TemplatePermission(
            self.parentclass,
            result,
            self.context
        )

    def get(self, name=None, id=None):

        '''
        [@param id  : string (the id of the entity)]
        [@param name: string (the name of the entity)]

        @return Permissions:
        '''

        url = '/templates/{template:id}/permissions'

        if id:
            try :
                result = self.__getProxy().get(
                    url=UrlHelper.append(
                        UrlHelper.replace(
                            url,
                            {
                                '{template:id}': self.parentclass.get_id(),
                            }
                        ),
                        id
                    ),
                    headers={}
                )

                return TemplatePermission(
                    self.parentclass,
                    result,
                    self.context
                )
            except RequestError as err:
                if err.status and err.status == 404:
                    return None
                raise err
        elif name:
            result = self.__getProxy().get(
                url=UrlHelper.replace(
                    url,
                    {
                        '{template:id}': self.parentclass.get_id(),
                    }
                ),
                headers={}
            ).get_permission()

            return TemplatePermission(
                self.parentclass,
                FilterHelper.getItem(
                    FilterHelper.filter(
                        result,
                        {'name':name}
                    ),
                    query="name=" + name
                ),
                self.context
            )
        else:
            raise MissingParametersError(['id', 'name'])

    def list(self, max=None, **kwargs):
        '''
        [@param **kwargs: dict (property based filtering)"]
        [@param max: int (max results)]

        @return Permissions:
        '''

        url = '/templates/{template:id}/permissions'

        result = self.__getProxy().get(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{template:id}': self.parentclass.get_id(),
                    }
                ),
                args={'max:matrix':max}
            ),
            headers={}
        ).get_permission()

        return ParseHelper.toSubCollection(
            TemplatePermission,
            self.parentclass,
            FilterHelper.filter(
                result,
                kwargs
            ),
            context=self.context
        )

class TemplateTag(params.Tag, Base):
    def __init__(self, template, tag, context):
        Base.__init__(self, context)
        self.parentclass = template
        self.superclass  =  tag

        #SUB_COLLECTIONS
    def __new__(cls, template, tag, context):
        if tag is None: return None
        obj = object.__new__(cls)
        obj.__init__(template, tag, context)
        return obj

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def delete(self, async=None, correlation_id=None):
        '''
        [@param async: boolean (true|false)]
        [@param correlation_id: any string]

        @return None:
        '''

        url = UrlHelper.replace(
            '/templates/{template:id}/tags/{tag:id}',
            {
                '{template:id}': self.parentclass.get_id(),
                '{tag:id}': self.get_id(),
            }
        )

        return self.__getProxy().delete(
            url=UrlHelper.appendParameters(
                url,
                {'async:matrix':async}
            ),
            headers={"Correlation-Id":correlation_id,"Content-type":None}
        )

class TemplateTags(Base):

    def __init__(self, template , context):
        Base.__init__(self, context)
        self.parentclass = template

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def add(self, tag, correlation_id=None, expect=None):

        '''
        @type Tag:

        @param tag.id|name: string
        [@param correlation_id: any string]
        [@param expect: 201-created]

        @return Tag:
        '''

        url = '/templates/{template:id}/tags'

        result = self.__getProxy().add(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{template:id}': self.parentclass.get_id(),
                    }
                ),
                args={}
            ),
            body=ParseHelper.toXml(tag),
            headers={"Correlation-Id":correlation_id, "Expect":expect}
        )

        return TemplateTag(
            self.parentclass,
            result,
            self.context
        )

    def get(self, name=None, id=None):

        '''
        [@param id  : string (the id of the entity)]
        [@param name: string (the name of the entity)]

        @return Tags:
        '''

        url = '/templates/{template:id}/tags'

        if id:
            try :
                result = self.__getProxy().get(
                    url=UrlHelper.append(
                        UrlHelper.replace(
                            url,
                            {
                                '{template:id}': self.parentclass.get_id(),
                            }
                        ),
                        id
                    ),
                    headers={}
                )

                return TemplateTag(
                    self.parentclass,
                    result,
                    self.context
                )
            except RequestError as err:
                if err.status and err.status == 404:
                    return None
                raise err
        elif name:
            result = self.__getProxy().get(
                url=UrlHelper.replace(
                    url,
                    {
                        '{template:id}': self.parentclass.get_id(),
                    }
                ),
                headers={}
            ).get_tag()

            return TemplateTag(
                self.parentclass,
                FilterHelper.getItem(
                    FilterHelper.filter(
                        result,
                        {'name':name}
                    ),
                    query="name=" + name
                ),
                self.context
            )
        else:
            raise MissingParametersError(['id', 'name'])

    def list(self, max=None, **kwargs):
        '''
        [@param **kwargs: dict (property based filtering)"]
        [@param max: int (max results)]

        @return Tags:
        '''

        url = '/templates/{template:id}/tags'

        result = self.__getProxy().get(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{template:id}': self.parentclass.get_id(),
                    }
                ),
                args={'max:matrix':max}
            ),
            headers={}
        ).get_tag()

        return ParseHelper.toSubCollection(
            TemplateTag,
            self.parentclass,
            FilterHelper.filter(
                result,
                kwargs
            ),
            context=self.context
        )

class TemplateWatchDog(params.WatchDog, Base):
    def __init__(self, template, watchdog, context):
        Base.__init__(self, context)
        self.parentclass = template
        self.superclass  =  watchdog

        #SUB_COLLECTIONS
    def __new__(cls, template, watchdog, context):
        if watchdog is None: return None
        obj = object.__new__(cls)
        obj.__init__(template, watchdog, context)
        return obj

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def delete(self, async=None, correlation_id=None):
        '''
        [@param async: boolean (true|false)]
        [@param correlation_id: any string]

        @return None:
        '''

        url = UrlHelper.replace(
            '/templates/{template:id}/watchdogs/{watchdog:id}',
            {
                '{template:id}': self.parentclass.get_id(),
                '{watchdog:id}': self.get_id(),
            }
        )

        return self.__getProxy().delete(
            url=UrlHelper.appendParameters(
                url,
                {'async:matrix':async}
            ),
            headers={"Correlation-Id":correlation_id,"Content-type":None}
        )

    def update(self, async=None, correlation_id=None, expect=None):
        '''
        [@param watchdog.action: string]
        [@param watchdog.model: string]
        [@param async: boolean (true|false)]
        [@param correlation_id: any string]
        [@param expect: 202-accepted]

        @return WatchDog:
        '''

        url = '/templates/{template:id}/watchdogs/{watchdog:id}'
        url = UrlHelper.replace(
            url,
            {
                '{template:id}': self.parentclass.get_id(),
                '{watchdog:id}': self.get_id(),
            }
        )

        result = self.__getProxy().update(
            url=UrlHelper.appendParameters(url, {'async:matrix':async}),
            body=ParseHelper.toXml(self.superclass),
            headers={"Correlation-Id":correlation_id, "Expect":expect}
        )

        return TemplateWatchDog(
            self.parentclass,
            result,
            self.context
        )

class TemplateWatchDogs(Base):

    def __init__(self, template , context):
        Base.__init__(self, context)
        self.parentclass = template

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def add(self, watchdog, correlation_id=None, expect=None):

        '''
        @type WatchDog:

        @param watchdog.action: string
        @param watchdog.model: string
        [@param correlation_id: any string]
        [@param expect: 201-created]

        @return WatchDog:
        '''

        url = '/templates/{template:id}/watchdogs'

        result = self.__getProxy().add(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{template:id}': self.parentclass.get_id(),
                    }
                ),
                args={}
            ),
            body=ParseHelper.toXml(watchdog),
            headers={"Correlation-Id":correlation_id, "Expect":expect}
        )

        return TemplateWatchDog(
            self.parentclass,
            result,
            self.context
        )

    def get(self, name=None, id=None):

        '''
        [@param id  : string (the id of the entity)]
        [@param name: string (the name of the entity)]

        @return WatchDogs:
        '''

        url = '/templates/{template:id}/watchdogs'

        if id:
            try :
                result = self.__getProxy().get(
                    url=UrlHelper.append(
                        UrlHelper.replace(
                            url,
                            {
                                '{template:id}': self.parentclass.get_id(),
                            }
                        ),
                        id
                    ),
                    headers={}
                )

                return TemplateWatchDog(
                    self.parentclass,
                    result,
                    self.context
                )
            except RequestError as err:
                if err.status and err.status == 404:
                    return None
                raise err
        elif name:
            result = self.__getProxy().get(
                url=UrlHelper.replace(
                    url,
                    {
                        '{template:id}': self.parentclass.get_id(),
                    }
                ),
                headers={}
            ).get_watchdog()

            return TemplateWatchDog(
                self.parentclass,
                FilterHelper.getItem(
                    FilterHelper.filter(
                        result,
                        {'name':name}
                    ),
                    query="name=" + name
                ),
                self.context
            )
        else:
            raise MissingParametersError(['id', 'name'])

    def list(self, max=None, **kwargs):
        '''
        [@param **kwargs: dict (property based filtering)"]
        [@param max: int (max results)]

        @return WatchDogs:
        '''

        url = '/templates/{template:id}/watchdogs'

        result = self.__getProxy().get(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{template:id}': self.parentclass.get_id(),
                    }
                ),
                args={'max:matrix':max}
            ),
            headers={}
        ).get_watchdog()

        return ParseHelper.toSubCollection(
            TemplateWatchDog,
            self.parentclass,
            FilterHelper.filter(
                result,
                kwargs
            ),
            context=self.context
        )

class Templates(Base):
    def __init__(self, context):
        Base.__init__(self, context)

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def add(self, template, correlation_id=None, expect=None):
        '''
        @type Template:

        @param template.vm.id|name: string
        @param template.name: string
        [@param template.memory: long]
        [@param template.io.threads: int]
        [@param template.memory_policy.guaranteed: long]
        [@param template.memory_policy.ballooning: boolean]
        [@param template.cpu.topology.cores: int]
        [@param template.cpu.topology.threds: int]
        [@param template.high_availability.enabled: boolean]
        [@param template.os.cmdline: string]
        [@param template.origin: string]
        [@param template.high_availability.priority: int]
        [@param template.timezone: string]
        [@param template.time_zone.name: string]
        [@param template.storage_domain.id: string]
        [@param template.domain.name: string]
        [@param template.type: string]
        [@param template.stateless: boolean]
        [@param template.delete_protected: boolean]
        [@param template.sso.methods.method: collection]
        {
          [@ivar method.id: string]
        }
        [@param vm.rng_device.rate.bytes: int]
        [@param vm.rng_device.rate.period: int]
        [@param vm.rng_device.source: string]
        [@param template.console.enabled: boolean]
        [@param template.placement_policy.affinity: string]
        [@param template.description: string]
        [@param template.comment: string]
        [@param template.custom_properties.custom_property: collection]
        {
          [@ivar custom_property.name: string]
          [@ivar custom_property.value: string]
        }
        [@param template.os.type: string]
        [@param template.os.boot: collection]
        {
          [@ivar boot.dev: string]
        }
        [@param template.cpu.topology.sockets: int]
        [@param template.cpu_shares: int]
        [@param template.cpu.architecture: string]
        [@param template.os.kernel: string]
        [@param template.display.type: string]
        [@param template.display.monitors: int]
        [@param vm.display.single_qxl_pci: boolean]
        [@param template.display.allow_override: boolean]
        [@param template.display.smartcard_enabled: boolean]
        [@param template.display.file_transfer_enabled: boolean]
        [@param template.display.copy_paste_enabled: boolean]
        [@param template.display.keyboard_layout: string]
        [@param template.display.disconnect_action: string]
        [@param template.os.initRd: string]
        [@param template.usb.enabled: boolean]
        [@param template.usb.type: string]
        [@param template.tunnel_migration: boolean]
        [@param template.migration_downtime: int]
        [@param template.virtio_scsi.enabled: boolean]
        [@param template.soundcard_enabled: boolean]
        [@param template.custom_emulated_machine: string]
        [@param template.custom_cpu_model: string]
        [@param template.vm.disks.disk: collection]
        {
          [@ivar disk.id: string]
          [@ivar disk.alias: string]
          [@ivar disk.description: string]
          [@ivar storage_domains.storage_domain: collection]
          {
            [@param storage_domain.id: string]
          }
        }
        [@param template.permissions.clone: boolean]
        [@param template.version.version_name: string]
        [@param template.version.base_template.id: string]
        [@param template.cpu.cpu_tune.vcpu_pin: collection]
        {
          [@ivar vcpu_pin.vcpu: int]
          [@ivar vcpu_pin.cpu_set: string]
        }
        [@param template.serial_number.policy: string]
        [@param template.serial_number.value: string]
        [@param template.bios.boot_menu.enabled: boolean]
        [@param template.cluster.id: string]
        [@param template.cluster.name: string]
        [@param template.start_paused: boolean]
        [@param template.cpu_profile.id: string]
        [@param template.migration.auto_converge: string]
        [@param template.migration.compressed: string]
        [@param template.small_icon.id: string]
        [@param template.large_icon.id: string]
        [@param template.large_icon.media_type: string]
        [@param template.large_icon.data: string]
        [@param correlation_id: any string]
        [@param expect: 201-created]

        @return Template:
        '''

        url = '/templates'

        result = self.__getProxy().add(
           url=UrlHelper.appendParameters(
                url=url,
                args={}
           ),
           body=ParseHelper.toXml(template),
           headers={"Correlation-Id":correlation_id, "Expect":expect}
        )

        return Template(result, self.context)

    def get(self, name=None, all_content=None, id=None):
        '''
        [@param id  : string (the id of the entity)]
        [@param name: string (the name of the entity)]
        [@param all_content: true|false]

        @return Templates:
        '''

        url = '/templates'

        if id:
            try :
                return Template(
                    self.__getProxy().get(
                        url=UrlHelper.append(url, id),
                        headers={"All-Content":all_content}
                    ),
                    self.context
                )
            except RequestError as err:
                if err.status and err.status == 404:
                    return None
                raise err
        elif name:
            result = self.__getProxy().get(
                url=UrlHelper.appendParameters(url, {'search:query':'name='+name}),
                headers={"All-Content":all_content}
            ).get_template()

            return Template(
                FilterHelper.getItem(
                    FilterHelper.filter(result, {'name':name}),
                    query="name=" + name
                ),
                self.context
            )
        else:
            raise MissingParametersError(['id', 'name'])

    def list(self, query=None, case_sensitive=True, max=None, all_content=None, **kwargs):
        '''
        [@param **kwargs: dict (property based filtering)]
        [@param query: string (oVirt engine search dialect query)]
        [@param case_sensitive: boolean (true|false)]
        [@param max: int (max results)]
        [@param all_content: true|false]

        @return Templates:
        '''

        url='/templates'

        result = self.__getProxy().get(
            url=UrlHelper.appendParameters(url, {'search:query':query,'case_sensitive:matrix':case_sensitive,'max:matrix':max}),
            headers={"All-Content":all_content}
        ).get_template()

        return ParseHelper.toCollection(
            Template,
            FilterHelper.filter(result, kwargs),
            context=self.context
        )

class User(params.User, Base):
    def __init__(self, user, context):
        Base.__init__(self, context)
        self.superclass = user

        self.permissions = UserPermissions(self, context)
        self.roles = UserRoles(self, context)
        self.sshpublickeys = UserSSHPublicKeys(self, context)
        self.tags = UserTags(self, context)

    def __new__(cls, user, context):
        if user is None: return None
        obj = object.__new__(cls)
        obj.__init__(user, context)
        return obj

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def delete(self, async=None, correlation_id=None):
        '''
        [@param async: boolean (true|false)]
        [@param correlation_id: any string]

        @return None:
        '''

        url = UrlHelper.replace(
            '/users/{user:id}',
            {
                '{user:id}': self.get_id(),
            }
        )

        return self.__getProxy().delete(
            url=UrlHelper.appendParameters(
                url,
                {'async:matrix':async}
            ),
            headers={"Correlation-Id":correlation_id,"Content-type":None}
        )

class UserPermission(params.Permission, Base):
    def __init__(self, user, permission, context):
        Base.__init__(self, context)
        self.parentclass = user
        self.superclass  =  permission

        #SUB_COLLECTIONS
    def __new__(cls, user, permission, context):
        if permission is None: return None
        obj = object.__new__(cls)
        obj.__init__(user, permission, context)
        return obj

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def delete(self, async=None, correlation_id=None):
        '''
        [@param async: boolean (true|false)]
        [@param correlation_id: any string]

        @return None:
        '''

        url = UrlHelper.replace(
            '/users/{user:id}/permissions/{permission:id}',
            {
                '{user:id}': self.parentclass.get_id(),
                '{permission:id}': self.get_id(),
            }
        )

        return self.__getProxy().delete(
            url=UrlHelper.appendParameters(
                url,
                {'async:matrix':async}
            ),
            headers={"Correlation-Id":correlation_id,"Content-type":None}
        )

class UserPermissions(Base):

    def __init__(self, user , context):
        Base.__init__(self, context)
        self.parentclass = user

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def add(self, permission, correlation_id=None, expect=None):

        '''
        @type Permission:

        Overload 1:
          @param permission.role.id|name: string
          @param permission.data_center.id: string
        Overload 2:
          @param permission.role.id|name: string
          @param permission.cluster.id: string
        Overload 3:
          @param permission.role.id|name: string
          @param permission.host.id: string
        Overload 4:
          @param permission.role.id|name: string
          @param permission.storage_domain.id: string
        Overload 5:
          @param permission.role.id|name: string
          @param permission.vm.id: string
        Overload 6:
          @param permission.role.id|name: string
          @param permission.vmpool.id: string
        Overload 7:
          @param permission.role.id|name: string
          @param permission.template.id: string
        [@param correlation_id: any string]
        [@param expect: 201-created]

        @return Permission:
        '''

        url = '/users/{user:id}/permissions'

        result = self.__getProxy().add(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{user:id}': self.parentclass.get_id(),
                    }
                ),
                args={}
            ),
            body=ParseHelper.toXml(permission),
            headers={"Correlation-Id":correlation_id, "Expect":expect}
        )

        return UserPermission(
            self.parentclass,
            result,
            self.context
        )

    def get(self, name=None, id=None):

        '''
        [@param id  : string (the id of the entity)]
        [@param name: string (the name of the entity)]

        @return Permissions:
        '''

        url = '/users/{user:id}/permissions'

        if id:
            try :
                result = self.__getProxy().get(
                    url=UrlHelper.append(
                        UrlHelper.replace(
                            url,
                            {
                                '{user:id}': self.parentclass.get_id(),
                            }
                        ),
                        id
                    ),
                    headers={}
                )

                return UserPermission(
                    self.parentclass,
                    result,
                    self.context
                )
            except RequestError as err:
                if err.status and err.status == 404:
                    return None
                raise err
        elif name:
            result = self.__getProxy().get(
                url=UrlHelper.replace(
                    url,
                    {
                        '{user:id}': self.parentclass.get_id(),
                    }
                ),
                headers={}
            ).get_permission()

            return UserPermission(
                self.parentclass,
                FilterHelper.getItem(
                    FilterHelper.filter(
                        result,
                        {'name':name}
                    ),
                    query="name=" + name
                ),
                self.context
            )
        else:
            raise MissingParametersError(['id', 'name'])

    def list(self, max=None, **kwargs):
        '''
        [@param **kwargs: dict (property based filtering)"]
        [@param max: int (max results)]

        @return Permissions:
        '''

        url = '/users/{user:id}/permissions'

        result = self.__getProxy().get(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{user:id}': self.parentclass.get_id(),
                    }
                ),
                args={'max:matrix':max}
            ),
            headers={}
        ).get_permission()

        return ParseHelper.toSubCollection(
            UserPermission,
            self.parentclass,
            FilterHelper.filter(
                result,
                kwargs
            ),
            context=self.context
        )

class UserRole(params.Role, Base):
    def __init__(self, user, role, context):
        Base.__init__(self, context)
        self.parentclass = user
        self.superclass  =  role

        self.permits = UserRolePermits(self, context)

    def __new__(cls, user, role, context):
        if role is None: return None
        obj = object.__new__(cls)
        obj.__init__(user, role, context)
        return obj

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def delete(self, async=None):
        '''
        [@param async: boolean (true|false)]

        @return None:
        '''

        url = UrlHelper.replace(
            '/users/{user:id}/roles/{role:id}',
            {
                '{user:id}': self.parentclass.get_id(),
                '{role:id}': self.get_id(),
            }
        )

        return self.__getProxy().delete(
            url=UrlHelper.appendParameters(
                url,
                {'async:matrix':async}
            ),
            headers={"Content-type":None}
        )

class UserRolePermit(params.Permit, Base):
    def __init__(self, userrole, permit, context):
        Base.__init__(self, context)
        self.parentclass = userrole
        self.superclass  =  permit

        #SUB_COLLECTIONS
    def __new__(cls, userrole, permit, context):
        if permit is None: return None
        obj = object.__new__(cls)
        obj.__init__(userrole, permit, context)
        return obj

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def delete(self, async=None, correlation_id=None):
        '''
        [@param async: boolean (true|false)]
        [@param correlation_id: any string]

        @return None:
        '''

        url = UrlHelper.replace(
            '/users/{user:id}/roles/{role:id}/permits/{permit:id}',
            {
                '{user:id}': self.parentclass.parentclass.get_id(),
                '{role:id}': self.parentclass.get_id(),
                '{permit:id}': self.get_id(),
            }
        )

        return self.__getProxy().delete(
            url=UrlHelper.appendParameters(
                url,
                {'async:matrix':async}
            ),
            headers={"Correlation-Id":correlation_id,"Content-type":None}
        )

class UserRolePermits(Base):

    def __init__(self, role , context):
        Base.__init__(self, context)
        self.parentclass = role

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def add(self, permit, correlation_id=None, expect=None):

        '''
        @type Permit:

        @param permit.id|name: string
        [@param correlation_id: any string]
        [@param expect: 201-created]

        @return Permit:
        '''

        url = '/users/{user:id}/roles/{role:id}/permits'

        result = self.__getProxy().add(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{user:id}': self.parentclass.parentclass.get_id(),
                        '{role:id}': self.parentclass.get_id(),
                    }
                ),
                args={}
            ),
            body=ParseHelper.toXml(permit),
            headers={"Correlation-Id":correlation_id, "Expect":expect}
        )

        return UserRolePermit(
            self.parentclass,
            result,
            self.context
        )

    def get(self, name=None, id=None):

        '''
        [@param id  : string (the id of the entity)]
        [@param name: string (the name of the entity)]

        @return Permits:
        '''

        url = '/users/{user:id}/roles/{role:id}/permits'

        if id:
            try :
                result = self.__getProxy().get(
                    url=UrlHelper.append(
                        UrlHelper.replace(
                            url,
                            {
                                '{user:id}': self.parentclass.parentclass.get_id(),
                                '{role:id}': self.parentclass.get_id(),
                            }
                        ),
                        id
                    ),
                    headers={}
                )

                return UserRolePermit(
                    self.parentclass,
                    result,
                    self.context
                )
            except RequestError as err:
                if err.status and err.status == 404:
                    return None
                raise err
        elif name:
            result = self.__getProxy().get(
                url=UrlHelper.replace(
                    url,
                    {
                        '{user:id}': self.parentclass.parentclass.get_id(),
                        '{role:id}': self.parentclass.get_id(),
                    }
                ),
                headers={}
            ).get_permit()

            return UserRolePermit(
                self.parentclass,
                FilterHelper.getItem(
                    FilterHelper.filter(
                        result,
                        {'name':name}
                    ),
                    query="name=" + name
                ),
                self.context
            )
        else:
            raise MissingParametersError(['id', 'name'])

    def list(self, max=None, **kwargs):
        '''
        [@param **kwargs: dict (property based filtering)"]
        [@param max: int (max results)]

        @return Permits:
        '''

        url = '/users/{user:id}/roles/{role:id}/permits'

        result = self.__getProxy().get(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{user:id}': self.parentclass.parentclass.get_id(),
                        '{role:id}': self.parentclass.get_id(),
                    }
                ),
                args={'max:matrix':max}
            ),
            headers={}
        ).get_permit()

        return ParseHelper.toSubCollection(
            UserRolePermit,
            self.parentclass,
            FilterHelper.filter(
                result,
                kwargs
            ),
            context=self.context
        )

class UserRoles(Base):

    def __init__(self, user , context):
        Base.__init__(self, context)
        self.parentclass = user

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def get(self, name=None, id=None):

        '''
        [@param id  : string (the id of the entity)]
        [@param name: string (the name of the entity)]

        @return Roles:
        '''

        url = '/users/{user:id}/roles'

        if id:
            try :
                result = self.__getProxy().get(
                    url=UrlHelper.append(
                        UrlHelper.replace(
                            url,
                            {
                                '{user:id}': self.parentclass.get_id(),
                            }
                        ),
                        id
                    ),
                    headers={}
                )

                return UserRole(
                    self.parentclass,
                    result,
                    self.context
                )
            except RequestError as err:
                if err.status and err.status == 404:
                    return None
                raise err
        elif name:
            result = self.__getProxy().get(
                url=UrlHelper.replace(
                    url,
                    {
                        '{user:id}': self.parentclass.get_id(),
                    }
                ),
                headers={}
            ).get_role()

            return UserRole(
                self.parentclass,
                FilterHelper.getItem(
                    FilterHelper.filter(
                        result,
                        {'name':name}
                    ),
                    query="name=" + name
                ),
                self.context
            )
        else:
            raise MissingParametersError(['id', 'name'])

    def list(self, max=None, **kwargs):
        '''
        [@param **kwargs: dict (property based filtering)"]
        [@param max: int (max results)]

        @return Roles:
        '''

        url = '/users/{user:id}/roles'

        result = self.__getProxy().get(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{user:id}': self.parentclass.get_id(),
                    }
                ),
                args={'max:matrix':max}
            ),
            headers={}
        ).get_role()

        return ParseHelper.toSubCollection(
            UserRole,
            self.parentclass,
            FilterHelper.filter(
                result,
                kwargs
            ),
            context=self.context
        )

class UserSSHPublicKey(params.SSHPublicKey, Base):
    def __init__(self, user, sshpublickey, context):
        Base.__init__(self, context)
        self.parentclass = user
        self.superclass  =  sshpublickey

        #SUB_COLLECTIONS
    def __new__(cls, user, sshpublickey, context):
        if sshpublickey is None: return None
        obj = object.__new__(cls)
        obj.__init__(user, sshpublickey, context)
        return obj

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def delete(self, async=None, correlation_id=None):
        '''
        [@param async: boolean (true|false)]
        [@param correlation_id: any string]

        @return None:
        '''

        url = UrlHelper.replace(
            '/users/{user:id}/sshpublickeys/{sshpublickey:id}',
            {
                '{user:id}': self.parentclass.get_id(),
                '{sshpublickey:id}': self.get_id(),
            }
        )

        return self.__getProxy().delete(
            url=UrlHelper.appendParameters(
                url,
                {'async:matrix':async}
            ),
            headers={"Correlation-Id":correlation_id,"Content-type":None}
        )

    def update(self, async=None):
        '''
        [@param async: boolean (true|false)]

        @return SSHPublicKey:
        '''

        url = '/users/{user:id}/sshpublickeys/{sshpublickey:id}'
        url = UrlHelper.replace(
            url,
            {
                '{user:id}': self.parentclass.get_id(),
                '{sshpublickey:id}': self.get_id(),
            }
        )

        result = self.__getProxy().update(
            url=UrlHelper.appendParameters(url, {'async:matrix':async}),
            body=ParseHelper.toXml(self.superclass),
            headers={}
        )

        return UserSSHPublicKey(
            self.parentclass,
            result,
            self.context
        )

class UserSSHPublicKeys(Base):

    def __init__(self, user , context):
        Base.__init__(self, context)
        self.parentclass = user

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def add(self, sshpublickey, correlation_id=None, expect=None):

        '''
        @type SSHPublicKey:

        @param ssh_public_key.id|name: string
        [@param correlation_id: any string]
        [@param expect: 201-created]

        @return SSHPublicKey:
        '''

        url = '/users/{user:id}/sshpublickeys'

        result = self.__getProxy().add(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{user:id}': self.parentclass.get_id(),
                    }
                ),
                args={}
            ),
            body=ParseHelper.toXml(sshpublickey),
            headers={"Correlation-Id":correlation_id, "Expect":expect}
        )

        return UserSSHPublicKey(
            self.parentclass,
            result,
            self.context
        )

    def get(self, name=None, id=None):

        '''
        [@param id  : string (the id of the entity)]
        [@param name: string (the name of the entity)]

        @return SSHPublicKeys:
        '''

        url = '/users/{user:id}/sshpublickeys'

        if id:
            try :
                result = self.__getProxy().get(
                    url=UrlHelper.append(
                        UrlHelper.replace(
                            url,
                            {
                                '{user:id}': self.parentclass.get_id(),
                            }
                        ),
                        id
                    ),
                    headers={}
                )

                return UserSSHPublicKey(
                    self.parentclass,
                    result,
                    self.context
                )
            except RequestError as err:
                if err.status and err.status == 404:
                    return None
                raise err
        elif name:
            result = self.__getProxy().get(
                url=UrlHelper.replace(
                    url,
                    {
                        '{user:id}': self.parentclass.get_id(),
                    }
                ),
                headers={}
            ).get_ssh_public_key()

            return UserSSHPublicKey(
                self.parentclass,
                FilterHelper.getItem(
                    FilterHelper.filter(
                        result,
                        {'name':name}
                    ),
                    query="name=" + name
                ),
                self.context
            )
        else:
            raise MissingParametersError(['id', 'name'])

    def list(self, max=None, **kwargs):
        '''
        [@param **kwargs: dict (property based filtering)"]
        [@param max: int (max results)]

        @return SSHPublicKeys:
        '''

        url = '/users/{user:id}/sshpublickeys'

        result = self.__getProxy().get(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{user:id}': self.parentclass.get_id(),
                    }
                ),
                args={'max:matrix':max}
            ),
            headers={}
        ).get_ssh_public_key()

        return ParseHelper.toSubCollection(
            UserSSHPublicKey,
            self.parentclass,
            FilterHelper.filter(
                result,
                kwargs
            ),
            context=self.context
        )

class UserTag(params.Tag, Base):
    def __init__(self, user, tag, context):
        Base.__init__(self, context)
        self.parentclass = user
        self.superclass  =  tag

        #SUB_COLLECTIONS
    def __new__(cls, user, tag, context):
        if tag is None: return None
        obj = object.__new__(cls)
        obj.__init__(user, tag, context)
        return obj

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def delete(self, async=None, correlation_id=None):
        '''
        [@param async: boolean (true|false)]
        [@param correlation_id: any string]

        @return None:
        '''

        url = UrlHelper.replace(
            '/users/{user:id}/tags/{tag:id}',
            {
                '{user:id}': self.parentclass.get_id(),
                '{tag:id}': self.get_id(),
            }
        )

        return self.__getProxy().delete(
            url=UrlHelper.appendParameters(
                url,
                {'async:matrix':async}
            ),
            headers={"Correlation-Id":correlation_id,"Content-type":None}
        )

class UserTags(Base):

    def __init__(self, user , context):
        Base.__init__(self, context)
        self.parentclass = user

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def add(self, tag, correlation_id=None, expect=None):

        '''
        @type Tag:

        @param tag.id|name: string
        [@param correlation_id: any string]
        [@param expect: 201-created]

        @return Tag:
        '''

        url = '/users/{user:id}/tags'

        result = self.__getProxy().add(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{user:id}': self.parentclass.get_id(),
                    }
                ),
                args={}
            ),
            body=ParseHelper.toXml(tag),
            headers={"Correlation-Id":correlation_id, "Expect":expect}
        )

        return UserTag(
            self.parentclass,
            result,
            self.context
        )

    def get(self, name=None, id=None):

        '''
        [@param id  : string (the id of the entity)]
        [@param name: string (the name of the entity)]

        @return Tags:
        '''

        url = '/users/{user:id}/tags'

        if id:
            try :
                result = self.__getProxy().get(
                    url=UrlHelper.append(
                        UrlHelper.replace(
                            url,
                            {
                                '{user:id}': self.parentclass.get_id(),
                            }
                        ),
                        id
                    ),
                    headers={}
                )

                return UserTag(
                    self.parentclass,
                    result,
                    self.context
                )
            except RequestError as err:
                if err.status and err.status == 404:
                    return None
                raise err
        elif name:
            result = self.__getProxy().get(
                url=UrlHelper.replace(
                    url,
                    {
                        '{user:id}': self.parentclass.get_id(),
                    }
                ),
                headers={}
            ).get_tag()

            return UserTag(
                self.parentclass,
                FilterHelper.getItem(
                    FilterHelper.filter(
                        result,
                        {'name':name}
                    ),
                    query="name=" + name
                ),
                self.context
            )
        else:
            raise MissingParametersError(['id', 'name'])

    def list(self, max=None, **kwargs):
        '''
        [@param **kwargs: dict (property based filtering)"]
        [@param max: int (max results)]

        @return Tags:
        '''

        url = '/users/{user:id}/tags'

        result = self.__getProxy().get(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{user:id}': self.parentclass.get_id(),
                    }
                ),
                args={'max:matrix':max}
            ),
            headers={}
        ).get_tag()

        return ParseHelper.toSubCollection(
            UserTag,
            self.parentclass,
            FilterHelper.filter(
                result,
                kwargs
            ),
            context=self.context
        )

class Users(Base):
    def __init__(self, context):
        Base.__init__(self, context)

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def add(self, user, correlation_id=None, expect=None):
        '''
        @type User:

        @param user.user_name: string
        @param user.domain.id|name: string
        [@param user.namespace: string]
        [@param user.principal: string]
        [@param correlation_id: any string]
        [@param expect: 201-created]

        @return User:
        '''

        url = '/users'

        result = self.__getProxy().add(
           url=UrlHelper.appendParameters(
                url=url,
                args={}
           ),
           body=ParseHelper.toXml(user),
           headers={"Correlation-Id":correlation_id, "Expect":expect}
        )

        return User(result, self.context)

    def get(self, name=None, id=None):
        '''
        [@param id  : string (the id of the entity)]
        [@param name: string (the name of the entity)]

        @return Users:
        '''

        url = '/users'

        if id:
            try :
                return User(
                    self.__getProxy().get(
                        url=UrlHelper.append(url, id),
                        headers={}
                    ),
                    self.context
                )
            except RequestError as err:
                if err.status and err.status == 404:
                    return None
                raise err
        elif name:
            result = self.__getProxy().get(
                url=UrlHelper.appendParameters(url, {'search:query':'name='+name}),
                headers={}
            ).get_user()

            return User(
                FilterHelper.getItem(
                    FilterHelper.filter(result, {'name':name}),
                    query="name=" + name
                ),
                self.context
            )
        else:
            raise MissingParametersError(['id', 'name'])

    def list(self, query=None, case_sensitive=True, max=None, **kwargs):
        '''
        [@param **kwargs: dict (property based filtering)]
        [@param query: string (oVirt engine search dialect query)]
        [@param case_sensitive: boolean (true|false)]
        [@param max: int (max results)]

        @return Users:
        '''

        url='/users'

        result = self.__getProxy().get(
            url=UrlHelper.appendParameters(url, {'search:query':query,'case_sensitive:matrix':case_sensitive,'max:matrix':max}),
            headers={}
        ).get_user()

        return ParseHelper.toCollection(
            User,
            FilterHelper.filter(result, kwargs),
            context=self.context
        )

class VM(params.VM, Base):
    def __init__(self, vm, context):
        Base.__init__(self, context)
        self.superclass = vm

        self.applications = VMApplications(self, context)
        self.cdroms = VMCdRoms(self, context)
        self.disks = VMDisks(self, context)
        self.graphicsconsoles = VMGraphicsConsoles(self, context)
        self.hostdevices = VMHostDevices(self, context)
        self.katelloerrata = VMKatelloErrata(self, context)
        self.nics = VMNICs(self, context)
        self.numanodes = VMVirtualNumaNodes(self, context)
        self.permissions = VMPermissions(self, context)
        self.reporteddevices = VMReportedDevices(self, context)
        self.sessions = VMSessions(self, context)
        self.snapshots = VMSnapshots(self, context)
        self.statistics = VMStatistics(self, context)
        self.tags = VMTags(self, context)
        self.watchdogs = VMWatchDogs(self, context)

    def __new__(cls, vm, context):
        if vm is None: return None
        obj = object.__new__(cls)
        obj.__init__(vm, context)
        return obj

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def delete(self, action=params.Action(), async=None, correlation_id=None):
        '''
        @type Action:

        [@param action.force: boolean]
        [@param action.vm.disks.detach_only: boolean]
        [@param action.async: boolean]
        [@param action.grace_period.expiry: long]
        [@param correlation_id: any string]

        @return None:
        '''

        url = UrlHelper.replace(
            '/vms/{vm:id}',
            {
                '{vm:id}': self.get_id(),
            }
        )

        return self.__getProxy().delete(
            url=UrlHelper.appendParameters(
                url,
                {'async:matrix':async}
            ),
            body=ParseHelper.toXml(action),
            headers={"Correlation-Id":correlation_id}
        )

    def update(self, correlation_id=None, expect=None):
        '''
        [@param vm.instance_type.id|name: string]
        [@param vm.name: string]
        [@param vm.cluster.id|name: string]
        [@param vm.timezone: string]
        [@param vm.time_zone.name: string]
        [@param vm.os.boot: collection]
        {
          [@ivar boot.dev: string]
        }
        [@param vm.custom_properties.custom_property: collection]
        {
          [@ivar custom_property.name: string]
          [@ivar custom_property.value: string]
        }
        [@param vm.os.type: string]
        [@param vm.usb.enabled: boolean]
        [@param vm.usb.type: string]
        [@param vm.type: string]
        [@param vm.os.initRd: string]
        [@param vm.display.monitors: int]
        [@param vm.display.single_qxl_pci: boolean]
        [@param vm.display.type: string]
        [@param vm.display.allow_override: boolean]
        [@param vm.display.smartcard_enabled: boolean]
        [@param vm.display.file_transfer_enabled: boolean]
        [@param vm.display.copy_paste_enabled: boolean]
        [@param vm.display.keyboard_layout: string]
        [@param vm.os.cmdline: string]
        [@param vm.cpu.mode: string]
        [@param vm.cpu.architecture: string]
        [@param vm.cpu.topology.cores: int]
        [@param vm.cpu.topology.threads: int]
        [@param vm.cpu_shares: int]
        [@param vm.memory: long]
        [@param vm.io.threads: int]
        [@param vm.memory_policy.guaranteed: long]
        [@param vm.memory_policy.ballooning: boolean]
        [@param vm.high_availability.priority: int]
        [@param vm.high_availability.enabled: boolean]
        [@param vm.domain.name: string]
        [@param vm.description: string]
        [@param vm.comment: string]
        [@param vm.stateless: boolean]
        [@param vm.delete_protected: boolean]
        [@param vm.sso.methods.method: collection]
        {
          [@ivar method.id: string]
        }
        [@param vm.rng_device.rate.bytes: int]
        [@param vm.rng_device.rate.period: int]
        [@param vm.rng_device.source: string]
        [@param vm.console.enabled: boolean]
        [@param vm.cpu.topology.sockets: int]
        [@param vm.placement_policy.affinity: string]
        [@param vm.placement_policy.host.id|name: string]
        [@param vm.origin: string]
        [@param vm.os.kernel: string]
        [@param vm.tunnel_migration: boolean]
        [@param vm.migration_downtime: int]
        [@param vm.virtio_scsi.enabled: boolean]
        [@param vm.soundcard_enabled: boolean]
        [@param vm.custom_emulated_machine: string]
        [@param vm.custom_cpu_model: string]
        [@param vm.use_latest_template_version: boolean]
        [@param vm.payloads.payload: collection]
        {
          [@ivar payload.type: string]
          [@ivar payload.volume_id: string]
          [@ivar payload.files.file: collection]
          {
            [@param file.name: string]
            [@param file.content: string]
          }
        }
        [@param vm.cpu.cpu_tune.vcpu_pin: collection]
        {
          [@ivar vcpu_pin.vcpu: int]
          [@ivar vcpu_pin.cpu_set: string]
        }
        [@param vm.serial_number.policy: string]
        [@param vm.serial_number.value: string]
        [@param vm.bios.boot_menu.enabled: boolean]
        [@param vm.numa_tune_mode: string]
        [@param vm.start_paused: boolean]
        [@param vm.cpu_profile.id: string]
        [@param vm.migration.auto_converge: string]
        [@param vm.migration.compressed: string]
        [@param vm.external_host_provider.id: string]
        [@param vm.small_icon.id: string]
        [@param vm.large_icon.id: string]
        [@param vm.large_icon.media_type: string]
        [@param vm.large_icon.data: string]
        [@param correlation_id: any string]
        [@param expect: 202-accepted]

        @return VM:
        '''

        url = '/vms/{vm:id}'

        result = self.__getProxy().update(
            url=UrlHelper.replace(
                url,
                {
                    '{vm:id}': self.get_id(),
                }
            ),
            body=ParseHelper.toXml(self.superclass),
            headers={"Correlation-Id":correlation_id, "Expect":expect}
        )

        return VM(result, self.context)

    def cancelmigration(self, action=params.Action()):
        '''
        @type Action:


        @return Action:
        '''

        url = '/vms/{vm:id}/cancelmigration'

        result = self.__getProxy().request(
            method='POST',
            url=UrlHelper.replace(
                url,
                {
                    '{vm:id}': self.get_id(),
                }
            ),
            body=ParseHelper.toXml(action),
            headers={}
        )

        return result

    def clone(self, action=params.Action(), correlation_id=None):
        '''
        @type Action:

        @param action.vm.name: string
        [@param action.async: boolean]
        [@param action.grace_period.expiry: long]
        [@param correlation_id: any string]

        @return Action:
        '''

        url = '/vms/{vm:id}/clone'

        result = self.__getProxy().request(
            method='POST',
            url=UrlHelper.replace(
                url,
                {
                    '{vm:id}': self.get_id(),
                }
            ),
            body=ParseHelper.toXml(action),
            headers={"Correlation-Id":correlation_id}
        )

        return result

    def commit_snapshot(self, action=params.Action(), correlation_id=None):
        '''
        @type Action:

        [@param correlation_id: any string]

        @return Action:
        '''

        url = '/vms/{vm:id}/commit_snapshot'

        result = self.__getProxy().request(
            method='POST',
            url=UrlHelper.replace(
                url,
                {
                    '{vm:id}': self.get_id(),
                }
            ),
            body=ParseHelper.toXml(action),
            headers={"Correlation-Id":correlation_id}
        )

        return result

    def detach(self, action=params.Action(), correlation_id=None):
        '''
        @type Action:

        [@param action.async: boolean]
        [@param action.grace_period.expiry: long]
        [@param correlation_id: any string]

        @return Action:
        '''

        url = '/vms/{vm:id}/detach'

        result = self.__getProxy().request(
            method='POST',
            url=UrlHelper.replace(
                url,
                {
                    '{vm:id}': self.get_id(),
                }
            ),
            body=ParseHelper.toXml(action),
            headers={"Correlation-Id":correlation_id}
        )

        return result

    def export(self, action=params.Action(), correlation_id=None):
        '''
        @type Action:

        [@param action.exclusive: boolean]
        [@param action.discard_snapshots: boolean]
        [@param action.storage_domain.id|name: string]
        [@param action.async: boolean]
        [@param action.grace_period.expiry: long]
        [@param correlation_id: any string]

        @return Action:
        '''

        url = '/vms/{vm:id}/export'

        result = self.__getProxy().request(
            method='POST',
            url=UrlHelper.replace(
                url,
                {
                    '{vm:id}': self.get_id(),
                }
            ),
            body=ParseHelper.toXml(action),
            headers={"Correlation-Id":correlation_id}
        )

        return result

    def freezefilesystems(self, action=params.Action(), correlation_id=None):
        '''
        @type Action:

        [@param action.async: boolean]
        [@param action.grace_period.expiry: long]
        [@param correlation_id: any string]

        @return Action:
        '''

        url = '/vms/{vm:id}/freezefilesystems'

        result = self.__getProxy().request(
            method='POST',
            url=UrlHelper.replace(
                url,
                {
                    '{vm:id}': self.get_id(),
                }
            ),
            body=ParseHelper.toXml(action),
            headers={"Correlation-Id":correlation_id}
        )

        return result

    def logon(self, action=params.Action(), correlation_id=None):
        '''
        @type Action:

        [@param action.async: boolean]
        [@param action.grace_period.expiry: long]
        [@param correlation_id: any string]

        @return Action:
        '''

        url = '/vms/{vm:id}/logon'

        result = self.__getProxy().request(
            method='POST',
            url=UrlHelper.replace(
                url,
                {
                    '{vm:id}': self.get_id(),
                }
            ),
            body=ParseHelper.toXml(action),
            headers={"Correlation-Id":correlation_id}
        )

        return result

    def maintenance(self, action=params.Action(), correlation_id=None):
        '''
        @type Action:

        @param action.maintenance_enabled: boolean
        [@param action.async: boolean]
        [@param action.grace_period.expiry: long]
        [@param correlation_id: any string]

        @return Action:
        '''

        url = '/vms/{vm:id}/maintenance'

        result = self.__getProxy().request(
            method='POST',
            url=UrlHelper.replace(
                url,
                {
                    '{vm:id}': self.get_id(),
                }
            ),
            body=ParseHelper.toXml(action),
            headers={"Correlation-Id":correlation_id}
        )

        return result

    def migrate(self, action=params.Action(), correlation_id=None):
        '''
        @type Action:

        [@param action.host.id|name: string]
        [@param action.force: boolean]
        [@param action.cluster.id: string]
        [@param action.async: boolean]
        [@param action.grace_period.expiry: long]
        [@param correlation_id: any string]

        @return Action:
        '''

        url = '/vms/{vm:id}/migrate'

        result = self.__getProxy().request(
            method='POST',
            url=UrlHelper.replace(
                url,
                {
                    '{vm:id}': self.get_id(),
                }
            ),
            body=ParseHelper.toXml(action),
            headers={"Correlation-Id":correlation_id}
        )

        return result

    def move(self, action=params.Action(), correlation_id=None):
        '''
        @type Action:

        @param action.storage_domain.id|name: string
        [@param action.async: boolean]
        [@param action.grace_period.expiry: long]
        [@param correlation_id: any string]

        @return Action:
        '''

        url = '/vms/{vm:id}/move'

        result = self.__getProxy().request(
            method='POST',
            url=UrlHelper.replace(
                url,
                {
                    '{vm:id}': self.get_id(),
                }
            ),
            body=ParseHelper.toXml(action),
            headers={"Correlation-Id":correlation_id}
        )

        return result

    def preview_snapshot(self, action=params.Action(), correlation_id=None):
        '''
        @type Action:

        @param action.snapshot.id: string
        [@param action.restore_memory: boolean]
        [@param action.disks.disk: collection]
        {
          [@ivar disk.id: string]
          [@ivar disk.image_id: string]
          [@ivar disk.snapshot.id: string]
        }
        [@param action.async: boolean]
        [@param action.grace_period.expiry: long]
        [@param correlation_id: any string]

        @return Action:
        '''

        url = '/vms/{vm:id}/preview_snapshot'

        result = self.__getProxy().request(
            method='POST',
            url=UrlHelper.replace(
                url,
                {
                    '{vm:id}': self.get_id(),
                }
            ),
            body=ParseHelper.toXml(action),
            headers={"Correlation-Id":correlation_id}
        )

        return result

    def reboot(self, action=params.Action(), correlation_id=None):
        '''
        @type Action:

        [@param correlation_id: any string]

        @return Action:
        '''

        url = '/vms/{vm:id}/reboot'

        result = self.__getProxy().request(
            method='POST',
            url=UrlHelper.replace(
                url,
                {
                    '{vm:id}': self.get_id(),
                }
            ),
            body=ParseHelper.toXml(action),
            headers={"Correlation-Id":correlation_id}
        )

        return result

    def reordermacaddresses(self, action=params.Action(), correlation_id=None):
        '''
        @type Action:

        [@param correlation_id: any string]

        @return Action:
        '''

        url = '/vms/{vm:id}/reordermacaddresses'

        result = self.__getProxy().request(
            method='POST',
            url=UrlHelper.replace(
                url,
                {
                    '{vm:id}': self.get_id(),
                }
            ),
            body=ParseHelper.toXml(action),
            headers={"Correlation-Id":correlation_id}
        )

        return result

    def shutdown(self, action=params.Action(), correlation_id=None):
        '''
        @type Action:

        [@param action.async: boolean]
        [@param action.grace_period.expiry: long]
        [@param correlation_id: any string]

        @return Action:
        '''

        url = '/vms/{vm:id}/shutdown'

        result = self.__getProxy().request(
            method='POST',
            url=UrlHelper.replace(
                url,
                {
                    '{vm:id}': self.get_id(),
                }
            ),
            body=ParseHelper.toXml(action),
            headers={"Correlation-Id":correlation_id}
        )

        return result

    def start(self, action=params.Action(), correlation_id=None):
        '''
        @type Action:

        [@param action.vm.os.initRd: string]
        [@param action.vm.domain.name: string]
        [@param action.vm.placement_policy.host.id|name: string]
        [@param action.vm.placement_policy.affinity: string]
        [@param action.vm.os.kernel: string]
        [@param action.vm.display.type: string]
        [@param action.vm.stateless: boolean]
        [@param action.vm.os.cmdline: string]
        [@param action.vm.domain.user.username: string]
        [@param action.pause: boolean]
        [@param action.vm.os.boot: collection]
        {
          [@ivar boot.dev: string]
        }
        [@param action.vm.domain.user.password: string]
        [@param action.vm.initialization.cloud_init.host.address: string]
        [@param action.vm.custom_emulated_machine: string]
        [@param action.vm.custom_cpu_model: string]
        [@param action.vm.initialization.cloud_init.network_configuration.nics.nic: collection]
        {
          [@ivar nic.name: string]
          [@ivar nic.boot_protocol: string]
          [@ivar nic.network.address.ip: string]
          [@ivar nic.network.address.netmask: string]
          [@ivar nic.network.address.gateway: string]
          [@ivar nic.onboot: boolean]
        }
        [@param action.vm.initialization.cloud_init.network_configuration.dns.servers.host: collection]
        {
          [@ivar host.address: string]
        }
        [@param action.vm.initialization.cloud_init.network_configuration.dns.search_domains.host: collection]
        {
          [@ivar host.address: string]
        }
        [@param action.vm.initialization.cloud_init.authorized_keys.authorized_key: collection]
        {
          [@ivar authorized_key.key: string]
        }
        [@param authorized_key.user.name: string]
        [@param action.vm.initialization.cloud_init.regenerate_ssh_keys: boolean]
        [@param action.vm.initialization.cloud_init.timezone: string]
        [@param action.vm.initialization.cloud_init.users.user: collection]
        {
          [@ivar user.password: string]
          [@ivar user.name: string]
        }
        [@param action.vm.initialization.cloud_init.payload_files.payload_file: collection]
        {
          [@ivar payload_file.name: string]
          [@ivar payload_file.content: string]
          [@ivar payload_file.type: string]
        }
        [@param action.use_sysprep: boolean]
        [@param action.use_cloud_init: boolean]
        [@param action.async: boolean]
        [@param action.grace_period.expiry: long]
        [@param correlation_id: any string]

        @return Action:
        '''

        url = '/vms/{vm:id}/start'

        result = self.__getProxy().request(
            method='POST',
            url=UrlHelper.replace(
                url,
                {
                    '{vm:id}': self.get_id(),
                }
            ),
            body=ParseHelper.toXml(action),
            headers={"Correlation-Id":correlation_id}
        )

        return result

    def stop(self, action=params.Action(), correlation_id=None):
        '''
        @type Action:

        [@param action.async: boolean]
        [@param action.grace_period.expiry: long]
        [@param correlation_id: any string]

        @return Action:
        '''

        url = '/vms/{vm:id}/stop'

        result = self.__getProxy().request(
            method='POST',
            url=UrlHelper.replace(
                url,
                {
                    '{vm:id}': self.get_id(),
                }
            ),
            body=ParseHelper.toXml(action),
            headers={"Correlation-Id":correlation_id}
        )

        return result

    def suspend(self, action=params.Action(), correlation_id=None):
        '''
        @type Action:

        [@param action.async: boolean]
        [@param action.grace_period.expiry: long]
        [@param correlation_id: any string]

        @return Action:
        '''

        url = '/vms/{vm:id}/suspend'

        result = self.__getProxy().request(
            method='POST',
            url=UrlHelper.replace(
                url,
                {
                    '{vm:id}': self.get_id(),
                }
            ),
            body=ParseHelper.toXml(action),
            headers={"Correlation-Id":correlation_id}
        )

        return result

    def thawfilesystems(self, action=params.Action(), correlation_id=None):
        '''
        @type Action:

        [@param action.async: boolean]
        [@param action.grace_period.expiry: long]
        [@param correlation_id: any string]

        @return Action:
        '''

        url = '/vms/{vm:id}/thawfilesystems'

        result = self.__getProxy().request(
            method='POST',
            url=UrlHelper.replace(
                url,
                {
                    '{vm:id}': self.get_id(),
                }
            ),
            body=ParseHelper.toXml(action),
            headers={"Correlation-Id":correlation_id}
        )

        return result

    def ticket(self, action=params.Action(), correlation_id=None):
        '''
        @type Action:

        [@param action.ticket.value: string]
        [@param action.async: boolean]
        [@param action.grace_period.expiry: long]
        [@param correlation_id: any string]

        @return Action:
        '''

        url = '/vms/{vm:id}/ticket'

        result = self.__getProxy().request(
            method='POST',
            url=UrlHelper.replace(
                url,
                {
                    '{vm:id}': self.get_id(),
                }
            ),
            body=ParseHelper.toXml(action),
            headers={"Correlation-Id":correlation_id}
        )

        return result

    def undo_snapshot(self, action=params.Action(), correlation_id=None):
        '''
        @type Action:

        [@param correlation_id: any string]

        @return Action:
        '''

        url = '/vms/{vm:id}/undo_snapshot'

        result = self.__getProxy().request(
            method='POST',
            url=UrlHelper.replace(
                url,
                {
                    '{vm:id}': self.get_id(),
                }
            ),
            body=ParseHelper.toXml(action),
            headers={"Correlation-Id":correlation_id}
        )

        return result

class VMApplication(params.Application, Base):
    def __init__(self, vm, application, context):
        Base.__init__(self, context)
        self.parentclass = vm
        self.superclass  =  application

        #SUB_COLLECTIONS
    def __new__(cls, vm, application, context):
        if application is None: return None
        obj = object.__new__(cls)
        obj.__init__(vm, application, context)
        return obj

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

class VMApplications(Base):

    def __init__(self, vm , context):
        Base.__init__(self, context)
        self.parentclass = vm

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def get(self, name=None, id=None):

        '''
        [@param id  : string (the id of the entity)]
        [@param name: string (the name of the entity)]

        @return Applications:
        '''

        url = '/vms/{vm:id}/applications'

        if id:
            try :
                result = self.__getProxy().get(
                    url=UrlHelper.append(
                        UrlHelper.replace(
                            url,
                            {
                                '{vm:id}': self.parentclass.get_id(),
                            }
                        ),
                        id
                    ),
                    headers={}
                )

                return VMApplication(
                    self.parentclass,
                    result,
                    self.context
                )
            except RequestError as err:
                if err.status and err.status == 404:
                    return None
                raise err
        elif name:
            result = self.__getProxy().get(
                url=UrlHelper.replace(
                    url,
                    {
                        '{vm:id}': self.parentclass.get_id(),
                    }
                ),
                headers={}
            ).get_application()

            return VMApplication(
                self.parentclass,
                FilterHelper.getItem(
                    FilterHelper.filter(
                        result,
                        {'name':name}
                    ),
                    query="name=" + name
                ),
                self.context
            )
        else:
            raise MissingParametersError(['id', 'name'])

    def list(self, max=None, **kwargs):
        '''
        [@param **kwargs: dict (property based filtering)"]
        [@param max: int (max results)]

        @return Applications:
        '''

        url = '/vms/{vm:id}/applications'

        result = self.__getProxy().get(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{vm:id}': self.parentclass.get_id(),
                    }
                ),
                args={'max:matrix':max}
            ),
            headers={}
        ).get_application()

        return ParseHelper.toSubCollection(
            VMApplication,
            self.parentclass,
            FilterHelper.filter(
                result,
                kwargs
            ),
            context=self.context
        )

class VMCdRom(params.CdRom, Base):
    def __init__(self, vm, cdrom, context):
        Base.__init__(self, context)
        self.parentclass = vm
        self.superclass  =  cdrom

        #SUB_COLLECTIONS
    def __new__(cls, vm, cdrom, context):
        if cdrom is None: return None
        obj = object.__new__(cls)
        obj.__init__(vm, cdrom, context)
        return obj

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def update(self, current=None, async=None, correlation_id=None, expect=None):
        '''
        [@param cdrom.file.id: string]
        [@param current: boolean (true|false)]
        [@param async: boolean (true|false)]
        [@param correlation_id: any string]
        [@param expect: 202-accepted]

        @return CdRom:
        '''

        url = '/vms/{vm:id}/cdroms/{cdrom:id}'
        url = UrlHelper.replace(
            url,
            {
                '{vm:id}': self.parentclass.get_id(),
                '{cdrom:id}': self.get_id(),
            }
        )

        result = self.__getProxy().update(
            url=UrlHelper.appendParameters(url, {'current:matrix':current,'async:matrix':async}),
            body=ParseHelper.toXml(self.superclass),
            headers={"Correlation-Id":correlation_id, "Expect":expect}
        )

        return VMCdRom(
            self.parentclass,
            result,
            self.context
        )

class VMCdRoms(Base):

    def __init__(self, vm , context):
        Base.__init__(self, context)
        self.parentclass = vm

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def add(self, cdrom, correlation_id=None, expect=None):

        '''
        @type CdRom:

        @param cdrom.file.id: string
        [@param correlation_id: any string]
        [@param expect: 201-created]

        @return CdRom:
        '''

        url = '/vms/{vm:id}/cdroms'

        result = self.__getProxy().add(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{vm:id}': self.parentclass.get_id(),
                    }
                ),
                args={}
            ),
            body=ParseHelper.toXml(cdrom),
            headers={"Correlation-Id":correlation_id, "Expect":expect}
        )

        return VMCdRom(
            self.parentclass,
            result,
            self.context
        )

    def get(self, name=None, id=None):

        '''
        [@param id  : string (the id of the entity)]
        [@param name: string (the name of the entity)]

        @return CdRoms:
        '''

        url = '/vms/{vm:id}/cdroms'

        if id:
            try :
                result = self.__getProxy().get(
                    url=UrlHelper.append(
                        UrlHelper.replace(
                            url,
                            {
                                '{vm:id}': self.parentclass.get_id(),
                            }
                        ),
                        id
                    ),
                    headers={}
                )

                return VMCdRom(
                    self.parentclass,
                    result,
                    self.context
                )
            except RequestError as err:
                if err.status and err.status == 404:
                    return None
                raise err
        elif name:
            result = self.__getProxy().get(
                url=UrlHelper.replace(
                    url,
                    {
                        '{vm:id}': self.parentclass.get_id(),
                    }
                ),
                headers={}
            ).get_cdrom()

            return VMCdRom(
                self.parentclass,
                FilterHelper.getItem(
                    FilterHelper.filter(
                        result,
                        {'name':name}
                    ),
                    query="name=" + name
                ),
                self.context
            )
        else:
            raise MissingParametersError(['id', 'name'])

    def list(self, current=None, max=None, **kwargs):
        '''
        [@param **kwargs: dict (property based filtering)"]
        [@param current: boolean (true|false)]
        [@param max: int (max results)]

        @return CdRoms:
        '''

        url = '/vms/{vm:id}/cdroms'

        result = self.__getProxy().get(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{vm:id}': self.parentclass.get_id(),
                    }
                ),
                args={'current:matrix':current,'max:matrix':max}
            ),
            headers={}
        ).get_cdrom()

        return ParseHelper.toSubCollection(
            VMCdRom,
            self.parentclass,
            FilterHelper.filter(
                result,
                kwargs
            ),
            context=self.context
        )

class VMDisk(params.Disk, Base):
    def __init__(self, vm, disk, context):
        Base.__init__(self, context)
        self.parentclass = vm
        self.superclass  =  disk

        self.permissions = VMDiskPermissions(self, context)
        self.statistics = VMDiskStatistics(self, context)

    def __new__(cls, vm, disk, context):
        if disk is None: return None
        obj = object.__new__(cls)
        obj.__init__(vm, disk, context)
        return obj

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def delete(self, action=params.Action(), async=None, correlation_id=None):
        '''
        @type Action:

        @param action.detach: boolean
        [@param action.async: boolean]
        [@param action.grace_period.expiry: long]
        [@param correlation_id: any string]

        @return None:
        '''

        url = UrlHelper.replace(
            '/vms/{vm:id}/disks/{disk:id}',
            {
                '{vm:id}': self.parentclass.get_id(),
                '{disk:id}': self.get_id(),
            }
        )

        return self.__getProxy().delete(
            url=UrlHelper.appendParameters(
                url,
                {'async:matrix':async}
            ),
            body=ParseHelper.toXml(action),
            headers={"Correlation-Id":correlation_id}
        )

    def update(self, async=None, correlation_id=None, expect=None):
        '''
        [@param disk.size: int]
        [@param disk.provisioned_size: int]
        [@param disk.name: string]
        [@param disk.alias: string]
        [@param disk.interface: string]
        [@param disk.format: string]
        [@param disk.sparse: boolean]
        [@param disk.description: string]
        [@param disk.bootable: boolean]
        [@param disk.shareable: boolean]
        [@param disk.propagate_errors: boolean]
        [@param disk.wipe_after_delete: boolean]
        [@param disk.quota.id: string]
        [@param disk.disk_profile.id: string]
        [@param disk.sgio: string]
        [@param disk.uses_scsi_reservation: boolean]
        [@param disk.read_only: boolean]
        [@param async: boolean (true|false)]
        [@param correlation_id: any string]
        [@param expect: 202-accepted]

        @return Disk:
        '''

        url = '/vms/{vm:id}/disks/{disk:id}'
        url = UrlHelper.replace(
            url,
            {
                '{vm:id}': self.parentclass.get_id(),
                '{disk:id}': self.get_id(),
            }
        )

        result = self.__getProxy().update(
            url=UrlHelper.appendParameters(url, {'async:matrix':async}),
            body=ParseHelper.toXml(self.superclass),
            headers={"Correlation-Id":correlation_id, "Expect":expect}
        )

        return VMDisk(
            self.parentclass,
            result,
            self.context
        )

    def activate(self, action=params.Action(), correlation_id=None):
        '''
        @type Action:

        [@param action.async: boolean]
        [@param action.grace_period.expiry: long]
        [@param correlation_id: any string]

        @return Action:
        '''

        url = '/vms/{vm:id}/disks/{disk:id}/activate'

        result = self.__getProxy().request(
            method='POST',
            url=UrlHelper.replace(
                url,
                {
                    '{vm:id}': self.parentclass.get_id(),
                    '{disk:id}': self.get_id(),
                }
            ),
            body=ParseHelper.toXml(action),
            headers={"Correlation-Id":correlation_id}
        )

        return result

    def deactivate(self, action=params.Action(), correlation_id=None):
        '''
        @type Action:

        [@param action.async: boolean]
        [@param action.grace_period.expiry: long]
        [@param correlation_id: any string]

        @return Action:
        '''

        url = '/vms/{vm:id}/disks/{disk:id}/deactivate'

        result = self.__getProxy().request(
            method='POST',
            url=UrlHelper.replace(
                url,
                {
                    '{vm:id}': self.parentclass.get_id(),
                    '{disk:id}': self.get_id(),
                }
            ),
            body=ParseHelper.toXml(action),
            headers={"Correlation-Id":correlation_id}
        )

        return result

    def export(self, action=params.Action(), correlation_id=None):
        '''
        @type Action:

        @param storagedomain.id|name: string
        [@param action.async: boolean]
        [@param action.grace_period.expiry: long]
        [@param correlation_id: any string]

        @return Action:
        '''

        url = '/vms/{vm:id}/disks/{disk:id}/export'

        result = self.__getProxy().request(
            method='POST',
            url=UrlHelper.replace(
                url,
                {
                    '{vm:id}': self.parentclass.get_id(),
                    '{disk:id}': self.get_id(),
                }
            ),
            body=ParseHelper.toXml(action),
            headers={"Correlation-Id":correlation_id}
        )

        return result

    def move(self, action=params.Action(), correlation_id=None):
        '''
        @type Action:

        @param storagedomain.id|name: string
        [@param action.async: boolean]
        [@param action.grace_period.expiry: long]
        [@param correlation_id: any string]

        @return Action:
        '''

        url = '/vms/{vm:id}/disks/{disk:id}/move'

        result = self.__getProxy().request(
            method='POST',
            url=UrlHelper.replace(
                url,
                {
                    '{vm:id}': self.parentclass.get_id(),
                    '{disk:id}': self.get_id(),
                }
            ),
            body=ParseHelper.toXml(action),
            headers={"Correlation-Id":correlation_id}
        )

        return result

class VMDiskPermission(params.Permission, Base):
    def __init__(self, vmdisk, permission, context):
        Base.__init__(self, context)
        self.parentclass = vmdisk
        self.superclass  =  permission

        #SUB_COLLECTIONS
    def __new__(cls, vmdisk, permission, context):
        if permission is None: return None
        obj = object.__new__(cls)
        obj.__init__(vmdisk, permission, context)
        return obj

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def delete(self, async=None):
        '''
        [@param async: boolean (true|false)]

        @return None:
        '''

        url = UrlHelper.replace(
            '/vms/{vm:id}/disks/{disk:id}/permissions/{permission:id}',
            {
                '{vm:id}': self.parentclass.parentclass.get_id(),
                '{disk:id}': self.parentclass.get_id(),
                '{permission:id}': self.get_id(),
            }
        )

        return self.__getProxy().delete(
            url=UrlHelper.appendParameters(
                url,
                {'async:matrix':async}
            ),
            headers={"Content-type":None}
        )

class VMDiskPermissions(Base):

    def __init__(self, disk , context):
        Base.__init__(self, context)
        self.parentclass = disk

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def add(self, permission):

        '''
        @type Permission:


        @return Permission:
        '''

        url = '/vms/{vm:id}/disks/{disk:id}/permissions'

        result = self.__getProxy().add(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{vm:id}': self.parentclass.parentclass.get_id(),
                        '{disk:id}': self.parentclass.get_id(),
                    }
                ),
                args={}
            ),
            body=ParseHelper.toXml(permission),
            headers={}
        )

        return VMDiskPermission(
            self.parentclass,
            result,
            self.context
        )

    def get(self, name=None, id=None):

        '''
        [@param id  : string (the id of the entity)]
        [@param name: string (the name of the entity)]

        @return Permissions:
        '''

        url = '/vms/{vm:id}/disks/{disk:id}/permissions'

        if id:
            try :
                result = self.__getProxy().get(
                    url=UrlHelper.append(
                        UrlHelper.replace(
                            url,
                            {
                                '{vm:id}': self.parentclass.parentclass.get_id(),
                                '{disk:id}': self.parentclass.get_id(),
                            }
                        ),
                        id
                    ),
                    headers={}
                )

                return VMDiskPermission(
                    self.parentclass,
                    result,
                    self.context
                )
            except RequestError as err:
                if err.status and err.status == 404:
                    return None
                raise err
        elif name:
            result = self.__getProxy().get(
                url=UrlHelper.replace(
                    url,
                    {
                        '{vm:id}': self.parentclass.parentclass.get_id(),
                        '{disk:id}': self.parentclass.get_id(),
                    }
                ),
                headers={}
            ).get_permission()

            return VMDiskPermission(
                self.parentclass,
                FilterHelper.getItem(
                    FilterHelper.filter(
                        result,
                        {'name':name}
                    ),
                    query="name=" + name
                ),
                self.context
            )
        else:
            raise MissingParametersError(['id', 'name'])

    def list(self, max=None, **kwargs):
        '''
        [@param **kwargs: dict (property based filtering)"]
        [@param max: int (max results)]

        @return Permissions:
        '''

        url = '/vms/{vm:id}/disks/{disk:id}/permissions'

        result = self.__getProxy().get(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{vm:id}': self.parentclass.parentclass.get_id(),
                        '{disk:id}': self.parentclass.get_id(),
                    }
                ),
                args={'max:matrix':max}
            ),
            headers={}
        ).get_permission()

        return ParseHelper.toSubCollection(
            VMDiskPermission,
            self.parentclass,
            FilterHelper.filter(
                result,
                kwargs
            ),
            context=self.context
        )

class VMDiskStatistic(params.Statistic, Base):
    def __init__(self, vmdisk, statistic, context):
        Base.__init__(self, context)
        self.parentclass = vmdisk
        self.superclass  =  statistic

        #SUB_COLLECTIONS
    def __new__(cls, vmdisk, statistic, context):
        if statistic is None: return None
        obj = object.__new__(cls)
        obj.__init__(vmdisk, statistic, context)
        return obj

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

class VMDiskStatistics(Base):

    def __init__(self, disk , context):
        Base.__init__(self, context)
        self.parentclass = disk

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def get(self, name=None, id=None):

        '''
        [@param id  : string (the id of the entity)]
        [@param name: string (the name of the entity)]

        @return Statistics:
        '''

        url = '/vms/{vm:id}/disks/{disk:id}/statistics'

        if id:
            try :
                result = self.__getProxy().get(
                    url=UrlHelper.append(
                        UrlHelper.replace(
                            url,
                            {
                                '{vm:id}': self.parentclass.parentclass.get_id(),
                                '{disk:id}': self.parentclass.get_id(),
                            }
                        ),
                        id
                    ),
                    headers={}
                )

                return VMDiskStatistic(
                    self.parentclass,
                    result,
                    self.context
                )
            except RequestError as err:
                if err.status and err.status == 404:
                    return None
                raise err
        elif name:
            result = self.__getProxy().get(
                url=UrlHelper.replace(
                    url,
                    {
                        '{vm:id}': self.parentclass.parentclass.get_id(),
                        '{disk:id}': self.parentclass.get_id(),
                    }
                ),
                headers={}
            ).get_statistic()

            return VMDiskStatistic(
                self.parentclass,
                FilterHelper.getItem(
                    FilterHelper.filter(
                        result,
                        {'name':name}
                    ),
                    query="name=" + name
                ),
                self.context
            )
        else:
            raise MissingParametersError(['id', 'name'])

    def list(self, **kwargs):
        '''
        [@param **kwargs: dict (property based filtering)"]

        @return Statistics:
        '''

        url = '/vms/{vm:id}/disks/{disk:id}/statistics'

        result = self.__getProxy().get(
            url=UrlHelper.replace(
                url,
                {
                    '{vm:id}': self.parentclass.parentclass.get_id(),
                    '{disk:id}': self.parentclass.get_id(),
                }
            )
        ).get_statistic()

        return ParseHelper.toSubCollection(
            VMDiskStatistic,
            self.parentclass,
            FilterHelper.filter(
                result,
                kwargs
            ),
            context=self.context
        )

class VMDisks(Base):

    def __init__(self, vm , context):
        Base.__init__(self, context)
        self.parentclass = vm

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def add(self, disk, correlation_id=None, expect=None):

        '''
        @type Disk:

        Overload 1:
          @param disk.format: string
          @param disk.interface: string
          @param disk.provisioned_size: int
          [@param disk.alias: string]
          [@param disk.name: string]
          [@param disk.size: int]
          [@param disk.sparse: boolean]
          [@param disk.description: string]
          [@param disk.bootable: boolean]
          [@param disk.shareable: boolean]
          [@param disk.propagate_errors: boolean]
          [@param disk.wipe_after_delete: boolean]
          [@param disk.quota.id: string]
          [@param disk.disk_profile.id: string]
          [@param disk.storage_domains.storage_domain: collection]
          {
            [@ivar storage_domain.id|name: string]
          }
          [@param disk.openstack_volume_type.name: string]
        Overload 2:
          @param disk.interface: string
          @param disk.lun_storage.type: string
          @param disk.lun_storage.logical_unit: collection
          {
            @ivar logical_unit.id: string
            @ivar logical_unit.address: string
            @ivar logical_unit.port: int
            @ivar logical_unit.target: string
          }
          [@param disk.alias: string]
          [@param disk.sparse: boolean]
          [@param disk.description: string]
          [@param disk.bootable: boolean]
          [@param disk.shareable: boolean]
          [@param disk.propagate_errors: boolean]
          [@param disk.wipe_after_delete: boolean]
          [@param disk.quota.id: string]
          [@param disk.sgio: string]
          [@param disk.uses_scsi_reservation: boolean]
          [@param disk.lun_storage.host: string]
        Overload 3:
          @param disk.id: string
          [@param disk.active: boolean]
          [@param disk.read_only: boolean]
        Overload 4:
          @param disk.id: string
          @param disk.snapshot.id: string
          [@param disk.active: boolean]
        [@param correlation_id: any string]
        [@param expect: 201-created]

        @return Disk:
        '''

        url = '/vms/{vm:id}/disks'

        result = self.__getProxy().add(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{vm:id}': self.parentclass.get_id(),
                    }
                ),
                args={}
            ),
            body=ParseHelper.toXml(disk),
            headers={"Correlation-Id":correlation_id, "Expect":expect}
        )

        return VMDisk(
            self.parentclass,
            result,
            self.context
        )

    def get(self, name=None, id=None):

        '''
        [@param id  : string (the id of the entity)]
        [@param name: string (the name of the entity)]

        @return Disks:
        '''

        url = '/vms/{vm:id}/disks'

        if id:
            try :
                result = self.__getProxy().get(
                    url=UrlHelper.append(
                        UrlHelper.replace(
                            url,
                            {
                                '{vm:id}': self.parentclass.get_id(),
                            }
                        ),
                        id
                    ),
                    headers={}
                )

                return VMDisk(
                    self.parentclass,
                    result,
                    self.context
                )
            except RequestError as err:
                if err.status and err.status == 404:
                    return None
                raise err
        elif name:
            result = self.__getProxy().get(
                url=UrlHelper.replace(
                    url,
                    {
                        '{vm:id}': self.parentclass.get_id(),
                    }
                ),
                headers={}
            ).get_disk()

            return VMDisk(
                self.parentclass,
                FilterHelper.getItem(
                    FilterHelper.filter(
                        result,
                        {'name':name}
                    ),
                    query="name=" + name
                ),
                self.context
            )
        else:
            raise MissingParametersError(['id', 'name'])

    def list(self, max=None, **kwargs):
        '''
        [@param **kwargs: dict (property based filtering)"]
        [@param max: int (max results)]

        @return Disks:
        '''

        url = '/vms/{vm:id}/disks'

        result = self.__getProxy().get(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{vm:id}': self.parentclass.get_id(),
                    }
                ),
                args={'max:matrix':max}
            ),
            headers={}
        ).get_disk()

        return ParseHelper.toSubCollection(
            VMDisk,
            self.parentclass,
            FilterHelper.filter(
                result,
                kwargs
            ),
            context=self.context
        )

class VMGraphicsConsole(params.GraphicsConsole, Base):
    def __init__(self, vm, graphicsconsole, context):
        Base.__init__(self, context)
        self.parentclass = vm
        self.superclass  =  graphicsconsole

        #SUB_COLLECTIONS
    def __new__(cls, vm, graphicsconsole, context):
        if graphicsconsole is None: return None
        obj = object.__new__(cls)
        obj.__init__(vm, graphicsconsole, context)
        return obj

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def delete(self, async=None, correlation_id=None):
        '''
        [@param async: boolean (true|false)]
        [@param correlation_id: any string]

        @return None:
        '''

        url = UrlHelper.replace(
            '/vms/{vm:id}/graphicsconsoles/{graphicsconsole:id}',
            {
                '{vm:id}': self.parentclass.get_id(),
                '{graphicsconsole:id}': self.get_id(),
            }
        )

        return self.__getProxy().delete(
            url=UrlHelper.appendParameters(
                url,
                {'async:matrix':async}
            ),
            headers={"Correlation-Id":correlation_id,"Content-type":None}
        )

class VMGraphicsConsoles(Base):

    def __init__(self, vm , context):
        Base.__init__(self, context)
        self.parentclass = vm

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def add(self, graphicsconsole, correlation_id=None, expect=None):

        '''
        @type GraphicsConsole:

        @param graphics_console.protocol: string
        [@param correlation_id: any string]
        [@param expect: 201-created]

        @return GraphicsConsole:
        '''

        url = '/vms/{vm:id}/graphicsconsoles'

        result = self.__getProxy().add(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{vm:id}': self.parentclass.get_id(),
                    }
                ),
                args={}
            ),
            body=ParseHelper.toXml(graphicsconsole),
            headers={"Correlation-Id":correlation_id, "Expect":expect}
        )

        return VMGraphicsConsole(
            self.parentclass,
            result,
            self.context
        )

    def get(self, name=None, id=None):

        '''
        [@param id  : string (the id of the entity)]
        [@param name: string (the name of the entity)]

        @return GraphicsConsoles:
        '''

        url = '/vms/{vm:id}/graphicsconsoles'

        if id:
            try :
                result = self.__getProxy().get(
                    url=UrlHelper.append(
                        UrlHelper.replace(
                            url,
                            {
                                '{vm:id}': self.parentclass.get_id(),
                            }
                        ),
                        id
                    ),
                    headers={}
                )

                return VMGraphicsConsole(
                    self.parentclass,
                    result,
                    self.context
                )
            except RequestError as err:
                if err.status and err.status == 404:
                    return None
                raise err
        elif name:
            result = self.__getProxy().get(
                url=UrlHelper.replace(
                    url,
                    {
                        '{vm:id}': self.parentclass.get_id(),
                    }
                ),
                headers={}
            ).get_graphics_console()

            return VMGraphicsConsole(
                self.parentclass,
                FilterHelper.getItem(
                    FilterHelper.filter(
                        result,
                        {'name':name}
                    ),
                    query="name=" + name
                ),
                self.context
            )
        else:
            raise MissingParametersError(['id', 'name'])

    def list(self, current=None, max=None, **kwargs):
        '''
        [@param **kwargs: dict (property based filtering)"]
        [@param current: boolean (true|false)]
        [@param max: int (max results)]

        @return GraphicsConsoles:
        '''

        url = '/vms/{vm:id}/graphicsconsoles'

        result = self.__getProxy().get(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{vm:id}': self.parentclass.get_id(),
                    }
                ),
                args={'current:matrix':current,'max:matrix':max}
            ),
            headers={}
        ).get_graphics_console()

        return ParseHelper.toSubCollection(
            VMGraphicsConsole,
            self.parentclass,
            FilterHelper.filter(
                result,
                kwargs
            ),
            context=self.context
        )

class VMHostDevice(params.HostDevice, Base):
    def __init__(self, vm, hostdevice, context):
        Base.__init__(self, context)
        self.parentclass = vm
        self.superclass  =  hostdevice

        #SUB_COLLECTIONS
    def __new__(cls, vm, hostdevice, context):
        if hostdevice is None: return None
        obj = object.__new__(cls)
        obj.__init__(vm, hostdevice, context)
        return obj

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def delete(self, async=None, correlation_id=None):
        '''
        [@param async: boolean (true|false)]
        [@param correlation_id: any string]

        @return None:
        '''

        url = UrlHelper.replace(
            '/vms/{vm:id}/hostdevices/{hostdevice:id}',
            {
                '{vm:id}': self.parentclass.get_id(),
                '{hostdevice:id}': self.get_id(),
            }
        )

        return self.__getProxy().delete(
            url=UrlHelper.appendParameters(
                url,
                {'async:matrix':async}
            ),
            headers={"Correlation-Id":correlation_id,"Content-type":None}
        )

class VMHostDevices(Base):

    def __init__(self, vm , context):
        Base.__init__(self, context)
        self.parentclass = vm

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def add(self, hostdevice, correlation_id=None, expect=None):

        '''
        @type HostDevice:

        @param host_device.id|name: xs.string
        [@param correlation_id: any string]
        [@param expect: 201-created]

        @return HostDevice:
        '''

        url = '/vms/{vm:id}/hostdevices'

        result = self.__getProxy().add(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{vm:id}': self.parentclass.get_id(),
                    }
                ),
                args={}
            ),
            body=ParseHelper.toXml(hostdevice),
            headers={"Correlation-Id":correlation_id, "Expect":expect}
        )

        return VMHostDevice(
            self.parentclass,
            result,
            self.context
        )

    def get(self, name=None, id=None):

        '''
        [@param id  : string (the id of the entity)]
        [@param name: string (the name of the entity)]

        @return HostDevices:
        '''

        url = '/vms/{vm:id}/hostdevices'

        if id:
            try :
                result = self.__getProxy().get(
                    url=UrlHelper.append(
                        UrlHelper.replace(
                            url,
                            {
                                '{vm:id}': self.parentclass.get_id(),
                            }
                        ),
                        id
                    ),
                    headers={}
                )

                return VMHostDevice(
                    self.parentclass,
                    result,
                    self.context
                )
            except RequestError as err:
                if err.status and err.status == 404:
                    return None
                raise err
        elif name:
            result = self.__getProxy().get(
                url=UrlHelper.replace(
                    url,
                    {
                        '{vm:id}': self.parentclass.get_id(),
                    }
                ),
                headers={}
            ).get_host_device()

            return VMHostDevice(
                self.parentclass,
                FilterHelper.getItem(
                    FilterHelper.filter(
                        result,
                        {'name':name}
                    ),
                    query="name=" + name
                ),
                self.context
            )
        else:
            raise MissingParametersError(['id', 'name'])

    def list(self, max=None, **kwargs):
        '''
        [@param **kwargs: dict (property based filtering)"]
        [@param max: int (max results)]

        @return HostDevices:
        '''

        url = '/vms/{vm:id}/hostdevices'

        result = self.__getProxy().get(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{vm:id}': self.parentclass.get_id(),
                    }
                ),
                args={'max:matrix':max}
            ),
            headers={}
        ).get_host_device()

        return ParseHelper.toSubCollection(
            VMHostDevice,
            self.parentclass,
            FilterHelper.filter(
                result,
                kwargs
            ),
            context=self.context
        )

class VMKatelloErrata(Base):

    def __init__(self, vm , context):
        Base.__init__(self, context)
        self.parentclass = vm

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def get(self, name=None, id=None):

        '''
        [@param id  : string (the id of the entity)]
        [@param name: string (the name of the entity)]

        @return KatelloErrata:
        '''

        url = '/vms/{vm:id}/katelloerrata'

        if id:
            try :
                result = self.__getProxy().get(
                    url=UrlHelper.append(
                        UrlHelper.replace(
                            url,
                            {
                                '{vm:id}': self.parentclass.get_id(),
                            }
                        ),
                        id
                    ),
                    headers={}
                )

                return VMKatelloErratum(
                    self.parentclass,
                    result,
                    self.context
                )
            except RequestError as err:
                if err.status and err.status == 404:
                    return None
                raise err
        elif name:
            result = self.__getProxy().get(
                url=UrlHelper.replace(
                    url,
                    {
                        '{vm:id}': self.parentclass.get_id(),
                    }
                ),
                headers={}
            ).get_katello_erratum()

            return VMKatelloErratum(
                self.parentclass,
                FilterHelper.getItem(
                    FilterHelper.filter(
                        result,
                        {'name':name}
                    ),
                    query="name=" + name
                ),
                self.context
            )
        else:
            raise MissingParametersError(['id', 'name'])

    def list(self, max=None, **kwargs):
        '''
        [@param **kwargs: dict (property based filtering)"]
        [@param max: int (max results)]

        @return KatelloErrata:
        '''

        url = '/vms/{vm:id}/katelloerrata'

        result = self.__getProxy().get(
            url=UrlHelper.appendParameters(
                url=UrlHelper.replace(
                    url=url,
                    args={
                        '{vm:id}': self.parentclass.get_id(),
                    }
                ),
                args={'max:matrix':max}
            ),
            headers={}
        ).get_katello_erratum()

        return ParseHelper.toSubCollection(
            VMKatelloErratum,
            self.parentclass,
            FilterHelper.filter(
                result,
                kwargs
            ),
            context=self.context
        )

class VMKatelloErratum(params.KatelloErratum, Base):
    def __init__(self, vm, katelloerratum, context):
        Base.__init__(self, context)
        self.parentclass = vm
        self.superclass  =  katelloerratum

        #SUB_COLLECTIONS
    def __new__(cls, vm, katelloerratum, context):
        if katelloerratum is None: return None
        obj = object.__new__(cls)
        obj.__init__(vm, katelloerratum, context)
        return obj

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

class VMNIC(params.NIC, Base):
    def __init__(self, vm, nic, context):
        Base.__init__(self, context)
        self.parentclass = vm
        self.superclass  =  nic

        self.reporteddevices = VMNICReportedDevices(self, context)
        self.statistics = VMNICStatistics(self, context)

    def __new__(cls, vm, nic, context):
        if nic is None: return None
        obj = object.__new__(cls)
        obj.__init__(vm, nic, context)
        return obj

    def __getProxy(self):
        proxy = context.manager[self.context].get('proxy')
        if proxy:
            return proxy
        #This may happen only if sdk was explicitly disconnected
        #using .disconnect() method, but resource instance ref. is
        #still available at client's code.
        raise DisconnectedError

    def delete(self, async=None, correlation_id=None):
        '''
        [@param async: boolean (true|false)]
        [@param correlation_id: any string]

        @return None:
        '''

        url = UrlHelper.replace(
            '/vms/{vm:id}/nics/{nic:id}',
            {
                '{vm:id}': self.parentclass.get_id(),
                '{nic:id}': self.get_id(),
            }
        )

        return self.__getProxy().delete(
            url=UrlHelper.appendParameters(
                url,
                {'async:matrix':async}
            ),
            headers={"Correlation-Id":correlation_id,"Content-type":None}
        )

    def update(self, async=None, correlation_id=None, expect=None):
        '''
        Overload 1:
          [@param nic.vnic_profile.id: string]
          [@param nic.linked: boolean]
          [@param nic.name: string]
          [@param nic.mac.address: string]
          [@param nic.interface: string]
          [@param nic.plugged: boolean]
        Overload 2:
          [@param nic.network.id|name: string]
          [@param nic.linked: boolean]
          [@param nic.name: string]
          [@param nic.mac.address: string]
          [@param nic.interface: string]
          [@param nic.port_mirroring.networks.network: collection]
          {
            [@ivar network.id: string]
          }
          [@param nic.plugged: boolean]
        [@param async: boolean (true|false)]
        [@param correlation_id: any string]
        [@param expect: 202-accepted]

        @return NIC:
        '''

        url = '/vms/{vm:id}/nics/{nic:id}'
        url = UrlHelper.replace(
            url,
            {
                '{vm:id}': self.parentclass.get_id(),
                '{nic:id}': self.get_id(),
            }
        )

        result = self.__getProxy().update(
            url=UrlHelper.appendParameters(url, {'async:matrix':async}),
            body=ParseHelper.toXml(self.superclass),
            headers={"Correlation-Id":correlation_id, "Expect":expect}
        )

        return VMNIC(
            self.parentclass,
            result,
            self.context
        )

    def activate(self, action=params.Action(), correlation_id=None):
        '''
        @type Action:

        [@param correlation_id: any string]

        @return Action:
        '''

        url = '/vms/{vm:id}/nics/{nic:id}/activate'

        result = self.__getProxy().request(
            method='POST',
            url=UrlHelper.replace(
                url,
                {
                    '{vm:id}': self.parentclass.get_id(),
                    '{nic:id}': self.get_id(),
                }
            ),
            body=ParseHelper.toXml(action),
            headers={"Correlation-Id":correlation_id}
        )

        return result

    def deactivate(self, action=params.Action(), correlation_id=None):
        '''
        @type Action:

        [@param correlation_id: any string]

        @return Action:
        '''

        url = '/vms/{vm:id}/nics/{nic:id}/deactivate'

        result = self.__