/* $OpenBSD: sha.h,v 1.1 2023/07/08 12:24:10 beck Exp $ */
/*
 * Copyright (c) 2023 Bob Beck <beck@openbsd.org>
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

#ifndef _LIBCRYPTO_SHA_H
#define _LIBCRYPTO_SHA_H

#ifndef _MSC_VER
#include_next <openssl/sha.h>
#else
#include "../include/openssl/sha.h"
#endif
#include "crypto_namespace.h"

LCRYPTO_USED(SHA1_Init);
LCRYPTO_USED(SHA1_Update);
LCRYPTO_USED(SHA1_Final);
LCRYPTO_USED(SHA1);
LCRYPTO_USED(SHA1_Transform);
LCRYPTO_USED(SHA224_Init);
LCRYPTO_USED(SHA224_Update);
LCRYPTO_USED(SHA224_Final);
LCRYPTO_USED(SHA224);
LCRYPTO_USED(SHA256_Init);
LCRYPTO_USED(SHA256_Update);
LCRYPTO_USED(SHA256_Final);
LCRYPTO_USED(SHA256);
LCRYPTO_USED(SHA256_Transform);
LCRYPTO_USED(SHA384_Init);
LCRYPTO_USED(SHA384_Update);
LCRYPTO_USED(SHA384_Final);
LCRYPTO_USED(SHA384);
LCRYPTO_USED(SHA512_Init);
LCRYPTO_USED(SHA512_Update);
LCRYPTO_USED(SHA512_Final);
LCRYPTO_USED(SHA512);
LCRYPTO_USED(SHA512_Transform);

#endif /* _LIBCRYPTO_SHA_H */
