/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.generator.layout.fill;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.Tool;
import com.sun.electric.tool.generator.layout.Gallery;
import com.sun.electric.tool.generator.layout.LayoutLib;
import com.sun.electric.tool.generator.layout.StdCellParams;
import com.sun.electric.tool.generator.layout.Tech;
import com.sun.electric.tool.generator.layout.fill.CapCell;
import com.sun.electric.tool.generator.layout.fill.CapFloorplan;
import com.sun.electric.tool.generator.layout.fill.FillCell;
import com.sun.electric.tool.generator.layout.fill.FillGenConfig;
import com.sun.electric.tool.generator.layout.fill.Floorplan;
import com.sun.electric.tool.generator.layout.fill.MetalFloorplan;
import com.sun.electric.tool.generator.layout.fill.MetalFloorplanFlex;
import com.sun.electric.tool.generator.layout.fill.TiledCell;
import java.util.ArrayList;
import java.util.List;

public class FillGeneratorTool
extends Tool {
    private static FillGeneratorTool tool = FillGeneratorTool.getTool();
    private static final double m1via = 4.0;
    private static final double m1sp = 3.0;
    private static final double m1SP = 6.0;
    private static final double m6via = 5.0;
    private static final double m6sp = 4.0;
    private static final double m6SP = 8.0;
    public FillGenConfig config;
    protected Library lib;
    private boolean libInitialized;
    public List<Cell> masters;
    protected StdCellParams stdCell;
    protected StdCellParams stdCellP;
    protected CapCell capCell;
    protected CapCell capCellP;
    protected Floorplan[] plans;
    public static final Units LAMBDA = Units.LAMBDA;
    public static final Units TRACKS = Units.TRACKS;
    public static final PowerType POWER = PowerType.POWER;
    public static final PowerType VDD = PowerType.VDD;
    public static final ExportConfig PERIMETER = ExportConfig.PERIMETER;
    public static final ExportConfig PERIMETER_AND_INTERNAL = ExportConfig.PERIMETER_AND_INTERNAL;

    public static FillGeneratorTool getTool() {
        FillGeneratorTool tool;
        if (FillGeneratorTool.tool != null) {
            return FillGeneratorTool.tool;
        }
        try {
            Class<?> extraClass = Class.forName("com.sun.electric.plugins.generator.FillCellTool");
            Object obj = extraClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            tool = (FillGeneratorTool)obj;
        }
        catch (Exception e) {
            if (Job.getDebug()) {
                System.out.println("GNU Release can't find Fill Cell Generator plugin");
            }
            tool = new FillGeneratorTool();
        }
        return tool;
    }

    public FillGeneratorTool() {
        super("Fill Generator");
        Tech.setTechnology(Tech.Type.MOCMOS);
    }

    public void setConfig(FillGenConfig config) {
        this.config = config;
        this.libInitialized = false;
        Tech.setTechnology(config.techNm);
    }

    protected boolean getOrientation() {
        return this.plans[this.plans.length - 1].horizontal;
    }

    private double reservedToLambda(int layer, double reserved, Units units) {
        if (units == LAMBDA) {
            return reserved;
        }
        double nbTracks = reserved;
        if (nbTracks == 0.0) {
            return 0.0;
        }
        if (layer != 6) {
            return 9.0 + nbTracks * 7.0;
        }
        return 12.0 + nbTracks * 9.0;
    }

    private Floorplan[] makeFloorplans(boolean metalFlex, boolean hierFlex) {
        LayoutLib.error(this.config.width == Double.NaN, "width hasn't been specified. use setWidth()");
        LayoutLib.error(this.config.height == Double.NaN, "height hasn't been specified. use setHeight()");
        double w = this.config.width;
        double h = this.config.height;
        double[] vddRes = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
        double[] gndRes = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
        double[] vddW = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
        double[] gndW = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
        for (FillGenConfig.ReserveConfig c : this.config.reserves) {
            vddRes[c.layer] = this.reservedToLambda(c.layer, c.vddReserved, c.vddUnits);
            gndRes[c.layer] = this.reservedToLambda(c.layer, c.gndReserved, c.gndUnits);
            if (c.vddWUnits != Units.NONE) {
                vddW[c.layer] = this.reservedToLambda(c.layer, c.vddWidth, c.vddWUnits);
            }
            if (c.gndWUnits == Units.NONE) continue;
            gndW[c.layer] = this.reservedToLambda(c.layer, c.gndWidth, c.gndWUnits);
        }
        boolean evenHor = this.config.evenLayersHorizontal;
        boolean alignedMetals = true;
        double[] spacing = new double[]{this.config.drcSpacingRule, this.config.drcSpacingRule, this.config.drcSpacingRule, this.config.drcSpacingRule, this.config.drcSpacingRule, this.config.drcSpacingRule, this.config.drcSpacingRule};
        if (alignedMetals) {
            int i;
            double maxVddRes = 0.0;
            double maxGndRes = 0.0;
            double maxSpacing = 0.0;
            double maxVddW = 0.0;
            double maxGndW = 0.0;
            for (i = 0; i < vddRes.length; ++i) {
                boolean vddOK = false;
                boolean gndOK = false;
                if (vddRes[i] > 0.0) {
                    vddOK = true;
                    if (maxVddRes < vddRes[i]) {
                        maxVddRes = vddRes[i];
                    }
                }
                if (gndRes[i] > 0.0) {
                    gndOK = true;
                    if (maxGndRes < gndRes[i]) {
                        maxGndRes = gndRes[i];
                    }
                }
                if ((gndOK || vddOK) && maxSpacing < this.config.drcSpacingRule) {
                    maxSpacing = this.config.drcSpacingRule;
                }
                if (maxVddW < vddW[i]) {
                    maxVddW = vddW[i];
                }
                if (!(maxGndW < gndW[i])) continue;
                maxGndW = gndW[i];
            }
            for (i = 0; i < vddRes.length; ++i) {
                vddRes[i] = maxVddRes;
                gndRes[i] = maxGndRes;
                spacing[i] = maxSpacing;
                vddW[i] = maxVddW;
                gndW[i] = maxGndW;
            }
        }
        if (metalFlex) {
            if (!hierFlex) {
                return new Floorplan[]{null, new CapFloorplan(w, h, !evenHor), new MetalFloorplanFlex(w, h, vddRes[2], gndRes[2], spacing[2], vddW[2], gndW[2], evenHor), new MetalFloorplanFlex(w, h, vddRes[3], gndRes[3], spacing[3], vddW[3], gndW[3], !evenHor), new MetalFloorplanFlex(w, h, vddRes[4], gndRes[4], spacing[4], vddW[4], gndW[4], evenHor), new MetalFloorplanFlex(w, h, vddRes[5], gndRes[5], spacing[5], vddW[5], gndW[5], !evenHor), new MetalFloorplanFlex(w, h, vddRes[6], gndRes[6], spacing[6], vddW[6], gndW[6], evenHor)};
            }
            w = this.config.width = this.config.minTileSizeX;
            h = this.config.height = this.config.minTileSizeY;
        }
        return new Floorplan[]{null, new CapFloorplan(w, h, !evenHor), new MetalFloorplan(w, h, vddRes[2], gndRes[2], spacing[2], evenHor), new MetalFloorplan(w, h, vddRes[3], gndRes[3], spacing[3], !evenHor), new MetalFloorplan(w, h, vddRes[4], gndRes[4], spacing[4], evenHor), new MetalFloorplan(w, h, vddRes[5], gndRes[5], spacing[5], !evenHor), new MetalFloorplan(w, h, vddRes[6], gndRes[6], spacing[6], evenHor)};
    }

    private void printCoverage(Floorplan[] plans) {
        for (int i = 2; i < plans.length; ++i) {
            System.out.println("metal-" + i + " coverage: " + ((MetalFloorplan)plans[i]).coverage);
        }
    }

    protected void initFillParameters(boolean metalFlex, boolean hierFlex) {
        if (this.libInitialized) {
            return;
        }
        LayoutLib.error(this.config.fillLibName == null, "no library specified. Use setFillLibrary()");
        LayoutLib.error(this.config.width == Double.NaN || this.config.width <= 0.0, "no width specified. Use setFillCellWidth()");
        LayoutLib.error(this.config.height == Double.NaN || this.config.height <= 0.0, "no height specified. Use setFillCellHeight()");
        this.plans = this.makeFloorplans(metalFlex, hierFlex);
        if (!metalFlex) {
            this.printCoverage(this.plans);
        }
        this.lib = LayoutLib.openLibForWrite(this.config.fillLibName);
        this.stdCell = new StdCellParams(null, Tech.getTechnology());
        this.stdCellP = new StdCellParams(null, Tech.getTechnology());
        this.stdCellP.setVddExportName("power");
        this.stdCellP.setVddExportRole(PortCharacteristic.IN);
        if (!metalFlex) {
            this.capCell = new CapCell(this.lib, (CapFloorplan)this.plans[1], this.stdCell);
            this.capCellP = new CapCell(this.lib, (CapFloorplan)this.plans[1], this.stdCellP);
        }
        this.libInitialized = true;
    }

    private void makeTiledCells(Cell cell, Floorplan[] plans, Library lib, int[] tiledSizes, StdCellParams stdCell) {
        if (tiledSizes == null) {
            return;
        }
        for (int num : tiledSizes) {
            TiledCell.makeTiledCell(num, num, cell, plans, lib, stdCell);
        }
    }

    public static Cell makeFillCell(Library lib, Floorplan[] plans, int botLayer, int topLayer, CapCell capCell, boolean wireLowest, StdCellParams stdCell, boolean metalFlex, boolean hierFlex) {
        FillCell fc = new FillCell(stdCell);
        return fc.makeFillCell1(lib, plans, botLayer, topLayer, capCell, wireLowest, stdCell, metalFlex, hierFlex);
    }

    private Cell standardMakeAndTileCell(Library lib, Floorplan[] plans, int lowLay, int hiLay, CapCell capCell, boolean wireLowest, int[] tiledSizes, StdCellParams stdCell, boolean metalFlex) {
        Cell master = FillGeneratorTool.makeFillCell(lib, plans, lowLay, hiLay, capCell, wireLowest, stdCell, metalFlex, false);
        this.masters = new ArrayList<Cell>();
        this.masters.add(master);
        this.makeTiledCells(master, plans, lib, tiledSizes, stdCell);
        return master;
    }

    private Cell standardMakeFillCell(int loLayer, int hiLayer, ExportConfig exportConfig, PowerType powerType, int[] tiledSizes, boolean metalFlex) {
        this.initFillParameters(metalFlex, false);
        LayoutLib.error(loLayer < 1, "loLayer must be >=1");
        LayoutLib.error(hiLayer > 6, "hiLayer must be <=6");
        LayoutLib.error(loLayer > hiLayer, "loLayer must be <= hiLayer");
        boolean wireLowest = exportConfig == PERIMETER_AND_INTERNAL;
        Cell cell = null;
        cell = powerType == VDD ? this.standardMakeAndTileCell(this.lib, this.plans, loLayer, hiLayer, this.capCell, wireLowest, tiledSizes, this.stdCell, metalFlex) : this.standardMakeAndTileCell(this.lib, this.plans, loLayer, hiLayer, this.capCellP, wireLowest, tiledSizes, this.stdCellP, metalFlex);
        return cell;
    }

    public Cell standardMakeFillCell(int loLayer, int hiLayer, ExportConfig exportConfig, int[] tiledSizes, boolean metalFlex) {
        return this.standardMakeFillCell(loLayer, hiLayer, exportConfig, VDD, tiledSizes, metalFlex);
    }

    public void makeGallery() {
        Gallery.makeGallery(this.lib);
    }

    public void writeLibrary() {
        LayoutLib.writeLibrary(this.lib);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FillTypeEnum {
        INVALID,
        TEMPLATE,
        CELL;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ExportConfig {
        PERIMETER,
        PERIMETER_AND_INTERNAL;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PowerType {
        POWER,
        VDD;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Units {
        NONE,
        LAMBDA,
        TRACKS;

    }
}

