/* Simple demo program which sends TCP RST packets in response to TCP
 * SYN packets.  Supply a destination IP and port number on the
 * command line. */
/* This code is GPL (C)1998 Paul `Rusty' Russell. */
#include <stdlib.h>
#include <stdio.h>
#include <signal.h>
#include <fcntl.h>
#include <unistd.h>
#include <sys/stat.h>

#include <netdb.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include "fwinterface.h"

void cleanup_and_exit(int signal __attribute((unused)))
{
    fw_close_listen(0);
    exit(0);
}

__u16 csum_partial(void *buffer, unsigned int len, __u16 prevsum)
{
	__u32 sum = 0;
	__u16 *ptr = buffer;

	while (len > 1)  {
		sum += *ptr++;
		len -= 2;
	}
	if (len) {
		union {
			__u8 byte;
			__u16 wyde;
		} odd;
		odd.wyde = 0;
		odd.byte = *((__u8 *)ptr);
		sum += odd.wyde;
	}
	sum = (sum >> 16) + (sum & 0xFFFF);
	sum += prevsum;
	return (sum + (sum >> 16));
}

static const struct iphdr *
readpkt(__u32 rulenum __attribute__((unused)), 
	const char *interface,
	const ip_chainlabel name __attribute__((unused)),
	__u16 packetsize,
	struct iphdr *hdr)
{
	__u32 tmp;
	struct tcphdr *tcp = (struct tcphdr *)((char *)hdr + hdr->ihl*4);
	struct pseudo_header {		/* For TCP header checksum */
		__u32 saddr;
		__u32 daddr;
		__u8 reserved;
		__u8 protocol;
		__u16 tcplen;
	} pseudo_header;


	fprintf(stderr, "Got one!\n");
	/* How to create a RST packet. */

	/* 1) Swap source and dest IP */
	tmp = hdr->saddr;
	hdr->saddr = hdr->daddr;
	hdr->daddr = tmp;

	/* 2) Delete TCP options & data. */
	hdr->tot_len = htons(hdr->ihl*4 + sizeof(*tcp));
	tcp->doff = sizeof(*tcp)/4;

	/* 3) Swap source and dest ports */
	tmp = tcp->dest;
	tcp->dest = tcp->source;
	tcp->source = tmp;

	/* 4) It's a SYN, so ack = seq + 1, seq = 0 */
	tcp->rst = tcp->ack = 1;
	tcp->syn = tcp->fin = tcp->psh = tcp->urg = 0;

	tcp->ack_seq = htonl(ntohl(tcp->seq)+1);
	tcp->seq = htonl(0);

	/* 5) Window = 0, DF = 0, offset = 0  */
	tcp->window = htonl(0);
	hdr->frag_off = 0;

	/* 6) TTL = 255. */
	hdr->ttl = 255;

	/* Do TCP checksum. */
	tcp->check = 0;
	pseudo_header.saddr = hdr->saddr;
	pseudo_header.daddr = hdr->daddr;
	pseudo_header.reserved = 0;
	pseudo_header.protocol = IPPROTO_TCP;
	pseudo_header.tcplen = htons(sizeof(*tcp));
	tcp->check = ~csum_partial((unsigned short *)&pseudo_header,
				   sizeof(pseudo_header), 
				   csum_partial(tcp, sizeof(*tcp), 0));

	/* IP checksum */
	hdr->check = 0;
	hdr->check = ~csum_partial((unsigned short *)hdr, sizeof(*hdr), 0);

	return hdr;
}

int main(int argc, const char *argv[])
{
	struct hostent *hp;
	__u32 destip;
	int destpt;
	int ret;
	struct ip_fw fw 
		= { { 0 }, { 0 }, { 0 }, { 0xFFFFFFFF }, /* SRC=ANY & DST=exact */
		    0,				/* Filled in by fw_reg... */
		    IPPROTO_TCP,		/* Only TCP packets */
		    IP_FW_F_TCPSYN,		/* TCP SYNs only */
		    0,				/* Nothing special */
		    { 0, 0xFFFF },              /* Source Pt = any */
		    { 0, 0 },			/* Dest Pt = TBA */
		    0,				/* redirpt = N/A */
		    65535,                      /* outputsize = all */
		    "",				/* interface = any */
		    0xFF, 0x00			/* TOS = unchanged */
	};

	if (argc != 3) {
		fprintf(stderr, "Usage: tcp_reset [dest host] [dest port]\n");
		exit(1);
	}

	hp = gethostbyname(argv[1]);
	if (!hp) {
		destip = inet_addr(argv[1]);
		if (destip == 0xFFFFFFFF) {
			fprintf(stderr, "Unknown host `%s'\n", argv[1]);
			exit(1);
		}
	} else memcpy(&destip, hp->h_addr_list[0], sizeof(destip));

	destpt = atoi(argv[2]);
	if (destpt < 1 || destpt > 65535) {
		fprintf(stderr, "Bad port `%s'\n", argv[2]);
		exit(1);
	}

	fw.fw_dst.s_addr = destip;
	fw.fw_dpts[0] = fw.fw_dpts[1] = destpt;

	if (!fw_init_listen(0, 0)) exit(1);

	/* Cleanup on receipt of ^C */
	signal(SIGINT, &cleanup_and_exit);

	if (!fw_register_interest(&fw, "input", readpkt, "DENY", 0, 0)) 
		exit(1);

	ret = fw_do_listen(0);
	fw_close_listen(0);

	exit(!ret);
}	
