////////////////////////////////////////////////////////////////////////////////
//
//	Class : akColor
//
//	Author : Andy Jefferson
//
//	Description :
//		The akColor class provides a color selection component,
//		providing slider control over the red, green, blue
//		components of color. It additionally allows selection
//		of the X11 predefined colors.
//
////////////////////////////////////////////////////////////////////////////////
#ifndef _akColor_h
#define _akColor_h
#ifdef __cplusplus

#include <Xm/Xm.h>
#include <vector.h>
#include <std/string.h>
#include "akComponent.h"

typedef struct
{
	string	name;
	int	red;
	int	green;
	int	blue;
} akDefinedColor;

class akColor : public akComponent
{
	public:

		// Constructor/Destructor

		akColor(Widget parent,
			 char *name,
			 int red=0,
			 int green=0,
			 int blue=0);
		~akColor(void);

		// Access functions

		int	red(void)   {return (_red);}
		int	green(void) {return (_green);}
		int	blue(void)  {return (_blue);}

		// Class name

		virtual const char *const className(void)
			{return ("akColor");}

	private:

		// The color components

		int	_red;
		int	_green;
		int	_blue;

		Pixel	_pixel;
		int	_enabled;

		// The array of defined (X11) colors (from rgb.txt)

		vector<akDefinedColor>	defined_colors;

		// The color selection widgets

		Widget	redSlider;
		Widget	greenSlider;
		Widget	blueSlider;
		Widget	colorView;
		Widget	definedList;

		// Update functions

		static void	redSliderChangedCB(Widget w,XtPointer ClientData,XtPointer CallData);
		static void	greenSliderChangedCB(Widget w,XtPointer ClientData,XtPointer CallData);
		static void	blueSliderChangedCB(Widget w,XtPointer ClientData,XtPointer CallData);
		static void	definedSelectionCB(Widget w,XtPointer ClientData,XtPointer CallData);

		void		updateView(void);
		void		updateRed(int value);
		void		updateGreen(int value);
		void		updateBlue(int value);

		void		addDefinedColors(void);
};

#endif
#endif
