#include "akFileDialog.h"
#include <Xm/FileSB.h>
#include <Xm/List.h>
#include <assert.h>
#include <iostream.h>
////////////////////////////////////////////////////////////////////////////////
//
//	Constructor
//
////////////////////////////////////////////////////////////////////////////////
akFileDialog::akFileDialog(Widget parent,
			   char *name,
			   Boolean modal,
		           void  *clientData,
		           akDialogCallback ok,
		           akDialogCallback cancel,
		           akDialogCallback help)
	: akComponent(name)
{
	Widget	button;
	Arg	args[2];

//	Create the dialog

	if (modal)
	  {
	   XtSetArg(args[0],XmNautoUnmanage,TRUE);
	   XtSetArg(args[1],XmNdialogStyle,XmDIALOG_FULL_APPLICATION_MODAL);
	   _w = XmCreateFileSelectionDialog(parent,_name,args,2);
	  }
	else
	  {
	   XtSetArg(args[0],XmNautoUnmanage,TRUE);
	   _w = XmCreateFileSelectionDialog(parent,_name,args,1);
	  }

//	Set up the callback data structure

	_CBdata = new akDialogCallbackData(clientData,ok,cancel,help);

//	Ensure that all required buttons are available

	button = XmFileSelectionBoxGetChild(_w,XmDIALOG_OK_BUTTON);
	if (!ok)
	  XtUnmanageChild(button);
	else
	  XtManageChild(button);

	button = XmFileSelectionBoxGetChild(_w,XmDIALOG_CANCEL_BUTTON);
	if (!cancel)
	  XtUnmanageChild(button);
	else
	  XtManageChild(button);

	button = XmFileSelectionBoxGetChild(_w,XmDIALOG_HELP_BUTTON);
	if (!help)
	  XtUnmanageChild(button);
	else
	  XtManageChild(button);

//	Set up all callbacks

	XtAddCallback(_w,XmNokCallback, 
		      &akFileDialog::actionCB,
		      (XtPointer)this);
	XtAddCallback(_w,XmNcancelCallback, 
		      &akFileDialog::actionCB,
		      (XtPointer)this);
	XtAddCallback(_w,XmNhelpCallback, 
		      &akFileDialog::actionCB,
		      (XtPointer)this);
}
////////////////////////////////////////////////////////////////////////////////
//
//	Destructor
//
////////////////////////////////////////////////////////////////////////////////
akFileDialog::~akFileDialog()
{
	delete _CBdata;
}
////////////////////////////////////////////////////////////////////////////////
//
//	Default file update function
//
////////////////////////////////////////////////////////////////////////////////
void akFileDialog::setDefault(string file)
{
	Widget		fileList;
	XmString	item;
	string		directory;

	if (!file.empty())
	  {

	   // Find directory for this file

	   int	pos = file.rfind('/');
	   directory.assign(file,0,pos);
	   setDirectory(directory.c_str());

	   // Select file in 'Files' list and put in 'Selection' field

	   fileList = XmFileSelectionBoxGetChild(_w,XmDIALOG_LIST);
	   if (fileList != (Widget)0)
	     {
	      item = XmStringCreateLocalized((char *)file.c_str());
	      XmListSelectItem(fileList,item,TRUE);
	     }
	  }
}
////////////////////////////////////////////////////////////////////////////////
//
//	Directory update function
//
////////////////////////////////////////////////////////////////////////////////
void akFileDialog::setDirectory(string dir)
{
	if (dir.size() > 0)
	  {
	   XmString xmstr = XmStringCreateLocalized((char *)dir.c_str());
	   XtVaSetValues(_w,XmNdirectory,xmstr,NULL);
	   XmStringFree(xmstr);
	  }
}
////////////////////////////////////////////////////////////////////////////////
//
//	Pattern update function
//
////////////////////////////////////////////////////////////////////////////////
void akFileDialog::setPattern(string pattern)
{
	if (pattern.size() > 0)
	  {
	   XmString xmstr = XmStringCreateLocalized((char *)pattern.c_str());
	   XtVaSetValues(_w,XmNpattern,xmstr,NULL);
	   XmStringFree(xmstr);
	  }
}
////////////////////////////////////////////////////////////////////////////////
//
//	Title update function
//
////////////////////////////////////////////////////////////////////////////////
void akFileDialog::setTitle(string title)
{
	if (title.size() > 0)
	  {
	   XmString xmstr = XmStringCreateLtoR((char *)title.c_str(),XmSTRING_DEFAULT_CHARSET);
	   XtVaSetValues(_w,XmNdialogTitle,xmstr,NULL);
	   XmStringFree(xmstr);
	  }
}
////////////////////////////////////////////////////////////////////////////////
//
//	OK Label update function
//
////////////////////////////////////////////////////////////////////////////////
void akFileDialog::setOKLabel(string label)
{
	if (label.size() > 0)
	  {
	   XmString xmstr = XmStringCreateLocalized((char *)label.c_str());
	   XtVaSetValues(_w,XmNokLabelString,xmstr,NULL);
	   XmStringFree(xmstr);
	  }
}
////////////////////////////////////////////////////////////////////////////////
//
//	Cancel Label update function
//
////////////////////////////////////////////////////////////////////////////////
void akFileDialog::setCancelLabel(string label)
{
	if (label.size() > 0)
	  {
	   XmString xmstr = XmStringCreateLocalized((char *)label.c_str());
	   XtVaSetValues(_w,XmNcancelLabelString,xmstr,NULL);
	   XmStringFree(xmstr);
	  }
}
////////////////////////////////////////////////////////////////////////////////
//
//	OK Label update function
//
////////////////////////////////////////////////////////////////////////////////
void akFileDialog::setHelpLabel(string label)
{
	if (label.size() > 0)
	  {
	   XmString xmstr = XmStringCreateLocalized((char *)label.c_str());
	   XtVaSetValues(_w,XmNhelpLabelString,xmstr,NULL);
	   XmStringFree(xmstr);
	  }
}
////////////////////////////////////////////////////////////////////////////////
//
//	Dialog button pressed callback
//
////////////////////////////////////////////////////////////////////////////////
void akFileDialog::actionCB(Widget,XtPointer clientData,XtPointer callData)
{
	akFileDialog		*obj = (akFileDialog *)clientData;
	XmFileSelectionBoxCallbackStruct *cbs =
		(XmFileSelectionBoxCallbackStruct *)callData;
	akDialogCallback	callback=(akDialogCallback)0;

	switch (cbs->reason)
	  {
	   case XmCR_OK:
	      callback = obj->_CBdata->ok();
	      break;
	   case XmCR_CANCEL:
	      callback = obj->_CBdata->cancel();
	      break;
	   case XmCR_HELP:
	      callback = obj->_CBdata->help();
	      break;
	  };

//	Call required callback

	if (callback)
	  (*callback)(obj->_CBdata->clientData(),callData);
}
