#include <sys/types.h>
#include <signal.h>
#include <stdio.h>
#include <unistd.h>
#include "akApp.h"
#include "akProcess.h"
////////////////////////////////////////////////////////////////////////////////
//
//	Constructor
//
////////////////////////////////////////////////////////////////////////////////
akProcess::akProcess()
	:_active(false),
	 _pid(0),
	 _outputId(0),
	 _errorId(0)
{
//	Empty
}
////////////////////////////////////////////////////////////////////////////////
//
//	Destructor
//
////////////////////////////////////////////////////////////////////////////////
akProcess::~akProcess()
{
	if (_active)
	  {
	   if (_outputId)
	     XtRemoveInput(_outputId);
	   if (_errorId)
	     XtRemoveInput(_errorId);
	   if (_inputStream)
	     _inputStream.close();
	   if (_outputStream)
	     _outputStream.close();
	   if (_errorStream)
	     _errorStream.close();

	   _active = false;
	   if (_pid > 0)
	     if (kill(_pid,0) != -1)
	       kill(_pid,SIGKILL);
	   _pid    = 0;
	  }
}
////////////////////////////////////////////////////////////////////////////////
//
//	Start function - fork the process and connect the pipes
//
////////////////////////////////////////////////////////////////////////////////
bool	akProcess::start(string command,akProcessCB callback,XtPointer clientData)
{
	int	process_cin[2];
	int	process_cout[2];
	int	process_cerr[2];
	int	input_fd;
	int	output_fd;
	int	error_fd;
	int	pid;

//	Check if process still active - return false if so

	if (_active)
	  return false;

//	Store users callbacks

	_userCB   = callback;
	_userData = clientData;

//	Open monitor-streams and Xt file descriptor monitor function

	_inputStream.open("/dev/null");
	_outputStream.open("/dev/null");
	_errorStream.open("/dev/null");
	input_fd  = _inputStream.rdbuf()->fd();
	output_fd = _outputStream.rdbuf()->fd();
	error_fd  = _errorStream.rdbuf()->fd();

	_outputId =
	  XtAppAddInput(theAkApp->appContext(),output_fd,
			(XtPointer)XtInputReadMask,
			&akProcess::receiveOutputCB,(XtPointer)this);
	_errorId =
	  XtAppAddInput(theAkApp->appContext(),error_fd,
			(XtPointer)XtInputReadMask,
			&akProcess::receiveOutputCB,(XtPointer)this);

//	Set up three pipes

	pipe(process_cin);
	pipe(process_cout);
	pipe(process_cerr);

//	Fork the process

	signal(SIGCHLD,SIG_IGN);
	if (pid=fork(),pid == 0)	// In child process
	  {

	   // Parse the command into its filename and arguments

	   string	file;
	   string	arg;
	   char		**args;
	   int		pos,pos1,pos2;
	   int		nargs;

	   pos = command.find(" ");
	   file.insert(0,command,0,pos);

	   // Count no of args and allocate storage
	   pos1 = -1;
	   nargs = 0;
	   while ((pos2=command.find(" ",pos1+1)) > 0)
	     {
	      pos1 = pos2;
	      nargs++;
	     }
	   if (pos1 != command.size()-1);
	     nargs++;
	   args = new char*[nargs+1];

	   // Set up args in storage
	   pos1 = -1;
	   nargs = 0;
	   while ((pos2=command.find(" ",pos1+1)) > 0)
	     {
	      arg.remove();
	      arg.insert(0,command,pos1+1,pos2-pos1-1);
	      args[nargs] = new char[arg.size()+1];
	      strcpy(args[nargs],arg.c_str());
	      pos1 = pos2;
	      nargs++;
	     }
	   if (pos1 != command.size()-1);
	     {
	      arg.remove();
	      arg.insert(0,command,pos1+1,command.size()-pos1);
	      args[nargs] = new char[arg.size()+1];
	      strcpy(args[nargs],arg.c_str());
	      nargs++;
	     }
	   args[nargs] = (char *)0;

	   close(0);
	   dup(process_cin[0]);
	   close(1);
	   dup(process_cout[1]);
	   close(2);
	   dup(process_cerr[1]);

	   close(process_cin[0]);
	   close(process_cin[1]);
	   close(process_cout[0]);
	   close(process_cout[1]);
	   close(process_cerr[0]);
	   close(process_cerr[1]);

	   execvp(file.c_str(),args);

	   // Free off args
	   for (int i=0;i<nargs;i++)
	     delete args[i];
	   delete []args;

	   _exit(255);
	  }
	else if (pid > 0)		// In parent process
	  {
	   _pid    = pid;
	   _active = true;

	   close(input_fd);
	   dup(process_cin[1]);
	   close(output_fd);
	   dup(process_cout[0]);
	   close(error_fd);
	   dup(process_cerr[0]);

	   _inputStream.setbuf((char *)0,0);
	   _outputStream.setbuf((char *)0,0);
	   _errorStream.setbuf((char *)0,0);

	   close(process_cin[0]);
	   close(process_cin[1]);
	   close(process_cout[0]);
	   close(process_cout[1]);
	   close(process_cerr[0]);
	   close(process_cerr[1]);

	   return true;
	  }
	else
	  {
	   return false;
	  }
}
////////////////////////////////////////////////////////////////////////////////
//
//	Stop function - kill the process and close the pipes
//
////////////////////////////////////////////////////////////////////////////////
bool	akProcess::stop()
{
	if (!_active)
	  return true;
	else
	  {
	   if (_outputId)
	     XtRemoveInput(_outputId);
	   if (_errorId)
	     XtRemoveInput(_errorId);
	   _outputId = 0;
	   _errorId  = 0;
	   if (_inputStream)
	     _inputStream.close();
	   if (_outputStream)
	     _outputStream.close();
	   if (_errorStream)
	     _errorStream.close();

	   if (_pid > 0)
	     if (kill(_pid,0) != -1)
	       kill(_pid,SIGKILL);
	   _pid = 0;
	   _active = false;

	   return true;
	  }
}
////////////////////////////////////////////////////////////////////////////////
//
//	Receive Output function
//
////////////////////////////////////////////////////////////////////////////////
void	akProcess::receiveOutputCB(XtPointer clientData,int *fd,XtInputId *id)
{
	akProcess *obj = (akProcess *)clientData;
	char	buf[BUFSIZ];	// BUFSIZ from stdio.h
	int	nbuf;
	string	output="";
	bool	moreData;

//	Read all bytes

	moreData = true;
	while (moreData)
	  {
	   nbuf = read(*fd,buf,BUFSIZ);
	   output.insert(output.size(),buf,nbuf);
	   if (nbuf < BUFSIZ)
	     moreData = false;
	  }

//	If 0 bytes check if process still exists, disconnect if not

	if (output.empty())
	  {
	   if (obj->_pid > 0)
	     {
	      if (kill(obj->_pid,0) == -1)
		{
		 obj->_pid = 0;
		 obj->_inputStream.close();
		 obj->_outputStream.close();
		 if (obj->_outputId)
		   XtRemoveInput(obj->_outputId);
		 if (obj->_errorId)
		   XtRemoveInput(obj->_errorId);
		 obj->_outputId = 0;
		 obj->_errorId  = 0;
		 obj->_active = false;
		}
	     }
	  }

//	Pass data to users callback

	if (obj->_userCB)
	  obj->_userCB(obj->_userData,output);
}
