#include <Xm/Xm.h>
#include <Xm/Form.h>
#include <Xm/Label.h>
#include <Xm/TextF.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <stdarg.h>
#include <iostream.h>

#include "akPrompt.h"
////////////////////////////////////////////////////////////////////////////////
//
//	Constructor function for the akPrompt object.
//
////////////////////////////////////////////////////////////////////////////////
akPrompt::akPrompt(Widget parent,char *name,string prompt)
	: akComponent(name),
	  _field((Widget)0),
	  _label((Widget)0)
{
//	Create a form to attach prompt to

	_w = XmCreateForm(parent,_name,NULL,0);
	installDestroyHandler();

//	Attach a label containing variable name (if not NULL)

	if (prompt.size() > 0)
	  _label =
		XtVaCreateManagedWidget(prompt.c_str(),
					xmLabelWidgetClass,
					_w,
					XmNtopAttachment,XmATTACH_FORM,
					XmNleftAttachment,XmATTACH_FORM,
					XmNbottomAttachment,XmATTACH_FORM,
					XmNalignment,XmALIGNMENT_END,
					NULL);

//	Attach the data entry prompt field

	_field =
		XtVaCreateManagedWidget("Prompt",
					xmTextFieldWidgetClass,
					_w,
					XmNtopAttachment,XmATTACH_FORM,
					XmNrightAttachment,XmATTACH_FORM,
					XmNbottomAttachment,XmATTACH_FORM,
					XmNmarginHeight,3,
					XmNmarginWidth,3,
					NULL);

//	Attach the prompt at the left

	if (_label != (Widget)0)
	  XtVaSetValues(_field,
			XmNleftAttachment,XmATTACH_WIDGET,
			XmNleftWidget,_label,
			NULL);
	else
	  XtVaSetValues(_field,XmNleftAttachment,XmATTACH_FORM,NULL);

//	Add the data entry callbacks
//	LIMITATION NOTE - if user doesn't want callback route, the internal
//			  callbacks are still called anyway.

	// Enter Pressed callback

	XtAddCallback(_field,
		      XmNactivateCallback,
		      &akPrompt::promptCB,
		      (XtPointer)this);

// Lost Focus callback
//	XtAddCallback(_field,
//		      XmNlosingFocusCallback,
//		      &akPrompt::promptCB,
//		      (XtPointer)this);
}
////////////////////////////////////////////////////////////////////////////////
//
//	Destructor
//
////////////////////////////////////////////////////////////////////////////////
akPrompt::~akPrompt(void)
{
	if (_field != (Widget)0)
	  {
	   XtRemoveCallback(_field,
			    XmNactivateCallback,
			    &akPrompt::promptCB,
			    (XtPointer)this);
//	   XtRemoveCallback(_field,
//			    XmNlosingFocusCallback,
//			    &akPrompt::promptCB,
//			    (XtPointer)this);
	  }
}
////////////////////////////////////////////////////////////////////////////////
//
//	data changed callback
//
////////////////////////////////////////////////////////////////////////////////
void	akPrompt::promptCB(Widget,XtPointer clientData,XtPointer)
{
	akPrompt 	*obj = (akPrompt *)clientData;
	string		field_string;
	char		*tempstr;

//	Retrieve field string - and copy so that new/delete used

	tempstr = XmTextFieldGetString(obj->_field);
	if (tempstr)
	  field_string = tempstr;
	XtFree(tempstr);

//	Call derived classes callback function

	obj->changeCB(field_string);
}
////////////////////////////////////////////////////////////////////////////////
//
//	Prompt 'clear'ing function
//
////////////////////////////////////////////////////////////////////////////////
void	akPrompt::clear()
{
	XmTextFieldSetString(_field,"");
}
////////////////////////////////////////////////////////////////////////////////
//
//	Prompt update function
//
////////////////////////////////////////////////////////////////////////////////
void	akPrompt::setPrompt(string prompt)
{
	if (!_label)
	  return;

	XmString	tempstr;
	if (prompt.empty())
	  {
	   tempstr = XmStringCreateLocalized("");
	   XtVaSetValues(_label,XmNlabelString,tempstr,0);
	  }
	else
	  {
	   tempstr = XmStringCreateLocalized((char *)prompt.c_str());
	   XtVaSetValues(_label,XmNlabelString,tempstr,0);
	  }
	XmStringFree(tempstr);
}
