////////////////////////////////////////////////////////////////////////////////
//
//	Class : akPromptPassword
//
//	Author : Andy Jefferson
//
//	Description :
//		The akPromptPassword class provides a data entry prompt
//		for a character string value. It creates a widget
//		consisting of an optional variable name label, together
//		with the actual data entry field. The user can retrieve
//		the value from the class via the function "value", or
//		use a callback hook to receive updates when changes are
//		made. The class differs from the akPromptString class by the
//		fact that all entered characters are replaced by *'s.
//
//	Public Methods :
//		(Constructor) requires :-
//			parent		Parent widget of component
//			name		Name used in resources
//			prompt		Prompt label
//			callback	Callback called when enter pressed
//			clientData	Data passed to callback
//		value()			Returns the string in the text field
//		setValue()		Set the field string.
//
//	Limitations :
//
////////////////////////////////////////////////////////////////////////////////
#ifndef _akPromptPassword_h
#define _akPromptPassword_h
#ifdef __cplusplus

#include <std/string.h>
#include <Xm/Xm.h>
#include "akPromptString.h"

typedef void (*akPromptPasswordCB) (XtPointer clientData,string value);

class akPromptPassword : public akPromptString
{
	public:

		// Constructor

		akPromptPassword(Widget parent,
				  char *name,
				  string variable_name,
				  akPromptPasswordCB callback=0,
				  XtPointer clientData=0);
		virtual ~akPromptPassword(void);

		// Class name

		virtual const char *const className(void)
			{return ("akPromptPassword");}

		// Access functions

		virtual	string	value(void);
		virtual	void	setValue(string new_value);

	private:

		string		_savedValue;
		static	void	checkPasswordCB(Widget,XtPointer,XtPointer);

		// The user is responsible for deleting the string

		virtual	void	changeCB(string field_string);
};
#endif

#endif
